/*
 * Copyright 2021 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 */

#ifndef SOC_DEFAULT_BASE_ADDR_H
#define SOC_DEFAULT_BASE_ADDR_H

/* CCSR mmu_def.h */
#define NXP_CCSR_ADDR			0x01000000
#define NXP_CCSR_SIZE			0x0F000000

#define NXP_DCSR_ADDR			0x20000000
#define NXP_DCSR_SIZE			0x4000000

/* Flex-SPI controller address */
#define NXP_FLEXSPI_ADDR		0x020C0000
/* QSPI Flash Start address */
#define NXP_QSPI_FLASH_ADDR		0x40000000
/* NOR Flash Start address */
#define NXP_IFC_REGION_ADDR		0x60000000
#define NXP_NOR_FLASH_ADDR		NXP_IFC_REGION_ADDR

/* MMU 500 soc.c*/
#define NXP_SMMU_ADDR			0x09000000

#define NXP_SNVS_ADDR			0x01E90000

#define NXP_DCFG_ADDR			0x01EE0000
#define NXP_SFP_ADDR			0x01E80000
#define NXP_RCPM_ADDR			0x01EE2000
#define NXP_CSU_ADDR			0x01510000
#define NXP_IFC_ADDR			0x01530000
#define NXP_SCFG_ADDR			0x01570000
#define NXP_DCSR_ADDR			0x20000000
#define NXP_DCSR_DCFG_ADDR		(NXP_DCSR_ADDR + 0x00140000)
#define NXP_I2C_ADDR			0x02180000
#define NXP_ESDHC_ADDR			0x01560000
#define NXP_UART_ADDR			0x021C0500
#define NXP_UART1_ADDR			0x021C0600

#define NXP_GPIO1_ADDR			0x02300000
#define NXP_GPIO2_ADDR			0x02310000
#define NXP_GPIO3_ADDR			0x02320000
#define NXP_GPIO4_ADDR			0x02330000

#define NXP_WDOG1_NS_ADDR		0x02390000
#define NXP_WDOG2_NS_ADDR		0x023A0000
#define NXP_WDOG1_TZ_ADDR		0x023B0000
#define NXP_WDOG2_TZ_ADDR		0x023C0000

#define NXP_TIMER_STATUS_ADDR		0x023F0000

#define NXP_GICD_4K_ADDR		0x01401000
#define NXP_GICC_4K_ADDR		0x01402000
#define NXP_GICD_64K_ADDR		0x01410000
#define NXP_GICC_64K_ADDR		0x01420000

#define NXP_CAAM_ADDR			0x01700000

#define NXP_TZC_ADDR			0x01500000
#define NXP_DDR_ADDR			0x01080000

#define NXP_TIMER_ADDR			0x02B00000
#define NXP_CCI_ADDR			0x01180000
#define NXP_RESET_ADDR			0x01E60000
#define NXP_SEC_REGFILE_ADDR		0x01E88000
#endif	/*	SOC_DEFAULT_BASE_ADDR_H		*/
