---
title: Install Canoeboot on HP Elite 8200 SFF/MT and 6200 Pro Business
x-toc-enable: true
...

**[PLEASE READ THESE INSTRUCTIONS BEFORE INSTALLING](ivy_has_common.md), OR
YOU MAY BRICK YOUR MACHINE!! - Please click the link and follow the instructions
there, before flashing. For posterity,
[here is the link again](ivy_has_common.md).**

<div class="specs">
<center>
<img tabindex=1 alt="HP Compaq 8200 Elite SFF" class="p" src="https://av.canoeboot.org/hp8200sff/grub_open.jpg" /><span class="f"><img src="https://av.canoeboot.org/hp8200sff/grub_open.jpg" /></span> <img tabindex=1 title="From left to right: SFF and MT" class="p" src="https://av.canoeboot.org/hp8200sff/sff+mt.jpg" /><span class="f"><img src="https://av.canoeboot.org/hp8200sff/sff+mt.jpg" /></span>
</center>

| ***Specifications***      |                                             |
|---------------------------|---------------------------------------------|
| **Manufacturer**          | HP                                          |
| **Name**                  | Compaq 8200 Elite SFF                       |
|                           | Compaq 8200 Elite MT                        |
| **Released**              | 2011                                        |
| **Chipset**               | Intel Q67                                   |
| **CPU**                   | Intel Sandy/Ivy Bridge                      |
| **Graphics**              | Intel HD Graphics or PCI-e low profile card |
| **Memory**                | Up to 32GB (4x8GB)                          |
| **Architecture**          | x86\_64                                      |
| **Intel ME/AMD PSP**      | Present, neutered                           |
| **Flash chip**            | SOIC-8 8MiB                                 |

```
W+: Works without vendor firmware; 
N: Doesn't work; 
W*: Works with vendor firmware; 
U: Untested; 
P+: Partially works; 
P*: Partially works with vendor firmware
```

| ***Features***                                    |    |
|---------------------------------------------------|----|
| **Internal flashing with original boot firmware** | N  |
| **Display (Intel GPU)**                           | W+ |
| **Display (PCIe graphics card)**                  | W+ |
| **Audio**                                         | W+ |
| **RAM Init**                                      | W+ |

| ***Payloads supported***  |       |
|---------------------------|-------|
| **GRUB**                  | Works |
| **SeaBIOS**               | Works |
| **SeaBIOS with GRUB**     | Works |
</div>

Open source BIOS/UEFI firmware
------------------------------

This document will teach you how to install Canoeboot, on your
HP Elite 8200 SFF desktop motherboard.
Canoeboot is a [Free Software](https://writefreesoftware.org/learn) project
that replaces proprietary BIOS/UEFI firmware.

Canoeboot has support for this, in the Git repository and release versions
from 20230423 onwards.

### Brief board info

HP Elite 8200 SFF is a small-form-factor desktop of Intel Sandybridge platform
which you can read more about here:

<https://support.hp.com/gb-en/product/hp-compaq-8200-elite-small-form-factor-pc/5037931>

MT is an identical board with a larger chassis and more powerful power supply:

<https://support.hp.com/gb-en/product/hp-compaq-8200-elite-desktop-pc-series/5037940>

Here's the [Technical Reference Manual](https://web.archive.org/web/20160109143257/https://h10032.www1.hp.com/ctg/Manual/c02778024.pdf).
This system supports Ivy Bridge processors too. The original BIOS
won't even POST with those, but with Canoeboot they work fully.

Disable security before flashing
--------------------------------

Before internal flashing, you must first disable `/dev/mem` protections. Make
sure to re-enable them after you're finished.

See: [Disabling /dev/mem protection](../install/devmem.md)

Install Canoeboot
-------------------------

You can actually just compile the Canoeboot ROM for this, and flash the
entire ROM.

Internal flashing from OEM BIOS is possible by setting a jumper
on the board. Step by step instructions for this are below.

The *coreboot* project proper has technical details on why this works if
you are interested. It also has external flashing instructions if you need
to recover from an unbootable BIOS:

<https://doc.coreboot.org/mainboard/hp/compaq_8200_sff.html>

You can build the images for it in Canoeboot like so:

	./mk -b coreboot hp8200sff_8mb

More information about building ROM images can be found in
the [build guide](../build/).

If you plan on using a graphics card (other than the integrated graphics of
your CPU), choose one of the files which name contains both "seabios" and
"txtmode".

If you are using the *Canoeboot* ROM images, the ME image is not provided
and Canoeboot won't provide it. You avoid a brick by flashing *around* the
existing Intel ME, to avoid a brick. Please read the guide:

[How to avoid overwriting Intel ME](../install/ivy_has_common.md)

You may also wish to change the *default MAC address* if you're planning to
use the onboard Intel Gigabit Ethernet. You can do this using the information
in the same guide linked above, or read the nvmutil manual:

[Modify MAC addresses with nvmutil](../install/nvmutil.md).

Internal flashing from vendor BIOS
----------------------------------

You can only install with external flashing, when migrating to Canoeboot.
Internally flashing *Libreboot* is possible, from vendor firmware, but that
is because Libreboot downloads and inserts all required files including Intel
ME, required in this case since you have to shrink the ME region for that
method, and Canoeboot cannot (as per its [policy](../../news/policy.md) include
any such files, even indirectly. In Canoeboot, we always flash around what's
already there, which means that the full Intel ME is retained (and then disabled
during early boot, by modifying the IFD so as to set the HAP bit).

If you have Libreboot, please know as always that the IFD region must not
be overwritten. Overwriting the GbE and BIOS regions is OK.

Do not, under any circumstance, overwrite the ME region.

HP 6200 Pro Business PC
-----------------------

According to this page from the vendor, HP BIOS updates are the same on both
the 8200 SFF Elite *and* 6200 Pro Business desktop PCs; therefore, we believe
that the Canoeboot config for 8200 SFF will *also* work on 6200 Pro Business
PCs. That page is here:
<https://support.hp.com/fi-fi/drivers/selfservice/swdetails/hp-compaq-8200-elite-small-form-factor-pc/5037931/swItemId/vc-229778-2>

The config for this board is courtesy of *Riku Viitanen* (`Riku_V` on Canoeboot
IRC), who tested and confirmed the following functionality:

* Sandy Bridge (i5-2400) and Ivy Bridge (i5-3570S) CPUs
* 4x8 GB RAM (Sandy Bridge: 1333MHz, Ivy Bridge: 1600MHz)
* PS/2 keyboard and mouse
* USB keyboard (a bit laggy on GRUB)
* Boot from USB and DVD
* Gigabit ethernet
* VGA and DisplayPort (Intel graphics), with libgfxinit (native video init)
* Headphone output, PC speaker
* S3 suspend, wake on USB keyboard
* lm\_sensors outputs CPU core temperatures only
* Both PCIe x16 slots, external GPU works with SeaBIOS
* PCI
* SATA
* USB ports
* Serial port (RS-232)
* Wake on LAN

At the time of adding this board to Canoeboot, the following is untested:

* Parallel port (internal header on the board)
* Floppy drive. The case has a spot for it, but I can't find the header (P10).

According to the initial coreboot port from 2018, the following also works:

* EHCI debug (not enabled by Canoeboot configs)
* Native (libre) raminit with up to four DIMM modules (also tested by Riku and
  confirmed working, with 32GB RAM installed as 4x8GB)

TPM
---

According to git logs, TPM should work, and a commit from 2018 at revision
ID `39d0e2a2cf45e28cdddd0fe0c88f94ce527ab1ef` in coreboot makes the TPM visible
to operating systems.

PSU Fan control
---------------

See coreboot commit `9bd601584350f51f112b15a7369f9aa82f1d0919` - labelled
by commit message `superio/nuvoton/npcd378: Add PSU fan control`.

Per this commit, SuperIO-based fan control is supported on HP Elite 8200 SFF.

TODO for testing the above is here:\
<https://codeberg.org/canoeboot/cbmk/issues/9>

This is controlled via `nvramtool` to modify the value in sram. See:

* `psu_fan_lvl=3` <-- default setting in coreboot, and Canoeboot.

Other values possible: from reading the source code, it is implied that the
number can be between 0 and 7. If the value is set higher than 7, it will
default back to 3.

Canoeboot locks CMOS/NVRAM settings, but you can change the default setting in
the *ROM* by using the `-C` option in nvramtool. You can find this under the
directory `src/coreboot/default/util/nvramtool` when downloading coreboot inside
of cbmk by running the command:

	./mk -f coreboot default

Go in there and type `make` to build nvramtool. Simply run nvramtool without
arguments, and it will show a list of options.
