/* SPDX-License-Identifier: GPL-2.0-only */

#include <device/azalia_device.h>

const u32 cim_verb_data[] = {
	0x10ec0257, // Vendor/Device ID: Realtek ALC257
	0x17aa225a, // Subsystem ID
	18,
	AZALIA_SUBVENDOR(0, 0x17aa225a),

	AZALIA_PIN_CFG(0, 0x12, AZALIA_PIN_DESC(
		AZALIA_INTEGRATED,
		AZALIA_INTERNAL,
		AZALIA_MIC_IN,
		AZALIA_OTHER_DIGITAL,
		AZALIA_COLOR_UNKNOWN,
		AZALIA_NO_JACK_PRESENCE_DETECT,
		2, 0
	)),
	AZALIA_PIN_CFG(0, 0x13, 0x40000000), // does not describe a jack or internal device
	AZALIA_PIN_CFG(0, 0x14, AZALIA_PIN_DESC(
		AZALIA_INTEGRATED,
		AZALIA_INTERNAL,
		AZALIA_SPEAKER,
		AZALIA_OTHER_ANALOG,
		AZALIA_COLOR_UNKNOWN,
		AZALIA_NO_JACK_PRESENCE_DETECT,
		1, 0
	)),
	AZALIA_PIN_CFG(0, 0x18, AZALIA_PIN_CFG_NC(0)),
	AZALIA_PIN_CFG(0, 0x19, AZALIA_PIN_DESC(
		AZALIA_JACK,
		AZALIA_EXTERNAL_PRIMARY_CHASSIS | AZALIA_RIGHT,
		AZALIA_MIC_IN,
		AZALIA_STEREO_MONO_1_8,
		AZALIA_BLACK,
		AZALIA_JACK_PRESENCE_DETECT,
		3, 0
	)),
	AZALIA_PIN_CFG(0, 0x1a, AZALIA_PIN_CFG_NC(0)),
	AZALIA_PIN_CFG(0, 0x1b, AZALIA_PIN_CFG_NC(0)),
	AZALIA_PIN_CFG(0, 0x1d, 0x40661b45), // does not describe a jack or internal device
	AZALIA_PIN_CFG(0, 0x1e, AZALIA_PIN_CFG_NC(0)),
	AZALIA_PIN_CFG(0, 0x21, AZALIA_PIN_DESC(
		AZALIA_JACK,
		AZALIA_EXTERNAL_PRIMARY_CHASSIS | AZALIA_RIGHT,
		AZALIA_HP_OUT,
		AZALIA_STEREO_MONO_1_8,
		AZALIA_BLACK,
		AZALIA_JACK_PRESENCE_DETECT,
		1, 15
	)),

	//==========Widget node 0x20 - 0 :Hidden register SW reset
	0x0205001A,
	0x0204C003,
	0x0205001A,
	0x0204C003,
	0x05850000,
	0x0584F880,
	0x05850000,
	0x0584F880,
	//==========Widget node 0x20 - 1 : ClassD 2W
	0x02050038,
	0x02048981,
	0x0205001B,
	0x02040A4B,
	//==========Widget node 0x20 - 2
	0x0205003C,
	0x02043154,
	0x0205003C,
	0x02043114,
	//==========Widget node 0x20 - 3 :
	0x02050046,
	0x02040004,
	0x05750003,
	0x057409A3,
	//==========Widget node 0x20 - 4 :JD1 enable 1JD port for HP JD
	0x02050009,
	0x02046003,
	0x0205000A,
	0x02047770,
	//==========Widget node 0x20 - 5 : Silence data mode Threshold (-84dB)
	0x02050037,
	0x0204FE15,
	0x02050030,
	0x02049004,

	0x8086280b, // Vendor/Device ID: Intel Kabylake HDMI
	0x80860101, // Subsystem ID
	4,
	AZALIA_SUBVENDOR(2, 0x80860101),

	AZALIA_PIN_CFG(2, 0x05, AZALIA_PIN_DESC(
		AZALIA_JACK,
		AZALIA_DIGITAL_DISPLAY,
		AZALIA_DIGITAL_OTHER_OUT,
		AZALIA_OTHER_DIGITAL,
		AZALIA_COLOR_UNKNOWN,
		AZALIA_JACK_PRESENCE_DETECT,
		1, 0
	)),
	AZALIA_PIN_CFG(2, 0x06, AZALIA_PIN_DESC(
		AZALIA_JACK,
		AZALIA_DIGITAL_DISPLAY,
		AZALIA_DIGITAL_OTHER_OUT,
		AZALIA_OTHER_DIGITAL,
		AZALIA_COLOR_UNKNOWN,
		AZALIA_JACK_PRESENCE_DETECT,
		1, 0
	)),
	AZALIA_PIN_CFG(2, 0x07, AZALIA_PIN_DESC(
		AZALIA_JACK,
		AZALIA_DIGITAL_DISPLAY,
		AZALIA_DIGITAL_OTHER_OUT,
		AZALIA_OTHER_DIGITAL,
		AZALIA_COLOR_UNKNOWN,
		AZALIA_JACK_PRESENCE_DETECT,
		1, 0
	)),
};

const u32 pc_beep_verbs[] = {};
AZALIA_ARRAY_SIZES;
