---
title: SAFELY flash Canoeboot on Intel IvyBridge, SandyBridge and Haswell mainboards
x-toc-enable: true
...

These words pertain to Intel Ivybridge, Sandybridge and Haswell systems that
are supported by Canoeboot. Those systems are possible to support in Canoeboot,
with only Free Software, but you have to flash it in specific regions of the
flash, while avoiding others, in order to prevent a soft-brick scenario.

**If migrating from Libreboot to Canoeboot on DELL systems, please
also read [GbE safety](dell_gbe.md).**

Open source BIOS/UEFI firmware
------------------------------

Canoeboot is a [Free Software](https://writefreesoftware.org/learn) project
that replaces proprietary BIOS/UEFI firmware, but some newer boards still
occasionally need code from the hardware manufacturer in order to boot properly.
Canoeboot is a *fully free* coreboot distro, which means that it will not
distribute these files; however, supporting these machines is still possible,
by avoiding overwriting the versions of these files that are already present.
For example, you can avoid overwriting the original Intel ME, while still
disabling Intel ME after early bringup by setting the HAP bit in the Intel
Flash Descriptor.

This is similar conceptually to when you, say, flash OpenWRT on a router, but
you have to avoid overwriting the vendor bootloader which is non-free. OpenWRT
is free software, but has to be flashed around certain vendor code. It's really
the same sort of thing here, from the user's point of view.

This design differs from Libreboot, in that *Libreboot* builds *complete*
ROM images, including all of these files when possible, which means downloading
them at build time and inserting them, or inserting them after-the-fact on
release images (because release images exclude them), using the same scripts.

Therefore, Canoeboot's installation method can be a bit more finnicky, but it
is done this way precisely because Canoeboot *only* provides free software.

It is an interesting design difference, and can create some very interesting
results. This article will teach you how to manage everything.
for it. For more context, please read Canoeboot's [Binary Blob Extermination
Policy](../../news/policy.md).

**PLEASE MAKE SURE you read and follow the instructions on this page, prior
to flashing Canoeboot, if required for your motherboard; failure to heed this
warning can and will result in a soft-brick, which would then necessitate
recovery via [external flashing](spi.md) - regardless, you are advised to
also read the external flashing guide just in caes, and have an external
flasher handy in case you need it.**

**WARNING: If you DO overwrite something that Canoeboot doesn't distribute,
such as Intel ME, you're pretty much stuck unless either 1) You made a full
dump of the flash first, as a backup and/or 2) You use a Libreboot image for
recovery instead, and then migrate back to Canoeboot. YOU HAVE BEEN WARNED.**

**This way of doing things is very hazardous unless you know what you're doing,
and it's how Libreboot previously handled these newer boards. Be careful.**

Two-chip IFD systems
--------------------

On systems with two flash chips, e.g. 8MB and 4MB (4MB being SPI2 and 8MB
being SPI1), where an IFD is used, Canoeboot uses a CBFS region size equivalent
to the capacity of the second chip.

For example, if the second IC was 4MB, then CBFS would be 4MB. This enables
easier external flashing, while avoiding overwriting the wrong regions; then
you can externally flash the second chip, only flashing the IFD and GBE
regions specifically (if desirable).

Install build dependencies first
------------------------------------

**You will be compiling several small utilities from source code. This means
you need the compilers and various libraries.**

**Please make sure to install [build dependencies](../build/)** before using this
guide, and note that this guide assumes you use [cbmk.git](../../git.md).

Introduction
------------

### BIOS region size vs Libreboot

On systems with IFD, Canoeboot uses the default, smaller BIOS region size,
instead of enlarging it. This size differs per platform. This means that
Canoeboot's IFD sets a larger ME region size and smaller BIOS region size.

This is because Canoeboot avoids distributing Intel ME, instead telling you
to avoid overwriting what's already present fram the factory; instead, you
only  flash the BIOS region.

Canoeboot therefore must be flashed carefully; if migrating from Libreboot,
you can just flash the BIOS region. This is true because Canoeboot has the
smaller BIOS region, so you'd just be flashing an image with smaller CBFS
size which would be compatible.

The reverse is not true; migrating from Canoeboot to Libreboot would just be
done by re-flashing the entire chip. However, this guide only covers migrating
to Canoeboot, from either Libreboot or the vendor firmware.

### MAC address

Regardless of whether your board uses vendorfiles or not, you can also use
this command to change the MAC address on systems with Intel GbE regions in
the flash, where an Intel gigabit ethernet device is used.

For example, a Lenovo ThinkPad X200 doesn't need such files in ROM, but can still
have the mac address changed; please continue reading!

### Flash by region, not the whole chip!

If you have a system with the intel Flash Descriptor, you can do first:

```
flashprog -p PROGRAMMER --ifd -i bios -w canoeboot.rom
```

This will flash *just* the BIOS region. If you're migrating from Libreboot,
this is all you should do. You can optionally re-flash the GbE section,
but please read [GbE Safety](dell_gbe.md) first. Like so:

```
flashprog -p PROGRAMMER --ifd -i gbe -w canoeboot.rom
```

**WARNING: Dell systems use a larger 16KB GbE region on Canoeboot, versus 8KB
on Libreboot. Doing the above `-i gbe` command for Canoeboot will brick your
system, if migrating from Libreboot, because it would overwrite the first 8KB
of your Intel ME.**

You can optionally re-flash the Intel IFD:

```
flashprog -p PROGRAMMER --ifd -i fd -w canoeboot.rom
```

**WARNING: DO NOT do this if migrating from Libreboot. Only do it if migrating
from factory firmware. This is because Libreboot shrinks the Intel ME region
and enlarges the BIOS region, modifying the IFD accordingly. Therefore, doing
this in a LB-to-Canoe context would result in an enlarged ME region, possibly
containing junk that would then brick the ME at boot time, resulting in your
machine not booting properly. Canoeboot and Libreboot both modify the IFD to
set the flash read-write and to disable the ME after early bringup, so you
really just need to flash the BIOS region.**

**WARNING: Older versions of nvmutil used `?` for random characters. Newer
versions use `x` instead. If you have an older version, use `?` instead,
when generating random characters in MAC addresses.**
