/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ext.javatime.ser;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonToken;
import tools.jackson.core.type.WritableTypeId;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ext.javatime.ser.JSR310FormattedSerializerBase;
import tools.jackson.databind.jsontype.TypeSerializer;

public class OffsetTimeSerializer
extends JSR310FormattedSerializerBase<OffsetTime> {
    public static final OffsetTimeSerializer INSTANCE = new OffsetTimeSerializer();

    protected OffsetTimeSerializer() {
        super(OffsetTime.class);
    }

    protected OffsetTimeSerializer(OffsetTimeSerializer base, DateTimeFormatter dtf, Boolean useTimestamp) {
        this(base, dtf, useTimestamp, null);
    }

    protected OffsetTimeSerializer(OffsetTimeSerializer base, DateTimeFormatter dtf, Boolean useTimestamp, Boolean useNanoseconds) {
        super(base, dtf, useTimestamp, useNanoseconds, null);
    }

    protected OffsetTimeSerializer withFormat(DateTimeFormatter dtf, Boolean useTimestamp, JsonFormat.Shape shape) {
        return new OffsetTimeSerializer(this, dtf, useTimestamp);
    }

    @Override
    public void serialize(OffsetTime time, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        if (this.useTimestamp(ctxt)) {
            g.writeStartArray();
            this._serializeAsArrayContents(time, g, ctxt);
            g.writeEndArray();
        } else {
            String str = this._formatter == null ? time.toString() : time.format(this._formatter);
            g.writeString(str);
        }
    }

    @Override
    public void serializeWithType(OffsetTime value, JsonGenerator g, SerializationContext ctxt, TypeSerializer typeSer) throws JacksonException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, ctxt, typeSer.typeId(value, this.serializationShape(ctxt)));
        if (typeIdDef != null && typeIdDef.valueShape == JsonToken.START_ARRAY) {
            this._serializeAsArrayContents(value, g, ctxt);
        } else {
            String str = this._formatter == null ? value.toString() : value.format(this._formatter);
            g.writeString(str);
        }
        typeSer.writeTypeSuffix(g, ctxt, typeIdDef);
    }

    private final void _serializeAsArrayContents(OffsetTime value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        g.writeNumber(value.getHour());
        g.writeNumber(value.getMinute());
        int secs = value.getSecond();
        int nanos = value.getNano();
        if (secs > 0 || nanos > 0) {
            g.writeNumber(secs);
            if (nanos > 0) {
                if (this.useNanoseconds(ctxt)) {
                    g.writeNumber(nanos);
                } else {
                    g.writeNumber(value.get(ChronoField.MILLI_OF_SECOND));
                }
            }
        }
        g.writeString(value.getOffset().toString());
    }

    @Override
    protected JsonToken serializationShape(SerializationContext ctxt) {
        return this.useTimestamp(ctxt) ? JsonToken.START_ARRAY : JsonToken.VALUE_STRING;
    }

    @Override
    protected JSR310FormattedSerializerBase<?> withFeatures(Boolean writeZoneId, Boolean writeNanoseconds) {
        return new OffsetTimeSerializer(this, this._formatter, this._useTimestamp, writeNanoseconds);
    }
}

