/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility;

import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.Utility;

public class InclusionCounts {
    private static final Logger LOGGER = Logger.getLogger(InclusionCounts.class.getName());
    private final String name;
    private int count;
    private int includedCount;

    public InclusionCounts(String name) {
        this.name = Utility.requireNotBlank(name, "No name provided");
        this.count = 0;
        this.includedCount = 0;
    }

    public void count() {
        ++this.count;
    }

    public void countIfIncluded(boolean included) {
        if (included) {
            ++this.includedCount;
        }
    }

    public void countIncluded() {
        ++this.includedCount;
    }

    public int getCount() {
        return this.count;
    }

    public int getIncludedCount() {
        return this.includedCount;
    }

    public String getName() {
        return this.name;
    }

    public void log() {
        Level level = Level.INFO;
        if (LOGGER.isLoggable(level)) {
            LOGGER.log(level, "Processed %d/%d %s".formatted(this.includedCount, this.count, this.name));
        }
    }

    public String toString() {
        return "%d/%d %s".formatted(this.includedCount, this.count, this.name);
    }
}

