/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn.matchers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Keyboard {
    private final String name;
    private final Map<Character, List<String>> adjacencyGraph;
    private final boolean slanted;
    private final int startingPositions;
    private final double averageDegree;

    Keyboard(String name, AdjacentGraphBuilder adjacentGraphBuilder) {
        this.name = name;
        this.adjacencyGraph = adjacentGraphBuilder.build();
        this.slanted = adjacentGraphBuilder.isSlanted();
        this.startingPositions = this.adjacencyGraph.size();
        this.averageDegree = Keyboard.calcAverageDegree(this.adjacencyGraph);
    }

    private static double calcAverageDegree(Map<Character, List<String>> adjacencyGraph) {
        double average = 0.0;
        for (Map.Entry<Character, List<String>> graphRef : adjacencyGraph.entrySet()) {
            List<String> neighbors = graphRef.getValue();
            ArrayList<String> results = new ArrayList<String>();
            for (String neighbor : neighbors) {
                if (neighbor == null) continue;
                results.add(neighbor);
            }
            average += (double)results.size();
        }
        ArrayList<Character> keys = new ArrayList<Character>();
        for (Map.Entry<Character, List<String>> graphRef : adjacencyGraph.entrySet()) {
            keys.add(graphRef.getKey());
        }
        return average /= (double)keys.size();
    }

    public String getName() {
        return this.name;
    }

    public Map<Character, List<String>> getAdjacencyGraph() {
        return this.adjacencyGraph;
    }

    public boolean isSlanted() {
        return this.slanted;
    }

    public int getStartingPositions() {
        return this.startingPositions;
    }

    public double getAverageDegree() {
        return this.averageDegree;
    }

    public static abstract class AdjacentGraphBuilder {
        private static final SplitMatcher WHITESPACE_SPLIT_MATCHER = new SplitMatcher(){

            @Override
            public boolean match(char c) {
                return Character.isWhitespace(c);
            }
        };
        private static final SplitMatcher NEW_LINE_SPLIT_MATCHER = new SplitMatcher(){

            @Override
            public boolean match(char c) {
                return c == '\n';
            }
        };
        private final String layout;

        protected AdjacentGraphBuilder(String layout) {
            this.layout = layout;
        }

        public Map<Character, List<String>> build() {
            Map<Position, String> positionTable = this.buildPositionTable(this.layout);
            HashMap<Character, List<String>> adjacencyGraph = new HashMap<Character, List<String>>();
            for (Map.Entry<Position, String> entry : positionTable.entrySet()) {
                for (char key : entry.getValue().toCharArray()) {
                    ArrayList<String> adjacencies = new ArrayList<String>();
                    Position position = entry.getKey();
                    for (Position coord : this.getAdjacentCoords(position)) {
                        adjacencies.add(positionTable.get(coord));
                    }
                    adjacencyGraph.put(Character.valueOf(key), adjacencies);
                }
            }
            return adjacencyGraph;
        }

        private Map<Position, String> buildPositionTable(String layout) {
            HashMap<Position, String> positionTable = new HashMap<Position, String>();
            List<String> tokens = AdjacentGraphBuilder.split(layout, WHITESPACE_SPLIT_MATCHER);
            int tokenSize = tokens.get(0).length();
            int xUnit = tokenSize + 1;
            for (String token : tokens) {
                assert (token.length() == tokenSize) : String.format("token [%s] length mismatch:%n%s", token, layout);
            }
            int y = 1;
            for (String line : AdjacentGraphBuilder.split(layout, NEW_LINE_SPLIT_MATCHER)) {
                int slant = this.calcSlant(y);
                for (String token : AdjacentGraphBuilder.split(line, WHITESPACE_SPLIT_MATCHER)) {
                    int index = line.indexOf(token) - slant;
                    int x = index / xUnit;
                    int remainder = index % xUnit;
                    assert (remainder == 0) : String.format("unexpected x offset [%d] for %s in:%n%s", x, token, layout);
                    positionTable.put(Position.of(x, y), token);
                }
                ++y;
            }
            return positionTable;
        }

        protected abstract List<Position> getAdjacentCoords(Position var1);

        private static List<String> split(String str, SplitMatcher splitMatcher) {
            int len = str.length();
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            int start = 0;
            boolean match = false;
            while (i < len) {
                if (splitMatcher.match(str.charAt(i))) {
                    if (match) {
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                match = true;
                ++i;
            }
            if (match) {
                list.add(str.substring(start, i));
            }
            return list;
        }

        protected abstract int calcSlant(int var1);

        public abstract boolean isSlanted();

        static class Position {
            private final int x;
            private final int y;

            private Position(int x, int y) {
                this.x = x;
                this.y = y;
            }

            public static Position of(int x, int y) {
                return new Position(x, y);
            }

            public int getX() {
                return this.x;
            }

            public int getY() {
                return this.y;
            }

            public int hashCode() {
                int result = this.x;
                result = 31 * result + this.y;
                return result;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof Position)) {
                    return false;
                }
                Position position = (Position)o;
                return this.x == position.x && this.y == position.y;
            }

            public String toString() {
                return "[" + this.x + "," + this.y + ']';
            }
        }

        private static interface SplitMatcher {
            public boolean match(char var1);
        }
    }
}

