(function() {
    var type_impls = Object.fromEntries([["kernel",[["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BinaryReader-for-Box%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/debugfs/traits.rs.html#289-297\">Source</a><a href=\"#impl-BinaryReader-for-Box%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a> + <a class=\"trait\" href=\"kernel/debugfs/trait.BinaryReader.html\" title=\"trait kernel::debugfs::BinaryReader\">BinaryReader</a>, A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>&gt; <a class=\"trait\" href=\"kernel/debugfs/trait.BinaryReader.html\" title=\"trait kernel::debugfs::BinaryReader\">BinaryReader</a> for <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.read_from_slice\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/debugfs/traits.rs.html#290-296\">Source</a><a href=\"#method.read_from_slice\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"kernel/debugfs/trait.BinaryReader.html#tymethod.read_from_slice\" class=\"fn\">read_from_slice</a>(\n    &amp;self,\n    reader: &amp;mut <a class=\"struct\" href=\"kernel/uaccess/struct.UserSliceReader.html\" title=\"struct kernel::uaccess::UserSliceReader\">UserSliceReader</a>,\n    offset: &amp;mut <a class=\"type\" href=\"kernel/fs/file/type.Offset.html\" title=\"type kernel::fs::file::Offset\">Offset</a>,\n) -&gt; <a class=\"type\" href=\"kernel/error/type.Result.html\" title=\"type kernel::error::Result\">Result</a>&lt;<a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>&gt;</h4></section></summary><div class='docblock'>Reads the binary form of <code>self</code> from <code>reader</code>. <a href=\"kernel/debugfs/trait.BinaryReader.html#tymethod.read_from_slice\">Read more</a></div></details></div></details>","BinaryReader","kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BinaryReaderMut-for-Box%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/debugfs/traits.rs.html#224-232\">Source</a><a href=\"#impl-BinaryReaderMut-for-Box%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a> + <a class=\"trait\" href=\"kernel/debugfs/trait.BinaryReaderMut.html\" title=\"trait kernel::debugfs::BinaryReaderMut\">BinaryReaderMut</a>, A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>&gt; <a class=\"trait\" href=\"kernel/debugfs/trait.BinaryReaderMut.html\" title=\"trait kernel::debugfs::BinaryReaderMut\">BinaryReaderMut</a> for <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.read_from_slice_mut\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/debugfs/traits.rs.html#225-231\">Source</a><a href=\"#method.read_from_slice_mut\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"kernel/debugfs/trait.BinaryReaderMut.html#tymethod.read_from_slice_mut\" class=\"fn\">read_from_slice_mut</a>(\n    &amp;mut self,\n    reader: &amp;mut <a class=\"struct\" href=\"kernel/uaccess/struct.UserSliceReader.html\" title=\"struct kernel::uaccess::UserSliceReader\">UserSliceReader</a>,\n    offset: &amp;mut <a class=\"type\" href=\"kernel/fs/file/type.Offset.html\" title=\"type kernel::fs::file::Offset\">Offset</a>,\n) -&gt; <a class=\"type\" href=\"kernel/error/type.Result.html\" title=\"type kernel::error::Result\">Result</a>&lt;<a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>&gt;</h4></section></summary><div class='docblock'>Reads the binary form of <code>self</code> from <code>reader</code>. <a href=\"kernel/debugfs/trait.BinaryReaderMut.html#tymethod.read_from_slice_mut\">Read more</a></div></details></div></details>","BinaryReaderMut","kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BinaryWriter-for-Box%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/debugfs/traits.rs.html#83-95\">Source</a><a href=\"#impl-BinaryWriter-for-Box%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"kernel/debugfs/trait.BinaryWriter.html\" title=\"trait kernel::debugfs::BinaryWriter\">BinaryWriter</a> for <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"kernel/debugfs/trait.BinaryWriter.html\" title=\"trait kernel::debugfs::BinaryWriter\">BinaryWriter</a>,\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.write_to_slice\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/debugfs/traits.rs.html#88-94\">Source</a><a href=\"#method.write_to_slice\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"kernel/debugfs/trait.BinaryWriter.html#tymethod.write_to_slice\" class=\"fn\">write_to_slice</a>(\n    &amp;self,\n    writer: &amp;mut <a class=\"struct\" href=\"kernel/uaccess/struct.UserSliceWriter.html\" title=\"struct kernel::uaccess::UserSliceWriter\">UserSliceWriter</a>,\n    offset: &amp;mut <a class=\"type\" href=\"kernel/fs/file/type.Offset.html\" title=\"type kernel::fs::file::Offset\">Offset</a>,\n) -&gt; <a class=\"type\" href=\"kernel/error/type.Result.html\" title=\"type kernel::error::Result\">Result</a>&lt;<a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>&gt;</h4></section></summary><div class='docblock'>Writes the binary form of <code>self</code> into <code>writer</code>. <a href=\"kernel/debugfs/trait.BinaryWriter.html#tymethod.write_to_slice\">Read more</a></div></details></div></details>","BinaryWriter","kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Borrow%3CT%3E-for-Box%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#609-617\">Source</a><a href=\"#impl-Borrow%3CT%3E-for-Box%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"core/borrow/trait.Borrow.html\" title=\"trait core::borrow::Borrow\">Borrow</a>&lt;T&gt; for <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;<div class=\"where\">where\n    T: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3><div class=\"docblock\"><h4 id=\"examples\"><a class=\"doc-anchor\" href=\"#examples\">§</a>Examples</h4>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">struct </span>Foo&lt;B: Borrow&lt;u32&gt;&gt;(B);\n\n<span class=\"comment\">// Owned instance.\n</span><span class=\"kw\">let </span>owned = Foo(<span class=\"number\">1</span>);\n\n<span class=\"comment\">// Owned instance using `KBox`.\n</span><span class=\"kw\">let </span>owned_kbox = Foo(KBox::new(<span class=\"number\">1</span>, GFP_KERNEL)<span class=\"question-mark\">?</span>);\n\n<span class=\"kw\">let </span>i = <span class=\"number\">1</span>;\n<span class=\"comment\">// Borrowed from `i`.\n</span><span class=\"kw\">let </span>borrowed = Foo(<span class=\"kw-2\">&amp;</span>i);</code></pre></div></div></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.borrow\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#614-616\">Source</a><a href=\"#method.borrow\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/borrow/trait.Borrow.html#tymethod.borrow\" class=\"fn\">borrow</a>(&amp;self) -&gt; <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;T</a></h4></section></summary><div class='docblock'>Immutably borrows from an owned value. <a href=\"core/borrow/trait.Borrow.html#tymethod.borrow\">Read more</a></div></details></div></details>","Borrow<T>","kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BorrowMut%3CT%3E-for-Box%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#637-645\">Source</a><a href=\"#impl-BorrowMut%3CT%3E-for-Box%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"core/borrow/trait.BorrowMut.html\" title=\"trait core::borrow::BorrowMut\">BorrowMut</a>&lt;T&gt; for <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;<div class=\"where\">where\n    T: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3><div class=\"docblock\"><h4 id=\"examples\"><a class=\"doc-anchor\" href=\"#examples\">§</a>Examples</h4>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">struct </span>Foo&lt;B: BorrowMut&lt;u32&gt;&gt;(B);\n\n<span class=\"comment\">// Owned instance.\n</span><span class=\"kw\">let </span>owned = Foo(<span class=\"number\">1</span>);\n\n<span class=\"comment\">// Owned instance using `KBox`.\n</span><span class=\"kw\">let </span>owned_kbox = Foo(KBox::new(<span class=\"number\">1</span>, GFP_KERNEL)<span class=\"question-mark\">?</span>);\n\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>i = <span class=\"number\">1</span>;\n<span class=\"comment\">// Borrowed from `i`.\n</span><span class=\"kw\">let </span>borrowed = Foo(<span class=\"kw-2\">&amp;mut </span>i);</code></pre></div></div></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.borrow_mut\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#642-644\">Source</a><a href=\"#method.borrow_mut\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/borrow/trait.BorrowMut.html#tymethod.borrow_mut\" class=\"fn\">borrow_mut</a>(&amp;mut self) -&gt; <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;mut T</a></h4></section></summary><div class='docblock'>Mutably borrows from an owned value. <a href=\"core/borrow/trait.BorrowMut.html#tymethod.borrow_mut\">Read more</a></div></details></div></details>","BorrowMut<T>","kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Box%3CMaybeUninit%3CT%3E,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#218-246\">Source</a><a href=\"#impl-Box%3CMaybeUninit%3CT%3E,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;<a class=\"union\" href=\"core/mem/maybe_uninit/union.MaybeUninit.html\" title=\"union core::mem::maybe_uninit::MaybeUninit\">MaybeUninit</a>&lt;T&gt;, A&gt;<div class=\"where\">where\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.assume_init\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#230-237\">Source</a><h4 class=\"code-header\">pub unsafe fn <a href=\"#method.assume_init\" class=\"fn\">assume_init</a>(self) -&gt; <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;</h4></section></summary><div class=\"docblock\"><p>Converts a <code>Box&lt;MaybeUninit&lt;T&gt;, A&gt;</code> to a <code>Box&lt;T, A&gt;</code>.</p>\n<p>It is undefined behavior to call this function while the value inside of <code>b</code> is not yet\nfully initialized.</p>\n<h5 id=\"safety\"><a class=\"doc-anchor\" href=\"#safety\">§</a>Safety</h5>\n<p>Callers must ensure that the value inside of <code>b</code> is in an initialized state.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.write\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#240-245\">Source</a><h4 class=\"code-header\">pub fn <a href=\"#method.write\" class=\"fn\">write</a>(self, value: T) -&gt; <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;</h4></section></summary><div class=\"docblock\"><p>Writes the value and converts to <code>Box&lt;T, A&gt;</code>.</p>\n</div></details></div></details>",0,"kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Box%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#164-216\">Source</a><a href=\"#impl-Box%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;<div class=\"where\">where\n    T: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_raw\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#179-183\">Source</a><h4 class=\"code-header\">pub const unsafe fn <a href=\"#method.from_raw\" class=\"fn\">from_raw</a>(raw: <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a>) -&gt; Self</h4></section></summary><div class=\"docblock\"><p>Creates a new <code>Box&lt;T, A&gt;</code> from a raw pointer.</p>\n<h5 id=\"safety\"><a class=\"doc-anchor\" href=\"#safety\">§</a>Safety</h5>\n<p>For non-ZSTs, <code>raw</code> must point at an allocation allocated with <code>A</code> that is sufficiently\naligned for and holds a valid <code>T</code>. The caller passes ownership of the allocation to the\n<code>Box</code>.</p>\n<p>For ZSTs, <code>raw</code> must be a dangling, well aligned pointer.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.into_raw\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#203-205\">Source</a><h4 class=\"code-header\">pub fn <a href=\"#method.into_raw\" class=\"fn\">into_raw</a>(b: Self) -&gt; <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a></h4></section></summary><div class=\"docblock\"><p>Consumes the <code>Box&lt;T, A&gt;</code> and returns a raw pointer.</p>\n<p>This will not run the destructor of <code>T</code> and for non-ZSTs the allocation will stay alive\nindefinitely. Use <a href=\"kernel/alloc/kbox/struct.Box.html#method.from_raw\" title=\"associated function kernel::alloc::kbox::Box::from_raw\"><code>Box::from_raw</code></a> to recover the <a href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\"><code>Box</code></a>, drop the value and free the\nallocation, if any.</p>\n<h5 id=\"examples\"><a class=\"doc-anchor\" href=\"#examples\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x = KBox::new(<span class=\"number\">24</span>, GFP_KERNEL)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>ptr = KBox::into_raw(x);\n<span class=\"comment\">// SAFETY: `ptr` comes from a previous call to `KBox::into_raw`.\n</span><span class=\"kw\">let </span>x = <span class=\"kw\">unsafe </span>{ KBox::from_raw(ptr) };\n\n<span class=\"macro\">assert_eq!</span>(<span class=\"kw-2\">*</span>x, <span class=\"number\">24</span>);</code></pre></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.leak\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#211-215\">Source</a><h4 class=\"code-header\">pub fn <a href=\"#method.leak\" class=\"fn\">leak</a>&lt;'a&gt;(b: Self) -&gt; <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;'a mut T</a></h4></section></summary><div class=\"docblock\"><p>Consumes and leaks the <code>Box&lt;T, A&gt;</code> and returns a mutable reference.</p>\n<p>See <a href=\"kernel/alloc/kbox/struct.Box.html#method.into_raw\" title=\"associated function kernel::alloc::kbox::Box::into_raw\"><code>Box::into_raw</code></a> for more details.</p>\n</div></details></div></details>",0,"kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Box%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#248-415\">Source</a><a href=\"#impl-Box%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;<div class=\"where\">where\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.new\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#256-259\">Source</a><h4 class=\"code-header\">pub fn <a href=\"#method.new\" class=\"fn\">new</a>(x: T, flags: <a class=\"struct\" href=\"kernel/alloc/struct.Flags.html\" title=\"struct kernel::alloc::Flags\">Flags</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;Self, <a class=\"struct\" href=\"kernel/alloc/struct.AllocError.html\" title=\"struct kernel::alloc::AllocError\">AllocError</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Creates a new <code>Box&lt;T, A&gt;</code> and initializes its contents with <code>x</code>.</p>\n<p>New memory is allocated with <code>A</code>. The allocation may fail, in which case an error is\nreturned. For ZSTs no memory is allocated.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.new_uninit\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#275-282\">Source</a><h4 class=\"code-header\">pub fn <a href=\"#method.new_uninit\" class=\"fn\">new_uninit</a>(flags: <a class=\"struct\" href=\"kernel/alloc/struct.Flags.html\" title=\"struct kernel::alloc::Flags\">Flags</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;<a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;<a class=\"union\" href=\"core/mem/maybe_uninit/union.MaybeUninit.html\" title=\"union core::mem::maybe_uninit::MaybeUninit\">MaybeUninit</a>&lt;T&gt;, A&gt;, <a class=\"struct\" href=\"kernel/alloc/struct.AllocError.html\" title=\"struct kernel::alloc::AllocError\">AllocError</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Creates a new <code>Box&lt;T, A&gt;</code> with uninitialized contents.</p>\n<p>New memory is allocated with <code>A</code>. The allocation may fail, in which case an error is\nreturned. For ZSTs no memory is allocated.</p>\n<h5 id=\"examples\"><a class=\"doc-anchor\" href=\"#examples\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>b = KBox::&lt;u64&gt;::new_uninit(GFP_KERNEL)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>b = KBox::write(b, <span class=\"number\">24</span>);\n\n<span class=\"macro\">assert_eq!</span>(<span class=\"kw-2\">*</span>b, <span class=\"number\">24_u64</span>);</code></pre></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.pin\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#287-292\">Source</a><h4 class=\"code-header\">pub fn <a href=\"#method.pin\" class=\"fn\">pin</a>(x: T, flags: <a class=\"struct\" href=\"kernel/alloc/struct.Flags.html\" title=\"struct kernel::alloc::Flags\">Flags</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;<a class=\"struct\" href=\"core/pin/struct.Pin.html\" title=\"struct core::pin::Pin\">Pin</a>&lt;<a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;&gt;, <a class=\"struct\" href=\"kernel/alloc/struct.AllocError.html\" title=\"struct kernel::alloc::AllocError\">AllocError</a>&gt;<div class=\"where\">where\n    A: 'static,</div></h4></section></summary><div class=\"docblock\"><p>Constructs a new <code>Pin&lt;Box&lt;T, A&gt;&gt;</code>. If <code>T</code> does not implement <a href=\"core/marker/trait.Unpin.html\" title=\"trait core::marker::Unpin\"><code>Unpin</code></a>, then <code>x</code> will be\npinned in memory and can’t be moved.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.pin_slice\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#336-369\">Source</a><h4 class=\"code-header\">pub fn <a href=\"#method.pin_slice\" class=\"fn\">pin_slice</a>&lt;Func, Item, E&gt;(\n    init: Func,\n    len: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>,\n    flags: <a class=\"struct\" href=\"kernel/alloc/struct.Flags.html\" title=\"struct kernel::alloc::Flags\">Flags</a>,\n) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;<a class=\"struct\" href=\"core/pin/struct.Pin.html\" title=\"struct core::pin::Pin\">Pin</a>&lt;<a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;<a class=\"primitive\" href=\"core/primitive.slice.html\">[T]</a>, A&gt;&gt;, E&gt;<div class=\"where\">where\n    Func: <a class=\"trait\" href=\"core/ops/function/trait.FnMut.html\" title=\"trait core::ops::function::FnMut\">FnMut</a>(<a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>) -&gt; Item,\n    Item: <a class=\"trait\" href=\"kernel/prelude/trait.PinInit.html\" title=\"trait kernel::prelude::PinInit\">PinInit</a>&lt;T, E&gt;,\n    E: <a class=\"trait\" href=\"core/convert/trait.From.html\" title=\"trait core::convert::From\">From</a>&lt;<a class=\"struct\" href=\"kernel/alloc/struct.AllocError.html\" title=\"struct kernel::alloc::AllocError\">AllocError</a>&gt;,</div></h4></section></summary><div class=\"docblock\"><p>Construct a pinned slice of elements <code>Pin&lt;Box&lt;[T], A&gt;&gt;</code>.</p>\n<p>This is a convenient means for creation of e.g. slices of structrures containing spinlocks\nor mutexes.</p>\n<h5 id=\"examples-1\"><a class=\"doc-anchor\" href=\"#examples-1\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">use </span>kernel::sync::{new_spinlock, SpinLock};\n\n<span class=\"kw\">struct </span>Inner {\n    a: u32,\n    b: u32,\n}\n\n<span class=\"attr\">#[pin_data]\n</span><span class=\"kw\">struct </span>Example {\n    c: u32,\n    <span class=\"attr\">#[pin]\n    </span>d: SpinLock&lt;Inner&gt;,\n}\n\n<span class=\"kw\">impl </span>Example {\n    <span class=\"kw\">fn </span>new() -&gt; <span class=\"kw\">impl </span>PinInit&lt;<span class=\"self\">Self</span>, Error&gt; {\n        <span class=\"macro\">try_pin_init!</span>(<span class=\"self\">Self </span>{\n            c: <span class=\"number\">10</span>,\n            d &lt;- <span class=\"macro\">new_spinlock!</span>(Inner { a: <span class=\"number\">20</span>, b: <span class=\"number\">30 </span>}),\n        })\n    }\n}\n\n<span class=\"comment\">// Allocate a boxed slice of 10 `Example`s.\n</span><span class=\"kw\">let </span>s = KBox::pin_slice(\n    | _i | Example::new(),\n    <span class=\"number\">10</span>,\n    GFP_KERNEL\n)<span class=\"question-mark\">?</span>;\n\n<span class=\"macro\">assert_eq!</span>(s[<span class=\"number\">5</span>].c, <span class=\"number\">10</span>);\n<span class=\"macro\">assert_eq!</span>(s[<span class=\"number\">3</span>].d.lock().a, <span class=\"number\">20</span>);</code></pre></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.into_pin\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#373-375\">Source</a><h4 class=\"code-header\">pub fn <a href=\"#method.into_pin\" class=\"fn\">into_pin</a>(this: Self) -&gt; <a class=\"struct\" href=\"core/pin/struct.Pin.html\" title=\"struct core::pin::Pin\">Pin</a>&lt;Self&gt;</h4></section></summary><div class=\"docblock\"><p>Convert a <a href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\"><code>Box&lt;T,A&gt;</code></a> to a <a href=\"core/pin/struct.Pin.html\" title=\"struct core::pin::Pin\"><code>Pin&lt;Box&lt;T,A&gt;&gt;</code></a>. If <code>T</code> does not implement\n<a href=\"core/marker/trait.Unpin.html\" title=\"trait core::marker::Unpin\"><code>Unpin</code></a>, then <code>x</code> will be pinned in memory and can’t be moved.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.drop_contents\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#398-406\">Source</a><h4 class=\"code-header\">pub fn <a href=\"#method.drop_contents\" class=\"fn\">drop_contents</a>(this: Self) -&gt; <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;<a class=\"union\" href=\"core/mem/maybe_uninit/union.MaybeUninit.html\" title=\"union core::mem::maybe_uninit::MaybeUninit\">MaybeUninit</a>&lt;T&gt;, A&gt;</h4></section></summary><div class=\"docblock\"><p>Drops the contents, but keeps the allocation.</p>\n<h5 id=\"examples-2\"><a class=\"doc-anchor\" href=\"#examples-2\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>value = KBox::new([<span class=\"number\">0</span>; <span class=\"number\">32</span>], GFP_KERNEL)<span class=\"question-mark\">?</span>;\n<span class=\"macro\">assert_eq!</span>(<span class=\"kw-2\">*</span>value, [<span class=\"number\">0</span>; <span class=\"number\">32</span>]);\n<span class=\"kw\">let </span>value = KBox::drop_contents(value);\n<span class=\"comment\">// Now we can re-use `value`:\n</span><span class=\"kw\">let </span>value = KBox::write(value, [<span class=\"number\">1</span>; <span class=\"number\">32</span>]);\n<span class=\"macro\">assert_eq!</span>(<span class=\"kw-2\">*</span>value, [<span class=\"number\">1</span>; <span class=\"number\">32</span>]);</code></pre></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.into_inner\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#409-414\">Source</a><h4 class=\"code-header\">pub fn <a href=\"#method.into_inner\" class=\"fn\">into_inner</a>(b: Self) -&gt; T</h4></section></summary><div class=\"docblock\"><p>Moves the <code>Box</code>’s value out of the <code>Box</code> and consumes the <code>Box</code>.</p>\n</div></details></div></details>",0,"kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Debug-for-Box%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#657-665\">Source</a><a href=\"#impl-Debug-for-Box%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"kernel/fmt/trait.Debug.html\" title=\"trait kernel::fmt::Debug\">Debug</a> for <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;<div class=\"where\">where\n    T: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a> + <a class=\"trait\" href=\"kernel/fmt/trait.Debug.html\" title=\"trait kernel::fmt::Debug\">Debug</a>,\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.fmt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#662-664\">Source</a><a href=\"#method.fmt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"kernel/fmt/trait.Debug.html#tymethod.fmt\" class=\"fn\">fmt</a>(&amp;self, f: &amp;mut <a class=\"struct\" href=\"kernel/fmt/struct.Formatter.html\" title=\"struct kernel::fmt::Formatter\">Formatter</a>&lt;'_&gt;) -&gt; <a class=\"type\" href=\"kernel/fmt/type.Result.html\" title=\"type kernel::fmt::Result\">Result</a></h4></section></summary><div class='docblock'>Formats the value using the given formatter. <a href=\"kernel/fmt/trait.Debug.html#tymethod.fmt\">Read more</a></div></details></div></details>","Debug","kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Deref-for-Box%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#565-577\">Source</a><a href=\"#impl-Deref-for-Box%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"core/ops/deref/trait.Deref.html\" title=\"trait core::ops::deref::Deref\">Deref</a> for <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;<div class=\"where\">where\n    T: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Target\" class=\"associatedtype trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#570\">Source</a><a href=\"#associatedtype.Target\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/ops/deref/trait.Deref.html#associatedtype.Target\" class=\"associatedtype\">Target</a> = T</h4></section></summary><div class='docblock'>The resulting type after dereferencing.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.deref\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#572-576\">Source</a><a href=\"#method.deref\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/deref/trait.Deref.html#tymethod.deref\" class=\"fn\">deref</a>(&amp;self) -&gt; <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;T</a></h4></section></summary><div class='docblock'>Dereferences the value.</div></details></div></details>","Deref","kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-DerefMut-for-Box%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#579-589\">Source</a><a href=\"#impl-DerefMut-for-Box%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"core/ops/deref/trait.DerefMut.html\" title=\"trait core::ops::deref::DerefMut\">DerefMut</a> for <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;<div class=\"where\">where\n    T: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.deref_mut\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#584-588\">Source</a><a href=\"#method.deref_mut\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/deref/trait.DerefMut.html#tymethod.deref_mut\" class=\"fn\">deref_mut</a>(&amp;mut self) -&gt; <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;mut T</a></h4></section></summary><div class='docblock'>Mutably dereferences the value.</div></details></div></details>","DerefMut","kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Display-for-Box%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#647-655\">Source</a><a href=\"#impl-Display-for-Box%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"kernel/fmt/trait.Display.html\" title=\"trait kernel::fmt::Display\">Display</a> for <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;<div class=\"where\">where\n    T: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a> + <a class=\"trait\" href=\"kernel/fmt/trait.Display.html\" title=\"trait kernel::fmt::Display\">Display</a>,\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.fmt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#652-654\">Source</a><a href=\"#method.fmt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"kernel/fmt/trait.Display.html#tymethod.fmt\" class=\"fn\">fmt</a>(&amp;self, f: &amp;mut <a class=\"struct\" href=\"kernel/fmt/struct.Formatter.html\" title=\"struct kernel::fmt::Formatter\">Formatter</a>&lt;'_&gt;) -&gt; <a class=\"type\" href=\"kernel/fmt/type.Result.html\" title=\"type kernel::fmt::Result\">Result</a></h4></section></summary><div class='docblock'>Same as <a href=\"core/fmt/trait.Display.html#tymethod.fmt\" title=\"method core::fmt::Display::fmt\"><code>core::fmt::Display::fmt</code></a>.</div></details></div></details>","Display","kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Drop-for-Box%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#667-683\">Source</a><a href=\"#impl-Drop-for-Box%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"core/ops/drop/trait.Drop.html\" title=\"trait core::ops::drop::Drop\">Drop</a> for <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;<div class=\"where\">where\n    T: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.drop\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#672-682\">Source</a><a href=\"#method.drop\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/drop/trait.Drop.html#tymethod.drop\" class=\"fn\">drop</a>(&amp;mut self)</h4></section></summary><div class='docblock'>Executes the destructor for this type. <a href=\"core/ops/drop/trait.Drop.html#tymethod.drop\">Read more</a></div></details></div></details>","Drop","kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ForeignOwnable-for-Box%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#483-518\">Source</a><a href=\"#impl-ForeignOwnable-for-Box%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: 'static, A&gt; <a class=\"trait\" href=\"kernel/types/trait.ForeignOwnable.html\" title=\"trait kernel::types::ForeignOwnable\">ForeignOwnable</a> for <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;<div class=\"where\">where\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedconstant.FOREIGN_ALIGN\" class=\"associatedconstant trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#487-491\">Source</a><a href=\"#associatedconstant.FOREIGN_ALIGN\" class=\"anchor\">§</a><h4 class=\"code-header\">const <a href=\"kernel/types/trait.ForeignOwnable.html#associatedconstant.FOREIGN_ALIGN\" class=\"constant\">FOREIGN_ALIGN</a>: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a></h4></section></summary><div class='docblock'>The alignment of pointers returned by <code>into_foreign</code>.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Borrowed\" class=\"associatedtype trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#493\">Source</a><a href=\"#associatedtype.Borrowed\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"kernel/types/trait.ForeignOwnable.html#associatedtype.Borrowed\" class=\"associatedtype\">Borrowed</a>&lt;'a&gt; = <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;'a T</a></h4></section></summary><div class='docblock'>Type used to immutably borrow a value that is currently foreign-owned.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.BorrowedMut\" class=\"associatedtype trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#494\">Source</a><a href=\"#associatedtype.BorrowedMut\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"kernel/types/trait.ForeignOwnable.html#associatedtype.BorrowedMut\" class=\"associatedtype\">BorrowedMut</a>&lt;'a&gt; = <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;'a mut T</a></h4></section></summary><div class='docblock'>Type used to mutably borrow a value that is currently foreign-owned.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.into_foreign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#496-498\">Source</a><a href=\"#method.into_foreign\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"kernel/types/trait.ForeignOwnable.html#tymethod.into_foreign\" class=\"fn\">into_foreign</a>(self) -&gt; <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut </a><a class=\"enum\" href=\"kernel/prelude/enum.c_void.html\" title=\"enum kernel::prelude::c_void\">c_void</a></h4></section></summary><div class='docblock'>Converts a Rust-owned object to a foreign-owned one. <a href=\"kernel/types/trait.ForeignOwnable.html#tymethod.into_foreign\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_foreign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#500-504\">Source</a><a href=\"#method.from_foreign\" class=\"anchor\">§</a><h4 class=\"code-header\">unsafe fn <a href=\"kernel/types/trait.ForeignOwnable.html#tymethod.from_foreign\" class=\"fn\">from_foreign</a>(ptr: <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut </a><a class=\"enum\" href=\"kernel/prelude/enum.c_void.html\" title=\"enum kernel::prelude::c_void\">c_void</a>) -&gt; Self</h4></section></summary><div class='docblock'>Converts a foreign-owned object back to a Rust-owned one. <a href=\"kernel/types/trait.ForeignOwnable.html#tymethod.from_foreign\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.borrow\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#506-510\">Source</a><a href=\"#method.borrow\" class=\"anchor\">§</a><h4 class=\"code-header\">unsafe fn <a href=\"kernel/types/trait.ForeignOwnable.html#tymethod.borrow\" class=\"fn\">borrow</a>&lt;'a&gt;(ptr: <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut </a><a class=\"enum\" href=\"kernel/prelude/enum.c_void.html\" title=\"enum kernel::prelude::c_void\">c_void</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;'a T</a></h4></section></summary><div class='docblock'>Borrows a foreign-owned object immutably. <a href=\"kernel/types/trait.ForeignOwnable.html#tymethod.borrow\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.borrow_mut\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#512-517\">Source</a><a href=\"#method.borrow_mut\" class=\"anchor\">§</a><h4 class=\"code-header\">unsafe fn <a href=\"kernel/types/trait.ForeignOwnable.html#tymethod.borrow_mut\" class=\"fn\">borrow_mut</a>&lt;'a&gt;(ptr: <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut </a><a class=\"enum\" href=\"kernel/prelude/enum.c_void.html\" title=\"enum kernel::prelude::c_void\">c_void</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;'a mut T</a></h4></section></summary><div class='docblock'>Borrows a foreign-owned object mutably. <a href=\"kernel/types/trait.ForeignOwnable.html#tymethod.borrow_mut\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_from_foreign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/types.rs.html#75-83\">Source</a><a href=\"#method.try_from_foreign\" class=\"anchor\">§</a><h4 class=\"code-header\">unsafe fn <a href=\"kernel/types/trait.ForeignOwnable.html#method.try_from_foreign\" class=\"fn\">try_from_foreign</a>(ptr: <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut </a><a class=\"enum\" href=\"kernel/prelude/enum.c_void.html\" title=\"enum kernel::prelude::c_void\">c_void</a>) -&gt; <a class=\"enum\" href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;Self&gt;</h4></section></summary><div class='docblock'>Tries to convert a foreign-owned object back to a Rust-owned one. <a href=\"kernel/types/trait.ForeignOwnable.html#method.try_from_foreign\">Read more</a></div></details></div></details>","ForeignOwnable","kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Handler-for-Box%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/irq/request.rs.html#48-52\">Source</a><a href=\"#impl-Handler-for-Box%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a> + <a class=\"trait\" href=\"kernel/irq/trait.Handler.html\" title=\"trait kernel::irq::Handler\">Handler</a>, A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>&gt; <a class=\"trait\" href=\"kernel/irq/trait.Handler.html\" title=\"trait kernel::irq::Handler\">Handler</a> for <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.handle\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/irq/request.rs.html#49-51\">Source</a><a href=\"#method.handle\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"kernel/irq/trait.Handler.html#tymethod.handle\" class=\"fn\">handle</a>(&amp;self, device: &amp;<a class=\"struct\" href=\"kernel/device/struct.Device.html\" title=\"struct kernel::device::Device\">Device</a>&lt;<a class=\"struct\" href=\"kernel/device/struct.Bound.html\" title=\"struct kernel::device::Bound\">Bound</a>&gt;) -&gt; <a class=\"enum\" href=\"kernel/irq/enum.IrqReturn.html\" title=\"enum kernel::irq::IrqReturn\">IrqReturn</a></h4></section></summary><div class='docblock'>The hard IRQ handler. <a href=\"kernel/irq/trait.Handler.html#tymethod.handle\">Read more</a></div></details></div></details>","Handler","kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-InPlaceInit%3CT%3E-for-Box%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#458-479\">Source</a><a href=\"#impl-InPlaceInit%3CT%3E-for-Box%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"kernel/init/trait.InPlaceInit.html\" title=\"trait kernel::init::InPlaceInit\">InPlaceInit</a>&lt;T&gt; for <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;<div class=\"where\">where\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a> + 'static,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.PinnedSelf\" class=\"associatedtype trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#462\">Source</a><a href=\"#associatedtype.PinnedSelf\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"kernel/init/trait.InPlaceInit.html#associatedtype.PinnedSelf\" class=\"associatedtype\">PinnedSelf</a> = <a class=\"struct\" href=\"core/pin/struct.Pin.html\" title=\"struct core::pin::Pin\">Pin</a>&lt;<a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;&gt;</h4></section></summary><div class='docblock'>Pinned version of <code>Self</code>. <a href=\"kernel/init/trait.InPlaceInit.html#associatedtype.PinnedSelf\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_pin_init\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#465-470\">Source</a><a href=\"#method.try_pin_init\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"kernel/init/trait.InPlaceInit.html#tymethod.try_pin_init\" class=\"fn\">try_pin_init</a>&lt;E&gt;(\n    init: impl <a class=\"trait\" href=\"kernel/prelude/trait.PinInit.html\" title=\"trait kernel::prelude::PinInit\">PinInit</a>&lt;T, E&gt;,\n    flags: <a class=\"struct\" href=\"kernel/alloc/struct.Flags.html\" title=\"struct kernel::alloc::Flags\">Flags</a>,\n) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;<a class=\"struct\" href=\"core/pin/struct.Pin.html\" title=\"struct core::pin::Pin\">Pin</a>&lt;Self&gt;, E&gt;<div class=\"where\">where\n    E: <a class=\"trait\" href=\"core/convert/trait.From.html\" title=\"trait core::convert::From\">From</a>&lt;<a class=\"struct\" href=\"kernel/alloc/struct.AllocError.html\" title=\"struct kernel::alloc::AllocError\">AllocError</a>&gt;,</div></h4></section></summary><div class='docblock'>Use the given pin-initializer to pin-initialize a <code>T</code> inside of a new smart pointer of this\ntype. <a href=\"kernel/init/trait.InPlaceInit.html#tymethod.try_pin_init\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_init\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#473-478\">Source</a><a href=\"#method.try_init\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"kernel/init/trait.InPlaceInit.html#tymethod.try_init\" class=\"fn\">try_init</a>&lt;E&gt;(init: impl <a class=\"trait\" href=\"kernel/prelude/trait.Init.html\" title=\"trait kernel::prelude::Init\">Init</a>&lt;T, E&gt;, flags: <a class=\"struct\" href=\"kernel/alloc/struct.Flags.html\" title=\"struct kernel::alloc::Flags\">Flags</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;Self, E&gt;<div class=\"where\">where\n    E: <a class=\"trait\" href=\"core/convert/trait.From.html\" title=\"trait core::convert::From\">From</a>&lt;<a class=\"struct\" href=\"kernel/alloc/struct.AllocError.html\" title=\"struct kernel::alloc::AllocError\">AllocError</a>&gt;,</div></h4></section></summary><div class='docblock'>Use the given initializer to in-place initialize a <code>T</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.pin_init\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/init.rs.html#154-163\">Source</a><a href=\"#method.pin_init\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"kernel/init/trait.InPlaceInit.html#method.pin_init\" class=\"fn\">pin_init</a>&lt;E&gt;(\n    init: impl <a class=\"trait\" href=\"kernel/prelude/trait.PinInit.html\" title=\"trait kernel::prelude::PinInit\">PinInit</a>&lt;T, E&gt;,\n    flags: <a class=\"struct\" href=\"kernel/alloc/struct.Flags.html\" title=\"struct kernel::alloc::Flags\">Flags</a>,\n) -&gt; <a class=\"type\" href=\"kernel/error/type.Result.html\" title=\"type kernel::error::Result\">Result</a>&lt;Self::<a class=\"associatedtype\" href=\"kernel/init/trait.InPlaceInit.html#associatedtype.PinnedSelf\" title=\"type kernel::init::InPlaceInit::PinnedSelf\">PinnedSelf</a>&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"kernel/error/struct.Error.html\" title=\"struct kernel::error::Error\">Error</a>: <a class=\"trait\" href=\"core/convert/trait.From.html\" title=\"trait core::convert::From\">From</a>&lt;E&gt;,</div></h4></section></summary><div class='docblock'>Use the given pin-initializer to pin-initialize a <code>T</code> inside of a new smart pointer of this\ntype. <a href=\"kernel/init/trait.InPlaceInit.html#method.pin_init\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.init\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/init.rs.html#171-180\">Source</a><a href=\"#method.init\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"kernel/init/trait.InPlaceInit.html#method.init\" class=\"fn\">init</a>&lt;E&gt;(init: impl <a class=\"trait\" href=\"kernel/prelude/trait.Init.html\" title=\"trait kernel::prelude::Init\">Init</a>&lt;T, E&gt;, flags: <a class=\"struct\" href=\"kernel/alloc/struct.Flags.html\" title=\"struct kernel::alloc::Flags\">Flags</a>) -&gt; <a class=\"type\" href=\"kernel/error/type.Result.html\" title=\"type kernel::error::Result\">Result</a>&lt;Self&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"kernel/error/struct.Error.html\" title=\"struct kernel::error::Error\">Error</a>: <a class=\"trait\" href=\"core/convert/trait.From.html\" title=\"trait core::convert::From\">From</a>&lt;E&gt;,</div></h4></section></summary><div class='docblock'>Use the given initializer to in-place initialize a <code>T</code>.</div></details></div></details>","InPlaceInit<T>","kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-InPlaceWrite%3CT%3E-for-Box%3CMaybeUninit%3CT%3E,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#433-456\">Source</a><a href=\"#impl-InPlaceWrite%3CT%3E-for-Box%3CMaybeUninit%3CT%3E,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"kernel/prelude/trait.InPlaceWrite.html\" title=\"trait kernel::prelude::InPlaceWrite\">InPlaceWrite</a>&lt;T&gt; for <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;<a class=\"union\" href=\"core/mem/maybe_uninit/union.MaybeUninit.html\" title=\"union core::mem::maybe_uninit::MaybeUninit\">MaybeUninit</a>&lt;T&gt;, A&gt;<div class=\"where\">where\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a> + 'static,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Initialized\" class=\"associatedtype trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#437\">Source</a><a href=\"#associatedtype.Initialized\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"kernel/prelude/trait.InPlaceWrite.html#associatedtype.Initialized\" class=\"associatedtype\">Initialized</a> = <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;</h4></section></summary><div class='docblock'>The type <code>Self</code> turns into when the contents are initialized.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.write_init\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#439-446\">Source</a><a href=\"#method.write_init\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"kernel/prelude/trait.InPlaceWrite.html#tymethod.write_init\" class=\"fn\">write_init</a>&lt;E&gt;(self, init: impl <a class=\"trait\" href=\"kernel/prelude/trait.Init.html\" title=\"trait kernel::prelude::Init\">Init</a>&lt;T, E&gt;) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;Self::<a class=\"associatedtype\" href=\"kernel/prelude/trait.InPlaceWrite.html#associatedtype.Initialized\" title=\"type kernel::prelude::InPlaceWrite::Initialized\">Initialized</a>, E&gt;</h4></section></summary><div class='docblock'>Use the given initializer to write a value into <code>self</code>. <a href=\"kernel/prelude/trait.InPlaceWrite.html#tymethod.write_init\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.write_pin_init\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#448-455\">Source</a><a href=\"#method.write_pin_init\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"kernel/prelude/trait.InPlaceWrite.html#tymethod.write_pin_init\" class=\"fn\">write_pin_init</a>&lt;E&gt;(\n    self,\n    init: impl <a class=\"trait\" href=\"kernel/prelude/trait.PinInit.html\" title=\"trait kernel::prelude::PinInit\">PinInit</a>&lt;T, E&gt;,\n) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;<a class=\"struct\" href=\"core/pin/struct.Pin.html\" title=\"struct core::pin::Pin\">Pin</a>&lt;Self::<a class=\"associatedtype\" href=\"kernel/prelude/trait.InPlaceWrite.html#associatedtype.Initialized\" title=\"type kernel::prelude::InPlaceWrite::Initialized\">Initialized</a>&gt;, E&gt;</h4></section></summary><div class='docblock'>Use the given pin-initializer to write a value into <code>self</code>. <a href=\"kernel/prelude/trait.InPlaceWrite.html#tymethod.write_pin_init\">Read more</a></div></details></div></details>","InPlaceWrite<T>","kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ThreadedHandler-for-Box%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/irq/request.rs.html#319-327\">Source</a><a href=\"#impl-ThreadedHandler-for-Box%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a> + <a class=\"trait\" href=\"kernel/irq/trait.ThreadedHandler.html\" title=\"trait kernel::irq::ThreadedHandler\">ThreadedHandler</a>, A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>&gt; <a class=\"trait\" href=\"kernel/irq/trait.ThreadedHandler.html\" title=\"trait kernel::irq::ThreadedHandler\">ThreadedHandler</a> for <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.handle\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/irq/request.rs.html#320-322\">Source</a><a href=\"#method.handle\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"kernel/irq/trait.ThreadedHandler.html#method.handle\" class=\"fn\">handle</a>(&amp;self, device: &amp;<a class=\"struct\" href=\"kernel/device/struct.Device.html\" title=\"struct kernel::device::Device\">Device</a>&lt;<a class=\"struct\" href=\"kernel/device/struct.Bound.html\" title=\"struct kernel::device::Bound\">Bound</a>&gt;) -&gt; <a class=\"enum\" href=\"kernel/irq/enum.ThreadedIrqReturn.html\" title=\"enum kernel::irq::ThreadedIrqReturn\">ThreadedIrqReturn</a></h4></section></summary><div class='docblock'>The hard IRQ handler. <a href=\"kernel/irq/trait.ThreadedHandler.html#method.handle\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.handle_threaded\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/irq/request.rs.html#324-326\">Source</a><a href=\"#method.handle_threaded\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"kernel/irq/trait.ThreadedHandler.html#tymethod.handle_threaded\" class=\"fn\">handle_threaded</a>(&amp;self, device: &amp;<a class=\"struct\" href=\"kernel/device/struct.Device.html\" title=\"struct kernel::device::Device\">Device</a>&lt;<a class=\"struct\" href=\"kernel/device/struct.Bound.html\" title=\"struct kernel::device::Bound\">Bound</a>&gt;) -&gt; <a class=\"enum\" href=\"kernel/irq/enum.IrqReturn.html\" title=\"enum kernel::irq::IrqReturn\">IrqReturn</a></h4></section></summary><div class='docblock'>The threaded IRQ handler. <a href=\"kernel/irq/trait.ThreadedHandler.html#tymethod.handle_threaded\">Read more</a></div></details></div></details>","ThreadedHandler","kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<section id=\"impl-CoerceUnsized%3CBox%3C__S,+A%3E%3E-for-Box%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#80\">Source</a><a href=\"#impl-CoerceUnsized%3CBox%3C__S,+A%3E%3E-for-Box%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a> + <a class=\"trait\" href=\"core/marker/trait.Unsize.html\" title=\"trait core::marker::Unsize\">Unsize</a>&lt;__S&gt;, __S: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>, A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>&gt; <a class=\"trait\" href=\"core/ops/unsize/trait.CoerceUnsized.html\" title=\"trait core::ops::unsize::CoerceUnsized\">CoerceUnsized</a>&lt;<a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;__S, A&gt;&gt; for <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;</h3></section>","CoerceUnsized<Box<__S, A>>","kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<section id=\"impl-DispatchFromDyn%3CBox%3C__S,+A%3E%3E-for-Box%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#80\">Source</a><a href=\"#impl-DispatchFromDyn%3CBox%3C__S,+A%3E%3E-for-Box%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a> + <a class=\"trait\" href=\"core/marker/trait.Unsize.html\" title=\"trait core::marker::Unsize\">Unsize</a>&lt;__S&gt;, __S: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>, A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>&gt; <a class=\"trait\" href=\"core/ops/unsize/trait.DispatchFromDyn.html\" title=\"trait core::ops::unsize::DispatchFromDyn\">DispatchFromDyn</a>&lt;<a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;__S, A&gt;&gt; for <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;</h3></section>","DispatchFromDyn<Box<__S, A>>","kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<section id=\"impl-Send-for-Box%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#149-154\">Source</a><a href=\"#impl-Send-for-Box%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"core/marker/trait.Send.html\" title=\"trait core::marker::Send\">Send</a> for <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Send.html\" title=\"trait core::marker::Send\">Send</a> + ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section>","Send","kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<section id=\"impl-Sync-for-Box%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#157-162\">Source</a><a href=\"#impl-Sync-for-Box%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"core/marker/trait.Sync.html\" title=\"trait core::marker::Sync\">Sync</a> for <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Sync.html\" title=\"trait core::marker::Sync\">Sync</a> + ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section>","Sync","kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<section id=\"impl-ZeroableOption-for-Box%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#146\">Source</a><a href=\"#impl-ZeroableOption-for-Box%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>&gt; <a class=\"trait\" href=\"pin_init/trait.ZeroableOption.html\" title=\"trait pin_init::ZeroableOption\">ZeroableOption</a> for <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;</h3></section>","ZeroableOption","kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"]]]]);
    if (window.register_type_impls) {
        window.register_type_impls(type_impls);
    } else {
        window.pending_type_impls = type_impls;
    }
})()
//{"start":55,"fragment_lengths":[66019]}