/*
 * Decompiled with CFR 0.152.
 */
package generic.stl;

import generic.stl.IteratorSTL;
import generic.stl.ListNodeSTL;
import generic.stl.ListSTL;

public class ListIterator<T>
implements IteratorSTL<T> {
    ListSTL<T> list;
    ListNodeSTL<T> root;
    protected ListNodeSTL<T> node;
    public StackTraceElement[] stackUse;

    ListIterator(ListSTL<T> list, ListNodeSTL<T> root, ListNodeSTL<T> node) {
        this.list = list;
        this.root = root;
        this.node = node;
    }

    @Override
    public void assign(IteratorSTL<T> otherIterator) {
        ListIterator other = (ListIterator)otherIterator;
        this.list = other.list;
        this.root = other.root;
        this.node = other.node;
    }

    @Override
    public IteratorSTL<T> copy() {
        return new ListIterator<T>(this.list, this.root, this.node);
    }

    @Override
    public boolean isBegin() {
        return this.node == this.root.next;
    }

    @Override
    public boolean isEnd() {
        return this.node == this.root;
    }

    @Override
    public IteratorSTL<T> decrement() {
        if (this.node.prev == this.root) {
            throw new IndexOutOfBoundsException();
        }
        this.node = this.node.prev;
        return this;
    }

    @Override
    public T get() {
        if (this.node == this.root) {
            throw new IndexOutOfBoundsException();
        }
        return this.node.value;
    }

    @Override
    public IteratorSTL<T> increment() {
        this.node = this.node.next;
        return this;
    }

    @Override
    public IteratorSTL<T> increment(int count) {
        for (int i = 0; i < count; ++i) {
            this.increment();
        }
        return this;
    }

    @Override
    public IteratorSTL<T> decrement(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insert(T value) {
        ListNodeSTL newNode = new ListNodeSTL(this.node.prev, this.node, value);
        this.node.prev.next = newNode;
        this.node.prev = newNode;
        this.node = newNode;
        this.list.adjustSize(1);
    }

    @Override
    public void set(T value) {
        if (this.root == this.node) {
            throw new IndexOutOfBoundsException();
        }
        this.node.value = value;
    }

    protected ListNodeSTL<T> getNode() {
        return this.node;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListIterator)) {
            return false;
        }
        ListIterator other = (ListIterator)obj;
        return this.list == other.list && this.node == other.node;
    }

    public int hashCode() {
        return this.list.hashCode();
    }
}

