/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target.visitors;

import ghidra.trace.database.target.visitors.TreeTraversal;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValPath;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.target.path.KeyPath;
import ghidra.trace.model.target.path.PathFilter;
import ghidra.trace.model.target.path.PathPattern;
import java.util.Set;
import java.util.stream.Stream;

public class OrderedSuccessorsVisitor
implements TreeTraversal.SpanIntersectingVisitor {
    protected final PathFilter filter;
    protected final boolean forward;

    public OrderedSuccessorsVisitor(KeyPath path, boolean forward) {
        this.filter = new PathPattern(path);
        this.forward = forward;
    }

    @Override
    public TraceObjectValPath composePath(TraceObjectValPath pre, TraceObjectValue value) {
        return pre == null ? TraceObjectValPath.of() : pre.append(value);
    }

    @Override
    public TreeTraversal.VisitResult visitValue(TraceObjectValue value, TraceObjectValPath valPath) {
        KeyPath path = valPath.getPath();
        if (this.filter.matches(path)) {
            return TreeTraversal.VisitResult.INCLUDE_PRUNE;
        }
        if (!value.isObject() || !this.filter.successorCouldMatch(path, true)) {
            return TreeTraversal.VisitResult.EXCLUDE_PRUNE;
        }
        return TreeTraversal.VisitResult.EXCLUDE_DESCEND;
    }

    @Override
    public TraceObject continueObject(TraceObjectValue value) {
        return value.isObject() ? value.getChild() : null;
    }

    @Override
    public Stream<? extends TraceObjectValue> continueValues(TraceObject object, Lifespan span, TraceObjectValPath valPath) {
        Set<String> nextKeys = this.filter.getNextKeys(valPath.getPath());
        if (nextKeys.isEmpty()) {
            return Stream.empty();
        }
        if (nextKeys.size() != 1) {
            throw new IllegalArgumentException("predicates must be a singleton");
        }
        String next = nextKeys.iterator().next();
        if (PathPattern.isWildcard(next)) {
            throw new IllegalArgumentException("predicates must be a singleton");
        }
        return object.getOrderedValues(span, next, this.forward);
    }
}

