/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.memory;

import db.DBRecord;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.memory.DBTraceMemoryBufferEntry;
import ghidra.trace.database.memory.DBTraceMemorySpace;
import ghidra.trace.model.Lifespan;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import java.io.IOException;
import java.nio.ByteBuffer;

@DBAnnotatedObjectInfo(version=0)
class DBTraceMemoryBlockEntry
extends DBAnnotatedObject {
    private static final String TABLE_NAME = "MemoryBlocks";
    static final String LOCATION_COLUMN_NAME = "LocationOT";
    static final String BUFFER_COLUMN_NAME = "Buffer";
    static final String BLOCK_COLUMN_NAME = "Block";
    @DBAnnotatedColumn(value="LocationOT")
    static DBObjectColumn LOCATION_COLUMN;
    @DBAnnotatedColumn(value="Buffer")
    static DBObjectColumn BUFFER_COLUMN;
    @DBAnnotatedColumn(value="Block")
    static DBObjectColumn BLOCK_COLUMN;
    @DBAnnotatedField(column="LocationOT", indexed=true, codec=DBTraceUtils.OffsetThenSnapDBFieldCodec.class)
    private DBTraceUtils.OffsetSnap location;
    @DBAnnotatedField(column="Buffer")
    private long bufferKey = -1L;
    @DBAnnotatedField(column="Block")
    private byte blockNum = (byte)-1;
    private final DBTraceMemorySpace space;

    static String tableName(AddressSpace space) {
        return DBTraceUtils.tableName(TABLE_NAME, space);
    }

    public DBTraceMemoryBlockEntry(DBTraceMemorySpace space, DBCachedObjectStore<?> store, DBRecord record) {
        super(store, record);
        this.space = space;
    }

    public void setLoc(DBTraceUtils.OffsetSnap location) {
        this.location = location;
        this.update(LOCATION_COLUMN);
    }

    public long getOffset() {
        return this.location.offset;
    }

    public long getSnap() {
        return this.location.snap;
    }

    public boolean isScratch() {
        return Lifespan.isScratch(this.location.snap);
    }

    private int getBlockNumber() {
        return Byte.toUnsignedInt(this.blockNum);
    }

    public DBTraceMemoryBlockEntry copy(DBTraceUtils.OffsetSnap loc) throws IOException {
        assert (loc.offset == this.location.offset);
        assert (loc.snap > this.location.snap);
        DBTraceMemoryBlockEntry cp = (DBTraceMemoryBlockEntry)this.space.blockStore.create();
        cp.setLoc(loc);
        this.space.blockCacheMostRecent.clear();
        this.space.blockCacheMostRecent.put(loc, cp);
        DBTraceMemoryBufferEntry myBuf = this.findAssignedBuffer();
        if (myBuf == null) {
            return cp;
        }
        DBTraceMemoryBufferEntry cpBuf = cp.findFreeBuffer(myBuf);
        if (cpBuf == null && (cpBuf = cp.findFreeBufferInFuture()) == null) {
            cpBuf = cp.allocateNewBuffer();
        }
        cpBuf.copyFrom(cp.getBlockNumber(), myBuf, this.getBlockNumber());
        return cp;
    }

    protected DBTraceMemoryBufferEntry allocateNewBuffer() {
        DBTraceMemoryBufferEntry bufEnt = (DBTraceMemoryBufferEntry)this.space.bufferStore.create();
        this.bufferKey = bufEnt.getKey();
        bufEnt.acquireBlock(0);
        this.blockNum = 0;
        this.update(BUFFER_COLUMN, BLOCK_COLUMN);
        return bufEnt;
    }

    protected DBTraceMemoryBufferEntry findFreeBuffer(DBTraceMemoryBufferEntry bufEnt) {
        if (bufEnt == null) {
            return null;
        }
        this.blockNum = (byte)bufEnt.acquireBlock();
        if (this.blockNum == -1) {
            return null;
        }
        this.bufferKey = bufEnt.getKey();
        this.update(BUFFER_COLUMN, BLOCK_COLUMN);
        return bufEnt;
    }

    protected DBTraceMemoryBufferEntry findFreeBuffer(DBTraceMemoryBlockEntry prev) throws IOException {
        DBTraceMemoryBufferEntry bufEnt = prev.findAssignedBuffer();
        return this.findFreeBuffer(bufEnt);
    }

    protected DBTraceMemoryBufferEntry findFreeBufferInPast() throws IOException {
        DBTraceMemoryBlockEntry prev = this.space.findMostRecentBlockEntry(this.location, false);
        if (prev == null) {
            return null;
        }
        return this.findFreeBuffer(prev);
    }

    protected DBTraceMemoryBufferEntry findFreeBufferInFuture() throws IOException {
        DBTraceMemoryBlockEntry next = this.space.findSoonestBlockEntry(this.location, false);
        if (next == null) {
            return null;
        }
        return this.findFreeBuffer(next);
    }

    protected DBTraceMemoryBufferEntry findFreeBuffer() throws IOException {
        DBTraceMemoryBufferEntry ent = this.findFreeBufferInPast();
        if (ent != null) {
            return ent;
        }
        ent = this.findFreeBufferInFuture();
        if (ent != null) {
            return ent;
        }
        return this.allocateNewBuffer();
    }

    protected DBTraceMemoryBufferEntry findAssignedBuffer() throws IOException {
        if (this.bufferKey == -1L) {
            return null;
        }
        DBTraceMemoryBufferEntry bufEnt = (DBTraceMemoryBufferEntry)this.space.bufferStore.getObjectAt(this.bufferKey);
        if (bufEnt == null) {
            throw new IOException("Trace Bytes table is corrupt");
        }
        return bufEnt;
    }

    protected static boolean isZeroes(ByteBuffer buf, int len) {
        int pos = buf.position();
        for (int i = 0; i < len; ++i) {
            if (buf.get(pos + i) == 0) continue;
            return false;
        }
        return true;
    }

    public int setBytes(ByteBuffer buf, int dstOffset, int len) throws IOException {
        DBTraceMemoryBufferEntry bufEnt = this.findAssignedBuffer();
        if (bufEnt == null) {
            if (DBTraceMemoryBlockEntry.isZeroes(buf, len)) {
                buf.position(buf.position() + len);
                return len;
            }
            bufEnt = this.findFreeBuffer();
        }
        return bufEnt.setBytes(buf, dstOffset, len, this.getBlockNumber());
    }

    public int getBytes(ByteBuffer buf, int srcOffset, int len) throws IOException {
        DBTraceMemoryBufferEntry bufEnt = this.findAssignedBuffer();
        if (bufEnt == null) {
            buf.put(new byte[len]);
            return len;
        }
        return bufEnt.getBytes(buf, srcOffset, len, this.getBlockNumber());
    }

    public int cmpBytes(ByteBuffer buf, int dstOffset, int len) throws IOException {
        DBTraceMemoryBufferEntry bufEnt = this.findAssignedBuffer();
        if (bufEnt == null) {
            if (DBTraceMemoryBlockEntry.isZeroes(buf, len)) {
                return 0;
            }
            return -1;
        }
        return bufEnt.cmpBytes(buf, dstOffset, len, this.getBlockNumber());
    }
}

