/*
 * Decompiled with CFR 0.152.
 */
package ghidra.test;

import docking.DialogComponentProvider;
import docking.Tool;
import docking.action.DockingActionIf;
import docking.widgets.fieldpanel.FieldPanel;
import ghidra.GhidraTestApplicationLayout;
import ghidra.app.plugin.core.codebrowser.AbstractCodeBrowserPlugin;
import ghidra.framework.ApplicationConfiguration;
import ghidra.framework.GhidraApplicationConfiguration;
import ghidra.framework.model.Project;
import ghidra.framework.model.ToolChest;
import ghidra.framework.model.ToolManager;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.model.Workspace;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginException;
import ghidra.program.model.listing.Program;
import ghidra.test.AbstractGhidraHeadlessIntegrationTest;
import ghidra.util.TaskUtilities;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import junit.framework.AssertionFailedError;
import utility.application.ApplicationLayout;

public abstract class AbstractGhidraHeadedIntegrationTest
extends AbstractGhidraHeadlessIntegrationTest {
    public AbstractGhidraHeadedIntegrationTest() {
        AbstractGhidraHeadedIntegrationTest.setErrorGUIEnabled((boolean)true);
    }

    @Override
    protected ApplicationLayout createApplicationLayout() throws IOException {
        return new GhidraTestApplicationLayout(new File(AbstractGhidraHeadedIntegrationTest.getTestDirectoryPath()));
    }

    @Override
    protected ApplicationConfiguration createApplicationConfiguration() {
        GhidraApplicationConfiguration config = new GhidraApplicationConfiguration();
        config.setShowSplashScreen(false);
        return config;
    }

    public static void waitForProgram(Program program) {
        if (program != null) {
            program.flushEvents();
        }
        AbstractGhidraHeadedIntegrationTest.waitForSwing();
    }

    public static <T extends Plugin> T addPlugin(PluginTool tool, Class<T> c) throws PluginException {
        tool.addPlugin(c.getName());
        return AbstractGhidraHeadedIntegrationTest.getPlugin(tool, c);
    }

    public static Plugin getPluginByName(PluginTool tool, String pluginName) {
        List list = tool.getManagedPlugins();
        for (Plugin p : list) {
            if (!pluginName.equals(p.getName())) continue;
            return p;
        }
        return null;
    }

    public static PluginTool showTool(PluginTool tool) {
        AbstractGhidraHeadedIntegrationTest.runSwing(() -> {
            boolean wasErrorGUIEnabled = AbstractGhidraHeadedIntegrationTest.isUseErrorGUI();
            AbstractGhidraHeadedIntegrationTest.setErrorGUIEnabled((boolean)false);
            tool.setVisible(true);
            AbstractGhidraHeadedIntegrationTest.setErrorGUIEnabled((boolean)wasErrorGUIEnabled);
        });
        AbstractGhidraHeadedIntegrationTest.waitForBusyTool(tool);
        return tool;
    }

    public static DialogComponentProvider showDialogWithoutBlocking(PluginTool tool, DialogComponentProvider provider) {
        AbstractGhidraHeadedIntegrationTest.executeOnSwingWithoutBlocking(() -> tool.showDialog(provider));
        DialogComponentProvider dialog = AbstractGhidraHeadedIntegrationTest.waitForDialogComponent(provider.getClass());
        AbstractGhidraHeadedIntegrationTest.waitForSwing();
        return dialog;
    }

    public static void waitForBusyTool(PluginTool tool) {
        AbstractGhidraHeadedIntegrationTest.waitForSwing();
        int timeout = PRIVATE_LONG_WAIT_TIMEOUT * 2;
        int totalTime = 0;
        while (tool.isExecutingCommand() || TaskUtilities.isExecutingTasks()) {
            if ((totalTime = (int)((long)totalTime + AbstractGhidraHeadedIntegrationTest.sleep((long)DEFAULT_WAIT_DELAY))) < timeout) continue;
            throw new AssertionFailedError("Timed-out waiting for tool to finish tasks");
        }
        AbstractGhidraHeadedIntegrationTest.waitForSwing();
    }

    public static DockingActionIf getAction(Plugin plugin, String actionName) {
        return AbstractGhidraHeadedIntegrationTest.getAction((Tool)plugin.getTool(), (String)plugin.getName(), (String)actionName);
    }

    public static PluginTool saveTool(Project project, PluginTool tool) {
        PluginTool newTool = (PluginTool)AbstractGhidraHeadedIntegrationTest.runSwing(() -> {
            ToolChest toolChest = project.getLocalToolChest();
            ToolTemplate toolTemplate = tool.saveToolToToolTemplate();
            toolChest.replaceToolTemplate(toolTemplate);
            ToolManager toolManager = project.getToolManager();
            Workspace workspace = toolManager.getActiveWorkspace();
            tool.close();
            return workspace.runTool(toolTemplate);
        });
        return newTool;
    }

    public void click(AbstractCodeBrowserPlugin<?> codeBrowser, int clickCount) {
        this.click(codeBrowser, clickCount, true);
    }

    public void click(AbstractCodeBrowserPlugin<?> codeBrowser, int clickCount, boolean wait) {
        codeBrowser.updateNow();
        this.click(codeBrowser.getFieldPanel(), clickCount, wait);
        codeBrowser.updateNow();
    }

    protected void click(FieldPanel fp, int clickCount, boolean wait) {
        Point cursor = fp.getCursorPoint();
        this.click(fp, cursor, clickCount, wait);
    }

    protected void click(FieldPanel fp, Point p, int clickCount, boolean wait) {
        int x = p.x;
        int y = p.y;
        MouseEvent ev = new MouseEvent((Component)fp, 0, System.currentTimeMillis(), 0, x, y, clickCount, false, 1);
        AbstractGhidraHeadedIntegrationTest.runSwing(() -> {
            MouseListener[] listeners;
            for (MouseListener listener : listeners = fp.getMouseListeners()) {
                listener.mousePressed(ev);
            }
            for (MouseListener listener : listeners) {
                listener.mouseReleased(ev);
            }
            for (MouseListener listener : listeners) {
                listener.mouseClicked(ev);
            }
        }, (boolean)wait);
    }
}

