/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.scalartable;

import docking.widgets.textfield.IntegerTextField;
import ghidra.program.model.listing.Program;
import org.apache.commons.lang3.StringUtils;

public class RangeFilterTextField
extends IntegerTextField {
    private Program program;
    private FilterType filterType;
    private int maxValue;

    public RangeFilterTextField(FilterType filterType, Program program) {
        super(8);
        this.program = program;
        this.filterType = filterType;
        this.maxValue = this.getMaxScalarValue();
        this.setValue(this.maxValue);
    }

    public int getLimitValue() {
        return this.maxValue;
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    public long getFilterValue() {
        long longVal;
        String text = this.getText();
        if (StringUtils.isBlank((CharSequence)text)) {
            return this.maxValue;
        }
        try {
            if (text.startsWith("0x")) {
                text = text.substring("0x".length());
                longVal = Long.parseUnsignedLong(text, 16);
            } else {
                longVal = Long.parseLong(text);
            }
        }
        catch (NumberFormatException e) {
            return this.maxValue;
        }
        return longVal;
    }

    private int getMaxScalarValue() {
        int defaultPointerSize = this.program.getDefaultPointerSize();
        int max = (int)Math.pow(2.0, defaultPointerSize * 8);
        return this.filterType == FilterType.MAX ? max : -max;
    }

    public static enum FilterType {
        MIN,
        MAX;

    }
}

