/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.register;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import java.math.BigInteger;

class RegisterValueRange {
    private BigInteger value;
    private boolean isDefault;
    private Address start;
    private Address end;

    public RegisterValueRange(AddressRange range, BigInteger value, boolean isDefault) {
        this.value = value;
        this.isDefault = isDefault;
        this.start = range.getMinAddress();
        this.end = range.getMaxAddress();
    }

    public void setEndAddress(Address maxAddress) {
        this.end = maxAddress;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public Address getEndAddress() {
        return this.end;
    }

    public Address getStartAddress() {
        return this.start;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public String toString() {
        if (this.value == null) {
            return "";
        }
        return "0x" + this.value.toString(16) + (this.isDefault ? "  (default)" : "");
    }
}

