/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer;

import java.net.URL;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.Compat;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.main.application.CommandLineOptions;
import org.freeplane.main.mindmapmode.stylemode.ExtensionInstaller;
import org.freeplane.main.osgi.IControllerExtensionProvider;
import org.freeplane.plugin.codeexplorer.CodeModeController;
import org.freeplane.plugin.codeexplorer.CodeModeControllerFactory;
import org.freeplane.plugin.codeexplorer.archunit.ArchUnitServer;
import org.freeplane.plugin.codeexplorer.configurator.CodeProjectController;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private CodeModeController modeController;
    private ExecutorService classImportService;
    private static final String PREFERENCES_RESOURCE = "preferences.xml";

    public void start(BundleContext context) throws Exception {
        if (Compat.isJavaVersionLessThan((String)"11.")) {
            System.out.println("Java 11 is required for code explorer mode. Disabled.");
        } else {
            this.registerMindMapModeExtension(context);
        }
    }

    private void registerMindMapModeExtension(BundleContext context) {
        Hashtable props = new Hashtable();
        context.registerService(IControllerExtensionProvider.class.getName(), (Object)new IControllerExtensionProvider(){

            public void installExtension(Controller controller, CommandLineOptions options, ExtensionInstaller.Context context) {
                if (context == ExtensionInstaller.Context.MAIN && Activator.this.modeController == null) {
                    Activator.this.classImportService = Executors.newSingleThreadExecutor(this::newThread);
                    ArchUnitServer archUnitServer = new ArchUnitServer();
                    ResourceController.getResourceController().addPropertyChangeListenerAndPropagate((IFreeplanePropertyListener)archUnitServer);
                    Activator.this.modeController = CodeModeControllerFactory.createModeController(Activator.this.classImportService, archUnitServer);
                    this.addPreferencesToOptionPanel();
                }
            }

            private Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "Load explored packages");
                thread.setDaemon(true);
                thread.setPriority(Math.min(10, Thread.currentThread().getPriority() + 1));
                return thread;
            }

            private void addPreferencesToOptionPanel() {
                URL preferences = this.getClass().getResource(Activator.PREFERENCES_RESOURCE);
                if (preferences == null) {
                    throw new RuntimeException("cannot open preferences");
                }
                MModeController modeController = MModeController.getMModeController();
                modeController.getOptionPanelBuilder().load(preferences);
            }
        }, props);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.modeController != null) {
            ((CodeProjectController)this.modeController.getExtension(CodeProjectController.class)).saveConfiguration();
            this.classImportService.shutdownNow();
        }
    }
}

