/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.nodestyle;

import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.map.NodeModel;

public class NodeSizeModel
implements IExtension {
    private Quantity<LengthUnit> minNodeWidth = null;
    private Quantity<LengthUnit> maxNodeWidth = null;

    public static NodeSizeModel getModel(NodeModel node) {
        return node.getExtension(NodeSizeModel.class);
    }

    public static NodeSizeModel createNodeSizeModel(NodeModel node) {
        NodeSizeModel styleModel = node.getExtension(NodeSizeModel.class);
        if (styleModel == null) {
            styleModel = new NodeSizeModel();
            node.addExtension(styleModel);
        }
        return styleModel;
    }

    public Quantity<LengthUnit> getMaxNodeWidth() {
        return this.maxNodeWidth;
    }

    public void setMaxNodeWidth(Quantity<LengthUnit> maxTextWidth) {
        this.maxNodeWidth = maxTextWidth;
    }

    public Quantity<LengthUnit> getMinNodeWidth() {
        return this.minNodeWidth;
    }

    public void setMinNodeWidth(Quantity<LengthUnit> quantity) {
        this.minNodeWidth = quantity;
    }

    public static void setMaxNodeWidth(NodeModel node, Quantity<LengthUnit> maxTextWidth) {
        NodeSizeModel.createNodeSizeModel(node).setMaxNodeWidth(maxTextWidth);
    }

    public static void setNodeMinWidth(NodeModel node, Quantity<LengthUnit> minNodeWidth) {
        NodeSizeModel.createNodeSizeModel(node).setMinNodeWidth(minNodeWidth);
    }

    public static Quantity<LengthUnit> getMaxNodeWidth(NodeModel node) {
        NodeSizeModel extension = node.getExtension(NodeSizeModel.class);
        return extension != null ? extension.getMaxNodeWidth() : null;
    }

    public static Quantity<LengthUnit> getMinNodeWidth(NodeModel node) {
        NodeSizeModel extension = node.getExtension(NodeSizeModel.class);
        return extension != null ? extension.getMinNodeWidth() : null;
    }

    public void copyTo(NodeSizeModel to) {
        if (this.maxNodeWidth != null) {
            to.setMaxNodeWidth(this.maxNodeWidth);
        }
        if (this.minNodeWidth != null) {
            to.setMinNodeWidth(this.minNodeWidth);
        }
    }
}

