﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cloudformation/CloudFormation_EXPORTS.h>
#include <aws/cloudformation/model/ResponseMetadata.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace CloudFormation {
namespace Model {
class UpdateGeneratedTemplateResult {
 public:
  AWS_CLOUDFORMATION_API UpdateGeneratedTemplateResult() = default;
  AWS_CLOUDFORMATION_API UpdateGeneratedTemplateResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_CLOUDFORMATION_API UpdateGeneratedTemplateResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the generated template. The format is
   * <code>arn:${Partition}:cloudformation:${Region}:${Account}:generatedtemplate/${Id}</code>.
   * For example,
   * <code>arn:aws:cloudformation:<i>us-east-1</i>:<i>123456789012</i>:generatedtemplate/<i>2e8465c1-9a80-43ea-a3a3-4f2d692fe6dc</i>
   * </code>.</p>
   */
  inline const Aws::String& GetGeneratedTemplateId() const { return m_generatedTemplateId; }
  template <typename GeneratedTemplateIdT = Aws::String>
  void SetGeneratedTemplateId(GeneratedTemplateIdT&& value) {
    m_generatedTemplateIdHasBeenSet = true;
    m_generatedTemplateId = std::forward<GeneratedTemplateIdT>(value);
  }
  template <typename GeneratedTemplateIdT = Aws::String>
  UpdateGeneratedTemplateResult& WithGeneratedTemplateId(GeneratedTemplateIdT&& value) {
    SetGeneratedTemplateId(std::forward<GeneratedTemplateIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  UpdateGeneratedTemplateResult& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_generatedTemplateId;

  ResponseMetadata m_responseMetadata;
  bool m_generatedTemplateIdHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudFormation
}  // namespace Aws
