/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplemagic.logger;

import com.j256.simplemagic.logger.Level;
import com.j256.simplemagic.logger.LogBackend;
import com.j256.simplemagic.logger.LogBackendFactory;
import com.j256.simplemagic.logger.backend.ConsoleLogBackend;
import com.j256.simplemagic.logger.backend.LocalLogBackend;
import com.j256.simplemagic.logger.backend.NullLogBackend;

public enum LogBackendType implements LogBackendFactory
{
    SLF4J("Slf4jLoggingLogBackend$Slf4jLoggingLogBackendFactory"),
    LOGBACK("LogbackLogBackend$LogbackLogBackendFactory"),
    COMMONS_LOGGING("CommonsLoggingLogBackend$CommonsLoggingLogBackendFactory"),
    LOG4J2("Log4j2LogBackend$Log4j2LogBackendFactory"),
    LOG4J("Log4jLogBackend$Log4jLogBackendFactory"),
    LOCAL(new LocalLogBackend.LocalLogBackendFactory()),
    CONSOLE(new ConsoleLogBackend.ConsoleLogBackendFactory()),
    JAVA_UTIL("JavaUtilLogBackend$JavaUtilLogBackendFactory"),
    NULL(new NullLogBackend.NullLogBackendFactory());

    private final LogBackendFactory factory;

    private LogBackendType(LogBackendFactory factory) {
        this.factory = factory;
    }

    private LogBackendType(String factoryClassNameSuffix) {
        this.factory = this.detectFactory(LocalLogBackend.LocalLogBackendFactory.class.getPackage().getName() + '.' + factoryClassNameSuffix);
    }

    @Override
    public LogBackend createLogBackend(String classLabel) {
        return this.factory.createLogBackend(classLabel);
    }

    public boolean isAvailable() {
        return this == LOCAL || this != NULL && !(this.factory instanceof LocalLogBackend.LocalLogBackendFactory);
    }

    private LogBackendFactory detectFactory(String factoryClassName) {
        try {
            LogBackendFactory factory = (LogBackendFactory)Class.forName(factoryClassName).newInstance();
            factory.createLogBackend("test").isLevelEnabled(Level.INFO);
            return factory;
        }
        catch (Throwable th) {
            String queuedWarning = "Unable to create instance of class " + factoryClassName + " for log type " + this + ", using local log: " + th;
            return new LocalLogBackend.LocalLogBackendFactory(queuedWarning);
        }
    }
}

