/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.api.endpoint;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import org.apache.solr.client.api.model.GetAliasPropertyResponse;
import org.apache.solr.client.api.model.GetAllAliasPropertiesResponse;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.api.model.UpdateAliasPropertiesRequestBody;
import org.apache.solr.client.api.model.UpdateAliasPropertyRequestBody;

@Path(value="/aliases/{aliasName}/properties")
public interface AliasPropertyApis {
    @GET
    @Operation(summary="Get properties for a collection alias.", tags={"alias-properties"})
    public GetAllAliasPropertiesResponse getAllAliasProperties(@Parameter(description="Alias Name") @PathParam(value="aliasName") String var1) throws Exception;

    @GET
    @Path(value="/{propName}")
    @Operation(summary="Get a specific property for a collection alias.", tags={"alias-properties"})
    public GetAliasPropertyResponse getAliasProperty(@Parameter(description="Alias Name") @PathParam(value="aliasName") String var1, @Parameter(description="Property Name") @PathParam(value="propName") String var2) throws Exception;

    @PUT
    @Operation(summary="Update properties for a collection alias.", tags={"alias-properties"})
    public SolrJerseyResponse updateAliasProperties(@Parameter(description="Alias Name") @PathParam(value="aliasName") String var1, @RequestBody(description="Properties that need to be updated", required=true) UpdateAliasPropertiesRequestBody var2) throws Exception;

    @PUT
    @Path(value="/{propName}")
    @Operation(summary="Update a specific property for a collection alias.", tags={"alias-properties"})
    public SolrJerseyResponse createOrUpdateAliasProperty(@Parameter(description="Alias Name") @PathParam(value="aliasName") String var1, @Parameter(description="Property Name") @PathParam(value="propName") String var2, @RequestBody(description="Property value that needs to be updated", required=true) UpdateAliasPropertyRequestBody var3) throws Exception;

    @DELETE
    @Path(value="/{propName}")
    @Operation(summary="Delete a specific property for a collection alias.", tags={"alias-properties"})
    public SolrJerseyResponse deleteAliasProperty(@Parameter(description="Alias Name") @PathParam(value="aliasName") String var1, @Parameter(description="Property Name") @PathParam(value="propName") String var2) throws Exception;
}

