/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.URLUtil;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.ReplicationHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.PeerSyncWithLeader;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.update.UpdateShardHandlerConfig;
import org.apache.solr.util.RTimer;
import org.apache.solr.util.RefCounted;
import org.apache.solr.util.SolrPluginUtils;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryStrategy
implements Runnable,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private int waitForUpdatesWithStaleStatePauseMilliSeconds = Integer.getInteger("solr.cloud.wait-for-updates-with-stale-state-pause", 2500);
    private int maxRetries = 500;
    private int startingRecoveryDelayMilliSeconds = 2000;
    private ReplicationHandler replicationHandlerDoingFetch;
    private volatile boolean close = false;
    private RecoveryListener recoveryListener;
    private ZkController zkController;
    private String baseUrl;
    private String coreZkNodeName;
    private ZkStateReader zkStateReader;
    private volatile String coreName;
    private int retries;
    private boolean recoveringAfterStartup;
    private CoreContainer cc;
    private volatile FutureTask<NamedList<Object>> prevSendPreRecoveryHttpUriRequest;
    private final Replica.Type replicaType;
    private CoreDescriptor coreDescriptor;
    public static Runnable testing_beforeReplayBufferingUpdates;

    protected RecoveryStrategy(CoreContainer cc, CoreDescriptor cd, RecoveryListener recoveryListener) {
        this.cc = cc;
        this.coreName = cd.getName();
        this.recoveryListener = recoveryListener;
        this.zkController = cc.getZkController();
        this.zkStateReader = this.zkController.getZkStateReader();
        this.baseUrl = this.zkController.getBaseUrl();
        this.coreZkNodeName = cd.getCloudDescriptor().getCoreNodeName();
        this.replicaType = cd.getCloudDescriptor().getReplicaType();
    }

    public final int getWaitForUpdatesWithStaleStatePauseMilliSeconds() {
        return this.waitForUpdatesWithStaleStatePauseMilliSeconds;
    }

    public final void setWaitForUpdatesWithStaleStatePauseMilliSeconds(int waitForUpdatesWithStaleStatePauseMilliSeconds) {
        this.waitForUpdatesWithStaleStatePauseMilliSeconds = waitForUpdatesWithStaleStatePauseMilliSeconds;
    }

    public final int getMaxRetries() {
        return this.maxRetries;
    }

    public final void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public final int getStartingRecoveryDelayMilliSeconds() {
        return this.startingRecoveryDelayMilliSeconds;
    }

    public final void setStartingRecoveryDelayMilliSeconds(int startingRecoveryDelayMilliSeconds) {
        this.startingRecoveryDelayMilliSeconds = startingRecoveryDelayMilliSeconds;
    }

    public final boolean getRecoveringAfterStartup() {
        return this.recoveringAfterStartup;
    }

    public final void setRecoveringAfterStartup(boolean recoveringAfterStartup) {
        this.recoveringAfterStartup = recoveringAfterStartup;
    }

    private Http2SolrClient.Builder recoverySolrClientBuilder(String baseUrl, String leaderCoreName) {
        UpdateShardHandlerConfig cfg = this.cc.getConfig().getUpdateShardHandlerConfig();
        return ((Http2SolrClient.Builder)new Http2SolrClient.Builder(baseUrl).withDefaultCollection(leaderCoreName)).withHttpClient(this.cc.getUpdateShardHandler().getRecoveryOnlyHttpClient());
    }

    @Override
    public final void close() {
        this.close = true;
        this.cancelPrepRecoveryCmd();
        log.warn("Stopping recovery for core=[{}] coreNodeName=[{}]", (Object)this.coreName, (Object)this.coreZkNodeName);
        this.abortIndexFetchingIfNecessary(this.replicationHandlerDoingFetch);
    }

    private void abortIndexFetchingIfNecessary(ReplicationHandler fetcher) {
        if (fetcher != null) {
            fetcher.abortFetch();
        }
    }

    private final void recoveryFailed(ZkController zkController, CoreDescriptor cd) throws Exception {
        log.error("Recovery failed - I give up.");
        try {
            zkController.publish(cd, Replica.State.RECOVERY_FAILED);
        }
        finally {
            this.close();
            this.recoveryListener.failed();
        }
    }

    protected String getReplicateLeaderUrl(ZkNodeProps leaderprops) {
        return new ZkCoreNodeProps(leaderprops).getCoreUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replicate(String nodeName, SolrCore core, ZkNodeProps leaderprops) throws SolrServerException, IOException {
        SolrRequestHandler handler;
        ReplicationHandler replicationHandler;
        String leaderBaseUrl = URLUtil.extractBaseUrl((String)this.getReplicateLeaderUrl(leaderprops));
        String leaderCore = URLUtil.extractCoreFromCoreUrl((String)this.getReplicateLeaderUrl(leaderprops));
        log.info("Attempting to replicate from core [{}] on node [{}].", (Object)leaderCore, (Object)leaderBaseUrl);
        if (Replica.Type.isLeaderType((Replica.Type)this.replicaType)) {
            this.commitOnLeader(leaderBaseUrl, leaderCore);
        }
        if ((replicationHandler = (ReplicationHandler)(handler = core.getRequestHandler("/replication"))) == null) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Skipping recovery, no /replication handler found");
        }
        ModifiableSolrParams solrParams = new ModifiableSolrParams();
        solrParams.set("leaderUrl", new String[]{URLUtil.buildCoreUrl((String)leaderBaseUrl, (String)leaderCore)});
        solrParams.set("skipCommitOnLeaderVersionZero", this.replicaType == Replica.Type.TLOG);
        if (this.isClosed()) {
            return;
        }
        try {
            this.replicationHandlerDoingFetch = replicationHandler;
            boolean success = replicationHandler.doFetch((SolrParams)solrParams, false).getSuccessful();
            if (!success) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Replication for recovery failed.");
            }
        }
        finally {
            this.replicationHandlerDoingFetch = null;
        }
        if (log.isDebugEnabled()) {
            try {
                RefCounted<SolrIndexSearcher> searchHolder = core.getNewestSearcher(false);
                SolrIndexSearcher searcher = searchHolder.get();
                Directory dir = core.getDirectoryFactory().get(core.getIndexDir(), DirectoryFactory.DirContext.META_DATA, null);
                try {
                    IndexCommit commit = core.getDeletionPolicy().getLatestCommit();
                    if (log.isDebugEnabled()) {
                        log.debug("{} replicated {} from core {} on node {} gen: {} data: {} index: {} newIndex: {} files: {}", new Object[]{core.getCoreContainer().getZkController().getNodeName(), searcher.count((Query)new MatchAllDocsQuery()), leaderCore, leaderBaseUrl, null == commit ? "null" : Long.valueOf(commit.getGeneration()), core.getDataDir(), core.getIndexDir(), core.getNewIndexDir(), Arrays.asList(dir.listAll())});
                    }
                }
                finally {
                    core.getDirectoryFactory().release(dir);
                    searchHolder.decref();
                }
            }
            catch (Exception e) {
                log.debug("Error in solrcloud_debug block", (Throwable)e);
            }
        }
    }

    private void commitOnLeader(String leaderBaseUrl, String coreName) throws SolrServerException, IOException {
        try (Http2SolrClient client = this.recoverySolrClientBuilder(leaderBaseUrl, coreName).build();){
            UpdateRequest ureq = new UpdateRequest();
            ureq.setParams(new ModifiableSolrParams());
            ureq.getParams().set("openSearcher", false);
            ureq.setAction(AbstractUpdateRequest.ACTION.COMMIT, false, true).process((SolrClient)client);
        }
    }

    @Override
    public final void run() {
        try (SolrCore core = this.cc.getCore(this.coreName);){
            if (core == null) {
                log.error("SolrCore not found - cannot recover: {}", (Object)this.coreName);
                return;
            }
            log.info("Starting recovery process. recoveringAfterStartup={}", (Object)this.recoveringAfterStartup);
            RTimer timer = new RTimer();
            try {
                this.doRecovery(core);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("interrupted", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            if (log.isInfoEnabled()) {
                log.info("Finished recovery process. recoveringAfterStartup={} msTimeTaken={}", (Object)this.recoveringAfterStartup, (Object)timer.getTime());
            }
        }
    }

    public final void doRecovery(SolrCore core) throws Exception {
        this.coreDescriptor = core.getCoreDescriptor();
        if (this.coreDescriptor.getCloudDescriptor().requiresTransactionLog()) {
            this.doSyncOrReplicateRecovery(core);
        } else {
            this.doReplicateOnlyRecovery(core);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doReplicateOnlyRecovery(SolrCore core) throws InterruptedException {
        RTimer timer = new RTimer();
        boolean successfulRecovery = false;
        while (!(successfulRecovery || Thread.currentThread().isInterrupted() || this.isClosed())) {
            try {
                block32: {
                    CloudDescriptor cloudDesc = this.coreDescriptor.getCloudDescriptor();
                    Replica leader = this.zkStateReader.getLeaderRetry(cloudDesc.getCollectionName(), cloudDesc.getShardId());
                    String leaderUrl = leader.getCoreUrl();
                    String ourUrl = ZkCoreNodeProps.getCoreUrl((String)this.baseUrl, (String)this.coreName);
                    boolean isLeader = ourUrl.equals(leaderUrl);
                    if (isLeader && !cloudDesc.isLeader()) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Cloud state still says we are leader.");
                    }
                    if (cloudDesc.isLeader()) {
                        assert (cloudDesc.getReplicaType() != Replica.Type.PULL);
                        log.warn("We have not yet recovered - but we are now the leader!");
                        log.info("Finished recovery process.");
                        this.zkController.publish(this.coreDescriptor, Replica.State.ACTIVE);
                        return;
                    }
                    if (log.isInfoEnabled()) {
                        log.info("Publishing state of core [{}] as recovering, leader is [{}] and I am [{}]", new Object[]{core.getName(), leaderUrl, ourUrl});
                    }
                    this.zkController.publish(this.coreDescriptor, Replica.State.RECOVERING);
                    if (this.isClosed()) {
                        if (!log.isInfoEnabled()) break;
                        log.info("Recovery for core {} has been closed", (Object)core.getName());
                        break;
                    }
                    log.info("Starting Replication Recovery.");
                    log.info("Stopping background replicate from leader process");
                    this.zkController.stopReplicationFromLeader(this.coreName);
                    this.replicate(this.zkController.getNodeName(), core, (ZkNodeProps)leader);
                    if (!this.isClosed()) break block32;
                    if (!log.isInfoEnabled()) break;
                    log.info("Recovery for core {} has been closed", (Object)core.getName());
                    break;
                }
                try {
                    log.info("Replication Recovery was successful.");
                    successfulRecovery = true;
                }
                catch (Exception e) {
                    log.error("Error while trying to recover", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error("Error while trying to recover. core={}", (Object)this.coreName, (Object)e);
            }
            finally {
                if (successfulRecovery) {
                    log.info("Restarting background replicate from leader process");
                    this.zkController.startReplicationFromLeader(this.coreName, false);
                    log.info("Registering as Active after recovery.");
                    try {
                        this.zkController.publish(this.coreDescriptor, Replica.State.ACTIVE);
                    }
                    catch (Exception e) {
                        log.error("Could not publish as ACTIVE after successful recovery", (Throwable)e);
                        successfulRecovery = false;
                    }
                    if (successfulRecovery) {
                        this.close = true;
                        this.recoveryListener.recovered();
                    }
                }
            }
            if (successfulRecovery || !this.waitBetweenRecoveries(core.getName())) continue;
        }
        if (log.isInfoEnabled()) {
            log.info("Finished recovery process, successful=[{}] msTimeTaken={}", (Object)successfulRecovery, (Object)timer.getTime());
        }
    }

    private boolean waitBetweenRecoveries(String coreName) {
        block10: {
            try {
                if (this.isClosed()) {
                    log.info("Recovery for core {} has been closed", (Object)coreName);
                    return true;
                }
                log.error("Recovery failed - trying again... ({})", (Object)this.retries);
                ++this.retries;
                if (this.retries < this.maxRetries) break block10;
                log.error("Recovery failed - max retries exceeded ({}).", (Object)this.retries);
                try {
                    this.recoveryFailed(this.zkController, this.coreDescriptor);
                }
                catch (Exception e) {
                    log.error("Could not publish that recovery failed", (Throwable)e);
                }
                return true;
            }
            catch (Exception e) {
                log.error("An error has occurred during recovery", (Throwable)e);
            }
        }
        try {
            long loopCount;
            long l = loopCount = this.retries < 5 ? Math.round(Math.pow(2.0, this.retries)) : 30L;
            if (log.isInfoEnabled()) {
                log.info("Wait [{}] seconds before trying to recover again (attempt={})", (Object)TimeUnit.MILLISECONDS.toSeconds(loopCount * (long)this.startingRecoveryDelayMilliSeconds), (Object)this.retries);
            }
            int i = 0;
            while ((long)i < loopCount) {
                if (this.isClosed()) {
                    log.info("Recovery for core {} has been closed", (Object)coreName);
                    break;
                }
                Thread.sleep(this.startingRecoveryDelayMilliSeconds);
                ++i;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("Recovery was interrupted.", (Throwable)e);
            this.close = true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final void doSyncOrReplicateRecovery(SolrCore core) throws Exception {
        timer = new RTimer();
        successfulRecovery = false;
        ulog = core.getUpdateHandler().getUpdateLog();
        if (ulog == null) {
            RecoveryStrategy.log.error("No UpdateLog found - cannot recover.");
            this.recoveryFailed(this.zkController, this.coreDescriptor);
            return;
        }
        firstTime = this.replicaType != Replica.Type.TLOG;
        try {
            recentUpdates = ulog.getRecentUpdates();
            try {
                recentVersions = recentUpdates.getVersions(ulog.getNumRecordsToKeep());
            }
            finally {
                if (recentUpdates != null) {
                    recentUpdates.close();
                }
            }
        }
        catch (Exception e) {
            RecoveryStrategy.log.error("Corrupt tlog - ignoring.", (Throwable)e);
            recentVersions = new ArrayList<Long>(0);
        }
        startingVersions = ulog.getStartingVersions();
        if (startingVersions != null && this.recoveringAfterStartup) {
            try {
                v0 = firstStartingVersion = startingVersions.size() > 0 ? startingVersions.get(0) : 0L;
                for (oldIdx = 0; oldIdx < recentVersions.size() && recentVersions.get(oldIdx) != firstStartingVersion; ++oldIdx) {
                }
                if (oldIdx > 0) {
                    RecoveryStrategy.log.info("Found new versions added after startup: num=[{}]", (Object)oldIdx);
                    if (RecoveryStrategy.log.isInfoEnabled()) {
                        RecoveryStrategy.log.info("currentVersions size={} range=[{} to {}]", new Object[]{recentVersions.size(), recentVersions.get(0), recentVersions.get(recentVersions.size() - 1)});
                    }
                }
                if (startingVersions.isEmpty()) {
                    RecoveryStrategy.log.info("startupVersions is empty");
                } else if (RecoveryStrategy.log.isInfoEnabled()) {
                    RecoveryStrategy.log.info("startupVersions size={} range=[{} to {}]", new Object[]{startingVersions.size(), startingVersions.get(0), startingVersions.get(startingVersions.size() - 1)});
                }
            }
            catch (Exception e) {
                RecoveryStrategy.log.error("Error getting recent versions.", (Throwable)e);
                recentVersions = new ArrayList<Long>(0);
            }
        }
        if (this.recoveringAfterStartup) {
            recentVersions = startingVersions;
            try {
                if (ulog.existOldBufferLog()) {
                    RecoveryStrategy.log.info("Looks like a previous replication recovery did not complete - skipping peer sync.");
                    firstTime = false;
                }
            }
            catch (Exception e) {
                RecoveryStrategy.log.error("Error trying to get ulog starting operation.", (Throwable)e);
                firstTime = false;
            }
        }
        if (this.replicaType == Replica.Type.TLOG) {
            this.zkController.stopReplicationFromLeader(this.coreName);
        }
        ourUrl = ZkCoreNodeProps.getCoreUrl((String)this.baseUrl, (String)this.coreName);
        replayFuture = null;
        while (!(successfulRecovery || Thread.currentThread().isInterrupted() || this.isClosed())) {
            block96: {
                block95: {
                    block94: {
                        block93: {
                            block91: {
                                block90: {
                                    block88: {
                                        block89: {
                                            block87: {
                                                cloudDesc = this.coreDescriptor.getCloudDescriptor();
                                                leader = this.pingLeader(ourUrl, this.coreDescriptor, true);
                                                if (!this.isClosed()) break block87;
                                                RecoveryStrategy.log.info("RecoveryStrategy has been closed");
                                                if (!successfulRecovery) break;
                                                RecoveryStrategy.log.info("Registering as Active after recovery.");
                                                try {
                                                    if (this.replicaType == Replica.Type.TLOG) {
                                                        this.zkController.startReplicationFromLeader(this.coreName, true);
                                                    }
                                                    this.zkController.publish(this.coreDescriptor, Replica.State.ACTIVE);
                                                }
                                                catch (Exception e) {
                                                    RecoveryStrategy.log.error("Could not publish as ACTIVE after successful recovery", (Throwable)e);
                                                    successfulRecovery = false;
                                                }
                                                if (!successfulRecovery) break;
                                                this.close = true;
                                                this.recoveryListener.recovered();
                                                break;
                                            }
                                            isLeader = leader.getCoreUrl().equals(ourUrl);
                                            if (isLeader && !cloudDesc.isLeader()) {
                                                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Cloud state still says we are leader.");
                                            }
                                            if (!cloudDesc.isLeader()) break block88;
                                            RecoveryStrategy.log.warn("We have not yet recovered - but we are now the leader!");
                                            RecoveryStrategy.log.info("Finished recovery process.");
                                            this.zkController.publish(this.coreDescriptor, Replica.State.ACTIVE);
                                            if (!successfulRecovery) break block89;
                                            RecoveryStrategy.log.info("Registering as Active after recovery.");
                                            try {
                                                if (this.replicaType == Replica.Type.TLOG) {
                                                    this.zkController.startReplicationFromLeader(this.coreName, true);
                                                }
                                                this.zkController.publish(this.coreDescriptor, Replica.State.ACTIVE);
                                            }
                                            catch (Exception e) {
                                                RecoveryStrategy.log.error("Could not publish as ACTIVE after successful recovery", (Throwable)e);
                                                successfulRecovery = false;
                                            }
                                            if (successfulRecovery) {
                                                this.close = true;
                                                this.recoveryListener.recovered();
                                            }
                                        }
                                        return;
                                    }
                                    RecoveryStrategy.log.info("Begin buffering updates. core=[{}]", (Object)this.coreName);
                                    ulog.bufferUpdates();
                                    if (RecoveryStrategy.log.isInfoEnabled()) {
                                        RecoveryStrategy.log.info("Publishing state of core [{}] as recovering, leader is [{}] and I am [{}]", new Object[]{core.getName(), leader.getCoreUrl(), ourUrl});
                                    }
                                    this.zkController.publish(this.coreDescriptor, Replica.State.RECOVERING);
                                    slice = this.zkStateReader.getClusterState().getCollection(cloudDesc.getCollectionName()).getSlice(cloudDesc.getShardId());
                                    this.cancelPrepRecoveryCmd();
                                    if (!this.isClosed()) break block90;
                                    RecoveryStrategy.log.info("RecoveryStrategy has been closed");
                                    if (!successfulRecovery) break;
                                    RecoveryStrategy.log.info("Registering as Active after recovery.");
                                    try {
                                        if (this.replicaType == Replica.Type.TLOG) {
                                            this.zkController.startReplicationFromLeader(this.coreName, true);
                                        }
                                        this.zkController.publish(this.coreDescriptor, Replica.State.ACTIVE);
                                    }
                                    catch (Exception e) {
                                        RecoveryStrategy.log.error("Could not publish as ACTIVE after successful recovery", (Throwable)e);
                                        successfulRecovery = false;
                                    }
                                    if (!successfulRecovery) break;
                                    this.close = true;
                                    this.recoveryListener.recovered();
                                    break;
                                }
                                this.sendPrepRecoveryCmd(leader.getBaseUrl(), leader.getCoreName(), slice);
                                if (!this.isClosed()) break block91;
                                RecoveryStrategy.log.info("RecoveryStrategy has been closed");
                                if (!successfulRecovery) break;
                                RecoveryStrategy.log.info("Registering as Active after recovery.");
                                try {
                                    if (this.replicaType == Replica.Type.TLOG) {
                                        this.zkController.startReplicationFromLeader(this.coreName, true);
                                    }
                                    this.zkController.publish(this.coreDescriptor, Replica.State.ACTIVE);
                                }
                                catch (Exception e) {
                                    RecoveryStrategy.log.error("Could not publish as ACTIVE after successful recovery", (Throwable)e);
                                    successfulRecovery = false;
                                }
                                if (!successfulRecovery) break;
                                this.close = true;
                                this.recoveryListener.recovered();
                                break;
                            }
                            try {
                                Thread.sleep(this.waitForUpdatesWithStaleStatePauseMilliSeconds);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                            if (!firstTime) ** GOTO lbl188
                            firstTime = false;
                            if (RecoveryStrategy.log.isInfoEnabled()) {
                                RecoveryStrategy.log.info("Attempting to PeerSync from [{}] - recoveringAfterStartup=[{}]", (Object)leader.getCoreUrl(), (Object)this.recoveringAfterStartup);
                            }
                            peerSyncWithLeader = new PeerSyncWithLeader(core, leader.getCoreUrl(), ulog.getNumRecordsToKeep());
                            try {
                                syncSuccess = peerSyncWithLeader.sync(recentVersions).isSuccess();
                            }
                            finally {
                                peerSyncWithLeader.close();
                            }
                            if (!syncSuccess) break block93;
                            req = new LocalSolrQueryRequest(core, (SolrParams)new ModifiableSolrParams());
                            core.getUpdateHandler().commit(new CommitUpdateCommand(req, false));
                            req.close();
                            RecoveryStrategy.log.info("PeerSync stage of recovery was successful.");
                            this.cloudDebugLog(core, "synced");
                            RecoveryStrategy.log.info("Replaying updates buffered during PeerSync.");
                            replayFuture = this.replay(core);
                            successfulRecovery = true;
                            if (!successfulRecovery) break;
                            RecoveryStrategy.log.info("Registering as Active after recovery.");
                            try {
                                if (this.replicaType == Replica.Type.TLOG) {
                                    this.zkController.startReplicationFromLeader(this.coreName, true);
                                }
                                this.zkController.publish(this.coreDescriptor, Replica.State.ACTIVE);
                            }
                            catch (Exception e) {
                                RecoveryStrategy.log.error("Could not publish as ACTIVE after successful recovery", (Throwable)e);
                                successfulRecovery = false;
                            }
                            if (!successfulRecovery) break;
                            this.close = true;
                            this.recoveryListener.recovered();
                            break;
                        }
                        RecoveryStrategy.log.info("PeerSync Recovery was not successful - trying replication.");
lbl188:
                        // 2 sources

                        if (!this.isClosed()) break block94;
                        RecoveryStrategy.log.info("RecoveryStrategy has been closed");
                        if (!successfulRecovery) break;
                        RecoveryStrategy.log.info("Registering as Active after recovery.");
                        try {
                            if (this.replicaType == Replica.Type.TLOG) {
                                this.zkController.startReplicationFromLeader(this.coreName, true);
                            }
                            this.zkController.publish(this.coreDescriptor, Replica.State.ACTIVE);
                        }
                        catch (Exception e) {
                            RecoveryStrategy.log.error("Could not publish as ACTIVE after successful recovery", (Throwable)e);
                            successfulRecovery = false;
                        }
                        if (!successfulRecovery) break;
                        this.close = true;
                        this.recoveryListener.recovered();
                        break;
                    }
                    RecoveryStrategy.log.info("Starting Replication Recovery.");
                    this.replicate(this.zkController.getNodeName(), core, (ZkNodeProps)leader);
                    if (!this.isClosed()) break block95;
                    RecoveryStrategy.log.info("RecoveryStrategy has been closed");
                    if (!successfulRecovery) break;
                    RecoveryStrategy.log.info("Registering as Active after recovery.");
                    try {
                        if (this.replicaType == Replica.Type.TLOG) {
                            this.zkController.startReplicationFromLeader(this.coreName, true);
                        }
                        this.zkController.publish(this.coreDescriptor, Replica.State.ACTIVE);
                    }
                    catch (Exception e) {
                        RecoveryStrategy.log.error("Could not publish as ACTIVE after successful recovery", (Throwable)e);
                        successfulRecovery = false;
                    }
                    if (!successfulRecovery) break;
                    this.close = true;
                    this.recoveryListener.recovered();
                    break;
                }
                replayFuture = this.replay(core);
                if (!this.isClosed()) break block96;
                RecoveryStrategy.log.info("RecoveryStrategy has been closed");
                if (!successfulRecovery) break;
                RecoveryStrategy.log.info("Registering as Active after recovery.");
                try {
                    if (this.replicaType == Replica.Type.TLOG) {
                        this.zkController.startReplicationFromLeader(this.coreName, true);
                    }
                    this.zkController.publish(this.coreDescriptor, Replica.State.ACTIVE);
                }
                catch (Exception e) {
                    RecoveryStrategy.log.error("Could not publish as ACTIVE after successful recovery", (Throwable)e);
                    successfulRecovery = false;
                }
                if (!successfulRecovery) break;
                this.close = true;
                this.recoveryListener.recovered();
                break;
            }
            try {
                RecoveryStrategy.log.info("Replication Recovery was successful.");
                successfulRecovery = true;
                {
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        RecoveryStrategy.log.warn("Recovery was interrupted", (Throwable)e);
                        this.close = true;
                    }
                    catch (Exception e) {
                        RecoveryStrategy.log.error("Error while trying to recover", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                RecoveryStrategy.log.error("Error while trying to recover. core={}", (Object)this.coreName, (Object)e);
            }
            catch (Throwable var18_39) {
                throw var18_39;
            }
            finally {
                if (successfulRecovery) {
                    RecoveryStrategy.log.info("Registering as Active after recovery.");
                    try {
                        if (this.replicaType == Replica.Type.TLOG) {
                            this.zkController.startReplicationFromLeader(this.coreName, true);
                        }
                        this.zkController.publish(this.coreDescriptor, Replica.State.ACTIVE);
                    }
                    catch (Exception e) {
                        RecoveryStrategy.log.error("Could not publish as ACTIVE after successful recovery", (Throwable)e);
                        successfulRecovery = false;
                    }
                    if (successfulRecovery) {
                        this.close = true;
                        this.recoveryListener.recovered();
                    }
                }
            }
            if (successfulRecovery || !this.waitBetweenRecoveries(core.getName())) continue;
        }
        if (RecoveryStrategy.log.isInfoEnabled()) {
            RecoveryStrategy.log.info("Finished recovery process, successful=[{}] msTimeTaken={}", (Object)successfulRecovery, (Object)timer.getTime());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Replica pingLeader(String ourUrl, CoreDescriptor coreDesc, boolean mayPutReplicaAsDown) throws Exception {
        int numTried = 0;
        while (true) {
            Replica replica;
            CloudDescriptor cloudDesc = coreDesc.getCloudDescriptor();
            DocCollection docCollection = this.zkStateReader.getClusterState().getCollection(cloudDesc.getCollectionName());
            if (!this.isClosed() && mayPutReplicaAsDown && numTried == 1 && docCollection.getReplica(coreDesc.getCloudDescriptor().getCoreNodeName()).getState() == Replica.State.ACTIVE) {
                this.zkController.publish(coreDesc, Replica.State.DOWN);
            }
            ++numTried;
            if (this.isClosed()) {
                return null;
            }
            Replica leaderReplica = null;
            try {
                leaderReplica = this.zkStateReader.getLeaderRetry(cloudDesc.getCollectionName(), cloudDesc.getShardId());
            }
            catch (SolrException solrException) {
                // empty catch block
            }
            if (leaderReplica == null) {
                Thread.sleep(500L);
                continue;
            }
            if (leaderReplica.getCoreUrl().equals(ourUrl)) {
                return leaderReplica;
            }
            Http2SolrClient httpSolrClient = this.recoverySolrClientBuilder(leaderReplica.getBaseUrl(), leaderReplica.getCoreName()).build();
            try {
                httpSolrClient.ping();
                replica = leaderReplica;
                if (httpSolrClient == null) return replica;
            }
            catch (Throwable throwable) {
                try {
                    if (httpSolrClient == null) throw throwable;
                    try {
                        httpSolrClient.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("Failed to connect leader {} on recovery, try again", (Object)leaderReplica.getBaseUrl());
                    Thread.sleep(500L);
                }
                catch (Exception e) {
                    if (!(e.getCause() instanceof IOException)) return leaderReplica;
                    log.error("Failed to connect leader {} on recovery, try again", (Object)leaderReplica.getBaseUrl());
                    Thread.sleep(500L);
                }
            }
            httpSolrClient.close();
            return replica;
        }
    }

    private final Future<UpdateLog.RecoveryInfo> replay(SolrCore core) throws InterruptedException, ExecutionException {
        if (testing_beforeReplayBufferingUpdates != null) {
            testing_beforeReplayBufferingUpdates.run();
        }
        if (this.replicaType == Replica.Type.TLOG) {
            LocalSolrQueryRequest req = new LocalSolrQueryRequest(core, (SolrParams)new ModifiableSolrParams());
            core.getUpdateHandler().getUpdateLog().copyOverBufferingUpdates(new CommitUpdateCommand(req, false));
            req.close();
            return null;
        }
        Future<UpdateLog.RecoveryInfo> future = core.getUpdateHandler().getUpdateLog().applyBufferedUpdates();
        if (future == null) {
            log.info("No replay needed.");
        } else {
            log.info("Replaying buffered documents.");
            UpdateLog.RecoveryInfo report = future.get();
            if (report.failed) {
                log.error("Replay failed");
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Replay failed");
            }
        }
        core.getUpdateHandler().getUpdateLog().openRealtimeSearcher();
        this.cloudDebugLog(core, "replayed");
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cloudDebugLog(SolrCore core, String op) {
        if (!log.isDebugEnabled()) {
            return;
        }
        try {
            RefCounted<SolrIndexSearcher> searchHolder = core.getNewestSearcher(false);
            SolrIndexSearcher searcher = searchHolder.get();
            try {
                int totalHits = searcher.count((Query)new MatchAllDocsQuery());
                String nodeName = core.getCoreContainer().getZkController().getNodeName();
                log.debug("[{}] {} [{} total hits]", new Object[]{nodeName, op, totalHits});
            }
            finally {
                searchHolder.decref();
            }
        }
        catch (Exception e) {
            log.debug("Error in solrcloud_debug block", (Throwable)e);
        }
    }

    public final boolean isClosed() {
        return this.close || this.cc.isShutDown();
    }

    private final void sendPrepRecoveryCmd(String leaderBaseUrl, String leaderCoreName, Slice slice) throws SolrServerException, IOException, InterruptedException, ExecutionException {
        CoreAdminRequest.WaitForState prepCmd = new CoreAdminRequest.WaitForState();
        prepCmd.setCoreName(leaderCoreName);
        prepCmd.setNodeName(this.zkController.getNodeName());
        prepCmd.setCoreNodeName(this.coreZkNodeName);
        prepCmd.setState(Replica.State.RECOVERING);
        prepCmd.setCheckLive(Boolean.valueOf(true));
        prepCmd.setOnlyIfLeader(true);
        Slice.State state = slice.getState();
        if (state != Slice.State.CONSTRUCTION && state != Slice.State.RECOVERY && state != Slice.State.RECOVERY_FAILED) {
            prepCmd.setOnlyIfLeaderActive(true);
        }
        int conflictWaitMs = this.zkController.getLeaderConflictResolveWait();
        int readTimeout = conflictWaitMs + Integer.parseInt(System.getProperty("prepRecoveryReadTimeoutExtraWait", "8000"));
        try (Http2SolrClient client = ((Http2SolrClient.Builder)this.recoverySolrClientBuilder(leaderBaseUrl, null).withIdleTimeout((long)readTimeout, TimeUnit.MILLISECONDS)).build();){
            this.prevSendPreRecoveryHttpUriRequest = new FutureTask<NamedList>(() -> RecoveryStrategy.lambda$sendPrepRecoveryCmd$0((SolrClient)client, prepCmd));
            log.info("Sending prep recovery command to [{}]; [{}]", (Object)leaderBaseUrl, (Object)prepCmd);
            this.prevSendPreRecoveryHttpUriRequest.run();
        }
    }

    private void cancelPrepRecoveryCmd() {
        Optional.ofNullable(this.prevSendPreRecoveryHttpUriRequest).ifPresent(req -> req.cancel(true));
    }

    private static /* synthetic */ NamedList lambda$sendPrepRecoveryCmd$0(SolrClient client, CoreAdminRequest.WaitForState prepCmd) throws Exception {
        return client.request((SolrRequest)prepCmd);
    }

    public static interface RecoveryListener {
        public void recovered();

        public void failed();
    }

    public static class Builder
    implements NamedListInitializedPlugin {
        private NamedList<?> args;

        @Override
        public void init(NamedList<?> args) {
            this.args = args;
        }

        public RecoveryStrategy create(CoreContainer cc, CoreDescriptor cd, RecoveryListener recoveryListener) {
            RecoveryStrategy recoveryStrategy = this.newRecoveryStrategy(cc, cd, recoveryListener);
            SolrPluginUtils.invokeSetters(recoveryStrategy, this.args);
            return recoveryStrategy;
        }

        protected RecoveryStrategy newRecoveryStrategy(CoreContainer cc, CoreDescriptor cd, RecoveryListener recoveryListener) {
            return new RecoveryStrategy(cc, cd, recoveryListener);
        }
    }
}

