/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import org.apache.sis.internal.storage.io.InputStreamAdapter;
import org.apache.sis.io.InvalidSeekException;
import org.apache.sis.util.resources.Errors;

public final class RewindableLineReader
extends LineNumberReader {
    public static final int BUFFER_SIZE = 8192;
    private InputStreamAdapter input;
    private final Charset encoding;
    private boolean isMarkProtected;

    public RewindableLineReader(InputStream inputStream, Charset charset) throws IOException {
        super(charset != null ? new InputStreamReader(inputStream, charset) : new InputStreamReader(inputStream), 8192);
        if (inputStream instanceof InputStreamAdapter) {
            this.input = (InputStreamAdapter)inputStream;
        }
        this.encoding = charset;
        this.lock = inputStream;
        super.mark(8192);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RewindableLineReader rewind() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                super.reset();
                return this;
            }
            catch (IOException iOException) {
                InputStreamAdapter inputStreamAdapter = this.input;
                if (inputStreamAdapter == null) {
                    throw new InvalidSeekException();
                }
                this.input = null;
                assert (Thread.holdsLock(inputStreamAdapter));
                try {
                    inputStreamAdapter.keepOpen = true;
                    super.close();
                }
                finally {
                    inputStreamAdapter.keepOpen = false;
                }
                try {
                    inputStreamAdapter.input.seek(0L);
                }
                catch (IOException iOException2) {
                    iOException2.addSuppressed(iOException);
                    throw iOException2;
                }
                return new RewindableLineReader(inputStreamAdapter, this.encoding);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void protectedMark() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            super.mark(8192);
            this.isMarkProtected = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void protectedReset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.isMarkProtected = false;
            super.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean markSupported() {
        Object object = this.lock;
        synchronized (object) {
            return !this.isMarkProtected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isMarkProtected) {
                throw new IOException(Errors.format((short)162, "mark"));
            }
            super.mark(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isMarkProtected) {
                throw new IOException(Errors.format((short)162, "reset"));
            }
            super.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.input = null;
            if (this.isMarkProtected) {
                super.reset();
            } else {
                super.close();
            }
        }
    }
}

