/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.field;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.analytics.function.field.AnalyticsField;
import org.apache.solr.analytics.util.function.FloatConsumer;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.legacy.LegacyNumericUtils;

@Deprecated
public class FloatMultiTrieField
extends AnalyticsField
implements FloatValueStream.CastingFloatValueStream {
    private SortedSetDocValues docValues;
    private int count = 0;
    private float[] values = new float[20];

    public FloatMultiTrieField(String fieldName) {
        super(fieldName);
    }

    @Override
    public void doSetNextReader(LeafReaderContext context) throws IOException {
        this.docValues = DocValues.getSortedSet((LeafReader)context.reader(), (String)this.fieldName);
    }

    @Override
    public void collect(int doc) throws IOException {
        this.count = 0;
        if (this.docValues.advanceExact(doc)) {
            int term;
            while ((long)(term = (int)this.docValues.nextOrd()) != -1L) {
                if (this.count == this.values.length) {
                    this.resizeValues();
                }
                this.values[this.count++] = NumericUtils.sortableIntToFloat((int)LegacyNumericUtils.prefixCodedToInt((BytesRef)this.docValues.lookupOrd((long)term)));
            }
        }
    }

    private void resizeValues() {
        float[] newValues = new float[this.values.length * 2];
        for (int i = 0; i < this.count; ++i) {
            newValues[i] = this.values[i];
        }
        this.values = newValues;
    }

    @Override
    public void streamFloats(FloatConsumer cons) {
        for (int i = 0; i < this.count; ++i) {
            cons.accept(this.values[i]);
        }
    }

    @Override
    public void streamDoubles(DoubleConsumer cons) {
        this.streamFloats(value -> cons.accept(value));
    }

    @Override
    public void streamStrings(Consumer<String> cons) {
        this.streamFloats(value -> cons.accept(Float.toString(value)));
    }

    @Override
    public void streamObjects(Consumer<Object> cons) {
        this.streamFloats(value -> cons.accept(Float.valueOf(value)));
    }
}

