/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.knn;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.ExpandWildcard;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.SearchType;
import org.opensearch.client.opensearch._types.SuggestMode;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch._types.query_dsl.Operator;
import org.opensearch.client.opensearch.knn.SearchModelsResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class SearchModelsRequest
extends RequestBase
implements ToCopyableBuilder<Builder, SearchModelsRequest> {
    @Nullable
    private final Boolean allowNoIndices;
    @Nullable
    private final Boolean allowPartialSearchResults;
    @Nullable
    private final Boolean analyzeWildcard;
    @Nullable
    private final String analyzer;
    @Nullable
    private final Integer batchedReduceSize;
    @Nullable
    private final Boolean ccsMinimizeRoundtrips;
    @Nullable
    private final Operator defaultOperator;
    @Nullable
    private final String df;
    @Nonnull
    private final List<String> docvalueFields;
    @Nonnull
    private final List<ExpandWildcard> expandWildcards;
    @Nullable
    private final Boolean explain;
    @Nullable
    private final Integer from;
    @Nullable
    private final Boolean ignoreThrottled;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nullable
    private final Boolean lenient;
    @Nullable
    private final Integer maxConcurrentShardRequests;
    @Nullable
    private final Integer preFilterShardSize;
    @Nullable
    private final String preference;
    @Nullable
    private final String q;
    @Nullable
    private final Boolean requestCache;
    @Nullable
    private final Boolean restTotalHitsAsInt;
    @Nonnull
    private final List<String> routing;
    @Nullable
    private final Time scroll;
    @Nullable
    private final SearchType searchType;
    @Nullable
    private final Boolean seqNoPrimaryTerm;
    @Nullable
    private final Integer size;
    @Nonnull
    private final List<String> sort;
    @Nonnull
    private final List<String> source;
    @Nonnull
    private final List<String> sourceExcludes;
    @Nonnull
    private final List<String> sourceIncludes;
    @Nonnull
    private final List<String> stats;
    @Nonnull
    private final List<String> storedFields;
    @Nullable
    private final String suggestField;
    @Nullable
    private final SuggestMode suggestMode;
    @Nullable
    private final Integer suggestSize;
    @Nullable
    private final String suggestText;
    @Nullable
    private final Integer terminateAfter;
    @Nullable
    private final Time timeout;
    @Nullable
    private final Boolean trackScores;
    @Nullable
    private final Boolean trackTotalHits;
    @Nullable
    private final Boolean version;
    public static final Endpoint<SearchModelsRequest, SearchModelsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<SearchModelsRequest, SearchModelsResponse>(request -> "POST", request -> "/_plugins/_knn/models/_search", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, SearchModelsResponse._DESERIALIZER);

    private SearchModelsRequest(Builder builder) {
        super(builder);
        this.allowNoIndices = builder.allowNoIndices;
        this.allowPartialSearchResults = builder.allowPartialSearchResults;
        this.analyzeWildcard = builder.analyzeWildcard;
        this.analyzer = builder.analyzer;
        this.batchedReduceSize = builder.batchedReduceSize;
        this.ccsMinimizeRoundtrips = builder.ccsMinimizeRoundtrips;
        this.defaultOperator = builder.defaultOperator;
        this.df = builder.df;
        this.docvalueFields = ApiTypeHelper.unmodifiable(builder.docvalueFields);
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.explain = builder.explain;
        this.from = builder.from;
        this.ignoreThrottled = builder.ignoreThrottled;
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.lenient = builder.lenient;
        this.maxConcurrentShardRequests = builder.maxConcurrentShardRequests;
        this.preFilterShardSize = builder.preFilterShardSize;
        this.preference = builder.preference;
        this.q = builder.q;
        this.requestCache = builder.requestCache;
        this.restTotalHitsAsInt = builder.restTotalHitsAsInt;
        this.routing = ApiTypeHelper.unmodifiable(builder.routing);
        this.scroll = builder.scroll;
        this.searchType = builder.searchType;
        this.seqNoPrimaryTerm = builder.seqNoPrimaryTerm;
        this.size = builder.size;
        this.sort = ApiTypeHelper.unmodifiable(builder.sort);
        this.source = ApiTypeHelper.unmodifiable(builder.source);
        this.sourceExcludes = ApiTypeHelper.unmodifiable(builder.sourceExcludes);
        this.sourceIncludes = ApiTypeHelper.unmodifiable(builder.sourceIncludes);
        this.stats = ApiTypeHelper.unmodifiable(builder.stats);
        this.storedFields = ApiTypeHelper.unmodifiable(builder.storedFields);
        this.suggestField = builder.suggestField;
        this.suggestMode = builder.suggestMode;
        this.suggestSize = builder.suggestSize;
        this.suggestText = builder.suggestText;
        this.terminateAfter = builder.terminateAfter;
        this.timeout = builder.timeout;
        this.trackScores = builder.trackScores;
        this.trackTotalHits = builder.trackTotalHits;
        this.version = builder.version;
    }

    public static SearchModelsRequest of(Function<Builder, ObjectBuilder<SearchModelsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    @Nullable
    public final Boolean allowPartialSearchResults() {
        return this.allowPartialSearchResults;
    }

    @Nullable
    public final Boolean analyzeWildcard() {
        return this.analyzeWildcard;
    }

    @Nullable
    public final String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public final Integer batchedReduceSize() {
        return this.batchedReduceSize;
    }

    @Nullable
    public final Boolean ccsMinimizeRoundtrips() {
        return this.ccsMinimizeRoundtrips;
    }

    @Nullable
    public final Operator defaultOperator() {
        return this.defaultOperator;
    }

    @Nullable
    public final String df() {
        return this.df;
    }

    @Nonnull
    public final List<String> docvalueFields() {
        return this.docvalueFields;
    }

    @Nonnull
    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public final Boolean explain() {
        return this.explain;
    }

    @Nullable
    public final Integer from() {
        return this.from;
    }

    @Nullable
    public final Boolean ignoreThrottled() {
        return this.ignoreThrottled;
    }

    @Nullable
    public final Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nullable
    public final Boolean lenient() {
        return this.lenient;
    }

    @Nullable
    public final Integer maxConcurrentShardRequests() {
        return this.maxConcurrentShardRequests;
    }

    @Nullable
    public final Integer preFilterShardSize() {
        return this.preFilterShardSize;
    }

    @Nullable
    public final String preference() {
        return this.preference;
    }

    @Nullable
    public final String q() {
        return this.q;
    }

    @Nullable
    public final Boolean requestCache() {
        return this.requestCache;
    }

    @Nullable
    public final Boolean restTotalHitsAsInt() {
        return this.restTotalHitsAsInt;
    }

    @Nonnull
    public final List<String> routing() {
        return this.routing;
    }

    @Nullable
    public final Time scroll() {
        return this.scroll;
    }

    @Nullable
    public final SearchType searchType() {
        return this.searchType;
    }

    @Nullable
    public final Boolean seqNoPrimaryTerm() {
        return this.seqNoPrimaryTerm;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nonnull
    public final List<String> sort() {
        return this.sort;
    }

    @Nonnull
    public final List<String> source() {
        return this.source;
    }

    @Nonnull
    public final List<String> sourceExcludes() {
        return this.sourceExcludes;
    }

    @Nonnull
    public final List<String> sourceIncludes() {
        return this.sourceIncludes;
    }

    @Nonnull
    public final List<String> stats() {
        return this.stats;
    }

    @Nonnull
    public final List<String> storedFields() {
        return this.storedFields;
    }

    @Nullable
    public final String suggestField() {
        return this.suggestField;
    }

    @Nullable
    public final SuggestMode suggestMode() {
        return this.suggestMode;
    }

    @Nullable
    public final Integer suggestSize() {
        return this.suggestSize;
    }

    @Nullable
    public final String suggestText() {
        return this.suggestText;
    }

    @Nullable
    public final Integer terminateAfter() {
        return this.terminateAfter;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Nullable
    public final Boolean trackScores() {
        return this.trackScores;
    }

    @Nullable
    public final Boolean trackTotalHits() {
        return this.trackTotalHits;
    }

    @Nullable
    public final Boolean version() {
        return this.version;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        params.put("typed_keys", "true");
        if (this.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(this.allowNoIndices));
        }
        if (this.allowPartialSearchResults != null) {
            params.put("allow_partial_search_results", String.valueOf(this.allowPartialSearchResults));
        }
        if (this.analyzeWildcard != null) {
            params.put("analyze_wildcard", String.valueOf(this.analyzeWildcard));
        }
        if (this.analyzer != null) {
            params.put("analyzer", this.analyzer);
        }
        if (this.batchedReduceSize != null) {
            params.put("batched_reduce_size", String.valueOf(this.batchedReduceSize));
        }
        if (this.ccsMinimizeRoundtrips != null) {
            params.put("ccs_minimize_roundtrips", String.valueOf(this.ccsMinimizeRoundtrips));
        }
        if (this.defaultOperator != null) {
            params.put("default_operator", this.defaultOperator.jsonValue());
        }
        if (this.df != null) {
            params.put("df", this.df);
        }
        if (ApiTypeHelper.isDefined(this.docvalueFields)) {
            params.put("docvalue_fields", String.join((CharSequence)",", this.docvalueFields));
        }
        if (ApiTypeHelper.isDefined(this.expandWildcards)) {
            params.put("expand_wildcards", this.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (this.explain != null) {
            params.put("explain", String.valueOf(this.explain));
        }
        if (this.from != null) {
            params.put("from", String.valueOf(this.from));
        }
        if (this.ignoreThrottled != null) {
            params.put("ignore_throttled", String.valueOf(this.ignoreThrottled));
        }
        if (this.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(this.ignoreUnavailable));
        }
        if (this.lenient != null) {
            params.put("lenient", String.valueOf(this.lenient));
        }
        if (this.maxConcurrentShardRequests != null) {
            params.put("max_concurrent_shard_requests", String.valueOf(this.maxConcurrentShardRequests));
        }
        if (this.preFilterShardSize != null) {
            params.put("pre_filter_shard_size", String.valueOf(this.preFilterShardSize));
        }
        if (this.preference != null) {
            params.put("preference", this.preference);
        }
        if (this.q != null) {
            params.put("q", this.q);
        }
        if (this.requestCache != null) {
            params.put("request_cache", String.valueOf(this.requestCache));
        }
        if (this.restTotalHitsAsInt != null) {
            params.put("rest_total_hits_as_int", String.valueOf(this.restTotalHitsAsInt));
        }
        if (ApiTypeHelper.isDefined(this.routing)) {
            params.put("routing", String.join((CharSequence)",", this.routing));
        }
        if (this.scroll != null) {
            params.put("scroll", this.scroll._toJsonString());
        }
        if (this.searchType != null) {
            params.put("search_type", this.searchType.jsonValue());
        }
        if (this.seqNoPrimaryTerm != null) {
            params.put("seq_no_primary_term", String.valueOf(this.seqNoPrimaryTerm));
        }
        if (this.size != null) {
            params.put("size", String.valueOf(this.size));
        }
        if (ApiTypeHelper.isDefined(this.sort)) {
            params.put("sort", String.join((CharSequence)",", this.sort));
        }
        if (ApiTypeHelper.isDefined(this.source)) {
            params.put("_source", String.join((CharSequence)",", this.source));
        }
        if (ApiTypeHelper.isDefined(this.sourceExcludes)) {
            params.put("_source_excludes", String.join((CharSequence)",", this.sourceExcludes));
        }
        if (ApiTypeHelper.isDefined(this.sourceIncludes)) {
            params.put("_source_includes", String.join((CharSequence)",", this.sourceIncludes));
        }
        if (ApiTypeHelper.isDefined(this.stats)) {
            params.put("stats", String.join((CharSequence)",", this.stats));
        }
        if (ApiTypeHelper.isDefined(this.storedFields)) {
            params.put("stored_fields", String.join((CharSequence)",", this.storedFields));
        }
        if (this.suggestField != null) {
            params.put("suggest_field", this.suggestField);
        }
        if (this.suggestMode != null) {
            params.put("suggest_mode", this.suggestMode.jsonValue());
        }
        if (this.suggestSize != null) {
            params.put("suggest_size", String.valueOf(this.suggestSize));
        }
        if (this.suggestText != null) {
            params.put("suggest_text", this.suggestText);
        }
        if (this.terminateAfter != null) {
            params.put("terminate_after", String.valueOf(this.terminateAfter));
        }
        if (this.timeout != null) {
            params.put("timeout", this.timeout._toJsonString());
        }
        if (this.trackScores != null) {
            params.put("track_scores", String.valueOf(this.trackScores));
        }
        if (this.trackTotalHits != null) {
            params.put("track_total_hits", String.valueOf(this.trackTotalHits));
        }
        if (this.version != null) {
            params.put("version", String.valueOf(this.version));
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.allowNoIndices);
        result = 31 * result + Objects.hashCode(this.allowPartialSearchResults);
        result = 31 * result + Objects.hashCode(this.analyzeWildcard);
        result = 31 * result + Objects.hashCode(this.analyzer);
        result = 31 * result + Objects.hashCode(this.batchedReduceSize);
        result = 31 * result + Objects.hashCode(this.ccsMinimizeRoundtrips);
        result = 31 * result + Objects.hashCode(this.defaultOperator);
        result = 31 * result + Objects.hashCode(this.df);
        result = 31 * result + Objects.hashCode(this.docvalueFields);
        result = 31 * result + Objects.hashCode(this.expandWildcards);
        result = 31 * result + Objects.hashCode(this.explain);
        result = 31 * result + Objects.hashCode(this.from);
        result = 31 * result + Objects.hashCode(this.ignoreThrottled);
        result = 31 * result + Objects.hashCode(this.ignoreUnavailable);
        result = 31 * result + Objects.hashCode(this.lenient);
        result = 31 * result + Objects.hashCode(this.maxConcurrentShardRequests);
        result = 31 * result + Objects.hashCode(this.preFilterShardSize);
        result = 31 * result + Objects.hashCode(this.preference);
        result = 31 * result + Objects.hashCode(this.q);
        result = 31 * result + Objects.hashCode(this.requestCache);
        result = 31 * result + Objects.hashCode(this.restTotalHitsAsInt);
        result = 31 * result + Objects.hashCode(this.routing);
        result = 31 * result + Objects.hashCode(this.scroll);
        result = 31 * result + Objects.hashCode(this.searchType);
        result = 31 * result + Objects.hashCode(this.seqNoPrimaryTerm);
        result = 31 * result + Objects.hashCode(this.size);
        result = 31 * result + Objects.hashCode(this.sort);
        result = 31 * result + Objects.hashCode(this.source);
        result = 31 * result + Objects.hashCode(this.sourceExcludes);
        result = 31 * result + Objects.hashCode(this.sourceIncludes);
        result = 31 * result + Objects.hashCode(this.stats);
        result = 31 * result + Objects.hashCode(this.storedFields);
        result = 31 * result + Objects.hashCode(this.suggestField);
        result = 31 * result + Objects.hashCode(this.suggestMode);
        result = 31 * result + Objects.hashCode(this.suggestSize);
        result = 31 * result + Objects.hashCode(this.suggestText);
        result = 31 * result + Objects.hashCode(this.terminateAfter);
        result = 31 * result + Objects.hashCode(this.timeout);
        result = 31 * result + Objects.hashCode(this.trackScores);
        result = 31 * result + Objects.hashCode(this.trackTotalHits);
        result = 31 * result + Objects.hashCode(this.version);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchModelsRequest other = (SearchModelsRequest)o;
        return Objects.equals(this.allowNoIndices, other.allowNoIndices) && Objects.equals(this.allowPartialSearchResults, other.allowPartialSearchResults) && Objects.equals(this.analyzeWildcard, other.analyzeWildcard) && Objects.equals(this.analyzer, other.analyzer) && Objects.equals(this.batchedReduceSize, other.batchedReduceSize) && Objects.equals(this.ccsMinimizeRoundtrips, other.ccsMinimizeRoundtrips) && Objects.equals(this.defaultOperator, other.defaultOperator) && Objects.equals(this.df, other.df) && Objects.equals(this.docvalueFields, other.docvalueFields) && Objects.equals(this.expandWildcards, other.expandWildcards) && Objects.equals(this.explain, other.explain) && Objects.equals(this.from, other.from) && Objects.equals(this.ignoreThrottled, other.ignoreThrottled) && Objects.equals(this.ignoreUnavailable, other.ignoreUnavailable) && Objects.equals(this.lenient, other.lenient) && Objects.equals(this.maxConcurrentShardRequests, other.maxConcurrentShardRequests) && Objects.equals(this.preFilterShardSize, other.preFilterShardSize) && Objects.equals(this.preference, other.preference) && Objects.equals(this.q, other.q) && Objects.equals(this.requestCache, other.requestCache) && Objects.equals(this.restTotalHitsAsInt, other.restTotalHitsAsInt) && Objects.equals(this.routing, other.routing) && Objects.equals(this.scroll, other.scroll) && Objects.equals(this.searchType, other.searchType) && Objects.equals(this.seqNoPrimaryTerm, other.seqNoPrimaryTerm) && Objects.equals(this.size, other.size) && Objects.equals(this.sort, other.sort) && Objects.equals(this.source, other.source) && Objects.equals(this.sourceExcludes, other.sourceExcludes) && Objects.equals(this.sourceIncludes, other.sourceIncludes) && Objects.equals(this.stats, other.stats) && Objects.equals(this.storedFields, other.storedFields) && Objects.equals(this.suggestField, other.suggestField) && Objects.equals(this.suggestMode, other.suggestMode) && Objects.equals(this.suggestSize, other.suggestSize) && Objects.equals(this.suggestText, other.suggestText) && Objects.equals(this.terminateAfter, other.terminateAfter) && Objects.equals(this.timeout, other.timeout) && Objects.equals(this.trackScores, other.trackScores) && Objects.equals(this.trackTotalHits, other.trackTotalHits) && Objects.equals(this.version, other.version);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, SearchModelsRequest> {
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private Boolean allowPartialSearchResults;
        @Nullable
        private Boolean analyzeWildcard;
        @Nullable
        private String analyzer;
        @Nullable
        private Integer batchedReduceSize;
        @Nullable
        private Boolean ccsMinimizeRoundtrips;
        @Nullable
        private Operator defaultOperator;
        @Nullable
        private String df;
        @Nullable
        private List<String> docvalueFields;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private Boolean explain;
        @Nullable
        private Integer from;
        @Nullable
        private Boolean ignoreThrottled;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private Boolean lenient;
        @Nullable
        private Integer maxConcurrentShardRequests;
        @Nullable
        private Integer preFilterShardSize;
        @Nullable
        private String preference;
        @Nullable
        private String q;
        @Nullable
        private Boolean requestCache;
        @Nullable
        private Boolean restTotalHitsAsInt;
        @Nullable
        private List<String> routing;
        @Nullable
        private Time scroll;
        @Nullable
        private SearchType searchType;
        @Nullable
        private Boolean seqNoPrimaryTerm;
        @Nullable
        private Integer size;
        @Nullable
        private List<String> sort;
        @Nullable
        private List<String> source;
        @Nullable
        private List<String> sourceExcludes;
        @Nullable
        private List<String> sourceIncludes;
        @Nullable
        private List<String> stats;
        @Nullable
        private List<String> storedFields;
        @Nullable
        private String suggestField;
        @Nullable
        private SuggestMode suggestMode;
        @Nullable
        private Integer suggestSize;
        @Nullable
        private String suggestText;
        @Nullable
        private Integer terminateAfter;
        @Nullable
        private Time timeout;
        @Nullable
        private Boolean trackScores;
        @Nullable
        private Boolean trackTotalHits;
        @Nullable
        private Boolean version;

        public Builder() {
        }

        private Builder(SearchModelsRequest o) {
            super(o);
            this.allowNoIndices = o.allowNoIndices;
            this.allowPartialSearchResults = o.allowPartialSearchResults;
            this.analyzeWildcard = o.analyzeWildcard;
            this.analyzer = o.analyzer;
            this.batchedReduceSize = o.batchedReduceSize;
            this.ccsMinimizeRoundtrips = o.ccsMinimizeRoundtrips;
            this.defaultOperator = o.defaultOperator;
            this.df = o.df;
            this.docvalueFields = Builder._listCopy(o.docvalueFields);
            this.expandWildcards = Builder._listCopy(o.expandWildcards);
            this.explain = o.explain;
            this.from = o.from;
            this.ignoreThrottled = o.ignoreThrottled;
            this.ignoreUnavailable = o.ignoreUnavailable;
            this.lenient = o.lenient;
            this.maxConcurrentShardRequests = o.maxConcurrentShardRequests;
            this.preFilterShardSize = o.preFilterShardSize;
            this.preference = o.preference;
            this.q = o.q;
            this.requestCache = o.requestCache;
            this.restTotalHitsAsInt = o.restTotalHitsAsInt;
            this.routing = Builder._listCopy(o.routing);
            this.scroll = o.scroll;
            this.searchType = o.searchType;
            this.seqNoPrimaryTerm = o.seqNoPrimaryTerm;
            this.size = o.size;
            this.sort = Builder._listCopy(o.sort);
            this.source = Builder._listCopy(o.source);
            this.sourceExcludes = Builder._listCopy(o.sourceExcludes);
            this.sourceIncludes = Builder._listCopy(o.sourceIncludes);
            this.stats = Builder._listCopy(o.stats);
            this.storedFields = Builder._listCopy(o.storedFields);
            this.suggestField = o.suggestField;
            this.suggestMode = o.suggestMode;
            this.suggestSize = o.suggestSize;
            this.suggestText = o.suggestText;
            this.terminateAfter = o.terminateAfter;
            this.timeout = o.timeout;
            this.trackScores = o.trackScores;
            this.trackTotalHits = o.trackTotalHits;
            this.version = o.version;
        }

        private Builder(Builder o) {
            super(o);
            this.allowNoIndices = o.allowNoIndices;
            this.allowPartialSearchResults = o.allowPartialSearchResults;
            this.analyzeWildcard = o.analyzeWildcard;
            this.analyzer = o.analyzer;
            this.batchedReduceSize = o.batchedReduceSize;
            this.ccsMinimizeRoundtrips = o.ccsMinimizeRoundtrips;
            this.defaultOperator = o.defaultOperator;
            this.df = o.df;
            this.docvalueFields = Builder._listCopy(o.docvalueFields);
            this.expandWildcards = Builder._listCopy(o.expandWildcards);
            this.explain = o.explain;
            this.from = o.from;
            this.ignoreThrottled = o.ignoreThrottled;
            this.ignoreUnavailable = o.ignoreUnavailable;
            this.lenient = o.lenient;
            this.maxConcurrentShardRequests = o.maxConcurrentShardRequests;
            this.preFilterShardSize = o.preFilterShardSize;
            this.preference = o.preference;
            this.q = o.q;
            this.requestCache = o.requestCache;
            this.restTotalHitsAsInt = o.restTotalHitsAsInt;
            this.routing = Builder._listCopy(o.routing);
            this.scroll = o.scroll;
            this.searchType = o.searchType;
            this.seqNoPrimaryTerm = o.seqNoPrimaryTerm;
            this.size = o.size;
            this.sort = Builder._listCopy(o.sort);
            this.source = Builder._listCopy(o.source);
            this.sourceExcludes = Builder._listCopy(o.sourceExcludes);
            this.sourceIncludes = Builder._listCopy(o.sourceIncludes);
            this.stats = Builder._listCopy(o.stats);
            this.storedFields = Builder._listCopy(o.storedFields);
            this.suggestField = o.suggestField;
            this.suggestMode = o.suggestMode;
            this.suggestSize = o.suggestSize;
            this.suggestText = o.suggestText;
            this.terminateAfter = o.terminateAfter;
            this.timeout = o.timeout;
            this.trackScores = o.trackScores;
            this.trackTotalHits = o.trackTotalHits;
            this.version = o.version;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        @Nonnull
        public final Builder allowPartialSearchResults(@Nullable Boolean value) {
            this.allowPartialSearchResults = value;
            return this;
        }

        @Nonnull
        public final Builder analyzeWildcard(@Nullable Boolean value) {
            this.analyzeWildcard = value;
            return this;
        }

        @Nonnull
        public final Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        @Nonnull
        public final Builder batchedReduceSize(@Nullable Integer value) {
            this.batchedReduceSize = value;
            return this;
        }

        @Nonnull
        public final Builder ccsMinimizeRoundtrips(@Nullable Boolean value) {
            this.ccsMinimizeRoundtrips = value;
            return this;
        }

        @Nonnull
        public final Builder defaultOperator(@Nullable Operator value) {
            this.defaultOperator = value;
            return this;
        }

        @Nonnull
        public final Builder df(@Nullable String value) {
            this.df = value;
            return this;
        }

        @Nonnull
        public final Builder docvalueFields(List<String> list) {
            this.docvalueFields = Builder._listAddAll(this.docvalueFields, list);
            return this;
        }

        @Nonnull
        public final Builder docvalueFields(String value, String ... values) {
            this.docvalueFields = Builder._listAdd(this.docvalueFields, value, values);
            return this;
        }

        @Nonnull
        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        @Nonnull
        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        @Nonnull
        public final Builder explain(@Nullable Boolean value) {
            this.explain = value;
            return this;
        }

        @Nonnull
        public final Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        @Nonnull
        public final Builder ignoreThrottled(@Nullable Boolean value) {
            this.ignoreThrottled = value;
            return this;
        }

        @Nonnull
        public final Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        @Nonnull
        public final Builder lenient(@Nullable Boolean value) {
            this.lenient = value;
            return this;
        }

        @Nonnull
        public final Builder maxConcurrentShardRequests(@Nullable Integer value) {
            this.maxConcurrentShardRequests = value;
            return this;
        }

        @Nonnull
        public final Builder preFilterShardSize(@Nullable Integer value) {
            this.preFilterShardSize = value;
            return this;
        }

        @Nonnull
        public final Builder preference(@Nullable String value) {
            this.preference = value;
            return this;
        }

        @Nonnull
        public final Builder q(@Nullable String value) {
            this.q = value;
            return this;
        }

        @Nonnull
        public final Builder requestCache(@Nullable Boolean value) {
            this.requestCache = value;
            return this;
        }

        @Nonnull
        public final Builder restTotalHitsAsInt(@Nullable Boolean value) {
            this.restTotalHitsAsInt = value;
            return this;
        }

        @Nonnull
        public final Builder routing(List<String> list) {
            this.routing = Builder._listAddAll(this.routing, list);
            return this;
        }

        @Nonnull
        public final Builder routing(String value, String ... values) {
            this.routing = Builder._listAdd(this.routing, value, values);
            return this;
        }

        @Nonnull
        public final Builder scroll(@Nullable Time value) {
            this.scroll = value;
            return this;
        }

        @Nonnull
        public final Builder scroll(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.scroll(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder searchType(@Nullable SearchType value) {
            this.searchType = value;
            return this;
        }

        @Nonnull
        public final Builder seqNoPrimaryTerm(@Nullable Boolean value) {
            this.seqNoPrimaryTerm = value;
            return this;
        }

        @Nonnull
        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        @Nonnull
        public final Builder sort(List<String> list) {
            this.sort = Builder._listAddAll(this.sort, list);
            return this;
        }

        @Nonnull
        public final Builder sort(String value, String ... values) {
            this.sort = Builder._listAdd(this.sort, value, values);
            return this;
        }

        @Nonnull
        public final Builder source(List<String> list) {
            this.source = Builder._listAddAll(this.source, list);
            return this;
        }

        @Nonnull
        public final Builder source(String value, String ... values) {
            this.source = Builder._listAdd(this.source, value, values);
            return this;
        }

        @Nonnull
        public final Builder sourceExcludes(List<String> list) {
            this.sourceExcludes = Builder._listAddAll(this.sourceExcludes, list);
            return this;
        }

        @Nonnull
        public final Builder sourceExcludes(String value, String ... values) {
            this.sourceExcludes = Builder._listAdd(this.sourceExcludes, value, values);
            return this;
        }

        @Nonnull
        public final Builder sourceIncludes(List<String> list) {
            this.sourceIncludes = Builder._listAddAll(this.sourceIncludes, list);
            return this;
        }

        @Nonnull
        public final Builder sourceIncludes(String value, String ... values) {
            this.sourceIncludes = Builder._listAdd(this.sourceIncludes, value, values);
            return this;
        }

        @Nonnull
        public final Builder stats(List<String> list) {
            this.stats = Builder._listAddAll(this.stats, list);
            return this;
        }

        @Nonnull
        public final Builder stats(String value, String ... values) {
            this.stats = Builder._listAdd(this.stats, value, values);
            return this;
        }

        @Nonnull
        public final Builder storedFields(List<String> list) {
            this.storedFields = Builder._listAddAll(this.storedFields, list);
            return this;
        }

        @Nonnull
        public final Builder storedFields(String value, String ... values) {
            this.storedFields = Builder._listAdd(this.storedFields, value, values);
            return this;
        }

        @Nonnull
        public final Builder suggestField(@Nullable String value) {
            this.suggestField = value;
            return this;
        }

        @Nonnull
        public final Builder suggestMode(@Nullable SuggestMode value) {
            this.suggestMode = value;
            return this;
        }

        @Nonnull
        public final Builder suggestSize(@Nullable Integer value) {
            this.suggestSize = value;
            return this;
        }

        @Nonnull
        public final Builder suggestText(@Nullable String value) {
            this.suggestText = value;
            return this;
        }

        @Nonnull
        public final Builder terminateAfter(@Nullable Integer value) {
            this.terminateAfter = value;
            return this;
        }

        @Nonnull
        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        @Nonnull
        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder trackScores(@Nullable Boolean value) {
            this.trackScores = value;
            return this;
        }

        @Nonnull
        public final Builder trackTotalHits(@Nullable Boolean value) {
            this.trackTotalHits = value;
            return this;
        }

        @Nonnull
        public final Builder version(@Nullable Boolean value) {
            this.version = value;
            return this;
        }

        @Override
        @Nonnull
        public SearchModelsRequest build() {
            this._checkSingleUse();
            return new SearchModelsRequest(this);
        }
    }
}

