/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.process.AbstractTokenizer;
import java.io.IOException;
import java.io.StreamTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenizerAdapter
extends AbstractTokenizer<String> {
    protected final StreamTokenizer st;
    protected String eolString = "<EOL>";

    public TokenizerAdapter(StreamTokenizer st) {
        this.st = st;
    }

    @Override
    public String getNext() {
        try {
            int nextTok = this.st.nextToken();
            switch (nextTok) {
                case 10: {
                    return this.eolString;
                }
                case -1: {
                    return null;
                }
                case -3: {
                    return this.st.sval;
                }
                case -2: {
                    return Double.toString(this.st.nval);
                }
            }
            char[] t = new char[]{(char)nextTok};
            return new String(t);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public void setEolString(String eolString) {
        if (eolString == null) {
            throw new IllegalArgumentException("eolString cannot be null");
        }
        this.eolString = eolString;
    }

    public boolean isEol(String str) {
        return this.eolString.equals(str);
    }
}

