/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect.pagination;

import java.util.regex.Matcher;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.query.spi.Limit;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.internal.ParameterMarkerStrategyStandard;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;

public class LegacyOracleLimitHandler
extends AbstractLimitHandler {
    private final DatabaseVersion version;

    public LegacyOracleLimitHandler(DatabaseVersion version) {
        this.version = version;
    }

    public String processSql(String sql, Limit limit) {
        return this.processSql(sql, -1, limit, null);
    }

    public String processSql(String sql, int jdbcParameterCount, @Nullable ParameterMarkerStrategy parameterMarkerStrategy, QueryOptions queryOptions) {
        return this.processSql(sql, jdbcParameterCount, queryOptions.getLimit(), parameterMarkerStrategy);
    }

    private String processSql(String sql, int jdbcParameterCount, @Nullable Limit limit, @Nullable ParameterMarkerStrategy parameterMarkerStrategy) {
        boolean hasOffset = LegacyOracleLimitHandler.hasFirstRow((Limit)limit);
        sql = sql.trim();
        String forUpdateClause = null;
        Matcher forUpdateMatcher = this.getForUpdatePattern().matcher(sql);
        if (forUpdateMatcher.find()) {
            int forUpdateIndex = forUpdateMatcher.start();
            forUpdateClause = sql.substring(forUpdateIndex);
            sql = sql.substring(0, forUpdateIndex);
        }
        StringBuilder pagingSelect = new StringBuilder(sql.length() + 100);
        if (ParameterMarkerStrategyStandard.isStandardRenderer((ParameterMarkerStrategy)parameterMarkerStrategy)) {
            if (hasOffset) {
                pagingSelect.append("select * from (select row_.*,rownum rownum_ from (").append(sql);
                if (this.version.isBefore(9)) {
                    pagingSelect.append(") row_) where rownum_<=? and rownum_>?");
                } else {
                    pagingSelect.append(") row_ where rownum<=?) where rownum_>?");
                }
            } else {
                pagingSelect.append("select * from (").append(sql).append(") where rownum<=?");
            }
        } else {
            String firstParameter = parameterMarkerStrategy.createMarker(jdbcParameterCount + 1, null);
            if (hasOffset) {
                String secondParameter = parameterMarkerStrategy.createMarker(jdbcParameterCount + 2, null);
                pagingSelect.append("select * from (select row_.*,rownum rownum_ from (").append(sql);
                if (this.version.isBefore(9)) {
                    pagingSelect.append(") row_) where rownum_<=");
                    pagingSelect.append(firstParameter);
                    pagingSelect.append(" and rownum_>");
                    pagingSelect.append(secondParameter);
                } else {
                    pagingSelect.append(") row_ where rownum<=");
                    pagingSelect.append(firstParameter);
                    pagingSelect.append(") where rownum_>");
                    pagingSelect.append(secondParameter);
                }
            } else {
                pagingSelect.append("select * from (").append(sql).append(") where rownum<=");
                pagingSelect.append(firstParameter);
            }
        }
        if (forUpdateClause != null) {
            pagingSelect.append(forUpdateClause);
        }
        return pagingSelect.toString();
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean supportsOffset() {
        return true;
    }

    public boolean forceLimitUsage() {
        return true;
    }

    public boolean bindLimitParametersInReverseOrder() {
        return true;
    }

    public boolean useMaxForLimit() {
        return true;
    }

    public boolean processSqlMutatesState() {
        return false;
    }
}

