/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.gradle.api.IllegalDependencyNotation;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.capability.CapabilitySelector;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.dsl.ParsedModuleStringNotation;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.project.ProjectIdentity;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.MapKey;
import org.gradle.internal.typeconversion.MapNotationConverter;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypeConversionException;

public class ComponentSelectorParsers {
    private static final NotationParserBuilder<Object, ComponentSelector> BUILDER = NotationParserBuilder.toType(ComponentSelector.class).fromCharSequence((NotationConverter)new StringConverter()).converter((NotationConverter)new MapConverter()).fromType(Project.class, (NotationConverter)new ProjectConverter());

    public static NotationParser<Object, Set<ComponentSelector>> multiParser() {
        return ComponentSelectorParsers.builder().toFlatteningComposite();
    }

    public static NotationParser<Object, ComponentSelector> parser() {
        return ComponentSelectorParsers.builder().toComposite();
    }

    private static NotationParserBuilder<Object, ComponentSelector> builder() {
        return BUILDER;
    }

    static class StringConverter
    implements NotationConverter<String, ComponentSelector> {
        StringConverter() {
        }

        public void describe(DiagnosticsVisitor visitor) {
            visitor.example("String or CharSequence values, e.g. 'org.gradle:gradle-core:1.0'.");
        }

        public void convert(String notation, NotationConvertResult<? super ComponentSelector> result) throws TypeConversionException {
            ParsedModuleStringNotation parsed;
            try {
                parsed = new ParsedModuleStringNotation(notation, null);
            }
            catch (IllegalDependencyNotation e) {
                throw new InvalidUserDataException("Invalid format: '" + notation + "'. The correct notation is a 3-part group:name:version notation, e.g: 'org.gradle:gradle-core:1.0'");
            }
            if (parsed.getGroup() == null || parsed.getName() == null || parsed.getVersion() == null) {
                throw new InvalidUserDataException("Invalid format: '" + notation + "'. Group, name and version cannot be empty. Correct example: 'org.gradle:gradle-core:1.0'");
            }
            result.converted((Object)DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(parsed.getGroup(), parsed.getName()), DefaultImmutableVersionConstraint.of(parsed.getVersion())));
        }
    }

    static class MapConverter
    extends MapNotationConverter<ComponentSelector> {
        MapConverter() {
        }

        public void describe(DiagnosticsVisitor visitor) {
            visitor.example("Maps, e.g. [group: 'org.gradle', name:'gradle-core', version: '1.0'].");
        }

        protected ModuleComponentSelector parseMap(@MapKey(value="group") String group, @MapKey(value="name") String name, @MapKey(value="version") String version) {
            return DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(group, name), DefaultImmutableVersionConstraint.of(version));
        }
    }

    static class ProjectConverter
    implements NotationConverter<Project, ComponentSelector> {
        ProjectConverter() {
        }

        public void describe(DiagnosticsVisitor visitor) {
            visitor.example("Project objects, e.g. project(':api').");
        }

        public void convert(Project notation, NotationConvertResult<? super ComponentSelector> result) throws TypeConversionException {
            ProjectIdentity identity = ((ProjectInternal)notation).getOwner().getIdentity();
            result.converted((Object)new DefaultProjectComponentSelector(identity, ImmutableAttributes.EMPTY, (ImmutableSet<CapabilitySelector>)ImmutableSet.of()));
        }
    }
}

