---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token PyPi upload token'
---

## Description

The response body contains content that matches the pattern of a PyPi upload token was identified. Upload tokens are used for uploading packages for publishing Python packages. A malicious actor with access to this token can upload potentially malicious artifacts.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).
It is strongly recommended to switch to OIDC Connect instead of using PyPi upload tokens. Please see [PyPi's documentation on trusted publishers](https://docs.pypi.org/trusted-publishers/).

To delete a PyPi upload token:

- Sign in to your PyPi account and visit <https://pypi.org/manage/account/>
- Scroll down to the "API tokens" section
- Find the identified token and select the "Options" dropdown list
- Select "Remove token"
- When prompted, enter your password and select "Remove API Token"

For more information, please see [PyPi's documentation on upload tokens](https://pypi.org/help/#apitoken).

## Details

| ID     | Aggregated | CWE | Type | Risk |
|:-------|:-----------|:----|:-----|:-----|
| 798.96 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
