# frozen_string_literal: true

class CreateVulnerabilityArchives < Gitlab::Database::Migration[2.2]
  milestone '17.9'

  def change
    create_table :vulnerability_archives do |t| # rubocop:disable Migration/EnsureFactoryForTable -- false positive
      t.timestamps_with_timezone null: false

      t.bigint :project_id, null: false
      t.integer :archived_records_count, null: false, default: 0
      t.date :date, null: false

      t.index %i[project_id date], unique: true

      t.check_constraint 'archived_records_count >= 0'
    end
  end
end
