## 16.11.10 (2024-09-16)

No changes.

## 16.11.9 (2024-09-10)

### Security (1 change)

- [Fix for private dotenv artifacts not accessible to downstream jobs](https://gitlab.com/gitlab-org/gitlab/-/commit/9bb4b59afe5a2e8a383709a55a139d6875acf911)

### Performance (1 change)

- [Analyze partitioned tables every 3 days](https://gitlab.com/gitlab-org/gitlab/-/commit/e38cca011522a565d582e8760ca958f37d9be299) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/163255))

## 16.11.8 (2024-08-05)

### Changed (1 change)

- [Put groups_direct field in CI JWT tokens behind feature flag](https://gitlab.com/gitlab-org/gitlab/-/commit/d0a48169310c947607259d20046bdaadabcebaee) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/161239))

## 16.11.7 (2024-07-23)

### Added (1 change)

- [Add Rake task to show token expiration info](https://gitlab.com/gitlab-org/gitlab/-/commit/74bda3d7064c5d346b89c3b81fc9ee9189919945) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159056))

### Fixed (1 change)

- [Ignore object pool already exists creation errors](https://gitlab.com/gitlab-org/gitlab/-/commit/b1ce2c82376ff000984686c22e739464458d868b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159021))

## 16.11.6 (2024-07-09)

### Fixed (1 change)

- [Update dependency slack-messenger to v2.3.5](gitlab-org/security/gitlab@4e78461cef64c7423d793de22deffbae7088e7d6)

### Security (6 changes)

- [Disallow serving Pages over disabled custom domains with deployments](gitlab-org/security/gitlab@ff23e03cab7495107b1342b4fa175db63a4acd61) ([merge request](gitlab-org/security/gitlab!4247))
- [Check if user has ban_group_member access before banning in namespace](gitlab-org/security/gitlab@cadb2dba7f5fe825fab7fe761259e7c1721bebfe) ([merge request](gitlab-org/security/gitlab!4090))
- [Prevent using quick actions for some bot users](gitlab-org/security/gitlab@951a656e6d530ba7692b03506b7c340bc5ac2788) ([merge request](gitlab-org/security/gitlab!4233))
- [Disable raw HTML for quick action pipeline](gitlab-org/security/gitlab@1a7f336059af3223b4886e79060b8dc8a17f5482) ([merge request](gitlab-org/security/gitlab!4237))
- [Disable quick actions unless description changed](gitlab-org/security/gitlab@267f4cf51303f70d5a834a3358fe62b6e981a873) ([merge request](gitlab-org/security/gitlab!4240))
- [Remove comment support from shrug and tableflip](gitlab-org/security/gitlab@579a180538609ccad2d3930218a5410cb33d3920) ([merge request](gitlab-org/security/gitlab!4230))

## 16.11.5 (2024-06-25)

### Fixed (2 changes)

- [Only allow documented token types for GraphQL authentication](gitlab-org/security/gitlab@29cf595d53bc1d05edb662004c5ac76a8d497065)
- [Update an expired test certificate](gitlab-org/security/gitlab@7d482c5924e4b61a1889029147367631c1b435ad)

### Changed (2 changes)

- [Add a banner informing about token expiration](gitlab-org/security/gitlab@e60607a2d4377cdb872b65d756d0e478e01e0f1c)
- [Enable invert_emails_disabled_to_emails_enabled by default](gitlab-org/security/gitlab@a2adc31b3fe5b8160922c42df31ab3b12ecc5b7b)

### Security (14 changes)

- [Security fixes for banzai pipeline](gitlab-org/security/gitlab@7a7560ebf98b9e3fed749c0895c7fe952a35d0e6) ([merge request](gitlab-org/security/gitlab!4182))
- [Fix the catastrophic backtracking in openapi regex](gitlab-org/security/gitlab@6561fa187bd297a664c7fee8d1bbb546fb6f197e) ([merge request](gitlab-org/security/gitlab!4144))
- [Use permitted_params for standalone and multiplex queries](gitlab-org/security/gitlab@7be6c33aa9ed53d8713a098a48ad5b5265fd4801) ([merge request](gitlab-org/security/gitlab!4148))
- [Fix for Private job artifacts can be accessed by any user](gitlab-org/security/gitlab@eff1ae75283fafff1204063fc9c5fa43d90439b0) ([merge request](gitlab-org/security/gitlab!4196))
- [Remove search results from public projects with unauthorized repos](gitlab-org/security/gitlab@5e1513db50b3ada45a991d39fde0cd4cadd4bb88) ([merge request](gitlab-org/security/gitlab!4042))
- [Do not run a new pipeline on re-target](gitlab-org/security/gitlab@f68c020c8d2a2dc53187a65857f3312a025af3f4) ([merge request](gitlab-org/security/gitlab!4189))
- [Add limits on autolinker regex](gitlab-org/security/gitlab@d79a1a8333484bf9537af2907767fad0ec1ad240) ([merge request](gitlab-org/security/gitlab!4128))
- [Fix clickjacking on OAuth application page](gitlab-org/security/gitlab@05b187a7860fc02b68eced70e882a807d7a0e784) ([merge request](gitlab-org/security/gitlab!4024))
- [Hide branch merge request if merge requests are private](gitlab-org/security/gitlab@5973f83550e4b6341ca3f3fdbd29759a46b31bb6) ([merge request](gitlab-org/security/gitlab!4206))
- [Remove collapseLongCommitList method](gitlab-org/security/gitlab@279c1eee6676df9e25b723fd971dcf5c7134effd) ([merge request](gitlab-org/security/gitlab!4207))
- [Pass SSO session data to Sidekiq](gitlab-org/security/gitlab@e3147a7c301acf2d5e474745e594ff319f6e7f37) ([merge request](gitlab-org/security/gitlab!4161))
- [Prevent non-members from using promote_to quick action for quick actions](gitlab-org/security/gitlab@6424c7ad252809a13bc14d61ba15a6a377cd5a30) ([merge request](gitlab-org/security/gitlab!4156))
- [Reject deletion of security policy project approval rules](gitlab-org/security/gitlab@0e86b08d33fcfca547fb0e95ef462e4240bcf00e) ([merge request](gitlab-org/security/gitlab!4106))
- [Mitigate ReDoS attacks via `method_call_regex`](gitlab-org/security/gitlab@6e3fb9ff027fa56e62db093c4291c5d562550c2d) ([merge request](gitlab-org/security/gitlab!4164))

## 16.11.4 (2024-06-11)

### Security (4 changes)

- [XSS and content injection raw XHTML files on IOS devices](gitlab-org/security/gitlab@5df472ac0deefe1e59ecfc0ffae7fa489cb6c9ab) ([merge request](gitlab-org/security/gitlab!4094))
- [Improve go_package_regex to prevent ReDoS attacks](gitlab-org/security/gitlab@d0b04b06f59e81bc57f6b33e26a0399b4b86ee80) ([merge request](gitlab-org/security/gitlab!4097))
- [Fix ReDoS in CI Interpolation](gitlab-org/security/gitlab@b013996a0612c9cc1e43bcd0be4b47d98eaf92f4) ([merge request](gitlab-org/security/gitlab!4082))
- [Verify Asana access token when testing Asana integration](gitlab-org/security/gitlab@6db47bd6ace0904869f56f035ff408855f3f4c9b) ([merge request](gitlab-org/security/gitlab!4060))

## 16.11.3 (2024-05-21)

### Fixed (2 changes)

- [Ensure BLPOP/BRPOP returns nil instead of raising ReadTimeoutError](gitlab-org/security/gitlab@53de79ac43f81963a15be27b94bc67f7bbf036b6)
- [Fix Sidekiq migration timeout](gitlab-org/security/gitlab@32cf49a634b4cb15f065c3e112a693ea30dadda5)

### Security (7 changes)

- [Prevent PDF.js from evaluating scripts](gitlab-org/security/gitlab@b5f9843d9b54ca45817c16cbb706697bf9d44d81) ([merge request](gitlab-org/security/gitlab!4070))
- [Caching test_report api response to reduce calculations](gitlab-org/security/gitlab@63299beda6e61653070c279ad6838a99a29dc33f) ([merge request](gitlab-org/security/gitlab!4027))
- [Restrict access to Secure artifacts to developer role](gitlab-org/security/gitlab@63855780157d740d1c8e731b90eecae4d5f1c8c2) ([merge request](gitlab-org/security/gitlab!4045))
- [Fail create commit status on pipeline_id / sha mismatch](gitlab-org/security/gitlab@a1a4f80bee205fedfd3da27978bed810afe78555) ([merge request](gitlab-org/security/gitlab!4032))
- [Use UntrustedRegexp for gollum pattern](gitlab-org/security/gitlab@fafda23db9f0c34408b155ddc089872b55e1fd8b) ([merge request](gitlab-org/security/gitlab!4040))
- [Patch @gitlab/web-ide to fix XSS webWorkerExtensionHostIframe.html](gitlab-org/security/gitlab@7b2acad244d55455a0bba1fd8cbad28b22704756) ([merge request](gitlab-org/security/gitlab!4056))
- [Add text limit to ci_runners text fields](gitlab-org/security/gitlab@d78c5995f6651e54ed97340a1446822d185f02f5) ([merge request](gitlab-org/security/gitlab!4036))

## 16.11.2 (2024-05-07)

### Fixed (1 change)

- [Changed the email validation for only encoded chars](gitlab-org/security/gitlab@d920615ba4a25ffc035ad6b8c26285815eeff4f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/151484/))

### Changed (1 change)

- [Return or display Gitlab version if GITLAB_KAS_VERSION is a SHA](gitlab-org/security/gitlab@0f75cac19752463492bd3311b14c37c468f8ab0d)

### Security (11 changes)

- [Update GITHUB_MEDIA_CDN to avoid SSRF when importing from Github](gitlab-org/security/gitlab@d09a2e9218ca0388e17c6e5810d73b1cdfaed965) ([merge request](gitlab-org/security/gitlab!4011))
- [Prevent namespace banned users from reading project todos](gitlab-org/security/gitlab@b3cc2799fe98e9a5a493545f5ff45098b9ba60fb) ([merge request](gitlab-org/security/gitlab!3968))
- [ReDoS in GitRefsFinder when using wildcards in branch search](gitlab-org/security/gitlab@1b2d2c2b4fb27eafd40ab4ef230f2b52d7b73747) ([merge request](gitlab-org/security/gitlab!3995))
- [ReDos in escape and commit reference filters](gitlab-org/security/gitlab@0b08bd7eebf65e4999574f3f856d996568c87fe6) ([merge request](gitlab-org/security/gitlab!3972))
- [Validate request origin before MR approval](gitlab-org/security/gitlab@ad8dfe033740952805ed677f26ff2ec391e4be82) ([merge request](gitlab-org/security/gitlab!4007))
- [Check request size before updating user pins](gitlab-org/security/gitlab@8f8110ed24f70c00f1bc69848af22f7fdd0caf57) ([merge request](gitlab-org/security/gitlab!4014))
- [Enforce per_page validation for Branches/TagsFinders](gitlab-org/security/gitlab@4655fca6ac2ecc340dd3bc50ddd6a74a8d00048f) ([merge request](gitlab-org/security/gitlab!3998))
- [Update Integrations::Discord::ATTACHMENT_REGEX regex](gitlab-org/security/gitlab@7d6c80a3768a7c0281647402990b67a4fa8a2c19) ([merge request](gitlab-org/security/gitlab!3988))
- [Update BaseMessage::RELATIVE_LINK_REGEX regex](gitlab-org/security/gitlab@52311b09ce70c1b3db8b7e7a49808467f76980b5) ([merge request](gitlab-org/security/gitlab!3989))
- [Require confirmation before linking JWT identity](gitlab-org/security/gitlab@2d84949cf6707d14ffd5a54290c605ff83bed6f6) ([merge request](gitlab-org/security/gitlab!3990))
- [Fix confidentiality check optimization](gitlab-org/security/gitlab@df63eb711d5d1f75147a4c5b3365559ed42af879) ([merge request](gitlab-org/security/gitlab!4002))

## 16.11.1 (2024-04-24)

### Security (5 changes)

- [Validation for encoded formatting characters](gitlab-org/security/gitlab@fc42e4b96ae1ac3cd766569d62d025cbf23ef16c) ([merge request](gitlab-org/security/gitlab!3979))
- [Forbid untrusted sign-ins to GitLab with Bitbucket and fix related uid](gitlab-org/security/gitlab@ef083c319e67072029787cd5c6a588562984a58c) ([merge request](gitlab-org/security/gitlab!3983))
- [Ensure PAT scope is validated everywhere for GraphQL/ActionCable](gitlab-org/security/gitlab@1847435210161d95b9c5fcd079380e7f2892195f) ([merge request](gitlab-org/security/gitlab!3975))
- [Protect against ReDoS in FileFinder with wildcard filters](gitlab-org/security/gitlab@dc16f3baa640ca8d5b223782ef3d58369423a1dd) ([merge request](gitlab-org/security/gitlab!3969))
- [fix: Validate security report version against schema during parsing](gitlab-org/security/gitlab@55e58d49051aa42938ec1d159b5e7eb3c47d2eb1) ([merge request](gitlab-org/security/gitlab!3967))

## 16.11.0 (2024-04-17)

### Added (121 changes)

- [Add skip secret detection audit event](gitlab-org/gitlab@e5b10f3c044a8992907f2dcc598123d798be9c7e) ([merge request](gitlab-org/gitlab!147855)) **GitLab Enterprise Edition**
- [Added added_approver to the todo action enum in GraphQL](gitlab-org/gitlab@0f2966c47ed9f5e042b8fb633ce454aa4592aa35) by @zillemarco ([merge request](gitlab-org/gitlab!148831))
- [Add setting for enabling pre-receive SD](gitlab-org/gitlab@dc4f895086986077fafc660537060d78546826b2) ([merge request](gitlab-org/gitlab!148332)) **GitLab Enterprise Edition**
- [Added pending member for project listing page](gitlab-org/gitlab@dcbb5001eca02fd8aa6d8dbd06a401fc49716988) ([merge request](gitlab-org/gitlab!146678)) **GitLab Enterprise Edition**
- [Merge branch 'add-support-for-v-prefix' into 'master' ](gitlab-org/gitlab@e5bcb9dc8a57d7bdcf6fc5ed4d9a34590fdf7348) ([merge request](gitlab-org/gitlab!148706))
- [Simplifies SemanticVersionable concern](gitlab-org/gitlab@f7353bc52a84f417ccc032ae4ba45e1058c14c50) ([merge request](gitlab-org/gitlab!148706))
- [Added model for external_status_checks_protected_branches](gitlab-org/gitlab@2647e53b6725a9c90e032488401d4b1d2827571e) ([merge request](gitlab-org/gitlab!149046)) **GitLab Enterprise Edition**
- [Update URL with cursor to load a specific page](gitlab-org/gitlab@4c7fb3d5d2853424555c64e23ebbe1ccb79dee0f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/148593)) **GitLab Enterprise Edition**
- [Added update api for instance level audit streaming](gitlab-org/gitlab@444a1b0312439545bd7ca7bd50136047c8db9c6f) ([merge request](gitlab-org/gitlab!149104)) **GitLab Enterprise Edition**
- [Add endpoint for checking relation import status](gitlab-org/gitlab@f450696483846a1cd7da2f2e8315e52df979cd75) ([merge request](gitlab-org/gitlab!147775))
- [Utilize show_diff_preview_in_email column](gitlab-org/gitlab@614f6d5d7d2c0358ebf5425e76d4f3062009be6c) by @joe-snyder ([merge request](gitlab-org/gitlab!98547))
- [Add API for trigger project webhook](gitlab-org/gitlab@b9bf0c33d5139823dada3a401a2607fa3856b6b5) by @lifez ([merge request](gitlab-org/gitlab!147656))
- [Add displaying list of linked policies to framework table](gitlab-org/gitlab@4528caee6d01cfb2e2c6b4f739cf7da3ed63a81f) ([merge request](gitlab-org/gitlab!149324)) **GitLab Enterprise Edition**
- [Change admin users search filter](gitlab-org/gitlab@60cb8a9b7be5eed84f1a2bf9d41c5e3a5620099a) by @bahek2462774 ([merge request](gitlab-org/gitlab!144907))
- [Protected packages: Show protected label in packages list](gitlab-org/gitlab@42a2d94bac523ec8cbd000609c49a38b84a72b46) by @gerardo-navarro ([merge request](gitlab-org/gitlab!141134))
- [Added delete api for instance level audit streaming](gitlab-org/gitlab@e81b3ef2809032b87bbdb1c3a662c256182aadad) ([merge request](gitlab-org/gitlab!149101)) **GitLab Enterprise Edition**
- [Update query for elevated_guests to use occupies_seat](gitlab-org/gitlab@0c7f5da4f50c6034cb018eca9378623869c5df53) ([merge request](gitlab-org/gitlab!148653)) **GitLab Enterprise Edition**
- [Frontend work for regex filter on Zoekt code search](gitlab-org/gitlab@bc2d7efa52429cabfd2cdd7a414c1aaf579a9728) ([merge request](gitlab-org/gitlab!144625))
- [Enabled product_analytics_billing by default](gitlab-org/gitlab@e4fbfd31e5ebe071a848a6c38c00bc9e355133fc) ([merge request](gitlab-org/gitlab!149243)) **GitLab Enterprise Edition**
- [Added update api for group audit event destinations](gitlab-org/gitlab@a08acfeab8dc426b96563d9a7ae26203af0d1ac2) ([merge request](gitlab-org/gitlab!148388)) **GitLab Enterprise Edition**
- [Remove experiment flag for product analytics](gitlab-org/gitlab@1fb7122f8e60a51e9e0f31213cbf29f1b467b21d) ([merge request](gitlab-org/gitlab!148983)) **GitLab Enterprise Edition**
- [Add co_authored_by placeholder to suggestions template](gitlab-org/gitlab@be6287b6c6e3280b26750842090563b531301183) ([merge request](gitlab-org/gitlab!148890))
- [New tests for project dropdown actions](gitlab-org/gitlab@61fc9592e2483aa2ba1577acc6d26b4e751c6915) by @espadav8 ([merge request](gitlab-org/gitlab!148750))
- [Obfuscate external participants emails in system notes](gitlab-org/gitlab@db7f244e226dfe2959034713daffa4b5511865fc) ([merge request](gitlab-org/gitlab!141612))
- [Update group policy to use admin_push_rules](gitlab-org/gitlab@ca6de0c1c208df53f13b08d024deafe4312853c6) ([merge request](gitlab-org/gitlab!147974)) **GitLab Enterprise Edition**
- [Added delete api for group audit event destinations](gitlab-org/gitlab@12d3cc288b8178cee1de4c8ac0bc9c89a514ece2) ([merge request](gitlab-org/gitlab!148738)) **GitLab Enterprise Edition**
- [Add top-level namespace to Usage Overview panel](gitlab-org/gitlab@3b8fbd9853cf73845a7dd95b7b11f4eb1bbeb1f5) ([merge request](gitlab-org/gitlab!148597)) **GitLab Enterprise Edition**
- [Add pre_receive_secret_detection_enabled param](gitlab-org/gitlab@875dfd8dbdd324b75e4fbc940381abd26cc28534) ([merge request](gitlab-org/gitlab!149160))
- [Protected containers: Create protection rules in project setting ui](gitlab-org/gitlab@aef987b99cf9d7e53a114f0d9d705e2304844e33) by @gerardo-navarro ([merge request](gitlab-org/gitlab!146523))
- [Add catalog component usage tracking in pipeline sequence](gitlab-org/gitlab@a0f6fd925367eb55a428a2687203888f6d6af64c) ([merge request](gitlab-org/gitlab!149138))
- [Implement the ability to use shorthand for semantic versions](gitlab-org/gitlab@ae5f0b35997e69ba646fb5cb4b5ce11ab73a8370) ([merge request](gitlab-org/gitlab!147910))
- [Add client for generating vertex embedding](gitlab-org/gitlab@d142f59a3c45d286fa15c61b5d28f2d5327ca501) ([merge request](gitlab-org/gitlab!148483)) **GitLab Enterprise Edition**
- [Expose metadata fields on Milestone type](gitlab-org/gitlab@3e5d0ab7f83a6f5562512bc465285b3883af15f9) ([merge request](gitlab-org/gitlab!148927))
- [Document encryption support for Google Cloud Storage (GCS)](gitlab-org/gitlab@63e1b9dfd82aa5527006ed97c9b37dc4ea0031b7) ([merge request](gitlab-org/gitlab!148994))
- [This MR adds new filter option](gitlab-org/gitlab@e62883d3d8504032bcf92805555e30ba7e20636b) ([merge request](gitlab-org/gitlab!148675)) **GitLab Enterprise Edition**
- [Added list api for listing instance level audit event destinations](gitlab-org/gitlab@86186adc05d92bc5a9a88f275c33d543cba424e3) ([merge request](gitlab-org/gitlab!148839)) **GitLab Enterprise Edition**
- [Added create api for instance audit event streaming destinations](gitlab-org/gitlab@20ec713cb27b4e8701317e2211b39f6daf960e02) ([merge request](gitlab-org/gitlab!148383)) **GitLab Enterprise Edition**
- [Adds "Allow runner registration token" setting to top-level group](gitlab-org/gitlab@29df08fb36a5c6b2626a021f5f2a3696cd637506) ([merge request](gitlab-org/gitlab!148557))
- [Rollout new custom roles UI](gitlab-org/gitlab@e82557fd72bbdcb1eeab09499d12b84e91071bde) ([merge request](gitlab-org/gitlab!148468)) **GitLab Enterprise Edition**
- [This MR adds new policy type](gitlab-org/gitlab@34203ec1278f48992af196a9f717620962886916) ([merge request](gitlab-org/gitlab!148600)) **GitLab Enterprise Edition**
- [Add referrer_type filtering to containerRepository tags GraphQL query](gitlab-org/gitlab@4720e1cbb764c3807dc881dc06a145e4ba19d2c5) ([merge request](gitlab-org/gitlab!147277))
- [Enable `group_saved_replies_flag` by default](gitlab-org/gitlab@04f93bbecb93e9a73d891611d258b76d9c4e3251) ([merge request](gitlab-org/gitlab!148958))
- [Add manage security policy as custom ability](gitlab-org/gitlab@b6a8cf2d72af8ee4a64612711111586b4cafdad6) ([merge request](gitlab-org/gitlab!148371)) **GitLab Enterprise Edition**
- [Initialize bigint conversion for vulnerability_occurrence_pipelines](gitlab-org/gitlab@bd40369ab79962a83a19e852ab3624b958507a36) ([merge request](gitlab-org/gitlab!148735))
- [Initialize bigint conversion for merge_trains](gitlab-org/gitlab@343e2b965acfdcbcb6d70b7f74dbfcf8b3fc55ed) ([merge request](gitlab-org/gitlab!148730))
- [Initialize bigint conversion for merge_trains](gitlab-org/gitlab@09fcf24f778807dc4097b17b9088499a9a32234b) ([merge request](gitlab-org/gitlab!148786))
- [Initialize bigint conversion for packages_build_infos](gitlab-org/gitlab@c65891c9240d56b53f391e0666631cb84a2e14b3) ([merge request](gitlab-org/gitlab!148791))
- [Initialize bigint conversion for vulnerability_feedback](gitlab-org/gitlab@390b83d1b1280f8657d96f7ef7cacf8fa709118f) ([merge request](gitlab-org/gitlab!148790))
- [Add a new worker to process the pipeline creation for sep](gitlab-org/gitlab@0185a66f0b645ad9625ea94d3ec7299d8959175b) ([merge request](gitlab-org/gitlab!147691)) **GitLab Enterprise Edition**
- [Removed auto_cancel_pipeline_on_job_failure feature flag](gitlab-org/gitlab@5e80edd594717e6a91c65223bd24b2bc716dbf0d) by @zillemarco ([merge request](gitlab-org/gitlab!148515))
- [Add runner creation status](gitlab-org/gitlab@6faa548186a248a22a3686d8e125a4ca1d204f56) by @imskr ([merge request](gitlab-org/gitlab!144842))
- [Add close on escape support](gitlab-org/gitlab@89c281d7077c29a6ec4a2a62443008e6ce8f2071) ([merge request](gitlab-org/gitlab!148852)) **GitLab Enterprise Edition**
- [Initialize bigint conversion for merge_requests](gitlab-org/gitlab@3c7e1f1157c6608ca54f1c19fada2fb4f5c48015) ([merge request](gitlab-org/gitlab!148788))
- [Add accessLevel & isLastOrganizationOwner fields to organizationUser](gitlab-org/gitlab@2acf4411a1396b9f00b36e2c2b4f74de47de4785) ([merge request](gitlab-org/gitlab!148148))
- [Improve the performance of group-level vulnerability export](gitlab-org/gitlab@3c0c31802ca926ade373a71c6c356085eeb254e0) ([merge request](gitlab-org/gitlab!147365))
- [Enable Custom Webhook Headers feature](gitlab-org/gitlab@e05517344b269d3fe0f200f87ba7901d3852468e) by @Taucher2003 ([merge request](gitlab-org/gitlab!148690))
- [Consider child pipelines for MR approval policies](gitlab-org/gitlab@5ba4ebdcd7c9de8296df6535c92b135465061069) ([merge request](gitlab-org/gitlab!147710)) **GitLab Enterprise Edition**
- [Add development widget (feature flags)](gitlab-org/gitlab@5dc384fd05ab651525ecc922ab6f62dba3569d93) ([merge request](gitlab-org/gitlab!148215)) **GitLab Enterprise Edition**
- [Beyond Identity: Add option to exclude service accounts](gitlab-org/gitlab@da808914d9bf0afbc194e428f1396a054303366a) ([merge request](gitlab-org/gitlab!148590))
- [Add verified badge](gitlab-org/gitlab@89e089bbf086ca7d98cdc7d88ab4f5d007fa4127) ([merge request](gitlab-org/gitlab!147384))
- [Add runner wait time stats by namespace](gitlab-org/gitlab@0f7fece2f8d894cb670859298fd2c6caca2e0541) ([merge request](gitlab-org/gitlab!147148)) **GitLab Enterprise Edition**
- [Support minimal access base for custom roles](gitlab-org/gitlab@95ffa5f8d64aae0cd99c7014488c57bbfc23ddc4) ([merge request](gitlab-org/gitlab!148390))
- [Add object_attributes.action for note webhooks](gitlab-org/gitlab@abc1b67b29fc9c2a1cf7f4454b55ee527021631d) ([merge request](gitlab-org/gitlab!147856))
- [Add cadence validation for sep creation](gitlab-org/gitlab@d8732ca1a7ce25be3d06a01879ed11895b126a35) ([merge request](gitlab-org/gitlab!148096)) **GitLab Enterprise Edition**
- [Enable combined analytics dashboards by default](gitlab-org/gitlab@0675178be05bcbe8236b6b74b74684eaa950bbaf) ([merge request](gitlab-org/gitlab!148559)) **GitLab Enterprise Edition**
- [Create and list apis for group audit events](gitlab-org/gitlab@f5bafe4a48bc98901b4e709bfadad3adfedb5379) ([merge request](gitlab-org/gitlab!147888)) **GitLab Enterprise Edition**
- [Default enable producy analytics admin settings FF](gitlab-org/gitlab@0c4927326f9bbacd66653adf39b3832b37e711f3) ([merge request](gitlab-org/gitlab!148539)) **GitLab Enterprise Edition**
- [Enabling FF ci_retry_on_exit_codes on SM](gitlab-org/gitlab@24590f014becc7a09566dcc384dc0dfc7657239d) ([merge request](gitlab-org/gitlab!148189))
- [Add API endpoint to return current SSO session expiry time](gitlab-org/gitlab@a5f5dde09f72743021ca1f5aa2560aaa227f69b6) ([merge request](gitlab-org/gitlab!146011)) **GitLab Enterprise Edition**
- [Add REST API endpoint to sync push mirrors](gitlab-org/gitlab@1ab7f8dfad9608b4f5455f2c0d80c6a52c2d6fb5) ([merge request](gitlab-org/gitlab!148186))
- [Rollout security_policies_policy_scope_project by default](gitlab-org/gitlab@dcbcf0bdb1a8be2268339148dc2fdcecde39a551) ([merge request](gitlab-org/gitlab!148407)) **GitLab Enterprise Edition**
- [Add custom webhook headers](gitlab-org/gitlab@1504f88df5a07db69abeef68edcf9c4ec5a63fcd) by @Taucher2003 ([merge request](gitlab-org/gitlab!146702))
- [Remomve FF for search_add_archived_filter_to_zoekt](gitlab-org/gitlab@c2b5997f9b1e6d7326cacf73d591927c740538da) ([merge request](gitlab-org/gitlab!148107)) **GitLab Enterprise Edition**
- [Enalbed the global Duo Chat button](gitlab-org/gitlab@e3c4da4f8b7186e628f7dc8fea9e0bbf6ee2af82) ([merge request](gitlab-org/gitlab!148402)) **GitLab Enterprise Edition**
- [Validate check null constraint for vulnerability_reads#traversal_ids](gitlab-org/gitlab@e59b81bac5ad2b16797694870ef10e12095db594) ([merge request](gitlab-org/gitlab!148386))
- [Switch Groups UX to emails_enabled](gitlab-org/gitlab@77b46f4a8ccb8901e04b50a378d10d5284d4f00b) by @joe-snyder ([merge request](gitlab-org/gitlab!135959)) **GitLab Enterprise Edition**
- [New Audit Event when approval rule is updated](gitlab-org/gitlab@45d8bc02374aefcf852f1a61b8849a11db930b6f) ([merge request](gitlab-org/gitlab!146819)) **GitLab Enterprise Edition**
- [Add list of tag in external pipeline validation api](gitlab-org/gitlab@0db47b7ac6a22038a0298ac9314389db4650ab4c) by @lifez ([merge request](gitlab-org/gitlab!148318))
- [This MR adds breaking changes icon](gitlab-org/gitlab@3574df9f1f482529b31ae657476f1a1d0885757d) ([merge request](gitlab-org/gitlab!146921)) **GitLab Enterprise Edition**
- [Add user count to Usage Overview panel on Value Streams Dashboard](gitlab-org/gitlab@b52185cfd145cfa9165bd68e07d5be1e32fd0cd7) ([merge request](gitlab-org/gitlab!148254)) **GitLab Enterprise Edition**
- [Update JiraConnect app_descriptor](gitlab-org/gitlab@d4e186f8744231fc4c9c5139394446017d4034f0) ([merge request](gitlab-org/gitlab!148251))
- [Finalize BackfillHasIssuesForExternalIssueLinks background migration](gitlab-org/gitlab@af5f897a532475711837ea27d3b8d32260d6c216) ([merge request](gitlab-org/gitlab!148244))
- [Enable create_vulnerability_jira_issue_via_graphql by default](gitlab-org/gitlab@acab556c474c16825ea0da33449e2403f2a87b4b) ([merge request](gitlab-org/gitlab!148239)) **GitLab Enterprise Edition**
- [feat: Protected containers: Protection rules in project settings ui](gitlab-org/gitlab@794768d4aa5ca2347b9c7c20aca303ee487b5d0b) by @gerardo-navarro ([merge request](gitlab-org/gitlab!146436))
- [Add a new column zoekt_settings in the application_settings](gitlab-org/gitlab@54abc04448244b588436065b6d807fe91af51a8c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/147914))
- [Add a shared avatar image for security policy bots](gitlab-org/gitlab@799dd2d015217e47d82c9a3bfb7432e8bbc014c9) ([merge request](gitlab-org/gitlab!146942))
- [Add Create New Merge Request button to issues in forked projects](gitlab-org/gitlab@a3d260fd772c7d407c8f363e849d1b9cb8e25886) ([merge request](gitlab-org/gitlab!147355))
- [Accept generation_type parameter](gitlab-org/gitlab@682b3e557d9e76385799d13b8fac1a9a43e82ab4) ([merge request](gitlab-org/gitlab!147421)) **GitLab Enterprise Edition**
- [Add autocomplete support for wiki pages](gitlab-org/gitlab@27c318f7b83312cd6ec2a04704414ccbe6139556) ([merge request](gitlab-org/gitlab!143654))
- [Introduces hidden variable to group and ci variables](gitlab-org/gitlab@8ecd09100a7e8af196c3ec4bef8db0ab9a106fa3) ([merge request](gitlab-org/gitlab!141926))
- [Enable GitLab for Slack app for Instances and Groups](gitlab-org/gitlab@aca445a970e6cfccfe43566f34192835becec2af) ([merge request](gitlab-org/gitlab!147820))
- [Add indirect membership API endpoint](gitlab-org/gitlab@35586c95a5c16dad059058c36f143fa956032e3a) ([merge request](gitlab-org/gitlab!145227)) **GitLab Enterprise Edition**
- [Expose `created_at` field in Tags API](gitlab-org/gitlab@dea10fa96631eecb3834a7fdf1a9b1eacacc61da) ([merge request](gitlab-org/gitlab!147785))
- [Add topic support for Telegram](gitlab-org/gitlab@e6152b6d9b87bc5ba9f26f6d239b4f7c4cfc52a3) ([merge request](gitlab-org/gitlab!147734))
- [Wait for ClickHouse workers before running migrations](gitlab-org/gitlab@9060b40f86cd60cd38b488914d017d3509ab9243) ([merge request](gitlab-org/gitlab!147925))
- [Add `default_branch` attribute to Groups API](gitlab-org/gitlab@86ffba7a79ef7d6625062b2787be1551ea90dbd5) ([merge request](gitlab-org/gitlab!145803))
- [Add post migration to set value of occupies_seat column](gitlab-org/gitlab@abdb1960504d0a5b89ad7b16dcd44143a8d259d9) ([merge request](gitlab-org/gitlab!146293))
- [Add setting for pre-receive secret detection](gitlab-org/gitlab@631340d934a92d4eee47b762882b255eb739046f) ([merge request](gitlab-org/gitlab!147831)) **GitLab Enterprise Edition**
- [Remove feature toggle for policy scope](gitlab-org/gitlab@8c61aded645b4d1935d2d15e22c135a679e214f2) ([merge request](gitlab-org/gitlab!145997)) **GitLab Enterprise Edition**
- [Add '/clear' to Duo Chat commands in addition to '/clean'](gitlab-org/gitlab@b7beb41ec62dad5e59b543aaa455ba96472550b6) ([merge request](gitlab-org/gitlab!147380)) **GitLab Enterprise Edition**
- [Add setting for enabling CS for Registry](gitlab-org/gitlab@31a3e10652e98f380970e1fa88873ff643b1758d) ([merge request](gitlab-org/gitlab!147409)) **GitLab Enterprise Edition**
- [AddOnPurchase process trial attribute](gitlab-org/gitlab@318753cfb1c1f2dc35e400b53d74d116c3986a96) ([merge request](gitlab-org/gitlab!147522)) **GitLab Enterprise Edition**
- [Add detailed view for pods and services](gitlab-org/gitlab@07057f76bd480726d0db5ef84af5c7dbd9db55de) ([merge request](gitlab-org/gitlab!147553))
- [Add array types to CI inputs](gitlab-org/gitlab@853153958068f8586bee2bfb6dca6a8c64925e3e) ([merge request](gitlab-org/gitlab!145954))
- [Add full_path GQL field to ResourceType](gitlab-org/gitlab@c5c9e4a7c30f20c642d239e1f11945de8dbe2fcd) ([merge request](gitlab-org/gitlab!147623))
- [Add report abuse button](gitlab-org/gitlab@a82ef82275695877f23351a4192763ec71e91d69) ([merge request](gitlab-org/gitlab!143692))
- [Add access keyword in artifacts](gitlab-org/gitlab@9fa22477401fa7257391a7fab5a3b8bc683b9488) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/145206))
- [Finalize PurgeSecurityScansWithEmptyFindingData migration](gitlab-org/gitlab@c5b2254257272ad4906664d98c019257a0ce06e3) ([merge request](gitlab-org/gitlab!147426))
- [Work item two column loading skeleton](gitlab-org/gitlab@5c5d2ec1acf231d51a1bef7a65753deeefbcfb29) ([merge request](gitlab-org/gitlab!146615))
- [Add trial column to subscription_add_on_purchases table](gitlab-org/gitlab@e64f8868f576f4616df91b101db9b9b2c1186089) ([merge request](gitlab-org/gitlab!147422)) **GitLab Enterprise Edition**
- [Add migration to index all projects](gitlab-org/gitlab@a81fb1fa887c886c053e08893a04cdb7abe4584d) ([merge request](gitlab-org/gitlab!145131)) **GitLab Enterprise Edition**
- [Add usage_count columns to catalog tables](gitlab-org/gitlab@92fa72a80a427e1c374d111eab00fc2191180b07) ([merge request](gitlab-org/gitlab!147293))
- [Add a worker Zoekt::MarkReadyWorker](gitlab-org/gitlab@8b48c1465f408d915b60474a1bf38de04904e89c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/146475)) **GitLab Enterprise Edition**
- [Validate the foreign key & add to routing table commit_id](gitlab-org/gitlab@e88832c384b363628b9f8cc26446c51e413160a1) ([merge request](gitlab-org/gitlab!146964))
- [Add avatar to new achievement form](gitlab-org/gitlab@91bd29352ce7830664da5d16cd8b1a23980f9cdd) ([merge request](gitlab-org/gitlab!147040))
- [Add humanized role to removal events in audit details](gitlab-org/gitlab@bb18b60933e840a4f3179bab6d77d7fd8c108506) ([merge request](gitlab-org/gitlab!147435)) **GitLab Enterprise Edition**
- [Added model for instance level event type filters](gitlab-org/gitlab@585a40d553de3ea560447813e7fb79434d7afe3c) ([merge request](gitlab-org/gitlab!145421)) **GitLab Enterprise Edition**
- [Add frontend filter for zoekt code search](gitlab-org/gitlab@752200fdf1126146712847c1075b0a4c2d061bd1) ([merge request](gitlab-org/gitlab!147014)) **GitLab Enterprise Edition**
- [Add `spec` column to `catalog_resource_components`](gitlab-org/gitlab@c7cf6d3080559a2231dfd1b3ac01d0a5c14fab64) ([merge request](gitlab-org/gitlab!146674))
- [Make `traversal_ids` column nullable if it's already not](gitlab-org/gitlab@155267bfa51e8d5e2efd45dc9e850eb7d774e0bb) ([merge request](gitlab-org/gitlab!147326))
- [Add not valid null check constraint for `traversal_ids`](gitlab-org/gitlab@4255ad3962ac3cf3572dc4d088514ab6c4ed1aa3) ([merge request](gitlab-org/gitlab!147276))

### Fixed (141 changes)

- [Update pages ci templates - Gatsby](gitlab-org/gitlab@f309140b1c746dbf93ba0e5d75342348760f64fe) ([merge request](gitlab-org/gitlab!148120))
- [Consider merge request pipelines for license approval policies](gitlab-org/gitlab@334e560a3649c8071429023e4b745761311dbfcf) ([merge request](gitlab-org/gitlab!149192)) **GitLab Enterprise Edition**
- [Disable personal access tokens for enterprise users](gitlab-org/gitlab@cbf59303e43effeabe2d1fa7abe3df631cdff9dd) ([merge request](gitlab-org/gitlab!148415)) **GitLab Enterprise Edition**
- [Fix ArgumentError in ProjectApprovalRules API](gitlab-org/gitlab@e2d0c77bb4bc7045851c35c9f27b75a18a1a9b0b) ([merge request](gitlab-org/gitlab!149106)) **GitLab Enterprise Edition**
- [Add row gap between rows of codeowner approver avatars](gitlab-org/gitlab@57816fbf3da86695403517b75f5d6542ab0be68c) ([merge request](gitlab-org/gitlab!149008)) **GitLab Enterprise Edition**
- [Fix hover state of emoji on snippets](gitlab-org/gitlab@f0154f2277fb93bcadec376de10c1977d5e7cdfa) ([merge request](gitlab-org/gitlab!149153))
- [Hide `New subgroup` button if visibility is restricted](gitlab-org/gitlab@97b12dbf8ea56eb4fdc96a8b775ac319f6bdb957) ([merge request](gitlab-org/gitlab!148758))
- [Ensure command pallet search respects current ref](gitlab-org/gitlab@4db0a566751b3e28166813f6d14b81f8d0f30c82) ([merge request](gitlab-org/gitlab!149084))
- [Escape markdown characters for Telegram integration](gitlab-org/gitlab@545fb61ba96dd21754e929fdb3f6de8d123671d2) ([merge request](gitlab-org/gitlab!148703))
- [Fix job log link regex](gitlab-org/gitlab@bdbcbb71363fbe9b6503c87dec979de2ab1838c1) ([merge request](gitlab-org/gitlab!148891))
- [Fix undefined method error when package.json is malformed](gitlab-org/gitlab@0e4e9aba50543be7b283ad3bc2d5753c2db8f931) ([merge request](gitlab-org/gitlab!149148))
- [Remove unnecessary md header divider when previewing](gitlab-org/gitlab@4692a59fc53bfb1fc1dd2a4d11a498838218e1df) ([merge request](gitlab-org/gitlab!149012))
- [Fix NoMethodError when an array parameter has an invalid format](gitlab-org/gitlab@920437053ace6d4d6625c60caa860305983d46dc) ([merge request](gitlab-org/gitlab!148962)) **GitLab Enterprise Edition**
- [MR approval widget: Align text correctly](gitlab-org/gitlab@4218a8b5430990ca3e2c4008140e36a55dcb6487) ([merge request](gitlab-org/gitlab!149056))
- [[Batched Migration] Fix corrupted scanner_ids of vulnerability_reads](gitlab-org/gitlab@fc5abd0b3f19b5aaa009704bd9f586f457801537) ([merge request](gitlab-org/gitlab!148807)) **GitLab Enterprise Edition**
- [Temporarily restore old breadcrumbs UX](gitlab-org/gitlab@ae8f680b61091bddb1abd86624cdc36126e6ba6c) ([merge request](gitlab-org/gitlab!148673))
- [Avoid bad MIN query plan during batch count](gitlab-org/gitlab@786631a70c5e96948be2bb96a9e62b76b41de516) ([merge request](gitlab-org/gitlab!148608)) **GitLab Enterprise Edition**
- [Show status, milestone and statistics on service desk issue list](gitlab-org/gitlab@135ed3c1ad3e8a035b633f3555cce54c7607ab5b) ([merge request](gitlab-org/gitlab!148895))
- [Clean up instrumentation key in analytics controller](gitlab-org/gitlab@15067f062f8123521d576b4c39e4c659a0eba78d) ([merge request](gitlab-org/gitlab!148840)) **GitLab Enterprise Edition**
- [MR widget approvals: Auto update approvals](gitlab-org/gitlab@fa3bfef9a940b60742d5d7d20fda0b2640bc2ae1) ([merge request](gitlab-org/gitlab!148379))
- [Let sub group api update default branch protection defaults](gitlab-org/gitlab@eafcf0f24fcd4f7a6eaa5b3e4e552cfbccdcd12e) ([merge request](gitlab-org/gitlab!148566))
- [Fix migration error when updating from GitLab 16.9 to 16.10](gitlab-org/gitlab@d2f0aaf37ececcd92b0c1eab73129532c92fb71a) ([merge request](gitlab-org/gitlab!148135))
- [MR sidebar: Fix reviewers loading icon position](gitlab-org/gitlab@af34d0b62b56e6d3b94b70ab28a277d9ea07a919) ([merge request](gitlab-org/gitlab!148950))
- [MR approval in MR list: Fix display of total approvals](gitlab-org/gitlab@5b91c9e43f813c100dab62bb8df1861c0a831452) ([merge request](gitlab-org/gitlab!148941)) **GitLab Enterprise Edition**
- [Skip license capacity check for security policy bot user](gitlab-org/gitlab@33345f3c5ed65a5f4920a1f5c68e5b84582ae6aa) ([merge request](gitlab-org/gitlab!148893)) **GitLab Enterprise Edition**
- [Preserve indirect memberships](gitlab-org/gitlab@bd9dae0c2b320cc75a99b720e1733b5894ef66a2) ([merge request](gitlab-org/gitlab!148220))
- [Fix border radius on MR diffs](gitlab-org/gitlab@f384129183453962a28da05cdc901d3986a9f737) ([merge request](gitlab-org/gitlab!148716))
- [Adapt Graphql path depending on GitHub API endpoint](gitlab-org/gitlab@f3b9cd839825c0b5200870f1f76735ff433a0e5d) by @daniel.marks ([merge request](gitlab-org/gitlab!147143))
- [Migrate sbom_occurrences.component_name to match](gitlab-org/gitlab@85faa73c55cc3aa61b41a0afdbbb3442edff3fd7) ([merge request](gitlab-org/gitlab!146776))
- [Fix pipeline complete condition and include manual state](gitlab-org/gitlab@5713bf9fbb108efd38808ed8a955c2e79370f240) ([merge request](gitlab-org/gitlab!148866)) **GitLab Enterprise Edition**
- [Use 2x image source for avatars smaller than 96px](gitlab-org/gitlab@7fefa86be66444f85e1229b96a7feb2b960b17b5) ([merge request](gitlab-org/gitlab!148333))
- [Prevent access to achievements for private groups](gitlab-org/gitlab@664430132351ea6aa881d78ae3ccb0f19f7a369b) ([merge request](gitlab-org/gitlab!147319))
- [This MR fix scope column in policy list](gitlab-org/gitlab@ec655265e05b1924ebc9ce50ea5d758f2877fb60) ([merge request](gitlab-org/gitlab!148842)) **GitLab Enterprise Edition**
- [Fix missing validation for Branches::CreateService](gitlab-org/gitlab@b458ed5ee901060552dd2d2ab80d04fc3a773faa) ([merge request](gitlab-org/gitlab!148689))
- [Make milestone titles unique in group hierarchy](gitlab-org/gitlab@aa5a790f9e3de50a049a1fd52d46a7e1f3c142a9) ([merge request](gitlab-org/gitlab!142857))
- [Correct parse the `canEdit` permission for project dropdown items](gitlab-org/gitlab@310ceeea42b8586001d948f54a56c08f2547c644) by @espadav8 ([merge request](gitlab-org/gitlab!148659))
- [Fix 500 error in Commits API when the repository is empty](gitlab-org/gitlab@778793d50837ca778541931827fe08cdc823765f) ([merge request](gitlab-org/gitlab!148405))
- [MR widget: Fix alignment of approval button and text](gitlab-org/gitlab@07cbdc49f8fb6097db11417a32208a5881220cf3) ([merge request](gitlab-org/gitlab!148631))
- [Fix "Import with projects" button not showing](gitlab-org/gitlab@fd2d9482bc2104f0df61c338ae6a415642a8f894) ([merge request](gitlab-org/gitlab!148613))
- [Fix board scope assignee dropdown results](gitlab-org/gitlab@4ff3dcf5d4fdc51928bfe339271df898146dfe7a) ([merge request](gitlab-org/gitlab!148377)) **GitLab Enterprise Edition**
- [Invert emails_disabled into emails_enabled](gitlab-org/gitlab@e6f3c8ddaeb34ee8526645418eaf61935308038c) ([merge request](gitlab-org/gitlab!148577))
- [Use locale-specific formatting for VSD table numbers](gitlab-org/gitlab@4b71d52baa05867abafcff3e03f5ad417d9dc4e0) ([merge request](gitlab-org/gitlab!148331)) **GitLab Enterprise Edition**
- [Correct diff colors & highlighting for none theme](gitlab-org/gitlab@8391bb3e6461fbf508bb965a7e98b33115e79cda) by @jameschensmith ([merge request](gitlab-org/gitlab!148538))
- [Disable sending of Link header in preload_link_tag](gitlab-org/gitlab@76fe184e4281812a9f819c2b3a2c4c3a89b356f1) ([merge request](gitlab-org/gitlab!148280))
- [Fix job sidebar when artifact access is restricted](gitlab-org/gitlab@e9cee36e9a051a782b8e47f8ecf5b43d6bc6d111) ([merge request](gitlab-org/gitlab!148453))
- [This is a small breaking change, and while it's not being done in the](gitlab-org/gitlab@1e9e6d5fcd5913ca79505fff4dc1dd1a44f99935) by @gitlab-dependency-update-bot ([merge request](gitlab-org/gitlab!147619))
- [Fix the test report modal](gitlab-org/gitlab@c9808da3a3bff4e6ad8e052391500c8128b84799) ([merge request](gitlab-org/gitlab!148440))
- [Fix handling of DAGs within a stage in AtomicProcessingService ](gitlab-org/gitlab@9ceb88fe5421afa87af290da78f419032325d746) ([merge request](gitlab-org/gitlab!148211))
- [Fix Duo Chat Popover Design Managment overlapping Bug](gitlab-org/gitlab@843bb55409348cc91e2d0ebb74094917e3823d3c) ([merge request](gitlab-org/gitlab!148434))
- [Fix epic links in issue sidebar changing to work item link](gitlab-org/gitlab@d7ac773456fd49792073024a505a4dc24cbc3888) ([merge request](gitlab-org/gitlab!148420))
- [Fix NoMethodError for tags#date](gitlab-org/gitlab@96858a07cc2046162dc7c15e5a95de33ba5f9c23) ([merge request](gitlab-org/gitlab!148413))
- [Support large wiki content in webhooks](gitlab-org/gitlab@3e38cff3a36d741b89b59859317cf8d6b3916917) by @ivantedja ([merge request](gitlab-org/gitlab!146973))
- [Fix included avatar in the code copy](gitlab-org/gitlab@fd451c621adcd6f59f03c636b665f3bf8b9c0cca) ([merge request](gitlab-org/gitlab!148243))
- [Use a correct link to group templates docs](gitlab-org/gitlab@30669dff2c937c78033b3de578d0d9c4bfb4e1cb) ([merge request](gitlab-org/gitlab!148374)) **GitLab Enterprise Edition**
- [Fix URL validator for mirror services when using localhost](gitlab-org/gitlab@310317f36d14efe8b424b1fdcb5fe00abdae1395) ([merge request](gitlab-org/gitlab!148368))
- [Expose `branches_to_be_notified` field for Telegram API](gitlab-org/gitlab@7bf6d3eee9c8a33f73a7b1f4e2a29268aa9d68b7) ([merge request](gitlab-org/gitlab!148281))
- [Fix duplicate "Job suceeded lines"](gitlab-org/gitlab@e86eddfe31a4e1ba25e4ca271c6c2d693f72e69a) ([merge request](gitlab-org/gitlab!148255))
- [WIP OVERWRITE LATER](gitlab-org/gitlab@81a73d56889b006adc1d36d60e04dbabb08e37c2) ([merge request](gitlab-org/gitlab!148262))
- [Fail sync when a primary connection is unvailable](gitlab-org/gitlab@756f9cdb1518ded4c2f53e9971ba38634d1f129c) ([merge request](gitlab-org/gitlab!148105)) **GitLab Enterprise Edition**
- [Trigger Epic events after transaction has been finished](gitlab-org/gitlab@4eab137d71d3e4d7785efcea963088567c9b6e9f) ([merge request](gitlab-org/gitlab!147677)) **GitLab Enterprise Edition**
- [Update vulnerability_reads scanner in the ingestion pipeline](gitlab-org/gitlab@287fd2d24d774cde7293e803a2cdc7f2c4dcf7ff) ([merge request](gitlab-org/gitlab!148016)) **GitLab Enterprise Edition**
- [Strip keywords from chat final answer](gitlab-org/gitlab@ca76cb9a231b8842bfad0b90a624558da584fbc3) ([merge request](gitlab-org/gitlab!148177)) **GitLab Enterprise Edition**
- [Fix native browser navigation in MR single-file mode](gitlab-org/gitlab@95c6310bc3d409db219246bc8c96fed684ca6f34) ([merge request](gitlab-org/gitlab!147413))
- [Fixes race condition for GFM rendering on issuable description](gitlab-org/gitlab@89a1fbb0cd5749991ca77cd0ce84747097a69613) ([merge request](gitlab-org/gitlab!148150))
- [Branches list: Fix focus states](gitlab-org/gitlab@be5f35c4998e8e50461075b9cbcf84bcf4009763) ([merge request](gitlab-org/gitlab!148057))
- [Fix cache timeout for commands](gitlab-org/gitlab@7655608a37274a2836fb1b799eeb886e0ebc65c3) ([merge request](gitlab-org/gitlab!147368))
- [Fix wiki URLs for wiki webhooks](gitlab-org/gitlab@dc6f269ba62b3e8ab95aca104179007d969bb8cb) by @ivantedja ([merge request](gitlab-org/gitlab!147822))
- [Fix size of design management todo button](gitlab-org/gitlab@8cec5771e1d853effa09babb9cbc9f7e3f2b007b) ([merge request](gitlab-org/gitlab!147941))
- [Strip cookies for asset requests in development and test](gitlab-org/gitlab@58a4a2cb5fb3ee1e205df5c314cb48a64f4cfb97) ([merge request](gitlab-org/gitlab!148117))
- [Remove echarts <5.x workaround in lead_time_charts](gitlab-org/gitlab@71b3002dbf56cc48fc0f2433ae8647688a36056f) ([merge request](gitlab-org/gitlab!148116)) **GitLab Enterprise Edition**
- [Fix styling of Incident timeline tab in dark mode](gitlab-org/gitlab@14bff2aa8bad57734a74f1210312337f6081d5f5) ([merge request](gitlab-org/gitlab!147852))
- [Fixes a horizontal scrolling issue for json tables](gitlab-org/gitlab@d38662cb71260969cd10d98cc3d0651a9cc5f9d4) by @fagerburg ([merge request](gitlab-org/gitlab!147286))
- [Fix blurry avatars when size < 48](gitlab-org/gitlab@d9d6391d1330e749500446b0e295106a61321716) ([merge request](gitlab-org/gitlab!147821))
- [Fix the deprecated_properties method](gitlab-org/gitlab@c2c641f183d38ccfca4be64a3463f2e342eec11a) ([merge request](gitlab-org/gitlab!147958)) **GitLab Enterprise Edition**
- [Pipeline Sec: Fix issue with deleted Jira issue](gitlab-org/gitlab@4e7bf39e3087bccc23b14780afeb07afc22d9e22) ([merge request](gitlab-org/gitlab!148007)) **GitLab Enterprise Edition**
- [Fix component include path rendered in the components tab](gitlab-org/gitlab@79a10b4eca5b2ed002105bd5ad91ffc8e3501163) ([merge request](gitlab-org/gitlab!147998))
- [Fix handling of DAGs within a stage in AtomicProcessingService](gitlab-org/gitlab@44911410286607e47a98e885744b06ec87d6c865) ([merge request](gitlab-org/gitlab!147875))
- [Fix handleLocationHash behavior for MRs and issuables](gitlab-org/gitlab@ab1e57d6c1d78d3efa69dde14bd66c7d39e5cbd6) ([merge request](gitlab-org/gitlab!147711))
- [Fix commit status API incorrectly overwriting MR head pipeline](gitlab-org/gitlab@6a4c87d6db68e2536b90b38c1e11f9a158bd7480) ([merge request](gitlab-org/gitlab!147212))
- [Pipeline Sec: Fix Jira issue creation](gitlab-org/gitlab@da3b8c10a91c3152af0b00048ebcc2b9c4c7c765) ([merge request](gitlab-org/gitlab!147647)) **GitLab Enterprise Edition**
- [Handle null owner when indexing projects](gitlab-org/gitlab@059908f552762fbc26bc8d62f383770cfc02f926) ([merge request](gitlab-org/gitlab!147951)) **GitLab Enterprise Edition**
- [Add search functionality to sub group autocomplete](gitlab-org/gitlab@5172a9247bc4fc7b5192247db7dfd27be4d94dce) ([merge request](gitlab-org/gitlab!147578)) **GitLab Enterprise Edition**
- [Initialize hiding tooltip for links with tooltips when clicked](gitlab-org/gitlab@4fd57f617d97c9764e11c4c89c03e399fc1a3507) ([merge request](gitlab-org/gitlab!147947))
- [Fix design management notification buttons feature flag](gitlab-org/gitlab@61e6d9765c2b4ecbcc236ec9f6ed5590037958fe) ([merge request](gitlab-org/gitlab!147945))
- [ActionController::UrlGenerationError for old path redirects](gitlab-org/gitlab@4b37f666e26e3f382a88e5e4872ae2de9d2399e9) ([merge request](gitlab-org/gitlab!147933))
- [Use vue routes for group custom Value Stream Dashboard](gitlab-org/gitlab@8b431614f3d6e8a254eef23dde703a0f35dc10d0) ([merge request](gitlab-org/gitlab!147842)) **GitLab Enterprise Edition**
- [Set `traversal_ids` and `archived` attributes always](gitlab-org/gitlab@589b246fa034fd339aefb746ac1de972409d843b) ([merge request](gitlab-org/gitlab!147082)) **GitLab Enterprise Edition**
- [Fix 500 error for erroneous content in markdown footnotes](gitlab-org/gitlab@8d061c5813ad28eea8afd6bdf15d098ad720a7a1) ([merge request](gitlab-org/gitlab!147922))
- [Update pages ci templates - Nanoc](gitlab-org/gitlab@f6e2b4f9edf9a1ceba5428f0dd435caac0f10242) ([merge request](gitlab-org/gitlab!147722))
- [Fix start_is_fixed and due_date_is_fixed default](gitlab-org/gitlab@2a2405c48f9081c415ba9623d653a85995a4ef69) ([merge request](gitlab-org/gitlab!147119)) **GitLab Enterprise Edition**
- [Skip migration when the partitioned FK exists](gitlab-org/gitlab@cb88e677ff9397c1b825d38381f987465fc76b1c) ([merge request](gitlab-org/gitlab!147878))
- [Handle missing pipeline user name in terraform registry UI](gitlab-org/gitlab@db119bed67e45bb7779aaf187b3af77fbe8af7e7) ([merge request](gitlab-org/gitlab!147865))
- [Reset pagination page](gitlab-org/gitlab@e164ef2015c9388d00bd3b4f9842fc747a779bb1) ([merge request](gitlab-org/gitlab!147832))
- [Fix leave action label for project members](gitlab-org/gitlab@f8bb6dd151393ff9e2b0e59921204fa7665b2a41) ([merge request](gitlab-org/gitlab!147692))
- [Replace space with HTML entity](gitlab-org/gitlab@eae79bfd94be8cb6d9a05adf2dd1fad284180116) ([merge request](gitlab-org/gitlab!147805)) **GitLab Enterprise Edition**
- [Apply inline validation to admin deletion protection settings](gitlab-org/gitlab@f5733cdc6a4a32780a0e1803d5bc447d1564f1c0) ([merge request](gitlab-org/gitlab!147299)) **GitLab Enterprise Edition**
- [Fix webhook test send wrong object kind for tag_push_event](gitlab-org/gitlab@ecc33395ae61141eb8d09245350ede435a070058) by @lifez ([merge request](gitlab-org/gitlab!147634))
- [Use semaphore for storing security reports](gitlab-org/gitlab@fea7c1843b08a9377a96f0a15e071b560867948c) ([merge request](gitlab-org/gitlab!147816)) **GitLab Enterprise Edition**
- [Fix character escaping in fork divergence message](gitlab-org/gitlab@0699d4ed2e2e61da32798d73a62ff79dbeadf073) ([merge request](gitlab-org/gitlab!147808))
- [Zoekt: Retry indexing if too many requests](gitlab-org/gitlab@0f2ecf22b24826efe5b30168acd9b5ee612ceda9) ([merge request](gitlab-org/gitlab!147776)) **GitLab Enterprise Edition**
- [Update pages ci templates - Lektor](gitlab-org/gitlab@89756d0a3c14b24dac2cc3b5e0a4d801b49ee876) ([merge request](gitlab-org/gitlab!147491))
- [Fix focus state for dark mode rounded bottom markdown input](gitlab-org/gitlab@ce00c22b4ba4a87d03fe57c9bb0bcfae35eb4a9d) ([merge request](gitlab-org/gitlab!147476))
- [Fix invalid CI input array type default value](gitlab-org/gitlab@3070c59f634ba8357fc9bcf32dcd763f1bfb0cd5) ([merge request](gitlab-org/gitlab!147681))
- [Update redis-client to v0.21.1](gitlab-org/gitlab@2e2191cb4f7ef4fdb4f7088377483beab31e0714) ([merge request](gitlab-org/gitlab!147675))
- [Include all changes made to issuable in hook data](gitlab-org/gitlab@9f0fd32b7039d6ba23b8829a1792490fbfc15626) ([merge request](gitlab-org/gitlab!147033))
- [Fix markdown header for uses with restricted items](gitlab-org/gitlab@be9c2c1e736c48341a7446829c101b6738b46e71) ([merge request](gitlab-org/gitlab!147481))
- [Fix VSD column names not matching the date range](gitlab-org/gitlab@45b59e2e3f52cfd953f51dd3e9c463d9ea2c7323) ([merge request](gitlab-org/gitlab!147668)) **GitLab Enterprise Edition**
- [Fix apparent spacing of issuable sidebar content](gitlab-org/gitlab@6502a266e8918d606b2266bae7edd21138a6c613) ([merge request](gitlab-org/gitlab!147294))
- [Pass plan when create trials](gitlab-org/gitlab@5f8421ffd418ea5fcf6141d8a731afce3d9dba4a) ([merge request](gitlab-org/gitlab!147635)) **GitLab Enterprise Edition**
- [Remove `ci_fix_input_types` feature flag](gitlab-org/gitlab@bcd12f77cd3875df3a87add7eed73a94ddda46da) ([merge request](gitlab-org/gitlab!146897))
- [Fix import of Gitea projects with a dot in owner name or project name](gitlab-org/gitlab@8c3c45e68887a072ac12ae3280bb5b0b489ba215) by @Cerdic ([merge request](gitlab-org/gitlab!146168))
- [Strip namespaces from OS component names](gitlab-org/gitlab@4f416b69ff375b7f200eb903ae37855d3a3cb9e9) ([merge request](gitlab-org/gitlab!145613)) **GitLab Enterprise Edition**
- [Fix check for adminPath in home_panel.vue](gitlab-org/gitlab@5d16553bf2053166eedd63a6cf96f9bfc0f42f10) ([merge request](gitlab-org/gitlab!147562))
- [Keep scope conditions for associations](gitlab-org/gitlab@0ce8a7ae2f050ed3b4b2ec190e98edf31e049c62) ([merge request](gitlab-org/gitlab!147550))
- [Fix the case when mirror trigger builds is not set](gitlab-org/gitlab@9bc3be7276d094256814b2b16e78a3c9ed520f2f) ([merge request](gitlab-org/gitlab!147545)) **GitLab Enterprise Edition**
- [Fix new project group templates pagination](gitlab-org/gitlab@2c5f068a0ab0e187cc564fda6a4765431d8a6a24) ([merge request](gitlab-org/gitlab!147534)) **GitLab Enterprise Edition**
- [Fixes update analytics dashboards project settings](gitlab-org/gitlab@f095431a0d6bbeca0a94b3b4b515ac8e440bbb41) ([merge request](gitlab-org/gitlab!147533)) **GitLab Enterprise Edition**
- [Change CRM Contacts help icon color](gitlab-org/gitlab@337c6ce961bc7bd1a514d3cbfc6b98068a8f08fd) ([merge request](gitlab-org/gitlab!147331))
- [Fix line width which separating the timeline events](gitlab-org/gitlab@fc17d327787945dc7d7a493c65ce30ce8a7d5cc1) by @antonkalmykov ([merge request](gitlab-org/gitlab!147037))
- [Pipeline Sec Report: handle Jira issues](gitlab-org/gitlab@e80220aa097b1ff7e304c5669da175773d1121e0) ([merge request](gitlab-org/gitlab!147102)) **GitLab Enterprise Edition**
- [Enable 'self' in Content-Security-Policy worker-src directive](gitlab-org/gitlab@52ec8103551d0b5fbcaf3d1b02cbcaa9ffe441a1) ([merge request](gitlab-org/gitlab!147472))
- [Ensure labels in inapplicable task list items are crossed out](gitlab-org/gitlab@4b6db3fe08157be75d3a286e6f1557ef864caacc) ([merge request](gitlab-org/gitlab!147361))
- [Delete callback should use namespace_id](gitlab-org/gitlab@2e0540f4a5b45f9245103f3fa17356c24e885192) ([merge request](gitlab-org/gitlab!147459)) **GitLab Enterprise Edition**
- [Fix the permission check for pull mirroring](gitlab-org/gitlab@4249c03c44f11d49b4c201c5b1247513cffd0c43) ([merge request](gitlab-org/gitlab!146899)) **GitLab Enterprise Edition**
- [Update pages ci templates - JBake, Jekyll, Jigsaw](gitlab-org/gitlab@74943a41a628eb764472c0fd3809e46c4bb1095d) ([merge request](gitlab-org/gitlab!146529))
- [Fix Vite HMR Content Security Policy rules](gitlab-org/gitlab@25f1a1d56fc1b814ff921535ef333997fae038a2) ([merge request](gitlab-org/gitlab!147366))
- [Fix breadcrumb style broken in external_file page](gitlab-org/gitlab@2316e9dcb069aac982fba0133b41a300a4feefe3) ([merge request](gitlab-org/gitlab!143597))
- [Remove indentation logic to fix Objective child list](gitlab-org/gitlab@72e68aec2d83e5f17b599691190a8c7bfcaa4474) ([merge request](gitlab-org/gitlab!147391))
- [Adjust border radius of rounded note input](gitlab-org/gitlab@928efabcb3b056876cb6c57d5251372d7b6ab130) ([merge request](gitlab-org/gitlab!147385))
- [Project item template: Fix alignment of CI/CD Catalog badge](gitlab-org/gitlab@ed2a3f707a789699f6ee402644572f9744aef9d7) ([merge request](gitlab-org/gitlab!147416))
- [Return 401 when user sign ins but password authentication is not allowed](gitlab-org/gitlab@2fc17dcf0951ab65e7962ef1bbc3d47a5dd1b4f2) ([merge request](gitlab-org/gitlab!147343))
- [Fix autocomplete for long items](gitlab-org/gitlab@6afbbc07bbf56afed66be66b1cded2a413bed70e) ([merge request](gitlab-org/gitlab!147337))
- [Fix scheduling service statement timeout](gitlab-org/gitlab@f3611dd958710be31e1d39d723d8c07bc130f393) ([merge request](gitlab-org/gitlab!147328)) **GitLab Enterprise Edition**
- [Make the recently added not null migration no-op](gitlab-org/gitlab@9025c5e6f7f024288497f64a8f00e364ff1d96e8) ([merge request](gitlab-org/gitlab!147264))
- [Fix the deprecated_properties method](gitlab-org/gitlab@fbed1c09ebb3a46e8403e992300986f4b9dba2e7) ([merge request](gitlab-org/gitlab!147281)) **GitLab Enterprise Edition**
- [Allow reset password when password auth is partially disabled](gitlab-org/gitlab@9198967aa9291c96da56547a853f101334be87d8) ([merge request](gitlab-org/gitlab!147198))
- [Upgrade gitlab-fog-azure-rm to v1.9.1](gitlab-org/gitlab@e3a40763932e46429ce3e826356badccf654bf60) ([merge request](gitlab-org/gitlab!147219))
- [Fix commit markdown parsing with word boundaries](gitlab-org/gitlab@9fc957662b0b2692306cc66cec89cdb4abbf1074) ([merge request](gitlab-org/gitlab!147185))
- [Record unassignment notes for removed member](gitlab-org/gitlab@40f479d5fdc34e1886d6aaca2d8e0b4cfaf12286) by @euko ([merge request](gitlab-org/gitlab!146735))
- [Fix Gitlab::HTTP_V2 allowed_internal_uris https scheme](gitlab-org/gitlab@c67777cf68bae073be21610e387e458b9de08d58) ([merge request](gitlab-org/gitlab!146919))
- [Transfer group labels](gitlab-org/gitlab@4011fd1f703072aaf5e2e21573246ae0071ebcb6) by @euko ([merge request](gitlab-org/gitlab!146727))

### Changed (167 changes)

- [Place relation import endpoint behind feature flag](gitlab-org/gitlab@32fa8cc96bc1866a3a2e1be517dddc0b5bb4eeec) ([merge request](gitlab-org/gitlab!149444))
- [Add Google Artifact Registry count to Service Ping](gitlab-org/gitlab@fb05c4f181c1ddd5bed877219abb0db97612a31d) ([merge request](gitlab-org/gitlab!148414)) **GitLab Enterprise Edition**
- [Enable approval rues drawer feature flag](gitlab-org/gitlab@24c5aabcfb278469bcc956ae76f618066318272f) ([merge request](gitlab-org/gitlab!149045))
- [Not throwing error when token not present](gitlab-org/gitlab@b5d98289e3724bc9bd3f7782a7a99e2fcf90907d) ([merge request](gitlab-org/gitlab!149392))
- [Add help text for agent selector on env settings page](gitlab-org/gitlab@e949eae157b441f2593195d384359a8fee83b8e6) by @jzeng88 ([merge request](gitlab-org/gitlab!149033))
- [Improve system note messaging for assumed merges](gitlab-org/gitlab@74389c2bcd8fafb3324f1459a4b0dde111636f2c) ([merge request](gitlab-org/gitlab!148147))
- [Export for the new frameworks report (frontend)](gitlab-org/gitlab@50dd9ced39e545544a5d75f11001512c0241a7b7) ([merge request](gitlab-org/gitlab!146740)) **GitLab Enterprise Edition**
- [Redirect profile ssh keys to user settings](gitlab-org/gitlab@c1544549d186064042ebdbc5d842ece1b06c1457) ([merge request](gitlab-org/gitlab!148081)) **GitLab Enterprise Edition**
- [Fix deprecated properties method for multiple policies](gitlab-org/gitlab@1cdb8a3b5087fd46891e9c74ad232214a9521c7e) ([merge request](gitlab-org/gitlab!149264)) **GitLab Enterprise Edition**
- [Enable moving issue children by default](gitlab-org/gitlab@10fa5542b53ff7e08d95b81f8d0cf60a52f6a5c0) ([merge request](gitlab-org/gitlab!149156))
- [Redirect profile gpg keys to user settings](gitlab-org/gitlab@9870ed2063627121b5bb39760e080cb10ba585d7) ([merge request](gitlab-org/gitlab!148528))
- [Enable epic_color_highlight feature flag by default](gitlab-org/gitlab@a16fce87696a265f2ad8dcc136996eda03bbf99a) ([merge request](gitlab-org/gitlab!149147)) **GitLab Enterprise Edition**
- [Display descendant policies in compliance framework report](gitlab-org/gitlab@60f154d4d3397f29754bdfbc440e1ff8839576fb) ([merge request](gitlab-org/gitlab!149116)) **GitLab Enterprise Edition**
- [Allow relation tree restorer to import single relation](gitlab-org/gitlab@485fd4aaa0a12565e6283aeb92e8fe165e969da2) ([merge request](gitlab-org/gitlab!147904))
- [Enable analytics dashboards animations and floating panels](gitlab-org/gitlab@fa00531c81e38d1190ced75830ff1dd7cc4281f5) ([merge request](gitlab-org/gitlab!149081)) **GitLab Enterprise Edition**
- [Update feature flag modal text](gitlab-org/gitlab@2b12f90a49a2fd657f19aac06999e2727226750c) ([merge request](gitlab-org/gitlab!149261))
- [This MR updates copy for pipeline execution type](gitlab-org/gitlab@7a3d9c2f87c0238d1275d1f97279b7297ffb61d1) ([merge request](gitlab-org/gitlab!149187)) **GitLab Enterprise Edition**
- [Add pagination for the approval rules in the `Merge requests` settings](gitlab-org/gitlab@487e19f41dc759770bfcb32949a385fe5831d727) by @antonkalmykov ([merge request](gitlab-org/gitlab!148824)) **GitLab Enterprise Edition**
- [Remove orphaned indices for a namespace](gitlab-org/gitlab@831bcba18bd90a6487706032e70371102ee4305d) ([merge request](gitlab-org/gitlab!147482)) **GitLab Enterprise Edition**
- [Update dependency auto-deploy-image to v2.89.0](gitlab-org/gitlab@63927f21846020d245304dc862db5f7301093804) ([merge request](gitlab-org/gitlab!149236))
- [Hide the `created_by` attribute from group/project non-admins](gitlab-org/gitlab@6acf810b4ca85ff48aba72c3e8296054abfb86a3) ([merge request](gitlab-org/gitlab!147870))
- [Limit counters on group deletion](gitlab-org/gitlab@9c060bc84c6ebfd01fb1d227e40ffb3bb20c5094) ([merge request](gitlab-org/gitlab!148575))
- [Remove Beta Labels from DuoChat Callout and Sidebar](gitlab-org/gitlab@206234fc578c9ccf64b9c452ae9064cd70aca586) ([merge request](gitlab-org/gitlab!149177)) **GitLab Enterprise Edition**
- [Add unicode_escaped_blob field](gitlab-org/gitlab@0a06e1dcb2474f866e2f335cee2d0cb3c6886db3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/139090))
- [Swap pipeline columns for p_ci_builds](gitlab-org/gitlab@44449068f2b450e2cbaa8feae58f819275bdb3f5) ([merge request](gitlab-org/gitlab!146759))
- [Add info about release notes for policy rename](gitlab-org/gitlab@21782f49f506e21424294ef9ae73ad0bb3d2235a) ([merge request](gitlab-org/gitlab!148144)) **GitLab Enterprise Edition**
- [MR widget: Use secondary text style for merge train message](gitlab-org/gitlab@d79f1d4a3da2ff601038c0432a101320307d577c) ([merge request](gitlab-org/gitlab!149131)) **GitLab Enterprise Edition**
- [Snippets: Move embed and clone to actions](gitlab-org/gitlab@3d46019e187930303752f7cdec0e4ca7b9786688) ([merge request](gitlab-org/gitlab!147996))
- [MR list: Show self approval](gitlab-org/gitlab@eec8884f56aa7276e391c24d8e67c8ec457a001c) ([merge request](gitlab-org/gitlab!149092))
- [Update design of the pipeline graph](gitlab-org/gitlab@8a05ff09c54f5a840816308468fab1046be712ea) ([merge request](gitlab-org/gitlab!149068))
- [Pipeline overview page: Migrate dropdown to GlDisclosureDropdown](gitlab-org/gitlab@a45e646fe225ee4a9cbb6ae0546d614803dac5fd) ([merge request](gitlab-org/gitlab!147273))
- [Reduce sbom_occurrences table writes](gitlab-org/gitlab@f1e0086cfba47720fd5a07ea38c9a9c9640b4da5) ([merge request](gitlab-org/gitlab!148868)) **GitLab Enterprise Edition**
- [Added information to product analytics docs](gitlab-org/gitlab@6e8750493f2418655d88f21d778a95529326aab3) ([merge request](gitlab-org/gitlab!148601)) **GitLab Enterprise Edition**
- [Add the container to the cadence validation ff check](gitlab-org/gitlab@47ae7f5dce7b4bcf3cf91bd89c026ad697eab088) ([merge request](gitlab-org/gitlab!148892)) **GitLab Enterprise Edition**
- [Fix project overview bugs](gitlab-org/gitlab@cabb403855e5ae6a8d4f1f700a7425376a24b7a4) ([merge request](gitlab-org/gitlab!148953))
- [Allow relation tree restorer to import single relation](gitlab-org/gitlab@ff17628fb19918ed0cf774fd5f48ab55101b740c) ([merge request](gitlab-org/gitlab!147913))
- [Remove `scan_result_policies_block_unprotecting_branches` feature flag](gitlab-org/gitlab@9056627110b4ac647b32ddf6810f20c4b7333855) ([merge request](gitlab-org/gitlab!148549)) **GitLab Enterprise Edition**
- [Left-align activity timestamps on mobile](gitlab-org/gitlab@30c223251024930c15fad63342595d8b8e3c35b9) ([merge request](gitlab-org/gitlab!148711))
- [Remove the need for SaaS to configure Product Analytics](gitlab-org/gitlab@85eb339cec332c1392d753fd789bd937d70388c7) ([merge request](gitlab-org/gitlab!147833))
- [Add action menu to milestone row on milestones page](gitlab-org/gitlab@d9895d13de20db638e261cac294152df83b98341) ([merge request](gitlab-org/gitlab!148219))
- [Move viewed file tooltip to the left; only show on hover](gitlab-org/gitlab@11105fe52389dfb17a10e39ea4b7b4995c5ee440) ([merge request](gitlab-org/gitlab!148558))
- [Capture running builds on non-shared runners](gitlab-org/gitlab@d299c78fa96ee76d16a95524cf04cf5f8bc0c708) ([merge request](gitlab-org/gitlab!147943))
- [Update epics foreign key on parent_id to nullify on delete](gitlab-org/gitlab@c6e4f7e2c0add5e048a32bd73e5113387add0ff5) ([merge request](gitlab-org/gitlab!148522))
- [Merge request list: Improve approvals](gitlab-org/gitlab@443aab39ec9ac0a79299b6947cda09d9194d594b) ([merge request](gitlab-org/gitlab!148364))
- [Add metadata database alert to registry pages in the UI](gitlab-org/gitlab@062eea6b2627d81ff3f8fb2ef36178f0e45d68bc) ([merge request](gitlab-org/gitlab!147503))
- [Enable `security_policies_unassign_redundant_policy_projects` FF](gitlab-org/gitlab@3c0bbcf05586a51dded19fe27d396ded619be706) ([merge request](gitlab-org/gitlab!148741)) **GitLab Enterprise Edition**
- [Add a `personal` argument to `Query.projects`](gitlab-org/gitlab@2ae86907e57e69350029b9cd11f5219172542355) by @yasuk ([merge request](gitlab-org/gitlab!148393))
- [Combine snippet embed and clone buttons into single code dropdown](gitlab-org/gitlab@4b8561afa2018da16348d43eb277cad8953b437b) ([merge request](gitlab-org/gitlab!147719))
- [Drop workhorse_google_client feature flag](gitlab-org/gitlab@2715b0369da54560ccdc51f524f3187228620713) ([merge request](gitlab-org/gitlab!148755))
- [Update text in deployment approval modal](gitlab-org/gitlab@5951bfd01255d5d0b9b1370317830cde22230238) ([merge request](gitlab-org/gitlab!148588)) **GitLab Enterprise Edition**
- [Distribute scheduled pipelines from Scan Execution Policy](gitlab-org/gitlab@7c1cac1a853639ab9a047f2d44ac39befe117ae1) ([merge request](gitlab-org/gitlab!145993)) **GitLab Enterprise Edition**
- [Update DevOps Reports illustrations](gitlab-org/gitlab@bfb5623d0b7ac5860f94c786c46cba71d6748fc0) ([merge request](gitlab-org/gitlab!148530)) **GitLab Enterprise Edition**
- [Update DevOps Adoption empty state illustration](gitlab-org/gitlab@f5df939dbb72e467918ea00eab9a269840c510ca) ([merge request](gitlab-org/gitlab!148546)) **GitLab Enterprise Edition**
- [Update ES shard size rake task and guidelines](gitlab-org/gitlab@9f48a818e5c0724bc5201c20ad68b7ad77e2cadb) ([merge request](gitlab-org/gitlab!146108)) **GitLab Enterprise Edition**
- [Update release empty state illustration](gitlab-org/gitlab@ab374d34bb7948dca1da5023ef301b8b2b8627de) ([merge request](gitlab-org/gitlab!148526))
- [Add sales call to action when onboarding without purchase](gitlab-org/gitlab@7355dafcd25f41bea162fec4c3ee0dfe8ac4daf4) ([merge request](gitlab-org/gitlab!148439)) **GitLab Enterprise Edition**
- [Moves ml_experiment_tracking to group::mlops](gitlab-org/gitlab@a398f1a46638db397f1772498e9f5026a3b85339) ([merge request](gitlab-org/gitlab!148533))
- [Truncate individual names](gitlab-org/gitlab@804f6efec7ef7c89405026f9a51c7c5d0e04e343) ([merge request](gitlab-org/gitlab!144369))
- [Replace GlAvatar with ProjectAvatar in GroupItems](gitlab-org/gitlab@7bcb4defeab1ac52da0e58d8256e8b9d5027668a) by @espadav8 ([merge request](gitlab-org/gitlab!148464))
- [Adjust default_enabled to true for wiki_content_background_job flag](gitlab-org/gitlab@672d92d44977ef0c1e8eaae7ecb85629f743e79a) by @ivantedja ([merge request](gitlab-org/gitlab!148616))
- [Remove sub-header background from Compare revisions form](gitlab-org/gitlab@bbcf8f8cb4c63cfa0f4472edec747dfae0420ac2) by @espadav8 ([merge request](gitlab-org/gitlab!148614))
- [Search iterations in descending order](gitlab-org/gitlab@17b0039b731cf31a7046720ecfe5d788b3fa070d) ([merge request](gitlab-org/gitlab!148465)) **GitLab Enterprise Edition**
- [Allow admins to disable runner registration token](gitlab-org/gitlab@7e4b4f7d0375b4d8a53ceb2705bc8280b3aae999) ([merge request](gitlab-org/gitlab!147559))
- [Update issue filter search illustration](gitlab-org/gitlab@a23f546fc0c705257782abdac946b64451e8fa03) ([merge request](gitlab-org/gitlab!148521))
- [Trigger search file modal when searching](gitlab-org/gitlab@d421d9cb81acaf422ecb04468450d23c03be74aa) ([merge request](gitlab-org/gitlab!148025))
- [Cleanup web_ide_settings_sync feature flag](gitlab-org/gitlab@512cf3f80903e3288400ca93b71a73012299b32c) ([merge request](gitlab-org/gitlab!148365))
- [Update color and spacing of releases page](gitlab-org/gitlab@09fc52c7762f812780bb35269be5de844e14a06e) ([merge request](gitlab-org/gitlab!148474))
- [Make merge conflict file stand out more](gitlab-org/gitlab@fae96877f76f666ba5c33552f22a28c2b9804eef) ([merge request](gitlab-org/gitlab!147654))
- [Update the cadence documentation for sep](gitlab-org/gitlab@2605c360256f47423ba2975003307dfa85a330ce) ([merge request](gitlab-org/gitlab!148109))
- [Add alphabetical sort for branch names](gitlab-org/gitlab@4a0c51d52c0ff087c553328034c11b0c7b0d7060) by @gauravmarwal ([merge request](gitlab-org/gitlab!147034))
- [Enable product_analytics_beta_option by default](gitlab-org/gitlab@3122e16371dc4e2e9330698d87f94cd6b5323add) ([merge request](gitlab-org/gitlab!148422))
- [Make product_analytics_dashboards default enabled](gitlab-org/gitlab@104c9d4aef2c258181c15287589c8d4983be4637) ([merge request](gitlab-org/gitlab!148381))
- [Add a validation to the scan execution policy cadence](gitlab-org/gitlab@3a3160b708ae1e67ef4a5ea738e447e9fc5b09d1) ([merge request](gitlab-org/gitlab!147576)) **GitLab Enterprise Edition**
- [Update MR changes empty state](gitlab-org/gitlab@d19cd4d747086f4677358fa7ea05484f659535fd) ([merge request](gitlab-org/gitlab!148051))
- [Adds logo to MattermostSlashCommands](gitlab-org/gitlab@558a96afcba39e3d57af296cea1ec4d714adb4e3) ([merge request](gitlab-org/gitlab!148373))
- [Update analytics dashboard observability](gitlab-org/gitlab@0f0627036905f892fe8b0cbb2afe459813ecbeb4) ([merge request](gitlab-org/gitlab!147163)) **GitLab Enterprise Edition**
- [Keep compliance frameworks for project transfers](gitlab-org/gitlab@b81b52b2c67664dd1dc941ab0e431d59d7869288) ([merge request](gitlab-org/gitlab!148142)) **GitLab Enterprise Edition**
- [This MR adds scope column to policies list](gitlab-org/gitlab@9d50f342072abdfe87a44b80c8eb5ef9662c118e) ([merge request](gitlab-org/gitlab!145047)) **GitLab Enterprise Edition**
- [Refactor BulkIndexer to able to handle other document references](gitlab-org/gitlab@2da4b1ca443ede7a42ecafbafbf1d37e9b6cfd45) ([merge request](gitlab-org/gitlab!146491)) **GitLab Enterprise Edition**
- [Add Mattermost logo](gitlab-org/gitlab@f3bd984876b13ea6328327f36314167cef9c0051) ([merge request](gitlab-org/gitlab!147893))
- [Blocks unprovisioned access to product analytics apis](gitlab-org/gitlab@f58377548fa9370b80861dcf52d3ec48fbf8d484) ([merge request](gitlab-org/gitlab!147841)) **GitLab Enterprise Edition**
- [Add empty state for sidebar CRM widget](gitlab-org/gitlab@b764d0da8be493cfd4ff961b659fc982e827f55e) ([merge request](gitlab-org/gitlab!147694))
- [Snippets delete modal improvements](gitlab-org/gitlab@0898b4148bc60063d3785eb2273247d67b6689c8) ([merge request](gitlab-org/gitlab!148044))
- [This MR adds branch exceptions selector](gitlab-org/gitlab@2c9b4b8a89f12fe9bb6a6f1f0053cedde65dbe6c) ([merge request](gitlab-org/gitlab!141650)) **GitLab Enterprise Edition**
- [Move Google Cloud instructions to reduce duplication](gitlab-org/gitlab@9ac8d4aa4d79650640828f28e46b5e721ae5a9a1) ([merge request](gitlab-org/gitlab!148190))
- [Adding alert for duo pro trials for existing users](gitlab-org/gitlab@f43b7f57087aaf6b9e2bbd94aeb057e5c494e9bd) ([merge request](gitlab-org/gitlab!148012)) **GitLab Enterprise Edition**
- [Deprecate security_auto_fix from graphql type](gitlab-org/gitlab@a69eb00b15bf14aae02ae885c9aefcee38cd5e9f) ([merge request](gitlab-org/gitlab!147157))
- [Show package processing error message returned from API](gitlab-org/gitlab@03da4ea38f9d5acec50d9499c9e27193b70d3810) ([merge request](gitlab-org/gitlab!147026))
- [Add columns for require_reauthentication_to_approve](gitlab-org/gitlab@24c9690f099da9fead2a364b87aef39cc08fc851) ([merge request](gitlab-org/gitlab!146374))
- [MR more actions dropdown: Improve alignment on small viewports](gitlab-org/gitlab@e8950e4bc438552fa65da59ed6b22d08bb30423d) ([merge request](gitlab-org/gitlab!148000))
- [Issuables: Improve more actions on smaller devices](gitlab-org/gitlab@1cbafae293a2d030eca6b5c36119d070e849c04b) ([merge request](gitlab-org/gitlab!147999))
- [Update CreateIssueForm to support Japanese IME](gitlab-org/gitlab@b1a1cf97ed248a5d20e926b7e629aff1ccb489e0) ([merge request](gitlab-org/gitlab!147814)) **GitLab Enterprise Edition**
- [Snippets page: Adjust header elements to match issuables](gitlab-org/gitlab@228280f9ef67c19f739f5113367457c2cfdc6419) ([merge request](gitlab-org/gitlab!147451))
- [Change button text from "Create/add new role" to "Create role"](gitlab-org/gitlab@da8245685deb6715a760d2c7dcc43cb1d123b86e) ([merge request](gitlab-org/gitlab!147507)) **GitLab Enterprise Edition**
- [Collapse sidebar on ESC key if in overlay mode](gitlab-org/gitlab@fdc93c8c76210fb393cd469fbc2223a9f76ca12d) ([merge request](gitlab-org/gitlab!147001))
- [Stop calling the migration's workers and update them to no-op](gitlab-org/gitlab@511b7db63830f0370845f950816c90b6d45d69fe) ([merge request](gitlab-org/gitlab!147228))
- [Unify the more actions kebab menu tooltip behavior](gitlab-org/gitlab@aa4126f55207d6849c97ffce972fd4a7ad840b32) ([merge request](gitlab-org/gitlab!147540))
- [Snippets page: Migrates dropdown to GlDisclosureDropdown](gitlab-org/gitlab@c475073d10e440e33bf4929ec911201eecd4336a) ([merge request](gitlab-org/gitlab!147518))
- [Update dependency auto-deploy-image to v2.88.0](gitlab-org/gitlab@a69a8c5cfba9d2949d266f358a772c008dbf4ec3) ([merge request](gitlab-org/gitlab!147935))
- [Improve UX feedback when project deploy feature flags limit is reached](gitlab-org/gitlab@584c89afc0260ae41f48a6b96f91c7e0931b75af) by @antonkalmykov ([merge request](gitlab-org/gitlab!147446))
- [Add provider selection in product analytics onboarding](gitlab-org/gitlab@1940cd0405f1cb0f9747f3f25c8cfeb1c889dd21) ([merge request](gitlab-org/gitlab!145880)) **GitLab Enterprise Edition**
- [Add descendant filter to security policies graphql query](gitlab-org/gitlab@15ac762e945f3e1488c059eb57302139bba077f0) ([merge request](gitlab-org/gitlab!145825)) **GitLab Enterprise Edition**
- [Clarify supported signed commits types](gitlab-org/gitlab@d9d9f2115fdb93ced6c7713da36cb2c4a11328ab) ([merge request](gitlab-org/gitlab!147556)) **GitLab Enterprise Edition**
- [Edit branch rule name](gitlab-org/gitlab@2ac027412c70a4a76c037c7d06518155a32d5eb3) ([merge request](gitlab-org/gitlab!147308))
- [Improve license matching when evaluating policies](gitlab-org/gitlab@40c4f39deecdb36b7ffa2dd49981b1c10a11b926) ([merge request](gitlab-org/gitlab!147598)) **GitLab Enterprise Edition**
- [Update project and group transfer modal text](gitlab-org/gitlab@c2515558105c95c1220b41a500ec422eb4f8e441) ([merge request](gitlab-org/gitlab!146938))
- [Updated gitlab-ui and refactored duo chat](gitlab-org/gitlab@0e4cea3574e69fe33f2c546d16ad2712666d9006) ([merge request](gitlab-org/gitlab!147802)) **GitLab Enterprise Edition**
- [This MR adds policy scope to a drawer](gitlab-org/gitlab@9ae60e3cf90df6e51e89325d36e6684fcd2428be) ([merge request](gitlab-org/gitlab!145567)) **GitLab Enterprise Edition**
- [Add empty state for discussion in sidebar](gitlab-org/gitlab@5a172ca1a1db009c5d50bc4b3ca8148aca8ee837) ([merge request](gitlab-org/gitlab!147642))
- [Remove namespace alias from DORA performance counts](gitlab-org/gitlab@a6287c22842e298fd8865016112f4e40dbb54c3d) by @jzeng88 ([merge request](gitlab-org/gitlab!147400)) **GitLab Enterprise Edition**
- [Update importers to use application settings to limit number of jobs](gitlab-org/gitlab@3254590fd2105fcd995f0ccb5e0b3e214c9a59c6) ([merge request](gitlab-org/gitlab!143875))
- [Add placeholder and validation for linkedin profile input](gitlab-org/gitlab@0381be4712ae81e508abe78b292c6fc1fabef6b1) ([merge request](gitlab-org/gitlab!147288))
- [Set AddOnPurchase trail value in CreateService](gitlab-org/gitlab@13174ab1ce2ee8a94cee7b3b8cfba5ee0b4ab221) ([merge request](gitlab-org/gitlab!147764)) **GitLab Enterprise Edition**
- [Use static_holmes instead of charlock_holmes](gitlab-org/gitlab@4f5136b7735810d03ce9aa20b5257ccec446808a) ([merge request](gitlab-org/gitlab!147721))
- [Make consistent padding in the package asset table row](gitlab-org/gitlab@925520fe0473c090a78cdc89baee0c41176a62cc) by @antonkalmykov ([merge request](gitlab-org/gitlab!147211))
- [Add groups_direct field in JWT for Vault integration](gitlab-org/gitlab@3b628813eff7ddd1ef085708e2fb63df3536d899) by @alexandru.jieanu ([merge request](gitlab-org/gitlab!146881))
- [Export for the new frameworks report (backend)](gitlab-org/gitlab@3bac11cb79bf24c72b15082fe484a06edc411936) ([merge request](gitlab-org/gitlab!144815)) **GitLab Enterprise Edition**
- [This MR changes key name for license rule](gitlab-org/gitlab@9a8e4548524fe903b5b988e1e0aba048d3a0a535) ([merge request](gitlab-org/gitlab!147184)) **GitLab Enterprise Edition**
- [Well segment: Change border color to default gray-100](gitlab-org/gitlab@8fa2fbf74694b5932162f222cb3409baaf4b4b2c) ([merge request](gitlab-org/gitlab!147674))
- [Reorganization project overview page](gitlab-org/gitlab@f0af2950542c1329cafa13342cf6b86bde3f2d03) ([merge request](gitlab-org/gitlab!145678))
- [Fix formatting of issue summaries](gitlab-org/gitlab@8622a816cd7cfc298cce6e28d79525dbf80de204) ([merge request](gitlab-org/gitlab!147466)) **GitLab Enterprise Edition**
- [Use textarea for collapsed snippet description](gitlab-org/gitlab@e637e32fb073ff0cd16a7f4f6d472ffa02415845) ([merge request](gitlab-org/gitlab!147585))
- [Disable file path input until project is selected](gitlab-org/gitlab@8fe848cbafaf0b786efffa28a2b4c5814fdcf652) ([merge request](gitlab-org/gitlab!147307))
- [Fix and refactor snippets list view](gitlab-org/gitlab@ee9bb496ca85487ded7e6599c608bc596cc39b1b) ([merge request](gitlab-org/gitlab!147580))
- [Update markdown styles for quoted lists](gitlab-org/gitlab@58ad2dbb905877f7d1934798c6e630c50722ef6f) ([merge request](gitlab-org/gitlab!147646))
- [Upgrade Elasticsearch version to 8.11.4](gitlab-org/gitlab@04103822e6731f1f69d806f5e0378425472b3231) ([merge request](gitlab-org/gitlab!147527))
- [Hide invited group name and source from project/group non-admins](gitlab-org/gitlab@a984f85ae821842538743d453fd3c26c79b2a636) ([merge request](gitlab-org/gitlab!147629))
- [Show Duo Pro button for ultimate trial](gitlab-org/gitlab@1a126e4bbf21e6056919d0d9e35302971025e22d) ([merge request](gitlab-org/gitlab!147548)) **GitLab Enterprise Edition**
- [Remove claude 2.1 feature flag](gitlab-org/gitlab@04c4cec133da5f095ddccc6b80304f01fd55bc58) ([merge request](gitlab-org/gitlab!147253))
- [Delete redundant policy configurations on assignment](gitlab-org/gitlab@bd8219a5ff8924b192e830bd0d9b0828f16d749c) ([merge request](gitlab-org/gitlab!143668)) **GitLab Enterprise Edition**
- [Add $gl-padding  margin bottom to <summary> in open <details>](gitlab-org/gitlab@32c118ce721f62f18cafea19fa615e1e3cb51dbd) ([merge request](gitlab-org/gitlab!147492))
- [Remove CI_COMPONENT_FQDN variable](gitlab-org/gitlab@c5497cf4aa3287d5cd2d817db2e8b09e07f03c0c) ([merge request](gitlab-org/gitlab!146797))
- [Updates model registry table docs with correct schema](gitlab-org/gitlab@aa3c9018fb4dbd623fc8cdbcb55a5a791d45d250) ([merge request](gitlab-org/gitlab!146898))
- [Migrate button-class-vue in todo.vue](gitlab-org/gitlab@69ef496e2898633f7884b94f160f5553450bd3e1) ([merge request](gitlab-org/gitlab!147203))
- [Cleanup snippets edit page](gitlab-org/gitlab@fe21c3ef651f3d5d508d1d179ed2f1a02d5997c9) ([merge request](gitlab-org/gitlab!147442))
- [Update deprecation milestone for job token setting](gitlab-org/gitlab@6097ab4273c38d2b7625e79107940e282108c90c) ([merge request](gitlab-org/gitlab!147320))
- [Change username validation message](gitlab-org/gitlab@cbafeab9d89686143a214b0f632b322eb0274ae6) by @jzeng88 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/147213)) **GitLab Enterprise Edition**
- [Backport Work Item copy changes to legacy issuables](gitlab-org/gitlab@ca1533961fe1ff8a841ebb1e36f4ea3b6638b079) ([merge request](gitlab-org/gitlab!147369))
- [Updating tab title](gitlab-org/gitlab@f1d14b00ecadcc50cadb3024ff9640d5d21a7af9) ([merge request](gitlab-org/gitlab!147094))
- [Display project and subgroup counters when deleting group](gitlab-org/gitlab@1b001708ad7aacdee9c7f537ceacf314ed7c315d) ([merge request](gitlab-org/gitlab!145838))
- [Issuables: Mark destructive action (delete) as such](gitlab-org/gitlab@8f64896cfa3c2b55442762864d90b9cf56111b8a) ([merge request](gitlab-org/gitlab!147441))
- [Migrates user access badge to use GlBadge](gitlab-org/gitlab@0afdd01a0e777d74960ca04349bf1ba01ce0c03b) ([merge request](gitlab-org/gitlab!147437))
- [Add logging for JWT errors](gitlab-org/gitlab@bbad75c4d5811a645fca9a71b70b637820da729b) ([merge request](gitlab-org/gitlab!147234))
- [Add thread count and remove participants from sidebar](gitlab-org/gitlab@80ea76d941891c82d7239ed2996f7d2db9aff364) ([merge request](gitlab-org/gitlab!146037))
- [User profile: Hide sidebar if user is blocked](gitlab-org/gitlab@366b3ce92586831e4ea910ac960332c4ae403649) ([merge request](gitlab-org/gitlab!147354))
- [Improved CI YAML schema tests](gitlab-org/gitlab@097f279544068ada7441e865b1f5819ff1b97b8e) by @zillemarco ([merge request](gitlab-org/gitlab!139716))
- [Fix runner form headings to match Pajamas](gitlab-org/gitlab@be576ce1ed8e7b68eff6563d1571bd8c29957b36) ([merge request](gitlab-org/gitlab!146383))
- [Display created and finshed pipeline times](gitlab-org/gitlab@d0c74ae64c7a80223183186099ec6efd6a2fbb21) ([merge request](gitlab-org/gitlab!147060))
- [Use standardized panel errors for Value stream dashboard](gitlab-org/gitlab@86a9a9194dd2a61263440f31441c177ad3e3990a) ([merge request](gitlab-org/gitlab!147287)) **GitLab Enterprise Edition**
- [Add tooltip to snippet visibility icon](gitlab-org/gitlab@442bba2c81e87e6126a1fd74133194494a4dbfa4) ([merge request](gitlab-org/gitlab!147295))
- [Migrates code dropdown to Vue](gitlab-org/gitlab@60a1a8f38183f774e12fbc7d3a265bae05a6e62f) ([merge request](gitlab-org/gitlab!146633))
- [Cleaned up code_suggestions_ga_owner_alert feature flag](gitlab-org/gitlab@032cc3a042653d306ab8636d5dea204145073e43) ([merge request](gitlab-org/gitlab!146322)) **GitLab Enterprise Edition**
- [Improve loading states of sidebar items](gitlab-org/gitlab@beef7d7944736f4401c48eea519c27c5cae137e8) ([merge request](gitlab-org/gitlab!147330))
- [Log if pipeline creation limit might be exceeded](gitlab-org/gitlab@c1e13cf9138c4dc3ecd117739bedf1f6cda00385) ([merge request](gitlab-org/gitlab!147306))
- [Show deployment count](gitlab-org/gitlab@a5ca23c5cf5b6d515865c1c5051d3cf92b49dfcb) ([merge request](gitlab-org/gitlab!147280))
- [Refactor enterprise_user trait into factory](gitlab-org/gitlab@a18dd07b682299c653d63f44d30cc238441974f0) by @jzeng88 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/145626)) **GitLab Enterprise Edition**
- [Update dependency auto-deploy-image to v2.87.0](gitlab-org/gitlab@aa08f973bcfcaa3f61cc0aa632d3698c0a8f3751) ([merge request](gitlab-org/gitlab!147272))
- [Change username text color to use same across UI](gitlab-org/gitlab@18f99db2f182da23df0e4c31903159eb14e1db7c) ([merge request](gitlab-org/gitlab!147260))
- [Remove feature flag fetch_tags_from_registry_api](gitlab-org/gitlab@0e2677a0f6be7b37324b4db1a6fdcc39bd8eb1da) ([merge request](gitlab-org/gitlab!147233))
- [Remove api: API::Internal::ContainerRegistry::Migration](gitlab-org/gitlab@00886957027172084f211dff4d6a18ab0271b68e) ([merge request](gitlab-org/gitlab!147229))
- [Do not expand CI predefined `TRIGGER_PAYLOAD` variable](gitlab-org/gitlab@e91bece35975a4f2e5e0da30eec651a125d76da6) by @vytautasbert ([merge request](gitlab-org/gitlab!146242))
- [Block compliance fraework removal when there are linked policies](gitlab-org/gitlab@e417b94198995f065763e1d80e7d62da381417db) ([merge request](gitlab-org/gitlab!147041)) **GitLab Enterprise Edition**
- [Raise atom feed title length limit to 160 characters](gitlab-org/gitlab@fbddd8ad18df8794627ebb20279ac3315bbc5f72) by @kxxt ([merge request](gitlab-org/gitlab!145730))
- [Fix pagination issue on adherences report](gitlab-org/gitlab@7d8bf7fe05c5bf658ada58ff15408396db3dd653) ([merge request](gitlab-org/gitlab!147022)) **GitLab Enterprise Edition**
- [Trim further file content for code suggestions](gitlab-org/gitlab@abbfb78f8ec921a4cde20340e79d03da1e1cbe17) ([merge request](gitlab-org/gitlab!146977)) **GitLab Enterprise Edition**
- [Update milestone icon](gitlab-org/gitlab@0ef8adbdf7769f36c4747a3d3e9069a001bd14ff) ([merge request](gitlab-org/gitlab!146828)) **GitLab Enterprise Edition**
- [Reject project CI jobs on reserved policy stages](gitlab-org/gitlab@82a6d2066bbc73c5ee41be5ca630bd4101ec0ed4) ([merge request](gitlab-org/gitlab!146307)) **GitLab Enterprise Edition**

### Deprecated (1 change)

- [Deprecate GITLAB_SHARED_RUNNERS_REGISTRATION_TOKEN](gitlab-org/gitlab@b35c2cc49458a06c641f150802faa3604ae98cc4) ([merge request](gitlab-org/gitlab!148310))

### Removed (19 changes)

- [Remove about section](gitlab-org/gitlab@62fbee1ba9a04453909b25e24f4f7e5db0694d74) ([merge request](gitlab-org/gitlab!147948))
- [Remove CH analytics related feature flags](gitlab-org/gitlab@7f85033ebb8d6b46203a94626e2cab7cc145824e) ([merge request](gitlab-org/gitlab!148651)) **GitLab Enterprise Edition**
- [Remove modify_auto_fix_setting](gitlab-org/gitlab@67de5f0af68d99b3104e25004b9bb2930a89dc55) ([merge request](gitlab-org/gitlab!149286))
- [Remove beta badge](gitlab-org/gitlab@5cab24cfce096bb3203a8ffa1285ff11582fa353) ([merge request](gitlab-org/gitlab!149018))
- [Clean up default_to_import_tab experiment](gitlab-org/gitlab@163a262210660a0ce2328f9976e20ca46ebce1f7) ([merge request](gitlab-org/gitlab!149130))
- [Remove ff and policy information related to](gitlab-org/gitlab@00a8ca95ce9890bd44a2e077728f83550e5bc805) ([merge request](gitlab-org/gitlab!147202))
- [Remove the backend changes for automatic diff summary](gitlab-org/gitlab@397e3d8c6e6177b10b62d5507177ac2edb8e0155) ([merge request](gitlab-org/gitlab!148122))
- [Remove ignore column rule from GeoNodeStatus](gitlab-org/gitlab@9bc24bb9d4a09ff63bc9d31af8a353f93b87d1b2) ([merge request](gitlab-org/gitlab!148335)) **GitLab Enterprise Edition**
- [Remove runner registration compatibility alert](gitlab-org/gitlab@5213b04f44787bf348ed19e94ef2f38b50eb7785) ([merge request](gitlab-org/gitlab!148152))
- [refactor: Drop col 'package_name_pattern_ilike_query' Part 3](gitlab-org/gitlab@afc688f79144701a6f0c215c2f96fbd850f7aefc) by @gerardo-navarro ([merge request](gitlab-org/gitlab!142305))
- [Remove CI text interpolation code](gitlab-org/gitlab@96f86196a6571c751433fd7eda099446ce9a4ece) ([merge request](gitlab-org/gitlab!147803))
- [Clean up auto_fix related action and services](gitlab-org/gitlab@b8898d459cec9ae3122e698d446738b7f44ed200) ([merge request](gitlab-org/gitlab!147161)) **GitLab Enterprise Edition**
- [Remove final mentions of Ai::SyncServiceTokenWorker](gitlab-org/gitlab@f0a6080f0dd86678283a0e15c24bc6c2f24d44c7) ([merge request](gitlab-org/gitlab!147452)) **GitLab Enterprise Edition**
- [Remove github_import_extended_events feature flag](gitlab-org/gitlab@6052e8d7e8973b20a27a3575f732b4f04d02628a) ([merge request](gitlab-org/gitlab!146695))
- [CI/CD Catalog experiment badge](gitlab-org/gitlab@e249ed0e906fdc5d029a1db6b0ef38ca5baa8e1b) ([merge request](gitlab-org/gitlab!147630))
- [Remove CH materialized view rebuilding FFs](gitlab-org/gitlab@e593b34b6a5aa9e00be73d40cffd42cdb257dda7) ([merge request](gitlab-org/gitlab!146592))
- [Remove latest_version from Ci::Catalog::ResourceType](gitlab-org/gitlab@917b922b5f351a748e72fb00a49b6cf2d84b71c0) ([merge request](gitlab-org/gitlab!146913))
- [Remove frontend code for security_auto_fix with](gitlab-org/gitlab@f4d3dd1222a472ae144a87eed37462d1284de5bb) ([merge request](gitlab-org/gitlab!147078)) **GitLab Enterprise Edition**
- [Remove ignore column](gitlab-org/gitlab@fe8ca866391350852803c8b6670a9c0de18cd09f) by @imskr ([merge request](gitlab-org/gitlab!147250))

### Security (7 changes)

- [Fix stored xss using the gollum filter](gitlab-org/gitlab@8240472c85efd51938ad064ab5cc4a39e374d0c8) ([merge request](gitlab-org/gitlab!149158))
- [Update Gitlab::Regex::Packages#slack_link_regex](gitlab-org/gitlab@ea5f384a4e51d16b1fe00ba9233abc09fb2b92d6) ([merge request](gitlab-org/gitlab!149158))
- [Fix XSS in autocomplete in rich text editor](gitlab-org/gitlab@d3ca8e6cc9cc98a48d53d7f968cd922ded0d74f8) ([merge request](gitlab-org/gitlab!149158))
- [Correctly parse attachments for junit result](gitlab-org/gitlab@9a0357ac244a3c7282d73864d5792d1aff3f48dd) ([merge request](gitlab-org/gitlab!149158))
- [Fix stored xss in wikis using the abstract_reference_filter](gitlab-org/gitlab@4ba8bee6bb39fb830c592c57d5d4595411c8a9ad)
- [Limit the number of emojis we will transform](gitlab-org/gitlab@ce5a24e34504c1f4b4408c83ebb801a055809bea)
- [Remove `unsafe-inline` from CSP](gitlab-org/gitlab@a7a302b7484d972fa85e2003a799349c541077b4) ([merge request](gitlab-org/gitlab!147268))

### Performance (8 changes)

- [Preload `vulnerability_reads` for vulnerability records](gitlab-org/gitlab@a36e652efbb76203555cc3b5afd72d225eb5b047) ([merge request](gitlab-org/gitlab!149304)) **GitLab Enterprise Edition**
- [Preload releases for Tags API](gitlab-org/gitlab@5a78293c8227686315b62b1f429f7b6669b9f24f) ([merge request](gitlab-org/gitlab!140484))
- [Added index for member_approval on member_namespace_id and status](gitlab-org/gitlab@7377e5a0e2dac6b06feddd21bafa197a22cdd182) ([merge request](gitlab-org/gitlab!149044))
- [Release skipping copy operation in generic packages upload](gitlab-org/gitlab@3e0dd0a3cafab219b5e7aa2d23995433db470fe3) ([merge request](gitlab-org/gitlab!148947))
- [Enable and remove the FF ci_rule_exists_extension_optimization](gitlab-org/gitlab@ccdac7fcf341030e2d3cdeaa2aad1c54cd2fb2c7) ([merge request](gitlab-org/gitlab!148682))
- [Avoid duplicated keys in ProtectedBranches cache](gitlab-org/gitlab@75183a5901df5b550879a78ba04a15470f1c01a7) ([merge request](gitlab-org/gitlab!148172))
- [Use replica DB to read ContainerRepository requiring_cleanup ids](gitlab-org/gitlab@5b757f6da9638f94570c8a5f4ef464f329d1637f) ([merge request](gitlab-org/gitlab!147074))
- [Optimize performance of ambiguous ref detection](gitlab-org/gitlab@e38ec0f827400093797c9608d2d9a86931c4c531) ([merge request](gitlab-org/gitlab!147557))

### Other (113 changes)

- [Removed Tanukibot from Translations](gitlab-org/gitlab@a2c915e9cc23c1767618404fc13c4f01ce75ceb3) by @NIKU-SINGH ([merge request](gitlab-org/gitlab!149328)) **GitLab Enterprise Edition**
- [Drop a partial index we no longer need](gitlab-org/gitlab@ce5d50df74794888b895388028da95c07f0b135f) ([merge request](gitlab-org/gitlab!149218))
- [Add relaxed sharding keys for groups_and_projects](gitlab-org/gitlab@7d37ac964b121056ef24c01cf03b9f89fcd2e9ae) ([merge request](gitlab-org/gitlab!149299))
- [Update artifact_state to include partition_id filter for job_artifacts](gitlab-org/gitlab@d370ffc255670587ba9091ba9bfc4841d5cdfc80) ([merge request](gitlab-org/gitlab!146305))
- [Remove identity_verification feature flag](gitlab-org/gitlab@be6f616110a4a36515ade286d91abe773a6d1902) ([merge request](gitlab-org/gitlab!148888))
- [Enable save_policy_violation_data by default](gitlab-org/gitlab@557fffb41124987e98cc62c1eb572235ba4d050c) ([merge request](gitlab-org/gitlab!149388)) **GitLab Enterprise Edition**
- [Add relaxed sharding keys for source_code_management](gitlab-org/gitlab@7e8e7d61321969a5c5f14cbd6eb921bcff8099dd) ([merge request](gitlab-org/gitlab!148951))
- [Add relaxed sharding keys for continuous_delivery](gitlab-org/gitlab@d087a3dfd833081f3270473cd4584912ea70fbea) ([merge request](gitlab-org/gitlab!149294))
- [Add Sidekiq shard-support for active jobs](gitlab-org/gitlab@cf10df05928636cca210560cafeb34428fb24348) ([merge request](gitlab-org/gitlab!148637))
- [Update status of namespace in URL path to Beta from Experiment](gitlab-org/gitlab@0f30d0144634ee1a65435d1d697340c1fbc0ee8b) ([merge request](gitlab-org/gitlab!148621))
- [Add relaxed sharding keys for vulnerability_management](gitlab-org/gitlab@7324229b273d51b04e2da297247fb4d38aa58b1e) ([merge request](gitlab-org/gitlab!149297))
- [Add relaxed sharding keys for devops_reports](gitlab-org/gitlab@cc6cb9bd1b9b2ff48cdababaa5d9b6ae6d781e5d) ([merge request](gitlab-org/gitlab!149298))
- [Add relaxed sharding keys for importers](gitlab-org/gitlab@cd15a5948cf911d3bcfa2c45cffc515f8a774546) ([merge request](gitlab-org/gitlab!149295))
- [Quarantine a flaky test](gitlab-org/gitlab@8577724795dad8de0558c351c0f45718f2dfab18) ([merge request](gitlab-org/gitlab!149287))
- [Quarantine a flaky test](gitlab-org/gitlab@5136480176a92b5afc9e88d26fad2cbd91651120) ([merge request](gitlab-org/gitlab!149292))
- [Support classic tokens only](gitlab-org/gitlab@795bd63fa964fc8a1e5fbea8e750a089689ff2b5) ([merge request](gitlab-org/gitlab!148398))
- [Adjust UI to new designs](gitlab-org/gitlab@99ca6307e61a75506a55b22bebea2400695614bc) ([merge request](gitlab-org/gitlab!148696))
- [Revert 'ci-rules-exists-add-paths-project-ref'](gitlab-org/gitlab@89133ab27ace8fdc455833baee5b94de72af89f0) ([merge request](gitlab-org/gitlab!149266))
- [Return all visible groups for the Organization.groups GraphQL query](gitlab-org/gitlab@f579c7fcd8eb13002dd5bba358dce02c0e0d87a1) ([merge request](gitlab-org/gitlab!146600))
- [Globally enabled the Duo Chat callout](gitlab-org/gitlab@645c1f1637c4ad230d849cac5b94850af1b1f68d) ([merge request](gitlab-org/gitlab!149059)) **GitLab Enterprise Edition**
- [Remove feature flags related to FF merge trains](gitlab-org/gitlab@4c024b8c82abad6925577e14137ae728f151cbba) ([merge request](gitlab-org/gitlab!148964))
- [Remove sbom_occurrences_vulnerabilities feature flag](gitlab-org/gitlab@29145495ac2a7262425944cfa657835bd3216cbd) ([merge request](gitlab-org/gitlab!148998)) **GitLab Enterprise Edition**
- [Remove the FF ci_parallel_remote_includes](gitlab-org/gitlab@3a2c20f792893ac9fa3a6537083026187e488f24) ([merge request](gitlab-org/gitlab!149134))
- [Protected packages: Use namespace for external string](gitlab-org/gitlab@bf7fbf998ab2ec2edb6dea7e02f8d0108f320c6e) by @gerardo-navarro ([merge request](gitlab-org/gitlab!149113))
- [Protected packages + containers: Adjust style and wording in settings UI](gitlab-org/gitlab@b7cb3e617114b9cc7535d3e552bad150bd446d84) by @gerardo-navarro ([merge request](gitlab-org/gitlab!148704))
- [Quarantine a flaky test](gitlab-org/gitlab@20de72ec85589163c98b843003b9ffda698574a2) ([merge request](gitlab-org/gitlab!149078))
- [Quarantine a flaky test](gitlab-org/gitlab@848d093630c75c294736e364c1d1ce2595ff5342) ([merge request](gitlab-org/gitlab!149064))
- [Quarantine a flaky test](gitlab-org/gitlab@56c4817c4b1a22c24b36f8519e6d69b6186dc27f) ([merge request](gitlab-org/gitlab!149075))
- [Quarantine a flaky test](gitlab-org/gitlab@6907a2cefc9e54be0721f6c7c493d090de827d7e) ([merge request](gitlab-org/gitlab!149065))
- [Quarantine a flaky test](gitlab-org/gitlab@c3bba73c876e2f91efd0f182af9ab295597506b4) ([merge request](gitlab-org/gitlab!149074))
- [Quarantine a flaky test](gitlab-org/gitlab@eb62b4a7d6caa65593dd13a47815e945c6c293f5) ([merge request](gitlab-org/gitlab!149072))
- [Quarantine a flaky test](gitlab-org/gitlab@47f8bc50e897cdf9bdfa2c95ade96282eae72c5d) ([merge request](gitlab-org/gitlab!149071))
- [Add and backfill project_id for deployment_approvals](gitlab-org/gitlab@c2e7da79997c9367ec37e6beda269ced8b533498) ([merge request](gitlab-org/gitlab!149031))
- [Drop an unnecessary index on merge_requests](gitlab-org/gitlab@cc96c157f239907b0103c55898578f400c7790a3) ([merge request](gitlab-org/gitlab!148490))
- [Clean up dora_performers_score_panel feature flag](gitlab-org/gitlab@b37063a371e3348712fdd6818a30d74c78df6c72) ([merge request](gitlab-org/gitlab!148973)) **GitLab Enterprise Edition**
- [Add relaxed sharding keys for system_access](gitlab-org/gitlab@44c0956d60b63ab5e0775a900eb6476e2f18aecf) ([merge request](gitlab-org/gitlab!148949))
- [Add a migration to backfill zoekt_settings in application_settings](gitlab-org/gitlab@100e7f8746da72119163a57a195ca56d160f3905) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/148014)) **GitLab Enterprise Edition**
- [Add relaxed sharding keys for pipeline_composition](gitlab-org/gitlab@6dafca0da880249bba35e5f6c75ddbc8b8263bde) ([merge request](gitlab-org/gitlab!148948))
- [Add sharding keys for continuous_delivery](gitlab-org/gitlab@fe492cd4c24684a5d190639526c1f282c9cd6b7c) ([merge request](gitlab-org/gitlab!142493))
- [Add closes_work_item column to merge_requests_closing_issues](gitlab-org/gitlab@39fd40250ec4d7100df419293b15a5e46191ae79) ([merge request](gitlab-org/gitlab!148763))
- [Remove FF search_add_archived_filter_to_zoekt](gitlab-org/gitlab@ce8c1e208f45cbe24595f151fd8c1d257f0310c9) ([merge request](gitlab-org/gitlab!148551)) **GitLab Enterprise Edition**
- [Fix Style/KeywordParametersOrder offenses](gitlab-org/gitlab@79b0fd0a7f4eabdebe91da01fa356af1cdc71119) by @harryminsky ([merge request](gitlab-org/gitlab!148567)) **GitLab Enterprise Edition**
- [Fix Lint/RedundantDirGlobSort offenses](gitlab-org/gitlab@2b1829232ccfb3101b8681bc545b5ba14ba58f58) ([merge request](gitlab-org/gitlab!148582))
- [Quarantine a flaky test](gitlab-org/gitlab@783ea4eaefe32a6fecfdda723c1b996c8c100c17) ([merge request](gitlab-org/gitlab!148856))
- [Add relaxed sharding keys for release_orchestration](gitlab-org/gitlab@2274785bd784dfb4fda398d5b906be82a81678db) ([merge request](gitlab-org/gitlab!148836))
- [Add relaxed sharding keys for continuous_integration](gitlab-org/gitlab@2af79b9748da46d525b6b7e1531d1a7d58fd3a29) ([merge request](gitlab-org/gitlab!148835))
- [Explicitly pass organization when a user namespace is created](gitlab-org/gitlab@f3d0799e44b372dbb63954212343acf7345189d9) ([merge request](gitlab-org/gitlab!148818))
- [Remove collapse_generated_diff_files FF](gitlab-org/gitlab@58a9c214ba078bce15bd6fcf420bbebd08c36899) ([merge request](gitlab-org/gitlab!148478))
- [Remove search_index_all_projects FF](gitlab-org/gitlab@d50f4f1ca6f352b367a20696f7264bf8a1302ceb) ([merge request](gitlab-org/gitlab!148111)) **GitLab Enterprise Edition**
- [Remove a partial index with locked_state on merge_requests](gitlab-org/gitlab@c4f4e335df8228984b785ac456f58bb9178df0db) ([merge request](gitlab-org/gitlab!148646))
- [Remove usages of FullPath and SetFullPath RPCs](gitlab-org/gitlab@32393507bd640aec2b5078ee7e76f45244689b3c) ([merge request](gitlab-org/gitlab!147651))
- [Move ref validation to services](gitlab-org/gitlab@147d4fd4def3b5f591178b1c171910079b09f17e) ([merge request](gitlab-org/gitlab!146764))
- [Add development widget to work item types](gitlab-org/gitlab@7c2ea75132f59b0fb5599cf1011f608674b3c32a) ([merge request](gitlab-org/gitlab!148119))
- [Create events definitions and reference them on UI elements](gitlab-org/gitlab@be2fa80363a086d046b3f03b326b5351620cad63) ([merge request](gitlab-org/gitlab!147673))
- [Refactor LfsStorageController#upload_finalize into service](gitlab-org/gitlab@5bd8976a7d7e5f5153c92c10a1a238de74435c7c) by @missy-davies ([merge request](gitlab-org/gitlab!139729))
- [Add relaxed sharding keys for team_planning](gitlab-org/gitlab@950f0665725a64db412262b59900fbd6de058a1e) ([merge request](gitlab-org/gitlab!148672))
- [Enforce not-null constraint vs_code_settings version](gitlab-org/gitlab@d73d7b283386ed5a9ba291b2b3f49d0661e66a90) ([merge request](gitlab-org/gitlab!148648))
- [Migrate inputs to spec on CI components table](gitlab-org/gitlab@9ff7f0872dbd089f16e89fc1bcb151021466e4ee) ([merge request](gitlab-org/gitlab!148547))
- [Remove "fetch_commits_for_bitbucket_server" feature flag](gitlab-org/gitlab@c971bda0141b79005afe97e89a1f8081e54e2416) ([merge request](gitlab-org/gitlab!148657))
- [Remove security_policies_policy_scope feature flag](gitlab-org/gitlab@ccdd99f9601cba26f0d3775bfda3c5067f59cf46) ([merge request](gitlab-org/gitlab!147386)) **GitLab Enterprise Edition**
- [Move right side panel into its own component](gitlab-org/gitlab@e9c465a377e4c9d13ed8dcad0b25b05d4c21f4d0) by @espadav8 ([merge request](gitlab-org/gitlab!148461))
- [Remove use_registration_type_db_value feature flag](gitlab-org/gitlab@a1e3f2bff8b28359cbc714eb3803e6d7a22de95f) ([merge request](gitlab-org/gitlab!148595)) **GitLab Enterprise Edition**
- [Add next desired sharding keys for code_review_workflow](gitlab-org/gitlab@e7a83dda1616fbd0dae531f7cd25c425b3319f48) ([merge request](gitlab-org/gitlab!148532))
- [Add next desired sharding keys for incident_management](gitlab-org/gitlab@d981c6f7d9ac6d13ba0807e116855887ccae9382) ([merge request](gitlab-org/gitlab!148531))
- [Add next desired sharding keys for portfolio_management](gitlab-org/gitlab@460a1b05e7bc6ea480499133dbbdb15361d8a23f) ([merge request](gitlab-org/gitlab!148529))
- [Finalize backfill vs_code_settings table migration](gitlab-org/gitlab@d105097d252eb65e2c7609808df660b4dbb925f1) ([merge request](gitlab-org/gitlab!148367))
- [Remove arkose_labs_signup_challenge feature flag](gitlab-org/gitlab@4276f0048ac1d060e1d8536eddf45c2cc5f2ca98) ([merge request](gitlab-org/gitlab!147767))
- [Protected containers: Resolve duplicate test assertions](gitlab-org/gitlab@9cc4b1b0ce27055df79ef4731a2072f40233ed95) by @gerardo-navarro ([merge request](gitlab-org/gitlab!148252))
- [Add desired sharding keys for geo_replication](gitlab-org/gitlab@fa96b612b05f861721c277c887e9885f5504a1c3) ([merge request](gitlab-org/gitlab!148061))
- [Remove `group_analytics_dashboards` feature flag](gitlab-org/gitlab@9c38ad6deef6d8123896eadfaa1aa702fa6196a6) ([merge request](gitlab-org/gitlab!147013)) **GitLab Enterprise Edition**
- [Add storage_shard label by decomposing instrumentation class name](gitlab-org/gitlab@f698dae407cebe4e12a62dca39028279ebe98897) ([merge request](gitlab-org/gitlab!147746))
- [Remove feature flag use_partition_id_filter_on_ci_job_artifacts](gitlab-org/gitlab@a58b1c3ad28329bc40f1df414356f511c676abd2) ([merge request](gitlab-org/gitlab!148029))
- [Finalize migration BackfillDefaultOrganizationUsers](gitlab-org/gitlab@295e8510ca9389c3156b54ba18d08d802d1c3a0b) ([merge request](gitlab-org/gitlab!147516))
- [Protected containers: Adjust error message in docker client](gitlab-org/gitlab@13417ca9003d59e0536e2ad166029b4a9ed0d731) by @gerardo-navarro ([merge request](gitlab-org/gitlab!148087))
- [Add desired sharding keys for audit_events](gitlab-org/gitlab@547eb9efc2f01024ffdc35535c710bad8018ecce) ([merge request](gitlab-org/gitlab!148067))
- [Add desired sharding keys for package_registry](gitlab-org/gitlab@ed4cebb62545b275b0bb1823ff96618c134579b7) ([merge request](gitlab-org/gitlab!148065))
- [Add desired sharding keys for team_planning](gitlab-org/gitlab@8be2b931e341e36db286aef9a9a5fade4b54f204) ([merge request](gitlab-org/gitlab!148063))
- [Add desired sharding keys for portfolio_management](gitlab-org/gitlab@4a121810e6d3f98175d7e85c7328e89f7fd775ec) ([merge request](gitlab-org/gitlab!148060))
- [Add desired sharding keys for incident_management](gitlab-org/gitlab@7ea185c0efb61a38cfb6e821e3e8219af2ece4c1) ([merge request](gitlab-org/gitlab!148043))
- [Add desired sharding keys for service_desk](gitlab-org/gitlab@464b55c52ee5afd640d1d2524d1655e2e69247c0) ([merge request](gitlab-org/gitlab!148041))
- [Add desired sharding keys for error_tracking](gitlab-org/gitlab@dabaf4a1de77a57f791bddb5f7770e5262073a67) ([merge request](gitlab-org/gitlab!148038))
- [Add desired sharding keys for metrics](gitlab-org/gitlab@8e885408fcb425c643961244624ee41cc38d2a54) ([merge request](gitlab-org/gitlab!148035))
- [Update schema for clusterwide tables in web_ide](gitlab-org/gitlab@cfd0ed92e464eb15bf047db4b697558f133a94a2) ([merge request](gitlab-org/gitlab!147982))
- [Update schema for clusterwide tables in team_planning](gitlab-org/gitlab@52e858a8f4c94b26e724854b61fa2fb5259d81df) ([merge request](gitlab-org/gitlab!147981))
- [Update schema for clusterwide tables in importers](gitlab-org/gitlab@c4fdf02c1044f544504563674a2ee7c2bb6c6e54) ([merge request](gitlab-org/gitlab!147980))
- [Update schema for clusterwide tables in system_access](gitlab-org/gitlab@883691365e1b424f33b10091f572551837153d50) ([merge request](gitlab-org/gitlab!147979))
- [Update schema for clusterwide tables in user_profile](gitlab-org/gitlab@22bbf1c56bdf44f55adfa6f3d9f426eb098b3aee) ([merge request](gitlab-org/gitlab!147978))
- [Update schema for clusterwide tables in deployment_management](gitlab-org/gitlab@b0854c4e78023392c85ac0a39b1912307783030a) ([merge request](gitlab-org/gitlab!147972))
- [Use PipelineTriggers::DestroyService across endpoints](gitlab-org/gitlab@85bded241311852974738edb35559141009c92a9) by @missy-davies ([merge request](gitlab-org/gitlab!136163))
- [Add missing attributes in the search/count endpoint](gitlab-org/gitlab@f93369b84e4dd53e1d084d322a5e534c899fd38b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/147796))
- [Update artifacts queries to use partition_id filter](gitlab-org/gitlab@bf891b816aacf233a9280ebd2b4928391131eafe) ([merge request](gitlab-org/gitlab!147126))
- [Adds sharding_key to internal_ids](gitlab-org/gitlab@9f9e531d020e8f89afc5c85dd1030f6b9f10db5c) ([merge request](gitlab-org/gitlab!147705))
- [Add sharding keys for error_tracking](gitlab-org/gitlab@54ec24bb31ae92b19a8237d8aedd275bbd43870c) ([merge request](gitlab-org/gitlab!147788))
- [Add sharding keys for metrics](gitlab-org/gitlab@a50560611537ba8df6d3758cdc727eea59151733) ([merge request](gitlab-org/gitlab!147787))
- [Add sharding keys for navigation](gitlab-org/gitlab@9c99f8829d400e748a409e679194222c8c8f36f9) ([merge request](gitlab-org/gitlab!147784))
- [Add sharding keys for service_desk](gitlab-org/gitlab@5f7162a6fbf5cd4172e54f1c54b333a58e70ab67) ([merge request](gitlab-org/gitlab!147783))
- [Add sharding keys for incident_management](gitlab-org/gitlab@3ae59207a80b6e46b8c6232d3513d8ece0aaff07) ([merge request](gitlab-org/gitlab!147779))
- [Remove epic_events_on_contributions_calendar feature flag](gitlab-org/gitlab@3f985a78b205ffb208ea5a1dc0e38c8a9f06e084) ([merge request](gitlab-org/gitlab!147760))
- [Use partitioned foreign key between ci_builds and ci_stages](gitlab-org/gitlab@6a18d4996153cecada618bfd35c36a9eea070b72) ([merge request](gitlab-org/gitlab!147648))
- [Use routing tables for ci_job_artifacts and ci_stages ](gitlab-org/gitlab@001e895189c01640f729f104430596055cfbb919) ([merge request](gitlab-org/gitlab!147438))
- [Add relation import tracker and table](gitlab-org/gitlab@6591d0b946a8dcc069b3c8250291aec1e235732a) ([merge request](gitlab-org/gitlab!146778))
- [Show alert to explain where code suggestions moved](gitlab-org/gitlab@d293a5a61db21f431772a12d99b786afd0fcbad3) ([merge request](gitlab-org/gitlab!144807)) **GitLab Enterprise Edition**
- [Adding p_ci_build_names table and model](gitlab-org/gitlab@af1699a0822078be97696954a5df78127a9f79e6) ([merge request](gitlab-org/gitlab!146555))
- [Refactor push_rules_helpers_spec.rb to improve tests speed](gitlab-org/gitlab@baa2641e1d44660613148e85216d6ce5d9ebe779) ([merge request](gitlab-org/gitlab!147571)) **GitLab Enterprise Edition**
- [Update indentation on yaml docs](gitlab-org/gitlab@d0f731e72094927a87411b152486e69f55700bcd) ([merge request](gitlab-org/gitlab!147564))
- [Adjust naming in admin network settings](gitlab-org/gitlab@39219aedd2a6c92964d9949ffed00060721c5c18) by @gerardo-navarro ([merge request](gitlab-org/gitlab!147536))
- [refactor: Add feature category for rack attack tests](gitlab-org/gitlab@adf26bc8186ac36c44c5044bdcdd5cd59212c5cd) by @gerardo-navarro ([merge request](gitlab-org/gitlab!147530))
- [Finalize migration BackfillDefaultOrganizationOwnersAgain](gitlab-org/gitlab@918153f76698b529d56f79f6768333189b2013d2) ([merge request](gitlab-org/gitlab!147514))
- [Remove "external_pipeline_validation_service_url" feature flag](gitlab-org/gitlab@95259cdfe652b81023988a868827c7d21faa9cd3) ([merge request](gitlab-org/gitlab!147407))
- [Port the project admin button to Vue](gitlab-org/gitlab@62bdb1e1a41db8e3161146f43724e43743e5e150) by @espadav8 ([merge request](gitlab-org/gitlab!144736))
- [Drop promote_ultimate_features_at column](gitlab-org/gitlab@b5dbcc83686be21fbf90d176bfd07707f21d1518) ([merge request](gitlab-org/gitlab!145706))
- [Finalize the backfill migration for onboarding status step url](gitlab-org/gitlab@f986c1b1cf00968ff106136893bfe68d47895c69) ([merge request](gitlab-org/gitlab!147278))
- [Remove ClusterRepositoryCache migration helper class](gitlab-org/gitlab@f71a7a94ce8d70d9d378ebc225b802b58f0ae006) ([merge request](gitlab-org/gitlab!147244))

## 16.10.10 (2024-09-19)

No changes.

## 16.10.9 (2024-07-23)

### Added (1 change)

- [Add Rake task to show token expiration info](https://gitlab.com/gitlab-org/gitlab/-/commit/401fa9da22fdeffa67c783e11b98ce0c9bb8c7ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159057))

## 16.10.8 (2024-06-25)

### Fixed (1 change)

- [Update an expired test certificate](gitlab-org/gitlab@adb50cc178e81e75b78f6b10cafc79cd6be9a43c) ([merge request](gitlab-org/gitlab!156394))

### Changed (1 change)

- [Add a banner informing about token expiration](gitlab-org/gitlab@7f51cdccdd702a4f92607d52b6d4e3884c8e5234) ([merge request](gitlab-org/gitlab!155266))

## 16.10.7 (2024-06-11)

### Security (4 changes)

- [XSS and content injection raw XHTML files on IOS devices](gitlab-org/security/gitlab@bd477c1d019b3f758a38a4b7182b86f2d4668df4) ([merge request](gitlab-org/security/gitlab!4095))
- [Improve go_package_regex to prevent ReDoS attacks](gitlab-org/security/gitlab@56f50979b62a982e572d5695a87d19a36e0a9ef6) ([merge request](gitlab-org/security/gitlab!4098))
- [Fix ReDoS in CI Interpolation](gitlab-org/security/gitlab@045cf00aa56d545bdfb828c6131af89c37164946) ([merge request](gitlab-org/security/gitlab!4083))
- [Verify Asana access token when testing Asana integration](gitlab-org/security/gitlab@233b152dfea572b19b1803174c4604f4c0e04851) ([merge request](gitlab-org/security/gitlab!4061))

### Other (1 change)

- [Quarantine a flaky test](gitlab-org/security/gitlab@45242cdf1d36c89aff59e3ce7ee3d2e2f5b16471)

## 16.10.6 (2024-05-21)

### Fixed (1 change)

- [Ensure BLPOP/BRPOP returns nil instead of raising ReadTimeoutError](gitlab-org/security/gitlab@78c11d44cf01757221da8bb01f6fbdefb352f619)

### Security (6 changes)

- [Prevent PDF.js from evaluating scripts](gitlab-org/security/gitlab@db5b63e4a26889f09f72b582b7777909efd4cd4d) ([merge request](gitlab-org/security/gitlab!4071))
- [Caching test_report api response to reduce calculations](gitlab-org/security/gitlab@8b67dde95712b74c3ff0ae9d8bc73d7cd0a350cf) ([merge request](gitlab-org/security/gitlab!4030))
- [Fail create commit status on pipeline_id / sha mismatch](gitlab-org/security/gitlab@36c5070a2ad812f52747241321aaae81345aaee0) ([merge request](gitlab-org/security/gitlab!4033))
- [Use UntrustedRegexp for gollum pattern](gitlab-org/security/gitlab@3fee24aca41a5db9135e8f3003335d1754beb636) ([merge request](gitlab-org/security/gitlab!4041))
- [Patch @gitlab/web-ide to fix XSS webWorkerExtensionHostIframe.html](gitlab-org/security/gitlab@29cc8769daee74938155dd7e3b5a2f3a3bda5b71) ([merge request](gitlab-org/security/gitlab!4057))
- [Add text limit to ci_runners text fields](gitlab-org/security/gitlab@5af28a81f6c11d9627f1a359a7c3a7d85e7fb4d9) ([merge request](gitlab-org/security/gitlab!4037))

## 16.10.5 (2024-05-07)

### Fixed (1 change)

- [Changed the email validation for only encoded chars](gitlab-org/security/gitlab@f7c8aa08b6bac4cfc9942166607ed482037e440f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/151484/))

### Changed (1 change)

- [Return or display Gitlab version if GITLAB_KAS_VERSION is a SHA](gitlab-org/security/gitlab@0b3fa36f5dd06891b9e612cc8abc007368b27be3)

### Security (11 changes)

- [Update GITHUB_MEDIA_CDN to avoid SSRF when importing from Github](gitlab-org/security/gitlab@0d7ee3cee127d629f12bfee309dbc55c8cc9c256) ([merge request](gitlab-org/security/gitlab!4012))
- [Prevent namespace banned users from reading project todos](gitlab-org/security/gitlab@8073a9aee49d9cad4923adaa2dbf0a6ad14ea9a6) ([merge request](gitlab-org/security/gitlab!3940))
- [ReDoS in GitRefsFinder when using wildcards in branch search](gitlab-org/security/gitlab@ba1ed3f62c2c454ec295636c66b4b1e4a2f8d990) ([merge request](gitlab-org/security/gitlab!3996))
- [ReDos in escape and commit reference filters](gitlab-org/security/gitlab@a1894c71a676f5b762bd951cf996f39e13a7725c) ([merge request](gitlab-org/security/gitlab!3973))
- [Validate request origin before MR approval](gitlab-org/security/gitlab@5279a01f625dc258a2f450ef2a7f65f63eb5d138) ([merge request](gitlab-org/security/gitlab!4008))
- [Check request size before updating user pins](gitlab-org/security/gitlab@914de75d86f9cf2a3275e2a48f35e19478d3aad4) ([merge request](gitlab-org/security/gitlab!4015))
- [Enforce per_page validation for Branches/TagsFinders](gitlab-org/security/gitlab@2ad4ddfb1fb705fec72771870624647443e7e55c) ([merge request](gitlab-org/security/gitlab!3999))
- [Update Integrations::Discord::ATTACHMENT_REGEX regex](gitlab-org/security/gitlab@3900a2e11afbca28d28bdf014e4c2f40b255236c) ([merge request](gitlab-org/security/gitlab!3987))
- [Update BaseMessage::RELATIVE_LINK_REGEX regex](gitlab-org/security/gitlab@f8641296f1bc0e944cee2685df703bcd72c4a556) ([merge request](gitlab-org/security/gitlab!3993))
- [Require confirmation before linking JWT identity](gitlab-org/security/gitlab@47382334fb05c3bef26719100e4281124dea606f) ([merge request](gitlab-org/security/gitlab!3991))
- [Fix confidentiality check optimization](gitlab-org/security/gitlab@3a6d5fbdea0f205695f0bf34cd5f64bec6ddbbd1) ([merge request](gitlab-org/security/gitlab!4003))

## 16.10.4 (2024-04-24)

### Fixed (1 change)

- [Update vulnerability_reads scanner in the ingestion pipeline](gitlab-org/security/gitlab@14b8876233e5dd29149426fd88bab0fc4f014d46) **GitLab Enterprise Edition**

### Security (5 changes)

- [Validation for encoded formatting characters](gitlab-org/security/gitlab@4cd13c705ce1a94152fb2fd6fcaa77e90e6441e5) ([merge request](gitlab-org/security/gitlab!3950))
- [Forbid untrusted sign-ins to GitLab with Bitbucket and fix related uid](gitlab-org/security/gitlab@5d3c3a599cc5560dea2236474309537536428cdc) ([merge request](gitlab-org/security/gitlab!3984))
- [Ensure PAT scope is validated everywhere for GraphQL/ActionCable](gitlab-org/security/gitlab@079dfee8cff9da9075eec7c03ce002e87eeebfff) ([merge request](gitlab-org/security/gitlab!3976))
- [Protect against ReDoS in FileFinder with wildcard filters](gitlab-org/security/gitlab@0e7e54050f1c4829b1d55aac85bd4e9cd96f1580) ([merge request](gitlab-org/security/gitlab!3960))
- [fix: Validate security report version against schema during parsing](gitlab-org/security/gitlab@217040b1062caad501d60af387c47cff758788a1) ([merge request](gitlab-org/security/gitlab!3956))

## 16.10.3 (2024-04-12)

No changes.

## 16.10.2 (2024-04-09)

### Fixed (1 change)

- [Fix URL validator for mirror services when using localhost](gitlab-org/security/gitlab@82ee9dbd7b4f52507563a509eaa8d2e4839b2e58)

### Security (3 changes)

- [Update Gitlab::Regex::Packages#slack_link_regex](gitlab-org/security/gitlab@25d2355e4cd84a5c1005f1769624e83bfc6d63c2) ([merge request](gitlab-org/security/gitlab!3945))
- [Fix XSS in autocomplete in rich text editor](gitlab-org/security/gitlab@dc132c61a896afc1b63ce9cf31b69797eecf95ce) ([merge request](gitlab-org/security/gitlab!3946))
- [Correctly parse attachments for junit result](gitlab-org/security/gitlab@e729252188fd47950e27abe14bad4bf748e99455) ([merge request](gitlab-org/security/gitlab!3934))

## 16.10.1 (2024-03-27)

### Fixed (2 changes)

- [Update redis-client to v0.21.1](gitlab-org/security/gitlab@c9d6f434dbc8d5ca244d0c00d8c5cf0d9092df39)
- [Fix new project group templates pagination](gitlab-org/security/gitlab@956b01c404e55bc92276ab7d21c63a09bc3edfb5) **GitLab Enterprise Edition**

### Security (3 changes)

- [Merge branch 'dchevalier2-master-patch-88770' into 'master'](gitlab-org/security/gitlab@9e621975bf405f2e66541faebf11b06a31360b5d) ([merge request](gitlab-org/security/gitlab!3936))
- [Limit the number of emojis we will transform](gitlab-org/security/gitlab@e935e1cc26a06990832781b30827d5afa53d0194) ([merge request](gitlab-org/security/gitlab!3927))
- [Fix stored xss in wikis using the abstract_reference_filter](gitlab-org/security/gitlab@d1bad1a4847917d5f10c883d0d2f627088a00ca5) ([merge request](gitlab-org/security/gitlab!3929))

## 16.10.0 (2024-03-20)

### Added (115 changes)

- [Add drawer to list of linked policies](gitlab-org/gitlab@218016c38801cfeac1308385097dcd760182a378) ([merge request](gitlab-org/gitlab!147039)) **GitLab Enterprise Edition**
- [Command palette default opening state - part 3](gitlab-org/gitlab@a51d07342e3a7dc4da56ec84efec5191d8663640) ([merge request](gitlab-org/gitlab!142816))
- [Expose repository object format via GitInfo](gitlab-org/gitlab@4947d2c17a7118e392312f9d31fcf7c6799577e3) ([merge request](gitlab-org/gitlab!146485))
- [Add deprecated_policy field for approval policies](gitlab-org/gitlab@2e332564e7148343db00f79a4caafe672e206c87) ([merge request](gitlab-org/gitlab!146520))
- [Add approval rules drawer component](gitlab-org/gitlab@51b30ac3d7bb61ab5f43fc87a322560ea0167238) ([merge request](gitlab-org/gitlab!146502)) **GitLab Enterprise Edition**
- [Expose external issue links to Vulnerabilities if any](gitlab-org/gitlab@7a8d63cd7660e3bc2dcc1de307f556549c137876) ([merge request](gitlab-org/gitlab!146149)) **GitLab Enterprise Edition**
- [Add table to track CI component usage](gitlab-org/gitlab@3372a7566bfe2b0bea000e48fd0bffbaffb2db45) ([merge request](gitlab-org/gitlab!145881))
- [Add Pages URL anchor](gitlab-org/gitlab@6d5023141d9597087ffd353a2794102e52ec5e09) ([merge request](gitlab-org/gitlab!144281))
- [Update Jira::JqlBuilderService to support multiple project keys](gitlab-org/gitlab@4da23ca620a7219a43c81170496ef99ebc989efd) ([merge request](gitlab-org/gitlab!146916))
- [Add new achievement UI](gitlab-org/gitlab@a4bcf4e181d1458f8bcb504de2d7e95ee3a4136e) ([merge request](gitlab-org/gitlab!146273))
- [Protected containers: GraphQL query for container protection rules](gitlab-org/gitlab@1a773182a248eb646affd5334c6a6e1182828345) by @gerardo-navarro ([merge request](gitlab-org/gitlab!146467))
- [Add runner creation metrics](gitlab-org/gitlab@dc17b7ad19792592b2e9078e49755a5da3356bc6) ([merge request](gitlab-org/gitlab!146063)) **GitLab Enterprise Edition**
- [Allow to enable/disable ClickHouse for analytics](gitlab-org/gitlab@f025888da096cace95cf86d5d20f3a52e0691eaa) ([merge request](gitlab-org/gitlab!145022)) **GitLab Enterprise Edition**
- [Adds Destroy action to delete models](gitlab-org/gitlab@1e487f60a57924b9c7dcbb1503af5e7478781a3a) ([merge request](gitlab-org/gitlab!144226))
- [Added event type filters for group audit event destinations](gitlab-org/gitlab@67cb59d71542f90b1e1fc62295747814fc16dd0c) ([merge request](gitlab-org/gitlab!144139)) **GitLab Enterprise Edition**
- [This MR adds alert banner](gitlab-org/gitlab@4d9836b4900ab7540c64e766ad6c18c0e9ce7011) ([merge request](gitlab-org/gitlab!146709)) **GitLab Enterprise Edition**
- [Create partitioned merge_request_diff_commits copy](gitlab-org/gitlab@1efd0bb9ea849e189d39940d0cd9a8878e20bf63) ([merge request](gitlab-org/gitlab!143869))
- [Allow toggling duo_features_enabled settings via REST API](gitlab-org/gitlab@8f960b374aea97fda31a3a2159ef26bb71e05bdd) ([merge request](gitlab-org/gitlab!146582)) **GitLab Enterprise Edition**
- [Document runner long polling configuration](gitlab-org/gitlab@4dbcfba63217807106534d88039015e07775cab9) ([merge request](gitlab-org/gitlab!146701))
- [Prepare async indices for dependency list aggregations](gitlab-org/gitlab@3d87873acd137f1610229114db9854c7ceeb3e68) ([merge request](gitlab-org/gitlab!146650))
- [Add GitHub integration's logo](gitlab-org/gitlab@bd5d604b677a23eac4a8d59ec99bdae991d81042) ([merge request](gitlab-org/gitlab!146614)) **GitLab Enterprise Edition**
- [Add Cloud Connector docs for new backends](gitlab-org/gitlab@8afdf975d407ab3a98d1bce2004366147e0b7b7b) ([merge request](gitlab-org/gitlab!146507))
- [Synchronously add indexes for new `vulnerability_occurrences` cols](gitlab-org/gitlab@fb7b7225e2058029b10d2f2e7b6d7f1f680a87b3) ([merge request](gitlab-org/gitlab!145782))
- [Backfill semvar columns of existing catalog versions](gitlab-org/gitlab@67dfcf8be9ec25bd6f496d36d5349de8da6ad4f4) ([merge request](gitlab-org/gitlab!146688))
- [Allow toggling duo_features_enabled on Groups via GraphQL](gitlab-org/gitlab@30b24fdead5bd9d48bafe9ce7066bb2d5ead14b8) ([merge request](gitlab-org/gitlab!146430)) **GitLab Enterprise Edition**
- [API customizations for service account user](gitlab-org/gitlab@da6541a26e55d761fc434596e6cbba63efd7cfc2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/144841))
- [Add diff_id to diff file links](gitlab-org/gitlab@81dce0361b9bfd951735a942ea40d3c4016dcb4c) ([merge request](gitlab-org/gitlab!146092))
- [Check duo_features_enabled setting by default](gitlab-org/gitlab@09581f30e9a9b9f2b42f3881a9a2d90ca8a1a3b8) ([merge request](gitlab-org/gitlab!146684)) **GitLab Enterprise Edition**
- [Add policy list when editing compliance framework](gitlab-org/gitlab@99fcb973a1e82fc567b1a0fbf7e7e22acf0af8b8) ([merge request](gitlab-org/gitlab!145312)) **GitLab Enterprise Edition**
- [Backfill has_issues for Vulnerability::Read rows with ExternalIssueLink](gitlab-org/gitlab@28ca07fe271a711692f7ac207118cf3309966140) ([merge request](gitlab-org/gitlab!146643))
- [Remove "dynamic_empty_tree_id" feature flag](gitlab-org/gitlab@f349b74184b4d5ab34c4da4262e4ba91894ba2b5) ([merge request](gitlab-org/gitlab!146609))
- [Adds /convert_to_ticket quick action](gitlab-org/gitlab@3bbe37bd14f9b3fa340f0b54e20a50e889b5f225) ([merge request](gitlab-org/gitlab!146492))
- [Adds activity page to Organization level](gitlab-org/gitlab@65045809d2d1a55942b5190dcdcc117e1ea6e665) ([merge request](gitlab-org/gitlab!146167))
- [Backfill archived and traversal_ids for vulnerability_reads](gitlab-org/gitlab@f032f04cc32f9d80688ac1192cc540c9c4d9962e) ([merge request](gitlab-org/gitlab!144765))
- [Cloud Connector: support extra claims in JWT](gitlab-org/gitlab@32202b2c6e104b239d2600ceee18b06a966f5406) ([merge request](gitlab-org/gitlab!146172)) **GitLab Enterprise Edition**
- [Add visibility filter in groups API](gitlab-org/gitlab@7f9aaa608595edbff92111607efbd6320ccd44b9) by @imskr ([merge request](gitlab-org/gitlab!146263))
- [Update JiraConnect app_descriptor](gitlab-org/gitlab@404abd1fc8fa1a620d60ef97df08024105fe35e9) ([merge request](gitlab-org/gitlab!142316))
- [Add user permission type for finding](gitlab-org/gitlab@41d142f4c6fc896f2849dddde18e61a14db9a312) ([merge request](gitlab-org/gitlab!144295)) **GitLab Enterprise Edition**
- [[Ban AI] Audit duo_features_enabled changes](gitlab-org/gitlab@dc3e1c3ed1bb7ccaf1f69877ff7586da6815f22a) ([merge request](gitlab-org/gitlab!145509)) **GitLab Enterprise Edition**
- [Add application limit on downstream pipelines](gitlab-org/gitlab@7dc888ebd2d890c70146079dfbe5bc7903953617) ([merge request](gitlab-org/gitlab!146112))
- [Show admin mode within active sessions view](gitlab-org/gitlab@5ea5889f554f334b54f9bd46f86401bceabb38ab) by @bufferoverflow ([merge request](gitlab-org/gitlab!145523))
- [Add support for templates in wikis](gitlab-org/gitlab@d469211260979df568fb488ea2cc202075071521) ([merge request](gitlab-org/gitlab!143314))
- [Add filter support for enterprise in GraphQL group members](gitlab-org/gitlab@1489b6e9b5fc89d3705308183afb3851913a6162) by @imskr ([merge request](gitlab-org/gitlab!145331))
- [Add service to send Arkose truth data](gitlab-org/gitlab@f3bbe9f5cc7781a6e7d9a30866125afb4b9e85db) ([merge request](gitlab-org/gitlab!145314))
- [Add php support for semgrep](gitlab-org/gitlab@cbb5b12d96def6ef5ef4d7029a96d24c1efb2fd6) ([merge request](gitlab-org/gitlab!143472))
- [Adds logo for DroneCI integration](gitlab-org/gitlab@3d856ecb91792afa226f5a189575261eae2638b6) ([merge request](gitlab-org/gitlab!146046))
- [Remove WIP feature flag](gitlab-org/gitlab@565d5f2aa37d75faa59fd1e737e5b2c9717f5e0b) ([merge request](gitlab-org/gitlab!146211)) **GitLab Enterprise Edition**
- [Add `initial` &  `latest` pipeline IDs to `vulnerability_occurrences`](gitlab-org/gitlab@cd1bfa6961c32e265f91c3ba657c6697ad3c301b) ([merge request](gitlab-org/gitlab!144697))
- [Add Remove Group custom ability](gitlab-org/gitlab@627346a084944547289326590b19769f887412dd) ([merge request](gitlab-org/gitlab!145166)) **GitLab Enterprise Edition**
- [Add support for sorting GET /groups/:id/projects by star count](gitlab-org/gitlab@7463ec4e59365c06bd7907c6f02a3bb1b81c9cd0) by @imskr ([merge request](gitlab-org/gitlab!145308))
- [Configurable session cookie token prefix](gitlab-org/gitlab@3bae157050215d0b975c195c755905abc9dfeda0) ([merge request](gitlab-org/gitlab!145178))
- [Add CI_COMPONENT_FQDN variable and usage instructions](gitlab-org/gitlab@ae9f265a8f7cb4fcecccd550f9751861987abd04) ([merge request](gitlab-org/gitlab!145950))
- [Add table to support new group-agent authorization strategy for RD](gitlab-org/gitlab@23a95b2769cb26478cc989aa00c5e153c9c5d0be) ([merge request](gitlab-org/gitlab!145101))
- [feat: Protected packages: Update protection rules in project settings ui](gitlab-org/gitlab@22769e8b79e976f172d5a85df2eea7c30f9ee303) by @gerardo-navarro ([merge request](gitlab-org/gitlab!141792))
- [Expose groups and projects allow list counters on graphQL](gitlab-org/gitlab@534f1dadc8129774ac3fe2965971c6f83539d7a8) ([merge request](gitlab-org/gitlab!145067))
- [Add time tracking widget to the work item update mutation](gitlab-org/gitlab@e2d808d2f668e64ba9b02e41ecd07bbcf5a5885d) ([merge request](gitlab-org/gitlab!145146))
- [Show target branch of MRs in Global Search](gitlab-org/gitlab@44a47b5f1d72b0f390bdef005b4393613220c758) by @santigl ([merge request](gitlab-org/gitlab!145849))
- [Add at least one approval by non author SOC 2 adherence check](gitlab-org/gitlab@33b9f8c00d4843d1403a908081dd416bb2bfe80a) ([merge request](gitlab-org/gitlab!145302)) **GitLab Enterprise Edition**
- [Add occupies_seat column to member_roles table](gitlab-org/gitlab@918cc302556394795be586125f4b8a84ccc63255) ([merge request](gitlab-org/gitlab!143911)) **GitLab Enterprise Edition**
- [Add REST API to fetch project's groups allowlist](gitlab-org/gitlab@84e9f297b0cdc02a7a47a35debe062cab04c269f) ([merge request](gitlab-org/gitlab!145069))
- [Add starrers_path to Catalog::ResourceType](gitlab-org/gitlab@9693fc338b17876112599fc27b1869f1f72e2daa) ([merge request](gitlab-org/gitlab!145937))
- [Added documentation for workflow:auto_cancel:on_job_failure](gitlab-org/gitlab@f822691e9082800dda1150814b96bb7c2e5d50bd) by @zillemarco ([merge request](gitlab-org/gitlab!145709))
- [Add new checkbox for optional data in service ping](gitlab-org/gitlab@51a6985a9ba587e0f6a970595257d218f4eff7b4) ([merge request](gitlab-org/gitlab!141540))
- [Display message when git rate limited by failed auth attempts](gitlab-org/gitlab@0c6b22efc24069741349ee0411d06c97749b27fe) ([merge request](gitlab-org/gitlab!145624))
- [Add new generic worker to handle auto merges from events](gitlab-org/gitlab@c8d7ec7f16b10b4b33ab6cd60bde982238397ab2) ([merge request](gitlab-org/gitlab!145460))
- [This MR adds policy scope on project level](gitlab-org/gitlab@7a4df91eef1dc726024f52e005c7db8757ba9481) ([merge request](gitlab-org/gitlab!143877)) **GitLab Enterprise Edition**
- [Remove ci_data_ingestion_to_click_house feature flag](gitlab-org/gitlab@8dd9fe00ae6b56664c086f83a4f81518a0f99e92) ([merge request](gitlab-org/gitlab!145665))
- [Remove run_clickhouse_migrations_automatically feature flag](gitlab-org/gitlab@7173726fdf9f309f4a692415a3df091e118cabdd) ([merge request](gitlab-org/gitlab!145668))
- [Added code to queue member promotion request](gitlab-org/gitlab@e61033ad415476d4c2ebe9ab63b1b98edfa3b443) ([merge request](gitlab-org/gitlab!142202)) **GitLab Enterprise Edition**
- [Add deployments_count field](gitlab-org/gitlab@3f0759518670a098e2c142a78f74d5ca218b4715) ([merge request](gitlab-org/gitlab!145320))
- [Copy VSA query params to issue analytics link](gitlab-org/gitlab@4ab125b9f80b7d0734256adbc50004b3f363b725) ([merge request](gitlab-org/gitlab!145496)) **GitLab Enterprise Edition**
- [Add ops flag to disable cookie-based language switcher](gitlab-org/gitlab@2b891f71abd03ffb1ad52e19eb15505d6b60ba96) ([merge request](gitlab-org/gitlab!144484))
- [Added first part of the command palete update - part 2](gitlab-org/gitlab@85cfd7f1dd1ae5d5fc3c011748d43ee5f2ba6893) ([merge request](gitlab-org/gitlab!141256))
- [Add an avatar to security policy bot](gitlab-org/gitlab@948d1602cad9d38464162b61bf5e2357678c4298) ([merge request](gitlab-org/gitlab!145423)) **GitLab Enterprise Edition**
- [Add yaml_error_messages graphql field](gitlab-org/gitlab@90de1d0c38c4e07d017a79b705ce1e62fec9c9f8) ([merge request](gitlab-org/gitlab!145327))
- [Add VSA aggregation status to GraphQL](gitlab-org/gitlab@875ba7de9ecaf52239000d3ea52406f3b232514a) ([merge request](gitlab-org/gitlab!144961)) **GitLab Enterprise Edition**
- [Add ops FF to reduce the export batch size](gitlab-org/gitlab@b85c99b7982ca94b03416bee2f8ad2b6a313a906) ([merge request](gitlab-org/gitlab!145189))
- [Add Cloud Connector developer docs](gitlab-org/gitlab@33714cfd2ab38b440903e5545b4b0672423cfd9f) ([merge request](gitlab-org/gitlab!142426))
- [Add endpoint to update group approval rules](gitlab-org/gitlab@526caa76c9b984eafa9f69b00f4c449ceeea9e34) ([merge request](gitlab-org/gitlab!144927)) **GitLab Enterprise Edition**
- [Default enable collapse_generated_diff_files feature](gitlab-org/gitlab@5134fbf13ff9fe1fa5025bba8f97842371c039ea) ([merge request](gitlab-org/gitlab!145100))
- [Add option to sort ciCatalogResources by star count](gitlab-org/gitlab@54a1a80598d40ed4a642fffc80680f1a384c40f5) ([merge request](gitlab-org/gitlab!145351))
- [Add duo_features_enabled cascading setting](gitlab-org/gitlab@08b0a643cde3a0bb7bcfee114bdbf9b2afe8131c) ([merge request](gitlab-org/gitlab!144931)) **GitLab Enterprise Edition**
- [Bulk ingest archived and traversal_ids values for security reports](gitlab-org/gitlab@08f4b9c2b680d7bde0303186de589191c09bb1f1) ([merge request](gitlab-org/gitlab!144618)) **GitLab Enterprise Edition**
- [Add parallel_project_export feature flag](gitlab-org/gitlab@1209339688c917a967877e89fa5c591f4d22e01f) ([merge request](gitlab-org/gitlab!145165))
- [Update denoramlized vuln read archived when projects are archived](gitlab-org/gitlab@529826c7bb117cb6ccee4cd4952cc3207fe48736) ([merge request](gitlab-org/gitlab!144455)) **GitLab Enterprise Edition**
- [Prepare issues table to backfill work items for epics](gitlab-org/gitlab@b1cfb979498102d1261081f24cc844e0235909b6) ([merge request](gitlab-org/gitlab!145124))
- [Keep showing create issue loading spinner while redirecting](gitlab-org/gitlab@0929a192c02d5f3d8c7301d8a18021fa805b2a05) ([merge request](gitlab-org/gitlab!144991)) **GitLab Enterprise Edition**
- [Purge old `security_scans` records on self-hosted installations](gitlab-org/gitlab@1ee7388709bbc8d5450164bbb60708613633a64a) ([merge request](gitlab-org/gitlab!144456))
- [Add custom payload template to webhooks](gitlab-org/gitlab@f8cfcb4fc3425636f4aede663078ae2caa503969) by @Taucher2003 ([merge request](gitlab-org/gitlab!142738))
- [Adds association count on organization level](gitlab-org/gitlab@d88c728d00ac23636b3a9c42bea76cf0e4d4a3d8) ([merge request](gitlab-org/gitlab!144726))
- [Add migration to add count fields to projects](gitlab-org/gitlab@ca9ba8a38fe0abbc19803729d1c8ad935ce6705e) ([merge request](gitlab-org/gitlab!144557)) **GitLab Enterprise Edition**
- [Add metrics for keep-around ref creation](gitlab-org/gitlab@de7031379b6ddc73934261b6f4a478e7947cfa8b) ([merge request](gitlab-org/gitlab!144809))
- [Add remove_child quick action for work items](gitlab-org/gitlab@d4d761fc83660692d39b03c50b7ab2a18417503c) ([merge request](gitlab-org/gitlab!141354))
- [Support job:rules:interruptible in CI config](gitlab-org/gitlab@78bd296182b6a2f1dd38345cbcaf1e7d76e1cacf) ([merge request](gitlab-org/gitlab!144687))
- [Add semantic version validation for catalog versions](gitlab-org/gitlab@8af3ded67da2dade5e090bdf471ca55df59893a0) ([merge request](gitlab-org/gitlab!144052))
- [Adds attribution_notice to Bugzilla integration](gitlab-org/gitlab@966edeabb3eaa40438d4ff69bb7bb997071f69c5) ([merge request](gitlab-org/gitlab!144166))
- [Run security reports ingestion for pipeline blocked with manual jobs](gitlab-org/gitlab@a1c5d4fc156a47702dccdff5812b7e378a433ee9) ([merge request](gitlab-org/gitlab!143046)) **GitLab Enterprise Edition**
- [Add Kubernetes overview on the Environment details page](gitlab-org/gitlab@04addb05c22b46001c798a99068c720215fd1d54) ([merge request](gitlab-org/gitlab!144370))
- [Enable VSA cumulative duration calculation](gitlab-org/gitlab@dfbf02a0b78000ec9d9115b8953ac969f0038e3c) ([merge request](gitlab-org/gitlab!144838)) **GitLab Enterprise Edition**
- [Adds search support to user organizations GraphQL query](gitlab-org/gitlab@116d540354890c4280a59f9b072f980d1080a2dd) ([merge request](gitlab-org/gitlab!144338))
- [Add configuration settings for Arkose client API](gitlab-org/gitlab@2043fe594f2fa16696c6429805108b94224957c0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/144534))
- [WorkItems rolledup dates: make fixed dates nullable on graphql](gitlab-org/gitlab@e402022624f847d31a38b653f6fb383df5ea185a) ([merge request](gitlab-org/gitlab!144451)) **GitLab Enterprise Edition**
- [Add throttling to bulk assignments](gitlab-org/gitlab@13806020f9e3f8f852ae1efc08e09280f14497a3) ([merge request](gitlab-org/gitlab!144745)) **GitLab Enterprise Edition**
- [Reuse existing projects & groups resolvers for Organization](gitlab-org/gitlab@9658c87958a54735b77882e270e2ca07ec54a7c8) ([merge request](gitlab-org/gitlab!144716))
- [Cancel a pipeline when configured to auto cancel on first job failure](gitlab-org/gitlab@88df5f5092e722fa408690fe4a38ebf0b9eb71cb) by @zillemarco ([merge request](gitlab-org/gitlab!141812))
- [feat: Protected packages: Delete protection rules in project settings ui](gitlab-org/gitlab@604002909fa988169c4c847e1e9451f29c5bb1c5) by @gerardo-navarro ([merge request](gitlab-org/gitlab!140483))
- [Replace FKs for p_ci_job_artifacts](gitlab-org/gitlab@01b364b8f0ab992249b3fe0dbc86c53a4964f144) ([merge request](gitlab-org/gitlab!144569))
- [Validate the foreign key & add to routing table upstream_pipeline_id](gitlab-org/gitlab@082ef3ac9bcbfac4d2f6e2d0ffa2bb548452abcf) ([merge request](gitlab-org/gitlab!144418))
- [Sync create indexes and prepare FK for p_ci_builds commit_id](gitlab-org/gitlab@fb679799339293f95cbc897a46fb6a22e08b9db5) ([merge request](gitlab-org/gitlab!144416))
- [Prepare async index for p_ci_builds.runner_id and project_id](gitlab-org/gitlab@569927247f88d04f6743b069f7a23c82b8f12f48) ([merge request](gitlab-org/gitlab!144414))
- [Use built-in multiline block quotes from parser](gitlab-org/gitlab@64fd38a6ebad791151e4e763dc82fead384e60ec) ([merge request](gitlab-org/gitlab!144379))
- [Add application setting for limit of merge request approval policies](gitlab-org/gitlab@381185ae27da69df4f8f29a2722ff9dcf75585ef) ([merge request](gitlab-org/gitlab!143849)) **GitLab Enterprise Edition**
- [Enable project redirect when fetching CI components](gitlab-org/gitlab@02e8ddbc0be5e6f42190be2ef8d23c3fb43fe229) ([merge request](gitlab-org/gitlab!144234))
- [Add the ability to sort findings](gitlab-org/gitlab@21cda12ba051b1c0640f00b9514bffee3575ea5a) ([merge request](gitlab-org/gitlab!142773)) **GitLab Enterprise Edition**
- [Fix WorkItems::RolledupDatesFinder](gitlab-org/gitlab@c590f431e7a1c1b050af83998e0f2eda90d6e698) ([merge request](gitlab-org/gitlab!143853)) **GitLab Enterprise Edition**

### Fixed (165 changes)

- [AdvisoryScanner recovers invalid version error](gitlab-org/gitlab@c85021c98817798ca2bf92555dd64f7de7fd70cf) ([merge request](gitlab-org/gitlab!147120)) **GitLab Enterprise Edition**
- [Add rake task to delete orphan artifact objects](gitlab-org/gitlab@e376ab7eba4f8d6fb16277e3c2b3dfd2e8b743b0) ([merge request](gitlab-org/gitlab!146093))
- [Fixed search input at small sizes](gitlab-org/gitlab@b0c6064fc61778f8bf6a578c5e7b7692f5d11ea7) ([merge request](gitlab-org/gitlab!147098))
- [Fix sidebar padding problem for issue lists](gitlab-org/gitlab@e97e31aa24678d314054bf6a2ad400f347b344a6) ([merge request](gitlab-org/gitlab!146954))
- [Fix incorrect dashboards link within onboarding flow](gitlab-org/gitlab@bf7e5046dfca54f7ac631707f7a93d46ad8b6c74) ([merge request](gitlab-org/gitlab!146967)) **GitLab Enterprise Edition**
- [Bulk deletes should respect search_index_all_projects FF](gitlab-org/gitlab@60ab1efa915c5b4f725c126256e9c129aab7f398) ([merge request](gitlab-org/gitlab!146999)) **GitLab Enterprise Edition**
- [Fix links to project issues redirect to wrong server](gitlab-org/gitlab@7d01bf2c60f617bdd56df43486ef12f23bad762e) by @lifez ([merge request](gitlab-org/gitlab!146433))
- [Truncate description and solution when ingesting Vulnerabilities](gitlab-org/gitlab@06391d0dc1b962811746d16f9556d7478eabd41e) ([merge request](gitlab-org/gitlab!146571)) **GitLab Enterprise Edition**
- [Fix a bug when mvn uses the dependency proxy with basic auth](gitlab-org/gitlab@5f517356a06b025239f910fc749775b5011867f4) ([merge request](gitlab-org/gitlab!146665))
- [Fix style problems for issues list on small screen](gitlab-org/gitlab@231127b6356687bf61d06ae25f823b528ba14a7a) ([merge request](gitlab-org/gitlab!146394))
- [Fix Repository analytics commit statistics failing to render](gitlab-org/gitlab@e9ba6a27a4b82c5ef0feae1a3702f2c400c460ed) ([merge request](gitlab-org/gitlab!146675))
- [Allow users to use _EXCLUDED_ANALYZERS variable in SEP](gitlab-org/gitlab@072cf3d3fae6ac9b0d97a0b44120d0833c6bc543) ([merge request](gitlab-org/gitlab!144243)) **GitLab Enterprise Edition**
- [Update pages ci templates - Hexo, Hugo, Hyde](gitlab-org/gitlab@fe427d85e54283b0475cb3116cafdfd3af62e7d3) ([merge request](gitlab-org/gitlab!146050))
- [Design management: Fix overflow of video](gitlab-org/gitlab@1269d6ad2d858b39e39d55dfdb7c8b4d946fac91) ([merge request](gitlab-org/gitlab!146903))
- [Limit security policy project resolver suggestions](gitlab-org/gitlab@cef98dcd59e0eac397c65985ce16a818451685d5) ([merge request](gitlab-org/gitlab!146892)) **GitLab Enterprise Edition**
- [Make sure spinner occupies enough vertical space](gitlab-org/gitlab@176e38e3b5d110433a44f0f0079f8261527b05b6) ([merge request](gitlab-org/gitlab!146535))
- [Issuable sidebar: Improve promotions and hide empty section](gitlab-org/gitlab@4ca9820861522c17264c7afd264f5c08b30b0d5d) ([merge request](gitlab-org/gitlab!146879))
- [Change bootstrap migration reset font weight bold value](gitlab-org/gitlab@c5f730ce559152349e9d0da3a3d14e24649369d9) ([merge request](gitlab-org/gitlab!146872))
- [Prevent mutating line endings](gitlab-org/gitlab@1aaf877acdf90e2aaf693da05851728a45df81ab) ([merge request](gitlab-org/gitlab!137641))
- [Resolve validation failing for theme_id when previous dark mode value 11](gitlab-org/gitlab@4526b9ebac1c98921365c27061b1e80bbb04fc1d) ([merge request](gitlab-org/gitlab!146845))
- [Add exit status when backup fail](gitlab-org/gitlab@d664f5b8d136fdf3005a3fdb4d22bbe6519f6156) by @lifez ([merge request](gitlab-org/gitlab!145943))
- [Clear search input when selecting or deselecting a reviewer](gitlab-org/gitlab@3adcfb3228272b5d995b7a394c96f41b13906042) ([merge request](gitlab-org/gitlab!145247))
- [Refactor Vue shared `SettingsBlock`](gitlab-org/gitlab@877bdbcad632b4e5164393181e44e5cb6a574530) ([merge request](gitlab-org/gitlab!146156)) **GitLab Enterprise Edition**
- [Clarify ambiguous instructions](gitlab-org/gitlab@6453121e844e17f7eca808b9c45a32993e1f0096) ([merge request](gitlab-org/gitlab!142782)) **GitLab Enterprise Edition**
- [Fix encoding error when downloading archive](gitlab-org/gitlab@f974d7b2a4a7485115eef8225851d37ae8ba60cf) ([merge request](gitlab-org/gitlab!146705))
- [Resolve Issue list page size control overlap](gitlab-org/gitlab@2308ffc9fa8895bf938bf1b9cf04fef15834cf99) ([merge request](gitlab-org/gitlab!145848))
- [Fix pagination in wiki pages and templates](gitlab-org/gitlab@c486b3fe6aa3b0ddaafa387009268b89004009fe) ([merge request](gitlab-org/gitlab!146468))
- [Ensure that scan-policies stage is added after .pre](gitlab-org/gitlab@48319b2baee8bbd64a90cd2d60daa914e03d983e) ([merge request](gitlab-org/gitlab!146096)) **GitLab Enterprise Edition**
- [Fix compliance framework graphql query to return correct policies](gitlab-org/gitlab@977713f1fc8ca310fd7c509abcba6d704a5549de) ([merge request](gitlab-org/gitlab!146238)) **GitLab Enterprise Edition**
- [Ensure scope validation only for classic pats](gitlab-org/gitlab@98a42cf48774b1f15e9b8d56ecc6f2e4300887cf) ([merge request](gitlab-org/gitlab!146532))
- [Reload HEAD diff when MR is marked as mergeable](gitlab-org/gitlab@804b8d9ccb92ec1d469fd04338d535eee34aeedc) ([merge request](gitlab-org/gitlab!146604))
- [Fix for avatar cache not clearing on update](gitlab-org/gitlab@4340c5ef62eedf10241e812243a08e85bfe9376c) ([merge request](gitlab-org/gitlab!122639))
- [Fix Issues Analytics first-of-month loading error](gitlab-org/gitlab@8337293db998ed3dca791bc95212f8f1e59381ac) ([merge request](gitlab-org/gitlab!146546)) **GitLab Enterprise Edition**
- [Fix namespace reset](gitlab-org/gitlab@5236a9e83069bd3af4a8baf88229ed8eb1a0dd0d) ([merge request](gitlab-org/gitlab!146540))
- [Prepare push rules for committer email change](gitlab-org/gitlab@19ea246eb99d09ab40a4155e01d101f942caa15e) ([merge request](gitlab-org/gitlab!146335))
- [Empty repo: Hide empty sidebar blocks](gitlab-org/gitlab@4a5bdc76a55db8cc1aabc965cb14d23132b81df5) ([merge request](gitlab-org/gitlab!146462))
- [Fix incorrect audit event name being logged when a user is rejected](gitlab-org/gitlab@472d22ef63d30097100634a5f42f02ad22221b76) ([merge request](gitlab-org/gitlab!146458)) **GitLab Enterprise Edition**
- [Style fixes for board top bar on small screens](gitlab-org/gitlab@94ce27a63db52aa2de4001c1fcf0893b72ea5020) ([merge request](gitlab-org/gitlab!146414)) **GitLab Enterprise Edition**
- [Emoji picker: Fix icon for legacy notes](gitlab-org/gitlab@f7de180b4ed8cca021ce5f83b3262a61621c2d13) ([merge request](gitlab-org/gitlab!146369))
- [Fix policy variables in scheduled pipelines](gitlab-org/gitlab@b091e4f849f6cf68c115504cd0844c2ae87a179c) ([merge request](gitlab-org/gitlab!146064)) **GitLab Enterprise Edition**
- [Enable feature flag "fetch_commits_for_bitbucket_server" by default](gitlab-org/gitlab@fd9256e60c83d23280cad631ca0350f028fe496c) ([merge request](gitlab-org/gitlab!146353))
- [Fix missing require for users development seed](gitlab-org/gitlab@8f6166dbd04aeebbedd23cc152413ab17a53254f) ([merge request](gitlab-org/gitlab!146351))
- [Fix finding modal when dismissed by is null](gitlab-org/gitlab@7be939041e81a5950c86bfacb39f35b86bfd34f8) ([merge request](gitlab-org/gitlab!146193)) **GitLab Enterprise Edition**
- [Fix user having custom role in multiple objects in a hierarchy](gitlab-org/gitlab@2a0fff1e1679df6aa3fae4aec1c9ba2490dfdbd5) ([merge request](gitlab-org/gitlab!144851)) **GitLab Enterprise Edition**
- [Use sentence case for DORA metrics titles](gitlab-org/gitlab@073fd7fcf5ae27dace77811f011258cb48e7c508) ([merge request](gitlab-org/gitlab!145867)) **GitLab Enterprise Edition**
- [Update pipeline_triggers plan limits to 25k for trials and opensource](gitlab-org/gitlab@2cecbcd8b82850f7607b4e9a85e76f50df8f98e1) ([merge request](gitlab-org/gitlab!145846))
- [This MR fixes header for security policies](gitlab-org/gitlab@96eac69ed540c700ac0af6cf4fea989cc7190d07) ([merge request](gitlab-org/gitlab!146277)) **GitLab Enterprise Edition**
- [Change "Create new Value Stream" to "New value Stream"](gitlab-org/gitlab@b0d79d1b864dd793b2f800ed589adab0bf42e358) ([merge request](gitlab-org/gitlab!146248)) **GitLab Enterprise Edition**
- [Fix DiffStatsType encoding error](gitlab-org/gitlab@077f497ee737c0e9615321f80d855afdcd79dc6d) ([merge request](gitlab-org/gitlab!145068))
- [Use user locale to display delimiters and separators in storage usage](gitlab-org/gitlab@d22bf9d9fc411948acf13d466baff2b949670cae) ([merge request](gitlab-org/gitlab!144565)) **GitLab Enterprise Edition**
- [Export & Import diff note's diff file](gitlab-org/gitlab@ab57d9055d0f457e50c3de4127b186574f996ef3) ([merge request](gitlab-org/gitlab!145967))
- [Handle version conflict errors in ElasticDeleteProjectWorker](gitlab-org/gitlab@fd99b56be44bdb74a8886cd2ca378b1fea800c3f) ([merge request](gitlab-org/gitlab!146068)) **GitLab Enterprise Edition**
- [Assignees widget dropdown reordering of selected users](gitlab-org/gitlab@f85f207eb67495cbe9331b555266e52bd100dfc4) ([merge request](gitlab-org/gitlab!145901))
- [Inspect start_branch_name if provided](gitlab-org/gitlab@54cf87270109b7d543f9f1a5c072effe54f5ab6b) ([merge request](gitlab-org/gitlab!139351))
- [Fix search within Environments folder](gitlab-org/gitlab@0e5e87e49c10e97969c7c187641f77878beb35db) ([merge request](gitlab-org/gitlab!146154))
- [Move focus to "What's new" drawer when opened](gitlab-org/gitlab@7e43fee0fc7df835a889c19eb3328b1a9ce7b7b7) ([merge request](gitlab-org/gitlab!144873))
- [Fix page overflow with long MR titles](gitlab-org/gitlab@4200b87ff685151ac389cf3241187fbcaa18a948) ([merge request](gitlab-org/gitlab!146103))
- [Release fetching all npm package tags](gitlab-org/gitlab@9031573c52bddcf17f20b8e563caf1c603d38565) ([merge request](gitlab-org/gitlab!144434))
- [Update Duo Pro Card to to show Add seats button for SM](gitlab-org/gitlab@6d19053750ea2f35f5bf2080fc6595981aed6aa3) ([merge request](gitlab-org/gitlab!145689)) **GitLab Enterprise Edition**
- [Supply the sequence name to the partitioning helper](gitlab-org/gitlab@644125eb09bbbc31dbbe52669527a8c13e478b3b) ([merge request](gitlab-org/gitlab!146065))
- [Fix autocomplete issue on design management comment form](gitlab-org/gitlab@b670c06fa8b594fd7155e492e3daa8580177dc31) ([merge request](gitlab-org/gitlab!146047))
- [Run specs with elastic_clean trait](gitlab-org/gitlab@cd71206c3b9f31199697d27806c111c206ba5d4f) ([merge request](gitlab-org/gitlab!145771))
- [Fix link to check out MRs locally](gitlab-org/gitlab@f7cca629e378d524cea27065f9530cf04c10bc9c) ([merge request](gitlab-org/gitlab!146041))
- [Do not raise CI lint exception if repository is empty](gitlab-org/gitlab@9a38817ff55f0f628238e0a76e20a59c1a20f066) ([merge request](gitlab-org/gitlab!145801))
- [Remove memoization for existing_sequence](gitlab-org/gitlab@ee5d8e912816d403f123eb1c0dd3824ceb2cfa16) ([merge request](gitlab-org/gitlab!146027))
- [Fixes missing "cancel" job button in admin jobs](gitlab-org/gitlab@2f8e8a1757733592d882c7d0224d4040cca6eaa1) ([merge request](gitlab-org/gitlab!146024))
- [Fix line highlighting](gitlab-org/gitlab@3df369cf54cb7c17c3a383545688ccc243d05106) ([merge request](gitlab-org/gitlab!146019))
- [Fix auth to dependency proxy with service account](gitlab-org/gitlab@9405a79b02255f917942442af1aff6454ffe15a0) ([merge request](gitlab-org/gitlab!146012))
- [Add SaaS check when fetching instance member roles](gitlab-org/gitlab@00a6aaff31941c18f979006d865cef3913458578) ([merge request](gitlab-org/gitlab!145094))
- [Proposed format changes for CI/CD Analytics](gitlab-org/gitlab@388ba9840241e7c233eba1e1e94e81ba5e45ed83) ([merge request](gitlab-org/gitlab!141307))
- [Include epic events on Profile page heat map](gitlab-org/gitlab@bc7602f7ca163ad03ec87889b37cabae071cf144) by @zzaakiirr ([merge request](gitlab-org/gitlab!138688))
- [Manage external issue tracker links to Vulnerabilities using events](gitlab-org/gitlab@a80b6a445c5171857fd97b1ba4874e42309e5370) ([merge request](gitlab-org/gitlab!145563)) **GitLab Enterprise Edition**
- [Change DuoChat z-index value to put it behind the feedback modal](gitlab-org/gitlab@96f283f2c5d4a06f1194cf90ebbc85f618c27180) ([merge request](gitlab-org/gitlab!145802)) **GitLab Enterprise Edition**
- [Check merge request's head_sha pipeline instead of latest](gitlab-org/gitlab@fd9980a6110598c4abc8f37db631e9674488ecfd) ([merge request](gitlab-org/gitlab!144919)) **GitLab Enterprise Edition**
- [Expose auth_method for remote mirrors via API](gitlab-org/gitlab@7d2177d947f48440211d49a3ac30c5405a369a21) ([merge request](gitlab-org/gitlab!75155))
- [Fix container repositories checksum mismatch errors](gitlab-org/gitlab@8a631409ceac9eaf66248741f7e31e2a47899c6d) ([merge request](gitlab-org/gitlab!145869)) **GitLab Enterprise Edition**
- [Make enum consistent to vulnerability enum](gitlab-org/gitlab@c9388aa1d7687098f0b5c82d7d444b54a5dafbc3) ([merge request](gitlab-org/gitlab!144849)) **GitLab Enterprise Edition**
- [Change query for assignee users to autocomplete query](gitlab-org/gitlab@49edefe573d4fbfb7d7cf8cd5e61b9a5aec95c00) ([merge request](gitlab-org/gitlab!145370))
- [Fix composability of `:published_event` with `:not_publish_event`](gitlab-org/gitlab@fe7cd8a3035beb4874f22df82e0bf59f34afdf86) ([merge request](gitlab-org/gitlab!144777))
- [Fixes duplicate users in search suggestions](gitlab-org/gitlab@384a98956d5ea3fe900a6854f7edf2edd66ba80f) ([merge request](gitlab-org/gitlab!145818))
- [Fix boolean and number input types](gitlab-org/gitlab@a4032ae6aef2e5dbd8a63b5a78fa3b334ab8e98f) ([merge request](gitlab-org/gitlab!145257))
- [Google Chat: Support inline replies](gitlab-org/gitlab@1ae2e61298b8a0463a570ff6ba16969356f87c82) by @robbie-demuth ([merge request](gitlab-org/gitlab!145187))
- [Web IDE Link: Hide button if empty](gitlab-org/gitlab@0daf8bf5c20d703cbf81c6c8799fee8bb13c0bef) ([merge request](gitlab-org/gitlab!145812))
- [Fix multi-line highlighting](gitlab-org/gitlab@34fa08685dbdaa41375ec5615609be7f925af4d3) ([merge request](gitlab-org/gitlab!144884))
- [Use `pre-wrap` to both preserve whitespace and wrap long lines](gitlab-org/gitlab@3e109880ebfee0754bb8172fe8dee15bf89a2b4f) ([merge request](gitlab-org/gitlab!145482))
- [Use sentence case for VSA Lifecycle metric titles](gitlab-org/gitlab@0040d58416ccc7a66e88c43b94d457b9f6cf56a1) ([merge request](gitlab-org/gitlab!145717)) **GitLab Enterprise Edition**
- [Fixes bug where Geo servers may leave orphaned Upload rep. stuck](gitlab-org/gitlab@c77566920dd7297a47b30942169b1b75f721ce87) ([merge request](gitlab-org/gitlab!142456)) **GitLab Enterprise Edition**
- [Update proxied request to use secondary for push_from_secondary](gitlab-org/gitlab@b93ec88eb37294778f70a8dc32cb8ce4aa665650) ([merge request](gitlab-org/gitlab!143980)) **GitLab Enterprise Edition**
- [Fix alert showing for unlimited schedules](gitlab-org/gitlab@b4e5516ce87a9d15393ea1ac984285c3687d143e) ([merge request](gitlab-org/gitlab!145695))
- [Add support for sidebar, example and openblock in AsciiDoc](gitlab-org/gitlab@ef0d0f9724d4cecb0ec5d0aa58b2dd9fb601841e) ([merge request](gitlab-org/gitlab!145379))
- [Fixed contributor count metric in VSD comparison table](gitlab-org/gitlab@328077d72a2cfa5fb2db63e4186ba59169317cd8) ([merge request](gitlab-org/gitlab!145682)) **GitLab Enterprise Edition**
- [Fix popover position for dependency list export](gitlab-org/gitlab@30ef0993c537c4d823df04ac774bc741fbd08fb9) ([merge request](gitlab-org/gitlab!145604)) **GitLab Enterprise Edition**
- [Increase packages_pypi_metadata keywords text limit](gitlab-org/gitlab@3b877ebf6a2e059e8b936a2fd3f69a64da1a4d94) ([merge request](gitlab-org/gitlab!144983))
- [Re-introduce drop user_interacted_projects table](gitlab-org/gitlab@574d864290ad35d20d33bce9198a6d22d9ce67c9) ([merge request](gitlab-org/gitlab!145260))
- [Do not remove indentation when pasting in code block](gitlab-org/gitlab@6c59aad2decc096a62deb2f2e515732499509160) ([merge request](gitlab-org/gitlab!143793))
- [Geo: Fix incorrect return values](gitlab-org/gitlab@f1a3391ad943e58217fc9e5a47794f217378d533) ([merge request](gitlab-org/gitlab!145616)) **GitLab Enterprise Edition**
- [Hide roles and permissions page from admin area when in SaaS mode](gitlab-org/gitlab@507361069cbadfe3766b748fe10242fde0aa264d) ([merge request](gitlab-org/gitlab!145262)) **GitLab Enterprise Edition**
- [Fix required approvals for mixed policies](gitlab-org/gitlab@86fc8568572466a532fe3971bb21d185e1c839f2) ([merge request](gitlab-org/gitlab!145572)) **GitLab Enterprise Edition**
- [Handle projects not found in Zoekt indexer worker](gitlab-org/gitlab@2c00ff21679c4287cef16853b86b62df8696b31d) ([merge request](gitlab-org/gitlab!145571)) **GitLab Enterprise Edition**
- [Handle a deletion of deployments for the removed repository](gitlab-org/gitlab@0c85dc6160d74f71ca0f2b81e6482ec86b61d772) ([merge request](gitlab-org/gitlab!145498))
- [Fix link anchors for synthetic system notes](gitlab-org/gitlab@ea1ffd2245d28861070dc1246b1b2ac3222983a5) ([merge request](gitlab-org/gitlab!145489))
- [Fix issue with uploading images sometimes](gitlab-org/gitlab@3c4c967a57ebf122be0d595a2c05ba9ce0f68029) ([merge request](gitlab-org/gitlab!144131))
- [Merge when checks pass should not need a pipeline to merge](gitlab-org/gitlab@5a9f0ac851aa4ba2e0b6ac7a2dbc5b381ca00f0c) ([merge request](gitlab-org/gitlab!144553))
- [Fix participants query in MR list page](gitlab-org/gitlab@a031162213a98d77dbd1089f2af1fc12dee7e4d8) ([merge request](gitlab-org/gitlab!145381))
- [Fix Container Registry Path](gitlab-org/gitlab@b77ae8639d0266b7a9364735f1cf3015cbcda68a) ([merge request](gitlab-org/gitlab!145389))
- [Job status: Add missing status text to GraphQL query](gitlab-org/gitlab@322aefda8599d1a915c6ab8db320daba1f2e0273) ([merge request](gitlab-org/gitlab!145139))
- [Improve show/hide logic of cube query generation frontend](gitlab-org/gitlab@2d149b9f695d86f5bec5f029a9de39ce99066f17) ([merge request](gitlab-org/gitlab!144415)) **GitLab Enterprise Edition**
- [Ensure errors.css is interpreted as UTF-8 encoding](gitlab-org/gitlab@b936a1d344d49bce1af09f92826dc152b77129d1) ([merge request](gitlab-org/gitlab!145363))
- [Keep code dropdown open when focusing clone inputs](gitlab-org/gitlab@d74e986b2ea8ae7be698b8583b5ef37fcabaf500) ([merge request](gitlab-org/gitlab!145304))
- [Fixed Shows branch name in non-blobs scopes](gitlab-org/gitlab@d60e1385ef64c13ff3aa50dc19a8cf624f3b0fac) ([merge request](gitlab-org/gitlab!142406))
- [Fix policy bot comment layout](gitlab-org/gitlab@8ba7c0fb55574c644db6fcfd5b023e93be69bcfb) ([merge request](gitlab-org/gitlab!145282)) **GitLab Enterprise Edition**
- [Fix overwriting the SOURCE_CODE variable in Code Quality](gitlab-org/gitlab@428327f364a601a9baff09be3fff6a1689e0fb0f) ([merge request](gitlab-org/gitlab!143018))
- [Emoji picker height in user edit profile page](gitlab-org/gitlab@88ac0ac0f404fd3525abedb57f6fe1779d15cf91) ([merge request](gitlab-org/gitlab!145240))
- [Fix highlight worker event ordering](gitlab-org/gitlab@a77f9e9ff46699fba0a95661d98f5bc75f33b206) ([merge request](gitlab-org/gitlab!145148))
- [Fix vulnerabilities seeder](gitlab-org/gitlab@cb8875c1aac0a1b7d7b4f01982de20aa0ba01640) ([merge request](gitlab-org/gitlab!145163))
- [Don't escape query in "Search or go to..." modal twice](gitlab-org/gitlab@d95bd7aa30d138d210f350201c34b52b799f5af6) by @syvb ([merge request](gitlab-org/gitlab!145158))
- [Mark issuable-resource-links as unique on create](gitlab-org/gitlab@463db89eb519aaddab6e64ada70b83a013be9a86) by @tomasz.skorupa ([merge request](gitlab-org/gitlab!143642)) **GitLab Enterprise Edition**
- [Fix queue purge security scans migration](gitlab-org/gitlab@426115c8c59e705c594777189fec6bba8e2886d0) ([merge request](gitlab-org/gitlab!145130))
- [Enable user/group pages access when namespace_in_path is enabled](gitlab-org/gitlab@5850113d14e830fe431a0d63dd42dd108f9a6d1e) ([merge request](gitlab-org/gitlab!144576))
- [Pipeline Status: Add aria-label](gitlab-org/gitlab@a50d244cf3a00c93be3c8094106282848bf87225) ([merge request](gitlab-org/gitlab!144969))
- [Adds the empty string fallback for organization description field](gitlab-org/gitlab@fa45b4f92de9e4448ce93a4f422f4544a6e3fa35) ([merge request](gitlab-org/gitlab!144896))
- [Check the actual bytesize of a Sentry JSON payload](gitlab-org/gitlab@48507d54bbfa735bd2847f35621c6d283ba6c332) ([merge request](gitlab-org/gitlab!112813))
- [Fix delete text on attach file toolbar button](gitlab-org/gitlab@60b5695e70f54bf34e4a37b95183cee0ceffc166) ([merge request](gitlab-org/gitlab!145034))
- [Profile page: Fix whitepsace  issue](gitlab-org/gitlab@c7e996f8f952bcabf79dd36f808a813a3a40aa7b) ([merge request](gitlab-org/gitlab!144955))
- [Fix boolean and number input types](gitlab-org/gitlab@24dabbb7d60819b209d1563c0d60e748620ec6af) ([merge request](gitlab-org/gitlab!144065))
- [Make `/clear_weight` work when weight is 0](gitlab-org/gitlab@dcc5068812cdb5c849bc00a46b6122476eed4065) ([merge request](gitlab-org/gitlab!145002)) **GitLab Enterprise Edition**
- [Adds users_organization_path to the organization home page](gitlab-org/gitlab@32e24b3baad4766d5d2a90cdef030da0efb01407) ([merge request](gitlab-org/gitlab!144878))
- [Make bundler-checksum work with RubyGems 3.5.6](gitlab-org/gitlab@f0de0f34901266750794bebddb60b10e8d0d642a) ([merge request](gitlab-org/gitlab!144985))
- [Repository: Fix code owners question icon color](gitlab-org/gitlab@0994efe550d105aa35695dc3d316ba0e7c0051ad) ([merge request](gitlab-org/gitlab!144634)) **GitLab Enterprise Edition**
- [Board - Fix creating issue in board scoped to iteration](gitlab-org/gitlab@1101bb89195da41aaa5911c02816744b9eae6e4b) ([merge request](gitlab-org/gitlab!144689)) **GitLab Enterprise Edition**
- [Add conditional operator to check for descriptionVersion being null](gitlab-org/gitlab@7236bc723087c919d6e3371112fcc90a88015d38) ([merge request](gitlab-org/gitlab!144949))
- [Mark code_suggestions as ignored](gitlab-org/gitlab@1ee566f4caecd01b118b6909ec0041a3c110b7ef) ([merge request](gitlab-org/gitlab!144892))
- [Fix alert showing for guest/reporter](gitlab-org/gitlab@3b2bb2575bbc00ef5321cc6c9825398fecf9a8ce) ([merge request](gitlab-org/gitlab!144901))
- [Project list item: Fix avatar spacing and alignment](gitlab-org/gitlab@7d2a4cc4714d0b89c079cb65db02021967c6e686) ([merge request](gitlab-org/gitlab!144898))
- [Add a safeguard against non-matching diff discussion positions](gitlab-org/gitlab@a9b42a7e2785101d696b1ec5b354aea8c2f313d3) ([merge request](gitlab-org/gitlab!144865))
- [Prevent policy bot message on non-applicable branches](gitlab-org/gitlab@4b3f6a0657b1979cd6534e0e87f168eab72d6c3f) ([merge request](gitlab-org/gitlab!144863)) **GitLab Enterprise Edition**
- [Set correct state for Apply button after action](gitlab-org/gitlab@ca45668160caf3e27be3c3a48c5211731b55524b) ([merge request](gitlab-org/gitlab!144862)) **GitLab Enterprise Edition**
- [Scope rejected projects query for better performance](gitlab-org/gitlab@f1ce9c5b24f969fc3cf8d6a76eff3a5323292f96) ([merge request](gitlab-org/gitlab!144047)) **GitLab Enterprise Edition**
- [Hide "email a new issue" on archived issues lists](gitlab-org/gitlab@eaaf0f1247a129d4b9fc5082f768b98cb14fe2b2) ([merge request](gitlab-org/gitlab!144058))
- [Consider pipelines with supported sources for MR approval policy](gitlab-org/gitlab@0b08e35779b472f4dc0dd9270a1c917e09156541) ([merge request](gitlab-org/gitlab!144825)) **GitLab Enterprise Edition**
- [Fix Search::Zoekt.index? logic](gitlab-org/gitlab@c8f7bbc7848ea348f5688ce430616fedecc2c898) ([merge request](gitlab-org/gitlab!144592)) **GitLab Enterprise Edition**
- [Remove `gl-z-index-200` from inline findings icon](gitlab-org/gitlab@518a6557ee95299af1d99dc0e3481954a72b0bac) ([merge request](gitlab-org/gitlab!144771)) **GitLab Enterprise Edition**
- [Reintroduces error tracking approximate user count](gitlab-org/gitlab@f1ac7ef970c590d98f84428f5652c0255b847372) ([merge request](gitlab-org/gitlab!144384))
- [Rename security dashboard graphql error alert](gitlab-org/gitlab@c7e343d4a7b0ae11bb0edd5019e75067588f13f8) ([merge request](gitlab-org/gitlab!144775)) **GitLab Enterprise Edition**
- [Fix including CI files in pipeline execution policy](gitlab-org/gitlab@089e07e8439caab0a8d25235670cb19abbcf9e2c) ([merge request](gitlab-org/gitlab!144727)) **GitLab Enterprise Edition**
- [Ignore compliance CI config when source is on-demand DAST scan](gitlab-org/gitlab@7638eb2383826bf63fd19d08502ea76669a71a3b) ([merge request](gitlab-org/gitlab!144307)) **GitLab Enterprise Edition**
- [Merge request checks: Fix right alignment of actions](gitlab-org/gitlab@a8cb6a80e0b8690965f2eea0097e5897a2f2853c) ([merge request](gitlab-org/gitlab!144724))
- [Readme: Fix anchor overflow behavior when collapsed](gitlab-org/gitlab@98f6b8c22097e0d584356f946946ecb9b2671b35) ([merge request](gitlab-org/gitlab!144571))
- [Update pages ci templates - Doxygen](gitlab-org/gitlab@3ccebc465ca01fb8cd3fc89f620cbf12898e2584) ([merge request](gitlab-org/gitlab!144317))
- [Fix Geo: Personal snippets not syncing](gitlab-org/gitlab@14b1af7e3b39179375439e9fc888eadc2bd51b8d) ([merge request](gitlab-org/gitlab!143456)) **GitLab Enterprise Edition**
- [Vulnerability Details: Fix code-snippet rendering](gitlab-org/gitlab@62dc1de6a55d21daa3942bb192a7c23fe6bdc2e4) ([merge request](gitlab-org/gitlab!144444)) **GitLab Enterprise Edition**
- [This MR fixes alignment](gitlab-org/gitlab@1763ec36864731b13c539689a4286c130f483e3b) ([merge request](gitlab-org/gitlab!144348)) **GitLab Enterprise Edition**
- [Add error recovery for package metadata sync](gitlab-org/gitlab@501075e19485de53c93b0405c10cc0c15149fcc5) ([merge request](gitlab-org/gitlab!144090))
- [Readmore shadow: Fix darkmode](gitlab-org/gitlab@329bcd9481289403f255ad386b55b24b8557e037) ([merge request](gitlab-org/gitlab!144568))
- [Fix GitLab for Slack app disabled when uninstalled](gitlab-org/gitlab@7de79ac28efecdd4388b54a7bcea66e009b30cf3) ([merge request](gitlab-org/gitlab!144544))
- [Add spacing to "Awaiting user signup" badge](gitlab-org/gitlab@986a26854a510b25ec0e855228b07c146bfbd792) by @yonghyun.jin13 ([merge request](gitlab-org/gitlab!141181))
- [Fix the name of a missing svg for the tests reports](gitlab-org/gitlab@52121f27ea34d66d6823f171a72dc2a3175a39cb) ([merge request](gitlab-org/gitlab!144362))
- [Changes the empty state illustation from CI/CD Analytics](gitlab-org/gitlab@4e39718b157492c0a256e003ec912caab632c816) ([merge request](gitlab-org/gitlab!144487))
- [Fix error from using `inputs` in some cases](gitlab-org/gitlab@ba97ac19e27fb650c9cc33d72181bff666c2874d) ([merge request](gitlab-org/gitlab!144497))
- [Fix deny_all_requests_except_allowed of AddressableUrlValidator](gitlab-org/gitlab@3d9f595d1b1a4f057c37770ac2ee0312c0b6e8a7) ([merge request](gitlab-org/gitlab!144488))
- [Fix File Browser height update on merge request tab change](gitlab-org/gitlab@e23549d421fc5692abfa2763b85a5a25793f840e) ([merge request](gitlab-org/gitlab!144458))
- [Account for typed code block responses from the LLM](gitlab-org/gitlab@2028e11ad4ad51cc1ecee021816b9134936947e3) ([merge request](gitlab-org/gitlab!144358)) **GitLab Enterprise Edition**
- [Make variable value listbox searchable](gitlab-org/gitlab@9b91529d6a563c3f7ad3d6ebde84bfda1d67bd43) ([merge request](gitlab-org/gitlab!143529))
- [Hide exposed artifacts when there are none](gitlab-org/gitlab@650e8107815f8eb6479bc13882aefdd854ad8cf7) ([merge request](gitlab-org/gitlab!143698))
- [Fix permissions check for runner usage by project](gitlab-org/gitlab@f72ecedc94a50668080bff83ce05593aa2adc4f6) ([merge request](gitlab-org/gitlab!143352))

### Changed (207 changes)

- [Change pipeline schedule button text](gitlab-org/gitlab@a2ea0248f57d9fb27a3f61d62d445592790efcca) ([merge request](gitlab-org/gitlab!147058))
- [Update MR empty states](gitlab-org/gitlab@d221a84ca42f98af1173ba65de862294197370a3) ([merge request](gitlab-org/gitlab!146708))
- [Updated the texts in the Protected environments under CI/CD Settings tab](gitlab-org/gitlab@b5ef5f805320d28a015d65a53e5d794b0aa40c0d) by @antonkalmykov ([merge request](gitlab-org/gitlab!147035)) **GitLab Enterprise Edition**
- [Projects: Improve pending deletion visibility and message](gitlab-org/gitlab@5b26f9c384db51533fe3ad69ea2e4d086062ca3e) ([merge request](gitlab-org/gitlab!146082))
- [Audit member access on destroy](gitlab-org/gitlab@38aacd015273bcfe45ea46f24c821de1c4ab73fd) ([merge request](gitlab-org/gitlab!146908)) **GitLab Enterprise Edition**
- [Design management add ability to toggle comments](gitlab-org/gitlab@e8e2aa5fbe895b3ce187bf3b9f08bf394b994760) ([merge request](gitlab-org/gitlab!146290))
- [Clarify audit event type script text](gitlab-org/gitlab@300e410878b6da70c6ff5ffe69580264b7a38706) ([merge request](gitlab-org/gitlab!146960))
- [Improve error message when job is missing an artifact](gitlab-org/gitlab@7639c2c7db731f1be98938d695ae9e1a9c3ad847) ([merge request](gitlab-org/gitlab!146941))
- [Disable release button for catalog resources](gitlab-org/gitlab@bf1f6ad7428842cf7d5784d13f29aaf783b415bc) ([merge request](gitlab-org/gitlab!145701))
- [Guided setup for Google Cloud IAM integration - 3](gitlab-org/gitlab@0f503f650d1dafcd70beb2dd4a10749f4ccbcc80) ([merge request](gitlab-org/gitlab!146174)) **GitLab Enterprise Edition**
- [This MR changed default state for policy scope](gitlab-org/gitlab@5fba32dab3df4627a93b7e975637662abb3b35a5) ([merge request](gitlab-org/gitlab!146210)) **GitLab Enterprise Edition**
- [Update todo and notifications for work items](gitlab-org/gitlab@25b37bd1f36113598ffaefd407f49218361a2c4b) ([merge request](gitlab-org/gitlab!145711))
- [Update commits empty state](gitlab-org/gitlab@88dd091d81f98187d9283d577e93f1df8e184489) ([merge request](gitlab-org/gitlab!146531))
- [Update kubernetes cluster empty state](gitlab-org/gitlab@ca986649138437d15b79ca4f804adf60c5756886) ([merge request](gitlab-org/gitlab!146358))
- [Added new columns and removed unwanted not null constraint](gitlab-org/gitlab@86f299d430d36db4a645c7c16bf8870896ee71f8) ([merge request](gitlab-org/gitlab!144882)) **GitLab Enterprise Edition**
- [Allow milestones to be specified by full path](gitlab-org/gitlab@d7d326b6d944bc30b0a33473a7e4eb24dcbefa3c) ([merge request](gitlab-org/gitlab!143859))
- [Assign default security policy stage](gitlab-org/gitlab@03591fa30b5c95e47a855593465cb0ff47457a9e) ([merge request](gitlab-org/gitlab!145914)) **GitLab Enterprise Edition**
- [Improve environments dashboard](gitlab-org/gitlab@40d007dd394da43c5b901db2cb315a8e45773c05) ([merge request](gitlab-org/gitlab!146258)) **GitLab Enterprise Edition**
- [Update frontend versioning](gitlab-org/gitlab@d3176d6895dc2cc27ce7dbd82e0de698480e2a75) ([merge request](gitlab-org/gitlab!146479))
- [Decouple dark color mode from navigation themes](gitlab-org/gitlab@66f9b887e601d888602aabe211454958616ffeb2) ([merge request](gitlab-org/gitlab!141459))
- [Update UI text](gitlab-org/gitlab@d7311e818cceba40f4496d8db7ef73f51fbc2b6d) by @jrachelr1 ([merge request](gitlab-org/gitlab!146432))
- [Modified source of the current scope](gitlab-org/gitlab@5d3c0e4371d195f77bb5c6c9f2f6fd2c7b1c17c3) ([merge request](gitlab-org/gitlab!146338))
- [Align merge request sticky header with static header](gitlab-org/gitlab@ab1a618aedbdc2c5ca6a778d599df8a8710c4c57) ([merge request](gitlab-org/gitlab!146809))
- [Change column null for `traversal_ids` of the `vulnerability_reads`](gitlab-org/gitlab@932600ee31623be2fe86ca92a19a45c971f36d9b) ([merge request](gitlab-org/gitlab!146800))
- [Migrate sbom_components.name so to match PEP 503](gitlab-org/gitlab@78b9a6025f5a61d2488ad1234fd9a2f914bea824) ([merge request](gitlab-org/gitlab!145700))
- [File header: Use variable instead of magic number](gitlab-org/gitlab@6b0d3eeed0afb8a0c839fb099c10b59eb69c7620) ([merge request](gitlab-org/gitlab!145229))
- [apps/pipeline_details: Copy full commit id](gitlab-org/gitlab@8c3b60c2108da8f72fad2f56ac660a567f7301cf) ([merge request](gitlab-org/gitlab!146052))
- [User profile sidebar: Fix alignment of user details](gitlab-org/gitlab@8a6ae0886b6b5ed81258765373acb183a2f5a6a5) ([merge request](gitlab-org/gitlab!146747))
- [Expose policy_scope in security policy graphql API](gitlab-org/gitlab@b052611c1d1b8a627622c165ec4482baae72a058) ([merge request](gitlab-org/gitlab!146562)) **GitLab Enterprise Edition**
- [Update compare empty state](gitlab-org/gitlab@728033c0efc1527cd05ec49b0af38012fef097da) ([merge request](gitlab-org/gitlab!146525))
- [Rename variable to CI_SERVER_FQDN to match expected value](gitlab-org/gitlab@ed5eb77c8cb130e573e0ad96961f4a778cb7e8d9) ([merge request](gitlab-org/gitlab!146461))
- [Remove cached_conflicts_with_types feature flag](gitlab-org/gitlab@ba3b70e080869ecbb7df80553f5fc7b83fb6200f) ([merge request](gitlab-org/gitlab!146738))
- [Correctly style labels in filtered search](gitlab-org/gitlab@890398b954a1efb9df5d71f715b195bc90ddc932) ([merge request](gitlab-org/gitlab!143780))
- [Update docs to clarify framework removal](gitlab-org/gitlab@fc75ad770f7e9158fe6a16f95f17fc5eeb21db9d) ([merge request](gitlab-org/gitlab!146704)) **GitLab Enterprise Edition**
- [Projects: Improve archived visibility and message](gitlab-org/gitlab@b1050e939f0d671bdf52b9a6eaaee1841a007f1d) ([merge request](gitlab-org/gitlab!145277))
- [Removes database migrations up to 16-1-stable-ee](gitlab-org/gitlab@c9d9a3bb5c6f249075f63c7d4fbd3feed9df1ab6) ([merge request](gitlab-org/gitlab!144364))
- [Update service desk empty state illustration](gitlab-org/gitlab@f47c45dfbeb001518aef3cd5bcecb30959d58ece) ([merge request](gitlab-org/gitlab!146549))
- [Update surface alerts empty state illustration](gitlab-org/gitlab@f8873fccddf20b5e6844aac99d534b10a8e47026) ([merge request](gitlab-org/gitlab!146534))
- [Guided setup for Google Cloud IAM integration - 2](gitlab-org/gitlab@3773915b528f23e3081555c67b4b15841712ba24) ([merge request](gitlab-org/gitlab!145543)) **GitLab Enterprise Edition**
- [Only show epic lane header shadow when it overlaps](gitlab-org/gitlab@d473fee4fd5cc144181037a76a0cc7f0f1fd51d2) ([merge request](gitlab-org/gitlab!146421)) **GitLab Enterprise Edition**
- [Use new ScalarValidator for variables CI keyword](gitlab-org/gitlab@65684085897b3c3daf717d3155936ffce6a26c7b) ([merge request](gitlab-org/gitlab!146503))
- [Billing page does not scale with large font sizes](gitlab-org/gitlab@eb845e4ae2d5806a4be249b42df0393a6359c36d) ([merge request](gitlab-org/gitlab!146668)) **GitLab Enterprise Edition**
- [Removes testable method from EWM](gitlab-org/gitlab@40e558363e07e6b3bca5e9303f65a3edfcc278ce) ([merge request](gitlab-org/gitlab!146636))
- [Change todo re-add button icon and title](gitlab-org/gitlab@918f2933adc729d6737aee5bc0167a10b59b91a4) ([merge request](gitlab-org/gitlab!146254))
- [Update Terraform modules empty state illustration](gitlab-org/gitlab@848d69f63b4c59ae51a71e92ffed80955b75a1c2) ([merge request](gitlab-org/gitlab!146487))
- [Remove merge_request_diff_generated_subscription feature flag](gitlab-org/gitlab@d3f0486be4473cbe3f93b21ca4a35902c81fe6c8) ([merge request](gitlab-org/gitlab!146580))
- [This MR adds validation for policy scope](gitlab-org/gitlab@5989bdd2b2e951bdb0663fb5b78866118e04e982) ([merge request](gitlab-org/gitlab!145871)) **GitLab Enterprise Edition**
- [Keeps compliance frameworks for project transfers](gitlab-org/gitlab@657c47cd46bfc9f3c12f3d0a3a34f1e8ea0f6fcf) ([merge request](gitlab-org/gitlab!146533)) **GitLab Enterprise Edition**
- [Update incident empty state illustration](gitlab-org/gitlab@781b87bc22f484156b1847bafbff537d8e81607c) ([merge request](gitlab-org/gitlab!146537))
- [Consolidate all google cloud support feature flags into one](gitlab-org/gitlab@aeb368e8f67d68274cdda70177328ddff424ddb6) ([merge request](gitlab-org/gitlab!145918)) **GitLab Enterprise Edition**
- [Guided setup for Google Cloud IAM integration - 1](gitlab-org/gitlab@efc4b630c9b912dc9415758dcca769d5f8d7d85a) ([merge request](gitlab-org/gitlab!146028)) **GitLab Enterprise Edition**
- [Update to redis-client v0.21.0](gitlab-org/gitlab@fccd704cd2409e0cb21db495b4dcc865162401ef) ([merge request](gitlab-org/gitlab!146506))
- [Update profile empty state](gitlab-org/gitlab@b7e7e087f28bbca8441106e8b5678c74307d14c8) ([merge request](gitlab-org/gitlab!146490))
- [Update UI text replacing 'catalog resource' with 'catalog project'](gitlab-org/gitlab@289eedc11b43c1cfcc96cfc7a07a1a4d563e38cc) ([merge request](gitlab-org/gitlab!146077))
- [Add environments empty state illustration](gitlab-org/gitlab@05b2c427d55fae41bac374f431eb308a4a1e3300) ([merge request](gitlab-org/gitlab!146323))
- [Swap columns auto_canceled_by for p_ci_builds](gitlab-org/gitlab@51a6865cd17c6bd49354426aab768e511a7b3d4b) ([merge request](gitlab-org/gitlab!144845))
- [Remove sort direction sync between columns on vulnerability report](gitlab-org/gitlab@ce614adbb30fc8c64fc1e8d7528d62ec981ead85) ([merge request](gitlab-org/gitlab!146466)) **GitLab Enterprise Edition**
- [Update dependency auto-deploy-image to v2.86.0](gitlab-org/gitlab@9089b269766ccfab11ef50cccef2e21984d3449b) ([merge request](gitlab-org/gitlab!146362))
- [Remove "ref_extract_sha256" feature flag](gitlab-org/gitlab@7e5ae6d6dac929cc94e4bb9df65c0285fe72456d) ([merge request](gitlab-org/gitlab!146355))
- [Backfill traversal_ids and archived to sbom_occurrences](gitlab-org/gitlab@6a422c6e02e16f3b8b6be544e07eb81ada7fe2d1) ([merge request](gitlab-org/gitlab!144802))
- [Update copy for trials/duo_pro/new](gitlab-org/gitlab@1fb2a8d3189d9c7b097a9684d14563fd46807220) ([merge request](gitlab-org/gitlab!145810)) **GitLab Enterprise Edition**
- [Add a link to the starrer's page on project stars in the CI/CD catalog](gitlab-org/gitlab@215ba918fad59d989c47b1cb4ca93e1796498b0c) by @antonkalmykov ([merge request](gitlab-org/gitlab!144781))
- [Expands adherence report group by dropdown](gitlab-org/gitlab@1e6a819972e5365c86f966bc01934d8f7302d350) ([merge request](gitlab-org/gitlab!144688)) **GitLab Enterprise Edition**
- [Update docs for security_approval_policies_limit application setting](gitlab-org/gitlab@247ef6ea819213983ad910d80cc443d7ef51c84f) ([merge request](gitlab-org/gitlab!146178))
- [Add safe rel attribute on links with target "_blank"](gitlab-org/gitlab@2e8037f5198072593a7c61148c8bc74b61c36cc7) ([merge request](gitlab-org/gitlab!145516))
- [Update MR sidebar reviewer status icons](gitlab-org/gitlab@de50202ed1aecc822791a6162f616bc00f303447) ([merge request](gitlab-org/gitlab!146237))
- [Expose policy_scope in policy graphql API](gitlab-org/gitlab@09e869ff19d792dbc8c4603e39af8a5b21e1a601) ([merge request](gitlab-org/gitlab!142248)) **GitLab Enterprise Edition**
- [Rename Google Artifact Registry integration](gitlab-org/gitlab@b5f665e86a79625852f29a2c66752cf2f7ff649e) ([merge request](gitlab-org/gitlab!145529)) **GitLab Enterprise Edition**
- [AI docs: explicitly mention use of HTTPS](gitlab-org/gitlab@006fe0e80023f3d354fa93865300a46484c44902) ([merge request](gitlab-org/gitlab!146194))
- [Default enable FF include_manual_to_pipeline_completion](gitlab-org/gitlab@b6d9b3e1626f5e8a27e674fb14f5ee1cc79f5e17) ([merge request](gitlab-org/gitlab!146100)) **GitLab Enterprise Edition**
- [Add image size recommendation to avatar settings](gitlab-org/gitlab@fd98b5647d244bb9ab0f8f81b486b137088a83f8) ([merge request](gitlab-org/gitlab!145418))
- [Allow adding an Organization to an User Namespace](gitlab-org/gitlab@65e4d11e147c09a70565993a1062cde1cfe23742) ([merge request](gitlab-org/gitlab!144049))
- [Allow /help to accept either page title in front matter or in Markdown](gitlab-org/gitlab@b13518baf1f74865bd811e9107d2dc0a7b55214e) ([merge request](gitlab-org/gitlab!145627))
- [Update scaler and overlay color on design detail](gitlab-org/gitlab@fc77cced42e59de58e4b29d753b0e4528d95e669) ([merge request](gitlab-org/gitlab!145153))
- [Link fast-forward Merge Requests to deployment](gitlab-org/gitlab@979a7f19da5834d6272bc2c94030ad37503c0a7f) ([merge request](gitlab-org/gitlab!145211))
- [Mark vulnerabilitiesRemoveAllFromProject mutation as stable](gitlab-org/gitlab@cd06c9a442a8340c4e4428381902fa75fed9ed0e) ([merge request](gitlab-org/gitlab!146125)) **GitLab Enterprise Edition**
- [Replace geo-replication-empty illustration](gitlab-org/gitlab@6e850f35e39c3547ab1528c0b0a40d2df75198a0) ([merge request](gitlab-org/gitlab!144665)) **GitLab Enterprise Edition**
- [This MR adds new properties for toggle_list](gitlab-org/gitlab@7f06af55b260c17627fe9794d5c77ac641caeccc) ([merge request](gitlab-org/gitlab!145548)) **GitLab Enterprise Edition**
- [Improve Google Cloud IAM integration UI text](gitlab-org/gitlab@2fdc58840c714e637caa4970871018799d1f7035) ([merge request](gitlab-org/gitlab!145535)) **GitLab Enterprise Edition**
- [Rollout zoekt_cache_search_responses feature](gitlab-org/gitlab@49d4a9163ba4a9e2b65ddfefc61c100532ce61b0) ([merge request](gitlab-org/gitlab!146085)) **GitLab Enterprise Edition**
- [This MR select all reset option](gitlab-org/gitlab@ade7828071bbd7f879a0948b6704f880b5215d5b) ([merge request](gitlab-org/gitlab!145874)) **GitLab Enterprise Edition**
- [Render project name with namespace in runner usage](gitlab-org/gitlab@8673d2b3d39c8de524920d18c548610f6775e5e7) ([merge request](gitlab-org/gitlab!145151)) **GitLab Enterprise Edition**
- [Design management - Move issue title](gitlab-org/gitlab@df0fec3009f0d89d0ff9cbb78e203936aa9ab02f) ([merge request](gitlab-org/gitlab!145878))
- [Change security pipeline execution policy stages strategy](gitlab-org/gitlab@8ac1d6f071f520f4329d76d9e6ee0e437d760cae) ([merge request](gitlab-org/gitlab!145136)) **GitLab Enterprise Edition**
- [Cleanup update_vuln_reads_traversal_ids_via_event FF](gitlab-org/gitlab@b073ad51ccb9470c4225457477f2279faa9c81cd) ([merge request](gitlab-org/gitlab!145430)) **GitLab Enterprise Edition**
- [Emphasize integration reset button](gitlab-org/gitlab@761185ebac73dceae5cc69c7f479e883a4f002c7) ([merge request](gitlab-org/gitlab!146045))
- [Activity feed: Make content better searchable](gitlab-org/gitlab@e408f410c069049f33bbe49255e295e858aeb4c6) ([merge request](gitlab-org/gitlab!145540))
- [Remove outdated illustrations](gitlab-org/gitlab@8b0acb8f862d8f13411bba5c26da7e32e72ceec8) ([merge request](gitlab-org/gitlab!146043))
- [Pipeline MiniGraph dropdown: Keep open when modifier is pressed](gitlab-org/gitlab@8920145ad81a08adc2a9693fdaec3d59643cedd4) ([merge request](gitlab-org/gitlab!146030))
- [Project/Group overview: Add settings link to kebab menu](gitlab-org/gitlab@57ebda215bbf27f2360a1b3a103cf38886bc969e) ([merge request](gitlab-org/gitlab!145239))
- [Add optional project labels to keep-around ref metrics](gitlab-org/gitlab@f54ae894c9f778a5a448312c49fe49b860d73ac9) ([merge request](gitlab-org/gitlab!145988))
- [Add option to keep shared groups when filtered by parent](gitlab-org/gitlab@d8e65143b0e464cfc0aa1a1d7c51250f331e48bc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/141462)) **GitLab Enterprise Edition**
- [Use pluralized string for Job/Jobs count label on jobs/pipelines page](gitlab-org/gitlab@46bce5fdcbda80cbd8c028a8e966de4152f848b5) by @antonkalmykov ([merge request](gitlab-org/gitlab!145731))
- [Make the date format consistently across the CI/CD Catalog](gitlab-org/gitlab@a6db118290802a2b0471362820ddd3a391668d57) by @antonkalmykov ([merge request](gitlab-org/gitlab!145729))
- [Redact SAMLResponse from logs](gitlab-org/gitlab@ec6757d64db8567ea0d486816067f62e489e8f7d) ([merge request](gitlab-org/gitlab!144732))
- [Darken light blue and green theme for contrast](gitlab-org/gitlab@cff5ca48903b919af5cbca744a4e25517e962617) ([merge request](gitlab-org/gitlab!145815))
- [Add illustration to Value Stream Analytics empty state](gitlab-org/gitlab@0225ddc22fd59537de8552bc354df8a622ad2722) ([merge request](gitlab-org/gitlab!145868))
- [Upgraded Web IDE to 0.0.1-dev-20240226152102](gitlab-org/gitlab@dac076d55d4c3e488080ef88deefd5cc12238d6d) ([merge request](gitlab-org/gitlab!145900))
- [Added namespace actor to PA billing feature flag](gitlab-org/gitlab@63b15bdab9aab6c041161adaf7fce4cc02942d52) ([merge request](gitlab-org/gitlab!145116)) **GitLab Enterprise Edition**
- [Update design management discussion as per new UX](gitlab-org/gitlab@b8ca254afd0ec5d357aecfdb894bf647c9c18d34) ([merge request](gitlab-org/gitlab!145011))
- [Add color_mode_id column to users table](gitlab-org/gitlab@2ff7f2616984e455fd00fa0e5d1f572874b7b77c) ([merge request](gitlab-org/gitlab!142772))
- [Allow /help to accept either index.md or _index.md as a docs index page](gitlab-org/gitlab@1be8d7c707febb07987558fce7e21efbcebf3c81) ([merge request](gitlab-org/gitlab!144419))
- [Update regex for normalize_pypi to align with](gitlab-org/gitlab@b191ad6ccf65e9756d646a301618b4c287c777f6) ([merge request](gitlab-org/gitlab!145393))
- [Cleanup free_user_cap_over_limit_email FF](gitlab-org/gitlab@6273551f112a258787c580fc6c39f9efd96b2fbe) ([merge request](gitlab-org/gitlab!145707)) **GitLab Enterprise Edition**
- [Add prefix to Operations::FeatureFlagsClient#token](gitlab-org/gitlab@0ef1fadd62b116373874995a179bdc1802f1cf00) by @jzeng88 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/144703))
- [Use skeleton loader for artifacts loading state](gitlab-org/gitlab@02b44144c0dc937aff74649c3e8c4ceaab1a6fcd) ([merge request](gitlab-org/gitlab!143218))
- [Additional cleanup for external usernames on oAuth and LDAP sign up](gitlab-org/gitlab@fdba060146a5952726d02d036eca8581ba6b022e) ([merge request](gitlab-org/gitlab!145038))
- [Design management - Move todo button](gitlab-org/gitlab@26a73723334f87e2fbe2035fb1109dad41fa446e) ([merge request](gitlab-org/gitlab!145736))
- [Update Cloud Connector architecture blueprint](gitlab-org/gitlab@95a9b949b67aaadaca04868a52555b73631b8cf8) ([merge request](gitlab-org/gitlab!145220))
- [Replace manual and failed pipeline illustrations](gitlab-org/gitlab@3bad95bb777af89f264056ade339033669125225) ([merge request](gitlab-org/gitlab!145650)) **GitLab Enterprise Edition**
- [Enable continuous container scanning by default](gitlab-org/gitlab@f85b3bd21829762f56d404ef9fdab7670e9554dd) ([merge request](gitlab-org/gitlab!145723)) **GitLab Enterprise Edition**
- [Default enable FF search_index_all_projects](gitlab-org/gitlab@9172ba05d3613e967a468d4956a4298c182bdb69) ([merge request](gitlab-org/gitlab!145300)) **GitLab Enterprise Edition**
- [Replace milestone promotion banner with alert](gitlab-org/gitlab@c323a81ed4440b319b965ee2dfda30dc49e3c735) ([merge request](gitlab-org/gitlab!138597))
- [Update Rails to 7.0.8.1](gitlab-org/gitlab@92c0c5192703bbfa5ebdf36e6c9853d9268061f4) ([merge request](gitlab-org/gitlab!145667))
- [Update GITLAB_PAGES_VERSION](gitlab-org/gitlab@8bf8b553560e18925368a152322eb6a652a720fa) ([merge request](gitlab-org/gitlab!145634))
- [Update version outdated text](gitlab-org/gitlab@5cc715a24c1aba10c53d1db07f4bdbf5ae3cdc2a) ([merge request](gitlab-org/gitlab!145445))
- [Add approval group rule get endpoint](gitlab-org/gitlab@85492b1c18760a01bb15e94dc8b7096b3efab99b) ([merge request](gitlab-org/gitlab!144170)) **GitLab Enterprise Edition**
- [Reword Project.services field deprecation](gitlab-org/gitlab@13cb32e1248fec2221e9b36163b8ccbb7d4d0dec) ([merge request](gitlab-org/gitlab!145615))
- [Beautify groups](gitlab-org/gitlab@4019e3877369357157babc316f03e64290e25768) ([merge request](gitlab-org/gitlab!144921))
- [Use helpPagePath to Render terraform module registry links](gitlab-org/gitlab@4773c0f603cb93eb174be4fa1bbd3e698968ee03) by @jzeng88 ([merge request](gitlab-org/gitlab!145055))
- [Remove $white color to improve dark mode](gitlab-org/gitlab@b49bdefbcf5108f116d800bc34be4c170ccbc9ec) ([merge request](gitlab-org/gitlab!145590))
- [Update dependency auto-deploy-image to v2.85.0](gitlab-org/gitlab@834c41c7014781adfe7df55b3bd1ae1d50471f52) ([merge request](gitlab-org/gitlab!145557))
- [Remove backtrace silencer for app dir](gitlab-org/gitlab@9c6c0e73615151400634b5736edc0ac22783d007) ([merge request](gitlab-org/gitlab!145084))
- [Open Deployments tab when no K8s integration set for Environment](gitlab-org/gitlab@7b7cfa054db6acfbb187285a04720b1d7495e881) ([merge request](gitlab-org/gitlab!145287))
- [Enable custom_webhook_template by default](gitlab-org/gitlab@40d60e40802723553aad8c11ad01d7d1c5866014) by @Taucher2003 ([merge request](gitlab-org/gitlab!145514))
- [Profile page: Increase spacing after profile avatar](gitlab-org/gitlab@2528c9a773e7950e8d099cff1dd09e9125cdca03) ([merge request](gitlab-org/gitlab!145487))
- [Clean up successful free_trial_registration_redesign experiment](gitlab-org/gitlab@578e07da6d39d24e6af01fd3a9ef144e62e1b721) ([merge request](gitlab-org/gitlab!145235)) **GitLab Enterprise Edition**
- [Remove feature flag and update docs](gitlab-org/gitlab@1bf2cb1e157a8d45a3cd699ebd24970e64de1704) ([merge request](gitlab-org/gitlab!145366))
- [Add ability to unsubscribe from design management notifications](gitlab-org/gitlab@bb1596a3594d06ff28345bb21122274c89afb9a0) ([merge request](gitlab-org/gitlab!144247))
- [Make sign in tabs fully Pajamas compliant](gitlab-org/gitlab@e7e211edc7a9baf0067d25b6719cc24379e9588b) ([merge request](gitlab-org/gitlab!145238))
- [Remove Gitlab.com check for ContainerRepository#size](gitlab-org/gitlab@b6659019f631d443da33907a2d6910174fbb8b5a) ([merge request](gitlab-org/gitlab!144917))
- [Add Search::Zoekt::Task](gitlab-org/gitlab@9e53a29fe3878b86a826493e7e32fb32b889df04) ([merge request](gitlab-org/gitlab!143063))
- [This MR extend compliance framework list](gitlab-org/gitlab@7d458862e69543ddd175c9541ac4fd25280c3bc9) ([merge request](gitlab-org/gitlab!145051)) **GitLab Enterprise Edition**
- [GCP WLIF script improvements](gitlab-org/gitlab@562e2bcaf6234a20e0de1196497abe7f11d44ad9) ([merge request](gitlab-org/gitlab!144818)) **GitLab Enterprise Edition**
- [Show more specific error messages](gitlab-org/gitlab@80fa7fe57c2e8021a2970f0077df27711e54fbf6) ([merge request](gitlab-org/gitlab!145140))
- [Add logos to JetBrains integrations](gitlab-org/gitlab@1f32dccc4cc2f9f84391ff902050a3d6d0e4164d) ([merge request](gitlab-org/gitlab!145149))
- [Update default bot comment text when approvals required](gitlab-org/gitlab@3aec41edf9d4de5c306254dc602ad1fa8ac00e2d) ([merge request](gitlab-org/gitlab!143717)) **GitLab Enterprise Edition**
- [Clean up encoding_logs_tree FF](gitlab-org/gitlab@dafd046609ee79dac9531ddf0b73f002da8e28a8) ([merge request](gitlab-org/gitlab!145242))
- [Update column title](gitlab-org/gitlab@410d00f738fa70a525e79486cc4d8dd59b5e7199) ([merge request](gitlab-org/gitlab!145079))
- [Renaming column type to category for external audit event destinations](gitlab-org/gitlab@1fc1ae33e39862feeb6c7f01489b863f874a5f87) ([merge request](gitlab-org/gitlab!144994)) **GitLab Enterprise Edition**
- [Add additional analytics dashboard user events](gitlab-org/gitlab@4d33a2150ead4078cdab85a6094483e47f4db41e) ([merge request](gitlab-org/gitlab!144850)) **GitLab Enterprise Edition**
- [Moves full stop out of "Learn More" link](gitlab-org/gitlab@cfd3fce24eadce307bc880020ef315e643f0e302) by @r2abreu ([merge request](gitlab-org/gitlab!145192))
- [Replace cluster_popover illustration](gitlab-org/gitlab@68fdc2a29ec09b6faa15d3238fa8eecfd242b852) ([merge request](gitlab-org/gitlab!145185))
- [Declare service_access_tokens table clusterwide](gitlab-org/gitlab@97aaf7ac774249a34f29c8e58637bd8303a35383) ([merge request](gitlab-org/gitlab!145157))
- [Fix emoji picker](gitlab-org/gitlab@d1faa6d12980f407d5d72eadb2de86e244f52b18) ([merge request](gitlab-org/gitlab!144977))
- [Design management - Update layout of image preview](gitlab-org/gitlab@675403ae0874b08a0af73302d292d04ad81d90b5) ([merge request](gitlab-org/gitlab!144550))
- [Update branch rules via global id](gitlab-org/gitlab@a730a2af6201b7757f66101a50fa3cdf53cfbcd7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/144632)) **GitLab Enterprise Edition**
- [Fix pull lfs files issue](gitlab-org/gitlab@f913a7709d370f68fb2681958b5f81f73c1947b0) by @chaomao ([merge request](gitlab-org/gitlab!145114)) **GitLab Enterprise Edition**
- [Use entity full_path for page title / breadcrumbs](gitlab-org/gitlab@90a8358de64ed3091a0cb93898c7a11909528796) ([merge request](gitlab-org/gitlab!145112))
- [Clarified work items FF naming](gitlab-org/gitlab@81c20d2c9d2276f4ac8a8edfed6dce9799a4f12d) ([merge request](gitlab-org/gitlab!144141))
- [Epic boards - Display Ancestors in sidebar when subepics are allowed](gitlab-org/gitlab@a99ae25fc7522b34373d826fc2241d1be995e7a3) ([merge request](gitlab-org/gitlab!145092)) **GitLab Enterprise Edition**
- [Backfill non-instance admins into the organization users table](gitlab-org/gitlab@f784aa8c573f918c3e9249540a2577c0f007653c) ([merge request](gitlab-org/gitlab!144674))
- [Switch repository backups to use manifests only](gitlab-org/gitlab@81871c9a1451cce33eb2e078c57d8bc7618502c7) ([merge request](gitlab-org/gitlab!144677))
- [Remove the Kubernetes overview section from the Environments page](gitlab-org/gitlab@c4c98e8e0d3696574978b09ab62fec770c480ee7) ([merge request](gitlab-org/gitlab!144799))
- [Implement BranchRules::UpdateService](gitlab-org/gitlab@d4289fcb5e12358c9f3f5969031d6dd655f70fec) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/144630))
- [Change route for /details to /failures with id](gitlab-org/gitlab@627d9b00ad48264b42b935698a8aa3e7ceccfce6) ([merge request](gitlab-org/gitlab!143904))
- [Add form validation for cube query generation input](gitlab-org/gitlab@6bd72dc87ef319444bc31429a14f5a5c8e1c4b81) ([merge request](gitlab-org/gitlab!144146)) **GitLab Enterprise Edition**
- [Update repositories analytics empty states](gitlab-org/gitlab@61fe290457749aa35d4afcd3d2149386b38aff0a) ([merge request](gitlab-org/gitlab!144794)) **GitLab Enterprise Edition**
- [Expand sidekiq queue_groups to default](gitlab-org/gitlab@658da0610c5b22b84f89452aec0441dc77819782) ([merge request](gitlab-org/gitlab!142577))
- [Change `vulnerabilities.finding_id` column to NOT NULL](gitlab-org/gitlab@34772c2ca6742c08b059bb93b9367d3a8c195695) ([merge request](gitlab-org/gitlab!140989)) **GitLab Enterprise Edition**
- [Pipeline MiniGraph: Migrate dropdown to GlDisclosureDropdown](gitlab-org/gitlab@677bf84e6da0b3c6044bcaac0d849fbe21b85d17) ([merge request](gitlab-org/gitlab!144606))
- [Changed Terraform Modules history wording](gitlab-org/gitlab@d333bad70a2fa12fabf667c833ff0c7c94f4d00d) by @jzeng88 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/144945))
- [Fix bitbucket spread cal job](gitlab-org/gitlab@aeb47d1fb039c758ba36ffe4d0a2f93b1a149076) by @imskr ([merge request](gitlab-org/gitlab!143815))
- [Update dependency auto-deploy-image to v2.83.0](gitlab-org/gitlab@a0959e69590f3d7e507943f58cc48caa58c00058) ([merge request](gitlab-org/gitlab!144826))
- [Refactor compliance frameworks export backend](gitlab-org/gitlab@d08f0385ab3700c3a7db80664e7fd791bf9522c0) ([merge request](gitlab-org/gitlab!144915)) **GitLab Enterprise Edition**
- [Fix blurry avatar in profile](gitlab-org/gitlab@3c2337946dcbac75603a9475f899e072b23e4dbd) ([merge request](gitlab-org/gitlab!144448))
- [Clean up promote_ultimate_features experiment](gitlab-org/gitlab@872f590928af5451e6902a71d334b8c2b4a5bd4a) ([merge request](gitlab-org/gitlab!144513)) **GitLab Enterprise Edition**
- [Now allowing expired trials to see Trial Discover Page](gitlab-org/gitlab@fb0118da47716650afdc5d0dfce06a7987c4a3e8) ([merge request](gitlab-org/gitlab!144904)) **GitLab Enterprise Edition**
- [Route projects by root namespace id](gitlab-org/gitlab@6583846f71e2d30434058c0cf7bb1ec84f68ea08) ([merge request](gitlab-org/gitlab!143212)) **GitLab Enterprise Edition**
- [Open "Create Slack app" link in new tab](gitlab-org/gitlab@9cf51675f38552e621e6432fdf37f8768e7e41fe) ([merge request](gitlab-org/gitlab!144885))
- [api/runners: Expose `maintenance_note` in details and editing](gitlab-org/gitlab@7b1af91226ba2ce3f6db523f3fcc0254592b32e1) ([merge request](gitlab-org/gitlab!144482))
- [Code dropdown: Migrate to GlDisclosureDropdown](gitlab-org/gitlab@9ab2803420becc67589be5979439e6aaa469bf80) ([merge request](gitlab-org/gitlab!143324))
- [User profile: Show 7 achievements instead of 3](gitlab-org/gitlab@653d2949f79e40d77908a57b669a3ce67272e1cd) ([merge request](gitlab-org/gitlab!144453))
- [Reorders work item sidebar widgets](gitlab-org/gitlab@040e80bce5db879fca047e64d87125c1afd041ba) ([merge request](gitlab-org/gitlab!143707))
- [Adjust environment and sync status badges on environments page](gitlab-org/gitlab@2cda9c5802a9d3787c553f0d82ebe2dcf55c3c8d) by @antonkalmykov ([merge request](gitlab-org/gitlab!144486))
- [Use color for protected/default branches/tags (#439551)](gitlab-org/gitlab@9db61fa943bb55622860f78e25b7a0253425e45c) by @abh80 ([merge request](gitlab-org/gitlab!143398))
- [Use createdAt instead of releasedAt](gitlab-org/gitlab@cea397f6460ea5acd8369db9d3b8c27f6039d1a4) ([merge request](gitlab-org/gitlab!144789))
- [Update cube query generation UI](gitlab-org/gitlab@969ea9d1c16df9993158cd99f44477fe777d79c4) ([merge request](gitlab-org/gitlab!144148)) **GitLab Enterprise Edition**
- [Update sha method depending of release presence](gitlab-org/gitlab@7c3a7cdb23417751176cef593d7dd6d955558e69) ([merge request](gitlab-org/gitlab!144175))
- [Fixing rubocop exceptions in tests](gitlab-org/gitlab@3695ddb1f7399d32d919c2ca9508787905c5d388) ([merge request](gitlab-org/gitlab!144589))
- [Rename "Runner" header to "Runner configuration"](gitlab-org/gitlab@1a26aaa3f15259890741215076e3ce7dc8a36291) ([merge request](gitlab-org/gitlab!144216))
- [workhorse: Downgrade incomplete multipart uploads to 400 errors](gitlab-org/gitlab@f85f72255c9bd8d9d3f63a1aa3f2ceae495d0546) ([merge request](gitlab-org/gitlab!144710))
- [Remove redundant "runner statuses" popover in the runners list](gitlab-org/gitlab@7ef740fca0b92292b062bc9922a581b8df7a5d98) ([merge request](gitlab-org/gitlab!144343))
- [Sort personal projects on profile page by last_activity_at](gitlab-org/gitlab@eea414d5709cb8d25bc94ab80c96892ce9596ed6) ([merge request](gitlab-org/gitlab!144309))
- [Unify collapse\expand all unresolved threads action](gitlab-org/gitlab@04143ecfedde8b70727874f1e5175650df527616) ([merge request](gitlab-org/gitlab!136034))
- [Improve environments dashboard](gitlab-org/gitlab@3fb0db611b5faa615565d5cd9a839a33fac06a88) ([merge request](gitlab-org/gitlab!142747))
- [Enable `group_level_dependencies_filtering` by default](gitlab-org/gitlab@0b43ebd13a7afc20b94b546e14e8e05fd10de0b0) ([merge request](gitlab-org/gitlab!144668)) **GitLab Enterprise Edition**
- [Abbreviate long numbers in groups/projects list](gitlab-org/gitlab@8f5bdcbf015eb459418e341a56a27a4e892be1cf) ([merge request](gitlab-org/gitlab!144074))
- [Remove namespace validation for policy_scope](gitlab-org/gitlab@e29824a6b9a36a93f5ed0b8b2364a5671548292f) ([merge request](gitlab-org/gitlab!144491)) **GitLab Enterprise Edition**
- [Allow only top level groups for ApprovalGroupRules](gitlab-org/gitlab@e7928dc11522850791e753ca152ffe8255c29581) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/144438)) **GitLab Enterprise Edition**
- [Dashboard: Use SingleStatComponent](gitlab-org/gitlab@ea8bcef820ac357c3766399ff076ed8a0e9af0d3) ([merge request](gitlab-org/gitlab!144447)) **GitLab Enterprise Edition**
- [Update redis-client to v0.20.0](gitlab-org/gitlab@099eb093032b3bfc1b8a59eb5eef0df2156e7bca) ([merge request](gitlab-org/gitlab!144620))
- [Use less ambiguous parameter names in CI lint API](gitlab-org/gitlab@043bc732c46c9453b52913fc2a824ede7e6aaf4e) ([merge request](gitlab-org/gitlab!143098))
- [Use Duo Chat for explain code feature](gitlab-org/gitlab@fe321c6b1c7c772f3f9079b6eedc51e6626c1afb) ([merge request](gitlab-org/gitlab!143217)) **GitLab Enterprise Edition**
- [Add tabs to Environment details page](gitlab-org/gitlab@6c021229c55cdf45c7787a59b139760e94a1397c) ([merge request](gitlab-org/gitlab!143865))
- [Truncate long dashboard descriptions on list page](gitlab-org/gitlab@8e4729ce031acfb431b039df5f84e720407a3155) ([merge request](gitlab-org/gitlab!144274)) **GitLab Enterprise Edition**
- [Populate topics slug column from name column](gitlab-org/gitlab@188e2c64cc2e4e4cc411783da74f64d70bfb7ce7) by @zzaakiirr ([merge request](gitlab-org/gitlab!141715))
- [Update layout and styling of billing/plan_component](gitlab-org/gitlab@7e3be144f84dfca7d2480a8faf2b174402d28902) ([merge request](gitlab-org/gitlab!142939)) **GitLab Enterprise Edition**
- [Update milestone banner illustration](gitlab-org/gitlab@b30970c3e092985a04bd66969fd16667dab25c1b) ([merge request](gitlab-org/gitlab!144044)) **GitLab Enterprise Edition**
- [Update alert settings tests](gitlab-org/gitlab@4dcfd3d40db22f6b416ee7d934eb181fd4085f35) ([merge request](gitlab-org/gitlab!144547))
- [Move color widget update to a callback](gitlab-org/gitlab@fb7759bfb3d57adf248e8c58a6446727c72b8b34) ([merge request](gitlab-org/gitlab!142335)) **GitLab Enterprise Edition**
- [Only allow group approval rules to be created by group admins](gitlab-org/gitlab@41196db8017bfc191ae11fdfd1b0eed2eeb78428) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/144452)) **GitLab Enterprise Edition**
- [MR approval widget: Fix alignment](gitlab-org/gitlab@eb905a344ea9e7db5fce3d48756739bc2801a148) ([merge request](gitlab-org/gitlab!144465))
- [MR ready message: Fix alignments](gitlab-org/gitlab@ae428ea4f4c01475082013914b506a359a2a1b2f) ([merge request](gitlab-org/gitlab!144462))
- [Update UI text with purchasing instructions](gitlab-org/gitlab@f8a14f17473f072b95e7a5b49ae06b99505e8318) ([merge request](gitlab-org/gitlab!144275)) **GitLab Enterprise Edition**
- [Migrate todos empty state component](gitlab-org/gitlab@1f0909949255acc5404ee3d0c2a139d31ca70e90) ([merge request](gitlab-org/gitlab!144083))
- [Migrate applications empty state component](gitlab-org/gitlab@bf351b1f3a0d9585e2d8ab763b3f51a67f2318cc) ([merge request](gitlab-org/gitlab!144069))

### Removed (24 changes)

- [Remove auto fix worker with migration](gitlab-org/gitlab@ed2b69bdf691791ef760b63889adf832bd609025) ([merge request](gitlab-org/gitlab!147051))
- [Remove issues_completed_analytics_feature_flag FF](gitlab-org/gitlab@d8e43c2d9945088cbb3392f1cf6765dfafd75569) ([merge request](gitlab-org/gitlab!146766))
- [Remove unused EOA bronze banner code and feature flag](gitlab-org/gitlab@0706b210dbac418f5243b7003d51b4d4c674c7e2) ([merge request](gitlab-org/gitlab!146309))
- [Remove use_primary_for_update_computations FF](gitlab-org/gitlab@c5b800f6712e0427e54a84542ad51024a94f96c1) ([merge request](gitlab-org/gitlab!146287))
- [Remove ci_catalog_components_tab](gitlab-org/gitlab@094eff85500582bd06f300ed0010542b93e13366) ([merge request](gitlab-org/gitlab!146224))
- [Remove obsolete logic behind a feature flag](gitlab-org/gitlab@91941eb9bae3996aad91b019b4f54a1101b7fc9a) ([merge request](gitlab-org/gitlab!146188))
- [Drop `third_party_ai_features_enabled` column](gitlab-org/gitlab@6622480255721cf65cc381fbb8c1a219f1138817) ([merge request](gitlab-org/gitlab!145210))
- [Remove delayed project/group columns](gitlab-org/gitlab@d8fcdb1c1e58f15ca522ceb7f6fda91dade2676c) by @imskr ([merge request](gitlab-org/gitlab!144347))
- [Geo DB migrations to remove force_to_redownload column from 5 tables](gitlab-org/gitlab@e35e9f05db2e24e3607aafa2affafb70072061f3) ([merge request](gitlab-org/gitlab!144824)) **GitLab Enterprise Edition**
- [Drop temporary index on vulnerabilities table](gitlab-org/gitlab@35a3978a5664f26ae22b4707f4ffcd3c9bc3f8c6) ([merge request](gitlab-org/gitlab!143338))
- [Drop project_repository_states table](gitlab-org/gitlab@f36ef30b0a65efc88a2157612e89df587e4bcb36) ([merge request](gitlab-org/gitlab!145195))
- [Remove build hooks worker and associated code](gitlab-org/gitlab@543286bcf0a5f48a8576ecd6900f8a3735583337) by @Varedis ([merge request](gitlab-org/gitlab!144965))
- [Remove old finding modal from MR security widget](gitlab-org/gitlab@889c831d5400dc9a24dc3d8d89a4a8d34aa678d4) ([merge request](gitlab-org/gitlab!144341)) **GitLab Enterprise Edition**
- [Remove deprecated /code_suggestions/tokens endpoint](gitlab-org/gitlab@2e6e1b2a4b094678605556ec5d2a75108ca087ce) ([merge request](gitlab-org/gitlab!145052)) **GitLab Enterprise Edition**
- [Remove the user_interacted_projects table](gitlab-org/gitlab@8a280cc82aac0bc2e1db8880afe78a6b2ee7b51e) by @missy-davies ([merge request](gitlab-org/gitlab!139630))
- [Remove license_compliance_widget_category feature flag](gitlab-org/gitlab@7f9371979d149406a9fa1c0926101de11b6a1730) ([merge request](gitlab-org/gitlab!144989))
- [Remove upload_ready from pages deployment](gitlab-org/gitlab@b377d57acc7546240614be2b49b850bd2914ca31) by @imskr ([merge request](gitlab-org/gitlab!144962))
- [Removing feature flag audit_events_streaming_namespace_filter](gitlab-org/gitlab@5771e1e6a0567a33f03024c0c650a9fd35349388) ([merge request](gitlab-org/gitlab!144043)) **GitLab Enterprise Edition**
- [refactor: Drop col 'package_name_pattern_ilike_query' Part 2](gitlab-org/gitlab@3ba3e9b1ad96291295e0f88e42fc5973682ba6ae) by @gerardo-navarro ([merge request](gitlab-org/gitlab!142303))
- [Remove deprecated BulkImports::StuckImportWorker](gitlab-org/gitlab@122b73c8668fed51502fd3fef0629d69186709d3) ([merge request](gitlab-org/gitlab!143806))
- [Drop product_analytics_events_experimental table](gitlab-org/gitlab@93093d2bf1f30059421fe181b54e1d06c7ead8f4) ([merge request](gitlab-org/gitlab!144626))
- [Remove ci_guard_for_catalog_resources ff](gitlab-org/gitlab@c78d549c9134e3ad881b9a1b188f0ed7f58ee155) ([merge request](gitlab-org/gitlab!144583))
- [Delete the usage_data_api feature flag](gitlab-org/gitlab@b9376c3aa14676463d0d82c3807ade22b966f7bb) ([merge request](gitlab-org/gitlab!143973))
- [Clean up SafelyChangeColumnDefault for CI models](gitlab-org/gitlab@f8c38e13fb26516855a3efc35de195e55962af11) by @imskr ([merge request](gitlab-org/gitlab!143058))

### Security (15 changes)

- [Filter SAML saml_response](gitlab-org/gitlab@010d0a2266d27c6a53ccbbb008fb8fd9bba6f95b) ([merge request](gitlab-org/gitlab!146454))
- [Add client-side detection for GitLab tokens](gitlab-org/gitlab@74f56ea7291084db2cb54dd0335adfbdbac5c749) ([merge request](gitlab-org/gitlab!146757))
- [Reset approvals when reopening a MR](gitlab-org/gitlab@8ba5fe64e3d3b62fc8acbecbd2dd99df5694a8c7)
- [Restrict group token rotation for custom roles](gitlab-org/gitlab@18abfbc075083ec0921d47056c185f01478eaf0c)
- [Update rack to v2.2.8.1](gitlab-org/gitlab@4df84ee731b04079ccad24fb8327e0107abcb0eb) ([merge request](gitlab-org/gitlab!145473))
- [Ensure LDAP user cannot sign in with password](gitlab-org/gitlab@98fd29b8beb2d72adbb194f424eddbdd591a7e8d)
- [Invalidate markdown cache to clear up stored XSS](gitlab-org/gitlab@adec203de57cd370ee9985607919a3e48bc808d1)
- [Ensure LDAP users cannot reset local password to bypass LDAP](gitlab-org/gitlab@7a15c7669cbb8dc6bbd83ea0440b83fc9c8c7ca4)
- [Add a limit to CodeOwners reference extractor regex](gitlab-org/gitlab@17b51afe3c586b73d3933d93352ac722db6c2510)
- [Adds authorization for analytics settings](gitlab-org/gitlab@eaff749ab0ff501f1eae69ef7f3d5a141c02924c)
- [Fix Stored-XSS in user's profile page: Change markup used for pronouns](gitlab-org/gitlab@3672795fc9a3f5e4768320a53cad40d209afe3da)
- [Check project read access in Environments and Operations dashboard](gitlab-org/gitlab@b1a317f836d862f6c0872a3889a36285216f8482)
- [Disallow assigning higher role than current user](gitlab-org/gitlab@87273243752ebef58fda6bfdcb2be685e7318200)
- [Disallow users to modify deploy key title](gitlab-org/gitlab@200f3fe6905bb48dfd4517d98461ad935ec702c2)
- [Use merge_head_diff for codeowners when merge request is mergeable](gitlab-org/gitlab@7457a15973e913719461c0630d27c34b1dfae368)

### Performance (16 changes)

- [Use the AvatarCache for commits/events](gitlab-org/gitlab@581403c153acbdc1d1e322cd29d65d5b892e27cf) ([merge request](gitlab-org/gitlab!144739))
- [Reduce N+1 queries when approvals by committers are not allowed](gitlab-org/gitlab@9e7ef142b35f44ae5d559be9411e7047b148de8f) ([merge request](gitlab-org/gitlab!146297)) **GitLab Enterprise Edition**
- [Fix N+1 problems in Groups API](gitlab-org/gitlab@b34d6d8baa9f1702c3ba65324dfefa59059319ef) ([merge request](gitlab-org/gitlab!145906)) **GitLab Enterprise Edition**
- [refactor: Debounce GET requests for notes after submitting MR review](gitlab-org/gitlab@624ee38a5be85050c3b25f5521f2d48b6e572dd4) by @gerardo-navarro ([merge request](gitlab-org/gitlab!145177))
- [RegisterJobService will use partition pruning](gitlab-org/gitlab@ce908573c8a06bb242703bacf8148a72410f2d8d) ([merge request](gitlab-org/gitlab!145861))
- [Enable ci_parallel_remote_includes feature flag](gitlab-org/gitlab@fb8c2c6f5e500012cbea05e9af0912f68c870cf8) ([merge request](gitlab-org/gitlab!145784))
- [Remove duplicated indexes for source code](gitlab-org/gitlab@927cdb8b48303e59b64c576960393b998c0bb50d) ([merge request](gitlab-org/gitlab!145534))
- [Remove FF reading p_ci_pipeline_variables](gitlab-org/gitlab@383397e44a6a5f583bab1cfc4e8c6296c5f73991) ([merge request](gitlab-org/gitlab!145374))
- [Reduce N+1 queries when approvals by committers are not allowed](gitlab-org/gitlab@dcf09018965e1c356a8680fa77bedbcfbd9e1685) ([merge request](gitlab-org/gitlab!144860)) **GitLab Enterprise Edition**
- [Reduce N+1 queries when MRs has blocking MRs](gitlab-org/gitlab@ff912fd563fb49120ad8f9b061cc937228bea272) ([merge request](gitlab-org/gitlab!144944)) **GitLab Enterprise Edition**
- [Skip status preloads in pipeline lists](gitlab-org/gitlab@0a426914445e111a1243aff912e058f3801c860c) ([merge request](gitlab-org/gitlab!144783))
- [Cache private email regex for a request](gitlab-org/gitlab@46489a0f94596510475fe302fef714c43db15555) ([merge request](gitlab-org/gitlab!144644))
- [Remove unused index on ci_pipeline_metadata](gitlab-org/gitlab@bbb4eb3f5f65a30c6bfec7a4addf8cc6771c9dcf) ([merge request](gitlab-org/gitlab!140608))
- [Stop calculating if blob is binary on creation](gitlab-org/gitlab@df1a89383d09669270f1f98d5f13571124cb92a0) ([merge request](gitlab-org/gitlab!144115))
- [Removing FF track_ci_build_created_internal_event](gitlab-org/gitlab@1cba51150c772c0a6e07b471db6056a91f875c15) ([merge request](gitlab-org/gitlab!144091))
- [Preload downstream pipelines when serializing bridge jobs](gitlab-org/gitlab@45883cb4df3a2a62ab5e90f0f4c0917d7043c3f6) ([merge request](gitlab-org/gitlab!143546))

### Other (120 changes)

- [Remove `compliance_framework_report_ui` feature flag](gitlab-org/gitlab@f613bc6d34c2d06c027b0ea9b423cfebed5c69cf) ([merge request](gitlab-org/gitlab!147042)) **GitLab Enterprise Edition**
- [refactor: Fix typo in code](gitlab-org/gitlab@696d38721bccfe93cb6fbfc4dad106291ab940b5) by @gerardo-navarro ([merge request](gitlab-org/gitlab!147081))
- [Revert "Merge branch..."](gitlab-org/gitlab@07745e093497fc85d43387112cd0decee98d975f) ([merge request](gitlab-org/gitlab!147061))
- [Update job_artifacts queries to use partition_id filter](gitlab-org/gitlab@3699e9824f98e9b462553413595848dadf8a4286) ([merge request](gitlab-org/gitlab!145522))
- [Fix Workhorse linter warnings](gitlab-org/gitlab@a7d7e7d52cca84a836d6d986189f982f7fe4de95) ([merge request](gitlab-org/gitlab!146871))
- [Revert changes to import stages](gitlab-org/gitlab@fe80668eb8b0ec3d57fb32891ddd204b1951b65c) ([merge request](gitlab-org/gitlab!146812))
- [Migrate table to gl-table](gitlab-org/gitlab@26bc530f6ea4685f515e5808392f697e65d2728e) by @hsbhangu ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/145618)) **GitLab Enterprise Edition**
- [Enables lock_retries by default in migrations](gitlab-org/gitlab@65ad9d77344fee470c4f8f39344df805888df518) ([merge request](gitlab-org/gitlab!135808))
- [Add cell local schema](gitlab-org/gitlab@631e338e7f169493f0236a3d1e29bb677b8dd0d3) ([merge request](gitlab-org/gitlab!146496))
- [refactor: Fix rubocop todos for maven package files](gitlab-org/gitlab@d1f395b6288fb3655849b9bbade03729aa3e23ee) by @gerardo-navarro ([merge request](gitlab-org/gitlab!145951))
- [Add missing sharding keys](gitlab-org/gitlab@121941b96e717d4a29a10b9bff1868345d473370) ([merge request](gitlab-org/gitlab!146607))
- [Clean up tmp FKs p_ci_stages](gitlab-org/gitlab@9fc2f3468fb97ca2714c39a21ec6c847d9403c0d) ([merge request](gitlab-org/gitlab!146598))
- [Add and validate FKs to p_ci_stages](gitlab-org/gitlab@0a63fc972c8ce42a02e90ad21421a021b04f1a80) ([merge request](gitlab-org/gitlab!146459))
- [Protected packages: Show alert message on fetching error](gitlab-org/gitlab@4aea495dcf70ab58860d5fd8e1d6af5306ac8bfb) by @gerardo-navarro ([merge request](gitlab-org/gitlab!146473))
- [Clean up current_organization_middleware feature flag](gitlab-org/gitlab@8e9aecabb2ddedfec3695b1b08a58370a7d8103b) ([merge request](gitlab-org/gitlab!146527))
- [Validate uniqnuess of member role name](gitlab-org/gitlab@4af14e2cd1b78a7ac1fb72c93d29669b0a29c298) ([merge request](gitlab-org/gitlab!145294))
- [chore: Remove sidekiq_job_completion_metric_initialize feature flag](gitlab-org/gitlab@0ae3e714c0a3620460e463fb1b71f43f80027554) ([merge request](gitlab-org/gitlab!146497))
- [Improve handling group_path param](gitlab-org/gitlab@b04c7baf3c1100ef13a5df1d3d230e53ccc35442) ([merge request](gitlab-org/gitlab!145511))
- [Remove `security_findings_finder_lateral_join` FF](gitlab-org/gitlab@575962a50408eed8434414abaa5c4d24a9fc4381) ([merge request](gitlab-org/gitlab!145754)) **GitLab Enterprise Edition**
- [refactor: Fix rubocop issues in Pypi::CreatePackageService](gitlab-org/gitlab@726376b6dd7ddf062cb82bd9bbde35eb02c4605e) by @gerardo-navarro ([merge request](gitlab-org/gitlab!146403))
- [Remove cron schedule for removed job](gitlab-org/gitlab@60525d4cc87554e7c0c456c6abd2c3d1202c919f) ([merge request](gitlab-org/gitlab!145938))
- [Protected packages: Return ServiceResponse for CreateMavenPackageService](gitlab-org/gitlab@951bc970ce553709d02cf81caada5a6b3cc51253) by @gerardo-navarro ([merge request](gitlab-org/gitlab!145076))
- [Remove assign_compliance_project_service feature flag](gitlab-org/gitlab@212283a3a27ee58c0ff2ffc6a47e2325403044c8) ([merge request](gitlab-org/gitlab!146331)) **GitLab Enterprise Edition**
- [Add cluster wide schema](gitlab-org/gitlab@206a512b463161dc5f5e274563a6809bf0e10aeb) ([merge request](gitlab-org/gitlab!146345))
- [Remove resolve_organization_groups feature flag](gitlab-org/gitlab@863cfe276028e69d9f88007967e777d1b29a743f) ([merge request](gitlab-org/gitlab!146320))
- [Backup and remove orphaned notes](gitlab-org/gitlab@ffcb25747f5794aaec5f64bfd89c92c3727d4f15) ([merge request](gitlab-org/gitlab!146023))
- [Backfill onboarding_status_step_url from orginal column](gitlab-org/gitlab@2ad007b5c1af1a973603f45a7219b3cc964426f1) ([merge request](gitlab-org/gitlab!145041))
- [Remove project_path_sort feature flag](gitlab-org/gitlab@0fbb3b34f341c0a22b9e182e3a06d5ae26de3157) ([merge request](gitlab-org/gitlab!146179))
- [Add sharding keys for application_instrumentation](gitlab-org/gitlab@756debd91cb6298d779ae308cfcc790eb19c468c) ([merge request](gitlab-org/gitlab!143308))
- [refactor: Fix rubocop issues for Npm::CreatePackageService](gitlab-org/gitlab@d2f2ef494f0822c0efb0e2fc62c5fdd81822543c) by @gerardo-navarro ([merge request](gitlab-org/gitlab!146098))
- [Use defined table header across the module](gitlab-org/gitlab@54781db8307169aaa0e5627fd675f9c991841e2e) ([merge request](gitlab-org/gitlab!145412)) **GitLab Enterprise Edition**
- [Replace FKs for p_ci_stages](gitlab-org/gitlab@f07c52a3db3199d3ae36542dab25d47615e367e3) ([merge request](gitlab-org/gitlab!145899))
- [Add database transaction duration to logs](gitlab-org/gitlab@c80306a326e55b131b919f7bac80bc3ba0bdf72a) ([merge request](gitlab-org/gitlab!145775))
- [Add cell scope with sharding key](gitlab-org/gitlab@a8dfef77479f503b243b288d4ae1468aa7150bd6) ([merge request](gitlab-org/gitlab!146039))
- [Add next desired sharding keys for dynamic_application_security_testing](gitlab-org/gitlab@966fbc0df2ba1b892fdcda464d644675f163165f) ([merge request](gitlab-org/gitlab!145249))
- [Add next desired sharding keys for code_review_workflow](gitlab-org/gitlab@b0c6247a455f8bbb46e95aa7aecab8562b9bf6f2) ([merge request](gitlab-org/gitlab!146029))
- [Update schemas and shared keys for source_code_management](gitlab-org/gitlab@dce38caea6e92d926c7640c7bb240dca5bd35be8) ([merge request](gitlab-org/gitlab!144014))
- [Use data-testid instead of js- class for project approvals](gitlab-org/gitlab@746490b79cd9c9ba299eb5c47dadf67f1c9f99d8) ([merge request](gitlab-org/gitlab!145236)) **GitLab Enterprise Edition**
- [Remove geo_proxy_check_pipeline_refs feature flag](gitlab-org/gitlab@92929c83dcd47dc2980d8c35fca7c7d7a5dd0dfb) ([merge request](gitlab-org/gitlab!145864)) **GitLab Enterprise Edition**
- [Add visibility_level to organizations](gitlab-org/gitlab@edd4f2c77d8e8edec18a9d2fdc1580715dd2a307) ([merge request](gitlab-org/gitlab!145606))
- [Migrate search empty states and update banner illustration](gitlab-org/gitlab@fe7193e9efc74e00e893b667b4c4647da7eedb43) ([merge request](gitlab-org/gitlab!145191))
- [Add self-managed migration](gitlab-org/gitlab@32ba10481eb050b79504d805e18fa75cffec1619) ([merge request](gitlab-org/gitlab!144953))
- [Add cluster_wide schema to add_ons](gitlab-org/gitlab@064e0550359b5cfcbaa185c4278f32df843488f3) ([merge request](gitlab-org/gitlab!145824))
- [Update remote mirror failure email](gitlab-org/gitlab@c6b5161e6e268ae49708537899f2d11b54461627) ([merge request](gitlab-org/gitlab!145808))
- [Change gitlab_schema for user_credit_card_validations](gitlab-org/gitlab@e82cebd9b483d332f539276808c24753dc98a48f) ([merge request](gitlab-org/gitlab!145426))
- [Add clusterwide schema](gitlab-org/gitlab@2f7151569970d3cc244051219b338ff1c861cd3e) ([merge request](gitlab-org/gitlab!145673))
- [Ensure ID uniqueness on p_ci_stages](gitlab-org/gitlab@13af4ccec70624cf816ee682df8f3f38db9b5cf3) ([merge request](gitlab-org/gitlab!145778))
- [Enforce not-null constraint vs_code_settings uuid](gitlab-org/gitlab@040e9503ad3e79c2378b1873eed894be9c2f57c5) ([merge request](gitlab-org/gitlab!145427))
- [Remove identity_verification_auto_ban feature flag](gitlab-org/gitlab@806a5188e05f82c746eb79390422acc0cc580ead) ([merge request](gitlab-org/gitlab!145781)) **GitLab Enterprise Edition**
- [Making a quick action spec rely less on the frontend](gitlab-org/gitlab@48ec55748fad7eb0084a2b894fd0dbadefb4d969) ([merge request](gitlab-org/gitlab!142236))
- [Update Transfer Data project blueprint with new Clickhouse fields](gitlab-org/gitlab@7217f644fbe19cac2d6429df626d6ad344ee40a2) ([merge request](gitlab-org/gitlab!145675))
- [Allowing cross db transactions and joins between clusterwide and main](gitlab-org/gitlab@d292da30656bb010d26d3b0da102f22b6886fb59) ([merge request](gitlab-org/gitlab!145669))
- [Add and backfill project_id for cluster_agent_tokens](gitlab-org/gitlab@485282ac8e4289f116c3fc77efee8b6850bd9968) ([merge request](gitlab-org/gitlab!144939))
- [Delete service_desk_vue_list feature flag](gitlab-org/gitlab@58efa1d0f78a48371a2378d269d12651471d87db) ([merge request](gitlab-org/gitlab!144782))
- [Remove cron schedule for removed job](gitlab-org/gitlab@e8b6e3c14032385defacd72255aba1114221e4fd) ([merge request](gitlab-org/gitlab!145633))
- [Create routing table for ci_stages](gitlab-org/gitlab@ba2318027315fd2cddcbc014e3c6ed5941c8a0d8) ([merge request](gitlab-org/gitlab!145217))
- [Remove cron schedule for removed job](gitlab-org/gitlab@69ee1ebf4ca5fc26347ea6e339e2d95f5ad90dc7) ([merge request](gitlab-org/gitlab!145248))
- [Fix secret config validation](gitlab-org/gitlab@3b20dc278580bfe138d461daad0582131b948763) by @alberts-gitlab ([merge request](gitlab-org/gitlab!145490))
- [Remove arkose_labs_oauth_signup_challenge feature flag](gitlab-org/gitlab@792f0612de2e77d81a0e16f4bc3da608cba7e915) ([merge request](gitlab-org/gitlab!145225)) **GitLab Enterprise Edition**
- [Allow to persist Clickhouse state](gitlab-org/gitlab@5c814099985ff577f48a597059f64e4d67df5174) ([merge request](gitlab-org/gitlab!144918))
- [Remove `sync_project_archival_status_to_sbom_occurrences` feature flag](gitlab-org/gitlab@107d31db9b8595f97f64c4908ab46e55309b6fc7) ([merge request](gitlab-org/gitlab!145419)) **GitLab Enterprise Edition**
- [Introduce empty_tree_id to correctly work with SHA256 repository](gitlab-org/gitlab@bfab8988d9cf7712dc8e6b6b217bb7c04dc21efe) ([merge request](gitlab-org/gitlab!144494))
- [Refactor planning component currency symbol](gitlab-org/gitlab@c675d2173a23bbfbb5883ef686e7fd833190e1f4) by @chaomao ([merge request](gitlab-org/gitlab!145378)) **GitLab Enterprise Edition**
- [Remove `group_level_dependencies_filtering` feature flag](gitlab-org/gitlab@500892480ccf798e07654b86e64b57b46902b35c) ([merge request](gitlab-org/gitlab!144672)) **GitLab Enterprise Edition**
- [test: Fix wrong param for shared example 'error service response'](gitlab-org/gitlab@9103ced153fa5c901deae045c14b5451ed5957d4) by @gerardo-navarro ([merge request](gitlab-org/gitlab!145134))
- [Clean up tmp FKs p_ci_job_artifacts](gitlab-org/gitlab@e97208ffe95e4d29619061623b39177290cf32a2) ([merge request](gitlab-org/gitlab!145216))
- [Remove enable_new_sentry_clientside_integration](gitlab-org/gitlab@c54585488ccd84b2e0a738e41fea5c69a7068f5c) ([merge request](gitlab-org/gitlab!145276))
- [Add ClusterRepositoryCache class for migration](gitlab-org/gitlab@147ddbd512dc9e2ec5686e4d16bcd8168bebb242) ([merge request](gitlab-org/gitlab!144548))
- [Finalize backfill vs_code_settings column migrations](gitlab-org/gitlab@46a38c5d8ce1bf0a2d18d310ac94d10d5beab2de) ([merge request](gitlab-org/gitlab!145138))
- [Remove arkose_labs_trial_signup_challenge feature flag](gitlab-org/gitlab@1df16b97529aa3f0b0f0e2b86c11818e86af32cc) ([merge request](gitlab-org/gitlab!144834)) **GitLab Enterprise Edition**
- [Add next desired sharding keys for package_registry](gitlab-org/gitlab@ff7c2b5abd423d2333b7b908a16448da14c2dffd) ([merge request](gitlab-org/gitlab!145254))
- [Add next desired sharding keys for importers](gitlab-org/gitlab@76a2e668305ed30e3da9608f7af8d992552fd215) ([merge request](gitlab-org/gitlab!145252))
- [Add next desired sharding keys for feature_flags](gitlab-org/gitlab@818efece04995d92ffd2f7dfcee0db6b74a9111f) ([merge request](gitlab-org/gitlab!145251))
- [Add next desired sharding keys for source_code_management](gitlab-org/gitlab@3c42ee7b0207f258ef7c429315205adad5c8a62c) ([merge request](gitlab-org/gitlab!145250))
- [Cleanup bigint conversion for system_note_metadata](gitlab-org/gitlab@5c0539a14db6da96acdda5ed337afe9c9069353e) ([merge request](gitlab-org/gitlab!145125))
- [test: Refactor tests to leverage service response shared examples](gitlab-org/gitlab@175d0d1f31090dca7762005ebb8ab95a11edf428) by @gerardo-navarro ([merge request](gitlab-org/gitlab!145156))
- [Drop use_sync_service_token_worker FF](gitlab-org/gitlab@eae7739ac1c5d0eee0e78f53cbb19e87f34816ae) ([merge request](gitlab-org/gitlab!144871))
- [Validate FKs p_ci_job_artifacts self managed](gitlab-org/gitlab@6f2cb0fa3d3537c7b70a028cd3e09ef1e7ac2fa8) ([merge request](gitlab-org/gitlab!145111))
- [Remove feature flag ci_workflow_auto_cancel_on_new_commit](gitlab-org/gitlab@2933c5f713b4fb5146b228bcf0dfcbc243d264cb) ([merge request](gitlab-org/gitlab!145144))
- [Prepare partitioning constraint for ci_stages](gitlab-org/gitlab@0bd2a03b743d0360a45f42685106a5004abdec6a) ([merge request](gitlab-org/gitlab!145109))
- [Add temporary index for locating orphaned notes](gitlab-org/gitlab@d562735b899e4840cb2297022d2ebb0d83e0f14d) ([merge request](gitlab-org/gitlab!143928))
- [Remove references to code suggestions group setting](gitlab-org/gitlab@11753521b2d89348558b147ca5982eafca2ea238) ([merge request](gitlab-org/gitlab!145043)) **GitLab Enterprise Edition**
- [Remove update_organization_users feature flag](gitlab-org/gitlab@ae9679c3c3abb92dd7f5902f48db040f802837de) ([merge request](gitlab-org/gitlab!144997))
- [Add self-managed migration](gitlab-org/gitlab@b23c24529147cfbf081d36798b821327be5f8289) ([merge request](gitlab-org/gitlab!142037))
- [Use UpdateService, add more spec coverage](gitlab-org/gitlab@6e0431b9e7ede3594f4032fa2a03bbe819b6fb7f) ([merge request](gitlab-org/gitlab!144800)) **GitLab Enterprise Edition**
- [Clean up self-hosted sent_notifications bigint](gitlab-org/gitlab@5c412bfd9627abd764725dee631cf4dbf37ef377) ([merge request](gitlab-org/gitlab!142965))
- [Add desired sharding keys for importers](gitlab-org/gitlab@989706b5b11fc621265f5947113f995ab3b5d7e7) ([merge request](gitlab-org/gitlab!144856))
- [Add desired sharding keys for team_planning](gitlab-org/gitlab@5b25063b60e1edf94d4300bdc4c87fb77526cdc2) ([merge request](gitlab-org/gitlab!144855))
- [Remove FF dependency_scanning_on_advisory_ingestion](gitlab-org/gitlab@43f385c185b094b8ec874d5c7123dcf9e78db63c) ([merge request](gitlab-org/gitlab!144546)) **GitLab Enterprise Edition**
- [Remove proxy-through-com logic for CS](gitlab-org/gitlab@b76a68ce0b1dd827107ad78124a7079565d09586) ([merge request](gitlab-org/gitlab!144721))
- [Add violation_data to scan_result_policy_violations](gitlab-org/gitlab@2210af36a7988cc2bfe9817851aa51c576603c2b) ([merge request](gitlab-org/gitlab!144504))
- [Update the Kaniko template to make the job be extendible](gitlab-org/gitlab@62fbbb77c3c81cbabed7199824c032c3125ed522) by @kjetilho ([merge request](gitlab-org/gitlab!144352))
- [Ensure uniqueness p_ci_job_artifacts IDs](gitlab-org/gitlab@7433b17f0f311d289aaa1577c4d9b9893674058a) ([merge request](gitlab-org/gitlab!144574))
- [Rename CreateEmptyEmbeddingsRecordsWorker](gitlab-org/gitlab@d8c24152743d7d5cc00c034ab9db9bcdb9db419a) by @jzeng88 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/144374)) **GitLab Enterprise Edition**
- [Add transaction check to ExclusiveLease](gitlab-org/gitlab@21994f1f62f70a3afc55b505a980ab517a016aa3) ([merge request](gitlab-org/gitlab!143321))
- [Remove ignore_column for project_import_level](gitlab-org/gitlab@f4891f738ef3ff0b9787a991c9a2277badcc1e00) ([merge request](gitlab-org/gitlab!144662))
- [Remove security_policies_sync_preexisting_state feature flag](gitlab-org/gitlab@331e33a9347988917ba2137535799e783af19ca6) ([merge request](gitlab-org/gitlab!144531)) **GitLab Enterprise Edition**
- [Fixes for MR Widget implementation and tests to support Vue compat](gitlab-org/gitlab@2cd2f8a45d2adb65638ea55480ca9943be2610d7) ([merge request](gitlab-org/gitlab!143485))
- [Remove unused code](gitlab-org/gitlab@29bb77e3c5b39706df09cc9906548598fe12d998) ([merge request](gitlab-org/gitlab!144604))
- [Rename EMPTY_TREE_ID constant](gitlab-org/gitlab@4babc79beb27c03c56301e40a047a243a2d71dee) ([merge request](gitlab-org/gitlab!144579))
- [Remove feature flag "store_object_format"](gitlab-org/gitlab@727577987734e018c0baa1c63d799de726a9f5a2) ([merge request](gitlab-org/gitlab!144628))
- [Update "Duo Pro" copy to "GitLab Duo Pro" in UI](gitlab-org/gitlab@f5ef5367a2a7fc39cea07afdbb5acac7a32f3da6) ([merge request](gitlab-org/gitlab!144461)) **GitLab Enterprise Edition**
- [Add patch for find_or_create_by](gitlab-org/gitlab@18e1855d5fd5f7e22c58a40fdf6f16540291185d) ([merge request](gitlab-org/gitlab!144457))
- [Add desired sharding keys for security_policy_management](gitlab-org/gitlab@3abb5e86fbcc4a7a59c59c08b671cdf49f659c9b) ([merge request](gitlab-org/gitlab!144470))
- [Remove feature flag security_policies_unenforceable_rules_notification](gitlab-org/gitlab@ab7862f7585854e48ad7cf28e1f530b3c8b64f4e) ([merge request](gitlab-org/gitlab!144468)) **GitLab Enterprise Edition**
- [Finalize UpdateDelayedProjectRemovalToNullForUserNamespaces migration](gitlab-org/gitlab@71bb14cb07479c40b8986c68dd7c9a388d8c91b7) ([merge request](gitlab-org/gitlab!144361))
- [Cleanup geo_pipeline_replication feature flag](gitlab-org/gitlab@32fb7a3ccc2d97bfeb60048b8519272e66015bc2) ([merge request](gitlab-org/gitlab!144549)) **GitLab Enterprise Edition**
- [Include prepared_at in the MR hook data](gitlab-org/gitlab@9cc77b735f037c2bd849b9fb76ca3435d4343080) ([merge request](gitlab-org/gitlab!143998))
- [Cleanup search_filter_by_ability feature flag](gitlab-org/gitlab@71c98ac1a359d099528b89d41aa3022abe0def72) ([merge request](gitlab-org/gitlab!144537)) **GitLab Enterprise Edition**
- [Add desired sharding keys for package_registry](gitlab-org/gitlab@530a5b438891aedf7a92ae414bb81e5d4eb0adc6) ([merge request](gitlab-org/gitlab!144476))
- [Add desired sharding keys for feature_flags](gitlab-org/gitlab@5f02c416dd9bad120799a2076dc6e262513cf6ff) ([merge request](gitlab-org/gitlab!144475))
- [Add desired sharding keys for dynamic_application_security_testing](gitlab-org/gitlab@f719300dc0cbafcee93776fa9b66800f14243b38) ([merge request](gitlab-org/gitlab!144474))
- [Add desired sharding keys for geo_replication](gitlab-org/gitlab@e5583c5d337ab47b8021c50f43cb0c0aa59d582e) ([merge request](gitlab-org/gitlab!144471))
- [Remove ci_job_token_groups_allowlist feature flag](gitlab-org/gitlab@1e192a7dcd317594757abebcf4f9872315e924ac) ([merge request](gitlab-org/gitlab!144258))
- [Add desired sharding keys for secrets_management](gitlab-org/gitlab@21d4784a4cf8162625aaf8e613935a648de56989) ([merge request](gitlab-org/gitlab!144211))
- [Remove select_ancestors_of_paginated_items feature flag](gitlab-org/gitlab@2bb9c584820424e33bca0524ebe2d49bd4ea29e3) ([merge request](gitlab-org/gitlab!143636))
- [Add sharding keys for auto_devops](gitlab-org/gitlab@320db1b8da1692fc61bc89f1c4b4e23dc87d0f00) ([merge request](gitlab-org/gitlab!143307))
- [Add sharding keys for code_review_workflow](gitlab-org/gitlab@f0ad99cc932bd74a5d02de99ee62651b32a34af2) ([merge request](gitlab-org/gitlab!143310))
- [Add sharding keys for system_access](gitlab-org/gitlab@62c2fd4788e62e46f1469e2f18d178840e8e3df2) ([merge request](gitlab-org/gitlab!142501))
- [Add sharding keys for purchase](gitlab-org/gitlab@9c3843da74714c72483c17489d5d3d68ceffd2c8) ([merge request](gitlab-org/gitlab!142505))

## 16.9.11 (2024-09-19)

No changes.

## 16.9.10 (2024-07-23)

### Added (1 change)

- [Add Rake task to show token expiration info](https://gitlab.com/gitlab-org/gitlab/-/commit/7747e83d1860f2186df35c5a29370e0e5bb0c810) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159058))

### Changed (1 change)

- [Do not enqueue PAT expiry enforcement migration](https://gitlab.com/gitlab-org/gitlab/-/commit/c7dc314ace84491b696fb65c3384fb0302d00d5a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153470))

## 16.9.9 (2024-06-25)

### Fixed (1 change)

- [Update an expired test certificate](gitlab-org/gitlab@8fb9c678564e11392eab4d2001e60f751d6a86bc) ([merge request](gitlab-org/gitlab!156395))

### Changed (1 change)

- [Add a banner informing about token expiration](gitlab-org/gitlab@a079122ed2976df0f023ef55cef4a1585e31b5ce) ([merge request](gitlab-org/gitlab!155267))

## 16.9.8 (2024-05-09)

No changes.

## 16.9.7 (2024-05-07)

### Fixed (1 change)

- [Changed the email validation for only encoded chars](gitlab-org/security/gitlab@01275ef428e3b183c638adaebe28ac53edb6ce0b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/151484/))

### Changed (1 change)

- [Return or display Gitlab version if GITLAB_KAS_VERSION is a SHA](gitlab-org/security/gitlab@d7792bcb9cdfaabc3b1345facee6b7536fb2b3cb)

### Security (11 changes)

- [Update GITHUB_MEDIA_CDN to avoid SSRF when importing from Github](gitlab-org/security/gitlab@3910b8db08f64662611322b84abfa282fe975396) ([merge request](gitlab-org/security/gitlab!4013))
- [Prevent namespace banned users from reading project todos](gitlab-org/security/gitlab@a43f81187c393376f7bdf603277e72036a127013) ([merge request](gitlab-org/security/gitlab!3941))
- [ReDoS in GitRefsFinder when using wildcards in branch search](gitlab-org/security/gitlab@844ad9c3f404a0a838b895d4ac9b7dc7493bd291) ([merge request](gitlab-org/security/gitlab!3997))
- [ReDos in escape and commit reference filters](gitlab-org/security/gitlab@186bda71e1bbcf542effee18a14d1a7261b0b12d) ([merge request](gitlab-org/security/gitlab!3974))
- [Validate request origin before MR approval](gitlab-org/security/gitlab@47be8dd9e352c19ca8fe2865c6cf995fbce987de) ([merge request](gitlab-org/security/gitlab!4009))
- [Check request size before updating user pins](gitlab-org/security/gitlab@f882c7ffaca37e10933d3f7e82d665444e25fd64) ([merge request](gitlab-org/security/gitlab!4016))
- [Enforce per_page validation for Branches/TagsFinders](gitlab-org/security/gitlab@29b2b5636a1ce1defa6dedaf656f84b54b322976) ([merge request](gitlab-org/security/gitlab!4000))
- [Update Integrations::Discord::ATTACHMENT_REGEX regex](gitlab-org/security/gitlab@3e9f6cca867362cfbd70da79f47a6ce2481fef0e) ([merge request](gitlab-org/security/gitlab!3986))
- [Update BaseMessage::RELATIVE_LINK_REGEX regex](gitlab-org/security/gitlab@e5be5ad17ba7d09b923098382b16f8637f8cac31) ([merge request](gitlab-org/security/gitlab!3994))
- [Require confirmation before linking JWT identity](gitlab-org/security/gitlab@e889c09bd4bd3897badb73d79231f183881a20f4) ([merge request](gitlab-org/security/gitlab!3992))
- [Fix confidentiality check optimization](gitlab-org/security/gitlab@fb3635e8674859226a71c1a43d26655c908ce15b) ([merge request](gitlab-org/security/gitlab!4004))

## 16.9.6 (2024-04-24)

### Security (5 changes)

- [Validation for encoded formatting characters](gitlab-org/security/gitlab@de8dc151e5ef3f07cf50839e50645df6ec12f5a5) ([merge request](gitlab-org/security/gitlab!3951))
- [Forbid untrusted sign-ins to GitLab with Bitbucket and fix related uid](gitlab-org/security/gitlab@94496a91c17a0f73202cd5c55abc93395825c68c) ([merge request](gitlab-org/security/gitlab!3985))
- [Ensure PAT scope is validated everywhere for GraphQL/ActionCable](gitlab-org/security/gitlab@0dccf32b71614584e05a8590b21a902220e8c701) ([merge request](gitlab-org/security/gitlab!3977))
- [Protect against ReDoS in FileFinder with wildcard filters](gitlab-org/security/gitlab@60a7418ec10f7c6f4ef9bcc75b2fec71255ddcc3) ([merge request](gitlab-org/security/gitlab!3961))
- [fix: Validate security report version against schema during parsing](gitlab-org/security/gitlab@ce709ff78fd8f18024383085d6ac0bf43fa2efbb) ([merge request](gitlab-org/security/gitlab!3957))

## 16.9.5 (2024-04-12)

No changes.

## 16.9.4 (2024-04-09)

### Security (3 changes)

- [Update Gitlab::Regex::Packages#slack_link_regex](gitlab-org/security/gitlab@af54b6789912e394423920674ac2f4f0e38f9ff7) ([merge request](gitlab-org/security/gitlab!3903))
- [Fix XSS in autocomplete in rich text editor](gitlab-org/security/gitlab@bf84ed8c4d716d642ed36c1a804733a17dace11a) ([merge request](gitlab-org/security/gitlab!3947))
- [Correctly parse attachments for junit result](gitlab-org/security/gitlab@ed457bf14d21566b98fa461dfac10dac06b054ac) ([merge request](gitlab-org/security/gitlab!3911))

## 16.9.3 (2024-03-27)

### Fixed (1 change)

- [Fix new project group templates pagination](gitlab-org/security/gitlab@93a68da5a3ddc7f2f5f44658a163198a8c5da240) **GitLab Enterprise Edition**

### Security (2 changes)

- [Limit the number of emojis we will transform](gitlab-org/security/gitlab@41ec64318e92b428edf9796b2777dc1d8b9b3bc2) ([merge request](gitlab-org/security/gitlab!3926))
- [Fix stored xss in wikis using the abstract_reference_filter](gitlab-org/security/gitlab@a39b0ea96cf309dfc2d8a3a73ea4a047567bd0a1) ([merge request](gitlab-org/security/gitlab!3921))

## 16.9.2 (2024-03-06)

### Fixed (2 changes)

- [Backport 145801 (Fix CI linter error when repository is empty) to 16.9](gitlab-org/security/gitlab@3387113650f62739955a47de59f7c17dbe7e9509)
- [Fix container repositories checksum mismatch errors](gitlab-org/security/gitlab@7dce926636d80e26c4e99ac74c09c3795063151a) **GitLab Enterprise Edition**

### Security (2 changes)

- [Restrict group token rotation for custom roles](gitlab-org/security/gitlab@c7eafe2b214d8a5c739fe116899540133daebef3) ([merge request](gitlab-org/security/gitlab!3905))
- [Reset approvals when reopening a MR](gitlab-org/security/gitlab@4c3fbb6674de3dfc01332a25959167ba1085e5bb) ([merge request](gitlab-org/security/gitlab!3897))

## 16.9.1 (2024-02-20)

### Fixed (2 changes)

- [Fix Duo Chat CORS issue by updating web-ide package](gitlab-org/security/gitlab@6c4fccdd4d33fd40550197699a990a0d07a65137)
- [Fix deny_all_requests_except_allowed of AddressableUrlValidator](gitlab-org/security/gitlab@18ff795a3b9fdd54705c1a8898ad15b5dd84e2f0)

### Security (10 changes)

- [Add a limit to CodeOwners reference extractor regex](gitlab-org/security/gitlab@b090b503c47300d708d7e51192a486467fdecefd) ([merge request](gitlab-org/security/gitlab!3894))
- [Ensure LDAP user cannot sign in with password](gitlab-org/security/gitlab@1c2de5ef077c5710e213b668373557c01ff8ba26) ([merge request](gitlab-org/security/gitlab!3891))
- [Ensure LDAP users cannot reset local password to bypass LDAP](gitlab-org/security/gitlab@07621ad26d2db3656c99b332e697a6b0857f6e07) ([merge request](gitlab-org/security/gitlab!3879))
- [Disallow assigning higher role than current user](gitlab-org/security/gitlab@c9d8ffebe020dfdc1435e073516a098a8d188ff0) ([merge request](gitlab-org/security/gitlab!3889))
- [Check project read access in Environment and Operations dashboard](gitlab-org/security/gitlab@83fdac099562fa4aebcc43e400b0da2026c730a6) ([merge request](gitlab-org/security/gitlab!3873))
- [Fix Stored-XSS in user's profile page: Change markup used for pronouns](gitlab-org/security/gitlab@0fafb29660c08e72b87bd79d792da802c566b650) ([merge request](gitlab-org/security/gitlab!3882))
- [Invalidate markdown cache to clear up stored XSS](gitlab-org/security/gitlab@3411c25e77642fddc3619bf24ee956d4ba4d99b2) ([merge request](gitlab-org/security/gitlab!3884))
- [Disallow users to modify deploy key title](gitlab-org/security/gitlab@46ffceb9c94b6f4ba207ddf035ae67e8de413d57) ([merge request](gitlab-org/security/gitlab!3876))
- [Adds authorization for analytics settings](gitlab-org/security/gitlab@01e2c82cb79b6b4a9f6cf3428890149d023aacfb) ([merge request](gitlab-org/security/gitlab!3877))
- [Use merge_head_diff for codeowners when merge request is mergeable](gitlab-org/security/gitlab@eafc00662cb6e604b35278a5f59c25d418ef00c9) ([merge request](gitlab-org/security/gitlab!3878))

## 16.9.0 (2024-02-14)

### Added (145 changes)

- [Ensure at least one permission is selected during member role creation](gitlab-org/gitlab@327e3959708cd9b4ed91f565f1b79108ab2c0d6e) ([merge request](gitlab-org/gitlab!143616)) **GitLab Enterprise Edition**
- [Allow signing in to Active Directory with smart card](gitlab-org/gitlab@25f2235ce97701a2677a13a6ae175f40d6f5da64) ([merge request](gitlab-org/gitlab!143721)) **GitLab Enterprise Edition**
- [Add POST /personal_access_tokens/self/rotate endpoint](gitlab-org/gitlab@e48c661eecb449deb591f3c6d89f7aa716460019) by @stalb ([merge request](gitlab-org/gitlab!142664))
- [Track traversal sync events, update vulnerability reads accordingly](gitlab-org/gitlab@9f960c976ffefa38ae025b5531f24886517cfda6) ([merge request](gitlab-org/gitlab!143537)) **GitLab Enterprise Edition**
- [Add achievements UI](gitlab-org/gitlab@7dd37d8ae59dd1fbc6120bfb50cb3821589c8b27) ([merge request](gitlab-org/gitlab!129370))
- [Update BulkImports::Failure to display subrelation that failed to import](gitlab-org/gitlab@8d44a19fe239b03134c4c247fde54b07b2062a6d) ([merge request](gitlab-org/gitlab!142820))
- [Add branchRuleDelete graphql mutation](gitlab-org/gitlab@6bc4e72b8233d8ce06697f88ea82a7fc2a04ddf9) ([merge request](gitlab-org/gitlab!144255))
- [This MR adds experiment promotion banner](gitlab-org/gitlab@9b9ac988a4a831d83514b64d6c203dce134ddde3) ([merge request](gitlab-org/gitlab!144078)) **GitLab Enterprise Edition**
- [Add settting math_rendering_limits_enabled](gitlab-org/gitlab@9f416a02be5417e9473e9f94065dce9ec7170a90) ([merge request](gitlab-org/gitlab!143256))
- [Add basic testing functionality for group level](gitlab-org/gitlab@24d019352e82b4f2c29a5d8cf86068e1ffd0dea3) ([merge request](gitlab-org/gitlab!144023)) **GitLab Enterprise Edition**
- [Sync create indexes and prepare FK for p_ci_builds upstream_pipeline_id](gitlab-org/gitlab@f4e00909f87104e3a4f5b3be8aa90beb22e53101) ([merge request](gitlab-org/gitlab!143897))
- [Added first part of the command palete update](gitlab-org/gitlab@2b5ecb472381de3cea78f40c22fc0ffb5c719fc0) ([merge request](gitlab-org/gitlab!143353))
- [Add composite PK to ci_stages](gitlab-org/gitlab@de4eb89657a422971315b39e1faeab5c98e0307a) ([merge request](gitlab-org/gitlab!144025))
- [Adds download API v4 endpoint for project avatar](gitlab-org/gitlab@d23076b8c94565a857e6e01a87dcc585064c1188) ([merge request](gitlab-org/gitlab!144039))
- [Add designs widget to work items](gitlab-org/gitlab@8533e3ec0ae8f965e82420f8f188a76d4e3cc10c) ([merge request](gitlab-org/gitlab!142113))
- [Adds convert_to_ticket quick action](gitlab-org/gitlab@d3ca0752f06031c5d6e72e06abaad84f96e5bb92) ([merge request](gitlab-org/gitlab!139553))
- [Sort resources by released_at](gitlab-org/gitlab@978ec481cc728643b5a8a98be17535b16e004a19) ([merge request](gitlab-org/gitlab!143532))
- [Adding SemanticVersionable concern to Ml::ModelVersion](gitlab-org/gitlab@f34eb63a8d499c8c2b3fae51d436e3f4a13edebe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/142228))
- [Add member guideline to admin appearance settings](gitlab-org/gitlab@70f1a15faf61074208968279a413123159d56d05) by @bufferoverflow ([merge request](gitlab-org/gitlab!137942))
- [Allow adding groups to CI_JOB_TOKEN allowlist graphQL mutation](gitlab-org/gitlab@2f6931217be6375c62415ea9f6c0d90ffeec4d4a) ([merge request](gitlab-org/gitlab!143132))
- [Log audit event for member events and custom roles](gitlab-org/gitlab@ca9ae9103a93fbf7169c61506645eaab8c6981fe) ([merge request](gitlab-org/gitlab!141985)) **GitLab Enterprise Edition**
- [Add concurrency option on sidekiq-cluster CLI](gitlab-org/gitlab@4843e5c1fb0f42c6614e9cf59e8f865a7f9da19b) ([merge request](gitlab-org/gitlab!143329))
- [Add alert about the gitops keyword deprecation](gitlab-org/gitlab@f48384c65592e2d3eafad862568505588c7c0bf4) ([merge request](gitlab-org/gitlab!143586))
- [Enable new finding modal on MR widget by default](gitlab-org/gitlab@b935941a9784e2d0902e9320a79db36e84c2bb6c) ([merge request](gitlab-org/gitlab!143987)) **GitLab Enterprise Edition**
- [feature: Add keyset pagination to the list of package protection rules](gitlab-org/gitlab@4de6931b301d2b3962ea3bcff34fbfca2663d885) by @gerardo-navarro ([merge request](gitlab-org/gitlab!140738))
- [Added cut line for board lists with WIP limit](gitlab-org/gitlab@e9b4c7188ce36533fd2b1241645aca478f3a6a88) ([merge request](gitlab-org/gitlab!142847)) **GitLab Enterprise Edition**
- [Release terraform module registry at (sub)group level](gitlab-org/gitlab@09ef9dd0344757dbddb0f40619cdd2cec970e3e6) ([merge request](gitlab-org/gitlab!143608))
- [Match Container Scanning SBOM component](gitlab-org/gitlab@d442355b2b25ddb398d6f81eb17123ac3edf6036) ([merge request](gitlab-org/gitlab!137623)) **GitLab Enterprise Edition**
- [Add GraphQL API for projects/groups linked to security policy project](gitlab-org/gitlab@6c0da69eb77dbc0b2abc1266281ff8d1a07877a4) ([merge request](gitlab-org/gitlab!143703)) **GitLab Enterprise Edition**
- [Added table and model for instance level destination](gitlab-org/gitlab@28ed896bef7853172f26eecd8a2bd9618adb14ed) ([merge request](gitlab-org/gitlab!143247)) **GitLab Enterprise Edition**
- [Adding tables and models for group streaming destinations](gitlab-org/gitlab@29199b2afc5725dc23b86feed48430a03c259516) ([merge request](gitlab-org/gitlab!141739)) **GitLab Enterprise Edition**
- [Add rich text editor in design notes](gitlab-org/gitlab@b4b05e8980c9ed841ee6de6d0f5bea9260250e66) ([merge request](gitlab-org/gitlab!143773))
- [Add rich text editor to release descriptions](gitlab-org/gitlab@23f137b4b3aa45b01b5eedd0746b530b287838a3) ([merge request](gitlab-org/gitlab!143775))
- [Add rich text editor in requirements](gitlab-org/gitlab@5418d7e981e7d39da510ca1f1443838a2cd575da) ([merge request](gitlab-org/gitlab!143778))
- [Add rich text editor in vulnerabilities](gitlab-org/gitlab@5d193823bd7b4fc6234dc2e7583cbca9f5ec25bc) ([merge request](gitlab-org/gitlab!143784))
- [Validate the foreign key & add to routing table auto_canceled_by_id](gitlab-org/gitlab@97aa6e854227cbf7b20c253c0031e1d300a1bef2) ([merge request](gitlab-org/gitlab!143777))
- [Add catalog_verified_namespace table](gitlab-org/gitlab@ec63a6edd94ab97bd73a27367d138e515cc62e7a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/143003))
- [Feat: transition to JiHu callout frontend](gitlab-org/gitlab@c5c35a14976cf4a065be06c901cfc7b84619a2a9) ([merge request](gitlab-org/gitlab!142126))
- [Feat: add entries for JH about repo blob viewers](gitlab-org/gitlab@c5effaac0edd22deba0a6d03bfb963468003d3c7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/143019))
- [Add organizations support to PushRules](gitlab-org/gitlab@8ecc6da4125581ce65c7d509ce1f665a7edd19dc) ([merge request](gitlab-org/gitlab!143541)) **GitLab Enterprise Edition**
- [Add rewrite_history method to the Gitaly cleanup client](gitlab-org/gitlab@76e7cd4f3cfca86ef1da574809adaeba599d5aff) ([merge request](gitlab-org/gitlab!142886))
- [Prepare async index for p_ci_builds.runner_id and commit_id](gitlab-org/gitlab@f37f03ce7c4145825a23849dfa172f28b47f8ced) ([merge request](gitlab-org/gitlab!143747))
- [Add CVSS data to vulnerabilities GraphQL API](gitlab-org/gitlab@9fa0080b83b1a827a81ca92c126a3352e3b77c88) ([merge request](gitlab-org/gitlab!143736)) **GitLab Enterprise Edition**
- [Add separate tab for the K8s Pods](gitlab-org/gitlab@39e7ffca747ac05fbfdf157b02069830eccd4afe) ([merge request](gitlab-org/gitlab!142326))
- [Update the analyzer for merge_request title and description](gitlab-org/gitlab@014d6c3fbe5f95e798c937a9f6aceafbc40c76d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/142550)) **GitLab Enterprise Edition**
- [Reject commits breaking GitGuardian policies](gitlab-org/gitlab@e0355289f7440cb6a0664b00f0c49e879b5e2d38) ([merge request](gitlab-org/gitlab!141779)) **GitLab Enterprise Edition**
- [Add the user access level claim to ID tokens](gitlab-org/gitlab@2c200eae49e0a0b5514a4100f8cafefc5d928b65) ([merge request](gitlab-org/gitlab!143091))
- [Add allow/disallow duplicate terraform modules setting to UI](gitlab-org/gitlab@f171779d298e1eb0957880f8501cda7c0c88e0b9) ([merge request](gitlab-org/gitlab!142855))
- [Track Insights merge request chart item click events](gitlab-org/gitlab@66824bdd9fb5673e744f724660118d77e4744288) ([merge request](gitlab-org/gitlab!143126)) **GitLab Enterprise Edition**
- [Extend drill-down functionality to all issuables Insights charts](gitlab-org/gitlab@10b7a5a0de86f1bc351c899d312f9a14486916d3) ([merge request](gitlab-org/gitlab!142872)) **GitLab Enterprise Edition**
- [Extend Projects API with a new parameter `repository_object_format`](gitlab-org/gitlab@9cfc3937cc35bd9b845f3c5c82cac136acf314e7) ([merge request](gitlab-org/gitlab!137659))
- [Allow creation of group-level custom-roles on self-managed instances](gitlab-org/gitlab@af5016004d8b7e2a0dafee9cb9c1c260ffa7c9e5) ([merge request](gitlab-org/gitlab!142637)) **GitLab Enterprise Edition**
- [Add groups to CI_JOB_TOKEN allowlist](gitlab-org/gitlab@60d902398ddb61730f8d4ee0dc384687ac457bb4) ([merge request](gitlab-org/gitlab!142441))
- [Add feature flag for progressive rollout of CVS](gitlab-org/gitlab@e2b2acb15169ad347a0230c69ed838a171b83a25) ([merge request](gitlab-org/gitlab!143275))
- [Sync create indexes for p_ci_builds auto_canceled_by_id and commit_id](gitlab-org/gitlab@dbef1efea70a0359a1de1ec83f2b299de45c5fe4) ([merge request](gitlab-org/gitlab!142766))
- [Create ProjectPlanLimits type](gitlab-org/gitlab@2ccbdebdc7c5d175cba4344de61c1342eeb118b1) ([merge request](gitlab-org/gitlab!142717))
- [Added updated to releases api](gitlab-org/gitlab@95b9bf0773eaff7b98fb2d0b399201f837b4eb13) ([merge request](gitlab-org/gitlab!141432))
- [Add group vulnerability report denormalisation fields to vuln_reads](gitlab-org/gitlab@f16ea5e330d0a584b126a8ff5f93eb08da974ebf) ([merge request](gitlab-org/gitlab!143215))
- [Sort resources by released_at](gitlab-org/gitlab@3609e3f9ae1ebd3c03e9194a291ad4356d2147c6) ([merge request](gitlab-org/gitlab!143422))
- [Ingest source_package_name as source_package](gitlab-org/gitlab@7ac33bbdbb8db6e0978cfb20595a3354cf97f759) ([merge request](gitlab-org/gitlab!142008)) **GitLab Enterprise Edition**
- [Add direct members metric to VSD counts](gitlab-org/gitlab@ae8160deca5ae04c6fe4dd72b33f8e78cbe94fe0) ([merge request](gitlab-org/gitlab!142060)) **GitLab Enterprise Edition**
- [Enable the ci_workflow_auto_cancel_on_new_commit feature](gitlab-org/gitlab@4be9807c06d25e4d905a964c878da5af42c2b01b) ([merge request](gitlab-org/gitlab!142911))
- [Add Privacy Policy and Terms acceptance component](gitlab-org/gitlab@7bff2bbfb2fbd218a2d387058e035869fa4d9ce4) ([merge request](gitlab-org/gitlab!143025)) **GitLab Enterprise Edition**
- [Assign instance-level custom roles to user](gitlab-org/gitlab@dbc40511cf0643a69a95d691622754651d80d80d) ([merge request](gitlab-org/gitlab!141847)) **GitLab Enterprise Edition**
- [Add `archived` and `traversal_ids` columns to `sbom_occurrences`](gitlab-org/gitlab@3042efee13bdac33a8b3a8de965b0df6b2f8e7fb) ([merge request](gitlab-org/gitlab!143104))
- [Add version to fetch readme](gitlab-org/gitlab@3367905421933f2b1233d5fd91168465a150c4d9) ([merge request](gitlab-org/gitlab!142853))
- [Update the analyzer for epic description and title](gitlab-org/gitlab@e422027b22ae2bc7944882c22fedf102da125bfc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/142562)) **GitLab Enterprise Edition**
- [Add sorting support to organization projects GraphQL query](gitlab-org/gitlab@6c86c6ab89c4b82dd46cc88168d7a67440af203e) ([merge request](gitlab-org/gitlab!142390))
- [Enabled has remediations filter by default](gitlab-org/gitlab@6a6306895e90a937e99b1d47f865441571621ad2) ([merge request](gitlab-org/gitlab!140469)) **GitLab Enterprise Edition**
- [Release concurrency limit for Sidekiq](gitlab-org/gitlab@58f7280969d7d026509427629ddc95468cba01f4) ([merge request](gitlab-org/gitlab!142901)) **GitLab Enterprise Edition**
- [Add GraphQL mutation to refresh standards adherence checks](gitlab-org/gitlab@0e5c6b9125f42588354ccaddc0e02b138415f5d2) ([merge request](gitlab-org/gitlab!142440)) **GitLab Enterprise Edition**
- [Document how to configure mutual TLS for Webhooks](gitlab-org/gitlab@286493c283f5936b0e6eccf18daf626b8ad86658) ([merge request](gitlab-org/gitlab!143115))
- [Add available_from_access_level to custom abilities](gitlab-org/gitlab@b556e17a09f79190a2faaf4c9eed32178f54c058) ([merge request](gitlab-org/gitlab!142802)) **GitLab Enterprise Edition**
- [Add index on sbom_occurrences table on project_id,](gitlab-org/gitlab@23f5a409ca6f030f74e5a9e9518c7d5fb4fdfce4) ([merge request](gitlab-org/gitlab!142540)) **GitLab Enterprise Edition**
- [Add repository x-ray usage tracking telemetry](gitlab-org/gitlab@efbba568863106a3379f8d1b0418af72088058f1) ([merge request](gitlab-org/gitlab!142807)) **GitLab Enterprise Edition**
- [Add manage roles link to roles dropdowm](gitlab-org/gitlab@f308529e9616b3ccf5af59d55bfd765ced90f0c9) ([merge request](gitlab-org/gitlab!142560)) **GitLab Enterprise Edition**
- [Allow filtering by unknown license](gitlab-org/gitlab@3a569da169dda8fb6bb22c8c02f7bf3be3172cf7) ([merge request](gitlab-org/gitlab!142235)) **GitLab Enterprise Edition**
- [Create packages_terraform_module_metadata table & corresponding model](gitlab-org/gitlab@4d56bfa7f73375bdb5d46e8a80143427595a1f8f) ([merge request](gitlab-org/gitlab!141914))
- [Show admin mode within active sessions view](gitlab-org/gitlab@4041a0ff1a6c8cf80bc3514a197a5355e02ac29f) by @bufferoverflow ([merge request](gitlab-org/gitlab!142158))
- [Port Star button to Vue app](gitlab-org/gitlab@5bde208c6864d9d1fdaf790002c30913374aae3a) by @espadav8 ([merge request](gitlab-org/gitlab!126475))
- [Criticial Security Alert - Latest Stable Patch](gitlab-org/gitlab@1d9a8808f369b8acf56b64b77499a945502ff4d7) ([merge request](gitlab-org/gitlab!142858))
- [Add description field to GraphQL MemberEntity](gitlab-org/gitlab@ac8d02f164873440baf8002411a2e75dc536edb5) ([merge request](gitlab-org/gitlab!142900)) **GitLab Enterprise Edition**
- [Add WorkItems Rolledup Dates mutation GraphQL](gitlab-org/gitlab@83070391bde87bfd61d821b1d527f2aafe7e37a4) ([merge request](gitlab-org/gitlab!140224)) **GitLab Enterprise Edition**
- [Expose ID in Types::Projects::BranchRuleType](gitlab-org/gitlab@d15b9464a31f7b67fda866e10e3ed9550cca18f4) ([merge request](gitlab-org/gitlab!142306))
- [Adds instance admins to organization_users as owners](gitlab-org/gitlab@4d8d7beb3f7d629c7a896a11d6b50a242556c8eb) ([merge request](gitlab-org/gitlab!141297))
- [Add verification_level to GraphQL ComponentType](gitlab-org/gitlab@47e3ccb19b186610550014b3dd5447d858d01457) by @imskr ([merge request](gitlab-org/gitlab!142317))
- [Expose securityPolicyProject for project or group in GraphQL API](gitlab-org/gitlab@e72f2a5f5090c597062b7e765c17860cc3fd2c7e) ([merge request](gitlab-org/gitlab!142720)) **GitLab Enterprise Edition**
- [feat: Integration in container auth service](gitlab-org/gitlab@e7f2bf7141fd80508eea887e8ca11010dd397c52) by @gerardo-navarro ([merge request](gitlab-org/gitlab!136873))
- [feat: Validation for container_path_pattern](gitlab-org/gitlab@11e486f956544ebb83d6366d7d436e870d037ab9) by @gerardo-navarro ([merge request](gitlab-org/gitlab!135972))
- [Add composite PK to ci_job_artifacts](gitlab-org/gitlab@d59c2ba0e50a32a7a3b132ad1b0cb77447dcc966) ([merge request](gitlab-org/gitlab!142644))
- [Added FF](gitlab-org/gitlab@40d860975611a37f5b29b2de3c3b6a1261a64f06) ([merge request](gitlab-org/gitlab!141965)) **GitLab Enterprise Edition**
- [Add Search::Zoekt::Repository model](gitlab-org/gitlab@6e4608a381d967a5f77d2a367294ac7006ed08c5) ([merge request](gitlab-org/gitlab!141864)) **GitLab Enterprise Edition**
- [feat: Protected packages: Create protection rules in project setting ui](gitlab-org/gitlab@ddca3e317dab73a0c324f9f6fe78b01394c6af4d) by @gerardo-navarro ([merge request](gitlab-org/gitlab!140473))
- [Prepare async index for p_ci_builds.upstream_pipeline_id and commit_id](gitlab-org/gitlab@2a820097db2208a450ef682bd70a31f79eb6e1fc) ([merge request](gitlab-org/gitlab!142763))
- [Add protectableBranches to ProjectType](gitlab-org/gitlab@40cc526d6904f5eff90bfb9f1c5b0c15615b8218) ([merge request](gitlab-org/gitlab!142464))
- [Add a new analyzer title_analyzer](gitlab-org/gitlab@80eebb64cb367b1fdc66c6312ddcf68d515cf061) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/142580)) **GitLab Enterprise Edition**
- [Add preload for autocomplete_sources/members](gitlab-org/gitlab@eddb9f3c540521257b5dcabe0c705560ed6796e1) ([merge request](gitlab-org/gitlab!142663))
- [Add the code_analyzer for notes note](gitlab-org/gitlab@c0fd247544196cad1cdbf0a7e9f983154db7398a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/142301)) **GitLab Enterprise Edition**
- [REST API support for getting commit sequence/count](gitlab-org/gitlab@613708ea4526695c7bf1b60aa766ee56cecfbdd5) by @travis.finch ([merge request](gitlab-org/gitlab!142250))
- [Adds graphql search options for Ml::ModelVersion](gitlab-org/gitlab@4f486027ee4a7f236e79a7bdbf77a954b31cef06) ([merge request](gitlab-org/gitlab!142320))
- [Migration to remove work_items from issues index](gitlab-org/gitlab@409762fb210fbc08d145dcbbd62a3cc05cc7faa1) ([merge request](gitlab-org/gitlab!142653)) **GitLab Enterprise Edition**
- [SAML reauth banner for issues and merge requests dashboard](gitlab-org/gitlab@508604d28acbe897d5c00f7482dab9a344f16438) ([merge request](gitlab-org/gitlab!140893)) **GitLab Enterprise Edition**
- [Prepare async index for auto_canceled_by_id_convert_to_bigint](gitlab-org/gitlab@5903e80a1b7eb93a7f1e9a51cdf9365dd05293b0) ([merge request](gitlab-org/gitlab!142476))
- [Publish ApprovalsResetEvent when approvals are reset on push](gitlab-org/gitlab@646e45c00447acf0ea47b2f4f782556db74cc3f4) ([merge request](gitlab-org/gitlab!141680)) **GitLab Enterprise Edition**
- [Members API: Allow group Owners to obtain enterprise users emails](gitlab-org/gitlab@708e6e51e849325b3cbc7950b82479ae5b205ec0) ([merge request](gitlab-org/gitlab!135873)) **GitLab Enterprise Edition**
- [Add `is_forked` field to project GraphQL type](gitlab-org/gitlab@38a1db7a93b1deacec0bc78aa76bd65897b077ee) ([merge request](gitlab-org/gitlab!141536))
- [Removes moved_mr_sidebar flag](gitlab-org/gitlab@fd56a1433ea685e965f0430d754a1bc3f779587d) ([merge request](gitlab-org/gitlab!127001))
- [Finalize BackfillPartitionId for ci_pipelines related tables](gitlab-org/gitlab@75e6ab96bf2284867552b3bcebea31edbca3ced7) ([merge request](gitlab-org/gitlab!142422))
- [Add "Contributor count" metric to Value Streams Dashboard](gitlab-org/gitlab@c615ebfc53d7edbff7bdae18dcf272edf29fe990) ([merge request](gitlab-org/gitlab!141912)) **GitLab Enterprise Edition**
- [Add category to /spend quick action](gitlab-org/gitlab@243d761bc9d88143f9bb8df3c9aa397a0106c5e5) ([merge request](gitlab-org/gitlab!140990))
- [Allow group Owners to view enterprise users emails on UI/Members page](gitlab-org/gitlab@15aa8b554ecf7512938bbf7c4729b2aad0e13830) ([merge request](gitlab-org/gitlab!141789)) **GitLab Enterprise Edition**
- [Add name and description for WebHooks](gitlab-org/gitlab@0d67426dc335c5741da2f8476f2b5197f094b1bb) ([merge request](gitlab-org/gitlab!141977))
- [Update front-end to create instance-level custom roles](gitlab-org/gitlab@0afa98ea9425260255a7e6a804f271131cbfcec1) ([merge request](gitlab-org/gitlab!141562)) **GitLab Enterprise Edition**
- [Add maxAccessLevel field to project and group type](gitlab-org/gitlab@26daf5920372e37475da022a566c0cf6470c7d83) ([merge request](gitlab-org/gitlab!141969))
- [Log when GraphQL query has deprecated arguments](gitlab-org/gitlab@ae2b28bbbf9a03a224da83aa4148c70a88ed11a8) ([merge request](gitlab-org/gitlab!142467))
- [Add Direct Transfer Stats API](gitlab-org/gitlab@75befb2b7fbe8f33ac12a673a541e6afce55f1c5) ([merge request](gitlab-org/gitlab!140097))
- [Add timestamp for sbom_source_packages](gitlab-org/gitlab@194ec70a7b8889a88c473354b29d0dafa6f4e045) ([merge request](gitlab-org/gitlab!142006))
- [Add GitLab for Slack app integration to REST API](gitlab-org/gitlab@e086e2def0c14dfaf92456509538591cee5434dd) ([merge request](gitlab-org/gitlab!141693))
- [Check if DB external command config parsed output is a Hash](gitlab-org/gitlab@7bf751639945a545f553b01749aedf3d61663309) ([merge request](gitlab-org/gitlab!142064))
- [AI Agent list view](gitlab-org/gitlab@e343e98ea2c994e44690b879e6819ed78c544278) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/141664)) **GitLab Enterprise Edition**
- [Unsubscribe individual issue email participants from issue](gitlab-org/gitlab@a536d72bb0a56b9d9eb96b52a9ea2d5c02662981) ([merge request](gitlab-org/gitlab!141131))
- [Define global identifiers for branch rules](gitlab-org/gitlab@d18055644dd3ddc121373ce9c63206d31476a393) ([merge request](gitlab-org/gitlab!142302))
- [Allow configuring git access protocol via Groups API](gitlab-org/gitlab@36ffbf82f70c58c83308b6d2500aacb37a794bf4) ([merge request](gitlab-org/gitlab!141118))
- [Add get ServicePing API endpoint](gitlab-org/gitlab@8bf3fe0482097456c01fb2b3da51b72becab9dcf) ([merge request](gitlab-org/gitlab!141446))
- [Remove dev feature flag: track_geo_secondary_git_op_action](gitlab-org/gitlab@57ad5fec53706e6cc215654a1aa80cd35f86174e) ([merge request](gitlab-org/gitlab!141505)) **GitLab Enterprise Edition**
- [Add description field to CI Variables drawer](gitlab-org/gitlab@16e327b66b7a05fc905b932719e5663bba79714d) ([merge request](gitlab-org/gitlab!140547))
- [Introduce BeyondIdentity integration to verify GPG keys](gitlab-org/gitlab@69cb2d20fc2a501ace8172af4aebfc478da317d1) ([merge request](gitlab-org/gitlab!136754))
- [Add support for cancelled subscription licenses](gitlab-org/gitlab@7f17d1bd47907941e6b45a995e751c825c8bba68) ([merge request](gitlab-org/gitlab!141554))
- [Enable geo_skip_download_if_exists by default](gitlab-org/gitlab@0388a8255a31a03b9403e49519d16ec9a6681938) ([merge request](gitlab-org/gitlab!140276)) **GitLab Enterprise Edition**
- [Audit CI artifact download](gitlab-org/gitlab@7d96ac2f1884b5f492cd9b12c66068ebf0666a9b) ([merge request](gitlab-org/gitlab!129608)) **GitLab Enterprise Edition**
- [Enable Jira integration issues and vulnerabilities on the group level](gitlab-org/gitlab@b593f6773310eaef370c49741690589e2470bd9f) ([merge request](gitlab-org/gitlab!141996))
- [Add participants widget](gitlab-org/gitlab@c5b699208d90e829decb15f1d7be3f68724efd2b) ([merge request](gitlab-org/gitlab!141097))
- [Hide count and table header in empty state](gitlab-org/gitlab@14d4d9d10f307f1576fdddb242d67b311def4917) ([merge request](gitlab-org/gitlab!141458)) **GitLab Enterprise Edition**
- [Remove pipeline_name_search feature flag](gitlab-org/gitlab@25101d206da47de552ed561e180ed9e6d2b50ace) ([merge request](gitlab-org/gitlab!133607))
- [GraphQL: Add systemId argument to `CiRunner.managers`](gitlab-org/gitlab@55562e837e99ab44395b8eb236e6d7066e918743) ([merge request](gitlab-org/gitlab!140714))
- [Allow setting inheritance type on protected env](gitlab-org/gitlab@85ba8369a4ea3944a010df9d8bf2ed061193e5e0) ([merge request](gitlab-org/gitlab!141422)) **GitLab Enterprise Edition**
- [Allow providing extra DB config through an external command](gitlab-org/gitlab@13d5b459b37d7149b8c494e7fad86345e47d0507) ([merge request](gitlab-org/gitlab!141818))
- [Added arugment error when pipeline is nil](gitlab-org/gitlab@e9d89ce94094f92d089f3d5d68f20192e8c91e85) by @chirayu999 ([merge request](gitlab-org/gitlab!141267))
- [Enforce workspaces_quota and workspaces_per_user_quota](gitlab-org/gitlab@ab0fadb19142b6c70c732105c864ce6d2f208868) ([merge request](gitlab-org/gitlab!141376))
- [Add verification_level to catalog_resources](gitlab-org/gitlab@480abdaf55b90106dfa0de5bf04a44bcc41b2da5) by @imskr ([merge request](gitlab-org/gitlab!140219))
- [Allow specifying extra Redis config from external command](gitlab-org/gitlab@595b0672a637988b44c88f1b0a335b508ca78eb8) ([merge request](gitlab-org/gitlab!141681))
- [Record previous weight when updating issue weight](gitlab-org/gitlab@e7e786b76b9737a6cfb4e0796fb59d7d078b8d37) ([merge request](gitlab-org/gitlab!141509)) **GitLab Enterprise Edition**
- [Add VSA added to iteration event](gitlab-org/gitlab@f5769694b23984e7d8eefc8f5953394d51e9b99f) ([merge request](gitlab-org/gitlab!141759)) **GitLab Enterprise Edition**
- [Add standards adherence refresh worker](gitlab-org/gitlab@14b242fd7abe57213c1eefa7f89c6de3ee71960c) ([merge request](gitlab-org/gitlab!141710)) **GitLab Enterprise Edition**
- [Track git operations from geo sites](gitlab-org/gitlab@950c237f1a9a40e77d9c46e94941692ba2ef73bb) ([merge request](gitlab-org/gitlab!141512)) **GitLab Enterprise Edition**

### Fixed (145 changes)

- [Filter committers with merge commits as well when users are loaded](gitlab-org/gitlab@d9d08f598d9a2dcb47f5a1e2f4a869e053eaea6d) ([merge request](gitlab-org/gitlab!144381)) **GitLab Enterprise Edition**
- [Fix CODEOWNERS rule to ignore Verify specs for lib](gitlab-org/gitlab@8e329139ceac045fc7c547dff9ffb60cabd45047) ([merge request](gitlab-org/gitlab!143387))
- [Contributor analytics: User commit counts update for time period](gitlab-org/gitlab@084e63e4ebe3a4dcade0224c30d228999b604095) ([merge request](gitlab-org/gitlab!143968))
- [Fix missing outbound_local_requests_allowlist parameter](gitlab-org/gitlab@62a58d5a51e70816544e9a537d9938f64e4dc6d1) ([merge request](gitlab-org/gitlab!144345))
- [Fix line anchor hrefs for legacy viewers](gitlab-org/gitlab@c4d26666c277141df039f37684b527004341c3a2) ([merge request](gitlab-org/gitlab!144340))
- [Fixes rendering issue with the sidebar on printed pages](gitlab-org/gitlab@20c031c02b12745026c6072e6bb719de597d22b0) ([merge request](gitlab-org/gitlab!144321))
- [Avoid mutating OpenSSL::PKey::EC keys](gitlab-org/gitlab@a661db3bcfbf9c32dcc9cf28bcd0221cfa0c289c) ([merge request](gitlab-org/gitlab!144252))
- [Fix X509::Signature#x509_issuer not working with OpenSSL 3](gitlab-org/gitlab@4bad33e001f09d1dd83f9f5bfd042fa39c137780) ([merge request](gitlab-org/gitlab!144252))
- [Added RefreshImportWorker to Bitbucket Cloud/Server stage workers](gitlab-org/gitlab@2e8babc771fd88d05334a9001d36e40aa86e0bd9) ([merge request](gitlab-org/gitlab!142980))
- [Remove math rendering exception for wikis](gitlab-org/gitlab@f1810d659e5faf1f499a1a49f6c64951a2c7837d) ([merge request](gitlab-org/gitlab!143550))
- [Use component_version_id for project finder](gitlab-org/gitlab@365ae698118d74374c47d15c90e76cd6518a9a7b) ([merge request](gitlab-org/gitlab!143841)) **GitLab Enterprise Edition**
- [Revert "Merge branch 'ag/356965-bug-sm-awaiting-user-signup-badge' into 'master' "](gitlab-org/gitlab@c7faa8439891cc3d69fa42fe4e23e48922599595) ([merge request](gitlab-org/gitlab!144225))
- [Update DiffNote's line_range during importing](gitlab-org/gitlab@d6df0435065dbb909fe8f8b425d9ff3804248326) ([merge request](gitlab-org/gitlab!144221))
- [Fix approvers loading for approval_policy type](gitlab-org/gitlab@92e1c3d8947d55cf5c73d579db5e1b8e81f262b0) ([merge request](gitlab-org/gitlab!144184)) **GitLab Enterprise Edition**
- [Fix with_hosted_plan when used with trial: nil](gitlab-org/gitlab@244b65135cbe747332389e45e1eff2d93dd54ae7) ([merge request](gitlab-org/gitlab!144185)) **GitLab Enterprise Edition**
- [Disable autocomplete sources feature flag](gitlab-org/gitlab@7c3494ad641eca5adf2b655e0fd4202666f11018) ([merge request](gitlab-org/gitlab!144169))
- [Handle row for "others" in runner usage breakdown](gitlab-org/gitlab@b620584b51a1e72064cb4e0715deb976d1432e27) ([merge request](gitlab-org/gitlab!144163)) **GitLab Enterprise Edition**
- [Update workhorse timeout to 55s](gitlab-org/gitlab@a88995390cca1f8fabe2dd326334ffd84c6bd3b3) ([merge request](gitlab-org/gitlab!143855)) **GitLab Enterprise Edition**
- [Milestone burndown chart consistency fixes](gitlab-org/gitlab@8ecd79969c4973fe044ab0c1c7939fc692b8d33e) ([merge request](gitlab-org/gitlab!143992)) **GitLab Enterprise Edition**
- [Fix limited visibility of variable values in dropdown](gitlab-org/gitlab@39da4e2266eca1832770bf6a6667b9bae2023fde) by @antonkalmykov ([merge request](gitlab-org/gitlab!143733))
- [Fix scan execution policy without ci file](gitlab-org/gitlab@07ce5d109b5664a755fbb086d2451e7abfa0817a) ([merge request](gitlab-org/gitlab!143979)) **GitLab Enterprise Edition**
- [Allow users w/ read_code permission to search code](gitlab-org/gitlab@9f1011b035accaa9aacd48ffbde01b68db39fd0a) ([merge request](gitlab-org/gitlab!144084)) **GitLab Enterprise Edition**
- [Fix issue with selecting expired milestones in RTE](gitlab-org/gitlab@25e7905d2048059ffb21e9251f826a3cb309ca29) ([merge request](gitlab-org/gitlab!143790))
- [Fix SBOM ingestion errors caused by input file path validation](gitlab-org/gitlab@19b483346280cf0879ef541be068f1de6aff9ee0) ([merge request](gitlab-org/gitlab!143985))
- [Fix changelog tag detection logic](gitlab-org/gitlab@abca89753caa1d533cb3444f94e0d31266825cd5) ([merge request](gitlab-org/gitlab!143827))
- [Issue board - Fix updating total list weight](gitlab-org/gitlab@0a1c36473054e65ccde90088401ec27fd8c5c331) ([merge request](gitlab-org/gitlab!143765)) **GitLab Enterprise Edition**
- [This MR fixes wrong wording for policy scope](gitlab-org/gitlab@b7821d5b764a354f78d9fb45ca1b033cf298e37b) ([merge request](gitlab-org/gitlab!143648)) **GitLab Enterprise Edition**
- [Fix OIDC and id_token issuer mismatch](gitlab-org/gitlab@45fe23971510232ca4586bd5f971e2de3f2acf9b) ([merge request](gitlab-org/gitlab!141151))
- [Revert "Merge branch '427437-preload-autocomplete_sources-members-retry' into 'master'"](gitlab-org/gitlab@3fb8cd2d698c07047e3bf6f8153307ef07cdefd3) ([merge request](gitlab-org/gitlab!143912))
- [Allow move to failed, from pending or failed](gitlab-org/gitlab@3813e8733745afb377eb57e1778b332d1b85099f) ([merge request](gitlab-org/gitlab!143158)) **GitLab Enterprise Edition**
- [Fix MockCI REST API](gitlab-org/gitlab@efd5c645eb3bb370d86bbef1c3ebc54d341872d1) ([merge request](gitlab-org/gitlab!143634))
- [Display runner dashboard ClickHouse features](gitlab-org/gitlab@641233ea0367c28fc786d3c1e926323c1564b74c) ([merge request](gitlab-org/gitlab!143209))
- [Return allow_force_push: false always when security policy enforced](gitlab-org/gitlab@9d1d787801d09ea8c669228b5d283aceb8cbaa5f) ([merge request](gitlab-org/gitlab!143839)) **GitLab Enterprise Edition**
- [Fix broken upload progress indicator](gitlab-org/gitlab@c47f652b024213c1a5d686bd437b1b1ed308acee) ([merge request](gitlab-org/gitlab!143788))
- [Fix the error when the fork is linked to itself](gitlab-org/gitlab@e20f2e58d43f0c5dd65806346ce5484498a0e3aa) ([merge request](gitlab-org/gitlab!141273))
- [Fix absent parameters in runner usage resolver](gitlab-org/gitlab@02b566c317f62d4944e69cbcc6d6c56ee6b64f39) ([merge request](gitlab-org/gitlab!143800))
- [Save message in chat api](gitlab-org/gitlab@670d883877a8359ffbc3b68638bc91529ebff680) ([merge request](gitlab-org/gitlab!143371)) **GitLab Enterprise Edition**
- [Fix issue with copying task lists](gitlab-org/gitlab@c1d5446ea22fe62426f172d52108f6a64e09ce3f) ([merge request](gitlab-org/gitlab!143785))
- [Fix bug where date strings where incorrectly formatted](gitlab-org/gitlab@bcdedf57aa6ab804207e5c4b858c36ebd62c6ee6) ([merge request](gitlab-org/gitlab!143744)) **GitLab Enterprise Edition**
- [Fix API branches OpenAPI YAML parameters](gitlab-org/gitlab@6ef1605082e05ea3b8d3aee2cd73534af6b7b7fc) by @Sineaggi ([merge request](gitlab-org/gitlab!143610))
- [Select report_type based on feature flag when](gitlab-org/gitlab@7cf9c781f6fc0377a3cc448176b176b4a17393c7) ([merge request](gitlab-org/gitlab!143517)) **GitLab Enterprise Edition**
- [Allow loading of Hashie::Mash in YAML](gitlab-org/gitlab@23b1e437266d947c447934f12fff494e6cffc3e3) ([merge request](gitlab-org/gitlab!143694))
- [Update mermaid to fix upstream render bug](gitlab-org/gitlab@e20e78a59270419d21aa348b16316a6ca31aa603) ([merge request](gitlab-org/gitlab!143609))
- [Use clearer label for iteration report calc mode](gitlab-org/gitlab@0d762500d61fc55d6b28b6c30045a4593e3bd80e) ([merge request](gitlab-org/gitlab!143569)) **GitLab Enterprise Edition**
- [Update the list of supported protocols for Settings API](gitlab-org/gitlab@5324313f5e2e473df28977ce01c08ff02604654a) ([merge request](gitlab-org/gitlab!142159))
- [Reindex wikis to adopt new structure of id](gitlab-org/gitlab@14e68ac13830c99f81c4e0b505dba29cb7c746eb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/143273)) **GitLab Enterprise Edition**
- [Set default vulnerability_states for empty states](gitlab-org/gitlab@554078f22ba1cd92143dc78d5ed0f60dec251e01) ([merge request](gitlab-org/gitlab!143498)) **GitLab Enterprise Edition**
- [Fix snippets overflowing bug](gitlab-org/gitlab@b2961c3aea41106d3aace04fb18e56c7febb2794) ([merge request](gitlab-org/gitlab!143523))
- [Fix group filter and pagination bug](gitlab-org/gitlab@d8591c7fca8c34bbe59166dd388a15a55a539d2d) ([merge request](gitlab-org/gitlab!108022))
- [Check project policy_configuration ids on syncing compliance framework](gitlab-org/gitlab@568f996d9a256b7a927b07faabb2780b0faca245) ([merge request](gitlab-org/gitlab!143590)) **GitLab Enterprise Edition**
- [Fix the lingering outdated codeowner rules issue](gitlab-org/gitlab@e812b800c3199a71422ffe1cd475eb24f05c39ca) ([merge request](gitlab-org/gitlab!143330))
- [Fix reviews import and E2E in GitHub Import](gitlab-org/gitlab@faecff1ffd804262a97fc9add58bf4bdf918bcba) ([merge request](gitlab-org/gitlab!143219))
- [Add dark mode modal specific timeline entry styles](gitlab-org/gitlab@eb06fd2eea03a824d4c75a4dc5345e88a59ba4d4) ([merge request](gitlab-org/gitlab!143128))
- [Change logic of oauth_authorization_path for GitLab Jira App](gitlab-org/gitlab@2e2010e3f090bafad371f2a1787d9edccbea38ff) ([merge request](gitlab-org/gitlab!143543))
- [Fix pipeline page timeout](gitlab-org/gitlab@1bc7e2a55723f3ef8701c909d6849d8afb535db1) ([merge request](gitlab-org/gitlab!143413))
- [VSD - Group merge request throughput should include subgroups](gitlab-org/gitlab@6dcecc1c11a5027e204d473553e7e440d53b1e5b) ([merge request](gitlab-org/gitlab!143377)) **GitLab Enterprise Edition**
- [Fix Redis 6.0 compatibility breakage with Sidekiq 7 gem](gitlab-org/gitlab@02467a794e381217f10ccdbf5717cbbf9b0e3086) ([merge request](gitlab-org/gitlab!142986))
- [Pass outbound_local_requests_whitelist to ProjectImporter](gitlab-org/gitlab@28995a77f33e4bf602ade8ea75d8e977784b7480) ([merge request](gitlab-org/gitlab!142893))
- [Fix mermaid diagrams in dark mode on linux](gitlab-org/gitlab@d99b43827dd67dc822d12e2c84715580e9d82d32) ([merge request](gitlab-org/gitlab!143459))
- [Fix webhooks to POST correct MR state after create](gitlab-org/gitlab@a7dbd4941d944e705f6d5196ec26e70ffa4ca193) ([merge request](gitlab-org/gitlab!143447))
- [Partial unique index on issuable-resource-links](gitlab-org/gitlab@96b575fcab74cee940bb904df4c69410c183b637) ([merge request](gitlab-org/gitlab!141549))
- [Use update services to unassign from issuables](gitlab-org/gitlab@dd6202dcbbde25adfbf19f9c922c9367677b5fcc) ([merge request](gitlab-org/gitlab!143045))
- [Fixes Rspec for FOSS edition](gitlab-org/gitlab@db7458bfe767acfe786f642724fdce849e23a1d6) ([merge request](gitlab-org/gitlab!143337))
- [Fix outdated pages brunch ci template](gitlab-org/gitlab@3e3b97e749c73029d31f3265977a9604895449b6) ([merge request](gitlab-org/gitlab!143336))
- [Update semver_dialects gem](gitlab-org/gitlab@7f8ebc1b288ed859c07ff0882e3a376bc3238263) ([merge request](gitlab-org/gitlab!143317)) **GitLab Enterprise Edition**
- [Remove archived projects from the group vulnerability report filter](gitlab-org/gitlab@71546ebc61c7f8192a6ac3500d6caa687ffb08a4) ([merge request](gitlab-org/gitlab!143315)) **GitLab Enterprise Edition**
- [Direct transfer: Handle case where bulk import status is nil](gitlab-org/gitlab@efe422a6cf870f56c669513f39d1a90a8eaef7e0) ([merge request](gitlab-org/gitlab!143291))
- [Make notification dropdown flippable](gitlab-org/gitlab@9924ba39ace06582286fdd0859e085dcda3133d7) by @bahek2462774 ([merge request](gitlab-org/gitlab!143257))
- [Update Kontra security training token](gitlab-org/gitlab@14e39c931d6e212bd2cc38c90402d8a46be1cfca) ([merge request](gitlab-org/gitlab!143277)) **GitLab Enterprise Edition**
- [Geo: Fix verification timeout of registry records](gitlab-org/gitlab@7987099fb9efcadefb7bc99e35fa4a5f35f5b027) ([merge request](gitlab-org/gitlab!143162)) **GitLab Enterprise Edition**
- [Fix alignment of note emoji btn on hover](gitlab-org/gitlab@a538c625b70a3134134962e89ec009016c4ef4f8) ([merge request](gitlab-org/gitlab!142834))
- [Fix email update on LDAP sync](gitlab-org/gitlab@9ccfd178cc6fc635e126060401169107983a11dd) ([merge request](gitlab-org/gitlab!142796)) **GitLab Enterprise Edition**
- [Downcase checksum in with_file_sha256 nuget symbol scope](gitlab-org/gitlab@c7fcbaae6a00824b26ab34985108cbc1ebd489c2) ([merge request](gitlab-org/gitlab!143262))
- [Fix epic subscription](gitlab-org/gitlab@784431025b22d9f4913c0a71d82704eaa16387f7) ([merge request](gitlab-org/gitlab!143249))
- [Hide draft comment note text when editing the comment](gitlab-org/gitlab@e69a7b72935aa07be8d0f22d43f960158200a481) ([merge request](gitlab-org/gitlab!142852))
- [Update star count component to work when logged out](gitlab-org/gitlab@dac9451e00251183a8571047f7db4ab425c9c946) by @espadav8 ([merge request](gitlab-org/gitlab!143047))
- [Add worker to sync approval rules with preexisting state](gitlab-org/gitlab@78678693be8d3d2a8cb407fa85f84c01b529d436) ([merge request](gitlab-org/gitlab!141095)) **GitLab Enterprise Edition**
- [Make sure the key attribute is unique](gitlab-org/gitlab@04442157e3d873616105646f3c48d2b54c3b75cd) ([merge request](gitlab-org/gitlab!143170))
- [This MR fixes code source selection](gitlab-org/gitlab@2d9a38724a93c9a392a12ae5f213c9875b33e72a) ([merge request](gitlab-org/gitlab!143008)) **GitLab Enterprise Edition**
- [This MR fixes adding extra characters](gitlab-org/gitlab@272e56176fec6cedb0457f4262c1f16933440189) ([merge request](gitlab-org/gitlab!143068)) **GitLab Enterprise Edition**
- [Redirect to correct page after dashboard SAML reauth](gitlab-org/gitlab@b5ce814f260b908baaeb0616735d96e51016d47f) ([merge request](gitlab-org/gitlab!142933)) **GitLab Enterprise Edition**
- [Fix vulnerability statistics adjustment service](gitlab-org/gitlab@d6d21d6662e9d74698ab5a4d002623d889229e5d) ([merge request](gitlab-org/gitlab!142684)) **GitLab Enterprise Edition**
- [Make nuget symbol files search case-insensitive](gitlab-org/gitlab@dd6abc7d74b58aba7312054535369620433a207f) ([merge request](gitlab-org/gitlab!142723))
- [Use `hidden` to prevent scollbars on inline math](gitlab-org/gitlab@30b6b1b3b4db4a1295363db86a456b77a35ec30d) ([merge request](gitlab-org/gitlab!142972))
- [Fix Members::DestroyService audit bug with removing subresources](gitlab-org/gitlab@d5bad07ac2762b488e1723adcb773673f7208273) ([merge request](gitlab-org/gitlab!142058)) **GitLab Enterprise Edition**
- [Use static list for dependency list licenses](gitlab-org/gitlab@a7f72c086f0a11deaa6d3a9704cde82543cb1907) ([merge request](gitlab-org/gitlab!142695)) **GitLab Enterprise Edition**
- [Fix invalid records with FK not valid](gitlab-org/gitlab@36bcd8b69954b22d3a0a4f6873e7799a6535089f) ([merge request](gitlab-org/gitlab!142896))
- [Only set CI_HAS_OPEN_REQUIREMENTS when licensed](gitlab-org/gitlab@1cb715e259818a485592f863cfc4aad702e25f82) ([merge request](gitlab-org/gitlab!142917)) **GitLab Enterprise Edition**
- [Emoji Picker button hover misalignment fix](gitlab-org/gitlab@a701195f5653a2e33dff464ad7ef91c3a4b039dd) ([merge request](gitlab-org/gitlab!142908))
- [Respect inherited font-size in markdown code block](gitlab-org/gitlab@50f378808d6417a0c9156de46e587f1332da27db) ([merge request](gitlab-org/gitlab!142882))
- [Load filter targets dynamically](gitlab-org/gitlab@be6147f9f39693d8394ad7d8a0513cd23efda433) ([merge request](gitlab-org/gitlab!142871)) **GitLab Enterprise Edition**
- [Allow non-development environments to perform local project imports](gitlab-org/gitlab@750d3d53b3132122da505ea85be6e818e6d8c127) ([merge request](gitlab-org/gitlab!142835))
- [Use active and correct add_on_purchase](gitlab-org/gitlab@cbab87474efb6a4847ffcdb90f1ab12ba79714e8) ([merge request](gitlab-org/gitlab!142812)) **GitLab Enterprise Edition**
- [Remove transaction around object pool mirroring](gitlab-org/gitlab@46218a4785f73a10641bf5e4d04e1f75182cc48f) ([merge request](gitlab-org/gitlab!142822))
- [Fix 403 error when using job token to access public project](gitlab-org/gitlab@16bb8da9f665fa751216f3c546e63e23a5366977) ([merge request](gitlab-org/gitlab!140903))
- [Fix creation of instance-level member roles](gitlab-org/gitlab@7012eb7c573ff08a306974dcdfd8c8d2ee06b27d) ([merge request](gitlab-org/gitlab!142636)) **GitLab Enterprise Edition**
- [Handle invalid API JSON input gracefully](gitlab-org/gitlab@8a98dadd5fbc3f6b3a1c014722c91e1c3c0a200c) ([merge request](gitlab-org/gitlab!142741))
- [Change SAML group lock self-managed to work on group sync and group SAML](gitlab-org/gitlab@0628a873297793a284b19acafed738f9addbfe9f) ([merge request](gitlab-org/gitlab!137579)) **GitLab Enterprise Edition**
- [Stop allowing approvals to be changed post merge](gitlab-org/gitlab@7c565585a5dc7493a923c32ed8e2d51b434fce1c) ([merge request](gitlab-org/gitlab!142705))
- [Use LFS change size for pushes, not total size](gitlab-org/gitlab@1c1b1d99893428289da0c6136fb2c98289bf653e) ([merge request](gitlab-org/gitlab!140604)) **GitLab Enterprise Edition**
- [Fix NoMethodError from Projects::BlobController#show](gitlab-org/gitlab@108c095516baecab239b6b732ba6c91f6164035c) ([merge request](gitlab-org/gitlab!142701)) **GitLab Enterprise Edition**
- [Disable pipeline_stage_set_last_modified FF](gitlab-org/gitlab@2a603c45f36c43a368b3cb42baaa7209b7213846) ([merge request](gitlab-org/gitlab!142683))
- [Fix breadcrumb and page title for Wiki/New page](gitlab-org/gitlab@bb24ab345d1ced58940559249a45d8e2e73c2a75) ([merge request](gitlab-org/gitlab!142416))
- [Only perform workspace agent validation on create](gitlab-org/gitlab@ad8808c16bb0e497a6d46b5a48a744dab246c818) ([merge request](gitlab-org/gitlab!142654)) **GitLab Enterprise Edition**
- [Fix issue search when created from another locale](gitlab-org/gitlab@7a3168c37303df3255398130c5ab85702ead19cf) ([merge request](gitlab-org/gitlab!142652))
- [Revert: Fix pages with case sensitive paths](gitlab-org/gitlab@d60f35d72201169d111ded6385c208b45ea26882) ([merge request](gitlab-org/gitlab!142638))
- [Execute hooks from timelog create service](gitlab-org/gitlab@d3298520740455a446479b1843acacaa580a1acf) by @zillemarco ([merge request](gitlab-org/gitlab!141916))
- [Fix punctuation on profile edit page](gitlab-org/gitlab@53817f4fdf1479b2a1191f7d13cf1ac6263d6ea5) ([merge request](gitlab-org/gitlab!142472))
- [Fix error in Mapper::Normalizer when CI include value type is invalid](gitlab-org/gitlab@c04f536620d53dfc175668d3abbf6c50861ea7bc) ([merge request](gitlab-org/gitlab!142616))
- [Bump semver_dialects gem](gitlab-org/gitlab@9fb4fae8bf2f0ed854cfbbf8b232d48fb1043f19) ([merge request](gitlab-org/gitlab!142607))
- [Fix Gitlab::Llm::Completions::Chat default value for the options param](gitlab-org/gitlab@df476fe9ddd2f71ba4b9ee69b02b4f603bee9de4) ([merge request](gitlab-org/gitlab!142084)) **GitLab Enterprise Edition**
- [Fix current_license_title namespace translation](gitlab-org/gitlab@6f64497263b61435e0e7e05cd7c4dbf3b1200b43) ([merge request](gitlab-org/gitlab!142587))
- [Truncate commit author on blame view when under 3 lines](gitlab-org/gitlab@36df40d1a3ab6292e1a4a1cff74722afd0bc9683) ([merge request](gitlab-org/gitlab!142043))
- [Fix action/rule deletion bug](gitlab-org/gitlab@710e25c8adbabda357440ca31aab50e80e485cea) ([merge request](gitlab-org/gitlab!140533)) **GitLab Enterprise Edition**
- [Vulnerability Details: Fix generic report types](gitlab-org/gitlab@4c5efd59b93adf9cab3d455d565cb24913254dc7) ([merge request](gitlab-org/gitlab!142220)) **GitLab Enterprise Edition**
- [Group dropdown on New Project page respects visibility settings](gitlab-org/gitlab@65a1e7fdb6813fc0e86a7130dd840dcb8fef57b6) ([merge request](gitlab-org/gitlab!140853))
- [Add with-header class to root element in minimal and devise empty views](gitlab-org/gitlab@84a7d2845bc487476ad4c1c5f3fbd84219dc1f1b) ([merge request](gitlab-org/gitlab!142079))
- [Set modal title to finding title](gitlab-org/gitlab@ce24424f093d245fe2ed4a1a4a10d92a89a04120) ([merge request](gitlab-org/gitlab!142140)) **GitLab Enterprise Edition**
- [Defer ConnectionPool instrumentation setup](gitlab-org/gitlab@747a5ed7e16737b3793598265e55a90cc2b55c6f) ([merge request](gitlab-org/gitlab!142042))
- [Create merge request button: Fix spacing in dropdown](gitlab-org/gitlab@f3c70dc2bf1e3d073d38510bd8fc97c2d735c36a) ([merge request](gitlab-org/gitlab!142184))
- [Improve decimal precision for small VSD metric values](gitlab-org/gitlab@05654fe07da6c07b654a675ac35ebfb9c7e1433a) ([merge request](gitlab-org/gitlab!141450)) **GitLab Enterprise Edition**
- [Update review button variant](gitlab-org/gitlab@0476bcf36776a11877907291f3d0cb46ffcc36a7) ([merge request](gitlab-org/gitlab!142245))
- [Fix issue with pasting images in RTE](gitlab-org/gitlab@391f84db218a67f205fa9164b933c30f58c88899) ([merge request](gitlab-org/gitlab!142244))
- [Referencing a user with "me" could result in an incorrect quick action](gitlab-org/gitlab@61ef25232ec9152bff185b386998e25db7778447) ([merge request](gitlab-org/gitlab!139712)) **GitLab Enterprise Edition**
- [Update nullable on author field on NoteType](gitlab-org/gitlab@801077b3c883bfba3f4d8b2266a9fdb58654dfa3) ([merge request](gitlab-org/gitlab!142206))
- [Allow non-admin access to user activities](gitlab-org/gitlab@fb7c8382fb1d6d10d6e63b77b34ecd811bd7de1a) ([merge request](gitlab-org/gitlab!141767))
- [Add team members to policy project only when not added for the group](gitlab-org/gitlab@2dee7c5f97ca5c09bca84634db6db6233091d330) ([merge request](gitlab-org/gitlab!141592)) **GitLab Enterprise Edition**
- [Use component_version_id instead component_id for](gitlab-org/gitlab@baa4a0de591bc493047b295fb67d8e9dd7beb3a6) ([merge request](gitlab-org/gitlab!142161)) **GitLab Enterprise Edition**
- [Fix pages with case sensitive paths](gitlab-org/gitlab@3a456fdee226a896357077f7c08028bc06f76acc) ([merge request](gitlab-org/gitlab!142188))
- [Ensure SVGs are properly compiled](gitlab-org/gitlab@f66e091a8da330dc0a28fd77d143267aff377467) ([merge request](gitlab-org/gitlab!141548))
- [Fix source code highlighting when using relative URL](gitlab-org/gitlab@9165b5fce9b3f1ed895356ff1c04ea96ba9edf96) ([merge request](gitlab-org/gitlab!141984))
- [Fixes project export task issue](gitlab-org/gitlab@f245593f8be5e099caa64f433079b7e4657b1ec1) ([merge request](gitlab-org/gitlab!142039))
- [Use different localStorage sorting key](gitlab-org/gitlab@fca67af7956a997e65aa4fd6c0fc4e55fba1547b) by @bahek2462774 ([merge request](gitlab-org/gitlab!141937))
- [Remember BACKUP for untarred backups](gitlab-org/gitlab@cc44a9dbd8288e3c48056e931eb65303daffd3b0) ([merge request](gitlab-org/gitlab!141440))
- [Nullify `dismissal_reason` when a vulnerability is un-dismissed](gitlab-org/gitlab@6420d0f7e9304bb226f371712476821e00eccd86) ([merge request](gitlab-org/gitlab!141245)) **GitLab Enterprise Edition**
- [Fix GitLab typo in empty state group page](gitlab-org/gitlab@73de2e4149434eb3bcd9dc919058ec9adcdaaf59) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/141895))
- [MR Media report widget alignment fix](gitlab-org/gitlab@1edbfa9ac6fbe5042418deffb01a90ad83f4533a) ([merge request](gitlab-org/gitlab!141981))
- [Hide viz designer button until product analytics onboarded](gitlab-org/gitlab@afb4d54cbaa92a9cbff664ff02ae5c49c6dac9a1) ([merge request](gitlab-org/gitlab!141325)) **GitLab Enterprise Edition**
- [Update RTV and ETV to use subscription ID](gitlab-org/gitlab@bc97b923570a677d48a6044e77cb585552acc89b) ([merge request](gitlab-org/gitlab!140884)) **GitLab Enterprise Edition**
- [Diff controls alignment fix](gitlab-org/gitlab@39baea28294eba3e27010b9ae917714848f2db7a) ([merge request](gitlab-org/gitlab!141979))
- [Validate repo import scope](gitlab-org/gitlab@9a33f82f4c5c893dd81467cec93b350203b5788d) ([merge request](gitlab-org/gitlab!141762))
- [Add VulnerabilitiesFinder for scan result policies](gitlab-org/gitlab@cef6c3b8089b6af5c570626152f175bb4caee3c7) ([merge request](gitlab-org/gitlab!141052)) **GitLab Enterprise Edition**
- [Issues list: spacing between labels](gitlab-org/gitlab@95dbe008aba60342195bfa4939371fd1099319f0) ([merge request](gitlab-org/gitlab!141760))
- [Resolve feedback banner not showing on the behavior dashboard](gitlab-org/gitlab@8ba4e5dcecf39baa7f15a1b525d39032ae91d43f) ([merge request](gitlab-org/gitlab!141753)) **GitLab Enterprise Edition**
- [Unify dividing line color in commit info-well](gitlab-org/gitlab@71257740d9dc9db05cec169424e0ab2dbd3eb63d) ([merge request](gitlab-org/gitlab!141652))

### Changed (209 changes)

- [Show subscription next term start date](gitlab-org/gitlab@332f61ca39f679119b8a70fef16750945e9d4ff8) ([merge request](gitlab-org/gitlab!143439)) **GitLab Enterprise Edition**
- [Filter out unlincensed work item widget definitions](gitlab-org/gitlab@2a043c41234fc8294b6d2b17f93fb5bb35d442d5) ([merge request](gitlab-org/gitlab!142746)) **GitLab Enterprise Edition**
- [Add rails payload to zoekt indexing callbacks](gitlab-org/gitlab@26e5ab8db15025ff890c0cad6ca295eb08505818) ([merge request](gitlab-org/gitlab!142865)) **GitLab Enterprise Edition**
- [Update deployment tests to vue 3](gitlab-org/gitlab@fef86060fb9e44c788541e6a293e9da2e94bea5a) ([merge request](gitlab-org/gitlab!144367))
- [Update comment form tests for vue 3](gitlab-org/gitlab@9a983ab621bc45615db41a0c7a0aff3e30319750) ([merge request](gitlab-org/gitlab!144366))
- [Reorganize profile page layout](gitlab-org/gitlab@2934d5a2a640d195cb0c8df6f3d22d373cc88799) ([merge request](gitlab-org/gitlab!137024))
- [Enable CRM by default](gitlab-org/gitlab@55f027781facbcabdce3aab3feb4d1ae7b143faf) ([merge request](gitlab-org/gitlab!108378))
- [Uses similarity sort for projects query](gitlab-org/gitlab@3ea9934ef98d8fd4d192dabb174b639cd57e46f1) ([merge request](gitlab-org/gitlab!144363))
- [Fixing rubocop exceptions no. 7](gitlab-org/gitlab@48c5d6af6c42633e4d905c8886f43eaadc5c1ec5) ([merge request](gitlab-org/gitlab!144060))
- [Remove `determine_blank_ref_based_on_gitaly_object_format` feature flag](gitlab-org/gitlab@3498dfc49f5d41647a6ee04a9af63a5339a013f1) ([merge request](gitlab-org/gitlab!144306))
- [Changes for optimizing expiring worker](gitlab-org/gitlab@24d80c655bc42b85faa25fd4d31816b741edbd96) ([merge request](gitlab-org/gitlab!144063))
- [Add group by dropdown on adherence report](gitlab-org/gitlab@c3825697aa2443015295c22afab58831c3d0a380) ([merge request](gitlab-org/gitlab!143557)) **GitLab Enterprise Edition**
- [Reposition catalog setting](gitlab-org/gitlab@6ac46b5ab0b832555b115e8d59426e8da7a9dc84) by @jzeng88 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/144256))
- [Improve analytics settings copy](gitlab-org/gitlab@8d4c76102a651b32e2ec658bbc8a8451b5e80b3a) ([merge request](gitlab-org/gitlab!144264)) **GitLab Enterprise Edition**
- [Migrate label empty state component](gitlab-org/gitlab@08a9d3910ba107fbcc44c0ac65735c9b366ff6d5) ([merge request](gitlab-org/gitlab!144064))
- [Pipeline manual action: Migrate dropdown to GlDisclosureDropdown](gitlab-org/gitlab@87c40a31cb5b29d6c68e4dffc8c41ebe73aaa7b2) ([merge request](gitlab-org/gitlab!143092))
- [Update old Geo DB docs link](gitlab-org/gitlab@e2d1c72d59ebad5e4eb0bccec82b99dba1ac1893) ([merge request](gitlab-org/gitlab!142932)) **GitLab Enterprise Edition**
- [Replace UI usages of shared runner with instance runner](gitlab-org/gitlab@765bbac324a81bd4e990875560dff9cf1dfb7810) ([merge request](gitlab-org/gitlab!143480))
- [Show alert in CI Variable drawer](gitlab-org/gitlab@545f3e784e6709ac162ec86ac67090408e060431) ([merge request](gitlab-org/gitlab!143901))
- [Rewrite Cloud Connector architecture docs](gitlab-org/gitlab@04ba8a1e0369fc72fbef50ac4c9621e72369b8f5) ([merge request](gitlab-org/gitlab!143538))
- [Fix security policy source to not trigger pipelines for tags](gitlab-org/gitlab@50894d0931cfdf2a652849a4676c095780b2bced) ([merge request](gitlab-org/gitlab!143089))
- [Enhance navigation in findings drawer with tooltip and button group](gitlab-org/gitlab@08df56dcb103340913f809004a9734edebe9eca7) ([merge request](gitlab-org/gitlab!143942)) **GitLab Enterprise Edition**
- [Add new integration logos](gitlab-org/gitlab@fcf1ea87634a70ceb0d7a5e3a14649771f099786) ([merge request](gitlab-org/gitlab!143945))
- [Premium customers can use GitLab Duo Chat](gitlab-org/gitlab@ddf5034094daf4bbfdf5f94c171f8c10f3a983af) ([merge request](gitlab-org/gitlab!142808)) **GitLab Enterprise Edition**
- [Set minimum Redis version in system check to 6.0.0](gitlab-org/gitlab@7aff713bce676a49a1504ab500dd635808283e9a) ([merge request](gitlab-org/gitlab!143643))
- [Add new route /bulk_imports/:id/history](gitlab-org/gitlab@a9858666566b3b9477ff5eae78e02f4b94fc42ff) ([merge request](gitlab-org/gitlab!143322))
- [Add tooltip with help docs to license scanning widget](gitlab-org/gitlab@123d60836dd352abc1e03e28420eaacbe830ef8f) ([merge request](gitlab-org/gitlab!144072))
- [Fixing rubocop exceptions in tests no 8](gitlab-org/gitlab@102eb807715e727caf883902d1072c64f5acff76) ([merge request](gitlab-org/gitlab!144080))
- [Fixes issue actions presentation at small size](gitlab-org/gitlab@1562926f5d1dffa7a23aa6f2c75f1572c6721f4a) ([merge request](gitlab-org/gitlab!144073))
- [Add runner usage breakdown to dashboard](gitlab-org/gitlab@20007fea48361e6e0650c86538dd05d34b877b6b) ([merge request](gitlab-org/gitlab!143680)) **GitLab Enterprise Edition**
- [Remove .borderless, .nav-links-unboxed](gitlab-org/gitlab@49625137f004a720161c5c61beec5318a5d22e10) ([merge request](gitlab-org/gitlab!143933))
- [Support nested arrays in CI config `stages`](gitlab-org/gitlab@24d85084d6a5eff195b2ba1a0b487474385bf1aa) by @suyash-chavan ([merge request](gitlab-org/gitlab!142916))
- [Expose committed_before and committed_after](gitlab-org/gitlab@53de24d78ed29fc64a422a8b63ae1d422610d152) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/143354))
- [Update GITLAB_PAGES_VERSION](gitlab-org/gitlab@fec61ffdf2056102bb76c471430db03c0f02376b) ([merge request](gitlab-org/gitlab!144024))
- [Use 'last_activity_at' for project list order by last updated](gitlab-org/gitlab@d69b9d65321f97b5f44cbc6bcda173762d6ca86b) ([merge request](gitlab-org/gitlab!143054))
- [Add import stats to bulk_import_history_app](gitlab-org/gitlab@aa779d93e3bdfa1bec64ec0c10c6a6b770bde9b6) ([merge request](gitlab-org/gitlab!143776))
- [Invite Group Modal - Use new API on project view](gitlab-org/gitlab@a3cafefa378ac7ba3eac3a5528d2b2087052c722) ([merge request](gitlab-org/gitlab!143431))
- [Disable new schedule button](gitlab-org/gitlab@82380af6a76c58428f4be095be7772d93e955892) ([merge request](gitlab-org/gitlab!143669))
- [Remove `compliance_standards_adherence_csv_export` feature flag](gitlab-org/gitlab@d2cf0bd03129be8fb383b58e1a1db809ba014129) ([merge request](gitlab-org/gitlab!143397)) **GitLab Enterprise Edition**
- [Rename Infrastructure Registry page title to Terraform Module Registry](gitlab-org/gitlab@5b4c8e19493961d9d51312847494cc37231361bb) ([merge request](gitlab-org/gitlab!143599))
- [This MR changes flow for compliance framework](gitlab-org/gitlab@fbed514e66f3db53f3121b216b89ab9a19458cbf) ([merge request](gitlab-org/gitlab!143442)) **GitLab Enterprise Edition**
- [Show various MR keyboard shortcuts in tooltips](gitlab-org/gitlab@817076618f1c5a937b3db5359bcdeb710095c621) ([merge request](gitlab-org/gitlab!143088))
- [Migrates .d-md-flex to .gl-md-display-flex!](gitlab-org/gitlab@b5794c3424553bef95fa28c19e66dbc2c74530b6) ([merge request](gitlab-org/gitlab!143225))
- [Add approvalPolicies field and deprecate scanResultPolicies](gitlab-org/gitlab@ea278f57cd37d52f442a7e413a43475c0b79846e) ([merge request](gitlab-org/gitlab!142662)) **GitLab Enterprise Edition**
- [Replace taskable argument with name](gitlab-org/gitlab@5861fc16f202a9b9e4d54c0a49233ec4c7f5f23b) ([merge request](gitlab-org/gitlab!140074))
- [Align X Ray permission model to Duo Pro Add On](gitlab-org/gitlab@685c1caa432d90a0507d146e04654d66753f767b) ([merge request](gitlab-org/gitlab!143798)) **GitLab Enterprise Edition**
- [Move order of collaborators import](gitlab-org/gitlab@ecef4593b2e003eecab9a7ad2177a23ba2ebf57e) ([merge request](gitlab-org/gitlab!142732))
- [Update permissions for adding a child issue to an epic](gitlab-org/gitlab@cf1934f55851b357a0601fde4648f1c3c8456cc1) ([merge request](gitlab-org/gitlab!136322))
- [Enable dora_performers_score_panel feature flag by default](gitlab-org/gitlab@20d8f1262055b260dc817230b2cbb7f4dd1376eb) ([merge request](gitlab-org/gitlab!143711)) **GitLab Enterprise Edition**
- [Update ui text for MR comment filters](gitlab-org/gitlab@8a7eb400ac9c47204755fe408b42d440e4bcba72) ([merge request](gitlab-org/gitlab!143700))
- [Auto approve pending members on user cap disable](gitlab-org/gitlab@1d3fb482a0fbc025c157aa2c4403c8b1ac973590) ([merge request](gitlab-org/gitlab!142711)) **GitLab Enterprise Edition**
- [Update sbom occurrence source fields ingestion](gitlab-org/gitlab@369f70468494911a521ac2652b4472ffddd499c0) ([merge request](gitlab-org/gitlab!140282)) **GitLab Enterprise Edition**
- [Pipeline MiniGraph: Migrate dropdown to GlDisclosureDropdown](gitlab-org/gitlab@f954ec9288a0b459a571cbb4b7c3949a704b6821) ([merge request](gitlab-org/gitlab!142427))
- [Add severity sort for group level dependencies](gitlab-org/gitlab@b5e23fe4195d2de78473350bc0b7c61d77a8d39b) ([merge request](gitlab-org/gitlab!143087)) **GitLab Enterprise Edition**
- [Refine Add code task copy](gitlab-org/gitlab@dfdb0a19f4ebcd59c618f8b5fa527c368b795578) ([merge request](gitlab-org/gitlab!143641)) **GitLab Enterprise Edition**
- [Update help text for GitHub import PAT field](gitlab-org/gitlab@e9a1ebbaf222ec62df77479784b95a412a733a42) ([merge request](gitlab-org/gitlab!143042))
- [Migrate buttons in overflow_warning_component.rb](gitlab-org/gitlab@0916c7470f6eb31a7514dbe7bd361edcaa84e186) ([merge request](gitlab-org/gitlab!142956))
- [Add delimiters to large numbers in analytics chart tooltips](gitlab-org/gitlab@2b7b2f8d01dc6971c8db2458a4316de6d94ff428) ([merge request](gitlab-org/gitlab!141729)) **GitLab Enterprise Edition**
- [Remove code_suggestions_claude21 flag](gitlab-org/gitlab@922a127849bdc6862feb14793bec2c8dddf82839) ([merge request](gitlab-org/gitlab!142517)) **GitLab Enterprise Edition**
- [Use container registry API to fetch a tag](gitlab-org/gitlab@e37476b209127bdef105d9f11454345d6b1bab0e) ([merge request](gitlab-org/gitlab!143624))
- [Update dependency auto-deploy-image to v2.80.1](gitlab-org/gitlab@c1008124419a70d94283c7a1e99d80f2ee9ea623) ([merge request](gitlab-org/gitlab!143454))
- [Update styles for services table](gitlab-org/gitlab@7fa11632bf67fb08a585f6b5682c3bb2f22e0bc2) ([merge request](gitlab-org/gitlab!142324))
- [Remove CRM organizations navigation menu item](gitlab-org/gitlab@1b3027e1e7323d06f79f0eff3fe9fe22869e63c7) ([merge request](gitlab-org/gitlab!142984))
- [Updated URLs for "Issues closed" links in Value Streams Dashboard](gitlab-org/gitlab@ab7eafd3781a1cb6cbbc781d8022870b6ebdc6c0) ([merge request](gitlab-org/gitlab!143142))
- [Migrates full width class](gitlab-org/gitlab@1368185ca396771f676e0e3b354ff1af93a5a44a) ([merge request](gitlab-org/gitlab!143179))
- [Remove projectPath argument from ciCatalogResourcesResolver](gitlab-org/gitlab@d319fbcf5f1dc9c859d19654e15e314e3525768a) ([merge request](gitlab-org/gitlab!143194))
- [Migrates height utility classes](gitlab-org/gitlab@18bde32b1bc886cba1645cb861184e8f69e71cac) ([merge request](gitlab-org/gitlab!143185))
- [Use radio buttons for admin group permission](gitlab-org/gitlab@fc2e88836cd126d592cfa157b19a2d4f5e6190de) ([merge request](gitlab-org/gitlab!143424))
- [Add GlSingleStat to haml](gitlab-org/gitlab@53a51f5d127b3adbb772964cbe8e27ab19d9675f) ([merge request](gitlab-org/gitlab!142682))
- [Remove `scan_result_policy_merge_base_pipeline` feature flag](gitlab-org/gitlab@d9fb7ad67ad4373a76c1d518ec6c18b5b4032b6b) ([merge request](gitlab-org/gitlab!142830))
- [Adds `jira_connect_public_key_storage_enabled` field](gitlab-org/gitlab@8fb21b6930e0f982e831093e11fc566da3354ba0) ([merge request](gitlab-org/gitlab!143265))
- [Custom role UI enhancements](gitlab-org/gitlab@fb3c552029fbb810e7f505714d872b1c3cf584f2) ([merge request](gitlab-org/gitlab!141887)) **GitLab Enterprise Edition**
- [Detect usage of pinned nav item and handle section expanded state](gitlab-org/gitlab@bb5d7e320e4e831b3a063a28c7ea2a6eb848a719) ([merge request](gitlab-org/gitlab!142430))
- [Do not pre-select group import target namespaces](gitlab-org/gitlab@2d7fe46438c6f0a245d86d2c6a8f935d9f7ad69e) ([merge request](gitlab-org/gitlab!142265))
- [Remove use_cloud_connector_lb feature flag](gitlab-org/gitlab@19747da6dcecbe4dfffe35f0785f95e8b4edf7be) ([merge request](gitlab-org/gitlab!142564))
- [Update policy type param for editing to use approval_policy](gitlab-org/gitlab@59a37392c20ed09a398766b4705cbefffe236323) ([merge request](gitlab-org/gitlab!143062)) **GitLab Enterprise Edition**
- [Add limits for license names](gitlab-org/gitlab@5e950bd501f2b8c01ea7dd61598f63f354ba35d1) ([merge request](gitlab-org/gitlab!143137)) **GitLab Enterprise Edition**
- [Migrate float-right to gl-float-right](gitlab-org/gitlab@3ab9200bf7db26f0451ac0da2c7e365cc9ec3cb4) ([merge request](gitlab-org/gitlab!143260))
- [This MR changes schema for external file path](gitlab-org/gitlab@b4a1a4054b96b8cbba04f332541ca8396c48a988) ([merge request](gitlab-org/gitlab!143095)) **GitLab Enterprise Edition**
- [WorkItemDelete mutations handle group](gitlab-org/gitlab@07079c2ba3c8f41b6977267b526dda3f160bb306) by @imskr ([merge request](gitlab-org/gitlab!141044))
- [Add blame data to simple viewer](gitlab-org/gitlab@c160a5c76b6062226a58659d6675eed337b41e71) ([merge request](gitlab-org/gitlab!141377))
- [Hides user checkbox that allows group creation](gitlab-org/gitlab@60410ca9274a55bd1cc7f479eda16a8c7a81417d) ([merge request](gitlab-org/gitlab!138863))
- [Work item - mobile ancestors widget](gitlab-org/gitlab@7c1a99f3dcd6f9deec50cc87e31143410c3d090f) ([merge request](gitlab-org/gitlab!142388))
- [Migrates .align-items-center to .gl-align-items-center](gitlab-org/gitlab@88b103a8c37ae1de9a10f9b2e8153402fb3bb4bb) ([merge request](gitlab-org/gitlab!143183))
- [Refactor FindChangedPaths RPC call for initial commits](gitlab-org/gitlab@b7f95f3c08e0a244aaca29e2079f2398a8888572) ([merge request](gitlab-org/gitlab!143216))
- [Update match_on_inclusion to match_on_inclusion_license](gitlab-org/gitlab@d00eb911298ff2eca9b817157b1c6cfb23c0c77d) ([merge request](gitlab-org/gitlab!141931)) **GitLab Enterprise Edition**
- [Remove help text about creating groups when creating a project](gitlab-org/gitlab@aeff20523fc4e14d2417b8a8bf1e287a1318ca60) ([merge request](gitlab-org/gitlab!142942))
- [Allow local request origin when in dev](gitlab-org/gitlab@b3cf1cb7a89ba04c8afb36095420a0786d7b77b5) ([merge request](gitlab-org/gitlab!143227))
- [Add item_to_preload method in helper and migrations](gitlab-org/gitlab@d32f8908e54c6cf2a0810e21dec024243288ff4e) ([merge request](gitlab-org/gitlab!143035)) **GitLab Enterprise Edition**
- [Clean up caching importer](gitlab-org/gitlab@f97ce7f059e31b1d500e8dde07974585cb292539) by @imskr ([merge request](gitlab-org/gitlab!139395))
- [Remove todo for group_saml/sso_state_spec](gitlab-org/gitlab@93bf5ecfe974f182f412f833a7c30820ff6226cb) ([merge request](gitlab-org/gitlab!143210))
- [Add cleanup to testAuthServer](gitlab-org/gitlab@7b6a08ea48e6af42535697be80ec111510bf8538) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/143200))
- [Use finished deployments in Environments stop actions](gitlab-org/gitlab@0606f196ebddaad6af05477c0dfd7985cb61d013) ([merge request](gitlab-org/gitlab!141216))
- [Migrate .lh-100 to .gl-line-height-1](gitlab-org/gitlab@f5b98ed77ed3af7a3bd69d73035a4527149dd634) ([merge request](gitlab-org/gitlab!143184))
- [Remove sms_send_wait_time feature flag](gitlab-org/gitlab@9cf2df77e3949ca5055768dc7835f3dc24ef5a6c) ([merge request](gitlab-org/gitlab!143181))
- [Migrates flex-wrap](gitlab-org/gitlab@2ccb31526f4081e0f3973e517e7b22fdb40bdd6a) ([merge request](gitlab-org/gitlab!143178))
- [Enable github_import_lock_user_finder feature flag by default](gitlab-org/gitlab@d64dfe1ae2ec8e293fcb29c3b8ad0bad035f9134) ([merge request](gitlab-org/gitlab!143118))
- [Import resources using GitHub Import timeline API](gitlab-org/gitlab@61291d98dadef485f90bc42fab7f119cd4545216) ([merge request](gitlab-org/gitlab!143082))
- [Update dependency auto-deploy-image to v2.80.0](gitlab-org/gitlab@24691372f8048cd102d92e4046371ac11b6edf92) ([merge request](gitlab-org/gitlab!143097))
- [Implementing Trial Discover Page Experiment Stage 1](gitlab-org/gitlab@fcd080a98fd90f4bd9383484bce84fff356002fe) ([merge request](gitlab-org/gitlab!142824)) **GitLab Enterprise Edition**
- [Enable geo_proxy_check_pipeline_refs by default](gitlab-org/gitlab@e3d11a5d43e347388a9b02812399c0f97f847c40) ([merge request](gitlab-org/gitlab!142609)) **GitLab Enterprise Edition**
- [Show find file and permalink shortcut in tooltip](gitlab-org/gitlab@cfbbe8907f01220529218767c606320af5c8fe61) ([merge request](gitlab-org/gitlab!140979))
- [Improve dark-mode theme in sign in/up pages](gitlab-org/gitlab@e0ff9a3a5234365b35b96fbd27a3c3767b4de2fe) ([merge request](gitlab-org/gitlab!142656))
- [Hide keyboard shortcuts in tooltips when disabled](gitlab-org/gitlab@9a084be7f98220a9992d225688c8d2af3de121f7) ([merge request](gitlab-org/gitlab!143067)) **GitLab Enterprise Edition**
- [Update pipeline findings description and report label](gitlab-org/gitlab@5c701bf2d0ee3de1c6b48a8dff013e34e2cc82a7) ([merge request](gitlab-org/gitlab!142783)) **GitLab Enterprise Edition**
- [Migrate existing policy to approval_policy on replace](gitlab-org/gitlab@316ed26c5c494edc6904884deff2eb18603c8210) ([merge request](gitlab-org/gitlab!143055)) **GitLab Enterprise Edition**
- [Use traversal_ids for project search](gitlab-org/gitlab@8464b44673f0e14488eec0163ddfc8ee8ccfb797) ([merge request](gitlab-org/gitlab!142310)) **GitLab Enterprise Edition**
- [Add /remove_parent quick action for work items](gitlab-org/gitlab@5e8b892ef55f79bfd3ce38e3db7ac7ec796b4114) ([merge request](gitlab-org/gitlab!142174))
- [Change Web App Manifest `display` from `browser` to `standalone`](gitlab-org/gitlab@42a65f0ef5e3153104aa20d0a51d1f33720f0ba9) by @LasseRosenow ([merge request](gitlab-org/gitlab!139311))
- [Code dropdown: Migrate to GlDisclosureDropdown](gitlab-org/gitlab@17f29187ce6037235543961f3abf411f7372d2f1) ([merge request](gitlab-org/gitlab!142554))
- [Update dependency auto-deploy-image to v2.79.0](gitlab-org/gitlab@ec5225f8b3d6867dbffb85463305a10ab9de688f) ([merge request](gitlab-org/gitlab!143011))
- [Productize tier_badge experiment](gitlab-org/gitlab@fd8921b74720a5595d496bcebb6e5a917dc383d0) ([merge request](gitlab-org/gitlab!142437)) **GitLab Enterprise Edition**
- [Removes dot from edit board button](gitlab-org/gitlab@3a871d3d1dd664a04df807576d407f234da959a7) ([merge request](gitlab-org/gitlab!142579))
- [Support `approval_policy` in JSON schema](gitlab-org/gitlab@5a11de9d7f7e0aa806e165817c3cddf15e55ce11) ([merge request](gitlab-org/gitlab!142559)) **GitLab Enterprise Edition**
- [Update po files](gitlab-org/gitlab@bdec4bb332900d4fd66460e591866fcec6712a46) ([merge request](gitlab-org/gitlab!142353))
- [Set minimum Redis version in system check to v6.2.0](gitlab-org/gitlab@0586518d4b2662d214323a3783f581283517cd6a) ([merge request](gitlab-org/gitlab!142881))
- [Move runner description field under configuration](gitlab-org/gitlab@a5087149e52de70c075c8be137f40e2edc7ff2e3) ([merge request](gitlab-org/gitlab!142531))
- [Finalize UUID backfilling before column type migration cleanup occurs](gitlab-org/gitlab@e4a4b4b84ffdb62da00016ac0a942e45d89e25c7) ([merge request](gitlab-org/gitlab!142537))
- [Feat(Feature flag): remove key_contacts_management](gitlab-org/gitlab@ad468e2811c4abf31406d64a26f775a97476f66e) ([merge request](gitlab-org/gitlab!142578)) **GitLab Enterprise Edition**
- [Allow workhorse extra config command to have arguments](gitlab-org/gitlab@ab8b42ca5e4a838b900c0577ae9c4de3ce5baebd) ([merge request](gitlab-org/gitlab!142781))
- [Remove the prefix_ci_build_tokens feature flag](gitlab-org/gitlab@02f063d67fc609ec0ba6bed810fa5c9e42ac0976) ([merge request](gitlab-org/gitlab!142622))
- [Add component names to resource item](gitlab-org/gitlab@d04aeea24875dc074b98d94d4e5fabbce188193a) ([merge request](gitlab-org/gitlab!142240))
- [Emoji picker: Migrate dropdown to GlDisclosureDropdown](gitlab-org/gitlab@219529e676209c1e2bf7603d43e43d3dc1b9920a) ([merge request](gitlab-org/gitlab!142201))
- [Update gitlab-pages](gitlab-org/gitlab@a2b061279ca9cb3ce6e2e35a05f4e1357e10ac13) ([merge request](gitlab-org/gitlab!142698))
- [FF use_sync_service_token_worker enabled by default](gitlab-org/gitlab@68d09f6ae753c178bdd82ce64f9702be6a70ef96) ([merge request](gitlab-org/gitlab!142699))
- [Improve specs for GroupSaml::SsoState](gitlab-org/gitlab@1ed9e8e5c7162fe4be3bac3d5103cd3ca9803020) ([merge request](gitlab-org/gitlab!142697)) **GitLab Enterprise Edition**
- [Update vendor/spdx.json to v3.22](gitlab-org/gitlab@3d8092242e6777cb0a2deed1b5cfdf45fc0bd185) ([merge request](gitlab-org/gitlab!142603))
- [Update documentation](gitlab-org/gitlab@6a3397eaa3b79ff95037088dd10271d8d331645b) ([merge request](gitlab-org/gitlab!142568)) **GitLab Enterprise Edition**
- [Excludes Ml::Models from showing up on Experiments](gitlab-org/gitlab@2dd2d56069689ee2df8f932c7d892c6bf54c9ae7) ([merge request](gitlab-org/gitlab!142693))
- [Replace geo empty state illustration](gitlab-org/gitlab@1a94110ac1974d1cc498fbb08e61370f34bdcdb9) ([merge request](gitlab-org/gitlab!142163))
- [Use t.Cleanup for startWorkhorseServerWithConfig startWorkhorseServer](gitlab-org/gitlab@7ec62666145c726ccb605b177314555b2c729b4d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/142674))
- [Use t.Cleanup in upstream_test](gitlab-org/gitlab@1927032c7566cfa9f4ae6a6f70d954b80c6ec37b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/142678))
- [Use t.Cleanup in range_test](gitlab-org/gitlab@1404419fbdbee651ece19810a8675e56701f4fe6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/142668))
- [Use t.Cleanup in artifacts_upload_test](gitlab-org/gitlab@63af9c580f6251456a57843ec6b869592915bf39) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/142673))
- [Add UI polish to issue analytics table](gitlab-org/gitlab@bb7c7d20d6d3fae5cac17b572a00880ed08f79ca) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/142596))
- [Simplify active_since?](gitlab-org/gitlab@2e0a902929195d6a34161d9f4cf30fb21dc6897a) ([merge request](gitlab-org/gitlab!142565)) **GitLab Enterprise Edition**
- [Admin area overview: Update stats component](gitlab-org/gitlab@98cd1f1d06853a26425f405f6835caa35170120a) ([merge request](gitlab-org/gitlab!142026))
- [Update character_set to v1.8.0](gitlab-org/gitlab@e3c95c7d19779fdf63fef16d5586b861edabca81) ([merge request](gitlab-org/gitlab!142606))
- [Copy adjustment for /billings page Duo Pro hand-raise PQL](gitlab-org/gitlab@e77f034f4b01e06c022646d27eb72e48dd9c7a4b) ([merge request](gitlab-org/gitlab!142417)) **GitLab Enterprise Edition**
- [Logs large IN lists](gitlab-org/gitlab@0318918f6e6cf8b20b28d98efdacbac4df32f796) ([merge request](gitlab-org/gitlab!141150))
- [Improvements in vertical spacing sign-in page](gitlab-org/gitlab@279b5ecdabf3fab0dc703a60008a02e51dcf2b51) ([merge request](gitlab-org/gitlab!142139))
- [Expose setting category on Internal Events for migration purposes (FE)](gitlab-org/gitlab@c8eac714d1a7f7d30f22b8410937dcab4060dfdb) ([merge request](gitlab-org/gitlab!142134))
- [This MR adds branch exceptions selector](gitlab-org/gitlab@17b756ad963b82007fc373a35bd31ca20b922681) ([merge request](gitlab-org/gitlab!141725)) **GitLab Enterprise Edition**
- [Improve avatar on vulnerability details page](gitlab-org/gitlab@56ebc823e85f1a65f9b44087808b8a3ef3f04be4) ([merge request](gitlab-org/gitlab!142319)) **GitLab Enterprise Edition**
- [Allow to revert/cherry-pick squashed MRs with FF strategy](gitlab-org/gitlab@2aefaebb9fa10720c64d875113a25c38a0a61b21) ([merge request](gitlab-org/gitlab!142152))
- [Move OWASP 2021 group behind a feature flag](gitlab-org/gitlab@c160b413dbb347f00b1d21b120de752e03f75682) ([merge request](gitlab-org/gitlab!142405)) **GitLab Enterprise Edition**
- [Format analytics dashboards data tables with delimiters](gitlab-org/gitlab@558ec2bb2a60a45f580d04efce4424c25ed97ded) ([merge request](gitlab-org/gitlab!141724)) **GitLab Enterprise Edition**
- [Group overview: Make items keyboard accessibile](gitlab-org/gitlab@1a95102dca6f8f89b8eda140192aa42ce3c00f98) ([merge request](gitlab-org/gitlab!141686))
- [Allow for DNS Zone change in RD Config](gitlab-org/gitlab@a179a8302d4dff4420694bfd4f725125c33a1867) ([merge request](gitlab-org/gitlab!137277)) **GitLab Enterprise Edition**
- [Remove the feature flag prefix_scim_tokens](gitlab-org/gitlab@6b839cbb50f4f316ff7cff0ae6c39c28598dc7f6) ([merge request](gitlab-org/gitlab!142260))
- [Add `includeArchived: true | false` to `groupProjects` graphQL](gitlab-org/gitlab@0aefcb67f23f6200b36216df3bdd0cbd01d6119c) ([merge request](gitlab-org/gitlab!142396))
- [Adds Application Setting](gitlab-org/gitlab@e57dbd6d1e11f4d119a6a6a34c842b0f0b12109f) ([merge request](gitlab-org/gitlab!141998))
- [Add Max Code indexing concurrency setting](gitlab-org/gitlab@320548db5209f6de1aea6683ccb59e6b35d6a29d) ([merge request](gitlab-org/gitlab!139968)) **GitLab Enterprise Edition**
- [Include subgroups in adherence export](gitlab-org/gitlab@663cf26a176803f0f62204e7ad720397f2d505b8) ([merge request](gitlab-org/gitlab!142355)) **GitLab Enterprise Edition**
- [Use content editor's serializer for copy_as_gfm](gitlab-org/gitlab@7a5806a60cef35b7b8a4b7a9d147b05e39c2c585) ([merge request](gitlab-org/gitlab!137152))
- [Allow embedding relative BMP images in markdown](gitlab-org/gitlab@941056e01aacfef380154e05f1d20fa6f14c652b) by @ignapk ([merge request](gitlab-org/gitlab!141711))
- [Spec approval service for instance SAML approval](gitlab-org/gitlab@e8772691fa4ec12267575ce3a28cbd48b2456dd9) ([merge request](gitlab-org/gitlab!142349)) **GitLab Enterprise Edition**
- [Add alert for user signed up with join a project option](gitlab-org/gitlab@6f5082a1e37428bf19db56470332ef25e834b6c7) ([merge request](gitlab-org/gitlab!142063)) **GitLab Enterprise Edition**
- [Enable sbom_occurrences_vulnerabilities FF](gitlab-org/gitlab@e6d73d0cffe3ae32763f7ef5f4026109323cd879) ([merge request](gitlab-org/gitlab!142330)) **GitLab Enterprise Edition**
- [Add a conditional for project or group avatar](gitlab-org/gitlab@cbd7a5caffc73e5e4eca9a6dce1fedb7f4875c79) ([merge request](gitlab-org/gitlab!142059))
- [Migrate milestone actions button to pajamas component](gitlab-org/gitlab@26a12b928452ceef08eb4dfb251821c4fb4c0ae8) ([merge request](gitlab-org/gitlab!142215))
- [Setup cssbundling-rails](gitlab-org/gitlab@fe9450ddb3df5b08dbdc3952042730475f9cf5b7) by @ar-mali ([merge request](gitlab-org/gitlab!140611))
- [Remove node backoffs for deletion and indexing requests](gitlab-org/gitlab@30f7367c64434fcf003e8231b3236865bde076ea) ([merge request](gitlab-org/gitlab!140806)) **GitLab Enterprise Edition**
- [Add a separate target for basic merge request search](gitlab-org/gitlab@c04ae49dc7efc76f03cf10f077cc61992432503b) ([merge request](gitlab-org/gitlab!142165))
- [Update dependency auto-deploy-image to v2.78.0](gitlab-org/gitlab@4b7fc7bd150e9194389a564f20b5089c81d56dd6) ([merge request](gitlab-org/gitlab!142096))
- [Support CS in PossiblyAffectedOccurrencesFinder](gitlab-org/gitlab@5d5fc26dc6ada6afab67d6452a0bc32fa08b88a9) ([merge request](gitlab-org/gitlab!136613)) **GitLab Enterprise Edition**
- [Migrate preview button in group templates](gitlab-org/gitlab@e5b932458bedd129a229330c1d20b477f47262cd) ([merge request](gitlab-org/gitlab!142233))
- [Migrate button in app/views/users/unsubscribes/show.html.haml](gitlab-org/gitlab@eab9965dad05c4bb4bbdecc2c1284d3989f848fb) ([merge request](gitlab-org/gitlab!142226))
- [Removes database migrations up to 15-9-stable-ee](gitlab-org/gitlab@febb89058f437a33ef43b99c37bf7475bd727176) ([merge request](gitlab-org/gitlab!139940))
- [Enable license_compliance_widget_category by default](gitlab-org/gitlab@2b73a3888dc97dc6aea41c2334e4ea24f7904c4b) ([merge request](gitlab-org/gitlab!142221)) **GitLab Enterprise Edition**
- [Noted lack of Duo Chat support in Web IDE on SM](gitlab-org/gitlab@2ff209f93a432be6f5db05208f2786bd3fd15cea) ([merge request](gitlab-org/gitlab!142144))
- [Remove unused file](gitlab-org/gitlab@ba562203256ccc88e86a20492682841a5fcbf2cd) ([merge request](gitlab-org/gitlab!142187))
- [Migrate buttons in awards_block.html.haml](gitlab-org/gitlab@05e418a213d95a62b9f23180e2b98955939d6d41) ([merge request](gitlab-org/gitlab!141930))
- [Update pipeline editor empty state](gitlab-org/gitlab@583b5397af752a4e091549022a7ab155323bea28) ([merge request](gitlab-org/gitlab!141862))
- [Remove true-up validation for cloud licenses](gitlab-org/gitlab@21b71a925518b1321a193cd4ee789c69cae6fb0b) ([merge request](gitlab-org/gitlab!142181)) **GitLab Enterprise Edition**
- [Updated copy for due pro hand-raise PQL on billings page](gitlab-org/gitlab@8d57a39890cc9adab8d6f3f3081bbeebdf6af59a) ([merge request](gitlab-org/gitlab!142013)) **GitLab Enterprise Edition**
- [Show Needs triage instead of DETECTED in finding modals](gitlab-org/gitlab@d0ab583cab1d459f8193e3361955b4ff4982f2f2) ([merge request](gitlab-org/gitlab!142148)) **GitLab Enterprise Edition**
- [Footer links disappear on small viewports](gitlab-org/gitlab@c405c7ce8bb3329b16ed9eff056817cb4eaf0e67) ([merge request](gitlab-org/gitlab!142145))
- [Clean CI usage w/ optional "deep clean" when banning users on GitLab.com](gitlab-org/gitlab@8026a2c3e029d5ef09fe61c2fc50395e92c3bbba) ([merge request](gitlab-org/gitlab!139218)) **GitLab Enterprise Edition**
- [Service accounts can be added to LDAP-synced groups](gitlab-org/gitlab@a2ec5c408808b82c5e75645f59b2fd3b94796bd1) ([merge request](gitlab-org/gitlab!139606)) **GitLab Enterprise Edition**
- [Migrate button in clone_panel to Pajamas component](gitlab-org/gitlab@dc9a45bb9aa8685243efbcbabdb170d665e9373a) ([merge request](gitlab-org/gitlab!142053))
- [Make review emails more readable](gitlab-org/gitlab@9dd833341856783442a5616416c11c43a827efd4) ([merge request](gitlab-org/gitlab!142047))
- [Add index for events to efficiently query user contributions [SYNC]](gitlab-org/gitlab@21a57ae1ba172f69abaeaae75848bd8d33e6a341) by @zzaakiirr ([merge request](gitlab-org/gitlab!141695))
- [Merge request approval widget: Use small button](gitlab-org/gitlab@3a0e33f34e1cd809826f8b0d0f23f1c3d67bfed9) ([merge request](gitlab-org/gitlab!142034))
- [Add approval group rule post endpoint](gitlab-org/gitlab@3a66940fe7a1d8da8dc7f3803a9d938d0885b127) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/137894)) **GitLab Enterprise Edition**
- [Show email on the user popover](gitlab-org/gitlab@bcf7ad044b7a82ca3b7f2766f169d64fa7a575a5) ([merge request](gitlab-org/gitlab!141780))
- [Admin area dashboard cleanup](gitlab-org/gitlab@984b596ccbcfab282b2d33e000090fc937dca605) ([merge request](gitlab-org/gitlab!141857))
- [Update pipeline illustrations](gitlab-org/gitlab@beb452d73a7ed6b69228a665a6b28b87e99990f1) ([merge request](gitlab-org/gitlab!139644))
- [Introduce separate targets for global search indexing](gitlab-org/gitlab@5ed63a92c27c9fd42b7ebb9862b6858f1d2da545) ([merge request](gitlab-org/gitlab!141960)) **GitLab Enterprise Edition**
- [Change importing alert to warning](gitlab-org/gitlab@887b3bd82b99b0d5a0b2568ed9bbf228aafc0fc0) ([merge request](gitlab-org/gitlab!141803))
- [Trims input fields in maven dependency proxy settings](gitlab-org/gitlab@7b815e82ff0fe9b81c5d8fc6f5458d4a13125296) ([merge request](gitlab-org/gitlab!141952))
- [Improve Cookie Preferences button on mobile](gitlab-org/gitlab@1cd9aed1b46595f906f4c945e886a2c02912eec9) ([merge request](gitlab-org/gitlab!141893))
- [Assignees button migration](gitlab-org/gitlab@6fa6734b2e4302751245a21ee4872d409c1852fa) ([merge request](gitlab-org/gitlab!141884))
- [Update dependency auto-deploy-image to v2.77.0](gitlab-org/gitlab@39e5659db987adcabcbba7bd08a61a48c960195f) ([merge request](gitlab-org/gitlab!141876))
- [Migrate {hll_counters}_i_code_review_create_mr from hll to int](gitlab-org/gitlab@4023471c70d3c8635eb16ee50ba9b2802327bc16) ([merge request](gitlab-org/gitlab!141809))
- [Add warning when project creation is noone](gitlab-org/gitlab@0e84c60395fd3125d4e6c1df017c90cf91bf94dd) ([merge request](gitlab-org/gitlab!140941))
- [Limit project description in sidebar](gitlab-org/gitlab@cf66e93ba2a73d370f676f0ccb1ee67bb3370e4c) ([merge request](gitlab-org/gitlab!141229))
- [Update project-level analytics settings strings](gitlab-org/gitlab@922e41c45a47a940e89d9fa4d2db54ea6881f60a) ([merge request](gitlab-org/gitlab!141860)) **GitLab Enterprise Edition**
- [Display the related MR's for the pipeline header](gitlab-org/gitlab@4edd170f3e34967a50676dc1c2b6370037ca506c) ([merge request](gitlab-org/gitlab!140501))
- [GitHub importer: Rename "link" as "attachment"](gitlab-org/gitlab@d1cbf58a2ea2842f660bb13dd6a76e0549855ef8) ([merge request](gitlab-org/gitlab!141823))
- [Removing FF persist_failed_pipelines_from_schedules](gitlab-org/gitlab@3760f2305993ba77d6025f7bde68aa4d61f4e7d1) ([merge request](gitlab-org/gitlab!141794))
- [Update FF with actor](gitlab-org/gitlab@b6cadabf8867ec6715919402d5eec847a9bfff2f) ([merge request](gitlab-org/gitlab!141772))
- [Remove feature flag package_metadata_advisory_sync](gitlab-org/gitlab@04340b57b8238686c62f153b7b532220170b2cc9) ([merge request](gitlab-org/gitlab!139889)) **GitLab Enterprise Edition**
- [Update tab name](gitlab-org/gitlab@df336ca1fa572b11b11a95e53cc55933b28afcb7) ([merge request](gitlab-org/gitlab!141654))
- [Fix accessibility issues in spam logs](gitlab-org/gitlab@bf115db011b09654e4333db42867f2903e4a7a9c) ([merge request](gitlab-org/gitlab!141517))
- [Allow multiple requirements for custom abilities](gitlab-org/gitlab@f20987f8646f0a10d5f5babb9e611d4e3d32b1af) ([merge request](gitlab-org/gitlab!141489)) **GitLab Enterprise Edition**
- [Update feature tests](gitlab-org/gitlab@2973d4374965375bb752efce2a23c26ab2c84682) ([merge request](gitlab-org/gitlab!141580))
- [Make security policy stages order take precedence](gitlab-org/gitlab@9a0ccca2011d7b987110477e729c32fec5c77b6e) ([merge request](gitlab-org/gitlab!141501)) **GitLab Enterprise Edition**
- [Remove bitbucket_importer_exponential_backoff feature flag](gitlab-org/gitlab@3eac3717e42b2bbbc731e093f83a236a0034fd93) ([merge request](gitlab-org/gitlab!140041))

### Deprecated (1 change)

- [Add deprecation for Ubuntu 18.04](gitlab-org/gitlab@a236d2772cc54085c2a244398c569c4bc9fc800f) ([merge request](gitlab-org/gitlab!141344))

### Removed (31 changes)

- [Remove repository renamed event code](gitlab-org/gitlab@9ba77596e1c9519347a1ec72e3b5ce370d3dca92) ([merge request](gitlab-org/gitlab!143446)) **GitLab Enterprise Edition**
- [Removes can_approve_deployment? method](gitlab-org/gitlab@bb8cd146893e0fde72fddb73f9cbac17d3c40efe) by @tedtran2019 ([merge request](gitlab-org/gitlab!140591)) **GitLab Enterprise Edition**
- [Delete two Sidekiq reliable_fetcher flags](gitlab-org/gitlab@a7f096ff08a992779de27e6bb15bca0e5f88f0d7) ([merge request](gitlab-org/gitlab!143970))
- [Remove ProjectRepositoryState model](gitlab-org/gitlab@1c368d3e331c428889a75ae902f409b2f9831630) ([merge request](gitlab-org/gitlab!143695)) **GitLab Enterprise Edition**
- [Delete the 'ci_accept_trace' feature flag](gitlab-org/gitlab@01bf571368cd9bdc41b338977f5ca7c5d1335082) ([merge request](gitlab-org/gitlab!144085))
- [Remove members_api_expose_enterprise_users_emails_only feature flag](gitlab-org/gitlab@29fab1a066568fd4f2c40e800ec4d6477ff5a992) ([merge request](gitlab-org/gitlab!144026)) **GitLab Enterprise Edition**
- [Clean up code suggestions non-owner alert](gitlab-org/gitlab@5b788b3251e6a7fb28804223116324a32dde865c) ([merge request](gitlab-org/gitlab!143862)) **GitLab Enterprise Edition**
- [Remove legacy hashed storage migration code](gitlab-org/gitlab@06db6416ec19eaa63a4cea2ec48838873f466fe2) ([merge request](gitlab-org/gitlab!143443)) **GitLab Enterprise Edition**
- [Remove readme_html field from Ci::Catalog::Resource](gitlab-org/gitlab@79fc87ede1465808a2075f0a879e95f69dfa5f1e) ([merge request](gitlab-org/gitlab!143525))
- [Remove bitbucket_server_convert_mentions_to_users](gitlab-org/gitlab@edc46e11a9eb63eddf1b16b4dcbebe9467a7032e) ([merge request](gitlab-org/gitlab!141859))
- [Remove pagination count](gitlab-org/gitlab@e35dc90ddc56c800d6c662e66d0f132982b3cdfa) ([merge request](gitlab-org/gitlab!141640))
- [Remove references to zoekt_indexed_namespaces and drop table](gitlab-org/gitlab@47efd6bfb2fcb2815b4e66c8c1414a319a601f8e) ([merge request](gitlab-org/gitlab!140906))
- [Remove project_overwrite_service_tracking FF](gitlab-org/gitlab@8d32ff1451543c274a7e0852f766ddd349444330) ([merge request](gitlab-org/gitlab!142841))
- [Remove usage of AutoFixWorker](gitlab-org/gitlab@214af62cc432b1ecb9118d39c540720aca0baed5) ([merge request](gitlab-org/gitlab!142046))
- [Remove unused controller code and old view](gitlab-org/gitlab@ad3ffe97c790fdc667e60a658218106358fe2d66) ([merge request](gitlab-org/gitlab!142810))
- [Drop `vulnerabilities` Column From SbomOccurences](gitlab-org/gitlab@49d1113efb9b57025b78ba7a26589f4cce5edaba) ([merge request](gitlab-org/gitlab!142646))
- [Revert "Merge branch '416662-free-storage-limit-alert' into 'master'"](gitlab-org/gitlab@87c1bc3daeace9a922d02fb433d61263346bafd1) ([merge request](gitlab-org/gitlab!142645))
- [refactor: Drop col column 'package_name_pattern_ilike_query' Part 1](gitlab-org/gitlab@09c7e870d6cae0f5ea9fcc2b3e2b97bf7bee39f3) by @gerardo-navarro ([merge request](gitlab-org/gitlab!142299))
- [Remove the GCP technical demo views](gitlab-org/gitlab@040c176be354a0cdb57e84e0b7f84070bb166315) ([merge request](gitlab-org/gitlab!142553))
- [refactor: Remove ignore rule for renamed attr 'container_path_pattern'](gitlab-org/gitlab@8daa5598f62ac9124e56c0d816c80dba3d22e337) by @gerardo-navarro ([merge request](gitlab-org/gitlab!142309))
- [Delete WorkItemUpdateTask mutation](gitlab-org/gitlab@180aa2380cb0968ad577be8460524dd6e1b8fd82) ([merge request](gitlab-org/gitlab!142241))
- [Drop ignored columns from geo_node_statuses table](gitlab-org/gitlab@198beae725aacd063e6cd9efcc4b1655d287fb4d) ([merge request](gitlab-org/gitlab!142224))
- [Remove summary tab from K8s overview](gitlab-org/gitlab@4707381e612f329df3ad86fed5119585e1c5a2bb) ([merge request](gitlab-org/gitlab!142203))
- [Drops unused index index_on_projects_lower_path from projects](gitlab-org/gitlab@1465d01beaff41477cf848e1833260ee4d1e020f) ([merge request](gitlab-org/gitlab!142012))
- [Remove gl_analytics_tracking Feature Flag](gitlab-org/gitlab@5d3abf77f478a9f726953d1ba75c2b24ca7f1ce8) ([merge request](gitlab-org/gitlab!142137))
- [Removes bitbucket_server_importer_exponential_backoff feature flag](gitlab-org/gitlab@3db6c643d33a625c8c4d16126afd91c79e99f272) ([merge request](gitlab-org/gitlab!140175))
- [Remove unused dependency scanning jobs](gitlab-org/gitlab@a0aceffa6607492409630bd592a5a3026e77d929) ([merge request](gitlab-org/gitlab!141733))
- [Cleanup the linear query feature flags](gitlab-org/gitlab@a0f6087b6b4a2661fce1b8571835a429305c4f60) ([merge request](gitlab-org/gitlab!130518))
- [Remove generate tests code](gitlab-org/gitlab@d5a11e0c5ae488bc6c2b949cafb5f1fea5d25d9c) ([merge request](gitlab-org/gitlab!141086))
- [Remove lfs-check feature flag](gitlab-org/gitlab@9162dada6c62f2296870187dc5794f39bf63b4e1) ([merge request](gitlab-org/gitlab!114219))
- [Remove superseded SSH certificates protocol option](gitlab-org/gitlab@b36054915289d8ee04a2cc1682c44895ada04ee6) ([merge request](gitlab-org/gitlab!141599))

### Security (11 changes)

- [Restrict group access token creation for custom roles](gitlab-org/gitlab@c50f40966c4a303ed5cff42610dbeded0fdd38fd)
- [Limit vulnerabilitiesCountByDay date range to 1 year](gitlab-org/gitlab@18d19704b5446b8af7510b49dd94c9b733b956de)
- [Make scan result policies block renaming branches](gitlab-org/gitlab@8669ff16228ec8d3b9e0051929928ec8adf4462d)
- [Fix CI component input Regexp](gitlab-org/gitlab@67df0d1733012b28ed2ce2837d14171ccf1b0db1)
- [Add zuora_payment_method_xid to CreditCardValidation](gitlab-org/gitlab@ff740a8adb27609ab233ccd6a8b8e063a94c0be5)
- [Fix improper username sanitization](gitlab-org/gitlab@7403c048951c88f23cf2f38ae3f35259d1a35430)
- [Do not allow non-team member to set MR assignees/reviewers](gitlab-org/gitlab@d07effe7a35c911e429e0964ded79b8edb049bf8)
- [Use public email in tags atom feed](gitlab-org/gitlab@2a71cc2b27b61d4048e41d9df7f67e862ac1af03)
- [Escape user input before building regex for linker](gitlab-org/gitlab@ffd7bd786c8122ce58c019609cf8d1c5df309e3d)
- [Devfile parser arbitrary file write](gitlab-org/gitlab@1e163bb209f53e841a2cd5ad83177e286c9977bd)
- [Adds absolute path check](gitlab-org/gitlab@3b0394cac9233184c528e2c3d5847d00abcdf543) ([merge request](gitlab-org/gitlab!141593)) **GitLab Enterprise Edition**

### Performance (18 changes)

- [Add pagination to UsersController#contributed](gitlab-org/gitlab@1445a193e20b8f9a562a8550b730cfa34ba59d06) ([merge request](gitlab-org/gitlab!144329))
- [Add an additional preload to prevent n+1 in new project page](gitlab-org/gitlab@d8a7c6bd973b01e1781abaa1a8cf8322dad1d644) ([merge request](gitlab-org/gitlab!144336)) **GitLab Enterprise Edition**
- [Creating an internal Ci::Pipeline will send an internal event](gitlab-org/gitlab@2ba1a4080a283d750646b67d73a554c590cfd811) ([merge request](gitlab-org/gitlab!144092))
- [Remove FF reading p_ci_pipeline_variables](gitlab-org/gitlab@238e97b7436ab7cb7b6899712da7410a9761cf6e) ([merge request](gitlab-org/gitlab!143905))
- [Reduce N+1 approval rules related queries on GraphQL request](gitlab-org/gitlab@f4b55eb2e5b721d64016d3db1e821e80ac2e0d77) ([merge request](gitlab-org/gitlab!142169)) **GitLab Enterprise Edition**
- [Disable unused coverage in MR pipeline list](gitlab-org/gitlab@c68e2806167b8e2bdcb5d44b3e4a572a86229f28) ([merge request](gitlab-org/gitlab!143549))
- [Reduce memory allocations when iterating over an Enumerator](gitlab-org/gitlab@aeafec338a65f4ca61bf39f0f2c9cf568161ed6b) ([merge request](gitlab-org/gitlab!143441))
- [Add ff to read from p_ci_pipeline_variables](gitlab-org/gitlab@1112ed1309200a93ece1475e327fa51ccc81e890) ([merge request](gitlab-org/gitlab!143334))
- [Preload policy requirements for group projects count](gitlab-org/gitlab@03a2bc570d21e21f0767bc610ffbf8f86e98d9b7) ([merge request](gitlab-org/gitlab!143093)) **GitLab Enterprise Edition**
- [Use the rust based markdown engine](gitlab-org/gitlab@9e73257762002566a83bfe9553f6f04b54e0d259) ([merge request](gitlab-org/gitlab!142052))
- [Add index to WebHooks on project based hooks](gitlab-org/gitlab@9bafab2aa741ea8cb0a6e2c3e8474236363a7eef) ([merge request](gitlab-org/gitlab!141473))
- [Cleanup unused index and fk for ci_build_trace_metadata](gitlab-org/gitlab@f00b72f514ce06ce8605043ba194bf2bef760d11) ([merge request](gitlab-org/gitlab!142400))
- [Remove duplicated index_user_callouts_on_user_id index](gitlab-org/gitlab@2bdceb2bf15d9f4143683b5ba1af5171d1f10318) ([merge request](gitlab-org/gitlab!142166))
- [Add unbind hook to SafeHtml directive](gitlab-org/gitlab@fe9d0aa6c983da9f8fef7d3d169e48c5356b0e19) ([merge request](gitlab-org/gitlab!139561))
- [Clean up feature flag "reorder_garbage_collection_calls"](gitlab-org/gitlab@83592b803459f4b251f67dbf1fd5474d44d43a39) ([merge request](gitlab-org/gitlab!142284))
- [Add index on [name, pipeline_id] to ci_pipeline_metadata](gitlab-org/gitlab@0dfa9b4490c132954cea40652cebf4ed4c62d998) ([merge request](gitlab-org/gitlab!140607))
- [Remove batch_route_updates feature flag](gitlab-org/gitlab@ed550db57689084202e3d0a35aa8e079c515fc33) ([merge request](gitlab-org/gitlab!141761))
- [Refactor GroupsFinder and (hopefully) fix performance issue](gitlab-org/gitlab@f93bfe52b605c2d77b47f14b7e9ef022b43dbf77) ([merge request](gitlab-org/gitlab!141280))

### Other (147 changes)

- [Re-enqueue backfilling of the default organization owners](gitlab-org/gitlab@df150bae0a40ed353d5a0cb740d7930a3bdd8bf8) ([merge request](gitlab-org/gitlab!142979))
- [Partition ci_job_artifacts table](gitlab-org/gitlab@25d8cdbfb5b9639bb5c4662c9517194d376396a5) ([merge request](gitlab-org/gitlab!143039))
- [Add sharding keys for importers](gitlab-org/gitlab@ba05c6265cfcede2a4802ba2d0400a77d1a53ba4) ([merge request](gitlab-org/gitlab!143309))
- [Prepare partitioning constraint for ci_stages](gitlab-org/gitlab@5150d56564451aa26a97bdf90b81ffa248565cb2) ([merge request](gitlab-org/gitlab!144167))
- [[Refactoring] Extract common code in commit.html.haml](gitlab-org/gitlab@3439d13c4223ce9df76ebf466aa9d466f7391f0f) ([merge request](gitlab-org/gitlab!135593))
- [Add Duo-Pro telemetry header to AIGW request](gitlab-org/gitlab@08a1e622e0c983c29d874de9f9fc9d39f6801dfb) ([merge request](gitlab-org/gitlab!143623)) **GitLab Enterprise Edition**
- [Add desired sharding keys for vulnerability_management](gitlab-org/gitlab@f8e6e55eb0cc83df0ff010511ed802324d657cd9) ([merge request](gitlab-org/gitlab!144210))
- [Add desired sharding keys for deployment_management](gitlab-org/gitlab@aaff6078271bf5356e978212bd9e81ece60c587f) ([merge request](gitlab-org/gitlab!144208))
- [Add desired sharding keys for design_management](gitlab-org/gitlab@9d27fa16ce673d4cc2be96739e023658f97d6913) ([merge request](gitlab-org/gitlab!144207))
- [Add desired sharding keys for compliance_management](gitlab-org/gitlab@79060e7f6cb0ac3ee401a01dc4c2ae0482d8fe05) ([merge request](gitlab-org/gitlab!144206))
- [Remove obsolete FK between ci_stages and p_ci_builds](gitlab-org/gitlab@fcd1b33ee3ce186756da43c17aa291990e80b3b0) ([merge request](gitlab-org/gitlab!144021))
- [Feature gate group code suggestion access policies](gitlab-org/gitlab@ed402c6781d44c40d2ad912eab8628ab0d93d7d9) ([merge request](gitlab-org/gitlab!143626)) **GitLab Enterprise Edition**
- [Prevent adding records with null attributes to users and user_preference](gitlab-org/gitlab@87cfba872b4704c6bf0159f534731c7d8c36f6b2) ([merge request](gitlab-org/gitlab!125744))
- [Upgrade redis gem to v5](gitlab-org/gitlab@d53401149f0c670c1c48e405b7d0dfba5d54f7f0) ([merge request](gitlab-org/gitlab!141213))
- [Add rake task to list orphan final artifact objects](gitlab-org/gitlab@2b68c4986a3ef9d90acd2fb4f049a2b586319b00) ([merge request](gitlab-org/gitlab!143737))
- [Geo: Disable pipeline ref created events](gitlab-org/gitlab@c4a7fdae34df372ac4bab73ce9c5ecc4a45428d5) ([merge request](gitlab-org/gitlab!144126)) **GitLab Enterprise Edition**
- [Docs: Update enable the feature flag link for pages](gitlab-org/gitlab@65d49d48821065a3964d83f3b35a88777ff3b631) ([merge request](gitlab-org/gitlab!144082))
- [feat: Protected packages: Use capitalized casing in setting ui table](gitlab-org/gitlab@440d72b9c19bfdb60f7e1ad71fec8aeecc56e66e) by @gerardo-navarro ([merge request](gitlab-org/gitlab!144076))
- [Docs: GitLab pages Domain-level redirects enabled on Gitlab.com](gitlab-org/gitlab@b238ec96ba3955084d4630a5f6ee5e07bdb75a74) ([merge request](gitlab-org/gitlab!144035))
- [Removes pipeline_warnings method](gitlab-org/gitlab@1833b355dbbf29ea2cdf5dc15b7839ba3aba17b6) by @tedtran2019 ([merge request](gitlab-org/gitlab!140509))
- [Add sharding keys for remote_development](gitlab-org/gitlab@1f423370129f073ded9ff2afdf2ebe58d21e2d29) ([merge request](gitlab-org/gitlab!142122))
- [Introduce FK for routing table](gitlab-org/gitlab@9699bcdb071dc78e807bbb3e580c2a889b5f9a0d) ([merge request](gitlab-org/gitlab!143811))
- [Enable refactoring Project.has_ci_config_file?](gitlab-org/gitlab@72ae7afefac26558e5726d9dd0772a55a8c0eb75) ([merge request](gitlab-org/gitlab!144020))
- [Clean up vsa_predefined_date_ranges feature flag](gitlab-org/gitlab@5cbd508805779ac59f108aafbfa0f171ca6ce6a9) ([merge request](gitlab-org/gitlab!143577))
- [Create index for merge_request_metrics](gitlab-org/gitlab@1eb51932c461e79322f2c668a78fe546153c16b0) by @schurzi ([merge request](gitlab-org/gitlab!142357))
- [Add not null constraint to noteable_type](gitlab-org/gitlab@cfc9f0da3eb47415b84c3178b5d8df374ab42cfe) ([merge request](gitlab-org/gitlab!143918))
- [Backfill default protection branch defaults in application setting](gitlab-org/gitlab@f56ec753330e51b5f7e0f61dbe00454c623096d6) ([merge request](gitlab-org/gitlab!136291))
- [Add desired sharding keys for mlops](gitlab-org/gitlab@28ffba4ae55a23f1a6f403b55264ed909af0b0db) ([merge request](gitlab-org/gitlab!143926))
- [Add desired sharding keys for user_profile](gitlab-org/gitlab@9e8652e8e1c9f706aedec6c31b690cfc39405d94) ([merge request](gitlab-org/gitlab!143925))
- [Add desired sharding keys for continuous_delivery](gitlab-org/gitlab@27803796492ea4e9b85e2b375f1f82be79afcea6) ([merge request](gitlab-org/gitlab!143924))
- [Add desired sharding keys for value_stream_management](gitlab-org/gitlab@c6dd34067d58961037b2fb4692e47d322d7afdb8) ([merge request](gitlab-org/gitlab!143923))
- [Remove partition filter feature flag](gitlab-org/gitlab@8b9bb09b902451980c156926c96531c643feda9d) ([merge request](gitlab-org/gitlab!143916))
- [Add sharding keys for continuous_integration](gitlab-org/gitlab@ca198fa392df18d5a310475b5febc159123bcc35) ([merge request](gitlab-org/gitlab!143305))
- [Fix wrong error reason for protected packages](gitlab-org/gitlab@1468491a6ae59c54da9d33740fa5041577484192) by @gerardo-navarro ([merge request](gitlab-org/gitlab!143834))
- [Remove references to graphql_git_blame](gitlab-org/gitlab@10c2722dc701ee0b907aad5260b2cbece8fb0685) ([merge request](gitlab-org/gitlab!143343))
- [Add sharding keys for source_code_management](gitlab-org/gitlab@e0a1bed4a33b393c6dc79fdbd53106c98a15fe6b) ([merge request](gitlab-org/gitlab!142107))
- [Add desired sharding keys for continuous_integration](gitlab-org/gitlab@b5b647c1bd7c647340344ca518824323e8fab944) ([merge request](gitlab-org/gitlab!143826))
- [Add desired sharding keys for code_review_workflow](gitlab-org/gitlab@85b52e894ce6331d984584d8620f313efa8430e7) ([merge request](gitlab-org/gitlab!143825))
- [Add desired sharding keys for portfolio_management](gitlab-org/gitlab@4f47ee912081d8d72b40ffd04c194d2f409aefc7) ([merge request](gitlab-org/gitlab!143824))
- [Refactor ForkService class](gitlab-org/gitlab@f789178f69bbf32ff6f04b199adf9058f2edc9b4) ([merge request](gitlab-org/gitlab!140575))
- [Rename paginated table page bundle to be reusable](gitlab-org/gitlab@d1090984f51558f7413c3af35f51620cbcd5a0db) ([merge request](gitlab-org/gitlab!143812))
- [Remove geo proxy related dev feature flags](gitlab-org/gitlab@fe66cf40eff4999467a0ad7e37a1817630d255ef) ([merge request](gitlab-org/gitlab!143367)) **GitLab Enterprise Edition**
- [Add sharding keys for gitaly](gitlab-org/gitlab@a59ca67754910f04e3b1bbe0ab9a4087aaf452e4) ([merge request](gitlab-org/gitlab!143312))
- [Use QueuesMetadata for Sidekiq status](gitlab-org/gitlab@652e3898553305bf70c5b8fb45bab6eaa3b11173) ([merge request](gitlab-org/gitlab!143749))
- [Use PipelineTriggers::UpdateService in endpoints](gitlab-org/gitlab@c12141a7d975d9877c91e3ab329b47bc3b60d277) by @missy-davies ([merge request](gitlab-org/gitlab!136160))
- [Improve the storing of approvals at merge time](gitlab-org/gitlab@b43708250b95105ca1bfd7d28ada69f5f83a97b4) ([merge request](gitlab-org/gitlab!143077))
- [Change column title and adjust empty rule](gitlab-org/gitlab@37e93e69ba45bf748bdd3d0c894867f8ae5b0abf) ([merge request](gitlab-org/gitlab!142826)) **GitLab Enterprise Edition**
- [Splits the migration to enqueue BBMs separately](gitlab-org/gitlab@c00fc9b3560003079b9d343d735c38df94076527) ([merge request](gitlab-org/gitlab!143510))
- [Remove feature flag i_ci_secrets_management_vault_build_created](gitlab-org/gitlab@52f91670ac8957f5c92ac73edf38b31704ffe8c0) ([merge request](gitlab-org/gitlab!143617))
- [Fixes Button spacing](gitlab-org/gitlab@5c7b1413994258321c926b785caa821f790b1926) by @NIKU-SINGH ([merge request](gitlab-org/gitlab!126629))
- [Add desired sharding keys for source_code_management](gitlab-org/gitlab@0cfcd4ffbf3a1d5aac1079402fff4b15482b6bf4) ([merge request](gitlab-org/gitlab!143504))
- [Add desired sharding keys for pages](gitlab-org/gitlab@324134f70b91677ce0948e44d0d1ba74aaca85eb) ([merge request](gitlab-org/gitlab!143494))
- [Add desired sharding keys for infrastructure_as_code](gitlab-org/gitlab@4e01a4132a70f8bda92154ad7b2590baf9eb733d) ([merge request](gitlab-org/gitlab!143491))
- [Add desired sharding keys for wiki](gitlab-org/gitlab@7be6cd1f402bdb304962d14b4bd83967cca289bd) ([merge request](gitlab-org/gitlab!143489))
- [Analyze parent table after partitioning](gitlab-org/gitlab@b8214941b45db8cc2659286e8316d644029d4825) ([merge request](gitlab-org/gitlab!143192))
- [Add sharding keys for dependency_management](gitlab-org/gitlab@aa1f23b771e9250c671b823566adc800c4b84dd2) ([merge request](gitlab-org/gitlab!143306))
- [Add sharding keys for geo_replication](gitlab-org/gitlab@3cf38956e15c3657f780c69119afb60212307398) ([merge request](gitlab-org/gitlab!143311))
- [Add sharding keys for build_artifacts](gitlab-org/gitlab@10e7cd18bc37a102568ba94f3eaf5301af9122a6) ([merge request](gitlab-org/gitlab!143304))
- [Add sharding keys for package_registry](gitlab-org/gitlab@cc709247b954957d1ac09686bbb45b16bfd3c3d3) ([merge request](gitlab-org/gitlab!143303))
- [Migrate sidekiq status from SharedState to QueuesMetadata](gitlab-org/gitlab@1b5dbfe087e7fa52ef35af15571975c707c22604) ([merge request](gitlab-org/gitlab!141743))
- [Add CRUD services for pipeline trigger tokens](gitlab-org/gitlab@9d82ae9de75b0c5359e32311d1fe771510efbcb5) by @missy-davies ([merge request](gitlab-org/gitlab!136159))
- [Change revoked approvals to reset approvals](gitlab-org/gitlab@a16f8f5d048174c375243fbd956ef3ccbd04b1bf) ([merge request](gitlab-org/gitlab!143274))
- [Split out one of the mergeability conflict checks](gitlab-org/gitlab@539b3a54bd67b2dc627ae86c6c6e4cdbaeaccef5) ([merge request](gitlab-org/gitlab!142904))
- [Specify GitLab SSHD in FIPS compliance docs](gitlab-org/gitlab@a568e5bc48b9adf38fb18df46b6ec5be952909b6) ([merge request](gitlab-org/gitlab!143255))
- [Update gitaly gem to 16.9.0.pre.rc2 version](gitlab-org/gitlab@40d8f82b74f019bef4b898b905ed5b4b379a793b) ([merge request](gitlab-org/gitlab!143048))
- [Add check constraint to ensure star_count is non-negative](gitlab-org/gitlab@fb0cf049d30438e57b16d9ef67d77e434947d71e) ([merge request](gitlab-org/gitlab!142527))
- [Add sharding keys for security_policy_management](gitlab-org/gitlab@9815e0ae2617110ee8978ae7cf098ee0c8bd4648) ([merge request](gitlab-org/gitlab!142103))
- [Add sharding keys for feature_flags](gitlab-org/gitlab@ba40f6b97f2aa844ea60c6d5f101e1b8fe6ca6b1) ([merge request](gitlab-org/gitlab!142506))
- [Finalize batched migration BackfillCatalogResourceVersionsReleasedAt](gitlab-org/gitlab@1727669a6e91ac94420c1c849d8f7797402d0cea) ([merge request](gitlab-org/gitlab!143114))
- [Create index to support group direct members count](gitlab-org/gitlab@880e3eeca5715faaf520c0cfa3f8204d238c7059) ([merge request](gitlab-org/gitlab!143107))
- [Update p_ci_builds FKs to ci_stages to include partition_id](gitlab-org/gitlab@2e2a5257593fa20d641eb8fdc79851122e2876d1) ([merge request](gitlab-org/gitlab!142804))
- [Add desired sharding keys for code_testing](gitlab-org/gitlab@d3a6b0d8706feca6ca8edc8f0b56ad93b4b91784) ([merge request](gitlab-org/gitlab!143081))
- [Rename StuckImportWorker to StaleImportWorker](gitlab-org/gitlab@3e90bf8df64d9041c3715af970753a61e6635d9b) ([merge request](gitlab-org/gitlab!139676))
- [Remove Gitlab::Redis::ClusterSharedState migration helper](gitlab-org/gitlab@babe16b12ac6e9f3889d545a741963857d942d07) ([merge request](gitlab-org/gitlab!140833))
- [Prepare partitioning constraint for ci_job_artifacts 2](gitlab-org/gitlab@16ef7cbdc2996927c6fc16604dbdbdb960533ab7) ([merge request](gitlab-org/gitlab!143028))
- [Add sharding keys for value_stream_management](gitlab-org/gitlab@200bfb511e0bb77561b4a73413124155e99d4939) ([merge request](gitlab-org/gitlab!142105))
- [Add sharding keys for vulnerability_management](gitlab-org/gitlab@96cfb8318305ced6ab605bdbea4e49d9e720e7fd) ([merge request](gitlab-org/gitlab!142121))
- [Add sharding keys for wiki](gitlab-org/gitlab@da914bd0c7c155f7c368579a820fc31112d51504) ([merge request](gitlab-org/gitlab!142504))
- [Cleanup the update_default_organization_users](gitlab-org/gitlab@39f4d1398d22967c12007525b303e5cfa6544b07) ([merge request](gitlab-org/gitlab!142975))
- [Return ServiceResponse for Pypi::CreatePackageService](gitlab-org/gitlab@af49fb67f7bbed5cc6cb4c898c057dd6de972b49) by @gerardo-navarro ([merge request](gitlab-org/gitlab!141386))
- [Use shorter notation for conditional classes](gitlab-org/gitlab@59ccf108cacc304de469c22dc82ec19d033e6377) ([merge request](gitlab-org/gitlab!142714))
- [test: Apply recommended matchers from testing library](gitlab-org/gitlab@ffe4ce9878519bab41f2bb42f867c97a6b716a92) by @gerardo-navarro ([merge request](gitlab-org/gitlab!142444))
- [Stop requesting the diff stats for tracing related diffs](gitlab-org/gitlab@ad24f07eb39cc7a689f96ef555935bf71ae0bdd5) ([merge request](gitlab-org/gitlab!134971))
- [Add visible names for all MR approval rule table headers](gitlab-org/gitlab@f08b6b77789b77c895f84725f12c6f724ea227f0) ([merge request](gitlab-org/gitlab!142183)) **GitLab Enterprise Edition**
- [Swap system_note_metadata.id to bigint](gitlab-org/gitlab@36d8e328b3c3eaed1d0050a1db2b9c99212d25c8) ([merge request](gitlab-org/gitlab!141220))
- [Creating new event based metric for Ci Builds](gitlab-org/gitlab@0fc109d6d9aa49e995bfbf83a44d112772384fbf) ([merge request](gitlab-org/gitlab!141421))
- [Replace icons with corresponding options](gitlab-org/gitlab@077c48662c2c3ec32a066c2cb26a04b208bd8096) ([merge request](gitlab-org/gitlab!142736))
- [Remove increase_jira_import_issues_timeout feature flag](gitlab-org/gitlab@861a325a1d52e71908dbda3b4c2f47f0a38c1ba7) ([merge request](gitlab-org/gitlab!141791))
- [refactor: Reference regex utility directly in Packages::Protection::Rule](gitlab-org/gitlab@0f85d213166f4985046ffea9faac48be83b05162) by @gerardo-navarro ([merge request](gitlab-org/gitlab!140737))
- [Prepare partitioning constraint for ci_job_artifacts](gitlab-org/gitlab@5437ecd3ef2cb032ba09f2284513240e4957e5d6) ([merge request](gitlab-org/gitlab!142648))
- [Ensure uniqueness ci_pipeline_variables ids](gitlab-org/gitlab@85b9ac05239edf7ffbee495e3e88984ca287c416) ([merge request](gitlab-org/gitlab!142526))
- [Avoids db hit to get `id`, instead using it from the loaded object](gitlab-org/gitlab@242af89eb478e5eb87c1727901cf57dcf8181f03) ([merge request](gitlab-org/gitlab!142722))
- [Async create index to support counting group members](gitlab-org/gitlab@6d2483b7ac4eb645165f5c3331a768db3af364af) ([merge request](gitlab-org/gitlab!142719))
- [Remove validate_import_decompressed_archive_size feature flag](gitlab-org/gitlab@4ccbe58ce33ddc5b51fa712bbbb9978390722c2a) ([merge request](gitlab-org/gitlab!142688))
- [Finalize BackfillOwaspTopTenOfVulnerabilityReads](gitlab-org/gitlab@6e531b1b9b704c14ab1e7566b3ae4f2a012ea612) ([merge request](gitlab-org/gitlab!142665))
- [Add sharding keys for audit_events](gitlab-org/gitlab@66ef9fa671e3cb403871a164497dff38b1b2076f) ([merge request](gitlab-org/gitlab!142511))
- [Fix workspaces url_prefix field](gitlab-org/gitlab@2d43b40945bb0abdcae7b2d62c94f4b575e7f1af) ([merge request](gitlab-org/gitlab!142647)) **GitLab Enterprise Edition**
- [Add onboarding_status to user_details and implement use](gitlab-org/gitlab@2517b9398ca6a42159526e64881c2a7625bb34d0) ([merge request](gitlab-org/gitlab!141932))
- [Update job_artifacts docs with new project ID location](gitlab-org/gitlab@a282aeb41d9dd8fee9e735a0be066f6e96dd9fb2) by @mitar ([merge request](gitlab-org/gitlab!142352))
- [Remove project import level](gitlab-org/gitlab@1443ef65a0672a1bec7366f347683ed95f9e2546) ([merge request](gitlab-org/gitlab!140322))
- [Cleanup highlight_js_worker feature flag](gitlab-org/gitlab@7f40f01603e2106d235708eaed4aa2050fb06dbc) ([merge request](gitlab-org/gitlab!142146))
- [Remove default values for partition_id](gitlab-org/gitlab@34d0202c35757b6aae4a5704ad679987e3c2bb65) ([merge request](gitlab-org/gitlab!142394))
- [Don't send email when importing members using DirectTransfer](gitlab-org/gitlab@23da8a55b3438d02802f9f3e26721991cd9b7f18) ([merge request](gitlab-org/gitlab!142546))
- [Add sharding keys for global_search](gitlab-org/gitlab@d1f8d1470de38a0fc14b20f4c830aa2805a472e8) ([merge request](gitlab-org/gitlab!142509))
- [Add sharding keys for secrets_management](gitlab-org/gitlab@25466097cbf4e11b86b5390c1ad8a8f40615ab86) ([merge request](gitlab-org/gitlab!142508))
- [Add sharding keys for onboarding](gitlab-org/gitlab@4b66380b44328c878fcacdf6685aeaf574b5ddda) ([merge request](gitlab-org/gitlab!142507))
- [Add sharding keys for consumables_cost_management](gitlab-org/gitlab@1a2a78307d62950f2eb0512b6eb394e399c1ef30) ([merge request](gitlab-org/gitlab!142503))
- [Add sharding keys for dependency_proxy](gitlab-org/gitlab@e26f0d5d293f53aca9049e1c1c33fa5d32a75235) ([merge request](gitlab-org/gitlab!142502))
- [Add sharding keys for infrastructure_as_code](gitlab-org/gitlab@9d29b618697a433bcf20b4367df80ecd19af901c) ([merge request](gitlab-org/gitlab!142500))
- [Add sharding keys for integrations](gitlab-org/gitlab@b00225b640989a3754698557f660257f6d07a43b) ([merge request](gitlab-org/gitlab!142499))
- [Add sharding keys for software_composition_analysis](gitlab-org/gitlab@30a4d690293d5cf2032a8d05358d6f9399ec496c) ([merge request](gitlab-org/gitlab!142495))
- [Add sharding keys for cell](gitlab-org/gitlab@f6a256ffb5481fd3096c158529b16685c94c0b6a) ([merge request](gitlab-org/gitlab!142494))
- [Silence only the first instance RedisClient::ConnectionError](gitlab-org/gitlab@87fab18e5d7ce1800e91d56c05b38d76341e898e) ([merge request](gitlab-org/gitlab!141845))
- [Fix MultiStore .close to skip if no connections borrowed](gitlab-org/gitlab@f237a1db69297ff9178a82a92864367240bac727) ([merge request](gitlab-org/gitlab!142409))
- [Create routing table for ci_pipeline_variables](gitlab-org/gitlab@02b7a81bfd02fd9db40e34b38000f2739feb17ea) ([merge request](gitlab-org/gitlab!141270))
- [Backfill catalog_resource_versions released_at column](gitlab-org/gitlab@a6bae48e67a6c7241ad9b8031e750ca954835d92) ([merge request](gitlab-org/gitlab!142255))
- [chore: Added missing feature_category for CurrentUserMode tests](gitlab-org/gitlab@554c66ea3afa3a5600e6cbc3bdf6efa11bf1008e) by @gerardo-navarro ([merge request](gitlab-org/gitlab!142332))
- [Add sharding keys for continuous_delivery](gitlab-org/gitlab@39e0bb3ea1240552716b7635c51dc7e435b7541c) ([merge request](gitlab-org/gitlab!142108))
- [Enable optimise GitHub import attachments feature](gitlab-org/gitlab@2f76853be8aa1eec7ac3672ed5ce285dcc138649) ([merge request](gitlab-org/gitlab!142257))
- [Cleanup scan_result_policies_block_force_push FF](gitlab-org/gitlab@f02510702c22ea8f199a6ab94151c4dd3501bb0c) ([merge request](gitlab-org/gitlab!141658)) **GitLab Enterprise Edition**
- [Fixes gettext autofix](gitlab-org/gitlab@89f06ab992241aa0e58ef6c73dcff8d246ba59af) ([merge request](gitlab-org/gitlab!142230))
- [Update migration's signature](gitlab-org/gitlab@a27a23254d3908caa9884e726bfcb62f1c3e8449) ([merge request](gitlab-org/gitlab!142197))
- [Adjust rule controles to new design](gitlab-org/gitlab@8c8e8ddfa1d816a3203f75922bd46b9b824c8d7d) ([merge request](gitlab-org/gitlab!141402)) **GitLab Enterprise Edition**
- [Prepare partitioning constraint for ci_pipeline_variables](gitlab-org/gitlab@29c08d617c87dd75772d8ad3345d7e4b3673178f) ([merge request](gitlab-org/gitlab!141072))
- [Add FK for bigint conversion for .com](gitlab-org/gitlab@474340a71c07383a066860d553f98faa593bfe60) ([merge request](gitlab-org/gitlab!141333))
- [Add sharding keys for instance_resiliency](gitlab-org/gitlab@fdcf9a6247a956cfe188a6dcc1fdf5e24b2421d7) ([merge request](gitlab-org/gitlab!142111))
- [Add sharding keys for portfolio_management](gitlab-org/gitlab@83ae946fba7c237f21857b3f4f78ac58aa84e803) ([merge request](gitlab-org/gitlab!142110))
- [Add sharding keys for requirements_management](gitlab-org/gitlab@3542c7d3bac86b1a8c3a48989ccec36cb22d1d94) ([merge request](gitlab-org/gitlab!142109))
- [Add sharding keys for dynamic_application_security_testing](gitlab-org/gitlab@24c9e61b28d43b2a9d2439b716c08e76b8ea46e5) ([merge request](gitlab-org/gitlab!142106))
- [Add sharding keys for deployment_management](gitlab-org/gitlab@3a90d22673d01a76864959968b0ccfd948c5b09f) ([merge request](gitlab-org/gitlab!142104))
- [Add sharding keys for mlops](gitlab-org/gitlab@f0610e34a45582df157041727e99d4f9c6151190) ([merge request](gitlab-org/gitlab!142102))
- [Create index asynchronously for merge_request_metrics](gitlab-org/gitlab@0d2ffd80ca15f664592ae28a146e6decb4acf317) by @schurzi ([merge request](gitlab-org/gitlab!141618))
- [Fix cross joins on group members](gitlab-org/gitlab@dcafd160d0fa3c161f08881334028e7be2dd4cf2) ([merge request](gitlab-org/gitlab!140493))
- [Document best practices for components README](gitlab-org/gitlab@0c99b279d77f123383b9e1e48e36a95bf18172c1) ([merge request](gitlab-org/gitlab!141484))
- [Add new fields](gitlab-org/gitlab@d5b764a9fd60ea5da0584f3d8f77eb9d9421e929) ([merge request](gitlab-org/gitlab!141083))
- [Migrate deprecated buttons to pajamas component](gitlab-org/gitlab@006d4c330ac7a923f6fd3b1a7887f4ff0ab32681) by @missy-davies ([merge request](gitlab-org/gitlab!140013))
- [Introduce `golangci` to Workhorse](gitlab-org/gitlab@804efbe50b29debebf8343bbbdc15d4b8d8c4f6d) ([merge request](gitlab-org/gitlab!141891))
- [Cleanup blobBlameInfo feature flag](gitlab-org/gitlab@9bd4c94a731607892b5cba1dc7d8f7907b4efe6a) ([merge request](gitlab-org/gitlab!141853))
- [Add guidelines for becoming a maintainer of GitLab Pages](gitlab-org/gitlab@3f1aa0fa16966a7a3ee87156c959ffc0ee4a0d96) ([merge request](gitlab-org/gitlab!140966))
- [Add index for the new primary key on system_note_metadata](gitlab-org/gitlab@a02434c898c4042dc666795e2ff14da9af46148d) ([merge request](gitlab-org/gitlab!141331))
- [Remove bulk_import_limit_concurrent_batches flag](gitlab-org/gitlab@cd9ddce70c5384ac802a7c994c667c4bea3e38ab) ([merge request](gitlab-org/gitlab!141811))
- [Move MentionsConverter to Import namespace](gitlab-org/gitlab@e1bdb8b64410b6e65c1396a89946bcd0b57bc32d) ([merge request](gitlab-org/gitlab!141793))
- [Validate merge_request_diffs.project_id foreign key](gitlab-org/gitlab@d3bf2174bcd1c5e419faa08edfe6c64938e06244) ([merge request](gitlab-org/gitlab!140280))
- [Add sharding key to agent_user_access_project_authorizations](gitlab-org/gitlab@34e2cc9e8b0e3e7ccbeca6fa3c08d67405f36364) ([merge request](gitlab-org/gitlab!141566))
- [Add sharding keys for feature category fuzz_testing](gitlab-org/gitlab@8bb0bcf8605f5f35061b2e6d5d0136c662db72d0) ([merge request](gitlab-org/gitlab!141570))
- [Add sharding keys for feature category container_registry](gitlab-org/gitlab@970eb0516521937a13957bc80730a58c9c4e7e2d) ([merge request](gitlab-org/gitlab!141569))
- [Protected packages: Align logic for protection rules across registries](gitlab-org/gitlab@2f2dbe94fecade03595d83298c251ead4dbadda6) by @gerardo-navarro ([merge request](gitlab-org/gitlab!140009))

### EE (1 change)

- [Add remediation badge to vulnerability report](gitlab-org/gitlab@e6236197509eae1bb27edf8fb2c63ccf769c2642) ([merge request](gitlab-org/gitlab!142455))

## 16.8.10 (2024-09-20)

No changes.

## 16.8.9 (2024-07-23)

### Added (1 change)

- [Add Rake task to show token expiration info](https://gitlab.com/gitlab-org/gitlab/-/commit/b8d88ab89f76ff7ed39d4d561ef79bd9c8c664cd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159066))

### Changed (1 change)

- [Do not enqueue PAT expiry enforcement migration](https://gitlab.com/gitlab-org/gitlab/-/commit/8a7138eaae89c433bcc234a59a9fb9c696c3081f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153469))

### Other (1 change)

- [Clear instance value](https://gitlab.com/gitlab-org/gitlab/-/commit/3d02306a06855503e8aaafd68b9234343d5ae84b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160249))

## 16.8.8 (2024-06-25)

### Fixed (1 change)

- [Update an expired test certificate](gitlab-org/gitlab@5b316194aee0927d3aeb6812f116d30bec8d6e37) ([merge request](gitlab-org/gitlab!156396))

### Changed (1 change)

- [Add a banner informing about token expiration](gitlab-org/gitlab@48caa37b7717dfabfdab4af472ba51de1303ae74) ([merge request](gitlab-org/gitlab!155268))

## 16.8.7 (2024-04-12)

No changes.

## 16.8.6 (2024-04-09)

### Security (3 changes)

- [Update Gitlab::Regex::Packages#slack_link_regex](gitlab-org/security/gitlab@1f88950d5d570b14915818539d88d54999e2606c) ([merge request](gitlab-org/security/gitlab!3902))
- [Fix XSS in autocomplete in rich text editor](gitlab-org/security/gitlab@60f3d5f99ae8c8df2f5a5543b61ce09f8bddc06e) ([merge request](gitlab-org/security/gitlab!3948))
- [Correctly parse attachments for junit result](gitlab-org/security/gitlab@2059390df321318c2f82b83e488e76ff23d6609c) ([merge request](gitlab-org/security/gitlab!3910))

## 16.8.5 (2024-03-27)

### Security (2 changes)

- [Limit the number of emojis we will transform](gitlab-org/security/gitlab@8d949c60d508b6cf3d558fc4f906c82b03e06748) ([merge request](gitlab-org/security/gitlab!3925))
- [Fix stored xss in wikis using the abstract_reference_filter](gitlab-org/security/gitlab@39a9847874a56baabacfba4d832b6d30ca388baf) ([merge request](gitlab-org/security/gitlab!3922))

## 16.8.4 (2024-03-06)

### Fixed (3 changes)

- [Backport 145801 (Fix CI linter error when repository is empty) to 16.8](gitlab-org/security/gitlab@0cf6a481f8555cf6c94d1b8b6bbc74af5a29c99f)
- [Fix container repositories checksum mismatch errors](gitlab-org/security/gitlab@3ac997e5fe461b828dcc5ef3990ec88e24d1ffb2) **GitLab Enterprise Edition**
- [Use the backup database connection while restoring timeouts](gitlab-org/security/gitlab@d5376ee9362c5a14e921f4f5fd54a1214480551f)

### Security (2 changes)

- [Restrict group token rotation for custom roles](gitlab-org/security/gitlab@fb35694c0a16a12cd62b2737937e4d20e04e155f) ([merge request](gitlab-org/security/gitlab!3904))
- [Reset approvals when reopening a MR](gitlab-org/security/gitlab@717aa058de09f0357914f0f8dce84340f10bfb45) ([merge request](gitlab-org/security/gitlab!3828))

## 16.8.3 (2024-02-20)

### Added (1 change)

- [Allow creation of group-level custom-roles on self-managed instances](gitlab-org/security/gitlab@72eeb80a95e7190b5a6a9a4b113dd88d3f66bdd4) **GitLab Enterprise Edition**

### Fixed (3 changes)

- [Avoid mutating OpenSSL::PKey::EC keys](gitlab-org/security/gitlab@f562d0d13834ec09123d49019265a1202d8c2cc2)
- [Fix X509::Signature#x509_issuer not working with OpenSSL 3](gitlab-org/security/gitlab@7ad0ea9d286e003814032275cd1bcc487b7ecac7)
- [Fix urlblocker validate calls with more options](gitlab-org/security/gitlab@04111c2e90b8e40668ccb74a4f64c3a2853bc3c0)

### Security (9 changes)

- [Add a limit to CodeOwners reference extractor regex](gitlab-org/security/gitlab@55d0ba98eaa460f86b6d750d91d1eb21a0759836) ([merge request](gitlab-org/security/gitlab!3860))
- [Ensure LDAP user cannot sign in with password](gitlab-org/security/gitlab@085b95fd9ec3ad3a4fa3aab7136ce29ae3dac507) ([merge request](gitlab-org/security/gitlab!3892))
- [Ensure LDAP users cannot reset local password to bypass LDAP](gitlab-org/security/gitlab@746702abea2a7703f75885f4a52df4d4ec2f8a41) ([merge request](gitlab-org/security/gitlab!3880))
- [Disallow assigning higher role than current user](gitlab-org/security/gitlab@d018ba8f447e0ae98f4ee74011d1aa4dcaab7432) ([merge request](gitlab-org/security/gitlab!3851))
- [Check project read access in Environments and Operations dashboard](gitlab-org/security/gitlab@d7c1e953fb21c2aa793156eb035cd170072cffca) ([merge request](gitlab-org/security/gitlab!3872))
- [Invalidate markdown cache to clear up stored XSS](gitlab-org/security/gitlab@d3dfc38783578bfecc3dfaa26546867b9f63694a) ([merge request](gitlab-org/security/gitlab!3885))
- [Disallow users to modify deploy key title](gitlab-org/security/gitlab@6bc3fca49ec264873100509683490b91c136b29e) ([merge request](gitlab-org/security/gitlab!3866))
- [Adds authorization for analytics settings](gitlab-org/security/gitlab@01a31cdf0d9879f048cdff21fcb20f368307ed11) ([merge request](gitlab-org/security/gitlab!3850))
- [Use merge_head_diff for codeowners when merge request is mergeable](gitlab-org/security/gitlab@6da2d42bfb260dcb387f2ea692df06c6054afd45) ([merge request](gitlab-org/security/gitlab!3868))

## 16.8.2 (2024-02-07)

### Fixed (3 changes)

- [Fix Redis 6.0 compatibility breakage with Sidekiq 7 gem](gitlab-org/security/gitlab@e61868ad98d2ae640b3deec2b148c01fb52dba77)
- [Defer ConnectionPool instrumentation setup](gitlab-org/security/gitlab@d31ee125cd7ec9023b7558bd7af44c0293637b94)
- [Fix invalid records with FK not valid](gitlab-org/security/gitlab@a8dece6c5d160a218d9622a3dab0f93a7b2ca181)

### Security (4 changes)

- [Fix CI component input Regexp](gitlab-org/security/gitlab@96b81737b2b9f1aa3c9d710bc00b80be8359f68f) ([merge request](gitlab-org/security/gitlab!3854))
- [Make scan result policies block renaming branches](gitlab-org/security/gitlab@6b12a71efe9c82b696cf1dc68c5aa2bc72e5fea3) ([merge request](gitlab-org/security/gitlab!3837))
- [Restrict group access token creation for custom roles](gitlab-org/security/gitlab@e1d38e70f1f5c9defbb0ca2fa4608e603dcd2858) ([merge request](gitlab-org/security/gitlab!3834))
- [Limit vulnerabilitiesCountByDay date range to 1 year](gitlab-org/security/gitlab@5e5428919d4773731bed7f724bd650dbc7555d9e) ([merge request](gitlab-org/security/gitlab!3826))

## 16.8.1 (2024-01-24)

### Fixed (1 change)

- [Optimize garbage collection process](gitlab-org/security/gitlab@1d5a7bc23d5678a2d3c059cbced7d33f5e1e68c4)

### Changed (1 change)

- [Migrate {hll_counters}_i_code_review_create_mr from hll to int](gitlab-org/security/gitlab@357bfe13fc9ab986bba65eb2b06413baed1357f1)

### Security (5 changes)

- [Devfile parser arbitrary file write](gitlab-org/security/gitlab@4f2cc52e8695d219bc9e5c73ada1cf92b1b7a398) ([merge request](gitlab-org/security/gitlab!3817))
- [Use public email in tags atom feed](gitlab-org/security/gitlab@d3b7615e4b0e5aa8007a8d00944bbd98a98c5f84) ([merge request](gitlab-org/security/gitlab!3822))
- [Fix improper username sanitization](gitlab-org/security/gitlab@2f5cccd35e5e0e5e1786d9d10cfacf890704d1ad) ([merge request](gitlab-org/security/gitlab!3818))
- [Escape user input before building regex for linker](gitlab-org/security/gitlab@7a315ac79ece40726fa28d0821c872f0343346b8) ([merge request](gitlab-org/security/gitlab!3819))
- [Do not allow non-team member to set MR assignees/reviewers](gitlab-org/security/gitlab@bf0c84e848ef955443e3998b937aabaf66cdb5ed) ([merge request](gitlab-org/security/gitlab!3820))

## 16.8.0 (2024-01-17)

### Added (113 changes)

- [Enable security_policies_policy_scope by default](gitlab-org/gitlab@f79b154180c1e5fdb240e02f3b593b4865b42d4e) ([merge request](gitlab-org/gitlab!141766)) **GitLab Enterprise Edition**
- [Enable compliance framework report by default](gitlab-org/gitlab@60e01b758a57e44ab89c9ae37f71e6da2ee6bd72) ([merge request](gitlab-org/gitlab!140825)) **GitLab Enterprise Edition**
- [Improve issue weight system notes](gitlab-org/gitlab@dc18d16118f5a617e7af004f49d7de9393016dfc) ([merge request](gitlab-org/gitlab!141479)) **GitLab Enterprise Edition**
- [Release the Maven dependency proxy](gitlab-org/gitlab@aa18d864fb03734eb8de24c0b259b2b7d4da7015) ([merge request](gitlab-org/gitlab!141600))
- [Make delete members API rate limit configurable](gitlab-org/gitlab@18f63149c87f8dac86369a4d8abb60eda0f60eec) ([merge request](gitlab-org/gitlab!140633))
- [Adds support for mlflow experiment search](gitlab-org/gitlab@f4b5d7db108885885752afc84d8356c0c5e106b7) ([merge request](gitlab-org/gitlab!141428))
- [Adds ML Agent and AgentVersion models](gitlab-org/gitlab@6e27278848405306d1d1ec597c5fbe6312144442) ([merge request](gitlab-org/gitlab!141356)) **GitLab Enterprise Edition**
- [Add code suggestions available to user graphql type](gitlab-org/gitlab@71a210d879da13472050cacdc2b4ef1b46123a6f) ([merge request](gitlab-org/gitlab!141617)) **GitLab Enterprise Edition**
- [API option for returning top level namespaces only](gitlab-org/gitlab@7cb19c35853e4ba599d9abcfb3702e167a307697) ([merge request](gitlab-org/gitlab!141311))
- [Protected packages: Display busy table with loading icon](gitlab-org/gitlab@4fd0e5a3885bb6f830fa70cef02cc72776c48d89) by @gerardo-navarro ([merge request](gitlab-org/gitlab!141370))
- [Add sorting to member roles GraphQL query](gitlab-org/gitlab@d3cc881499dcc51f9be3b9a16c8c34e59830774e) ([merge request](gitlab-org/gitlab!141405)) **GitLab Enterprise Edition**
- [Log audit events when updating and deleting member roles](gitlab-org/gitlab@5eb6f94b8282c9511533532ef3b236365ee2cb26) ([merge request](gitlab-org/gitlab!141630)) **GitLab Enterprise Edition**
- [Add partition_id to Ci::PipelineConfig](gitlab-org/gitlab@f2ddcb34d0a18a9e6969e824eaeed259ac2c5da0) ([merge request](gitlab-org/gitlab!141461))
- [Add Duo Chat access check to GraphQL API](gitlab-org/gitlab@57aac43b27baf1824787dbf38fa6d76040633328) ([merge request](gitlab-org/gitlab!141389))
- [Backfill zoekt_enabled_namespaces and zoekt_indices](gitlab-org/gitlab@d4a7c607cf66ecd6940a2998965e1b472a2fe573) ([merge request](gitlab-org/gitlab!140252)) **GitLab Enterprise Edition**
- [Add description field for Ci::InstanceVariable and InheritedCiVariable](gitlab-org/gitlab@37cbc8035c56a9927ca69137ee332d2071110db8) ([merge request](gitlab-org/gitlab!140549))
- [Add partition_id to Ci::PipelineArtifact](gitlab-org/gitlab@c3ac0da2088f5e2a5b459ae7aa62375329ea3041) ([merge request](gitlab-org/gitlab!141345))
- [Add partition_id to Ci::PipelineMetadata](gitlab-org/gitlab@171b7fa93f8403e93ba6c669bd903eba959edb14) ([merge request](gitlab-org/gitlab!141078))
- [Remove manage_project_access_tokens FF](gitlab-org/gitlab@96c3aaf636c187f6b3999ece8693c0fefadf3180) ([merge request](gitlab-org/gitlab!141294)) **GitLab Enterprise Edition**
- [Ensure backfill of default branch protection setting](gitlab-org/gitlab@d01dfa4a3b40dcf3fe1f2dbc6f33b81e3716d008) ([merge request](gitlab-org/gitlab!141012))
- [Group by OWASP Top 10](gitlab-org/gitlab@54e2dfdc35b77c7ec501ad3ebcaa8ac13aff3b98) ([merge request](gitlab-org/gitlab!141149)) **GitLab Enterprise Edition**
- [Allow User to be specified for a CI Image or Service](gitlab-org/gitlab@f3ec5bf2329d02f526dfdfa5460b0bb093a29b6a) by @ar-mali ([merge request](gitlab-org/gitlab!137907))
- [Add index project_id, component_version_id and id](gitlab-org/gitlab@fdad489b0991b72f19206abc7b0768337add2b58) ([merge request](gitlab-org/gitlab!141400)) **GitLab Enterprise Edition**
- [Add support for inapplicable task items in RTE](gitlab-org/gitlab@fbd1f1fa6aa1f568c6a11f569b86bee8ab7466b1) ([merge request](gitlab-org/gitlab!141303))
- [Remove ff cache_control_headers_for_openid_jwks](gitlab-org/gitlab@3365b71f0e3b3a391d133639c057414187e6c7ab) ([merge request](gitlab-org/gitlab!141305))
- [Added gitlab_tags helper to MLflow API](gitlab-org/gitlab@d4fa6558fbd0e72bfd309442598df38682e6f682) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/139706))
- [Add GCP Secret Manager CI integration](gitlab-org/gitlab@0daa46523566d2ee20dac7d76a46a611ad546697) ([merge request](gitlab-org/gitlab!141460)) **GitLab Enterprise Edition**
- [Added tests to guardrail missing scopes](gitlab-org/gitlab@99e9e272b682303605c51960a82535096bac45a9) ([merge request](gitlab-org/gitlab!138307))
- [Release Pipeline execution polices as an experiment](gitlab-org/gitlab@f3e708bb3d6f7b9f796e9a89b61622518699051a) ([merge request](gitlab-org/gitlab!139771)) **GitLab Enterprise Edition**
- [Add ability to admin_terraform_state to custom roles](gitlab-org/gitlab@52ebf3e509c9ef139df04caeabaae1f551da71c2) ([merge request](gitlab-org/gitlab!140759)) **GitLab Enterprise Edition**
- [Add support for rich text editor in comment templates](gitlab-org/gitlab@5dfc400951b6449e1116188459a397da78eb16e3) ([merge request](gitlab-org/gitlab!141316))
- [Add rich text editor in iterations](gitlab-org/gitlab@b6bf098d4eb307e1679a475e9318cb69af9bf8df) ([merge request](gitlab-org/gitlab!141314)) **GitLab Enterprise Edition**
- [Add owasp_top_10 filter to VulnerabilitySeverityCount GraphQL API](gitlab-org/gitlab@bc1ad3a30a970932243ebac8472bd7b481c9e8cc) ([merge request](gitlab-org/gitlab!140205)) **GitLab Enterprise Edition**
- [Add pages project settings API](gitlab-org/gitlab@52b254913a45fece3d21db2ff3078d2aaa8685cd) ([merge request](gitlab-org/gitlab!140895))
- [Add mutation to update color](gitlab-org/gitlab@0039d6d6ea9156d9c55690b2d5277fa500b7b9ce) ([merge request](gitlab-org/gitlab!140847)) **GitLab Enterprise Edition**
- [Expose epic-issue permissions in GraphQL](gitlab-org/gitlab@a69106709f6a2dd5be958f9574b1323d7bfe9d73) ([merge request](gitlab-org/gitlab!141351))
- [Add support for table alignment in RTE](gitlab-org/gitlab@11e4f7b7d05886dfe35e738963a7a4b0b0d86192) ([merge request](gitlab-org/gitlab!141249))
- [Add Your resources tab to CI/CD Catalog](gitlab-org/gitlab@c508c9beb2d9aa9475806fa96823edfc727d0b63) ([merge request](gitlab-org/gitlab!138388))
- [Wrap the serched text with double quotes when exact_search is passed](gitlab-org/gitlab@16d0c0814d3a115085bdd8aed38843f0cde99829) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/140346)) **GitLab Enterprise Edition**
- [Add documentation for migration helpers](gitlab-org/gitlab@27d11987825fc84582d038b4ed0f7356e51134d0) ([merge request](gitlab-org/gitlab!140046)) **GitLab Enterprise Edition**
- [Enable ci_data_ingestion_to_click_house by default](gitlab-org/gitlab@c981c43c2b37b961abc3e6cb3d3bd31c488d5e45) ([merge request](gitlab-org/gitlab!141238)) **GitLab Enterprise Edition**
- [Added initial Diffblue Cover integration](gitlab-org/gitlab@a925c2f291507c63f4e5f1fccb02159dca1bc219) by @roxspring ([merge request](gitlab-org/gitlab!134437))
- [Redefine referenced FK ci_job_artifacts for self managed](gitlab-org/gitlab@c28a2116fa9641811ef451396efe021f8c70f63f) ([merge request](gitlab-org/gitlab!141218))
- [Send Arkose Data Exchange payload on signup challenge initialization](gitlab-org/gitlab@f80056ff1e087f6ef35bc78f279a3594dabf7c70) ([merge request](gitlab-org/gitlab!139070)) **GitLab Enterprise Edition**
- [Add system_id param to GET runners/:id/jobs endpoint](gitlab-org/gitlab@75b287e451aaea061369c283d1d38d552363431b) ([merge request](gitlab-org/gitlab!140667))
- [Use new GraphQL client to paginate deploy keys](gitlab-org/gitlab@5965d1b71386079b74d98bb3d4dbf0b0ce1cf842) ([merge request](gitlab-org/gitlab!139569))
- [feat: Protected packages: Project settings ui package protection rules](gitlab-org/gitlab@66e0f67ca56ca216600e82df57d03e793013a391) by @gerardo-navarro ([merge request](gitlab-org/gitlab!140008))
- [Replace clickhouse_ci_analytics FF with database config check](gitlab-org/gitlab@687352cfddf8df959efe6e8c1814df5ecc4b4636) ([merge request](gitlab-org/gitlab!140890))
- [Create namespace descendants table](gitlab-org/gitlab@352f692cad7fe8c59409a8fcdc4756589722d847) ([merge request](gitlab-org/gitlab!140735))
- [Add support for global HTTP TLS client cert](gitlab-org/gitlab@5ae8a6f85ea92fff615a34d0cbdeaad72fd60a59) ([merge request](gitlab-org/gitlab!140263))
- [Migrate config_version for non-terminated workspaces](gitlab-org/gitlab@fe4f885edbf3e3a10923d643ace462a87da737ae) ([merge request](gitlab-org/gitlab!140972)) **GitLab Enterprise Edition**
- [Hard limit daily phone verification transactions](gitlab-org/gitlab@770104162f8f537fa3e69529a380eeeb65573ce2) ([merge request](gitlab-org/gitlab!138627)) **GitLab Enterprise Edition**
- [Add Experiment badge and popover](gitlab-org/gitlab@35b94980292f18d666e16e01d8e938258ce7bfee) ([merge request](gitlab-org/gitlab!139702)) **GitLab Enterprise Edition**
- [Add WorkItems Rolledup Dates widget](gitlab-org/gitlab@734dde3e9155a01a360ef27fb1c9b547174e0092) ([merge request](gitlab-org/gitlab!139418))
- [Finalize BackfillPartitionIdCiPipelineChatData](gitlab-org/gitlab@a1ddb08e29b56086b91a91c711f7dc1ea8812ded) ([merge request](gitlab-org/gitlab!140969))
- [Validate referenced FK constraints ci_job_artifacts](gitlab-org/gitlab@6f8ef3d6453167bb2226da62abee9bb46934b9b0) ([merge request](gitlab-org/gitlab!140960))
- [Add source_xid attribute to the ErrorTracking](gitlab-org/gitlab@2e850910c7be1f4c206115e8c23c61c6b976189b) ([merge request](gitlab-org/gitlab!140948)) **GitLab Enterprise Edition**
- [Add ci_restrict_pipeline_cancellation_role to update project api](gitlab-org/gitlab@790d9aa2bb5873e0d7276ecdcb4d9e2f24a1d858) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/139585)) **GitLab Enterprise Edition**
- [Support fetching versioned readme from GQL ciCatalogResource endpoint](gitlab-org/gitlab@a5d9abf2459146b59a043b553dfb008f6e41236d) ([merge request](gitlab-org/gitlab!139983))
- [workhorse: Support generating configuration via external command](gitlab-org/gitlab@4b5d67a17a1f1ab33b671df7314b90dfa73aa398) ([merge request](gitlab-org/gitlab!140898))
- [Add setting to enforce 2FA for admins](gitlab-org/gitlab@e7ba0f66ad5c735ed50129ad8ccf9c7127825023) ([merge request](gitlab-org/gitlab!137911))
- [Add color widget to work items](gitlab-org/gitlab@93abac0543222f84661517739005bb130d6c2cbb) ([merge request](gitlab-org/gitlab!140331)) **GitLab Enterprise Edition**
- [Add GraphQL to list all organizations in an instance for admin area](gitlab-org/gitlab@1e008496d283b7018beb482f8f270a62c3ecb8b0) ([merge request](gitlab-org/gitlab!140552))
- [Cleanup truncate_ci_merge_request_description FF](gitlab-org/gitlab@6c27289930abca271769eccb934416c8450a28b9) ([merge request](gitlab-org/gitlab!140201))
- [Add migration to add_work_item_type_id to issues index](gitlab-org/gitlab@f3196690034c1c7ba6247e1b2560c9d2aff31772) ([merge request](gitlab-org/gitlab!139079)) **GitLab Enterprise Edition**
- [Add support for updating member_role permissions](gitlab-org/gitlab@d6d9cd97d229cc02c52ad7f799ef06eb0bed6692) ([merge request](gitlab-org/gitlab!140581)) **GitLab Enterprise Edition**
- [Change data source for project level dependencies](gitlab-org/gitlab@51f4f2a88fd44defc3f6b3ce635c25a356201f05) ([merge request](gitlab-org/gitlab!139686)) **GitLab Enterprise Edition**
- [Remove slash_commands_file_content flag](gitlab-org/gitlab@88991216f124dd45457a04b7e7f1836d83cdcc76) ([merge request](gitlab-org/gitlab!140795)) **GitLab Enterprise Edition**
- [Enable SAML group sync for customizable roles](gitlab-org/gitlab@aedd8807232aec9fc5fac16dd196a1af11502b10) ([merge request](gitlab-org/gitlab!140573)) **GitLab Enterprise Edition**
- [Add migration to add_work_item_type_id to issues index](gitlab-org/gitlab@372567f1e63f6ffcb1cc3161a4400aa2c458bf70) ([merge request](gitlab-org/gitlab!138299)) **GitLab Enterprise Edition**
- [Add Harbor to integrations docs](gitlab-org/gitlab@531dd3932911b89baee622620c56ada62f3a7f61) ([merge request](gitlab-org/gitlab!140672))
- [Schedule removal of invalid Vulnerabilities](gitlab-org/gitlab@575d9b0d51850bd33b55b36afc59a73679bbc568) ([merge request](gitlab-org/gitlab!140532))
- [Add online and offline dashboard panels](gitlab-org/gitlab@017a8535bb16dbeea00b6fca239b90d26836ed55) ([merge request](gitlab-org/gitlab!140138)) **GitLab Enterprise Edition**
- [Add CI/CD Catalog alert to releases page](gitlab-org/gitlab@a3c5948b5d1f34fa09a2f5092ac7e77ad0841d63) ([merge request](gitlab-org/gitlab!140691))
- [Add pagination to compliance framework report](gitlab-org/gitlab@1353ce1731cda01cae0d003d5f5fda3f37f99b10) ([merge request](gitlab-org/gitlab!139743)) **GitLab Enterprise Edition**
- [Adding Model Version Metadata to MLflow](gitlab-org/gitlab@05da217c7adbf9edd75dba2a7d94f5ef5bda5556) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/139975))
- [Add Manage group access tokens custom permission](gitlab-org/gitlab@093b552432fa5e49fdee828f6ac8d182a14e7ce4) ([merge request](gitlab-org/gitlab!140115)) **GitLab Enterprise Edition**
- [Add graphql query to list policies for compliance framework](gitlab-org/gitlab@19bc5025f775bf689cbd3294b6f32fca8ab9dca6) ([merge request](gitlab-org/gitlab!136641)) **GitLab Enterprise Edition**
- [Add Google Play to integrations docs](gitlab-org/gitlab@ada2421849b8779ebae353c78342d7a6f9532819) ([merge request](gitlab-org/gitlab!140563))
- [Add support for cancelling drag on `Esc`](gitlab-org/gitlab@f74a573db7a7ecc382203ef38ee82db8ae8e07eb) ([merge request](gitlab-org/gitlab!140619))
- [Add organization specification for group creation](gitlab-org/gitlab@6f9b46a9a4ee7878da91ef9c4235234f95d7a400) ([merge request](gitlab-org/gitlab!140472))
- [Add a setting to allow/disallow duplicate Terraform modules](gitlab-org/gitlab@c09fadea25f918fb52b98921835415c21f18a897) ([merge request](gitlab-org/gitlab!139161))
- [Add referrers to container repository tags in GraphQL API](gitlab-org/gitlab@befbd09add9b4a2e9071b9c92f79403f0e9e090e) ([merge request](gitlab-org/gitlab!138588))
- [Emit event when a release is published](gitlab-org/gitlab@853af39e669370e90c86b30857fbc3e0aa144acf) by @oelmekki ([merge request](gitlab-org/gitlab!137253))
- [Expose instance level custom roles](gitlab-org/gitlab@915153bbfd9fb930012dd34d2d4db127a639651c) ([merge request](gitlab-org/gitlab!137708)) **GitLab Enterprise Edition**
- [Add new fields to GroupType](gitlab-org/gitlab@01d12e94d14646115826a84c8a4f4081e42d020b) ([merge request](gitlab-org/gitlab!139966))
- [Add delete button to edit compliance framework page](gitlab-org/gitlab@68adf479f5393148689bbdb96d00a400c5468598) ([merge request](gitlab-org/gitlab!139723)) **GitLab Enterprise Edition**
- [Add zoekt enabled namespace and indices](gitlab-org/gitlab@4d8fc7524be6ead4c2189f44d2c7d13ca70224df) ([merge request](gitlab-org/gitlab!138992)) **GitLab Enterprise Edition**
- [Cache users from Bitbucket Server](gitlab-org/gitlab@4bc85597fcaf09ac5a4ff57a15b6e4e872632e1e) ([merge request](gitlab-org/gitlab!139221))
- [Clean up BE for SecurityConfigurationController](gitlab-org/gitlab@9db7c4babceebbb98f8eb5e5d37ec6aaa002eb73) ([merge request](gitlab-org/gitlab!140325)) **GitLab Enterprise Edition**
- [Add name and path as fields for version type](gitlab-org/gitlab@9427249a83b380bb536fb02078a6f7ea3682ac5f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/139772))
- [Add feature toggle for security policies policy scope](gitlab-org/gitlab@88088a44b11ba88a81451254fd1c73444ff7bc6a) ([merge request](gitlab-org/gitlab!139959)) **GitLab Enterprise Edition**
- [Cache users from Bitbucket Server](gitlab-org/gitlab@de92ed8f3f5a619f00303850b33e51a843b65af9) ([merge request](gitlab-org/gitlab!139775))
- [Add discussion locked property to work item notes widget](gitlab-org/gitlab@5c133ecb10cba7c51421a161576bcb1f6ea1f02f) ([merge request](gitlab-org/gitlab!138793))
- [Redefine referenced FK ci_job_artifacts](gitlab-org/gitlab@bb5473249fd61c8323018a1b6b1fcd6f035d006c) ([merge request](gitlab-org/gitlab!140187))
- [Add partition_id to Ci::PipelineChatData](gitlab-org/gitlab@7d1890a9576715e7e22cd08b68543589b2f24395) ([merge request](gitlab-org/gitlab!139515))
- [Add props field to SBOM component parser](gitlab-org/gitlab@c75baaf98ccaea7f04b24d886c01620186584864) ([merge request](gitlab-org/gitlab!140042))
- [Add migration to add_work_item_type_id to issues index](gitlab-org/gitlab@c07001d1f32037ca3dcff1dfa6180a4273d0e965) ([merge request](gitlab-org/gitlab!138298)) **GitLab Enterprise Edition**
- [Add organization specification for group creation](gitlab-org/gitlab@a95f2491015e7cded109decd17c5515bd1b62d19) ([merge request](gitlab-org/gitlab!139842))
- [Add API for SBOM occurrences related-vulnerabilities](gitlab-org/gitlab@7cb132d498df2a56bade8c97716199e8e21f5f4a) ([merge request](gitlab-org/gitlab!137889)) **GitLab Enterprise Edition**
- [Add feature toggle for security policies policy scope](gitlab-org/gitlab@6a95e2faa09c756f99117f442d1d1b67ef93b60f) ([merge request](gitlab-org/gitlab!139911)) **GitLab Enterprise Edition**
- [Add Delete Project custom permission](gitlab-org/gitlab@3fb60c17be5d184e8fa97925edb0fc2f08d42de8) ([merge request](gitlab-org/gitlab!139696)) **GitLab Enterprise Edition**
- [Adds CI minutes usage CSV export button](gitlab-org/gitlab@03d1edafcf3b5e44d0286c27825f9c3e94684ac5) ([merge request](gitlab-org/gitlab!139548)) **GitLab Enterprise Edition**
- [Enhance Security configuration response with features](gitlab-org/gitlab@c5ad0b4a43e854669c0177c1ce51f1e8e50c7ff4) ([merge request](gitlab-org/gitlab!140183))
- [Introduce verified_ca commit signature verification status](gitlab-org/gitlab@824e2e12e97469ccf998eca82825792c26eb262e) ([merge request](gitlab-org/gitlab!140082)) **GitLab Enterprise Edition**
- [Add GraphQL fields to check if MR allows mutliple assignees/reviewers](gitlab-org/gitlab@1553ae8cf998561720a30030deae53e43b5623e8) ([merge request](gitlab-org/gitlab!139887))
- [Add index to ci_job_artifacts referenced FK](gitlab-org/gitlab@19dc7b834802e40b5bfa8f05ddb978ccc33723d6) ([merge request](gitlab-org/gitlab!140045))
- [Add issue_id to epics](gitlab-org/gitlab@441b41e533930f154b1735c16629cdf6f4d34ead) ([merge request](gitlab-org/gitlab!139788))
- [Add support to search by work item links in token input](gitlab-org/gitlab@ba461a7c905caf6d97af21ed797541163673a2c5) ([merge request](gitlab-org/gitlab!135751))
- [Adding new scope for_container_path for container protection rule](gitlab-org/gitlab@83035e5012e367388677ca7e2135b5b2b3fa3819) by @gerardo-navarro ([merge request](gitlab-org/gitlab!135969))
- [Reference Terraform modules from a project](gitlab-org/gitlab@7d77be6ccc2eb0c890c14645961789493f033845) ([merge request](gitlab-org/gitlab!137809))
- [Clear work item types reactive cache when importing restrictions](gitlab-org/gitlab@25fb92513d20f14c4a21a4773cb1c0bbe97b396c) ([merge request](gitlab-org/gitlab!138961))
- [Add diff_by_file_hash merge request action](gitlab-org/gitlab@0dcbc736ab94a48cad482702f56a19c7bdb9b207) ([merge request](gitlab-org/gitlab!138712))

### Fixed (103 changes)

- [Fix migration error in sent_notifications migration](gitlab-org/gitlab@0b6c09587e64212c38d9dbdfcf40fb2a61f541ce) ([merge request](gitlab-org/gitlab!141783))
- [Validate import collaborator scope](gitlab-org/gitlab@de8534e3edd463a84aa574800eb19f6a1c51c01f) ([merge request](gitlab-org/gitlab!141510))
- [Fix display of selected timezone for cities with duplicated identifiers](gitlab-org/gitlab@8b8344972fde4c9202f1939d5f2882d8935e09e3) ([merge request](gitlab-org/gitlab!141522))
- [Fix unresolved OpenApi references](gitlab-org/gitlab@04429efc5e3c33ec77f7d893a8edb7cf905fe17a) ([merge request](gitlab-org/gitlab!138922))
- [Make chat_names table migration idempotent](gitlab-org/gitlab@53269865a2fe3d59de1b8eb6dde0cb57e7858b45) ([merge request](gitlab-org/gitlab!141703))
- [Add conditional chaining for systemNoteMetadata](gitlab-org/gitlab@2f632f0a9f7dd286ea95912d34de4a3d5ebc92ed) ([merge request](gitlab-org/gitlab!140943))
- [Truncate source_title & source_url when creating `BulkImports::Failure`](gitlab-org/gitlab@f36bf0d797ad3147bb7e77c8e9c6be4060b7ed28) ([merge request](gitlab-org/gitlab!141655))
- [Fix error when security policy CI contains no jobs](gitlab-org/gitlab@92811c5415807b713c5f1c18c3f4dc762928d841) ([merge request](gitlab-org/gitlab!141520)) **GitLab Enterprise Edition**
- [Fetch tag notes on release refresh](gitlab-org/gitlab@399c09b411bd962d6ecc4d2e776335db11d9385a) ([merge request](gitlab-org/gitlab!141260))
- [Work items lists: Fix focus ring overflow issue](gitlab-org/gitlab@0216b3343533daee19ce7762e7f1df5e0cbdc2e1) ([merge request](gitlab-org/gitlab!141587))
- [Return error message when there is unlinked security policy project](gitlab-org/gitlab@6d546f7c91b0e1aa354a6695140233d791de0351) ([merge request](gitlab-org/gitlab!140584)) **GitLab Enterprise Edition**
- [Fix group milestone deletion](gitlab-org/gitlab@3424738891272dc5e42d39467fe675473359b30c) by @Taucher2003 ([merge request](gitlab-org/gitlab!141298))
- [Remove next badge from logged out header](gitlab-org/gitlab@c7e201ef2ca82c6bb4dc30ff1bc0e0448ed8b0e6) ([merge request](gitlab-org/gitlab!141435))
- [Update Flux sync status for bad config](gitlab-org/gitlab@0e7dc69ad34bba2a320f9daf8570898ea6465b88) ([merge request](gitlab-org/gitlab!141424))
- [Package Metadata DB with v prefix](gitlab-org/gitlab@d3bda5635600e676a3492c19dede3f25f787db62) ([merge request](gitlab-org/gitlab!140435)) **GitLab Enterprise Edition**
- [Fix preview button for instance templates](gitlab-org/gitlab@c201deda13b6d678694b1f9e1bb1eb949695d250) ([merge request](gitlab-org/gitlab!140788)) **GitLab Enterprise Edition**
- [Fix broken state when undoing after uploading](gitlab-org/gitlab@73a7e1d73cbbafe9d84e3916cc5f792a7b71dc42) ([merge request](gitlab-org/gitlab!139021))
- [Fix alignment issue with scan summary](gitlab-org/gitlab@98f5a8f357a8669c63e88402ece69586855b57e0) ([merge request](gitlab-org/gitlab!141234)) **GitLab Enterprise Edition**
- [Fix broken source maps after quick actions](gitlab-org/gitlab@e0a1f24d7d814766211f2cf254d16d795920a4d4) ([merge request](gitlab-org/gitlab!141263))
- [Align icon with text in Code Quality widget](gitlab-org/gitlab@231d0ba733c4b42f97955cf28bedd52c671d1a0e) ([merge request](gitlab-org/gitlab!141490))
- [Fix wiki menus background color in darkmode](gitlab-org/gitlab@785715dc26f1d5a38f1c15e9fb23d605a0898ca0) by @lvckyapi ([merge request](gitlab-org/gitlab!141312))
- [Breadcrumb: Remove extra whitespace when avatar is used](gitlab-org/gitlab@02ea34020f9b9955746df93b7216087c10a1ca6b) ([merge request](gitlab-org/gitlab!141387))
- [Fix date for state change in vulnerability discussions](gitlab-org/gitlab@30be6cb56e9433eab2c6b1d4f82057b20b7e2f65) ([merge request](gitlab-org/gitlab!141454)) **GitLab Enterprise Edition**
- [Show unsupported message for doc tool SM](gitlab-org/gitlab@dd303e52dfe3efda0f5bbebcf95f506eb3a7db91) ([merge request](gitlab-org/gitlab!141227)) **GitLab Enterprise Edition**
- [Implement GCP/AWS orphan artifacts clean up task](gitlab-org/gitlab@41c8fa7f1e4de850346d212c5167295204796c77) ([merge request](gitlab-org/gitlab!139892))
- [Show merge help text for failed pipelines](gitlab-org/gitlab@2229b93bca785bfe7e7e00aaafa2adbb795f4eca) ([merge request](gitlab-org/gitlab!141396))
- [Fix Markdown not rendering in CI/CD catalog](gitlab-org/gitlab@3f1af81670bb2a15f81548797b3bc17a33eb20c8) ([merge request](gitlab-org/gitlab!141388))
- [Fix "error on credentials page for PATs with deleted group/project"](gitlab-org/gitlab@c08db8d049355bd140beb30388593834c1a3a43e) ([merge request](gitlab-org/gitlab!140873)) **GitLab Enterprise Edition**
- [Fix duplicated policy approval rules in rule details](gitlab-org/gitlab@59f781c1b605c0c197abfafb698a7f4aa8ef9cc7) ([merge request](gitlab-org/gitlab!141021)) **GitLab Enterprise Edition**
- [Fix `Group#owned_by?` and `#has_user?` methods to handle nil](gitlab-org/gitlab@b824e61c9ff25f68aae479992df30140910a47f9) ([merge request](gitlab-org/gitlab!141276))
- [Ignore pending access requests when calculating the highest group role](gitlab-org/gitlab@c25c7b794ca269a715b1a9b65269c1471d2e876d) ([merge request](gitlab-org/gitlab!141364))
- [Update file size validation](gitlab-org/gitlab@56f4f58e6b4de301a4e12329852b359d0c8dbb91) ([merge request](gitlab-org/gitlab!140237))
- [Fix error creating pipeline with external policy CI](gitlab-org/gitlab@351e41dce18ccef5a09e265344133541a3b3a225) ([merge request](gitlab-org/gitlab!141362)) **GitLab Enterprise Edition**
- [Add uniqueness validation to topic](gitlab-org/gitlab@87aa5cd96466f80f3888f9767194d5d49a31d56b) ([merge request](gitlab-org/gitlab!141357))
- [Add estimate system note on issuable creation](gitlab-org/gitlab@61a5a0bbf3e019ad74c0120f617bbc95a8640eb5) ([merge request](gitlab-org/gitlab!141192))
- [Fix getting single custom role through graphQL](gitlab-org/gitlab@78cd832cdb13afd3d9ac56aa97683255b81c3b2e) ([merge request](gitlab-org/gitlab!140981)) **GitLab Enterprise Edition**
- [Fix locations count](gitlab-org/gitlab@43c21ba9e03c42008de8d6757193d753e463aa7f) ([merge request](gitlab-org/gitlab!140727)) **GitLab Enterprise Edition**
- [Open file link for new modal in new tab](gitlab-org/gitlab@3c6db267cb8c6464344957f08ca8e56159bffaf9) ([merge request](gitlab-org/gitlab!140546)) **GitLab Enterprise Edition**
- [GraphQL doc update](gitlab-org/gitlab@8d3f18191e65cd564e491d11da0bea5f9a8606b2) ([merge request](gitlab-org/gitlab!141170)) **GitLab Enterprise Edition**
- [Display error message when an existing stage name is used](gitlab-org/gitlab@abaf24a26c8bb542e93acb3389dbcf53f03eba3c) ([merge request](gitlab-org/gitlab!141062)) **GitLab Enterprise Edition**
- [Sec Finding details: Fix double-hash for file loc](gitlab-org/gitlab@657cbe8195dde489b36d66bca025eec678889638) ([merge request](gitlab-org/gitlab!140975)) **GitLab Enterprise Edition**
- [Fix path generation error for #switch](gitlab-org/gitlab@cedb9f2a0db5b77f1d0bc8b633dacb7588875cb5) ([merge request](gitlab-org/gitlab!141232))
- [Pipline Mini Graph: Fix max length for item](gitlab-org/gitlab@452feb0ed2e0e7d79f1377c2f70e47e7bf993d35) ([merge request](gitlab-org/gitlab!141099))
- [Issues list: Don't render empty closed badge](gitlab-org/gitlab@2688f2ad74d631544d1fd9150304313e3b4f1382) ([merge request](gitlab-org/gitlab!140320))
- [Show inherited security policies when user has access to project only](gitlab-org/gitlab@a403c095bc4960b98056cce146f29753e435c224) ([merge request](gitlab-org/gitlab!140530)) **GitLab Enterprise Edition**
- [Remove relative_url from markdown preview in RTE](gitlab-org/gitlab@5f655a0a7405f8ba296f225bfa048bf0aec5df78) ([merge request](gitlab-org/gitlab!141070))
- [Make bundler-checksum work with Bundler v2.5.0 (part 2)](gitlab-org/gitlab@79a61126ea888cba87f44ca66c9ba5e57cdd822b) ([merge request](gitlab-org/gitlab!141069))
- [Add spacing between account providers](gitlab-org/gitlab@0d18d66f90a2ecafb9df2a25b1c236745fa7c092) ([merge request](gitlab-org/gitlab!141038))
- [Fix long session expiry for some requests](gitlab-org/gitlab@8c85364205ccb1f4602ab3543d10ff55295bd6cc) ([merge request](gitlab-org/gitlab!141020))
- [Prevent unnecessary sessions in API requests](gitlab-org/gitlab@f9e48ac93c9e062382d9f61771ce26dcb0926b8c) ([merge request](gitlab-org/gitlab!141010))
- [Provide `ref` to BlameData query](gitlab-org/gitlab@688953fcd90c1038d7266b7b6bf2a45e4fb4457f) ([merge request](gitlab-org/gitlab!140800))
- [Fix the vulnerability statistic calculation logic](gitlab-org/gitlab@51417a5f0ec74bcd27c4943b8f1bd0ed5571ea3c) ([merge request](gitlab-org/gitlab!140711)) **GitLab Enterprise Edition**
- [Show top-bar full width when right-sidebar is present](gitlab-org/gitlab@b413baa08ac6e0758d4d2cb1769e5b019279c961) ([merge request](gitlab-org/gitlab!140304))
- [Right sidebar gutter toggle fix position](gitlab-org/gitlab@07cf17543225757a02a51e96826b801c5c919818) ([merge request](gitlab-org/gitlab!140308))
- [Fix: Remember me cookie not set when bypassing](gitlab-org/gitlab@dbbe753ca506576f50a5d0382b333ba510022c03) by @gerardo-navarro ([merge request](gitlab-org/gitlab!138545))
- [Fix TypeError for invalid package.json dependencies](gitlab-org/gitlab@934a3d69249620a2cfc3a4a7cce7efdb3144d4aa) ([merge request](gitlab-org/gitlab!140791))
- [Fix NoMethodError for track event method](gitlab-org/gitlab@78af4ed67a519ddbc46c8ac049bfcac216bf5f42) ([merge request](gitlab-org/gitlab!140783))
- [Clear runner heartbeat when the last manager is removed](gitlab-org/gitlab@554daf6a8f6833a1e38de6f1a58961057d62536c) ([merge request](gitlab-org/gitlab!140572))
- [Fix file browser drag handle height](gitlab-org/gitlab@df24dd390c8ea32abbc95f2bb0b0a29f7057cafe) ([merge request](gitlab-org/gitlab!140732))
- [Fix 500 error when anonymous user visits explore/catalog](gitlab-org/gitlab@ac40978f9e5e74086b48de885145bfdd89ecae06) ([merge request](gitlab-org/gitlab!140724))
- [Add missing ci_sources_pipelines indexes for self-host](gitlab-org/gitlab@08f84359979e7dd60c05f598db0d34163ba8a05a) ([merge request](gitlab-org/gitlab!140697))
- [Add the missing definition for Discord integration](gitlab-org/gitlab@c50d88bda1b5c3da516f62e4c3100f006fd8cda4) ([merge request](gitlab-org/gitlab!140671))
- [Allow auditors to view job history of a runner](gitlab-org/gitlab@d2ea5e66dcf373c026fc086039242aad15d6d016) ([merge request](gitlab-org/gitlab!140618)) **GitLab Enterprise Edition**
- [Make bundler-checksum work with bundler v2.5.0+](gitlab-org/gitlab@dc85634db01ce452a82f277895abdb3d17f844df) ([merge request](gitlab-org/gitlab!140599))
- [Add sorting for the name column of the policies table](gitlab-org/gitlab@cf97cae9d5d88dad27532b7ca74979318921280e) by @vinod.kumar827 ([merge request](gitlab-org/gitlab!139341)) **GitLab Enterprise Edition**
- [Use toast for preferences saved notification](gitlab-org/gitlab@27b30ee1a7f283b824276c0f58b100a995cabd69) ([merge request](gitlab-org/gitlab!139587))
- [Fixed clicking global Duo Chat button after dismissed callout](gitlab-org/gitlab@936cc4a681c543e0915331bb786e149fbb7a532f) ([merge request](gitlab-org/gitlab!140551)) **GitLab Enterprise Edition**
- [Add scheduled DAST scans to be executed by security policy bot](gitlab-org/gitlab@40b2acb9a01c7167771c70c318f5d94794709bc0) ([merge request](gitlab-org/gitlab!140525)) **GitLab Enterprise Edition**
- [Fix Gradle publish failure in FIPS mode](gitlab-org/gitlab@6b09e9cee231e63705f46661587b9cc14a6da963) ([merge request](gitlab-org/gitlab!140499))
- [Exclude artifact & package sizes when calculating project export limit](gitlab-org/gitlab@b800df7ebdd31ca964e51a433b3b851b6deb3866) ([merge request](gitlab-org/gitlab!140227))
- [Add infinite scrolling to projects_dropdown](gitlab-org/gitlab@6981f5a459bbf2e74381ef4991369ab3de1cecf0) ([merge request](gitlab-org/gitlab!140185))
- [Pipeline Sec: remove ext-link icons from alerts](gitlab-org/gitlab@aa0c97c7f7e0ae0b8e1d19f16c4c9416f1b7a165) ([merge request](gitlab-org/gitlab!140360)) **GitLab Enterprise Edition**
- [Fixes VSA dropdowns when editing an existing stage](gitlab-org/gitlab@656078c2293b63636c1648752866fc930801e854) ([merge request](gitlab-org/gitlab!140171)) **GitLab Enterprise Edition**
- [Update issuable assignment change email copy](gitlab-org/gitlab@6267be767bade5c09cec5effa231389e0568ff11) ([merge request](gitlab-org/gitlab!139296))
- [Fix 500 error when not signed in](gitlab-org/gitlab@2efd4e1830eb8a2049e7ce2cf22c0fdbc110c6c9) ([merge request](gitlab-org/gitlab!140445)) **GitLab Enterprise Edition**
- [Fix change_column_type_concurrently for migration v2](gitlab-org/gitlab@938723f349eacf9d6d343424e242b2ee905fff7d) ([merge request](gitlab-org/gitlab!139337))
- [Avoid mapping by connected GitHub accounts during gitea import](gitlab-org/gitlab@a4f062774859bdf780c5be3c42f22efc5f93f7d9) ([merge request](gitlab-org/gitlab!140439))
- [Fix missing page_bundles CSS for Jira issues](gitlab-org/gitlab@2f0c8e5c573940d2c3ea0874e7c9762ed0f3b4ce) ([merge request](gitlab-org/gitlab!140425)) **GitLab Enterprise Edition**
- [Fix commit references being rendered inadvertently](gitlab-org/gitlab@f6b70ed4d5ce53d73b17e5ebfb8ae7a774d9a94a) ([merge request](gitlab-org/gitlab!140424))
- [Fix conflicting MR link when MR created from fork](gitlab-org/gitlab@301445583852f2951eafee41795884d3fb690a76) by @zzaakiirr ([merge request](gitlab-org/gitlab!139789))
- [Fix GitHub Import worker spread calculation](gitlab-org/gitlab@f3f3831aabc205fa971685e6995e491004b5d8f4) ([merge request](gitlab-org/gitlab!140283))
- [Fix Zero shot prompt validation error](gitlab-org/gitlab@ba3d8abebbb33a3dd12adaf11cbb2f52a05a2935) ([merge request](gitlab-org/gitlab!140297)) **GitLab Enterprise Edition**
- [Add label-for attributes](gitlab-org/gitlab@f4c68eafc6a277f50f7a484bdbf0e12e68743402) ([merge request](gitlab-org/gitlab!140338)) **GitLab Enterprise Edition**
- [Escape unicode null characters before parsing the security report](gitlab-org/gitlab@2e61a808814c11810052a0bfbb07ea5a20822fa2) ([merge request](gitlab-org/gitlab!140103)) **GitLab Enterprise Edition**
- [Fix browser navigation for vulnerability tabs](gitlab-org/gitlab@b225987832f4551c05f5ac88cabfed9e444fdeb8) ([merge request](gitlab-org/gitlab!139776)) **GitLab Enterprise Edition**
- [Check if owner account exists](gitlab-org/gitlab@985d121b0f0fc1ed8742ac8a943b474f9a2144c4) ([merge request](gitlab-org/gitlab!140274))
- [Fixed an incorrect parameter for deleting draft notes in the API](gitlab-org/gitlab@157cd395c6347ef2a3a32b897c92d5f02bca701a) ([merge request](gitlab-org/gitlab!140129))
- [Do not run ElasticCommitIndexerWorker on secondary geo nodes](gitlab-org/gitlab@ab66b87d5e93674fc0b13431308ecf822d562b30) by @zzaakiirr ([merge request](gitlab-org/gitlab!139843)) **GitLab Enterprise Edition**
- [Exclude archived projects from group project templates list](gitlab-org/gitlab@a1500d7cbd525ca1c6746704a16cb586c8524007) ([merge request](gitlab-org/gitlab!140084)) **GitLab Enterprise Edition**
- [Ensure timestamps are set for manually created vulnerabilities](gitlab-org/gitlab@a722ac5b91d66a10d22100dd5ee6b90f5497bde5) ([merge request](gitlab-org/gitlab!140223)) **GitLab Enterprise Edition**
- [Project overview mirrored message improvements](gitlab-org/gitlab@2615502e1e5d857663c8f5982b60ce2cdaa66eec) ([merge request](gitlab-org/gitlab!140207)) **GitLab Enterprise Edition**
- [Use VulnerabilityReadsFinder for InstanceSecurityDashboard counts](gitlab-org/gitlab@abae6252d5dc31713eab92c15afe13fb97f35fb4) ([merge request](gitlab-org/gitlab!140099)) **GitLab Enterprise Edition**
- [Project overivew: Add permission check for edit button](gitlab-org/gitlab@729c6dbc0973f82ddff3cf2b1fda4b99f7248962) ([merge request](gitlab-org/gitlab!139375))
- [Ingest owasp_top_10 for multiple identifiers finding map](gitlab-org/gitlab@63e9a1df3b45ac9a6c0953481eae3b035584861b) ([merge request](gitlab-org/gitlab!140067)) **GitLab Enterprise Edition**
- [Fix more badge in issuables lists](gitlab-org/gitlab@b217a98722baf6ef351c92aeb5a3ff2367ceff9e) ([merge request](gitlab-org/gitlab!140125))
- [Fix alignment of buttons on readme only preference](gitlab-org/gitlab@76954164859b098bb922dae4479fc63a99936a5d) ([merge request](gitlab-org/gitlab!140112))
- [Fix issues with Member Roles API](gitlab-org/gitlab@813f153c3186788cbcdf9ca357a16cd49dfc305f) ([merge request](gitlab-org/gitlab!140088)) **GitLab Enterprise Edition**
- [Fix cluster reindexing document_count](gitlab-org/gitlab@6bfb959abbe88f574820d01f1bb546c596ed5777) ([merge request](gitlab-org/gitlab!140085)) **GitLab Enterprise Edition**
- [Fix Advanced search dropdowns](gitlab-org/gitlab@fffa1320efdfdfef34a0ff8a5e7991539873ea46) ([merge request](gitlab-org/gitlab!139945))
- [Skip calculating signature fingerprint for certificates](gitlab-org/gitlab@9df61a46a92a8216a5b811241a2401b9ce04aed9) ([merge request](gitlab-org/gitlab!139926))
- [Ensure the approvals can not be changed after merge](gitlab-org/gitlab@f2edd555da6c5d874c62d33ec92454fbfaa883d6) ([merge request](gitlab-org/gitlab!138925))
- [Allow assigning of guests to confidential issues](gitlab-org/gitlab@e89eb0ce6d6989ac12ac4778f856fbd6bc1bf7df) ([merge request](gitlab-org/gitlab!139500))
- [Remove refresh_statistics_on_unlink_fork feature flag](gitlab-org/gitlab@19209f25c981274f14752c560118c603ffd932f8) ([merge request](gitlab-org/gitlab!139451))

### Changed (128 changes)

- [Refactor start_and_due_date to use callbacks](gitlab-org/gitlab@27705ad65570fdbb159fbdceaf51fd1d0f1ba475) by @imskr ([merge request](gitlab-org/gitlab!141727))
- [Replace autodevops illustrations with devops-sm](gitlab-org/gitlab@b446879ac8c17253372cb9ed596bfeb77bc1aee7) ([merge request](gitlab-org/gitlab!141707))
- [Show assignee and label shortcuts in tooltip](gitlab-org/gitlab@b5aa4ee1376e311ab199aad30b7caa44cdc4b3c2) ([merge request](gitlab-org/gitlab!141154))
- [Migrate deprecated sorting-item vue component](gitlab-org/gitlab@e9ffaa6ba61fa381d5a21f5bfc8b75e07e708a93) ([merge request](gitlab-org/gitlab!141530)) **GitLab Enterprise Edition**
- [Default enable group_analytics_dashboards feature flag](gitlab-org/gitlab@c8754fbb6a85ae7828d97cdf387c6d130eb80cdb) ([merge request](gitlab-org/gitlab!141453)) **GitLab Enterprise Edition**
- [Enable security_policies_unenforceable_rules_notification by default](gitlab-org/gitlab@ab28e627af2282889ab14fa5ff7355c67d6364eb) ([merge request](gitlab-org/gitlab!141619)) **GitLab Enterprise Edition**
- [Add `Cookie Preferences` button in the footer](gitlab-org/gitlab@11a0f85640244b1850780921987bfc92d4e07431) ([merge request](gitlab-org/gitlab!141475))
- [Migrate deprecated sorting-item vue component](gitlab-org/gitlab@bc9343fb70cf54a3a6b2ce96988ac56d821ff598) ([merge request](gitlab-org/gitlab!141480)) **GitLab Enterprise Edition**
- [Enable ff_require_saml_auth_to_approve by default](gitlab-org/gitlab@7bc47ba47391e56ea644fa64ea6edd3319859c9a) ([merge request](gitlab-org/gitlab!141594)) **GitLab Enterprise Edition**
- [Add flag and disable Container Scanning CVS](gitlab-org/gitlab@71568a85541e27421aac8d019af2821b0b07833b) ([merge request](gitlab-org/gitlab!141023))
- [Show edit issuable and wiki shortcut in tooltip](gitlab-org/gitlab@e09af9f3c383446d9501ca29199bd894f4b2d3e5) ([merge request](gitlab-org/gitlab!141526)) **GitLab Enterprise Edition**
- [Scope epics internal_ids generation to `issues` usage](gitlab-org/gitlab@c2f0d3833ca3e53ffcaf94fb2743d6c4e3b0322e) ([merge request](gitlab-org/gitlab!139367))
- [Add sbom_occurrence_properties table](gitlab-org/gitlab@97c28ade67ae982f83a2dea431500bee1f378eaa) ([merge request](gitlab-org/gitlab!140539))
- [Add feedback banner to product analytics dashboards](gitlab-org/gitlab@f458bdbad83600803663d39e17047ac6ed86205e) ([merge request](gitlab-org/gitlab!140790)) **GitLab Enterprise Edition**
- [System note tweaks](gitlab-org/gitlab@41addf4becfbdbcaf659ded8610b7d69b81aa866) ([merge request](gitlab-org/gitlab!141543))
- [Update dependency auto-deploy-image to v2.76.1](gitlab-org/gitlab@4a4cb563c24893af2f5a7074572170e4cd6f7fa2) ([merge request](gitlab-org/gitlab!141541))
- [Change order within admin appearance settings page by using the ABC](gitlab-org/gitlab@32134880df0e27b6b78fb40e3a9c4a429adb4519) by @bufferoverflow ([merge request](gitlab-org/gitlab!139049))
- [Add keyboard shortcut to Web IDE dropdown option](gitlab-org/gitlab@9542966fa3a08e2c8549d588695488c35f8a14b8) ([merge request](gitlab-org/gitlab!140965))
- [Store full include path for CI components](gitlab-org/gitlab@e997b1974fb0d77e192e5a0514a911966bbe101f) ([merge request](gitlab-org/gitlab!139122))
- [Fix 500 error when Jira host is unreachable](gitlab-org/gitlab@17c14c23d1c2818ade6de35a4bb811a8b3604e7d) ([merge request](gitlab-org/gitlab!141363))
- [This MR adds popover to experiment feature](gitlab-org/gitlab@2cb19343ff329894b408bbb7fe8d81639cd1f418) ([merge request](gitlab-org/gitlab!141268)) **GitLab Enterprise Edition**
- [Change variable modal action button to save](gitlab-org/gitlab@f3bae78cf14524c1c97a706571ce1090ad1f7ed5) ([merge request](gitlab-org/gitlab!141290))
- [Replace deprecated dropdown on new project page](gitlab-org/gitlab@6c605a9f53c15d72a5337421c594154916e9ab7b) by @daniel_magnus.bader ([merge request](gitlab-org/gitlab!139521))
- [This MR fixes usage of reserved names](gitlab-org/gitlab@2b48daea9bd140c2b74a5a57160f760409874018) ([merge request](gitlab-org/gitlab!141439)) **GitLab Enterprise Edition**
- [Enabling sast_reports_in_inline_diff flag by default in 16.8](gitlab-org/gitlab@51306b39bf2fed93f2f750f6007d19c19a297dcc) ([merge request](gitlab-org/gitlab!141247)) **GitLab Enterprise Edition**
- [Change button alignment on variable drawer](gitlab-org/gitlab@1d92cc26c2eb0cc29af2efcce80e055845c55254) ([merge request](gitlab-org/gitlab!141455))
- [Stop deleting merged MRs approval rules](gitlab-org/gitlab@c86ff3a48657b50f01874629ff8665710895cf5a) ([merge request](gitlab-org/gitlab!141036))
- [Enabling audit_events_streaming_namespace_filter by default](gitlab-org/gitlab@2b3a1b85622f97644d2ccb4282f57178bd0e5eb9) ([merge request](gitlab-org/gitlab!141445)) **GitLab Enterprise Edition**
- [Enable issues_completed_analytics_feature_flag feature flag by default](gitlab-org/gitlab@f39a3bc5bc2a8794acae788d44849feb10085603) ([merge request](gitlab-org/gitlab!141278)) **GitLab Enterprise Edition**
- [Add waiting time between phone verification code sends](gitlab-org/gitlab@3f81ac7a2c37db2154685353b77591aea4eee125) ([merge request](gitlab-org/gitlab!137850)) **GitLab Enterprise Edition**
- [Update GITLAB_PAGES_VERSION](gitlab-org/gitlab@83aba1d21593d77da3df93e8124e763055e8cfab) ([merge request](gitlab-org/gitlab!141384))
- [Code suggestions: Update condition to check cut-off date](gitlab-org/gitlab@ac0aa97ef5c334fc4f84c4cabc1e2bf4ac964cda) ([merge request](gitlab-org/gitlab!138334))
- [Standardize customizable permission type](gitlab-org/gitlab@f807189110630504c0121d874ee95c2d8546fac3) ([merge request](gitlab-org/gitlab!141296)) **GitLab Enterprise Edition**
- [Add warning to group creation page to avoid using dot](gitlab-org/gitlab@32976c09262145059e3ec7723c0837931f8ad7ce) ([merge request](gitlab-org/gitlab!141243))
- [Refactor description widget to use callbacks](gitlab-org/gitlab@de18913fb7f3274b5dcd4440ce3f47f121fb9e36) by @imskr ([merge request](gitlab-org/gitlab!140577))
- [Show copy source branch shortcut in tooltip](gitlab-org/gitlab@29a85cd791182a13cce199219f1ff2eb5c3015fc) ([merge request](gitlab-org/gitlab!141119))
- [Ensure dashboards change to 1 column mode at small sizes](gitlab-org/gitlab@b4284b232a522fc683b3fd5db46d98bc869ee5c0) ([merge request](gitlab-org/gitlab!141306)) **GitLab Enterprise Edition**
- [Filter out banned users in Contribution Analytics](gitlab-org/gitlab@78fc222156a6f07356714ae3f2db369419f43071) ([merge request](gitlab-org/gitlab!140987)) **GitLab Enterprise Edition**
- [Remove the commit count button](gitlab-org/gitlab@3cc3d014f867894a10abcbb8f0895678baf22233) ([merge request](gitlab-org/gitlab!140780))
- [Move Cloud Seed files to cloud_seed namespace](gitlab-org/gitlab@2fbd205f31ff270e2021c56ffc393ae4a8fa7a31) ([merge request](gitlab-org/gitlab!141262))
- [Update nio4r gem to v2.7.0](gitlab-org/gitlab@08a8a27d3ad35de716e33e0765e35dc74303a6e8) ([merge request](gitlab-org/gitlab!141219))
- [This MR fixes component registration in tests](gitlab-org/gitlab@b4d93fa964fac4d87017afa85a0216cf65a64ed2) ([merge request](gitlab-org/gitlab!140930)) **GitLab Enterprise Edition**
- [Improve tests for filtering admin runners by creator](gitlab-org/gitlab@3f43aba8e5cb70c6dbcd1d11c9e31bb7a360d6a1) by @zzaakiirr ([merge request](gitlab-org/gitlab!139361))
- [Switch Zero Shot agent request traffic to AI Gateway](gitlab-org/gitlab@4844605bc6dafae1bc0d432106b1e51cda8a8c64) ([merge request](gitlab-org/gitlab!141209)) **GitLab Enterprise Edition**
- [Make review emails easier to view on mobile](gitlab-org/gitlab@b951683c533bd3c53d278c4986cf88ca41a60fa4) ([merge request](gitlab-org/gitlab!141187))
- [Current user todos widget service to use callbacks](gitlab-org/gitlab@a3e41129eac9c2e8c313252a23e271d2f945964a) by @imskr ([merge request](gitlab-org/gitlab!141186))
- [Drop dependency on nokogiri for GitLab gems](gitlab-org/gitlab@89bbe66a18eb982cb281fd854cb98242940dccd8) ([merge request](gitlab-org/gitlab!141182))
- [Use (merge) base pipelines as SRP comparison pipelines](gitlab-org/gitlab@ea7953ad62f1d21ca58111684f9daf30b4587e49) ([merge request](gitlab-org/gitlab!140348)) **GitLab Enterprise Edition**
- [Remove pending_status_check_responses ff](gitlab-org/gitlab@e0a3e2ba01917aeb11a7a844ecf924d232cfbf9a) ([merge request](gitlab-org/gitlab!141159)) **GitLab Enterprise Edition**
- [Remove timeout_status_check_responses ff](gitlab-org/gitlab@17424cdb025df0bcd7de3d839dd070a5a734b835) ([merge request](gitlab-org/gitlab!141152)) **GitLab Enterprise Edition**
- [Increase the height of square and landscape logos](gitlab-org/gitlab@efe69349df66b21035d74df9c158df975da829c0) ([merge request](gitlab-org/gitlab!141137))
- [This MR fixes component registration in tests](gitlab-org/gitlab@3cbf1092f733cc20208e6f470bc08f4c9b635f16) ([merge request](gitlab-org/gitlab!141009)) **GitLab Enterprise Edition**
- [Project overview: Reorder more dropdown items](gitlab-org/gitlab@45273b598f69ae879b61b661034df51d74c76a04) ([merge request](gitlab-org/gitlab!140050))
- [Remove extra space around preferences link in shortcuts modal](gitlab-org/gitlab@6c870e656a82eec43fc236548fc49e18ae899567) ([merge request](gitlab-org/gitlab!141084))
- [Add migration to drop documents with old schema version](gitlab-org/gitlab@927c04c19fe4e60c505fe01618694345bebe3d27) ([merge request](gitlab-org/gitlab!140867)) **GitLab Enterprise Edition**
- [Adds tooltip to clarify container image storage](gitlab-org/gitlab@9ea67aa74dfed6796e3c00767d49d973b662aca4) ([merge request](gitlab-org/gitlab!140643))
- [Update uri gem to v0.13.0](gitlab-org/gitlab@915331b2e4db93b993cd3f83ee68052c57883b50) ([merge request](gitlab-org/gitlab!141053))
- [This MR fixes component registration in tests](gitlab-org/gitlab@eb4f32270d307e99d754f94e5ca0dd1a842f00bc) ([merge request](gitlab-org/gitlab!140994)) **GitLab Enterprise Edition**
- [This MR fixes component registration in tests](gitlab-org/gitlab@49e76eff1bc2d9de3e012aae52ab7a6d79a69889) ([merge request](gitlab-org/gitlab!141007)) **GitLab Enterprise Edition**
- [Add `Dismissal Reason` to the vulnerability csv report](gitlab-org/gitlab@4034e2f3934868c072bde90874eab7216046d342) ([merge request](gitlab-org/gitlab!140664)) **GitLab Enterprise Edition**
- [Improve accessibility in the two factor page](gitlab-org/gitlab@cfc72d2bb38b200ab6de9b35b5eae208136af21f) ([merge request](gitlab-org/gitlab!141029))
- [Add icon to branch and tag](gitlab-org/gitlab@7786e42e315b714914bbe12289c9e8b329d16435) ([merge request](gitlab-org/gitlab!140217))
- [Default ci_finished_builds timestamps to zero](gitlab-org/gitlab@5e854c80cbcd6e7f64d0c81f3c96246ec712ea85) ([merge request](gitlab-org/gitlab!140804))
- [Remove feature flag package_metadata_advisory_sync](gitlab-org/gitlab@d7bd2ff95e7c4486f6ecbd45eec9dd157289e6dc) ([merge request](gitlab-org/gitlab!140166)) **GitLab Enterprise Edition**
- [This MR adds pagination for toggle list](gitlab-org/gitlab@c384d2071120f62f7d37da189588d56b103fbe61) ([merge request](gitlab-org/gitlab!140485)) **GitLab Enterprise Edition**
- [Remove validation of title_html and description_html](gitlab-org/gitlab@6e9270d90d0a670e988fc3ca42503202dd8360e6) ([merge request](gitlab-org/gitlab!140857)) **GitLab Enterprise Edition**
- [Remove scan_result_policy_license_scanning_merge_base_pipeline flag](gitlab-org/gitlab@06fe12971fe808b162f508e58d7a9b518fdc7662) ([merge request](gitlab-org/gitlab!140854)) **GitLab Enterprise Edition**
- [Add possibility to add new branch rules](gitlab-org/gitlab@3c1cee4dc72687f18e964456eef6f1f2b2506b41) ([merge request](gitlab-org/gitlab!140319))
- [Add order and bump migration version](gitlab-org/gitlab@219c2b83829863b3a6d0afae429da1995d216ccb) ([merge request](gitlab-org/gitlab!140863)) **GitLab Enterprise Edition**
- [Make value field resizable in CI Variables form](gitlab-org/gitlab@5ddf345cfb06fcff26b638431e67b419b9f9a6b0) ([merge request](gitlab-org/gitlab!140837))
- [Replace epics issue_id foreign key to nullify on delete](gitlab-org/gitlab@137fbdfd58b2ff00ed8790bca126d7c57a912c56) ([merge request](gitlab-org/gitlab!140666))
- [Add validations for bucket name for AWS](gitlab-org/gitlab@cacd199e632e6d16625732d21c93abbeb744c676) ([merge request](gitlab-org/gitlab!140779)) **GitLab Enterprise Edition**
- [Synchronously validate `finding_id` FK on vulnerabilities](gitlab-org/gitlab@4b83fe02c431bd91a7d9618032264404f9cb5f4b) ([merge request](gitlab-org/gitlab!140775)) **GitLab Enterprise Edition**
- [Return 401 token invalid form graphql](gitlab-org/gitlab@ccd8ba2f02ed931eeb5fb2750fc5c7fdbd937421) ([merge request](gitlab-org/gitlab!140761))
- [Update dependency auto-deploy-image to v2.76.0](gitlab-org/gitlab@0c4bd26f836d3e99511e59817e825eca4d43d010) ([merge request](gitlab-org/gitlab!140744))
- [Allow personal namespaces to use aggregated VSA](gitlab-org/gitlab@d6bcbdbc8cb31c854de132243976a4d0c275e774) ([merge request](gitlab-org/gitlab!138731)) **GitLab Enterprise Edition**
- [Asynchronously validate `finding_id` foreign key on vulnerabilities](gitlab-org/gitlab@c42dbc0eda145d8f2c049ec4f9ef276cdde0b972) ([merge request](gitlab-org/gitlab!131979)) **GitLab Enterprise Edition**
- [Add a prefix to CI Build tokens behind a feature flag](gitlab-org/gitlab@6100ae4f8947221438de3f668587841c2115437b) ([merge request](gitlab-org/gitlab!140159))
- [Changed milestone burn chart to use segmented control](gitlab-org/gitlab@9a9c97d3074f36f2c37b8ed3ae205c2464a8b889) by @zillemarco ([merge request](gitlab-org/gitlab!139641))
- [Add tooltip to move card button in boards](gitlab-org/gitlab@1ddb86df6f607824ef755c63b87758884f79c89e) ([merge request](gitlab-org/gitlab!140389))
- [Remove `rules` from target branch rules name](gitlab-org/gitlab@08cc21206f6a29fcb200be9b130beec4090223e8) ([merge request](gitlab-org/gitlab!139738)) **GitLab Enterprise Edition**
- [Add CI runner managers finder](gitlab-org/gitlab@955abe4b7ee5b8121dc4bf347c265aa5a0423f98) by @zzaakiirr ([merge request](gitlab-org/gitlab!137888))
- [api: Expose `archived` field for CI jobs](gitlab-org/gitlab@5e374cdfebd99ab12d99464d6a40ddea400e3206) ([merge request](gitlab-org/gitlab!140285))
- [Relocate admin mode switch from command palette to user menu](gitlab-org/gitlab@520287a553bd4997043e96f985516f60f89dd7c5) ([merge request](gitlab-org/gitlab!140254))
- [Add published_at to ContainerRegistry::Tag](gitlab-org/gitlab@75b29e5338016f8f66c0201f032b963922e0bfe2) ([merge request](gitlab-org/gitlab!140188))
- [Remove custom styling of tab elements](gitlab-org/gitlab@cf37a92c56efe306ff627e9b9185b72a5970dfeb) ([merge request](gitlab-org/gitlab!139956))
- [Added control to limit users to create group/project](gitlab-org/gitlab@3652d4ad72f8308baaff757ec936404ec8c40ec8) ([merge request](gitlab-org/gitlab!134630))
- [Remove btn-group class from all listbox helper](gitlab-org/gitlab@a1fd8d48e212951a631a61b9498eeda708ae7b2f) ([merge request](gitlab-org/gitlab!138575))
- [Remove final instances of `group_icon`](gitlab-org/gitlab@3ddb701d3d0808abca3fc4d5771176320dccc0a3) by @yonghyun.jin13 ([merge request](gitlab-org/gitlab!139205))
- [Move organization_users to gitlab_main_cell](gitlab-org/gitlab@733516319d7a599f491a816b53ff5d013540565c) ([merge request](gitlab-org/gitlab!140343))
- [Add frontend for standards adherence export](gitlab-org/gitlab@efa504209dcde9f33db643d2c2a084d4dc07f0c0) ([merge request](gitlab-org/gitlab!138807)) **GitLab Enterprise Edition**
- [This MR adds policy scope to a drawer](gitlab-org/gitlab@5a1b75b63de01ebb710ff1c3146646035fa94682) ([merge request](gitlab-org/gitlab!138720)) **GitLab Enterprise Edition**
- [Save external_identifiers on ImportFailure for file import relations](gitlab-org/gitlab@82b0d0b5dc2fcf2585b05bf58a072455eb6e103e) ([merge request](gitlab-org/gitlab!139653))
- [Add slug to topics](gitlab-org/gitlab@bce941042ea8d4cc5d0c33b4b645c158bb2dcb6e) by @zzaakiirr ([merge request](gitlab-org/gitlab!139269))
- [Reset repository checksum before publishing an updated event](gitlab-org/gitlab@a891f53fbf2d527f2fa36c356d6664a037905e31) ([merge request](gitlab-org/gitlab!139282)) **GitLab Enterprise Edition**
- [Added modifier for wild card count link](gitlab-org/gitlab@2b5951ac91756e751ceed6e47c7fa167187608c4) ([merge request](gitlab-org/gitlab!138302))
- [Fixing jest spec violations for Vue.js v3 Migration](gitlab-org/gitlab@f3c02a09465d3717cf537f25133a1d10249d1421) ([merge request](gitlab-org/gitlab!135610))
- [Use specific FullPathResolver descriptions](gitlab-org/gitlab@b4ae53260d798973ca189be99fb35f514663b8ff) by @ayushya0612 ([merge request](gitlab-org/gitlab!140120))
- [Update description in CI/CD Variables settings](gitlab-org/gitlab@012757050062d3145c5e3773b53c2d0b21fe465f) ([merge request](gitlab-org/gitlab!140461))
- [Send GitLab version and hostname during instance activation](gitlab-org/gitlab@89c7375ed69803cb09d8a12fd2bca95f51616090) ([merge request](gitlab-org/gitlab!140104)) **GitLab Enterprise Edition**
- [Save phone verification record when the number relates to a banned user](gitlab-org/gitlab@9254c01f8ce4b4de3f6525add38da334bddae7e8) ([merge request](gitlab-org/gitlab!139083)) **GitLab Enterprise Edition**
- [Add index for events to efficiently query user contributions](gitlab-org/gitlab@1f2a60c7420cf4a0d844d4d56dedf082bc094bcc) by @zzaakiirr ([merge request](gitlab-org/gitlab!139928))
- [Set default vuln report filter to 'Still Detected'](gitlab-org/gitlab@c70d04a0eb355da494ffc64ba1dff34987d9cd37) ([merge request](gitlab-org/gitlab!137186)) **GitLab Enterprise Edition**
- [Update dependency auto-deploy-image to v2.72.0](gitlab-org/gitlab@496da637158b7a9bdc088bbd265aad176e15f887) ([merge request](gitlab-org/gitlab!140351))
- [Change i_code_review_create_mr metric to total counts](gitlab-org/gitlab@7fd2d70f1c98571e0243c130216e2877df3ca998) ([merge request](gitlab-org/gitlab!138030))
- [Add a prefix to SCIM tokens behind a feature flag](gitlab-org/gitlab@f09de3db0ed92ce55c39a50dabf2125b9d0daa1f) ([merge request](gitlab-org/gitlab!139737)) **GitLab Enterprise Edition**
- [Change telesign_intelligence feature flag type to ops](gitlab-org/gitlab@ee5cd032bc2ba7cfcfd291d71aec5f6b14e2de6c) ([merge request](gitlab-org/gitlab!140309)) **GitLab Enterprise Edition**
- [Notes: Refactor CSS](gitlab-org/gitlab@33210e27caebe57bad3ecdde8caaa613581c4fda) ([merge request](gitlab-org/gitlab!140089))
- [Analytics dashboards UI polish](gitlab-org/gitlab@55a73762fed682a3af8166c366c8e68d84af1303) ([merge request](gitlab-org/gitlab!139565)) **GitLab Enterprise Edition**
- [Fix images not pasting in RTE](gitlab-org/gitlab@7f28622a4d3e40097aa37f32060056d5b9f80ec5) ([merge request](gitlab-org/gitlab!140298))
- [Remove in_product_marketing_emails model and table](gitlab-org/gitlab@8bb4c2eb71afa0f18dc2dfe9f5d125bdf25d5e91) ([merge request](gitlab-org/gitlab!138835))
- [Use plural form for packages & registries settings alerts](gitlab-org/gitlab@087137e6df2fd5573309b8c2d382ca8d830eb589) by @zzaakiirr ([merge request](gitlab-org/gitlab!139407))
- [This MR updated yaml preview](gitlab-org/gitlab@c0e1070545824b07938318fee03fe0a4da62215f) ([merge request](gitlab-org/gitlab!140269)) **GitLab Enterprise Edition**
- [Compare most recent SBOM pipeline for license approval policies](gitlab-org/gitlab@40ef1bbc8af023680ef10e6b0c07643c38e8eba7) ([merge request](gitlab-org/gitlab!136695)) **GitLab Enterprise Edition**
- [Improve info on Free Public Namespaces](gitlab-org/gitlab@ebdd0bec38ccce203571f6d0145d19d7aad12713) ([merge request](gitlab-org/gitlab!138802)) **GitLab Enterprise Edition**
- [Center the content of the login page](gitlab-org/gitlab@c7ff768cf2c2d2f0090dd8ce7baa47c025967ed0) ([merge request](gitlab-org/gitlab!140116))
- [Add params and sorting to group users API](gitlab-org/gitlab@97bac7482e9781e81b7325bedc97dfd53c6864e9) ([merge request](gitlab-org/gitlab!140241)) **GitLab Enterprise Edition**
- [Refactor code_suggestions_ga_non_owner_alert feature spec](gitlab-org/gitlab@df62b7db33c94573ee51f4ab44debc1a67dd50ae) ([merge request](gitlab-org/gitlab!140225)) **GitLab Enterprise Edition**
- [Remove restyle_login_page feature flag](gitlab-org/gitlab@6c00fd1a3f62a73642be3564fa44ebbad9b62daa) ([merge request](gitlab-org/gitlab!139677))
- [Remove feature flag ci_job_token_scope](gitlab-org/gitlab@4b5d3693307298f2491be4cc406313ce9540469a) ([merge request](gitlab-org/gitlab!139862))
- [MR code button: Migrate to GlButton](gitlab-org/gitlab@c83969dfdcb3ce0238a97c05a1b38a534fb911a0) ([merge request](gitlab-org/gitlab!140181))
- [Use /react as the primary command](gitlab-org/gitlab@58104079d6a45408e2e90cbfd083752de72782be) ([merge request](gitlab-org/gitlab!139504))
- [Introduce a timeout when finding or creating a container repository](gitlab-org/gitlab@578edaa657a7f34a76254f1cc5ab01b58afcf57d) ([merge request](gitlab-org/gitlab!138616))
- [Update dependency auto-deploy-image to v2.71.1](gitlab-org/gitlab@2fdaa3f040a7fd189957545e23e12458d6cf4f21) ([merge request](gitlab-org/gitlab!140157))
- [Update users stats tables to use full width](gitlab-org/gitlab@1ee53cfaa78b078041048380c8d8b6ed0bccd0fc) ([merge request](gitlab-org/gitlab!139786))
- [Refactor notifications service](gitlab-org/gitlab@5b7549464cf33a2608ef79eedff6bbe8c38bcaa2) by @imskr ([merge request](gitlab-org/gitlab!140004))
- [Update feedback banner](gitlab-org/gitlab@5b8f24f8c25611090ceb6e62cfcd55394938e5b0) by @davidwatts111 ([merge request](gitlab-org/gitlab!139879))
- [Updating policy ui](gitlab-org/gitlab@6e182015b42a8b8ff98d74e980aed1c21ee43280) by @davidwatts111 ([merge request](gitlab-org/gitlab!139489)) **GitLab Enterprise Edition**

### Removed (43 changes)

- [Delete skip_refresh_project_policies feature flag](gitlab-org/gitlab@8bb6972a230d407e8c56d7862aa50c97d6f34351) ([merge request](gitlab-org/gitlab!141653)) **GitLab Enterprise Edition**
- [Remove convert_user_to_group_managed_accounts, remove_non_gma_memberships FFs and related code](gitlab-org/gitlab@e6fb44c93ed7e64af9e1eac30478fa2116b201ca) ([merge request](gitlab-org/gitlab!127388)) **GitLab Enterprise Edition**
- [Remove code_suggestions_used_by_default flag](gitlab-org/gitlab@02f38cf96461b0e14b7295bd7ea64b4b0656ba98) ([merge request](gitlab-org/gitlab!141080)) **GitLab Enterprise Edition**
- [Clean up environment alert experiment](gitlab-org/gitlab@bd6af624e172b99873f73a06c4bda5e0a2f5c201) ([merge request](gitlab-org/gitlab!141032))
- [Remove namespace CI Catalog](gitlab-org/gitlab@30b4ffbe6a1bc64ad17ee73d8c08cbc4732f8435) ([merge request](gitlab-org/gitlab!140725)) **GitLab Enterprise Edition**
- [Remove geo_repository_replicator_legacy_behaviour feature flag](gitlab-org/gitlab@602a08d4eb60b9b48e3c00d6d409f5d4c0d12ab4) ([merge request](gitlab-org/gitlab!141304)) **GitLab Enterprise Edition**
- [Remove unused tag_name and tag_path from VersionType](gitlab-org/gitlab@23be76995d5c46f0c7ccd2b24e21fa0649511838) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/140970))
- [Drop `epic_id` Column From Vulnerabilities](gitlab-org/gitlab@3f4b140f41baf8b11a804c7a3d3aad6b5b6e3685) ([merge request](gitlab-org/gitlab!138263))
- [Drop `milestone_id` Column From Vulnerabilities](gitlab-org/gitlab@fdf2fc2a01dc987d8059e279274913b989335786) ([merge request](gitlab-org/gitlab!138262))
- [Remove browrsersdk_tracking feature flag](gitlab-org/gitlab@05d169c14ca34509403e74ff3ce3203c9e20e80f) ([merge request](gitlab-org/gitlab!141212))
- [Remove CA page size feature flag](gitlab-org/gitlab@af3285110ac658ae8bb48c6c46cf7d08d0d267b9) ([merge request](gitlab-org/gitlab!141075)) **GitLab Enterprise Edition**
- [Drop `start_date` Column From Vulnerabilities](gitlab-org/gitlab@ff11c881b59b389770f5c23b9390e4d68c2d1827) ([merge request](gitlab-org/gitlab!138268))
- [Remove individual permissions from MemberRole API](gitlab-org/gitlab@3e6d4b371b5d7fcac369552f36071fa1ef99df03) ([merge request](gitlab-org/gitlab!140715)) **GitLab Enterprise Edition**
- [Drop `updated_by_id` Column From Vulnerabilities](gitlab-org/gitlab@9d0996611446b55114b3d9e33e7efba14c7a1251) ([merge request](gitlab-org/gitlab!138264))
- [Drop `last_edited_by_id` Column From Vulnerabilities](gitlab-org/gitlab@7de5f7ce28c4ed4fad5a6e9bbb8bcb752a1372aa) ([merge request](gitlab-org/gitlab!138266))
- [Drop `last_edited_at` Column From Vulnerabilities](gitlab-org/gitlab@367f6734775ad55cc6cc250578c5feae6b4a026a) ([merge request](gitlab-org/gitlab!138269))
- [Removes sidebar_build_class method](gitlab-org/gitlab@7cf6e05f127dd68969ada0dd73c5feeaba95ef19) by @tedtran2019 ([merge request](gitlab-org/gitlab!140508))
- [Removes `format_project_count` method](gitlab-org/gitlab@5b01f2c09c7593ee18a90e4a4a836bc032e6f194) by @tedtran2019 ([merge request](gitlab-org/gitlab!140593)) **GitLab Enterprise Edition**
- [Cleanup the feature flag inherit_higher_access_levels_no_cross_join](gitlab-org/gitlab@03d1c3af044a6ce0123a66aa49865641a7a84be8) ([merge request](gitlab-org/gitlab!140703))
- [Remove `delayed_project_removal_help_text`](gitlab-org/gitlab@6b7f9723f22ec0ea894331d92c8e34bc03f5d92d) by @tedtran2019 ([merge request](gitlab-org/gitlab!140405)) **GitLab Enterprise Edition**
- [Removes ci_status_for_statuseable method](gitlab-org/gitlab@80e3a3772dbbe40054665ed79cf4e6bbfb2f6d1b) by @tedtran2019 ([merge request](gitlab-org/gitlab!140644))
- [Drop `due_date` Column From Vulnerabilities](gitlab-org/gitlab@2f8e48e4b2a4edc50423b95c93e2be3c5d660526) ([merge request](gitlab-org/gitlab!138267))
- [Removes ci_variable_masked? method](gitlab-org/gitlab@30ce11cfcf0594e28a5292f11979c67cf1183254) by @tedtran2019 ([merge request](gitlab-org/gitlab!140512))
- [Removes root_ancestor_namespace method](gitlab-org/gitlab@c01bbb5dbbc2fea2f67e77ff904d4cff587d26bd) by @tedtran2019 ([merge request](gitlab-org/gitlab!140589)) **GitLab Enterprise Edition**
- [Remove temp index from members table](gitlab-org/gitlab@fdbabef67d74b19c8a47c739b40ec0408e834a7f) ([merge request](gitlab-org/gitlab!140559))
- [Removes environment_for_build method](gitlab-org/gitlab@ab2d8d46bac02b5cbc5f252b85ed4f2c81e7e3c8) by @tedtran2019 ([merge request](gitlab-org/gitlab!140515))
- [Removes ci_variable_type_options method](gitlab-org/gitlab@05382c6b9e260b4124c151cf6346f67f1b7da0c3) by @tedtran2019 ([merge request](gitlab-org/gitlab!140513))
- [Removes pipeline_status_cache_key method](gitlab-org/gitlab@16c4fbe629c9a27acb55320ea5458a5944f216bc) by @tedtran2019 ([merge request](gitlab-org/gitlab!140510))
- [Removes omnibus_protected_paths_throttle? method](gitlab-org/gitlab@7cf34c768c8353e6fcbaaeb2faef91e6cc9450a3) by @tedtran2019 ([merge request](gitlab-org/gitlab!140507))
- [Removes vulnerability_data_with_category method](gitlab-org/gitlab@35afb89a619cc234cf6f92b69fe72059f7658f57) by @tedtran2019 ([merge request](gitlab-org/gitlab!140506)) **GitLab Enterprise Edition**
- [Removes show_trial_namespace_select? method](gitlab-org/gitlab@6ad837b06b1d48c99d4b9526edb5a36c09bb4700) by @tedtran2019 ([merge request](gitlab-org/gitlab!140505)) **GitLab Enterprise Edition**
- [Removes  any_project_not_in_hashed_storage? method](gitlab-org/gitlab@4392dda2c5a4ec25ef3ed0b14cb1b6f6e13ba1d5) by @tedtran2019 ([merge request](gitlab-org/gitlab!140504)) **GitLab Enterprise Edition**
- [Removes show_profile_token_expiry_notification?](gitlab-org/gitlab@1af369c180eb09045fd2ac4b8a65707a78fdfe5e) by @tedtran2019 ([merge request](gitlab-org/gitlab!140502)) **GitLab Enterprise Edition**
- [Removes sort_title_project_name method](gitlab-org/gitlab@ff1cc0833da137d4262eb98eec77463640cd8fe5) by @tedtran2019 ([merge request](gitlab-org/gitlab!140408)) **GitLab Enterprise Edition**
- [Removes methods from sorting_titles_values_helper](gitlab-org/gitlab@bbc2f63b51b8a30fdbbe66acff2976aab735c439) by @tedtran2019 ([merge request](gitlab-org/gitlab!140409)) **GitLab Enterprise Edition**
- [Removes keep_deleted_option_label method](gitlab-org/gitlab@0511ddda1030fff71cf9e62b848df24902cb7cc6) by @tedtran2019 ([merge request](gitlab-org/gitlab!140406)) **GitLab Enterprise Edition**
- [Removes delayed_deletion_disabled method](gitlab-org/gitlab@40b6f6feb436ad8bdac8072baa12adf87ab6185b) by @tedtran2019 ([merge request](gitlab-org/gitlab!140407)) **GitLab Enterprise Edition**
- [Remove gitlab_routing_helper.rb: upgrade_plan_path](gitlab-org/gitlab@3eb42851d6ee0c6f9e0175ab7f91ea5d6b308e6a) by @tedtran2019 ([merge request](gitlab-org/gitlab!140404)) **GitLab Enterprise Edition**
- [Remove geo_helper.rb: prepare_error_app_data](gitlab-org/gitlab@6d4d35bf7d48ab06ab37df42fa45d71de8344c80) by @tedtran2019 ([merge request](gitlab-org/gitlab!140400)) **GitLab Enterprise Edition**
- [Removes users_helper.rb: users_sentence](gitlab-org/gitlab@386f24b229f96465687d8bb36e49ad1a065d9857) by @tedtran2019 ([merge request](gitlab-org/gitlab!140396)) **GitLab Enterprise Edition**
- [Drop `start_date_sourcing_milestone_id` Col From Vulnerabilities](gitlab-org/gitlab@dd05e8fcf7e5d9d834c47a70aee2322065294e84) ([merge request](gitlab-org/gitlab!138270))
- [Drop `due_date_sourcing_milestone_id` Col From Vulnerabilities](gitlab-org/gitlab@74d1a0fbbee3a5b865adcabbc93721f3fce72b50) ([merge request](gitlab-org/gitlab!138271))
- [Drop index users_forbidden_state_idx](gitlab-org/gitlab@adf2f61035c7214a8c7ac4c66cf2a42745371844) ([merge request](gitlab-org/gitlab!139958))

### Performance (4 changes)

- [Cleanup referenced FK ci_job_artifacts](gitlab-org/gitlab@2e7c416c999dbc1feb67d7a0803e10cacab6e341) ([merge request](gitlab-org/gitlab!141474))
- [Bulk create license scan result policies](gitlab-org/gitlab@6b884e14c0be4178d564c52bef71f2ec592d85e0) ([merge request](gitlab-org/gitlab!139163)) **GitLab Enterprise Edition**
- [Remove feature flag `optimize_where_full_path_in`](gitlab-org/gitlab@95c2f51680291034c3c5a392712555b09cf5631a) ([merge request](gitlab-org/gitlab!141008))
- [Add pagination to UsersController#groups](gitlab-org/gitlab@f53167b6015a9a8c1777a5cdd90b5f47f0a85198) ([merge request](gitlab-org/gitlab!140194))

### Other (73 changes)

- [Refactor member roles front-end to use GraphQL instead of REST API](gitlab-org/gitlab@c3d919d0c7cb430d4587ad35f41c792c974a86a5) ([merge request](gitlab-org/gitlab!141064)) **GitLab Enterprise Edition**
- [Add a constraint to ensure application_settings.rate_limits is a hash](gitlab-org/gitlab@a02d2e551e09f731d21eddd2345dea8fd2769bec) ([merge request](gitlab-org/gitlab!141765))
- [Clean up FF scan_result_any_merge_request from backend](gitlab-org/gitlab@4269aa1e2269974330e7d275df9769b910dee4c4) ([merge request](gitlab-org/gitlab!141506)) **GitLab Enterprise Edition**
- [Remove unused prompt files for completion and generation](gitlab-org/gitlab@40cc9c3d108613b8d4cea71e04244d410bc2c08a) ([merge request](gitlab-org/gitlab!141545))
- [Fix tooltips on group "Shared projects" view](gitlab-org/gitlab@019cfd2c2493d0aeb6f7b0457490fdec85954a8a) by @antonykor.ak ([merge request](gitlab-org/gitlab!141493))
- [Prepare partitioning constraints for ci_pipeline_variables](gitlab-org/gitlab@5bd44c4901547ea8c8d91f38d245d98524463c67) ([merge request](gitlab-org/gitlab!137643))
- [Add sharding keys for feature category compliance_management](gitlab-org/gitlab@c1492bb0048d9cda22ec2ab8e537a5c4547c69fe) ([merge request](gitlab-org/gitlab!141568))
- [Add sharding key `group_id` to agent_user_access_group_authorizations](gitlab-org/gitlab@aa2e33373260d5e0b9f7acf51fea249c817f2467) ([merge request](gitlab-org/gitlab!141565))
- [Add sharding key `project_id` to agent_project_authorizations](gitlab-org/gitlab@0781b1b0aed2338b2788328ceee3c028a3a8a009) ([merge request](gitlab-org/gitlab!141564))
- [Remove geo_proxy_lfs_batch_requests feature flag](gitlab-org/gitlab@af53d6e333a60e2b7372c5f4d085d76006920c77) ([merge request](gitlab-org/gitlab!141516)) **GitLab Enterprise Edition**
- [Remove FF bulk_imports_batched_import_export](gitlab-org/gitlab@1d6c783df41dc47768e13b05be56f61c38c14e7c) ([merge request](gitlab-org/gitlab!135394))
- [test: Test for feature flag in package registry settings](gitlab-org/gitlab@03acd6ba3783a6e039f909966d35a59196d4f4f1) by @gerardo-navarro ([merge request](gitlab-org/gitlab!141113))
- [Fix text alignment in GitLab Pages Domain-level redirects](gitlab-org/gitlab@4eace52c0b4d3bf767a74364cea4b6480f7cdf18) ([merge request](gitlab-org/gitlab!141447))
- [Protected packages: Return ServiceResponse for CreateNpmPackageService](gitlab-org/gitlab@1305cba2091e899bece5057e280eb2962feff27f) by @gerardo-navarro ([merge request](gitlab-org/gitlab!140778))
- [Move group_setting app outside components directory](gitlab-org/gitlab@a819a8be60ad281bdb5326a3a795a3eaa48b7c59) ([merge request](gitlab-org/gitlab!141082)) **GitLab Enterprise Edition**
- [Docs: Support domain-level redirects](gitlab-org/gitlab@d5a07568327cf154bec69a4fdd4cc39bb3341d39) ([merge request](gitlab-org/gitlab!138515))
- [Ignore project_import_level column](gitlab-org/gitlab@05f6a5176aae7d4f85e175ebbf54d43bd9071dfb) ([merge request](gitlab-org/gitlab!141188))
- [Remove in_factory_bot_create?](gitlab-org/gitlab@b823114b0bed11aa6dd53b7afffb2e5c92fe13e8) ([merge request](gitlab-org/gitlab!141286))
- [Create index asynchronously for system_note_metadata](gitlab-org/gitlab@4d15308a50130f05d3dc4be44c0c5cddc65b83b3) ([merge request](gitlab-org/gitlab!141330))
- [Remove bulk_import_details_page feature flag](gitlab-org/gitlab@1cedf335988c547892a09e1ca2af64ee1c788291) ([merge request](gitlab-org/gitlab!140719))
- [Add support for split button loading](gitlab-org/gitlab@32d52d5ba5e9c15ccaf8fb426f57b122a3e74c95) ([merge request](gitlab-org/gitlab!141251)) **GitLab Enterprise Edition**
- [Remove default values ci_pipeline_chat_data#partition_id](gitlab-org/gitlab@e7ca0ad5dae1215f45b5e7f86ee781dcc23f219c) ([merge request](gitlab-org/gitlab!141071))
- [Remove feature flag security_policies_variables_precedence](gitlab-org/gitlab@03a62101da58852cc5f2b947b4a6e7a2aefa9850) ([merge request](gitlab-org/gitlab!140883)) **GitLab Enterprise Edition**
- [Add role to organization_users and assign creator as owner](gitlab-org/gitlab@919a830b673ce3d56e5fc36e3b9fd0b9b62f138c) ([merge request](gitlab-org/gitlab!140817))
- [Rename app component to reflect its purpose](gitlab-org/gitlab@65021b7868683c2a8628eb1fc5766564336d52a8) ([merge request](gitlab-org/gitlab!140337)) **GitLab Enterprise Edition**
- [Backfill namespace_id for issue_search_data](gitlab-org/gitlab@23dcb9408278b82377a9dc4453a8f99e2d76addd) ([merge request](gitlab-org/gitlab!128010))
- [refactor: Add missing feature category to controller tests](gitlab-org/gitlab@f9181f5e4f985129b2f18eb5090d5b953a4527d3) by @gerardo-navarro ([merge request](gitlab-org/gitlab!141121))
- [Refactor ForkService tests](gitlab-org/gitlab@d98fb44526c5094479ff475220da498c192033ad) ([merge request](gitlab-org/gitlab!141003))
- [Stablize test to remove side effects](gitlab-org/gitlab@e4b1dfd22277d3a37823e392ab30c7fd4372abce) ([merge request](gitlab-org/gitlab!135165))
- [Drop plain-text columns from user_credit_card_validations table](gitlab-org/gitlab@3d2839f84a7dec213425c596d256f29dfb03cb4d) ([merge request](gitlab-org/gitlab!139734))
- [Add index for owasp_top_10 to vulnerability_reads](gitlab-org/gitlab@3c72701980a18d4c7c5b941fc623baa5c88ee37b) ([merge request](gitlab-org/gitlab!141045))
- [Fix a false-positive test](gitlab-org/gitlab@7fd0489925c0d71abf7bb30843027e00594d6cfc) ([merge request](gitlab-org/gitlab!140988))
- [Remove the FF use_gitlab_http_v2](gitlab-org/gitlab@cadfad1c11fc7b7edbd998663428f80ae8ae5e78) ([merge request](gitlab-org/gitlab!140789))
- [Remove feature flag user_approval_rules_removal](gitlab-org/gitlab@a48fe5a6e09ff803ad72a5bc5347d5451b69614a) ([merge request](gitlab-org/gitlab!140887))
- [Backfill version field batch migration](gitlab-org/gitlab@0c120c2e0211dd72b8f34027a19bc678e3f8b57f) ([merge request](gitlab-org/gitlab!140091))
- [Upgrade the Sidekiq gem to v7.1.6](gitlab-org/gitlab@e4a291c48ba2f8173d2c8dd462caba5dd0cd83ab) ([merge request](gitlab-org/gitlab!138882))
- [Remove create_user_ns_outside_model feature flag](gitlab-org/gitlab@51f7c658fab6200e09b58a4f1931585a2c518bf0) ([merge request](gitlab-org/gitlab!140835))
- [Docs: GitLab Pages rate-limiting for IPv6 should be based on /64 prefix](gitlab-org/gitlab@ff8ca76b7d5799f9a5a0ee568dd70e17c64c2899) ([merge request](gitlab-org/gitlab!140059))
- [Ban use of License in ApplicationSetting model](gitlab-org/gitlab@843ecc2482277daf9876f86e1c10b2548f0b2df9) ([merge request](gitlab-org/gitlab!140669)) **GitLab Enterprise Edition**
- [Show the most correct set of approval rules post merge](gitlab-org/gitlab@a0367645ae42b087cbae2ac44a188062a43f92b6) ([merge request](gitlab-org/gitlab!133665))
- [Migrates OmniAuth login button to use Pajamas](gitlab-org/gitlab@8dd2da2e6485133bc09a36d3f2324deefc3b2c29) ([merge request](gitlab-org/gitlab!140294))
- [Update AI generated MR text](gitlab-org/gitlab@32a5c20a88382303f8f0d9c45f375068a616d092) ([merge request](gitlab-org/gitlab!140813))
- [Remove feature flag always_set_pipeline_failure_reason](gitlab-org/gitlab@b6239b10019f4c383012076ee2529c988aee1e94) ([merge request](gitlab-org/gitlab!140494))
- [Backfill owasp_top_10 on existing vulnerability_reads records](gitlab-org/gitlab@ea49ae6e66d8256d21799f5291671a6fd3c9eab5) ([merge request](gitlab-org/gitlab!139544))
- [test: Remove duplicate test cases for Npm::CreatePackageService](gitlab-org/gitlab@eae3fc1c7372ad00ab51140b57579f888edf4d0a) by @gerardo-navarro ([merge request](gitlab-org/gitlab!140781))
- [Remove feature flag allow_streaming_instance_audit_events_to_amazon_s3](gitlab-org/gitlab@f447eeec3ee37c961637ef0ee61f0dcd297ab6d7) ([merge request](gitlab-org/gitlab!140774)) **GitLab Enterprise Edition**
- [Schedule async validation for merge_request_diffs.project_id FK](gitlab-org/gitlab@e75996c98133e2e2d3f19af7e10b4d7afdbd6c37) ([merge request](gitlab-org/gitlab!140410))
- [test: Align and refactor test structure for package protection](gitlab-org/gitlab@c8a4d2dabe4099af0c00be455659aebe7facb3ef) by @gerardo-navarro ([merge request](gitlab-org/gitlab!140753))
- [Remove vite feature flag](gitlab-org/gitlab@a5d841e01f8d6ec213381d2c6de6b1d7a202a222) ([merge request](gitlab-org/gitlab!140733))
- [Remove old summarize mr worker](gitlab-org/gitlab@9d2a844f11c027afd502ea2b93716ebee3cc7d71) ([merge request](gitlab-org/gitlab!140659))
- [Refactor event sync worker](gitlab-org/gitlab@d39bcf82fb8c7c40a34ce915ccde8170e1a5a7fa) ([merge request](gitlab-org/gitlab!140126))
- [Finalize batched background migrations](gitlab-org/gitlab@092feed2ea3a5254039cf67c452497427b9bae4f) ([merge request](gitlab-org/gitlab!132480))
- [Create index_issues_on_namespace_id_iid_unique index SYNC](gitlab-org/gitlab@31b862f247eac56c8e08453b14eaefdde37910d9) ([merge request](gitlab-org/gitlab!140253))
- [No-op migration due to incident](gitlab-org/gitlab@7636233e73938120035af6a2cf21012edda54b87) ([merge request](gitlab-org/gitlab!140587))
- [Refactor Gitlab::Git::Tree#where method](gitlab-org/gitlab@aacb81758ed1e6ead95d711dec9c366a6f26f7f5) ([merge request](gitlab-org/gitlab!140466)) **GitLab Enterprise Edition**
- [Reuse fallback's connection pool if identical](gitlab-org/gitlab@73f607caea5e1cf96e990bba1c00b52edf746824) ([merge request](gitlab-org/gitlab!139493))
- [Remove use of deprecated_clipboard_button](gitlab-org/gitlab@30f8d93782b54849a016471c21887f7b827c00f3) by @missy-davies ([merge request](gitlab-org/gitlab!140014))
- [Remove ci_editor_ai_conversations table and related jobs](gitlab-org/gitlab@064a557e87d3b2e80a44914b7e21d344a4a67643) ([merge request](gitlab-org/gitlab!139626))
- [Initialize conversion of geo_event_id column type](gitlab-org/gitlab@eab8d49924003d7a2e227e175c5e46797ae65e93) ([merge request](gitlab-org/gitlab!138646)) **GitLab Enterprise Edition**
- [Remove FF: updated_ai_powered_features_menu_for_sm](gitlab-org/gitlab@c0c01faab7dabd92b62c3251c5e9127d3a3cd79a) ([merge request](gitlab-org/gitlab!139141))
- [Resolving some group and project cross joins](gitlab-org/gitlab@8936d6d00d544092c2f4bc3a004e33ee8602ae66) ([merge request](gitlab-org/gitlab!139690))
- [Remove unused index](gitlab-org/gitlab@0f3dbfcb59c2b0ae784f650af5d504f53b98fa4a) ([merge request](gitlab-org/gitlab!140165))
- [Move modal components to seperate directory](gitlab-org/gitlab@27aced36240705e77a4380bc3569004a91577832) ([merge request](gitlab-org/gitlab!139924)) **GitLab Enterprise Edition**
- [Refactor assignees widget service](gitlab-org/gitlab@972631ce5f5e3ac89328ff294943b93e5c621d92) by @imskr ([merge request](gitlab-org/gitlab!140001))
- [Migrate to Pajamas::AvatarComponent for _member](gitlab-org/gitlab@ebee389cffe4c82262b54c43e0a4f21ed49d3471) by @tedtran2019 ([merge request](gitlab-org/gitlab!139848))
- [Aligning variable name in test relaed to protected containers](gitlab-org/gitlab@b33e8a401c0ecf6190959849817f2b21d50f5762) by @gerardo-navarro ([merge request](gitlab-org/gitlab!140258))
- [Refactor repository storage move worker scheduling ](gitlab-org/gitlab@308ebfa3d730b1af04708e49a4e2e34091672716) by @tedtran2019 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/139724#note_1700869142))
- [Refactor UI text for To-Do List empty state](gitlab-org/gitlab@60c8d2d492714bd7266eff1ec650cb434ac9473b) ([merge request](gitlab-org/gitlab!139153))
- [Preload saml_provider unconditionally to fix N+1 queries](gitlab-org/gitlab@449a46785954f9782ffe0c6e24ff2da1b78da11f) ([merge request](gitlab-org/gitlab!140197)) **GitLab Enterprise Edition**
- [Finalize system_note_metadata bigint backfill](gitlab-org/gitlab@8ecf9bf0416aaed29dbb51385f92441b5ba41924) ([merge request](gitlab-org/gitlab!138610))
- [Finalize merge_request_diffs.project_id backfill](gitlab-org/gitlab@26aded629ba0a944e9c1ef138d9d5563de0d86ac) ([merge request](gitlab-org/gitlab!139726))
- [Bump the finalize_after date of backfill migration](gitlab-org/gitlab@770ab7faa2048bfeb8bddd506e6f37fe18bb4d06) ([merge request](gitlab-org/gitlab!140109))
- [Remove code_suggestions_completion_api feature](gitlab-org/gitlab@988e2f57f9635ed9cc3896b15965b608fce54756) ([merge request](gitlab-org/gitlab!138174)) **GitLab Enterprise Edition**

## 16.7.10 (2024-09-20)

No changes.

## 16.7.9 (2024-07-23)

### Added (1 change)

- [Add Rake task to show token expiration info](https://gitlab.com/gitlab-org/gitlab/-/commit/22ab35073260e27d979f7cb54e9fba85e7327327) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159069))

### Changed (1 change)

- [Do not enqueue PAT expiry enforcement migration](https://gitlab.com/gitlab-org/gitlab/-/commit/0fc9d3cfb69f6f2008557fcbd99c5c61eba5ff07) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153468))

### Other (1 change)

- [Clear instance value](https://gitlab.com/gitlab-org/gitlab/-/commit/b1626d144508b52a015578a5b5089606b88a1671) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160248))

## 16.7.8 (2024-06-25)

### Fixed (1 change)

- [Update an expired test certificate](gitlab-org/gitlab@bd3b4aff0df30ae03bc8ce0372b72dd0f7171696) ([merge request](gitlab-org/gitlab!156397))

### Changed (1 change)

- [Add a banner informing about token expiration](gitlab-org/gitlab@c9c79c94d95d2314f607ccdad1a1c525154c58f9) ([merge request](gitlab-org/gitlab!155269))

## 16.7.7 (2024-03-06)

### Fixed (1 change)

- [Use the backup database connection while restoring timeouts](gitlab-org/security/gitlab@796d1a2904fee95a7a1f9f4eb7bcfb4f431bf720)

### Security (1 change)

- [Reset approvals when reopening a MR](gitlab-org/security/gitlab@4be38a72793e54c0f7f653be0e2b744d22dc1e0e) ([merge request](gitlab-org/security/gitlab!3829))

## 16.7.6 (2024-02-20)

### Fixed (2 changes)

- [Avoid mutating OpenSSL::PKey::EC keys](gitlab-org/security/gitlab@3d15d7efb953ff7abe9837caa99dd9be776c1a58)
- [Fix X509::Signature#x509_issuer not working with OpenSSL 3](gitlab-org/security/gitlab@e1fb88e53d6a699f3b26db233ec275fc6dbaeeb9)

### Security (9 changes)

- [Add a limit to CodeOwners reference extractor regex](gitlab-org/security/gitlab@df77f98beec6c91605b697a84dabcabe12a9aa8e) ([merge request](gitlab-org/security/gitlab!3861))
- [Ensure LDAP user cannot sign in with password](gitlab-org/security/gitlab@a711d3d91d2c66b97fef6987107838b68f471b68) ([merge request](gitlab-org/security/gitlab!3893))
- [Ensure LDAP users cannot reset local password to bypass LDAP](gitlab-org/security/gitlab@4c0cb71664cc31f93a3adbc71aa2339c8ce8ee20) ([merge request](gitlab-org/security/gitlab!3881))
- [Disallow assigning higher role than current user](gitlab-org/security/gitlab@9699f280e711fd75e8c02e6849efbc09e6162b59) ([merge request](gitlab-org/security/gitlab!3852))
- [Check project read access in Environments and Operations dashboard](gitlab-org/security/gitlab@0a6b7ffd36aafd377065e61e6806734e9fcf449c) ([merge request](gitlab-org/security/gitlab!3871))
- [Invalidate markdown cache to clear up stored XSS](gitlab-org/security/gitlab@d17f1b2b42c5d0872392e0c26f244e4ae55f4c2c) ([merge request](gitlab-org/security/gitlab!3886))
- [Disallow users to modify deploy key title](gitlab-org/security/gitlab@b581173dbe86002261584a16a13360e2e6497274) ([merge request](gitlab-org/security/gitlab!3865))
- [Adds authorization for analytics settings](gitlab-org/security/gitlab@b4eec07d6a987d1ae508ba7aacc66f39ec2dd30d) ([merge request](gitlab-org/security/gitlab!3857))
- [Use merge_head_diff for codeowners when merge request is mergeable](gitlab-org/security/gitlab@52e8d1a80ae99ac8c68b1df3581c1817e6fb7d49) ([merge request](gitlab-org/security/gitlab!3869))

## 16.7.5 (2024-02-07)

### Fixed (1 change)

- [Update dependency prometheus-client-mmap to '~> 1.1', '>= 1.1.1'](gitlab-org/security/gitlab@41326f12836b409735f0745d57b135fd952b54e0)

### Security (3 changes)

- [Fix CI component input Regexp](gitlab-org/security/gitlab@7b29c348a90b3311c5661b57572cbedf6160d02a) ([merge request](gitlab-org/security/gitlab!3855))
- [Make scan result policies block renaming branches](gitlab-org/security/gitlab@5f8202c849059e28370d79aa79cd94a851abd61a) ([merge request](gitlab-org/security/gitlab!3838))
- [Limit vulnerabilitiesCountByDay date range to 1 year](gitlab-org/security/gitlab@95c1de1c1c297ba59e7e52485e9703b01d8ad552) ([merge request](gitlab-org/security/gitlab!3827))

## 16.7.4 (2024-01-24)

### Fixed (1 change)

- [Bring legacy verification behavior back for repositories](gitlab-org/security/gitlab@0f3c5e6c2867cb9ea5ca40cf6a0f1526d6018ad1) **GitLab Enterprise Edition**

### Security (5 changes)

- [Devfile parser arbitrary file write](gitlab-org/security/gitlab@ae7844052f79e4fa987818bf642313fb6e47388f) ([merge request](gitlab-org/security/gitlab!3800))
- [Use public email in tags atom feed](gitlab-org/security/gitlab@9abe7c6ca865c4884ad25db17c02ee7feb5c6c91) ([merge request](gitlab-org/security/gitlab!3803))
- [Fix improper username sanitization](gitlab-org/security/gitlab@58ab3f89b3298a248640bddbf94a5c3fdf27a867) ([merge request](gitlab-org/security/gitlab!3785))
- [Escape user input before building regex for linker](gitlab-org/security/gitlab@ced4fa77abf8a05cbc015b6128220d783d11c3a2) ([merge request](gitlab-org/security/gitlab!3788))
- [Do not allow non-team member to set MR assignees/reviewers](gitlab-org/security/gitlab@d374f84266d2ca14a79a3924f458e244b50191e4) ([merge request](gitlab-org/security/gitlab!3792))

## 16.7.3 (2024-01-13)

### Fixed (1 change)

- [Make chat_names table migration idempotent](gitlab-org/gitlab@1757965f503f2f0eb144731a982d4f83519e61d9) ([merge request](gitlab-org/gitlab!141704))

## 16.7.2 (2024-01-10)

### Fixed (1 change)

- [Add missing ci_sources_pipelines indexes for self-host](gitlab-org/security/gitlab@1e0c4e44228a3ec8013b70e5ef33ac3184f6cb4c) ([merge request](gitlab-org/security/gitlab!3809))

### Changed (1 change)

- [Enable Apollo Boards by default](gitlab-org/security/gitlab@dc1e1e8368fce9ca8c407d439877980e0426b356) ([merge request](gitlab-org/security/gitlab!3809))

### Security (4 changes)

- [Consider older commits when resetting codeowner approvals](gitlab-org/security/gitlab@d20f815258ac8f7195a04aeab760645993354485) ([merge request](gitlab-org/security/gitlab!3764))
- [Password reset followups](gitlab-org/security/gitlab@48154de65e174b93d70bc561c7a0c8b0815d367f) ([merge request](gitlab-org/security/gitlab!3777))
- [Add verification layer for BaseSlash commands](gitlab-org/security/gitlab@f972a67468aa2da9530188930da2fb5225eb1aad) ([merge request](gitlab-org/security/gitlab!3763))
- [Ensure workspaces are created under same root namespace as agent](gitlab-org/security/gitlab@ca7e81b8ce6c2140820c9ce21aa75af1967a2fb5) ([merge request](gitlab-org/security/gitlab!3759))

## 16.7.0 (2023-12-20)

### Added (199 changes)

- [Geo: Skip download of new blob if already exists](gitlab-org/gitlab@70b30c0e167eef997912320926d2a5697a41d1f2) ([merge request](gitlab-org/gitlab!96935)) **GitLab Enterprise Edition**
- [Exempt paid non-trial/enterprise users from identity verification](gitlab-org/gitlab@522c510cd5a9e32e6bc20844fc6d80a2e4d38bbd) ([merge request](gitlab-org/gitlab!139101)) **GitLab Enterprise Edition**
- [Add feature toggle for custom CI execution policy](gitlab-org/gitlab@8806c961f16593036b81de50426820d72803c378) ([merge request](gitlab-org/gitlab!138484)) **GitLab Enterprise Edition**
- [Add namespace setting to enable/disable NuGet symbol server](gitlab-org/gitlab@d16d642b86d57e9efb704a918210a8c92bc979f5) ([merge request](gitlab-org/gitlab!138936))
- [Soft limit daily phone verification transactions](gitlab-org/gitlab@fa81159a3f5e5959332015c6017981f6f7d8a4d3) ([merge request](gitlab-org/gitlab!138287)) **GitLab Enterprise Edition**
- [Cleanup and reschedule finding_id backfilling](gitlab-org/gitlab@f28e14553d1e88b650e2a122dd892218ed0b3832) ([merge request](gitlab-org/gitlab!138163))
- [Add WorkItems::DatesStart table/model](gitlab-org/gitlab@dbfe5a390f0b86c772e76d066a765fb06083353b) ([merge request](gitlab-org/gitlab!139116))
- [Allow handling instance custom roles via graphql](gitlab-org/gitlab@2b222db166c76e971452fd3c03b40292d01d5ed9) ([merge request](gitlab-org/gitlab!139166)) **GitLab Enterprise Edition**
- [Remove SAML Microsoft Attribute Feature Flag](gitlab-org/gitlab@ffedc93a863ef6e625a6ce69787185f8e9d8b86b) ([merge request](gitlab-org/gitlab!139289))
- [Save timestamp for login in session storage](gitlab-org/gitlab@aebdbd71a2fd83abce3042d3862ba715c0ec20c8) ([merge request](gitlab-org/gitlab!139069)) **GitLab Enterprise Edition**
- [feat: Add graphql mutation to update container protection rules](gitlab-org/gitlab@b2fecc011df6bec721a76b3903ee86ec2eea1117) by @gerardo-navarro ([merge request](gitlab-org/gitlab!137175))
- [Add feature spec for MR approval settings](gitlab-org/gitlab@a3440f1f5f1f985494861535d91f54e75cb17f3a) ([merge request](gitlab-org/gitlab!139820)) **GitLab Enterprise Edition**
- [Add code added to onboarding progress](gitlab-org/gitlab@7693a04f9d38f14293a25da1f5e7266d2a3a7e8a) ([merge request](gitlab-org/gitlab!139822))
- [Add new fields to GroupType](gitlab-org/gitlab@9dce4f7dbb089a12282e60f7aed0b83f30ece5b5) ([merge request](gitlab-org/gitlab!139226))
- [Store the information about the generated files](gitlab-org/gitlab@95c0bdafea3d28f4aa2d3a279fd1a6770bee9319) ([merge request](gitlab-org/gitlab!139210))
- [Add namespace filtering to streaming destinations](gitlab-org/gitlab@9f2e2b1058ba697a667481dfbc39005aa1e81fdd) ([merge request](gitlab-org/gitlab!137477)) **GitLab Enterprise Edition**
- [Use XRay data for code generation](gitlab-org/gitlab@21fb5fb22cb4ee94383ea52086eac5d8845cb37f) ([merge request](gitlab-org/gitlab!139152)) **GitLab Enterprise Edition**
- [Enable security_policies_variables_precedence by default](gitlab-org/gitlab@382e9b4b869dbfa4277b2a8dcac094cbb2c515d4) ([merge request](gitlab-org/gitlab!139828)) **GitLab Enterprise Edition**
- [Expose timeToMerge metrics via GraphQL](gitlab-org/gitlab@1c007accf9f096d81ba13c8f593644cca471b4c6) ([merge request](gitlab-org/gitlab!139220)) **GitLab Enterprise Edition**
- [Adding group and project filters for instance audit streaming](gitlab-org/gitlab@72b12df3ad39f97be9172e92c70f6df256c5b5c7) ([merge request](gitlab-org/gitlab!136959)) **GitLab Enterprise Edition**
- [Add arkose_labs_data_exchange_key column to applicatio_settings table](gitlab-org/gitlab@359e9c1f51b9b1e126a48f88d5bcd03de233fdfd) ([merge request](gitlab-org/gitlab!139754)) **GitLab Enterprise Edition**
- [Move add/editing compliance frameworks to separte page](gitlab-org/gitlab@704da74b6cf067b2a48682c2bf805382cbee7b55) ([merge request](gitlab-org/gitlab!135662)) **GitLab Enterprise Edition**
- [Added auto_cancel_pipeline_on_job_failure and feature flag](gitlab-org/gitlab@d12244407d7e0e076bf56ca36e31aa28639b39bb) by @zillemarco ([merge request](gitlab-org/gitlab!137815))
- [Support path redirect for component projects](gitlab-org/gitlab@8ac1a1e3cad222e91ee248c095fc4778f627fa7d) ([merge request](gitlab-org/gitlab!139254))
- [Support multiple ids when querying compliance frameworks](gitlab-org/gitlab@cb07d01e9619bf3960ad3a97cd334d0129903181) ([merge request](gitlab-org/gitlab!138513)) **GitLab Enterprise Edition**
- [Add support for cyclonedx specVersion 1.5](gitlab-org/gitlab@7301c50e7581b62e9b1fccdcf7d4d7fa0c52d1a3) ([merge request](gitlab-org/gitlab!138852))
- [Add pre receive secret detection documentation](gitlab-org/gitlab@9765f813eb5f13d78c85a4b18f053b7cf90060ad) ([merge request](gitlab-org/gitlab!139496))
- [Adding gin index on name field of compliance frameworks table](gitlab-org/gitlab@35e1329e800b0b134ad702f7e6f22edda7511569) ([merge request](gitlab-org/gitlab!139643))
- [Update ingestion logic for vulnerability reads owasp top 10](gitlab-org/gitlab@12967a0906ad266b98aed7b2cf59379146bca337) ([merge request](gitlab-org/gitlab!138594)) **GitLab Enterprise Edition**
- [Remove explain_vulnerability feature flag](gitlab-org/gitlab@712cccfc7dc385f36b6c74be8819f782c5c47cfc) ([merge request](gitlab-org/gitlab!139354)) **GitLab Enterprise Edition**
- [Remove slash_commands feature flag](gitlab-org/gitlab@ed6f34225c12828ae97fa1a7250c3e2366a40ec6) ([merge request](gitlab-org/gitlab!139551)) **GitLab Enterprise Edition**
- [Add restrict_pipeline_cancellation_role to read project api](gitlab-org/gitlab@18f1d410b55b607d599ccca8f219b2cdf77ed590) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/139414)) **GitLab Enterprise Edition**
- [Add Internal Events Tracking to Insights charts](gitlab-org/gitlab@e199150f0ee90640c82fed40f206d4be72fdcc98) ([merge request](gitlab-org/gitlab!139277)) **GitLab Enterprise Edition**
- [Store the information about the generated files](gitlab-org/gitlab@a3ddfd07402d0165603741431bd3eff2ce63d457) ([merge request](gitlab-org/gitlab!138611))
- [Add PostgresSequence view](gitlab-org/gitlab@57011b8c856da9ef1b1f5367d4cff93c74c954eb) ([merge request](gitlab-org/gitlab!139117))
- [Add user viewing catalog logging](gitlab-org/gitlab@2d84e37b33e902957cdc6c757dae843006f9c22d) ([merge request](gitlab-org/gitlab!137564))
- [Add support for include_descendants](gitlab-org/gitlab@7f363d2e204776bfa310ed3b07e76e7de9eedc12) ([merge request](gitlab-org/gitlab!138380))
- [Expose VSD distinct contributor counts via GraphQL](gitlab-org/gitlab@5633241be3f8e8fc6504f0949e09a3b0ff28479b) ([merge request](gitlab-org/gitlab!139107)) **GitLab Enterprise Edition**
- [Adding functionality of searching compliance frameworks by name](gitlab-org/gitlab@f6fcbdfa2d83e7c704ae5869ed4a686ec731c0da) ([merge request](gitlab-org/gitlab!138641)) **GitLab Enterprise Edition**
- [Remove non_public_artifacts FF](gitlab-org/gitlab@51d2b90c40b948c34a38d93a74dcb9313af878a7) ([merge request](gitlab-org/gitlab!139439))
- [Use Ci::Catalog::Listing class in the Resource Resolver](gitlab-org/gitlab@b3af38d850685da2a388b2e5b547c2c7767b67ef) ([merge request](gitlab-org/gitlab!138686))
- [Add tests for license scanning](gitlab-org/gitlab@665eef8f24ea158eee1637a1ccc3ece113d6b9ee) ([merge request](gitlab-org/gitlab!136087)) **GitLab Enterprise Edition**
- [Adds API to control model registry project setting](gitlab-org/gitlab@f9b224de0bcb73b5f689c854b86fa0984b94b201) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/139004))
- [Release Conversational Pipeline Editing](gitlab-org/gitlab@945168f291b7f99344b4b8dc5e0affc54dcf56ea) ([merge request](gitlab-org/gitlab!139338)) **GitLab Enterprise Edition**
- [Store the information about the generated files](gitlab-org/gitlab@6251837219657a4d70274560db9b4a6e0f3d2abf) ([merge request](gitlab-org/gitlab!138013))
- [Background syncing of 'catalog_resources' and 'projects' tables](gitlab-org/gitlab@d1301be527dbc1ec2eff013ec8f72d2968654ee1) ([merge request](gitlab-org/gitlab!139458))
- [Add `counts.enterprise_users` metric](gitlab-org/gitlab@82c2f0b30a195f807fcb9393bbdeeaaf8dc2f6ef) ([merge request](gitlab-org/gitlab!139392)) **GitLab Enterprise Edition**
- [Synchronous index creation to support finding_id backfill](gitlab-org/gitlab@c00b83139f43fcedb6b99760c31ca86f29237b28) ([merge request](gitlab-org/gitlab!138952))
- [Add performance tests for sync license](gitlab-org/gitlab@f9428d9880a40bafbe38a46e4e840baeb5c52a5b) ([merge request](gitlab-org/gitlab!139409)) **GitLab Enterprise Edition**
- [Add publish_group feature to Gitlab::EventStore](gitlab-org/gitlab@57e18d128c7f12740c12a0702bb8c4b2f605c251) ([merge request](gitlab-org/gitlab!137464))
- [Reopen issues on a new note from external participants](gitlab-org/gitlab@40f079c352e51e1e20914821ed05359f75dfde4c) ([merge request](gitlab-org/gitlab!138293))
- [Add support for querying work items counts by state](gitlab-org/gitlab@f65dddac672f2d2c9850bd80c80ae2b063f0a2bf) ([merge request](gitlab-org/gitlab!137043))
- [Add vulnerabilities to sbom_occurrences ingestion](gitlab-org/gitlab@218f422339212959e0f6d1271f37d981b609ada6) ([merge request](gitlab-org/gitlab!133004)) **GitLab Enterprise Edition**
- [Compare pipeline refs for secondary jobs](gitlab-org/gitlab@35350048f3929591a8fc5fe058047646e6703320) ([merge request](gitlab-org/gitlab!137732)) **GitLab Enterprise Edition**
- [Add the `archive_project` custom permission](gitlab-org/gitlab@6b81480f5892a8726dc74a57a398c7f667eaccfe) ([merge request](gitlab-org/gitlab!139260)) **GitLab Enterprise Edition**
- [Handles merged events on GitHub Import](gitlab-org/gitlab@31affa8cb8212ef13d3eaa99feab642b82700222) ([merge request](gitlab-org/gitlab!138986))
- [Add `interruptible` to trigger jobs](gitlab-org/gitlab@cfa917bfdf9de9fd0236e4640e51f121ab727853) ([merge request](gitlab-org/gitlab!138508))
- [Add memberCount to memberRole GraphQL type](gitlab-org/gitlab@5fbe6145ed32a20272e6c44c6e01834864408987) ([merge request](gitlab-org/gitlab!137585)) **GitLab Enterprise Edition**
- [Create BranchRuleUpdate graphql endpoint](gitlab-org/gitlab@4b0fd1d5316e31b97f22eeed63dc3834acac2de9) ([merge request](gitlab-org/gitlab!138672))
- [Sync npm metadata cache when package is marked for destruction](gitlab-org/gitlab@84e89982260069aca6b052732db58838a42e6723) ([merge request](gitlab-org/gitlab!137510))
- [Add posibility to return permission in upcase](gitlab-org/gitlab@f2855a277ae04d1bda0ff5208ffd53df19178a60) ([merge request](gitlab-org/gitlab!137752)) **GitLab Enterprise Edition**
- [Add GraphQL API to delete instance Amazon S3 configurations](gitlab-org/gitlab@530e625b247c914fa08b56258ec4eab8c7763c3c) ([merge request](gitlab-org/gitlab!138318)) **GitLab Enterprise Edition**
- [Rollout enable_remove_all_vulnerabilties_from_project_mutation feature](gitlab-org/gitlab@44631c4419fa919ebae0bbd25ac7093ce92bd221) ([merge request](gitlab-org/gitlab!139071))
- [Allow administrators to provide public security contact information](gitlab-org/gitlab@2d0dfef0d1b8db2f83f04b095c124e9204425f79) ([merge request](gitlab-org/gitlab!138259))
- [Adds project feature availability check for model registry](gitlab-org/gitlab@2119c10e7a81d01eee5344e4b604e4c3577973e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/138995))
- [Remove job log jump to failures flag](gitlab-org/gitlab@11882fbe5e933b6c8583466f16e0eca17543911f) ([merge request](gitlab-org/gitlab!138979))
- [Add GraphQL API to update instance Amazon S3 configurations](gitlab-org/gitlab@880bc35f451d24114ca18fa8b424eea2e5e41915) ([merge request](gitlab-org/gitlab!138310)) **GitLab Enterprise Edition**
- [Refactor refresh job for Self-Managed](gitlab-org/gitlab@781e32d83a81286a9d9cd7d7f9dc01530b279386) ([merge request](gitlab-org/gitlab!138776)) **GitLab Enterprise Edition**
- [Implement background syncing for catalog_resources and projects](gitlab-org/gitlab@55809457a245992a48bd033182da19985956aa84) ([merge request](gitlab-org/gitlab!137238))
- [Inject data attributes to render maven dependency proxy settings](gitlab-org/gitlab@98c1c9b49d2d6ddf1e86128622d613ba35a36a61) ([merge request](gitlab-org/gitlab!138356)) **GitLab Enterprise Edition**
- [feat: Add graphql mutation to delete container protection rules](gitlab-org/gitlab@c0bd2ed57b8e0b1c1684754cd228784735314ccf) by @gerardo-navarro ([merge request](gitlab-org/gitlab!137176))
- [Expose allowedChildTypes in WorkItemType graphQL type](gitlab-org/gitlab@beaf08c94272c7e9205912719d82f0ac365ca279) ([merge request](gitlab-org/gitlab!136725))
- [Enable `global_ci_catalog` globally](gitlab-org/gitlab@ec6111e0ac820b463630eaa7c6101603b5b9b435) ([merge request](gitlab-org/gitlab!135403))
- [Schedule asynchronous index creation to support finding_id backfill](gitlab-org/gitlab@60a9bec9d815b4a83881a51cd087f99c85bf64da) ([merge request](gitlab-org/gitlab!138339))
- [Add a refresh_token parameter to SyncSeatLinkRequestWorker](gitlab-org/gitlab@0a9d634e17c0800e083e761b7c159971e6b7fdcb) ([merge request](gitlab-org/gitlab!138744)) **GitLab Enterprise Edition**
- [Endpoint for symbol file download](gitlab-org/gitlab@40deb736df797485abdacf7c2ec73bf45387ad94) ([merge request](gitlab-org/gitlab!134564))
- [Update delete_ineligible_user_assignments method](gitlab-org/gitlab@185cedf690acfeb51ae14f0cc0db3d3c3275be37) ([merge request](gitlab-org/gitlab!138640)) **GitLab Enterprise Edition**
- [Refactor AffectedVersionRangeMatcher class](gitlab-org/gitlab@7732ab5cbb33d6f26c083b1ca697ed294d0b1c38) ([merge request](gitlab-org/gitlab!137400)) **GitLab Enterprise Edition**
- [Add SAML Auth for Approvals](gitlab-org/gitlab@5e63594c21cbf1454ff06dd175f0c2fc6f222ff8) ([merge request](gitlab-org/gitlab!137067)) **GitLab Enterprise Edition**
- [Add documentation for `pages_path_prefix` on `gitlab-ci.yml`](gitlab-org/gitlab@71798f796817213eacb43c510023b26d5574dc6e) ([merge request](gitlab-org/gitlab!130314))
- [Adding complex merge order dependencies](gitlab-org/gitlab@a4aaa667adb0c7feb68282e896f8b3f1bc2f82cb) ([merge request](gitlab-org/gitlab!136775))
- [Add API for listing instance_amazon_s3_configuration for audit events](gitlab-org/gitlab@db3424f22a40d392972e3fc05adf658e7e3be4f9) ([merge request](gitlab-org/gitlab!137895)) **GitLab Enterprise Edition**
- [Add GraphQL mutation to update Organization](gitlab-org/gitlab@938e02714954f77abd8a7c832608b5325c879c0b) ([merge request](gitlab-org/gitlab!138276))
- [Add unique indexes to ci_job_artifacts](gitlab-org/gitlab@30c35b2528fb4d12cc6ec0a615776ad401e91d22) ([merge request](gitlab-org/gitlab!138620))
- [Display the new PyPi package metadata fields](gitlab-org/gitlab@77c788d70c4e85b6b27cd50ded3de0a2b50b6a6d) ([merge request](gitlab-org/gitlab!136073))
- [Validate key field in CI variables form](gitlab-org/gitlab@0c0b189953d1fe2433daf42062203f5b122557d5) ([merge request](gitlab-org/gitlab!137370))
- [Add workload type details](gitlab-org/gitlab@c856d59113c0521f1d3ce99df7db114997a216af) ([merge request](gitlab-org/gitlab!138353))
- [Add workload type details](gitlab-org/gitlab@009ae3b3c57d5a7fc36cb46421c6cf1d8d5a2fc4) ([merge request](gitlab-org/gitlab!138112))
- [Create Package during Model Version creation](gitlab-org/gitlab@7cab75036d7377accf9a50e07efde2f50f1ebf35) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/138230))
- [Add finding builder for Container Scanning](gitlab-org/gitlab@5ea198a046119af933f1e608cd51b39b59b02004) ([merge request](gitlab-org/gitlab!137590))
- [Refactor UserAddOnAssignments and the GQL API](gitlab-org/gitlab@9ae7456c377fce5b8653dfd16f3fb59ea9d5d5c0) ([merge request](gitlab-org/gitlab!138157)) **GitLab Enterprise Edition**
- [Allow to query value streams on GraphQL](gitlab-org/gitlab@f0d4a6d4159e6ddfb8c6cb4fdf7f8ced9ca6efd3) ([merge request](gitlab-org/gitlab!135378))
- [Full dotenv vars support in downstream pipelines](gitlab-org/gitlab@2f0e358d61b7052336c4e35b9df99f7057b64bb5) by @renehernandez ([merge request](gitlab-org/gitlab!137364))
- [Include owasp_top_10 to vulnerabilities read model](gitlab-org/gitlab@43cc8c3fa49cf017aad14c82861fef779a27e64e) ([merge request](gitlab-org/gitlab!138502)) **GitLab Enterprise Edition**
- [Introduce new fields to GraphQL ProjectType](gitlab-org/gitlab@5d3d4cb12714ed5ad983dab71bfab71612fdd670) ([merge request](gitlab-org/gitlab!138497))
- [Added Diffblue Cover CI template](gitlab-org/gitlab@c86886e6e7401a482352c580555d772235bbf132) by @roxspring ([merge request](gitlab-org/gitlab!137047))
- [Hide label close button when label is locked](gitlab-org/gitlab@2707906bdee75a3a54da1ea3c949167d2bd5d559) ([merge request](gitlab-org/gitlab!130681))
- [Add streaming to /code_suggestions/completions API](gitlab-org/gitlab@5a0a07d4aee87190725e5b93594559e4224fe6a1) ([merge request](gitlab-org/gitlab!136553)) **GitLab Enterprise Edition**
- [Added drill down functionality to select Insights charts](gitlab-org/gitlab@6baf101b070b41e1f873ac56826e656a95ee6221) ([merge request](gitlab-org/gitlab!137723)) **GitLab Enterprise Edition**
- [Added MLflow API to search for Registered Models](gitlab-org/gitlab@fecaf922a6c0f2037bf88473761c7f9fc00cf066) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/137476))
- [Adds backend project setting for model registry](gitlab-org/gitlab@a09dbe99d6829ab81186668d11b40bea73e1bbf7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/138399))
- [Restict CI cancellation by role](gitlab-org/gitlab@01c6944a3400126d64f274da1650514efe5637b2) ([merge request](gitlab-org/gitlab!137301)) **GitLab Enterprise Edition**
- [Change project_authorizations.user_id to LFK](gitlab-org/gitlab@0423f6721e83ac68e1ba20d186d772a74ec69a95) ([merge request](gitlab-org/gitlab!138087))
- [Adding MLFlow API for creating model versions](gitlab-org/gitlab@5cd3397c943c7e8572bcf89126ad37d676361d6e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/137421))
- [Add worker to cleanup orphaned packages_nuget_symbols records](gitlab-org/gitlab@f1e06ae239d91d0287cfa4241b31cf7143b56f87) ([merge request](gitlab-org/gitlab!136737))
- [Add feature to stream instance audit events to Amazon S3 destinations](gitlab-org/gitlab@2d8013c06b771777a03bffeed43d77febb50e77a) ([merge request](gitlab-org/gitlab!136496)) **GitLab Enterprise Edition**
- [Add API for creating instance_amazon_s3_configuration for audit events](gitlab-org/gitlab@a935c010282034711d6bace0f5675ebc75930860) ([merge request](gitlab-org/gitlab!137651)) **GitLab Enterprise Edition**
- [Use code suggestions without GitLab Duo prefix](gitlab-org/gitlab@9244902f3e933c1ff3437478cf579f42ac285cad) ([merge request](gitlab-org/gitlab!138149)) **GitLab Enterprise Edition**
- [Enable Natural Language Git assistent](gitlab-org/gitlab@8332febaf4699991500b25dc5bea53cd8608341b) ([merge request](gitlab-org/gitlab!138168))
- [Adds query 'Query.addOnPurchase'](gitlab-org/gitlab@a05c3759c6d07e2f5ebe10e024109739aa536fb0) ([merge request](gitlab-org/gitlab!137804)) **GitLab Enterprise Edition**
- [Add auto_cancel_on_new_commit to ci_pipeline_metadata and remove a const](gitlab-org/gitlab@014ccb0a862c078b6c133d0c30f58f401720ca3e) ([merge request](gitlab-org/gitlab!137520))
- [Show dismissal reason descriptions in bulk actions](gitlab-org/gitlab@6fbc88a839d48ae82255b409f7a3dc40550fdd1d) ([merge request](gitlab-org/gitlab!137784)) **GitLab Enterprise Edition**
- [Feat(key_contacts_management): Add feature flag](gitlab-org/gitlab@f5b74de4491f6f0b910dbbc19615fc1d5f86d397) ([merge request](gitlab-org/gitlab!138045)) **GitLab Enterprise Edition**
- [Allow comment in SecurityFindingRevertToDetected mutation](gitlab-org/gitlab@af59235f274c11a287e4d60f9ce3b8637ca271d7) ([merge request](gitlab-org/gitlab!137503)) **GitLab Enterprise Edition**
- [Store event durations in VSA tables](gitlab-org/gitlab@08d291732b86a24c6ab5659903a8b3621e1cf08d) ([merge request](gitlab-org/gitlab!137529))
- [Prepare Ci::JobArtifact for partitioning 1/3](gitlab-org/gitlab@93aae4c579b236e132b95b6138a16a78eec797d1) ([merge request](gitlab-org/gitlab!138038))
- [Add Mutations::Vulnerabilities::RemoveAllFromProject](gitlab-org/gitlab@55e9be2fa6fd030c826911d04685b10114695f56) ([merge request](gitlab-org/gitlab!135169)) **GitLab Enterprise Edition**
- [Add integration tests for license scanning](gitlab-org/gitlab@982a92625b3399486c3d618c9db6bc5380263ea6) ([merge request](gitlab-org/gitlab!137566)) **GitLab Enterprise Edition**
- [Add retry:exit_codes syntax for CI config](gitlab-org/gitlab@82aa5beb9fbeb8be1a76150c734de31bbf9e92f8) by @BaptisteLalanne ([merge request](gitlab-org/gitlab!135430))
- [Introduce Gitlab::CircuitBreaker](gitlab-org/gitlab@0b48f6653b1dd735242ff7a4bbfce7d91fd682d6) ([merge request](gitlab-org/gitlab!137531))
- [Introduce `extended_trailers` field in commits API](gitlab-org/gitlab@f4ad42c30a33a04bc49598abfcfe39499327dfba) ([merge request](gitlab-org/gitlab!136998))
- [Allow specifying Docker image platform to pull](gitlab-org/gitlab@11efe50ef108bf4cb71c2c84987aa344c7308cdf) by @ar-mali ([merge request](gitlab-org/gitlab!137100))
- [Filtering audit events by namespace filters](gitlab-org/gitlab@27e3f0168b5d80759b3b75471dc09419de196035) ([merge request](gitlab-org/gitlab!137009)) **GitLab Enterprise Edition**
- [Update security policies when compliance framework is updated](gitlab-org/gitlab@87a35d7831ffe09774b75b67e7cf526f0da4485a) ([merge request](gitlab-org/gitlab!136618)) **GitLab Enterprise Edition**
- [Docs: Add auth_timeout flag for Gitlab Pages](gitlab-org/gitlab@55daea6a44d235a9e98b4702bda283c260244fb5) ([merge request](gitlab-org/gitlab!137845))
- [Work items - Add ancestors widget](gitlab-org/gitlab@a78ac025207189a0b1bdb0c98d10ea1e88bfd410) ([merge request](gitlab-org/gitlab!135530))
- [Add test sumary section to the job section sidebar](gitlab-org/gitlab@b08ba8ac0bd9726e7bca30a603becfb89143ebba) ([merge request](gitlab-org/gitlab!136929))
- [Add member_role_id to group_saml_links](gitlab-org/gitlab@59c145574a15566c0f8f2a4a494803d785f8d1bd) ([merge request](gitlab-org/gitlab!135596)) **GitLab Enterprise Edition**
- [Enable Contribution Analytics page size FF](gitlab-org/gitlab@192e5d77c8814c66165b266f297edbfcce999abc) ([merge request](gitlab-org/gitlab!137795)) **GitLab Enterprise Edition**
- [Add self_managed_add_on_eligible_users to query types](gitlab-org/gitlab@70f2a39c0c4076a978160b2c7f0254e5639412b5) ([merge request](gitlab-org/gitlab!137534)) **GitLab Enterprise Edition**
- [Added MLFLow API to delete a registered model by name](gitlab-org/gitlab@d8438f8061cb5c85c7e192c448795e828541cb15) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/136259))
- [Reschedule BackfillFindingIdInVulnerabilities background migration](gitlab-org/gitlab@508f9dace0be95490173d7c7f2a2a883fd713c36) ([merge request](gitlab-org/gitlab!137261))
- [Add endpoint for prevent_merge_without_jira_issue](gitlab-org/gitlab@0c5314c851ec7334afcf7bce04cd427cde10bac8) ([merge request](gitlab-org/gitlab!137064)) **GitLab Enterprise Edition**
- [Add experimental namespace_in_path pages url in project deploy](gitlab-org/gitlab@4b47a1810cd2d2e0fcf933c7d04f22a155be9cb8) ([merge request](gitlab-org/gitlab!137615))
- [Show `email_reset_offered_at` to admin users](gitlab-org/gitlab@8a4724cd461ce9ce69a3289eabc99742105993c5) ([merge request](gitlab-org/gitlab!137610))
- [Add watch API for k8s services](gitlab-org/gitlab@e56d5701eb464091c2f48c5f9b95a40dc21e2be8) ([merge request](gitlab-org/gitlab!137306))
- [Add watch API for k8s workload types](gitlab-org/gitlab@beea126f7a592b016f2c660dd28f720cf59e5226) ([merge request](gitlab-org/gitlab!137456))
- [Add comment form to an abuse report](gitlab-org/gitlab@8a8ab9b73be24accb52e9bfd28114e04c32b4360) ([merge request](gitlab-org/gitlab!135533))
- [Breadcrumbs navigation in the Workspaces UI](gitlab-org/gitlab@1356d54f60fd0b61471c181080b6dc4b1c0c4425) ([merge request](gitlab-org/gitlab!137019))
- [Log audit event when custom role is created](gitlab-org/gitlab@05f74b91603ca327cff4b3c3ac76b76976b2f3db) ([merge request](gitlab-org/gitlab!137087)) **GitLab Enterprise Edition**
- [Add product analytics group usage quota tab](gitlab-org/gitlab@998c60cd90df8a6d779ac89c1844b429c7ead5d4) ([merge request](gitlab-org/gitlab!137078)) **GitLab Enterprise Edition**
- [Add `object_format` field to `project_repositories`](gitlab-org/gitlab@e707713cc72719ce2d69ec608b5baa62cefe36bb) ([merge request](gitlab-org/gitlab!136819))
- [Add allowsMultipleAssignees field to assignees widget defintion](gitlab-org/gitlab@99f0d099df87a99f4dba13506cd720f08ad2a720) ([merge request](gitlab-org/gitlab!137307)) **GitLab Enterprise Edition**
- [Remove mastodon_social_ui feature flag](gitlab-org/gitlab@c1bfe08d23d95b6d90ce26f1e9933b2a11da24a0) ([merge request](gitlab-org/gitlab!137339))
- [Add saving a custom role to SAML providers](gitlab-org/gitlab@05a72621673d65dcaf579ee51154d4eb1267f5c0) ([merge request](gitlab-org/gitlab!136192)) **GitLab Enterprise Edition**
- [Show survey alert when group_analytics_dashboards is enabled](gitlab-org/gitlab@bcd439e1db6adaef9fd04b48053c457ec303629e) ([merge request](gitlab-org/gitlab!137044)) **GitLab Enterprise Edition**
- [Add support for ObjectFormatRequest RPC](gitlab-org/gitlab@69cc43bd1256836c1058131d51a29a8203d5e45c) ([merge request](gitlab-org/gitlab!136692))
- [Make job_artifact_state partitionable](gitlab-org/gitlab@78823a7566b2fdec3ee850ae5d04b126f1978c99) ([merge request](gitlab-org/gitlab!136849))
- [Add `Mutation.memberRoleDelete` to delete a member role](gitlab-org/gitlab@135492e1dd562221a0507816168ffb14d6556684) ([merge request](gitlab-org/gitlab!136371)) **GitLab Enterprise Edition**
- [Allow staring and unstaring of a project via GraphQL](gitlab-org/gitlab@2c55cc6aac021b06276b4f599ddb50cea2253933) by @espadav8 ([merge request](gitlab-org/gitlab!137076))
- [Add migration for new column](gitlab-org/gitlab@458d2abf63b87e95519afcdec647f4b10d73fa87) ([merge request](gitlab-org/gitlab!137264))
- [Add `filter_project_topics` setting to Dora Performers Score chart](gitlab-org/gitlab@6b21cebed9256ee535cfe3b94bd8c1c14acdd26f) ([merge request](gitlab-org/gitlab!136497)) **GitLab Enterprise Edition**
- [Track CS subscription namespace IDs](gitlab-org/gitlab@0623d07e93cef6be9994c9cfad993dfd50f7d625) ([merge request](gitlab-org/gitlab!137220)) **GitLab Enterprise Edition**
- [Enable generate commit message through VertexAI](gitlab-org/gitlab@97508f9b60c4e55f0c626859f5706338eb3b3d8d) ([merge request](gitlab-org/gitlab!137020)) **GitLab Enterprise Edition**
- [Use correct attribute for distro_version](gitlab-org/gitlab@45c67884fe03c5c8cf8d2efdefce033a20ffb12e) ([merge request](gitlab-org/gitlab!137309))
- [This MR adds linked file mode](gitlab-org/gitlab@9ac4510739e29395555ea8883968930995e8f99a) ([merge request](gitlab-org/gitlab!137151)) **GitLab Enterprise Edition**
- [Add member_role_id to saml_providers](gitlab-org/gitlab@bfa8e03f672b50fb7678182c8c6f1cb4c82d9e5d) ([merge request](gitlab-org/gitlab!135757)) **GitLab Enterprise Edition**
- [Link security policies to compliance frameworks on policy change](gitlab-org/gitlab@26952cd8c93a1378873aeed35ca85b6e32becb26) ([merge request](gitlab-org/gitlab!136611)) **GitLab Enterprise Edition**
- [Add projects field to compliance framework GraphQL type](gitlab-org/gitlab@6f2ffe443dc8b8da1d0bd8872cc5cd9485c93bba) ([merge request](gitlab-org/gitlab!137262)) **GitLab Enterprise Edition**
- [Import approvals from Bitbucket server](gitlab-org/gitlab@5421bc5dbbcd986056e68017f497c9ff17658fbf) ([merge request](gitlab-org/gitlab!135256))
- [Allow to update/create stages for value streams](gitlab-org/gitlab@dddcaca0bb71d29f1947ca7a21a8d3232da7b061) ([merge request](gitlab-org/gitlab!136252)) **GitLab Enterprise Edition**
- [Set up many-to-many assoc between AbuseReport and User (assignee)](gitlab-org/gitlab@55bfd7fdcb69b2827a9027d6e8261fb539f8f332) ([merge request](gitlab-org/gitlab!134240))
- [Add user_permissions field to ContainerRepository/Tag type](gitlab-org/gitlab@a0dd30ef18dd3394df96dc8743290329af22629a) ([merge request](gitlab-org/gitlab!136576))
- [Added predefined variable for merge request descriptions](gitlab-org/gitlab@d072a54efcde17973ab56698f3af8df34bf62cf0) ([merge request](gitlab-org/gitlab!137194))
- [Display spam icon to admins next to snippets of banned users](gitlab-org/gitlab@5889b847a3d0d99f1d7c7707e749d11a62ef5701) ([merge request](gitlab-org/gitlab!136928))
- [Introduce new Group Users API endpoint](gitlab-org/gitlab@b614b462e40111f9f4e6631a04e3630167fc6ee9) ([merge request](gitlab-org/gitlab!134570)) **GitLab Enterprise Edition**
- [Create instance_audit_events_amazon_s3_configurations table](gitlab-org/gitlab@1f37512faf2ec3e85ffd102748868eb7579e47cd) ([merge request](gitlab-org/gitlab!136492)) **GitLab Enterprise Edition**
- [Expose present_on_default_branch field](gitlab-org/gitlab@639ad639e20b3bac8dbd2cb8b7ca410174e09229) ([merge request](gitlab-org/gitlab!137166)) **GitLab Enterprise Edition**
- [Use SyncServiceTokenWorker by default](gitlab-org/gitlab@dacc5e382a775d0da40a63bd82a3d9e522f1ab7f) ([merge request](gitlab-org/gitlab!137249))
- [Release remove remote_development_feature_flag](gitlab-org/gitlab@9e08f3d67519051de3751c22da364a59afbd05e9) ([merge request](gitlab-org/gitlab!136744)) **GitLab Enterprise Edition**
- [Add UI to support SHA256 repositories creation](gitlab-org/gitlab@df74cf0a74cc6fa0e2ce239cf57c748d75ca44b8) ([merge request](gitlab-org/gitlab!136681))
- [Add workspaces_quota and workspaces_per_user_quota fields](gitlab-org/gitlab@db969acdf474679c7ebd96d1c64f8392db679f5a) ([merge request](gitlab-org/gitlab!137089))
- [Add X-Gitlab-Host-Name to the AI Gateway header](gitlab-org/gitlab@0dd7263909825dda6e2873db887cd32d9389d1ba) ([merge request](gitlab-org/gitlab!136954))
- [feat: Add graphql mutation to update package protection rules](gitlab-org/gitlab@f9cefce3f0a375e8db32bd1cefd0dc0e03652b49) by @gerardo-navarro ([merge request](gitlab-org/gitlab!127096))
- [Add unit test for license scanning](gitlab-org/gitlab@1c8e7de79f34352a1aec58fe4700d700ba8c89f1) ([merge request](gitlab-org/gitlab!136264)) **GitLab Enterprise Edition**
- [Converted search type indicator to Vue](gitlab-org/gitlab@193c945c77e91a099fcbf0514ca213f0a3261762) ([merge request](gitlab-org/gitlab!134397)) **GitLab Enterprise Edition**
- [This MR adds section for custom yaml](gitlab-org/gitlab@cc39b9ebf0f5fd3a99bd0410a4aae37e72467ce9) ([merge request](gitlab-org/gitlab!136587)) **GitLab Enterprise Edition**
- [Add max_workspaces & max_workspaces_per_user field](gitlab-org/gitlab@400760252815c0cbdf45ffa85d286b708529ae06) ([merge request](gitlab-org/gitlab!136806))
- [Rate limit /completions API endpoint](gitlab-org/gitlab@b9c2d92aa409b96c573531177b7c42183d227505) ([merge request](gitlab-org/gitlab!133969)) **GitLab Enterprise Edition**
- [Enable generate test file functionality through vertex](gitlab-org/gitlab@39daa6c987fad2cdc73f25c5096798cb3cd45775) ([merge request](gitlab-org/gitlab!137017)) **GitLab Enterprise Edition**
- [Allow specifying Docker image platform to pull](gitlab-org/gitlab@07d67a2b0a1f0ca61a677446176ff370b602c1e9) by @ar-mali ([merge request](gitlab-org/gitlab!112907))
- [Added destroy api for namespace filters](gitlab-org/gitlab@2985b8f27fee38466f22e7d992bf739418d38909) ([merge request](gitlab-org/gitlab!136302)) **GitLab Enterprise Edition**
- [Add COMPRESS_CMD backup option](gitlab-org/gitlab@042587b7ed08f7c0854b8b4ce28274e2fe33ce6d) ([merge request](gitlab-org/gitlab!135541))
- [Adds read_timeout to Service Desk custom email verification errors](gitlab-org/gitlab@42f4c74e05c2976789e9ba8e57fed5a0ea47d317) ([merge request](gitlab-org/gitlab!136856))
- [Default_resources_per_workspace_container, max_resources_per_workspace](gitlab-org/gitlab@4853bc49fe6e30bb4088ff95f3e486ae9c3fd9ef) ([merge request](gitlab-org/gitlab!136853))
- [Adjust ingestion pipeline to populate finding_id](gitlab-org/gitlab@65f1ff79e3f0a0532e6a3c0f5372f2129ab1d15b) ([merge request](gitlab-org/gitlab!136755)) **GitLab Enterprise Edition**
- [Accept current_file parameter for Duo Chat](gitlab-org/gitlab@302bb8c61d51b23df38def6754da5944ed96b3bb) ([merge request](gitlab-org/gitlab!136822)) **GitLab Enterprise Edition**
- [Enfoce SSH Certificates via Settings](gitlab-org/gitlab@438475d7483af2b8406899f57f57d35a064b4f59) ([merge request](gitlab-org/gitlab!136498))
- [Initial commit of gitlab-secret_detection gem](gitlab-org/gitlab@72b79b5a82f2bed7a6171428e9badf296a1ea77f) ([merge request](gitlab-org/gitlab!135510))
- [Adds the Ci::Catalog::Resources::Destroy service](gitlab-org/gitlab@b632e8d3b75533b5be8c063591743ee94d012799) ([merge request](gitlab-org/gitlab!136457))
- [Add metrics for compliance group](gitlab-org/gitlab@075193bda835080161afd41fb034295e23e9bd45) ([merge request](gitlab-org/gitlab!135000)) **GitLab Enterprise Edition**
- [Enable scan_result_any_merge_request by default](gitlab-org/gitlab@015c28617ad3e1fa39bb591aadd02926f0566422) ([merge request](gitlab-org/gitlab!136298)) **GitLab Enterprise Edition**
- [Add setup for new Ultimate trial plan](gitlab-org/gitlab@6307fc4a820650bab55dcdef6640fb4bb9606813) ([merge request](gitlab-org/gitlab!136598)) **GitLab Enterprise Edition**
- [Add Tool option to Group By](gitlab-org/gitlab@19aa355e60eb96911dc3a47359724e44006af336) ([merge request](gitlab-org/gitlab!136301)) **GitLab Enterprise Edition**
- [Removes widget_pipeline_pass_subscription_update feature flag](gitlab-org/gitlab@5daeb68377414965812b026506cb7fc73bffb48a) ([merge request](gitlab-org/gitlab!136704))
- [Add clean Gitlab Duo chat history functionality](gitlab-org/gitlab@5ada8677fc79efe6321f3878a00f40678df03b44) ([merge request](gitlab-org/gitlab!136303)) **GitLab Enterprise Edition**
- [This MR adds compliance framework tooltip](gitlab-org/gitlab@6027cc5cd5fb71cb6e38eff58a6ef392fb93f8bb) ([merge request](gitlab-org/gitlab!135875)) **GitLab Enterprise Edition**
- [Ingest Service Desk custom email address replies](gitlab-org/gitlab@bb5246a38fa66b7a849d6477b35243915ed94ff6) ([merge request](gitlab-org/gitlab!136443))
- [Removes the target_branch_rules_flag feature](gitlab-org/gitlab@a51c8518bb4ce500b88c3ae4444d7e32beb3d3be) ([merge request](gitlab-org/gitlab!136431))

### Fixed (207 changes)

- [Prevent duplicate resource links in incidents](gitlab-org/gitlab@01844d6e65dbc4b1f2fe0ea10305e374f7d49d6d) ([merge request](gitlab-org/gitlab!139588))
- [Milestones finder - filter by id OR title](gitlab-org/gitlab@54efa4f2f903c5ab0ee700ec61f0bcc3d585f7f4) by @zzaakiirr ([merge request](gitlab-org/gitlab!139809))
- [Awards: Fix alignment with custom Emojis](gitlab-org/gitlab@3ba5dda3f1f4693bbfd1b7b9f42b5670a9c0ddc5) ([merge request](gitlab-org/gitlab!139650))
- [Fixed the layout of the work item health status widget](gitlab-org/gitlab@b220cc4775996990c806aa4b6bc67c7a8f55600b) by @zillemarco ([merge request](gitlab-org/gitlab!139757))
- [Refresh security policies only when user is present in approvers](gitlab-org/gitlab@45e99cbc8d886ec752d024c819e93e79012249d2) ([merge request](gitlab-org/gitlab!139980)) **GitLab Enterprise Edition**
- [Improved reorderable lists for touch devices](gitlab-org/gitlab@9dfe5502ff0b5a279c4220736f8964662c2ef3e7) ([merge request](gitlab-org/gitlab!139001)) **GitLab Enterprise Edition**
- [Allow creating assignee lists for invited members](gitlab-org/gitlab@768602d8911874228a11d1910d7506b533da32f4) ([merge request](gitlab-org/gitlab!139502)) **GitLab Enterprise Edition**
- [Hide "Merge immediately" button when fast-forward is not possible](gitlab-org/gitlab@fa7517c8f539c707ff0b4ad8e0f4f9cbf0411457) ([merge request](gitlab-org/gitlab!138866)) **GitLab Enterprise Edition**
- [Fix creating/updating/destroying of project group links](gitlab-org/gitlab@b1b0a72e2ef91c04434c7882be75435ede1bcd8e) ([merge request](gitlab-org/gitlab!133674))
- [Animate approval icon on MR reviewers section](gitlab-org/gitlab@c03ac754a35e1374f8e79d12677b369e644bee92) ([merge request](gitlab-org/gitlab!139691))
- [Fix inline code serialization in rich text editor](gitlab-org/gitlab@b0753454f3b2606a4c48d048cd48b1775804a02e) ([merge request](gitlab-org/gitlab!139942))
- [Fix pasting in code blocks in content editor](gitlab-org/gitlab@bfc8fcb56aee6b3d9f95b2166fedbbab9c90cff6) ([merge request](gitlab-org/gitlab!139935))
- [Fix code block serialization in rich text editor](gitlab-org/gitlab@03a4178436dab8772f9218dffb9250a57e79e9b4) ([merge request](gitlab-org/gitlab!139919))
- [Close button was not being dispalyed for open MRs](gitlab-org/gitlab@904b256a54b798b117ebfa9029a3025a315d062e) ([merge request](gitlab-org/gitlab!139714))
- [Include group links in access level checks](gitlab-org/gitlab@7eb104753f703d6c113d80bd146a8c0df55032cf) ([merge request](gitlab-org/gitlab!139582)) **GitLab Enterprise Edition**
- [Add importing: true to GitHub import objects](gitlab-org/gitlab@a8382e54ea2ce6648777a52eee5888b5b1f3a451) ([merge request](gitlab-org/gitlab!139860))
- [Fix N+1 queries in vulnerability exports](gitlab-org/gitlab@8f6f53721ae217ccd8306266017d07ba3331f4b9) ([merge request](gitlab-org/gitlab!139838)) **GitLab Enterprise Edition**
- [Fix URL on the UI when unique domain and namespace_in_path is enabled](gitlab-org/gitlab@6e49fd8e73fe2cc52ac63a3413ac35bc52e3fda9) ([merge request](gitlab-org/gitlab!139821))
- [Stop finding tagless releases](gitlab-org/gitlab@ee46f676290106c98bea09b406e735d19a4f08ef) ([merge request](gitlab-org/gitlab!139415))
- [Skip importing pull requests from forks](gitlab-org/gitlab@d5f22a21dd8cbc70aecab4a074627e314a4d29a4) ([merge request](gitlab-org/gitlab!139366))
- [Push Rules API 404 when dot in the namespace](gitlab-org/gitlab@4ef5b6cb90cd84e048a7ac9df0a688048ba6240a) ([merge request](gitlab-org/gitlab!139685)) **GitLab Enterprise Edition**
- [Fix the missing routing in wiki elasticsearch](gitlab-org/gitlab@74fc4d6d48eaa1797c2a656053df0531875e2ee7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/139669)) **GitLab Enterprise Edition**
- [Update security_findings fix_available filter to include solution field](gitlab-org/gitlab@4bb92fda07621f2915afb87009e6b40a28c55c66) ([merge request](gitlab-org/gitlab!137057)) **GitLab Enterprise Edition**
- [Unify storage related banners width](gitlab-org/gitlab@ee552710f873a32c2c0d10115c344eeb8fd60d84) ([merge request](gitlab-org/gitlab!139119))
- [Changes for PAT creation to calculate expiry date as set by user](gitlab-org/gitlab@f48e46615901eec727aae2c8888515dda14699e1) ([merge request](gitlab-org/gitlab!137983)) **GitLab Enterprise Edition**
- [Fix Board Issue avatar spacing](gitlab-org/gitlab@18412b5afa1b2d1511ce2377df6e2140e3170b12) ([merge request](gitlab-org/gitlab!139010))
- [Fix scrolling issue in rich text editor autocomplete](gitlab-org/gitlab@db2fd88f0eca49a51c4e0cdd7361888812e5fd0a) ([merge request](gitlab-org/gitlab!139697))
- [Fix scrolling tabs on activity view](gitlab-org/gitlab@c920468c14545c87c92510fa13bc4a80d9b4c640) ([merge request](gitlab-org/gitlab!139695))
- [Fix quick links styling with autodevops off](gitlab-org/gitlab@b7db185c3cf8ce0d753dd0aae315aeef8766a4dc) ([merge request](gitlab-org/gitlab!139575))
- [Dependency Proxy: add group access scope checks](gitlab-org/gitlab@bb48f7d1a553ba55df31dd94f96e3b773d31b84b) ([merge request](gitlab-org/gitlab!136655))
- [Move deprovisioning of paid group and project features](gitlab-org/gitlab@0058ef8e32151c3713ecda44027ca3565cd2031d) ([merge request](gitlab-org/gitlab!139646)) **GitLab Enterprise Edition**
- [Include `blob_path` in `VulnerabilityLocationType`](gitlab-org/gitlab@5e65e3ab6271a862e125db5af0d318f96292f008) ([merge request](gitlab-org/gitlab!139497)) **GitLab Enterprise Edition**
- [Vulnerability report: fix sticky header when error](gitlab-org/gitlab@f965b107b50231bb1d180369bcad4a6e6f2e440d) ([merge request](gitlab-org/gitlab!139436)) **GitLab Enterprise Edition**
- [Fix metrics server not shutting down when Puma is stopped](gitlab-org/gitlab@593bcda331378c4bfed0250e53a63cacfc2f1c76) ([merge request](gitlab-org/gitlab!139589))
- [Show project actions dropdown text on small screens](gitlab-org/gitlab@4b9443bc29a94856872fd7f36e4b81ddf31f568b) ([merge request](gitlab-org/gitlab!139577))
- [Add method for removing duplicate epics](gitlab-org/gitlab@a2d0cf679243340eb8afcda80fca118e9e3b3b70) ([merge request](gitlab-org/gitlab!134524)) **GitLab Enterprise Edition**
- [Use search_service to determine type](gitlab-org/gitlab@6a42e8d9423634f216a4c1758d73710870a59cbb) ([merge request](gitlab-org/gitlab!139537))
- [Deduplicate finding maps by UUID before ingestion](gitlab-org/gitlab@e970d7fec22d7c1d28a7582da3cdaeaabcd7f773) ([merge request](gitlab-org/gitlab!139468))
- [Emoji Picker: Fix wrongly shown active tab after closing](gitlab-org/gitlab@4883ffd1b3ebd88bf9bdf891de7f715e83ccd2db) ([merge request](gitlab-org/gitlab!139529))
- [Refactor wiki_class_proxy to make simple](gitlab-org/gitlab@e977b62e1ff945e2b859b7273782e4244a641fe3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/134978)) **GitLab Enterprise Edition**
- [Fixed search type indicator bug](gitlab-org/gitlab@2d2d95698a319257f2f9d7f36c4baeffe8733664) ([merge request](gitlab-org/gitlab!139372))
- [Checks if import data contains credentials and data](gitlab-org/gitlab@74e9e3b944053ce4bf4792336c3a1d3347f293a3) ([merge request](gitlab-org/gitlab!139498))
- [Fix enabled_zoekt? logic](gitlab-org/gitlab@5a2e02e7c1f6623b73d74ac7bddc659d28da9687) ([merge request](gitlab-org/gitlab!139471)) **GitLab Enterprise Edition**
- [Prevent showing repos in the new MR dropdown that are inaccessible](gitlab-org/gitlab@0b7b9c20ab29e86c06d57ab0948d281a4a8bb611) ([merge request](gitlab-org/gitlab!136282))
- [Update invalid rules text color for 4.5:1 WCAG 2.1 AA contrast](gitlab-org/gitlab@9bab23186b4468f23992f5802b8f5901418d93d8) ([merge request](gitlab-org/gitlab!139334))
- [Do not fail import on NoMethodError](gitlab-org/gitlab@e1a12d032bd68556c09a7ae8935dea13880b3b22) ([merge request](gitlab-org/gitlab!139466))
- [Finding builder errors should be recoverable](gitlab-org/gitlab@6dca74e11269542703f864d1124c10f6aa10a746) ([merge request](gitlab-org/gitlab!138840))
- [Choosing a base diff if using a specific diff id](gitlab-org/gitlab@bf589e1b315f07bcbd37fc6eedb251941e083cc7) ([merge request](gitlab-org/gitlab!137060))
- [Don't show project limit popover when FF is disabled](gitlab-org/gitlab@6333e16ace56082781646cbc6b83d4fa8bbba595) ([merge request](gitlab-org/gitlab!138796)) **GitLab Enterprise Edition**
- [Search indication message alignment](gitlab-org/gitlab@263162d33a1396deac4de71d032c717c8e6e2cac) ([merge request](gitlab-org/gitlab!139368))
- [Handle invalid vulnerabilities, finalize bg migration](gitlab-org/gitlab@406748da6b118f07f31724ea71b3a78d8ae95e41) ([merge request](gitlab-org/gitlab!138947)) **GitLab Enterprise Edition**
- [Tree header controls: Fix alignment and spacing on mobile](gitlab-org/gitlab@9d846b135eb6200fad997f0c51b87c630e3a6786) ([merge request](gitlab-org/gitlab!139363))
- [Refactor logged out header to isolate styles specific to it's usage](gitlab-org/gitlab@b788e1958f8ed83f84e47e2245e214d91e6abb75) ([merge request](gitlab-org/gitlab!139048))
- [Fix sticky header on vulnerability reports](gitlab-org/gitlab@5ffee589d4a930cff5303aaa58f15a8979f4b6e0) ([merge request](gitlab-org/gitlab!139118)) **GitLab Enterprise Edition**
- [Fetch group and project after session has been loaded](gitlab-org/gitlab@f662289fdaddc92a440c8b95ee2649e9ae170daa) ([merge request](gitlab-org/gitlab!137829))
- [Accept [PermissionsEnum] instead of [String]](gitlab-org/gitlab@14032bdd412c6491223a711023ebd8a29e64eea2) ([merge request](gitlab-org/gitlab!138983)) **GitLab Enterprise Edition**
- [Fix rich text editor format toolbar wrapping](gitlab-org/gitlab@023c2e4919cb21f3061e187d6ef276a44f8c2079) ([merge request](gitlab-org/gitlab!139167))
- [Sanitize custom maintenance mode message](gitlab-org/gitlab@06161453359b54115f7bf1d778d476ec1a15d355) ([merge request](gitlab-org/gitlab!139266)) **GitLab Enterprise Edition**
- [Update logs tree encoding method](gitlab-org/gitlab@496d8fb911c9cdc48ce268e931728c7be977ec05) ([merge request](gitlab-org/gitlab!136323))
- [fix: Secret Detection findings should require manual resolution](gitlab-org/gitlab@5a3747292a8537e594bf022e63b82d15f441ea81) ([merge request](gitlab-org/gitlab!138530)) **GitLab Enterprise Edition**
- [Fix deprovisioning paid features upon transfer to subgroups](gitlab-org/gitlab@d3358b30b98228cdf3e8c1eb94d48b52b4c82849) ([merge request](gitlab-org/gitlab!137887)) **GitLab Enterprise Edition**
- [Use until_executed deduplication for CoverageReportWorker](gitlab-org/gitlab@1c5559ba462a5bd62e1c7c6d28abff5a24a3f55b) ([merge request](gitlab-org/gitlab!139246))
- [Copy iteration system notes on moving issue](gitlab-org/gitlab@74e1ceb6b2d9f48cdc622d998885db8cbcb825ab) ([merge request](gitlab-org/gitlab!139216)) **GitLab Enterprise Edition**
- [Fixes error when noteable is Commit in CreateNoteHandler](gitlab-org/gitlab@0f80ba953ed246321d77a45dfccd4218125777b1) ([merge request](gitlab-org/gitlab!138955))
- [Provide minimal access options for custom roles](gitlab-org/gitlab@fd9685182d599a78b833e019ea3b4e686c4d112b) ([merge request](gitlab-org/gitlab!138561)) **GitLab Enterprise Edition**
- [Fix undefined method <= for nil:NilClass on pages:deploy](gitlab-org/gitlab@beff4315d632449667b28361e20925f2c77d8944) ([merge request](gitlab-org/gitlab!138774))
- [Correct aria-expanded usage for related issues](gitlab-org/gitlab@46d9e889634355d6d4b7e3de80153b52ae70219c) ([merge request](gitlab-org/gitlab!138838)) **GitLab Enterprise Edition**
- [Fix duplicate CI variables when running manual jobs](gitlab-org/gitlab@d6a6416e2506a2bd4e717ebcca165e73682e044b) ([merge request](gitlab-org/gitlab!138901))
- [Add snowsplow to the CSP of all controllers](gitlab-org/gitlab@4cdd4203e6abbc42e798eedf21fc20cabaa2f74e) ([merge request](gitlab-org/gitlab!138117))
- [Compliance framework badge remove custom styles](gitlab-org/gitlab@ad883c02a5d232edb56c3e05dd1357d180dcad34) ([merge request](gitlab-org/gitlab!139058)) **GitLab Enterprise Edition**
- [Fix pre-enforcement banner width](gitlab-org/gitlab@b247be89b6341b891be3b91250771de302e6fbb6) ([merge request](gitlab-org/gitlab!138957))
- [Fix maintenance mode toggle in admin settings](gitlab-org/gitlab@c245c7a9f0e8d7bc28cce9508f71cc74d626616b) ([merge request](gitlab-org/gitlab!138998)) **GitLab Enterprise Edition**
- [Fix broken dependency list aggregation](gitlab-org/gitlab@49ff243a2d68d7ee59050668c48484788e147371) ([merge request](gitlab-org/gitlab!139014)) **GitLab Enterprise Edition**
- [Requeue backfill migration for remediations](gitlab-org/gitlab@1c4a500f291552b3f7156ccf9e39fbcc4af999e0) ([merge request](gitlab-org/gitlab!138574))
- [Update branch protection default setting values](gitlab-org/gitlab@c719aa434c96167c8d1c2e165dc86388f6046c24) ([merge request](gitlab-org/gitlab!138997))
- [Correctly deduplicate vulnerabilities with 8 digit image tags](gitlab-org/gitlab@752d9a59eb973407ad2e4a279a0b7b74f0dab364) ([merge request](gitlab-org/gitlab!138675)) **GitLab Enterprise Edition**
- [Fix project templates at instance level](gitlab-org/gitlab@1c18f15c2b8f8f11f8a82486648bb37abd4d9781) ([merge request](gitlab-org/gitlab!137995))
- [Fix alignment issues with the MR widget](gitlab-org/gitlab@74b511ba5ca18765e566aa6c6eddb25c1d3dcdee) ([merge request](gitlab-org/gitlab!138789)) **GitLab Enterprise Edition**
- [Fix undefined method `downcase' error](gitlab-org/gitlab@398651ab8abdab97c53630fe0dc864abe389dae0) ([merge request](gitlab-org/gitlab!138924))
- [Send confirmation instructions to provisioned by group users if needed](gitlab-org/gitlab@d7877c4503b36c0d13f4fd7e3b259a03d94fd9f8) ([merge request](gitlab-org/gitlab!138501)) **GitLab Enterprise Edition**
- [Bump LocalStorageCache key version](gitlab-org/gitlab@f539aa2ee8b5783660e9d57ad47104aa953f802a) ([merge request](gitlab-org/gitlab!138667))
- [Sidebar spacing changes](gitlab-org/gitlab@a900524add3dc4adf26ee0ddc26f65cd77d38ef0) ([merge request](gitlab-org/gitlab!138896))
- [Do not import if import data is missing](gitlab-org/gitlab@05e0d675cb36d6dd2dceb0c78613c16616792c16) ([merge request](gitlab-org/gitlab!138888))
- [Render different headings when isModal is false](gitlab-org/gitlab@e7768f9162491e9f566f36cbfe0db3bc86ccbb0c) ([merge request](gitlab-org/gitlab!138560))
- [Update creation of Direct Transfer batch exports to use `in_batches`](gitlab-org/gitlab@f86454159aab262f3fc7eeb8917bc04a38d42297) ([merge request](gitlab-org/gitlab!138815))
- [Convert events author_id to users foreign key to a LFK](gitlab-org/gitlab@762586d6730b5be3cefb19d18f1dbc7f21676183) ([merge request](gitlab-org/gitlab!138215))
- [Upsert Vulnerabilities::Scanner](gitlab-org/gitlab@3e31788542a4dd460bb73f34bd0e505e7a0e36a1) ([merge request](gitlab-org/gitlab!138754)) **GitLab Enterprise Edition**
- [Fix 500 error for X509 commits without a certificate](gitlab-org/gitlab@19ba19fbb4c942832d288fb5269d4e8073d72c93) ([merge request](gitlab-org/gitlab!138521))
- [Allow paratheses for template names](gitlab-org/gitlab@93aa0024231bc55d555a64d3448229458e953cc8) ([merge request](gitlab-org/gitlab!138367))
- [Fix loading of ancestors for signed out users](gitlab-org/gitlab@ddf447b1afb8df86fec99b0c83ab3abe2ed8e9bb) ([merge request](gitlab-org/gitlab!138209))
- [Fix Z-index Issue on inline Findings Dropdown](gitlab-org/gitlab@28ba98c831d7043073954bfef830e43121d62e77) ([merge request](gitlab-org/gitlab!138020))
- [Fix hidden retry job dropdown in safari](gitlab-org/gitlab@f608b12043bf5c217675bde9ee5896d43e6f4f2b) ([merge request](gitlab-org/gitlab!138398))
- [Fix 500 error when accessing resources as anonymous user](gitlab-org/gitlab@6290b55ec567dbbaa42c9cb198dd4bc17f0c2330) ([merge request](gitlab-org/gitlab!138527))
- [Consider relative URL root in group overview tabs](gitlab-org/gitlab@cbf42a2ee59a7261e955ca11550dfbd8d3dd71ce) by @zzaakiirr ([merge request](gitlab-org/gitlab!138632))
- [Fix pages path_prefix ci variable expansion](gitlab-org/gitlab@1d596ea410dd93a590ed688292942abeb262de00) ([merge request](gitlab-org/gitlab!138593)) **GitLab Enterprise Edition**
- [Fix work item loading as signed out user](gitlab-org/gitlab@ecb4bb1a66aa42db03a8cc1f75afcf0e654a4225) ([merge request](gitlab-org/gitlab!138643))
- [Fix code generation anthropic prompt](gitlab-org/gitlab@386a9e636562a0a4e96d096975ead4a690f074f1) ([merge request](gitlab-org/gitlab!138637)) **GitLab Enterprise Edition**
- [Fix push & merge branch rules label](gitlab-org/gitlab@5e2e73d3cfed8419786cf9ff9b0731a337fd52a1) ([merge request](gitlab-org/gitlab!138634))
- [Fix task list updates for different issue types](gitlab-org/gitlab@bfed3d073369816b028cd5e2854825afeb8b2722) ([merge request](gitlab-org/gitlab!137705))
- [Fix clicking edit the second time on commit comments](gitlab-org/gitlab@3be95fcb11be8fe67aa013abe50bb2f1c5ed9b64) ([merge request](gitlab-org/gitlab!138619))
- [Skip email domain checks for service accounts](gitlab-org/gitlab@4e4860c8aa8cbe60bdd7e04e809d1657e3b0de33) ([merge request](gitlab-org/gitlab!138414)) **GitLab Enterprise Edition**
- [Gracefully handle corrupted/invalid repo HEAD](gitlab-org/gitlab@083be06587b6b939061d565bb9db83d2fc6670a3) ([merge request](gitlab-org/gitlab!138292))
- [Fix work item ancestor loading for user namespaces](gitlab-org/gitlab@0f925869ca527433d588f9b3ff78f0b75ea2e7c7) ([merge request](gitlab-org/gitlab!138541))
- [Fix undefined framework_id error when unassigning framework](gitlab-org/gitlab@b9246d069b45eef49e8ebde46acf2777a7261dc2) ([merge request](gitlab-org/gitlab!138365)) **GitLab Enterprise Edition**
- [Update mobile spacing of nav links](gitlab-org/gitlab@aab064497296726883e518d10941df55f0760385) ([merge request](gitlab-org/gitlab!138511))
- [Commit info: Fix for broken wrapping](gitlab-org/gitlab@30a2ea6364a8966c320a63da7c0db022eee299d0) ([merge request](gitlab-org/gitlab!138504))
- [Update docs redirects 2023-11-29](gitlab-org/gitlab@9d3f869f5aac0789e3b03f75b65192c7d6879e75) ([merge request](gitlab-org/gitlab!138223))
- [Adjust styling of md editor header](gitlab-org/gitlab@41e78ef065a76627743876cf982bcfd68bfc8759) ([merge request](gitlab-org/gitlab!137294))
- [Improve error handling on Usage Quotas](gitlab-org/gitlab@3dd968f5284162e230d7d2e785eb63ee6349e9c4) ([merge request](gitlab-org/gitlab!138032)) **GitLab Enterprise Edition**
- [Fix cluster reindexing preflight check](gitlab-org/gitlab@be61bd22fec626040ce1b02af98fd8ae3067fafe) ([merge request](gitlab-org/gitlab!138211)) **GitLab Enterprise Edition**
- [Fix unlocking non-successful pipelines](gitlab-org/gitlab@09e6729083dd5b386cc2b42ff23b37b55b907768) ([merge request](gitlab-org/gitlab!138459))
- [Fix issue and epic title alignment on small screens](gitlab-org/gitlab@ce9c6bbcb9642f4f1cb3e98ac8b9e5c5b9aecc26) ([merge request](gitlab-org/gitlab!138205))
- [Quick action parsing fixed](gitlab-org/gitlab@6eba337070941d6a7f3ae493e610512a8072f5b5) ([merge request](gitlab-org/gitlab!138420))
- [Remove notifications from sm issue dropdown behind feature flag](gitlab-org/gitlab@f2ae6b92c0d49d7670a208043670e196ea3c80a3) ([merge request](gitlab-org/gitlab!138374))
- [Fix pull mirroring for projects created from templates](gitlab-org/gitlab@11914b2941fcddd4dbae4a9061b4702887386251) ([merge request](gitlab-org/gitlab!137433)) **GitLab Enterprise Edition**
- [Stop Inline Findings Polling when error occurred](gitlab-org/gitlab@335aff5494f51b5d280a77f45fbaf4811e422085) ([merge request](gitlab-org/gitlab!138021)) **GitLab Enterprise Edition**
- [Fix scope of project visibility checks when changing group visibility](gitlab-org/gitlab@191c0c2ef622cce66aac14abaac31693a2e14adb) ([merge request](gitlab-org/gitlab!138179))
- [Fix overflow issue of focus in commit info](gitlab-org/gitlab@45bcc9b65a27078db0ee1be702e6315a96606765) ([merge request](gitlab-org/gitlab!138068))
- [Comment on file button expands the file](gitlab-org/gitlab@6f81d1775219bff379daed1bb9f8f5e3eddf7e2e) ([merge request](gitlab-org/gitlab!137873))
- [Remove `contributions_calendar_refactoring` feature flag](gitlab-org/gitlab@0666c17538535ddd4cb301dd97eb0a33d0d7bd27) by @zzaakiirr ([merge request](gitlab-org/gitlab!138309))
- [Fix adding confidential child tasks](gitlab-org/gitlab@4423782ef0cbfc3b61b635e2128e68dfedef6f1b) ([merge request](gitlab-org/gitlab!138071))
- [Fix TLS support for standalone Redis](gitlab-org/gitlab@a83ed3286d9de28af5b00d84f7b720b323007686) ([merge request](gitlab-org/gitlab!138010))
- [Fix Kubernetes cluster health badge](gitlab-org/gitlab@9269d175bdffd5628ba9fbb3253a52ac01306df7) ([merge request](gitlab-org/gitlab!137785))
- [Fix project access tokens page for admin](gitlab-org/gitlab@30ed888467257a606f3510d157f8ff16be961f06) ([merge request](gitlab-org/gitlab!138138))
- [Return job_waiter if an error is raised](gitlab-org/gitlab@47d9a1f80b85ddc9a1a70251bfb70bc17edca35e) ([merge request](gitlab-org/gitlab!138282))
- [Fix javascript errors that occur due to missing elements on project page](gitlab-org/gitlab@655f2459e4c1a92595cbbc008a27a25070ba5601) ([merge request](gitlab-org/gitlab!138236)) **GitLab Enterprise Edition**
- [Add delay between pipeline schedules execution](gitlab-org/gitlab@eac88e3cc674a5d8bc5dc4d47ea980775773fd75) ([merge request](gitlab-org/gitlab!136992))
- [Fix copy ref shortcut on issues](gitlab-org/gitlab@cd680e13d268941d299614e6e8df977135834c2d) ([merge request](gitlab-org/gitlab!138102))
- [Pipelines Artifact set max-height to dropdown](gitlab-org/gitlab@67c60c9432e9f3a225dc370eb1439b1da07b4634) ([merge request](gitlab-org/gitlab!138079))
- [Clarify error when base url invlaid](gitlab-org/gitlab@9a20a72274734a6bd2a21a158d6ae02ac0f0ade1) ([merge request](gitlab-org/gitlab!137434))
- [Blob controls: Fix alignment](gitlab-org/gitlab@33681f5e9fa5b6cdc8e1b154cb3173fe13493b90) ([merge request](gitlab-org/gitlab!137956))
- [MR widget: remove double border Part II](gitlab-org/gitlab@4083d8501d07a574ab9f0adc4f4b5801050875bd) ([merge request](gitlab-org/gitlab!137881))
- [Allow PAT to be rotated in edge case](gitlab-org/gitlab@e6335140a1c23d30c5a9e9c13636285b177fcb0c) ([merge request](gitlab-org/gitlab!137281)) **GitLab Enterprise Edition**
- [Bitbucket server should not import when failed](gitlab-org/gitlab@bf7e9f3669f9f4957f669f896e036990a8c3e2d1) ([merge request](gitlab-org/gitlab!138172))
- [Fix NoMethodError in Vulnerabilities::RemoveAllVulnerabilitiesWorker](gitlab-org/gitlab@f9c4ee0b8a749348d6b0b82b2d8816766bee3faf) ([merge request](gitlab-org/gitlab!138167))
- [Rename package metadata advisory source xid](gitlab-org/gitlab@ff158cb346db5f3774a7da00ee5952ec90d36c4a) ([merge request](gitlab-org/gitlab!137925))
- [Fix MS Graph Client validation of token when no token exists](gitlab-org/gitlab@dbefdb9b9e0c72b6f0dc2f160422f4fd5bd5dd15) ([merge request](gitlab-org/gitlab!137470)) **GitLab Enterprise Edition**
- [Add migration to fix broken user achievement records](gitlab-org/gitlab@6662f491ccc88875d3ebae68358440f5dbe41b8b) by @Taucher2003 ([merge request](gitlab-org/gitlab!137992))
- [Migrate fields of UserAchievement to Ghost User on User deletion](gitlab-org/gitlab@c0bb67a6c350b56b7b4d85999c3c211843fde925) by @Taucher2003 ([merge request](gitlab-org/gitlab!137992))
- [Allow developers invited through group to read group runners](gitlab-org/gitlab@18cc550000665aca3ac172a418f00d8d7c1e28bc) ([merge request](gitlab-org/gitlab!137041))
- [Set failure flag on parent import when an entity fails](gitlab-org/gitlab@d28e21e3ecdd19cd54f782d5639f771614bc3b37) ([merge request](gitlab-org/gitlab!138036))
- [Include scheduled when deduplicating ProcessScanResultPolicyWorker](gitlab-org/gitlab@947a330a588c62e496f0802b2fe66f27795aa049) ([merge request](gitlab-org/gitlab!137930)) **GitLab Enterprise Edition**
- [Change the foreign key to member_roles on members](gitlab-org/gitlab@237c48956a5792d36d00f6e1d18362cf242575fe) ([merge request](gitlab-org/gitlab!137805))
- [Fix the index_name in IndexrepairService](gitlab-org/gitlab@910a45d188c65de860596f0fdf6b46f0da4f3084) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/137836)) **GitLab Enterprise Edition**
- [Fixed error for work item update task](gitlab-org/gitlab@23c0c801c4816f96dff5dcd8e418da4adcd7eed7) ([merge request](gitlab-org/gitlab!137837))
- [Avoid idling in transaction when exporting relation using DirectTransfer](gitlab-org/gitlab@1467b26ee28ff65eaf2b38c8595acf666fe785ed) ([merge request](gitlab-org/gitlab!137766))
- [Move unlock pipeline cron scheduler out of ee](gitlab-org/gitlab@73ea9ad75cc3ad987bbcce7f9a3ef0bbfc5eafc6) ([merge request](gitlab-org/gitlab!137749))
- [MR widget: remove double border](gitlab-org/gitlab@14d546a52f88206414402c5719192ff6635655b6) ([merge request](gitlab-org/gitlab!137748))
- [Improve delete_software_license_policies query](gitlab-org/gitlab@dc82a705b611dc9f5f99da80ae794d28d7e56cde) ([merge request](gitlab-org/gitlab!137707))
- [Refresh project statistics when removing a fork relationship](gitlab-org/gitlab@776f67c70f98d3638bc319cdfad0edf1a4de08fc) ([merge request](gitlab-org/gitlab!137197))
- [Add guard when vun read is absent](gitlab-org/gitlab@a26399207f7f88bcfcbad8afc2640392a19c1b20) ([merge request](gitlab-org/gitlab!137595)) **GitLab Enterprise Edition**
- [Allow + in abuse detection](gitlab-org/gitlab@79d9df9b33f21616f4fe1df4ecffacc879d093a3) ([merge request](gitlab-org/gitlab!137549))
- [Enable API redirection for moved projects](gitlab-org/gitlab@1d848fee54d98e241a4991b72933042a8cd2914b) ([merge request](gitlab-org/gitlab!137578))
- [Truncate verification failure message to 255](gitlab-org/gitlab@bb8758969a6609aba7fc9b73f51e0fdffbb59fcf) ([merge request](gitlab-org/gitlab!137569)) **GitLab Enterprise Edition**
- [Package registry: truncate Pypi metadata fields](gitlab-org/gitlab@ada402f0783d88cb33aad597e8ad90eb1c85795b) ([merge request](gitlab-org/gitlab!137000))
- [Handle invalid MIME type on multipart upload](gitlab-org/gitlab@fd1a866b5720fe7ec25059201c4cd7fa6b199922) ([merge request](gitlab-org/gitlab!137517))
- [Fixes type bug in MLflow Registered Models API response](gitlab-org/gitlab@5df4d5f92a5310f486921f486322196ed8279219) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/137459))
- [Consistency fixes for Tasks widget](gitlab-org/gitlab@63f5b899f886d4df697322b163ffa1ba556f2554) ([merge request](gitlab-org/gitlab!136762))
- [Fix ingestion logic for remediations](gitlab-org/gitlab@1add6ec16fb5c21e692034ade10bed23eae7d38f) ([merge request](gitlab-org/gitlab!135747))
- [Geo: Fix VerificationStateBackfillWorker N+1 queries](gitlab-org/gitlab@123c5801f5243761bc73d4adea953729dde1ecfb) ([merge request](gitlab-org/gitlab!136394)) **GitLab Enterprise Edition**
- [Update formatTimeAsSummary helper function](gitlab-org/gitlab@1c1b0eceb39173a8c38ede3cd41dee4ace07a815) ([merge request](gitlab-org/gitlab!137169))
- [Hide stage::deploy filter from issue/mr dashboard](gitlab-org/gitlab@4082a2332a067c063144a8a74fffb9800bdc3387) ([merge request](gitlab-org/gitlab!136913))
- [Don't show /invite_email quick action on new issue](gitlab-org/gitlab@78b3fefe984323d47aff8bcf568d9f8a134d71ac) ([merge request](gitlab-org/gitlab!137397))
- [Boards - Fix fetching blocking issues](gitlab-org/gitlab@cf9c3cc86c1a2b1d3122bf3b65c65faf5ee3ef47) ([merge request](gitlab-org/gitlab!137202)) **GitLab Enterprise Edition**
- [Fix inconsistent scroll to file in 'Show one file at a time' mode](gitlab-org/gitlab@9f444a279eb1f6c5737600e257d548e815a4412d) ([merge request](gitlab-org/gitlab!137195))
- [Skip encrypted settings logic for Redis when used by Mailroom](gitlab-org/gitlab@6d0a263c6c26845e455d3c7e30912aa264dee406) ([merge request](gitlab-org/gitlab!137279))
- [Pipelines Artifact set max-height to dropdown](gitlab-org/gitlab@c9245c3dc6a4e5499b10f08a41d5a675a2239106) ([merge request](gitlab-org/gitlab!137272))
- [Replace cropper with cropperjs](gitlab-org/gitlab@2d0ca2ab7c06d9eba3ef159e7740279838321992) by @brianjaustin ([merge request](gitlab-org/gitlab!136620))
- [Fix Security Reports widget not displaying error message](gitlab-org/gitlab@7b7790314dcb873d015802092cc55df852653db2) ([merge request](gitlab-org/gitlab!136990)) **GitLab Enterprise Edition**
- [Failing bulk import entity on abort_on_failure](gitlab-org/gitlab@f7d1fd0a0051905276bc0674f6126744b551b577) ([merge request](gitlab-org/gitlab!136512))
- [Allow project developers to read runners](gitlab-org/gitlab@22f8a61da990c124599fdd2853b22b0c1ad6bd3b) ([merge request](gitlab-org/gitlab!137011))
- [Stop CI minutes legacy tracking](gitlab-org/gitlab@aa0478d119c6d7898343ab766a2b503e5668d15a) ([merge request](gitlab-org/gitlab!137254))
- [Clone button: Styles missing on empty project page](gitlab-org/gitlab@816d13917be6b039dc4827e776c90e80771508da) ([merge request](gitlab-org/gitlab!137248))
- [Randomize cron minutes for schedules](gitlab-org/gitlab@ee40935a9b9c26acde4ac133cc2813b7bf9c065f) ([merge request](gitlab-org/gitlab!137035))
- [Fix token for repository tree keyset pagination](gitlab-org/gitlab@181f6c36c216b7ce549d15ebddd15730111dd610) ([merge request](gitlab-org/gitlab!136586))
- [Fix iteration cadence and wild card filter for boards](gitlab-org/gitlab@587f3e51819b4b9076b2ec5d955f11770c20361f) ([merge request](gitlab-org/gitlab!137069))
- [Removing FF fallback_to_db to ensure we recache ids on cache miss](gitlab-org/gitlab@72aa2785f73417ac29e89d589484b84553246dac) ([merge request](gitlab-org/gitlab!136931))
- [Fix vertical line on user activity](gitlab-org/gitlab@5bd8370f13331fe8aa573fb01e053b57bfecaf3a) ([merge request](gitlab-org/gitlab!137036))
- [Allow users to authenticate via OAuth with password-based providers](gitlab-org/gitlab@1b414b59889437ee53becb61836ebd6397348374) ([merge request](gitlab-org/gitlab!137171))
- [Increase z index of MR sticky header](gitlab-org/gitlab@e791f547f927ae29a08dd0d4e5056c830a15f138) ([merge request](gitlab-org/gitlab!137158))
- [Remove Cluster Image Scanning](gitlab-org/gitlab@74b495669e9575ebdf232eade9132d73be3e4a9d) ([merge request](gitlab-org/gitlab!137111))
- [Only show published catalog resources](gitlab-org/gitlab@8b47ce3855c76abcefa6f5c606cbd8a494b387c1) ([merge request](gitlab-org/gitlab!136698))
- [Fix public deploy key form](gitlab-org/gitlab@65ac127be364144735cf1a4c66cb33f58ed20b25) ([merge request](gitlab-org/gitlab!133787))
- [Add block to parent wiget collapsible listbox](gitlab-org/gitlab@60f04123ded4e1bebf426b30798271366328d37f) ([merge request](gitlab-org/gitlab!137120))
- [Include merge request approved events in Profile heat map](gitlab-org/gitlab@26adb8bbde87a35bf1e6ff7ca42060ac8cccca1f) by @zzaakiirr ([merge request](gitlab-org/gitlab!134991))
- [Convert reference text to a reference after spacebar](gitlab-org/gitlab@160b6a89a84619b392c2c22265da84c4efbb6226) ([merge request](gitlab-org/gitlab!137106))
- [Handles issue refs that do not have specific issue names](gitlab-org/gitlab@3b5a0ab6e9648074fbca86c1408306636a367dd0) ([merge request](gitlab-org/gitlab!136672))
- [Stop validating snippets when restoring from backup](gitlab-org/gitlab@6c90b6007abf11ee4605952eb367196b67851d38) ([merge request](gitlab-org/gitlab!137070))
- [Add `PagesDeployment` upload_finished field](gitlab-org/gitlab@40519e00c27160d32f796d408039805102b9e9bc) ([merge request](gitlab-org/gitlab!136970))
- [Fixes MLflow compatibility issue in model versions API](gitlab-org/gitlab@f632cad8f6e91416dfd0475d0034d1abf395b373) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/137042))
- [Don't use cached value for snippet edit](gitlab-org/gitlab@2acf1af4328a031a9eee1a8f3765bfdff5fa0997) ([merge request](gitlab-org/gitlab!136866))
- [Pipeline Minigraph: Fix job dropdown item link renders twice](gitlab-org/gitlab@b66dcf8c842ae19ff0a035ea6c495cb876ac8c05) ([merge request](gitlab-org/gitlab!136963))
- [Round deployment frequency avg. to nearest 10th](gitlab-org/gitlab@7aca79eceefb59c267e9ac4124e51fd505d62905) ([merge request](gitlab-org/gitlab!136531)) **GitLab Enterprise Edition**
- [Resets pagination on applying filter on Seats tab on Usage Quotas page](gitlab-org/gitlab@065974576f062e8b4ab9ebe0b5f3ef969cf6f9b4) ([merge request](gitlab-org/gitlab!136796)) **GitLab Enterprise Edition**
- [Fix sidebar wiki heading color](gitlab-org/gitlab@6caf2d5c58979b26a0cd71641b83bbd9ddcaf128) ([merge request](gitlab-org/gitlab!136889))
- [Mini Pipeline: Fix alignment of linked items](gitlab-org/gitlab@49c6aabbeb8e5209f6f923b1835fd860b2e3667e) ([merge request](gitlab-org/gitlab!136887))
- [Add exclusive lock for UpdateRepositoryStorageWorker](gitlab-org/gitlab@ca9399781b0c4d0d85ba409eef91f718648f554d) ([merge request](gitlab-org/gitlab!136169))
- [Use project CI config path to show CI blob viewer](gitlab-org/gitlab@de353150b56453fa58c14df79d824c2c4ece1737) ([merge request](gitlab-org/gitlab!136549))
- [Fixes LimitAlertComponent access check](gitlab-org/gitlab@bf3f85225ed56e1d1e3567456ff0ff1ff157531b) ([merge request](gitlab-org/gitlab!136470)) **GitLab Enterprise Edition**
- [Fix button alignment in child issues and epic widget](gitlab-org/gitlab@1db15ef447997ec4b3a848d0695f4b4ffcc005fd) ([merge request](gitlab-org/gitlab!136707))
- [Fix group page erroring because of nil user](gitlab-org/gitlab@ca66a84e4ac17629fdc7021618a5d2e630df9231) ([merge request](gitlab-org/gitlab!136786))
- [Increse billable users when using custom roles](gitlab-org/gitlab@330e9302bf30ef20ea0403460334ba6d3fd6584e) ([merge request](gitlab-org/gitlab!135627)) **GitLab Enterprise Edition**
- [Initialize Confirm Rollback Modal in Env Folders](gitlab-org/gitlab@f6dc81b8f5629f432272edd48b12a4eaf1eb5240) ([merge request](gitlab-org/gitlab!136749))
- [Prefer custom sort order with search in users API](gitlab-org/gitlab@098d4eff63a9da4f24fa0e5ba05dcb7e25892764) ([merge request](gitlab-org/gitlab!136538))
- [Return SAST report errors in an `errors` array](gitlab-org/gitlab@e7742603cb9f42b39e33395a1c4f8afad4e9b4fc) ([merge request](gitlab-org/gitlab!134490)) **GitLab Enterprise Edition**
- [Support EDITOR having arguments in encrypted secrets Rake tasks](gitlab-org/gitlab@b268736dd6a9f5dd05b6e6c68a06fa8ad4a95079) ([merge request](gitlab-org/gitlab!136527))
- [Release GitHub importer higher Sidekiq interrupts](gitlab-org/gitlab@a2ea5c0ad4dee11d9a7cc4dfe3f0ff445aa55130) ([merge request](gitlab-org/gitlab!135789))

### Changed (279 changes)

- [Refactor code_suggestions_ga_non_owner_alert feature spec](gitlab-org/gitlab@07649a38f8a7de47c45d9b94939f39faf7a1af03) **GitLab Enterprise Edition**
- [Adds support to filter packages by version](gitlab-org/gitlab@f9b674c11d11489518efd6f6602c995b8d8f9a28) ([merge request](gitlab-org/gitlab!139403))
- [Add copy to clipboard button to merge conflict file header](gitlab-org/gitlab@6d2967126de6a90625ddc9a3bbce838945ec404d) ([merge request](gitlab-org/gitlab!139829))
- [Project/group overview: Migrate to use type scale heading](gitlab-org/gitlab@072c3384673fab4cfded074ef8ffbd1f8d7c5160) ([merge request](gitlab-org/gitlab!140055))
- [Issuables: Small visual changes to sidebar appearance](gitlab-org/gitlab@e035fbc960a18c1c48018caf19778dfe1f06bfbc) ([merge request](gitlab-org/gitlab!139812))
- [Skip ingesting the SBOM reports if any of the SBOM builds fail](gitlab-org/gitlab@f497600650840bc9a171b5d7b7ad34c463d4b1dc) ([merge request](gitlab-org/gitlab!136709)) **GitLab Enterprise Edition**
- [Move profile/password to user_settings](gitlab-org/gitlab@9f298396ea9e2aac3f97763aad67c68fefc82ec6) ([merge request](gitlab-org/gitlab!139628))
- [Improve logs of the Sidekiq reliable fetcher](gitlab-org/gitlab@f0fa007baa65e8da1f394fbafcafdebb99a5d48c) ([merge request](gitlab-org/gitlab!139932))
- [Change feature flag from dev to ops](gitlab-org/gitlab@78fcc940981980d6684ed0d51f422233b6b848a9) ([merge request](gitlab-org/gitlab!139745))
- [Update gitlab pages version](gitlab-org/gitlab@54397b36fca994368bdce006337dec2f5de85b18) ([merge request](gitlab-org/gitlab!140048))
- [Change the order of package tags when generate package metadata](gitlab-org/gitlab@052b3cbf12d7a3a279cd19823f59b841b9d84021) ([merge request](gitlab-org/gitlab!138197))
- [Makes creating ai_features token always possible](gitlab-org/gitlab@8c7a66d1d3b5a742a48d74507022a62774954657) ([merge request](gitlab-org/gitlab!139659))
- [Adding secuity details section to Project-level Secure Files docs](gitlab-org/gitlab@61cd9d8889c6da7d16d9a2bee998e27641e86456) ([merge request](gitlab-org/gitlab!139839))
- [Allow local network for custom email SMTP host for self-managed](gitlab-org/gitlab@1f33745220a88539531d2ec0fbb82bdb096e6340) ([merge request](gitlab-org/gitlab!139679))
- [Display temporary extension details in subscription card](gitlab-org/gitlab@23c47a6b893f2af3b7baffe559d912f1cead04ea) ([merge request](gitlab-org/gitlab!138116)) **GitLab Enterprise Edition**
- [Add free access end date to code suggestions alert](gitlab-org/gitlab@f3080536685a88f9193132514c02a8e9c3d881d3) ([merge request](gitlab-org/gitlab!139837)) **GitLab Enterprise Edition**
- [Improve Security Training Description](gitlab-org/gitlab@2bcd895072d4408665162acb4f2ebad4ebd08c5c) ([merge request](gitlab-org/gitlab!139778)) **GitLab Enterprise Edition**
- [Simplify the MR header with unicode characters and secondary button](gitlab-org/gitlab@d24c09bedd2c0a4e1bcfcc2afcb9b22521d23c6b) ([merge request](gitlab-org/gitlab!138822))
- [Refactored TimelogResolver splitting it up into a resolver and a finder](gitlab-org/gitlab@4fb2bcc44c3833c55cf6004c91ea6ab20be9f13f) by @zillemarco ([merge request](gitlab-org/gitlab!135034))
- [Backend changes for workspaces admin](gitlab-org/gitlab@4e85e7f28d138bcff767fa4160ad07c5cf4bae41) ([merge request](gitlab-org/gitlab!135413)) **GitLab Enterprise Edition**
- [Add filtering for the standards adherence report](gitlab-org/gitlab@5d4aac33b1c5956437e5109055844ed461e86782) ([merge request](gitlab-org/gitlab!131594)) **GitLab Enterprise Edition**
- [Add explicit name to have predictable path name](gitlab-org/gitlab@16d9ef628d8d25c5e4fd4df1ad2eaa5102b3ac53) ([merge request](gitlab-org/gitlab!139886)) **GitLab Enterprise Edition**
- [Migrate ssh keys alert to use pajamas](gitlab-org/gitlab@b1ac9584b68638132cd21d4b0d925f8d4c631481) by @missy-davies ([merge request](gitlab-org/gitlab!139495))
- [Add instance AWS S3 streaming destinations](gitlab-org/gitlab@20816515215640275428fce6fe415f6d97031b81) ([merge request](gitlab-org/gitlab!138245)) **GitLab Enterprise Edition**
- [Discussion lock: Add specs for FF](gitlab-org/gitlab@33ed5da8f82844f26fd8c40ae066cefe5a56b54b) ([merge request](gitlab-org/gitlab!138652))
- [Warn webhook token will be cleared when URL changes](gitlab-org/gitlab@dcdcd8226767fc4fcb3dbb6a3d7999a0707a0992) ([merge request](gitlab-org/gitlab!139865))
- [Add more patterns to gitleaks.toml](gitlab-org/gitlab@5355fbfd62c44cf1940a901a35b063bbeb0c876c) ([merge request](gitlab-org/gitlab!139602)) **GitLab Enterprise Edition**
- [Emoji group picker: Migrate button](gitlab-org/gitlab@7f931a9f09a489ede77838e06d4aa1aca04fbc32) ([merge request](gitlab-org/gitlab!139637))
- [Truncate a ci mr description if it is too long](gitlab-org/gitlab@db18a6dd9d993529886573b2d80a8ebcdadf5aca) ([merge request](gitlab-org/gitlab!139605))
- [Project overview sidebar: Use right sidebar variable](gitlab-org/gitlab@3587699d515d3f96ec4f50d67456ae4796bdba0f) ([merge request](gitlab-org/gitlab!139817))
- [Updates instructions for GitLab.com](gitlab-org/gitlab@62bf79d9716e184ef26775751eaad2a9976b12d6) ([merge request](gitlab-org/gitlab!139404))
- [Swap primary key on ci_pipeline_variables](gitlab-org/gitlab@4dee08d9b7271ee8b117de38937ada3bf1c106df) ([merge request](gitlab-org/gitlab!139528))
- [Redirect personal access tokens to user_settings](gitlab-org/gitlab@6019eda0c523a3e3ad50b65fcc2d15e2803b3645) ([merge request](gitlab-org/gitlab!139306))
- [Fixed cyclical dependency of custom project templates feature check](gitlab-org/gitlab@750cf1d0a4fc1b2268a89ccdf1e1c5625f212060) ([merge request](gitlab-org/gitlab!139783)) **GitLab Enterprise Edition**
- [Add migrations for source_package_name column](gitlab-org/gitlab@62abe8cb9102e7ec0c81d06444bd4bbf24c6cbcf) ([merge request](gitlab-org/gitlab!138927))
- [Update devops illustration](gitlab-org/gitlab@eabb4df640379dc4962a715ea0fa033e0bfb0896) ([merge request](gitlab-org/gitlab!139256))
- [Changed the documentation text from policy to statement](gitlab-org/gitlab@025e20b1f2646433441b124d785cb601a78e102b) ([merge request](gitlab-org/gitlab!139355))
- [Update text for CI Variables settings](gitlab-org/gitlab@87c5904a20b1eb2c1d81b22918d457d32c233e67) ([merge request](gitlab-org/gitlab!139751))
- [Update dependency auto-deploy-image to v2.71.0](gitlab-org/gitlab@8e6c0a556674f765136b6542ad10bec44ab8d3b3) ([merge request](gitlab-org/gitlab!139733))
- [Migrate doorkeeper alert to use pajamas](gitlab-org/gitlab@81b2d07db1c96c2ff69fb413663b29e3e34677ad) by @missy-davies ([merge request](gitlab-org/gitlab!139501))
- [Add severity sorting for sbom_occurrences](gitlab-org/gitlab@3ae195da5d22d5554e484022934d92120c2ea0c8) ([merge request](gitlab-org/gitlab!136481)) **GitLab Enterprise Edition**
- [Add way to disaable zoekt search via chatops](gitlab-org/gitlab@956902807ebd557562c5fecf860a18950f0b3edc) ([merge request](gitlab-org/gitlab!138232)) **GitLab Enterprise Edition**
- [Enable blob blame by default](gitlab-org/gitlab@ba488e1febe5ed52ab9ba88199ed6ee33b55be14) ([merge request](gitlab-org/gitlab!139080))
- [Enable graphql git blame feature flag](gitlab-org/gitlab@7ee8042879ce3a0a16e51d6f12ad54d35e936d65) ([merge request](gitlab-org/gitlab!139656))
- [Cleanup for converted ci_stages.pipeline_id conversion for self host](gitlab-org/gitlab@bbcdbfd08d9b66869ca23776eb09a38db3cfe268) ([merge request](gitlab-org/gitlab!139055))
- [Adds FE banner for importing projects](gitlab-org/gitlab@c5108b239584cc3731723ed381cdc3c8fe893e01) ([merge request](gitlab-org/gitlab!139253))
- [Redirect oauth applications to user_settings](gitlab-org/gitlab@df8210f9679b925c3b1249cd2bafab7be9d2995a) ([merge request](gitlab-org/gitlab!139251))
- [Updating contribution docs](gitlab-org/gitlab@1857b839c1f853c1d37453e04768c8ef0f07f6c3) by @davidwatts111 ([merge request](gitlab-org/gitlab!139633))
- [Updating docs](gitlab-org/gitlab@0edeffaf1e1488a67375502edd09019e5d6d3e5d) by @davidwatts111 ([merge request](gitlab-org/gitlab!139475))
- [Only use code-gecko for code completion](gitlab-org/gitlab@3c9b9383dbdbc950c340dabb68156db4b172b166) ([merge request](gitlab-org/gitlab!139591))
- [Emoji group picker: Migrate button](gitlab-org/gitlab@5379fdcc138777487dc8da2db3386aea1172f96b) ([merge request](gitlab-org/gitlab!134111))
- [Move git command assistant to vertex](gitlab-org/gitlab@cc1ad968878ca03272671ce2934a4b6f2d62e47c) ([merge request](gitlab-org/gitlab!139570)) **GitLab Enterprise Edition**
- [Only use claude-2.0 for code generation](gitlab-org/gitlab@3dec129650e2f67c875668a0c3abcb7fdf42c4d5) ([merge request](gitlab-org/gitlab!139456))
- [Emoji picker tab button migration](gitlab-org/gitlab@4726bed013812ebc6167150dd483565eea0e8082) ([merge request](gitlab-org/gitlab!134113))
- [Enable linked_work_items by default](gitlab-org/gitlab@b7a1f411951fb86e8930d3989c43c6517d276994) ([merge request](gitlab-org/gitlab!139394))
- [Remove approval rules when removing authorization](gitlab-org/gitlab@ac61fc2cfc1a61ce6579409b4ccd6714720b1bcf) ([merge request](gitlab-org/gitlab!138691)) **GitLab Enterprise Edition**
- [Exclude each_batch from Style/SymbolProc rubocop rule](gitlab-org/gitlab@c47254a6429197a253e8f7b3e2c6f94b117a2513) ([merge request](gitlab-org/gitlab!139081))
- [Updating UI text](gitlab-org/gitlab@a15d6585879d498b13ed1b7acc6a88470a2bd031) by @davidwatts111 ([merge request](gitlab-org/gitlab!139356))
- [Update dependency auto-deploy-image to v2.70.0](gitlab-org/gitlab@faa0a7f4c288bbd7a00df351cc6192fc8399566a) ([merge request](gitlab-org/gitlab!139454))
- [Validate ref early in deployments API](gitlab-org/gitlab@8e8ac0ba1256ad7b19683285aaccfda104f023f4) ([merge request](gitlab-org/gitlab!139461))
- [Display settings panel for Dedicated](gitlab-org/gitlab@dae5b62c22df98e434caa1d325e30f405ca2cc0c) ([merge request](gitlab-org/gitlab!139312)) **GitLab Enterprise Edition**
- [Unexpose `url_variables` from GET project_hooks](gitlab-org/gitlab@bbe0f5e0bd8a08d21eb4e964baf50df9a1a41f85) ([merge request](gitlab-org/gitlab!139142))
- [Mark Duo Chat as 'Beta'](gitlab-org/gitlab@b48fd5b5181e8e39069ac3d4abe10dac6a19514d) ([merge request](gitlab-org/gitlab!138965)) **GitLab Enterprise Edition**
- [Removes database migrations up to 15-6-stable-ee](gitlab-org/gitlab@3c6c9864572fb487f318e4c665f0a89799c49127) ([merge request](gitlab-org/gitlab!137701))
- [Rename quick action /award to /react](gitlab-org/gitlab@27d7489b54839fa6e4370169ad8b95338bfaca22) ([merge request](gitlab-org/gitlab!138892))
- [Add a prefix to deploy tokens](gitlab-org/gitlab@29d083e70af15dffe9192ac5a143b72ec7f9a6ff) ([merge request](gitlab-org/gitlab!138438))
- [Remove feature flag renaming_project_with_tags](gitlab-org/gitlab@3d2c71f39f2729c19f6ad69efb7b73e7dc5b5165) ([merge request](gitlab-org/gitlab!138385))
- [Add include_descendants to iteration list API](gitlab-org/gitlab@fafd94ff4634a3218f73bcf2b56db762f6758535) ([merge request](gitlab-org/gitlab!135764)) **GitLab Enterprise Edition**
- [Migrated signup omniauth buttons to pajamas](gitlab-org/gitlab@ae38c9cf99fb3bd82018ac802eec035c6c040a06) ([merge request](gitlab-org/gitlab!133432)) **GitLab Enterprise Edition**
- [Release MemberRoleCreateInput.permissions](gitlab-org/gitlab@ab1c835d9b8b07ff5a2f334baad7abfe21120966) ([merge request](gitlab-org/gitlab!139160)) **GitLab Enterprise Edition**
- [Delete feature flag create_project_subscription_graphql_endpoint](gitlab-org/gitlab@9286d8e42cfb7f71e9fc7d7677c26b90314c3ef5) ([merge request](gitlab-org/gitlab!139280))
- [Fix project starrers layout](gitlab-org/gitlab@3767eec793f7a945ea290e1f8cb68b2d84099a78) ([merge request](gitlab-org/gitlab!138233))
- [Enable vsa_predefined_date_ranges feature flag by default](gitlab-org/gitlab@bb97210d52997ce5c5021d42b80c4c7a41742475) ([merge request](gitlab-org/gitlab!139162))
- [Adds a new cop to flag the usage of pluck without a limit](gitlab-org/gitlab@5e4b8a9cdfc591fdaaa66d2df78e215a4a881d58) ([merge request](gitlab-org/gitlab!138702))
- [Refactor search dropdowns to collapsible-listbox](gitlab-org/gitlab@b4c63b3003594dbbb12afbf458729b5fa5bb0b24) ([merge request](gitlab-org/gitlab!134128))
- [Update sidekiq-cron to v1.12.0](gitlab-org/gitlab@bcc00ca7771a5de3632fe1101375a35d13c9467a) ([merge request](gitlab-org/gitlab!139267))
- [Adds additional step for Self-Managed instances](gitlab-org/gitlab@eff1aad32676726193c61765d89ad4fd1cd656ed) ([merge request](gitlab-org/gitlab!139262))
- [Export for standards adherence report backend](gitlab-org/gitlab@2c9f9957d1ebfd33c22fed18b3e4a8a80b788d65) ([merge request](gitlab-org/gitlab!138589)) **GitLab Enterprise Edition**
- [Code dropdown: Remove artifacts](gitlab-org/gitlab@147c1a5cc793595cedc411e6d038cc8cc7864861) ([merge request](gitlab-org/gitlab!138658))
- [Remove unused in product email code](gitlab-org/gitlab@a920501906dddb2502f4a0fc0a14b62ad40f0867) ([merge request](gitlab-org/gitlab!138221))
- [This MR extends file path selector](gitlab-org/gitlab@e7287a3f4e9b4dc8e67423671d4283a5230160fd) ([merge request](gitlab-org/gitlab!138242)) **GitLab Enterprise Edition**
- [This MR converts exception list to generic](gitlab-org/gitlab@12fb90192d43711c1f62f05e0a0882d119eb2ca8) ([merge request](gitlab-org/gitlab!138775)) **GitLab Enterprise Edition**
- [Updates name of ComponentType and InputType in GQL](gitlab-org/gitlab@ab48c913b717ba802ad9f22f9a0711bfe7b1ad71) ([merge request](gitlab-org/gitlab!139237))
- [Re-adds project presenter spec](gitlab-org/gitlab@a571341ed3a5d09d5f000ac3c5facd8e3b1c8b0c) ([merge request](gitlab-org/gitlab!138919))
- [Remove serialized bitbucket importer and feature flag](gitlab-org/gitlab@22cd80d70c23f0651777e777e048bad7d38a3a36) ([merge request](gitlab-org/gitlab!138942))
- [Raise artifacts bulk delete selection limit to 100](gitlab-org/gitlab@bd50c60271bdc80c3fb1fe41268f55f5f81268fd) ([merge request](gitlab-org/gitlab!136780))
- [Enable free text entry for Kubernetes namespace](gitlab-org/gitlab@4615891284d380368b116cf9e051891d12f76529) ([merge request](gitlab-org/gitlab!138568))
- [Add tooltips to compliance exports dropdown options](gitlab-org/gitlab@ad9d6d308dad15a35c4fffd3820b8635d0a7fc93) ([merge request](gitlab-org/gitlab!138878)) **GitLab Enterprise Edition**
- [Redirect active_sessions to /-/user_settings/active_sessions](gitlab-org/gitlab@4db8ac8e3b0cc7b02d5e530a8ac2f91e047c1f2c) ([merge request](gitlab-org/gitlab!138761))
- [Added tasks back to issues API](gitlab-org/gitlab@ac9c5cc3f050d6527c3d9f5e57082ad5d820dc43) ([merge request](gitlab-org/gitlab!126398))
- [Remove restrict_ci_job_token FF](gitlab-org/gitlab@86c3c1e72b343f0e14cb58966c29d2db102296a1) ([merge request](gitlab-org/gitlab!138520))
- [Merge `Application analytics` and `Analytics dashboards` menu items](gitlab-org/gitlab@e1e23241501eea11011523ab120a30403908cac1) ([merge request](gitlab-org/gitlab!138976)) **GitLab Enterprise Edition**
- [Improve autocomplete results in rich text editor](gitlab-org/gitlab@3617b242c79d080dc3757c2defb5574170566051) ([merge request](gitlab-org/gitlab!136437))
- [Update epic illustrations](gitlab-org/gitlab@0fbab2c60e31a0f3ddcd24d11a0fb76dd0db4b67) ([merge request](gitlab-org/gitlab!139077))
- [Introduce a FF cache_control_headers_for_openid_jwks](gitlab-org/gitlab@e70b3a0a8a85dd059aaa0db6b39a30daece6f63f) ([merge request](gitlab-org/gitlab!138405))
- [Refactor search bar from search by click](gitlab-org/gitlab@51adcecb6cdcadc25df649f44336975294cc0e5e) ([merge request](gitlab-org/gitlab!137452))
- [Rename "Contributor statistics" to "Contributor analytics"](gitlab-org/gitlab@152f55a151f203d8c1cb597561eb7553bcbc8fb3) ([merge request](gitlab-org/gitlab!138941))
- [Improve order of mention autocomplete in epics](gitlab-org/gitlab@4fa6ce067e18f55447479eaa27cc512bccabc9ff) ([merge request](gitlab-org/gitlab!139050))
- [Hide config digest for manifest list tags](gitlab-org/gitlab@3a603b9143459f321f8b29d7c286186c030e0f47) ([merge request](gitlab-org/gitlab!138005))
- [Code Suggestions GA alert for non owners](gitlab-org/gitlab@65649e07619ee9675d75967b1f1cf9338933bc67) ([merge request](gitlab-org/gitlab!138971)) **GitLab Enterprise Edition**
- [Issue cross-reference notes use issue type name](gitlab-org/gitlab@06abbe8563197f68327268cc3337ce6547972009) ([merge request](gitlab-org/gitlab!139017))
- [Updated logic for MLflow Run artifact_url](gitlab-org/gitlab@a6ccb240f331b482f91c83c15a2b24001c41539e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/138715))
- [Migrate VSD metric drill-down event tracking to Internal Events Tracking](gitlab-org/gitlab@689183c4dba193b99dd198d3a0046da1597b4ae3) ([merge request](gitlab-org/gitlab!138553)) **GitLab Enterprise Edition**
- [Limit updating `can_create_group` & `projects_limit` to Enterprise Users](gitlab-org/gitlab@b48f2d40e33d7a903466378d6b67509c84d8a407) ([merge request](gitlab-org/gitlab!138656)) **GitLab Enterprise Edition**
- [Update empty state illustrations](gitlab-org/gitlab@ab4efd7ba4f67bb4e5ad48d634a3c250d452f7d6) ([merge request](gitlab-org/gitlab!138820))
- [Handle reset for ultimate-trial-paid-customer plan](gitlab-org/gitlab@b69ef71c62f9474a3fc912d81f0503f72e1f290e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/137243)) **GitLab Enterprise Edition**
- [Update warning when disabling group shared runners](gitlab-org/gitlab@1a30c2df401b833069fdb3d29bb53691c2ca605f) ([merge request](gitlab-org/gitlab!138948))
- [Update Haml breadcrumbs to use GlBreadcrumbs styles](gitlab-org/gitlab@5f277bc69a925f9375df84949f02cc20e8fb01bb) ([merge request](gitlab-org/gitlab!134415))
- [Adjust scroll to collapsed file](gitlab-org/gitlab@59aec032070dca6348c884b3f62e08d661101954) ([merge request](gitlab-org/gitlab!138949))
- [Test case layout update](gitlab-org/gitlab@e13331735e2290bb270b35a32755fc4246a9efc6) ([merge request](gitlab-org/gitlab!137855)) **GitLab Enterprise Edition**
- [Hide product analytics checkbox unless root](gitlab-org/gitlab@294b4b1965649a289f28a0302c9ec6240cbc11e6) ([merge request](gitlab-org/gitlab!138486)) **GitLab Enterprise Edition**
- [Rename pages "multiple versions" to "multiple deployments"](gitlab-org/gitlab@2c23a5ae6c892a1424ac6b970b3196b695da9dd4) ([merge request](gitlab-org/gitlab!138624))
- [Remove flag that enables CVS GA](gitlab-org/gitlab@abb3896d03975cf4e04e8c1da52bd554f37a9993) ([merge request](gitlab-org/gitlab!138192)) **GitLab Enterprise Edition**
- [Refactor remote dev resolvers and finders](gitlab-org/gitlab@37ad5d559b5b2acfe514275ca96f3c9723920622) ([merge request](gitlab-org/gitlab!136653))
- [Add exponential backoff for bitbucket server client](gitlab-org/gitlab@fc8a21352ba9b0671b3ff23adee9f7067665e9c7) ([merge request](gitlab-org/gitlab!137974))
- [Update exports text in the compliance center](gitlab-org/gitlab@86b931bae312d5e227f7d1d058f801fc3f92f793) ([merge request](gitlab-org/gitlab!138846)) **GitLab Enterprise Edition**
- [Change param to `include_ancestors`](gitlab-org/gitlab@e42b6b1cb9060eac1731958091845e4353469165) ([merge request](gitlab-org/gitlab!138391))
- [Enable autocomplete/members by default](gitlab-org/gitlab@4e1018ccc5e750e59561edbe11e819417755e52f) ([merge request](gitlab-org/gitlab!138794))
- [Project storage: Hide if no permission](gitlab-org/gitlab@ea282302af370ab301a982234a2d7b2f0e7c1ae3) ([merge request](gitlab-org/gitlab!138495))
- [Cleanup "use_lock_for_update_repository_storage" feature flag](gitlab-org/gitlab@87d1a409b3aa1b8a91388994089f73f07b1f7c15) ([merge request](gitlab-org/gitlab!138346))
- [Disable use_sync_service_token_worker feature flag by default](gitlab-org/gitlab@5eb671a02f9e2a284a87a7aeddf204e936b793ee) ([merge request](gitlab-org/gitlab!138746))
- [Project/group name area updates](gitlab-org/gitlab@0993c722a7ae1a56ce1e9f81c025fd65f9c07349) ([merge request](gitlab-org/gitlab!136843))
- [Cleanup for converted ci_stages.pipeline_id conversion](gitlab-org/gitlab@aa8744356ded404e448a541cfee314f41b99e9b0) ([merge request](gitlab-org/gitlab!137379))
- [Improves performance of runners list with large number of jobs](gitlab-org/gitlab@584899942dee90f1a933744478cac7f95ed51167) ([merge request](gitlab-org/gitlab!137648))
- [Move compliance center export buttons](gitlab-org/gitlab@179d1f9056dda2af9afaea7504b1db1e15298a46) ([merge request](gitlab-org/gitlab!138383)) **GitLab Enterprise Edition**
- [Add permissions arg to Mutation.memberRoleCreate](gitlab-org/gitlab@79b9a0fe85349916ce0393e51011d7d15805f453) ([merge request](gitlab-org/gitlab!138412)) **GitLab Enterprise Edition**
- [Update error to show in correct place](gitlab-org/gitlab@f2d4f410be55242f0ebf02648d45c0499c9a4fc1) ([merge request](gitlab-org/gitlab!138273))
- [Refactor search dropdowns to collapsible-listbox](gitlab-org/gitlab@fcdedd2dca5f606925db51f991e9bf28efb84bd7) ([merge request](gitlab-org/gitlab!137505))
- [Update field title and allow tab to function as enter](gitlab-org/gitlab@111ba4aefcb3485a0cbf009674d1a04d59ead54d) ([merge request](gitlab-org/gitlab!138073))
- [Redirect audit_log to /-/user_settings/authentication_log](gitlab-org/gitlab@461f79c2b938b57ad280037a8e8f9a73f3fb061f) ([merge request](gitlab-org/gitlab!137893))
- [Namespace API expose GitlabSubscription.end_date](gitlab-org/gitlab@c7302994f2a6017987c7e1a4e27045f260a07846) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/137847)) **GitLab Enterprise Edition**
- [Audit CI variable changes](gitlab-org/gitlab@6ca89cad13b174d4cc294f9bd7886c2be13bce14) ([merge request](gitlab-org/gitlab!131882)) **GitLab Enterprise Edition**
- [Display a list of permission for a custom role](gitlab-org/gitlab@a661232b554b0e81061093902aa29b969827c263) ([merge request](gitlab-org/gitlab!136703))
- [Enables parsing nested sections in logs](gitlab-org/gitlab@3332f2a0fb5b5feeba64960bfd7d59ff89433dd4) ([merge request](gitlab-org/gitlab!136186))
- [Consistently use `mmm dd, yyyy` format for analytics dates](gitlab-org/gitlab@d0ee832cd84e87ad974f617a246f0289b98f3f92) ([merge request](gitlab-org/gitlab!137799))
- [Update badge in CI/CD Catalog Settings to Beta](gitlab-org/gitlab@45c5aa43335c58b733730d744420ef3638c0979a) ([merge request](gitlab-org/gitlab!138533))
- [Update dependency auto-build-image to v1.51.0](gitlab-org/gitlab@062c802fd14e6bb5c56ac066a2938e62351555c8) ([merge request](gitlab-org/gitlab!138549))
- [Update banners](gitlab-org/gitlab@881401f948b41c6a9e8c72bd099488e4581f8ea9) ([merge request](gitlab-org/gitlab!138067))
- [Add CI/CD for github to registration features](gitlab-org/gitlab@68d3030d119c58e3c7d3a8ca2b0d07d9ad053388) ([merge request](gitlab-org/gitlab!137646)) **GitLab Enterprise Edition**
- [Update breadcrumbs and titles for import](gitlab-org/gitlab@2302b93aa0f6a41d84797912c56d2cb9233bf899) ([merge request](gitlab-org/gitlab!138014))
- [Move notes.scss to page_bundles from page_specific_bundles](gitlab-org/gitlab@a19d50c4d7a7be8e15ae8b60035972f8adfc8aee) ([merge request](gitlab-org/gitlab!131241))
- [Allows seat usage export on self managed instances](gitlab-org/gitlab@b2698176f07477fe8ac8dc90aac507f5c3a193bf) ([merge request](gitlab-org/gitlab!138465)) **GitLab Enterprise Edition**
- [Default on feature flag](gitlab-org/gitlab@4048622b98377d725119d92598107fbedaebd3ea) ([merge request](gitlab-org/gitlab!138114))
- [This MR adds popover to compliance framework](gitlab-org/gitlab@0da7645bd3aa80c0f56206225b1840cb7a5cf3e8) ([merge request](gitlab-org/gitlab!137594)) **GitLab Enterprise Edition**
- [Remove bulk_import_async_references_pipeline feature flag](gitlab-org/gitlab@082cc5e076f9f5ed071d38652fd872e1b4e75236) ([merge request](gitlab-org/gitlab!138052))
- [Add description to release title](gitlab-org/gitlab@a4af975f044dacb335fe36eaf95e6f5c21ac84a9) ([merge request](gitlab-org/gitlab!137936))
- [Update gitlab-pages](gitlab-org/gitlab@f440c34169b6b1858729584359bdd5bdaca1e110) ([merge request](gitlab-org/gitlab!138366))
- [Add back private projects to Ci::Catalog::Listing](gitlab-org/gitlab@3d96981cf96075bd929ad66656eca189f7c1e50b) ([merge request](gitlab-org/gitlab!138195))
- [Remove old top-bar from old Web IDE](gitlab-org/gitlab@262a7309ef39ce2e7c47e395383bc2ae8d5457d1) ([merge request](gitlab-org/gitlab!138104))
- [Search for users when focus on input](gitlab-org/gitlab@4a2e10f3fca3cb92a12e47c773ad736fde281954) ([merge request](gitlab-org/gitlab!138325))
- [[Feature flag] Remove `group_vulnerabilities_optimized_query` FF](gitlab-org/gitlab@324761643fcf9ed1d72baee330cdba8db649fe2e) ([merge request](gitlab-org/gitlab!138308)) **GitLab Enterprise Edition**
- [Add group to approval rule create service](gitlab-org/gitlab@b474ab94f555dc7ff1d5211f959e0cc5a6ff3521) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/137268)) **GitLab Enterprise Edition**
- [Job scrolls to bottom when a line is highlighted](gitlab-org/gitlab@2040925437189f29dea16211f2528171722392d2) ([merge request](gitlab-org/gitlab!138301))
- [Project overview page reoganisation: add sidebar](gitlab-org/gitlab@be49ba174a120203916e2ca5526f1bdf3e9d880e) ([merge request](gitlab-org/gitlab!137025))
- [Use new getTopFrequentItems helper](gitlab-org/gitlab@7cfe6602d873383470fc5f1ee2ccf7ddf0a223df) ([merge request](gitlab-org/gitlab!137787)) **GitLab Enterprise Edition**
- [Add status to get container repository(ies) REST API response](gitlab-org/gitlab@e9917c709b9625a71fb1971025da3503fb21ce68) ([merge request](gitlab-org/gitlab!138202))
- [Hide the rebase button for ff train MRs](gitlab-org/gitlab@12d28cf8ec42497e8acbc59cb06ef6634e27a8c3) ([merge request](https://gitlab.com/foo/bar/-/merge_requests/136232)) **GitLab Enterprise Edition**
- [Hardcode email on registration if it is an invite](gitlab-org/gitlab@8bfe69da9e9343f666180b8a7687a5ed3d423d5f) ([merge request](gitlab-org/gitlab!137463))
- [Migrate GitHub import alert to use Pajamas](gitlab-org/gitlab@ca7d526cea01fe3f3febc7e39c684aa3023367b0) ([merge request](gitlab-org/gitlab!138022))
- [Update snippet page layout](gitlab-org/gitlab@5c75f117bfe7fc74fda907ecf9429b1b82662dad) ([merge request](gitlab-org/gitlab!137859))
- [Create wiki page form update](gitlab-org/gitlab@5efcd9a5ee61d014976263d91df86953772e52bf) ([merge request](gitlab-org/gitlab!137862))
- [Unify reply field](gitlab-org/gitlab@66b6b71ee788e45b390e70d576899f02aaf3a506) ([merge request](gitlab-org/gitlab!137969))
- [Hide VSD link when no access to the parent group](gitlab-org/gitlab@7c50bd677e1562449084d1aa76bf51f9d3aa2e6a) ([merge request](gitlab-org/gitlab!137792)) **GitLab Enterprise Edition**
- [Add forks breadcrumb](gitlab-org/gitlab@ba2f26487e25ffff39f1c9b2cc1f6b8d7ea7de7a) ([merge request](gitlab-org/gitlab!138109))
- [Update fork btn text](gitlab-org/gitlab@0de62eedcd84acac2b0e5ad9ea80f9f0e9bd864c) ([merge request](gitlab-org/gitlab!138107))
- [Support Microsoft SAML attribute names by default](gitlab-org/gitlab@19cebb6a78ba6dc89b8b24a0bf46f690fd1f2eb2) ([merge request](gitlab-org/gitlab!136734))
- [Enable CVS GA by default](gitlab-org/gitlab@13c131bf5714b1d9dee5e6cd3334722dcc729d68) ([merge request](gitlab-org/gitlab!135816)) **GitLab Enterprise Edition**
- [Redirect/proxy the request to the primary site if not verified](gitlab-org/gitlab@fce89a22868c7b086b0592e81febb6813f5b7cad) ([merge request](gitlab-org/gitlab!136790)) **GitLab Enterprise Edition**
- [When config digest is not present, return an empty string](gitlab-org/gitlab@9643ab1b4a52932ce472492bddf05e89d0168dfc) ([merge request](gitlab-org/gitlab!137709))
- [This MR refactors props for project dropdown](gitlab-org/gitlab@2c8836513f05dd503bd3d3038bbc078a5de10868) ([merge request](gitlab-org/gitlab!137717)) **GitLab Enterprise Edition**
- [Remove analytics visualization editor feature flag](gitlab-org/gitlab@6689ebc86afcc3d517c7b4a3b0eba3bc9e5f5eb3) ([merge request](gitlab-org/gitlab!137774)) **GitLab Enterprise Edition**
- [Wiki page: Update layout](gitlab-org/gitlab@efd84e854defeb3963f114408dd80a13697da40b) ([merge request](gitlab-org/gitlab!137877))
- [Search for approvers by email and username](gitlab-org/gitlab@bc4567ffb5ad704f9d9b859a8e9c1a3d56d7d3f2) ([merge request](gitlab-org/gitlab!137626))
- [Add notification about the container registry during rename](gitlab-org/gitlab@f60eaaeed84dbf9575a9dda7d397e004f368656e) ([merge request](gitlab-org/gitlab!137518))
- [Fix cross joins in epics_finder](gitlab-org/gitlab@d96554e93f531781ecb02ce59ebd72b1998f0bd8) ([merge request](gitlab-org/gitlab!137965)) **GitLab Enterprise Edition**
- [feat: Updated docs to reflect behaviour when RD is disabled](gitlab-org/gitlab@71506f2d82d2fa2ed379feb1d543ac98477f42c3) ([merge request](gitlab-org/gitlab!137560)) **GitLab Enterprise Edition**
- [Remove combined_analytics_dashboards_editor feature flag](gitlab-org/gitlab@4a0888445e55bd9d7530d0f8720df0e24edd412d) ([merge request](gitlab-org/gitlab!136204)) **GitLab Enterprise Edition**
- [Add NOT NULL constraint to track and series columns](gitlab-org/gitlab@a94fe7ef15cbf6666a4657b2fcd21f3ad925b260) ([merge request](gitlab-org/gitlab!137545))
- [Add merge pipelines to registration features](gitlab-org/gitlab@d7b56364a89be0aee83302b208dd3e9382027e72) ([merge request](gitlab-org/gitlab!136911)) **GitLab Enterprise Edition**
- [Enable absolute doc links for duo chat](gitlab-org/gitlab@188933e9b217a4975542115467d8c424c15ee4e0) ([merge request](gitlab-org/gitlab!137916)) **GitLab Enterprise Edition**
- [Fixing rubocop exceptions no. 5](gitlab-org/gitlab@7fd62cf29e07a5bb02132e44236cd08bf2def44a) ([merge request](gitlab-org/gitlab!137755))
- [Project: Merge clone and download options into Code](gitlab-org/gitlab@256248c3f32e0fc3e9b739c1322f3bbcc89cb6be) ([merge request](gitlab-org/gitlab!137256))
- [Respect user locale in setStatus modal](gitlab-org/gitlab@a516d41fd103a18c1c71420e448154a3306f1b49) ([merge request](gitlab-org/gitlab!137242))
- [Fix license category in license compliance widget](gitlab-org/gitlab@9ad9c0e63475662d10f1b00c405f1bda4f6b2b2f) ([merge request](gitlab-org/gitlab!136770)) **GitLab Enterprise Edition**
- [Remove security_orchestration_policy_configurations.bot_user_id](gitlab-org/gitlab@42955e39b0319e70ff49a531e1898e0b17067104) ([merge request](gitlab-org/gitlab!137857))
- [This MR adds sync between filters and url](gitlab-org/gitlab@7a1eb4f9f5be455fa8c2e454a940a7d8be5317f1) ([merge request](gitlab-org/gitlab!137431)) **GitLab Enterprise Edition**
- [Add a project actor to non_public_artifacts feature flag](gitlab-org/gitlab@16b79b657a55b10a3c2d24bf5ffdabbc18f8cb9d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/136488))
- [Remove the feature flag npm_metadata_cache](gitlab-org/gitlab@b41108734dc70b12e51b6891cbd7c5036e4f4355) ([merge request](gitlab-org/gitlab!137415))
- [Update sbom_occurrences.vulnerabilities](gitlab-org/gitlab@7bd1e41b3a918a7749d301c509c9846868bf474a) ([merge request](gitlab-org/gitlab!135746)) **GitLab Enterprise Edition**
- [Adjust ordering of CTAs on both trial-end and active-trial popover](gitlab-org/gitlab@0ba13c6f5334b9cea9750602145d9ce50bacfe31) ([merge request](gitlab-org/gitlab!137551)) **GitLab Enterprise Edition**
- [Drop unique constrain from index](gitlab-org/gitlab@a2563a401601d6657e7a80c759901ff9bbaed2d1) ([merge request](gitlab-org/gitlab!137801))
- [This MR adds default value for policy scope](gitlab-org/gitlab@232e6efa479fd32ec551a659a72df9dc156e4fba) ([merge request](gitlab-org/gitlab!137332)) **GitLab Enterprise Edition**
- [Removes unused custom email columns in service_desk_settings](gitlab-org/gitlab@3b4d201639d7d51f028778fdbe7e01f79192573d) ([merge request](gitlab-org/gitlab!137638))
- [feat: Disabled agents are not shown in the dropdown on the UI](gitlab-org/gitlab@51981833724ce7c304c46c72ccfd23f7ffd74068) ([merge request](gitlab-org/gitlab!137344)) **GitLab Enterprise Edition**
- [Fixing rubocop expections no. 6](gitlab-org/gitlab@a7a32da8a249ed19ff816b33705e4a88f0ff5d66) ([merge request](gitlab-org/gitlab!137762))
- [Update outdated golden tanuki logo](gitlab-org/gitlab@46aa19a296d53d645ceda16ee7afce5b5bbb9377) ([merge request](gitlab-org/gitlab!137663)) **GitLab Enterprise Edition**
- [Migrate work_item_iteration.vue dropdown to GlCollapsibleListbox](gitlab-org/gitlab@e54105a31eff217065698c489700c3d016f72d05) ([merge request](gitlab-org/gitlab!136871)) **GitLab Enterprise Edition**
- [Enable highlight_js_worker feature flag by default](gitlab-org/gitlab@d9c44bc3ef0e6f5811e3f10e4992981c862e0721) ([merge request](gitlab-org/gitlab!137722))
- [Significant refactor away from metadata for vulnerability mr's](gitlab-org/gitlab@a394264f7edf9a42f77026eb3cbdefdd259a81c0) ([merge request](gitlab-org/gitlab!136118)) **GitLab Enterprise Edition**
- [Add some missing bulk_import items](gitlab-org/gitlab@53b05d70ad1328c93e7783e7f3b22345142fddb2) ([merge request](gitlab-org/gitlab!137508))
- [Fetch and present the custom roles in invite modal](gitlab-org/gitlab@d9ce4102bb261e7c35e218b6db3783110be49abd) ([merge request](gitlab-org/gitlab!133101))
- [Add in-product prompt for CI adoption if jenkins detected](gitlab-org/gitlab@e9c9bd4fc7acc7fc345cef795efde36c6bf05478) ([merge request](gitlab-org/gitlab!137023))
- [Show only published catalog resources](gitlab-org/gitlab@9d6a366f9c433a287774bac4082ca86fcc8b280c) ([merge request](gitlab-org/gitlab!136581))
- [Refactor Security MR Widget State Badge](gitlab-org/gitlab@a1de606d00565ad6f171b928ea4783a74285a3a9) ([merge request](gitlab-org/gitlab!137411)) **GitLab Enterprise Edition**
- [Add commit_committer_name_check to project push rule API](gitlab-org/gitlab@b0ef265da108834d4717fc9122e4bd8de4c46ed1) by @sinkcup ([merge request](gitlab-org/gitlab!137343)) **GitLab Enterprise Edition**
- [Improve UI text for project badges](gitlab-org/gitlab@e0144a2c9f7a1d6ac9a613bb86c4295e664ec14b) ([merge request](gitlab-org/gitlab!137274))
- [Change invite last onboarding step to group or project page](gitlab-org/gitlab@526a30738eba7158ed39d86b88d6d0c6dd39e099) ([merge request](gitlab-org/gitlab!137317)) **GitLab Enterprise Edition**
- [Update rails Banner component](gitlab-org/gitlab@f1bc8cec16234f923c36dae421884e221292d747) ([merge request](gitlab-org/gitlab!137530))
- [Remove advanced_epic_search flag](gitlab-org/gitlab@861caccbf97c4f2cc48ea2be078b45f0ca7b8aeb) ([merge request](gitlab-org/gitlab!136462))
- [Require gitaly_address instead of path in storage settings](gitlab-org/gitlab@14c078d1ea8397a96c24e396b48d7cc360c42088) ([merge request](gitlab-org/gitlab!137467))
- [Add Multiversion support to Pages internal API](gitlab-org/gitlab@707c5375656573251d4cd9be20b37b25e2c64fc5) ([merge request](gitlab-org/gitlab!133261))
- [Feature flag legacy bulk import references pipeline](gitlab-org/gitlab@d22963b30fcbf73c68d5bcd3fab06ce89edfe4da) ([merge request](gitlab-org/gitlab!135806))
- [Add attribute to group push rule API](gitlab-org/gitlab@0b22bc34104f01f0ebc335afe7bb29bf050a45f3) by @sinkcup ([merge request](gitlab-org/gitlab!136812)) **GitLab Enterprise Edition**
- [Rate limit Bitbucket Cloud importer](gitlab-org/gitlab@d58aade8c44532734e4daa9be59d14d24e55814a) ([merge request](gitlab-org/gitlab!136842))
- [Refactor Workspace graphql fields and specs](gitlab-org/gitlab@d02ecac2e0a5e1c4cb65ad70d6bd160f5cd4dc38) ([merge request](gitlab-org/gitlab!135412))
- [Reverse the order of identity verification steps](gitlab-org/gitlab@efa620bb13efa2b9f877538f846b25cdfd1f61e6) ([merge request](gitlab-org/gitlab!137513)) **GitLab Enterprise Edition**
- [Markdown Editor: Make Preview header sticky](gitlab-org/gitlab@346255ebd88cccc05bd56b0c72009b3c9a41ceac) ([merge request](gitlab-org/gitlab!128469))
- [This MR creates reusable popover](gitlab-org/gitlab@91e6c954e1ebd6e7f7d41feedeb8448fc1d4dded) ([merge request](gitlab-org/gitlab!137201)) **GitLab Enterprise Edition**
- [Rename event type filter](gitlab-org/gitlab@999816a00ebc5a6f288ade8fcc755460bc5cada9) ([merge request](gitlab-org/gitlab!137481)) **GitLab Enterprise Edition**
- [Updates outdated status checks docs](gitlab-org/gitlab@66c300716146d1db05da7e07d36f9ba80693cbc8) ([merge request](gitlab-org/gitlab!137474))
- [Allow rename of projects with registry tags](gitlab-org/gitlab@418ad70a4f5ebd5c8c764b9487ce5588aeae9516) ([merge request](gitlab-org/gitlab!135422))
- [Limit line range in blame GraphQL resolver](gitlab-org/gitlab@b8db2c6ede98071c6cca7bc350e84a413cede8db) ([merge request](gitlab-org/gitlab!136583))
- [Move policy bot removal into worker](gitlab-org/gitlab@5f88c93bd8c30b62fa6e320be46acf6e6f99652c) ([merge request](gitlab-org/gitlab!137137)) **GitLab Enterprise Edition**
- [Remove the frecent_namespaces_suggestions feature flag](gitlab-org/gitlab@1bc183bd06650d73334f6be566b4c44ddb4a893c) ([merge request](gitlab-org/gitlab!137448))
- [Stop passing repository paths via shell rake to the shell install script](gitlab-org/gitlab@a986cd993db7dd257a1d18f6b77e05ec282e0de6) ([merge request](gitlab-org/gitlab!137455))
- [Update dependency prometheus-client-mmap to v1](gitlab-org/gitlab@42a5e2b234b9074538bd963508783b95d14a6a98) by @gitlab-dependency-update-bot ([merge request](gitlab-org/gitlab!137052))
- [Group: Project overview item adjustments](gitlab-org/gitlab@6519d24bc57b5565e842ae1207dfe048c2127f51) ([merge request](gitlab-org/gitlab!137266))
- [Update gitlab-shell to 14.30.1](gitlab-org/gitlab@0bbab9acbcf4e3b6738d67c60b7dfb1521a00f3f) ([merge request](gitlab-org/gitlab!136798))
- [Add error message to project_repository_storage_moves table](gitlab-org/gitlab@e8a519d20e83edca84b660dcb6dc383972f305f3) ([merge request](gitlab-org/gitlab!136643))
- [This MR adds error state to compliance dropdown](gitlab-org/gitlab@829c3beb711102ab30def6da43adce73436fc3c6) ([merge request](gitlab-org/gitlab!137338)) **GitLab Enterprise Edition**
- [Only disable code suggestions if all users groups have it disabled](gitlab-org/gitlab@11133e040ff8d52d09966fb062b68426c1043380) ([merge request](gitlab-org/gitlab!137016))
- [This MR adds yaml update](gitlab-org/gitlab@b07b566b9987e51628ec74fdbb4742f134f6cc8c) ([merge request](gitlab-org/gitlab!135948)) **GitLab Enterprise Edition**
- [Removes database migrations up to 15-3-stable-ee](gitlab-org/gitlab@5d82bebceb3b9a3f9dd5723a4bcdf90087c25263) ([merge request](gitlab-org/gitlab!136253))
- [Validate compliance framework id in security policy](gitlab-org/gitlab@4356a72ce6342181dfb4652e6a6b41116bf9a69b) ([merge request](gitlab-org/gitlab!136927)) **GitLab Enterprise Edition**
- [Mention Container Registry and Dependency Proxy in api scope](gitlab-org/gitlab@dd99e19d6a975235ce7935c8d2fc231dbfd98534) ([merge request](gitlab-org/gitlab!136305))
- [Clarify Last Activity as Last GitLab Activity on Usage Quotas page](gitlab-org/gitlab@fad9ba26f560c5bda9f1dfee9bfd401ee35fb3bf) ([merge request](gitlab-org/gitlab!136919)) **GitLab Enterprise Edition**
- [Add import_history_link to status page](gitlab-org/gitlab@ed3fcceea0861d120d8a4dad0012e15753be4d57) ([merge request](gitlab-org/gitlab!136882))
- [Update Graphql version fields and resolver to use Versions](gitlab-org/gitlab@3a8ae108976e3ad62da977588ed35f3352d4826f) ([merge request](gitlab-org/gitlab!136081))
- [feat: Allow enabled in remote development configuration to be false](gitlab-org/gitlab@a4c70ac0312b4828e59dcb9b43376546e0384523) ([merge request](gitlab-org/gitlab!137119)) **GitLab Enterprise Edition**
- [Skip delayed own user deletion when the user has been unblocked](gitlab-org/gitlab@0758c7d6b001294208c963c4e8b6f19266914f34) ([merge request](gitlab-org/gitlab!136817))
- [Ensure timestamp tooltips respect user locale](gitlab-org/gitlab@5692b5a501885abe5a9511037d572caf63631ae6) ([merge request](gitlab-org/gitlab!136577))
- [Move out read_job_artifacts ability references from build policy](gitlab-org/gitlab@c997aa8969bb68403d9692841fabc18182981ec5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/136490))
- [Update component InstancePath to use latest version](gitlab-org/gitlab@706df19c692c92a981a9c4b025e7bcde85b3248d) ([merge request](gitlab-org/gitlab!136083))
- [Pipeline Minigraph: Change tooltip alignment in job items](gitlab-org/gitlab@40d7162055050dcc175f85d10873d126b2ba601c) ([merge request](gitlab-org/gitlab!137126))
- [Add feature flag related issues to registration features](gitlab-org/gitlab@d9dc3492d85818a41e1f141ead2e1efb39229623) ([merge request](gitlab-org/gitlab!135349)) **GitLab Enterprise Edition**
- [Allow larger page size for contributions query](gitlab-org/gitlab@44b589b8e791b7ac824a9003aa8c762d728cde40) ([merge request](gitlab-org/gitlab!136724)) **GitLab Enterprise Edition**
- [Remove reset_approvals_patch_id feature flag](gitlab-org/gitlab@d038edfaa340a348bee1826b5211fdea4ee34112) ([merge request](gitlab-org/gitlab!137079)) **GitLab Enterprise Edition**
- [Improve vulnerability report filter text](gitlab-org/gitlab@8e156e27c676434ae4c9412ad5f8dc3fa6475953) ([merge request](gitlab-org/gitlab!136778))
- [Make Puma low-level handler send to all available Sentry instances](gitlab-org/gitlab@f36789f9ea7312d5143019512362382b692a3cec) ([merge request](gitlab-org/gitlab!136503))
- [Fix(License): Match button text for adding license](gitlab-org/gitlab@1eaae2862da7bdbc27ef2d0835aa2047ded4a98d) ([merge request](gitlab-org/gitlab!137007)) **GitLab Enterprise Edition**
- [Blocking undefined audit event types](gitlab-org/gitlab@e646a6eb18665d6ad2e520cadd6261af51ebf056) ([merge request](gitlab-org/gitlab!136319)) **GitLab Enterprise Edition**
- [Cleanup for converted ci_pipelines.auto_canceled_by_id conversion](gitlab-org/gitlab@d1f234c8c54e837d10e3e69157083454aa06515f) ([merge request](gitlab-org/gitlab!135542))
- [Remove ignore rule for ci_pipeline_chat_data bigint conversion](gitlab-org/gitlab@00a55b185e08d3099488bca248e6a9d2066945f7) ([merge request](gitlab-org/gitlab!135454))
- [Add helpful validation messages to masked ci variables](gitlab-org/gitlab@4b28d6d1ea0838cd5e845ef999e30896b956d38b) by @JamesHow1ett ([merge request](gitlab-org/gitlab!135823))
- [Bitbucket Server importer create refs for fetched commits](gitlab-org/gitlab@40964a7224f5c8e78f2846d31d7fc864ad9370af) ([merge request](gitlab-org/gitlab!135554))
- [Update dependency auto-build-image to v1.50.0](gitlab-org/gitlab@bd19cb6a937ad4d3204a144a65ec679e16038c6a) ([merge request](gitlab-org/gitlab!136933))
- [Update permissions to relate issues](gitlab-org/gitlab@f468e7036412abf683a314928d2648137eacb4f0) ([merge request](gitlab-org/gitlab!135170)) **GitLab Enterprise Edition**
- [Remove extraneous bottom margin from invite modal button](gitlab-org/gitlab@190ed1133f305dead7b88f02f0f8c2c5d42ef90f) ([merge request](gitlab-org/gitlab!136474))
- [Add circuit breaker for zoekt nodes](gitlab-org/gitlab@4fdbf9b67d6f1e3c3db083159147bd9803a596c0) ([merge request](gitlab-org/gitlab!136346)) **GitLab Enterprise Edition**
- [Add cross project pipelines to registration features](gitlab-org/gitlab@3f1c20ecd21971760c83bbdd9637e8299434d393) ([merge request](gitlab-org/gitlab!136592)) **GitLab Enterprise Edition**
- [Cleanup for converted ci_pipeline_variables.pipeline_id](gitlab-org/gitlab@26de14b015a040e3e446710f82fa2304cc1e8674) ([merge request](gitlab-org/gitlab!134956))
- [Change "Nothing to merge" widget](gitlab-org/gitlab@e7ca66e4c3068a1bdf3b7afd8841fb49be3c094d) ([merge request](gitlab-org/gitlab!136335))
- [Add layout override for GlAlert & GlBroadcast in alert-wrapper](gitlab-org/gitlab@f81bd62d4ccd1ae01877031502b409dc6ab8634e) ([merge request](gitlab-org/gitlab!136844))
- [Uses total column for sorting when under no storage enforcement](gitlab-org/gitlab@baa40fa4c6ebd002b74ddf3be8da9a791991d1af) ([merge request](gitlab-org/gitlab!135836)) **GitLab Enterprise Edition**
- [Use group import_status for status page](gitlab-org/gitlab@552b38a53d0a94cc09ca3af3ef8ac60be456e90f) ([merge request](gitlab-org/gitlab!136489))
- [Update gitlab-pages to latest version](gitlab-org/gitlab@bdd2a16bc6c2365234d4f2bfcd25c5db17d99a24) ([merge request](gitlab-org/gitlab!136504))
- [Add settings to allow merge without pipeline](gitlab-org/gitlab@6a5a0bcc2b36c0c94efa8a790cb709a35d41ce14) ([merge request](gitlab-org/gitlab!136084))
- [Activity feed: Update design](gitlab-org/gitlab@92dd08caf3186b494b8de3b568583f92ce26df81) ([merge request](gitlab-org/gitlab!136180))
- [Remove duplicated index from merge_requests](gitlab-org/gitlab@9df8747f42804ff567ac6d7823bee448a9c75190) ([merge request](gitlab-org/gitlab!136591))
- [Remove ignore column rules for shared_runners_duration](gitlab-org/gitlab@941cce625fe39e99a753f4e15e582e4eb534c742) ([merge request](gitlab-org/gitlab!136809))
- [Remove ignore rules for Ci::Sources::Pipeline](gitlab-org/gitlab@2b198ad94239353c941e481ff0937e7c76e9f758) ([merge request](gitlab-org/gitlab!136808))
- [Migrate component from GlButton to GlCollapsibleListbox](gitlab-org/gitlab@7ff11f069208137e68e7ba07d25935f3e43dd240) ([merge request](gitlab-org/gitlab!136391)) **GitLab Enterprise Edition**
- [Update dependency auto-deploy-image to v2.63.0](gitlab-org/gitlab@f9e2bbc42309d5ddff5f11f56cb8ad09487ea8cc) ([merge request](gitlab-org/gitlab!135978))
- [Fix [ ] in plain text editor incorrectly expanded to * [ ] in RTE](gitlab-org/gitlab@af57830f3c06fccb7ac1f1bb070e05771d0ff59d) by @manav014 ([merge request](gitlab-org/gitlab!136627))
- [Remove the tool filter with scanner feature flag](gitlab-org/gitlab@0d38368eabf7d37f928a184236a412075f67756b) ([merge request](gitlab-org/gitlab!136256)) **GitLab Enterprise Edition**
- [Licensed VSA UI visibility enhancements](gitlab-org/gitlab@0714fc1108f788b7ab6500825b09a8e6f3e495d6) ([merge request](gitlab-org/gitlab!136207)) **GitLab Enterprise Edition**
- [Remove feature flag: use_repository_list_tags_on_graphql](gitlab-org/gitlab@cdfbc217efb8dd0d6683b5b5f34b2653676358f2) ([merge request](gitlab-org/gitlab!136676))
- [Hide CVS enable/disable functionality behind feature flag](gitlab-org/gitlab@6a58a97db035c28e2be8999a28a25c3968e202d7) ([merge request](gitlab-org/gitlab!135313))
- [Prevent users from copying labels from runner details](gitlab-org/gitlab@5e471ebff60c2659d0753d5f72285f84d153052c) ([merge request](gitlab-org/gitlab!136220))

### Deprecated (2 changes)

- [Deprecate gitlab:list_repos Rake task](gitlab-org/gitlab@8cecf163be3252024b7599f339ed26716ab883db) ([merge request](gitlab-org/gitlab!137592))
- [Deprecate temporary storage increase graphql fields](gitlab-org/gitlab@900e52773922b7c916888eda783534be0286f499) ([merge request](gitlab-org/gitlab!136202)) **GitLab Enterprise Edition**

### Removed (25 changes)

- [chore: Updating changelog](gitlab-org/gitlab@08ba806f4ecb9554d2baf7452bb2568a937f3097) ([merge request](gitlab-org/gitlab!138537))
- [Drop max_workspaces and max_workspaces_per_user fields](gitlab-org/gitlab@6702c18fd5791e1e82650092d5a76ffcf9d670a0) ([merge request](gitlab-org/gitlab!140040))
- [Remove deprecated & unused #snaphot_* methods](gitlab-org/gitlab@3ea4e94383e856b02f858d4bdde4bc8b203719e0) ([merge request](gitlab-org/gitlab!139725)) **GitLab Enterprise Edition**
- [Remove rootNamespace from GQL catalog ResourceType](gitlab-org/gitlab@de661388b3fbf27d313333afd866d8957a437efc) ([merge request](gitlab-org/gitlab!139700))
- [Remove the `unpublish` method and mutation](gitlab-org/gitlab@74d12f24915b6fd7e437e3c756871097b6f7ab5a) ([merge request](gitlab-org/gitlab!139664))
- [Remove WorkItemDeleteTask mutation from GraphQL API](gitlab-org/gitlab@89e47d14cddf33555e575fa18413702f74a821e2) ([merge request](gitlab-org/gitlab!139592))
- [Remove MVP implementation of CI config chat](gitlab-org/gitlab@8c24e145c14d64c62a5b4f6fe72726140457d9f1) ([merge request](gitlab-org/gitlab!138448)) **GitLab Enterprise Edition**
- [Remove legacy Geo sidekiq workers](gitlab-org/gitlab@ef58c10160d6b86baedc4666c597b71620090bcb) ([merge request](gitlab-org/gitlab!138377)) **GitLab Enterprise Edition**
- [Remove single_file_file_by_file feature flag](gitlab-org/gitlab@ade1cef0fdd9ad74ba2852c316af7fc1a26a947b) ([merge request](gitlab-org/gitlab!138963))
- [Drop unused index_projects_on_path_and_id for projects](gitlab-org/gitlab@75b66db8db7ac87349783dbc3acdeb8c7a07ccdc) ([merge request](gitlab-org/gitlab!138219))
- [Drop unused index_projects_on_created_at_and_id for projects](gitlab-org/gitlab@8e503f4a8cff9f00537183d226a02c292de2f052) ([merge request](gitlab-org/gitlab!138393))
- [Revert "Add generate_ci_finished_builds_sync_events FF"](gitlab-org/gitlab@c77a90984a8d7795b5260cc0d911d52246dec4e6) ([merge request](gitlab-org/gitlab!138194)) **GitLab Enterprise Edition**
- [Remove product analytics seeding and other files](gitlab-org/gitlab@71e9371c9c5a1271427791b3ad7fd067260595db) ([merge request](gitlab-org/gitlab!137656))
- [Remove orphaned namespace check](gitlab-org/gitlab@4c7003bc2b25a6ae7f47ed0c109a492ef87b166b) ([merge request](gitlab-org/gitlab!137359))
- [Remove the repository downloads and repository data conflict check](gitlab-org/gitlab@3f4111832eae8dfe2c3ef89e05df5836af47699b) ([merge request](gitlab-org/gitlab!137482))
- [Remove shimo integration](gitlab-org/gitlab@4f8781061cb277e4bf48237e0239d359965a701f) by @icbd ([merge request](gitlab-org/gitlab!136143))
- [Remove gitlab shell build_missing_projects rake task](gitlab-org/gitlab@41152a6bff7c4d01338ae68a7da98f03c4921bce) ([merge request](gitlab-org/gitlab!137366))
- [Create new Remove AiAccessTokenColumn migration](gitlab-org/gitlab@b83c6a950fabd70eb253039e870bfb7d84206b7a) ([merge request](gitlab-org/gitlab!137004))
- [Remove gitlab:cleanup:moved rake task](gitlab-org/gitlab@e5b799233abd5e8c628cd34e10134302bd36fe8e) ([merge request](gitlab-org/gitlab!137357))
- [Removes Jira DVCS Cloud from usage data](gitlab-org/gitlab@c17d56fbc9a1c51fb13a389fcdfb8b9b915d561c) ([merge request](gitlab-org/gitlab!136484))
- [Remove Geo deprecated events](gitlab-org/gitlab@e426f9abe4cf6ba9636fa5a28c2ab0821a82dbe5) ([merge request](gitlab-org/gitlab!136493)) **GitLab Enterprise Edition**
- [Removes fork_count from Ci::Catalog::ResourceType](gitlab-org/gitlab@9d0216dd17ef63ae75b08c2cf74c6a01c53eee9c) ([merge request](gitlab-org/gitlab!136712))
- [Remove CheckDeniedPoliciesService mergability check](gitlab-org/gitlab@73aa09105da8948f6a1b893d55db25d9f06dca36) ([merge request](gitlab-org/gitlab!136183)) **GitLab Enterprise Edition**
- [Remove ignore rule for jitsu_key](gitlab-org/gitlab@31d1c917444dc82ee34814516a6cc496f5a751d4) ([merge request](gitlab-org/gitlab!136827))
- [Revert "Support Microsoft SAML attribute names by default"](gitlab-org/gitlab@211d2963d13df49a3ca84c8780064c3bf1803a95) ([merge request](gitlab-org/gitlab!136727))

### Security (21 changes)

- [Prevent tag names starting with SHA-1 and SHA-256 values](gitlab-org/gitlab@5146cc013520a950b16bdf71e7849970dc0e3e07)
- [Pass encoded file paths to router](gitlab-org/gitlab@7722539297daa7f34655ba5a4b258c6d4b780466)
- [Smartcard auth: encrypt client cert in params](gitlab-org/gitlab@42fdb9aacd602a777ac11435584d7b312700c486)
- [Restrict passing variables on the pipeline schedule API](gitlab-org/gitlab@ea9a18973dcdbdde01107b345199d134130bfc19)
- [Validate access level of user while rotating token](gitlab-org/gitlab@a2cda4e8b5ec7404b70c37aa3243f9b2f66ef2b0)
- [Remove the ability to fork and create MR for auditors](gitlab-org/gitlab@10432c4573d16000b8e5d0009b1b42ec179e1de7)
- [Fix large time_spent value causing GraphQL error `Integer out of bounds`](gitlab-org/gitlab@4b306b9776606e8ce73f786acfa644fed55711f9)
- [Restrict Protected branch access via group to direct members](gitlab-org/gitlab@d81336f2ddf0d1a902b29035d1ee4acff1008554)
- [Revert "Check max role for user for group access to protected ref"](gitlab-org/gitlab@72bd7f03aa22d721b55c027583aa18d2ea5ddb16)
- [Use ruby 3.0 syntax in User#can?](gitlab-org/gitlab@4ae6bdf6443a4000c6fb0b9e9c07e2f4e39e0727)
- [Update mermaid version for DOS security fixes](gitlab-org/gitlab@e4fb3c88f3ffd99fabf39f140f1187bd7881c69f)
- [Treat security policy bots as external](gitlab-org/gitlab@1566f95a250a32aceac6a657dfcb2d4b20b5ef16)
- [Enforce ref protection on pipeline schedule updates](gitlab-org/gitlab@60fdc54fde9efa334663cc41545ef74a26df032f)
- [Filter out projects with disabled package registry in Composer finder](gitlab-org/gitlab@ea3dc0d67a439d640bec95fe956f8ec984749a2d)
- [Validate adding members with higher role](gitlab-org/gitlab@6249974e52671ec603fe7bbdb4f7730a61c9c2c6)
- [XSS and ReDoS in Markdown via Banzai pipeline of Jira](gitlab-org/gitlab@9b062706ac6203f0fa897a9baf5c8e9be1876c74)
- [Prevent guest users from being able to add emojis in confidential issues](gitlab-org/gitlab@add5f39a39d21a4c1603b76492272dbe03882a58)
- [Prevent branch names starting with SHA-1 and SHA-256 values](gitlab-org/gitlab@f0fcffdc7b04d61bbc52b7de3b915652366f829a)
- [Ensure access is checked when loading releases associated with tags](gitlab-org/gitlab@517e2fc01159b1acf451cb54e2ba4cc05bb6ae53)
- [Do not run ssl cert validation if key has errors](gitlab-org/gitlab@dd548f4dcde1dd759617a06db378683eea7019e9)
- [Check max role for user for group access to protected ref](gitlab-org/gitlab@88dce7e1e2e364e46b4596622dbbdfdb33fbbfa2)

### Performance (24 changes)

- [Utilizing a new Gitaly feautre to speed up conflict file lists](gitlab-org/gitlab@4398397dd98804e3baf750dd9f320552224fe5e2) ([merge request](gitlab-org/gitlab!136284))
- [Updating worker to use keyset pagination](gitlab-org/gitlab@5649e2b98a28563accedd7b584dfa68ce23dcff7) ([merge request](gitlab-org/gitlab!138696))
- [Improve DB performance in PolicyRuleScheduleNamespaceWorker](gitlab-org/gitlab@5aa0245a20390fe195fdf5eb8b02fce4c83cfd61) ([merge request](gitlab-org/gitlab!138763)) **GitLab Enterprise Edition**
- [Rollout cache control for autocomplete sources](gitlab-org/gitlab@596e8c95ad2d5c66c4ca7d19aa004704fa694972) ([merge request](gitlab-org/gitlab!139313))
- [Adding refresh_jid checkpoints for stuckImportWorker](gitlab-org/gitlab@85694fe7bd77be78d7f1c67eb72b5ebe186b6f9c) ([merge request](gitlab-org/gitlab!137697))
- [Use loop with delete_all instead of EachBatch](gitlab-org/gitlab@d203cba7c07c88a05ed2f03df6ee8c41bf2b1b4f) ([merge request](gitlab-org/gitlab!138800))
- [Refactor single quotes regex import](gitlab-org/gitlab@7ef26cc0dc6212963e9a421f7aac92d074beb76c) ([merge request](gitlab-org/gitlab!138780))
- [Drop unique index on ci_job_artifacts](gitlab-org/gitlab@79855fbc5e6b39c2ab86e228ecbc5c478145bc67) ([merge request](gitlab-org/gitlab!138745))
- [Improve DB performance for SyncScanResultPoliciesService](gitlab-org/gitlab@e32fcd11655a3d91c4306ce045528da9f88dd5d4) ([merge request](gitlab-org/gitlab!138741)) **GitLab Enterprise Edition**
- [Adding conditional (updated_at,id) index to bulk_import_entities](gitlab-org/gitlab@35221d56f8a1a076c55c200bed963467abe815e0) ([merge request](gitlab-org/gitlab!138387))
- [Adding indexes for bulk imports](gitlab-org/gitlab@132eda31b54f06e4b2cc4480c9182b2deda44b61) ([merge request](gitlab-org/gitlab!137816))
- [Drop index_users_on_accepted_term_id](gitlab-org/gitlab@dec2c77e27731bded8d66b0c64c69423494b3cde) ([merge request](gitlab-org/gitlab!135293))
- [Adding index on bulk_import_batch_trackers on (tracker_id, updated_at)](gitlab-org/gitlab@a5d8d5b341e320691838431b3ffa066187d5b4dd) ([merge request](gitlab-org/gitlab!137331))
- [Remove `bulk_import_export_batches` index](gitlab-org/gitlab@b29837bc7d6f1fe2775867049692b5ae2dc9e8e0) ([merge request](gitlab-org/gitlab!137662))
- [Remove `index_web_hook_logs_part_on_web_hook_id`](gitlab-org/gitlab@2ec3289388ed08d5ffe65fb0f24def41cbb853d0) ([merge request](gitlab-org/gitlab!137650))
- [Remove `project_relation_exports` index](gitlab-org/gitlab@872f2c3c3ee52d7ca5c197d277ac10c3461e41dd) ([merge request](gitlab-org/gitlab!137665))
- [Remove `bulk_import_batch_trackers` index](gitlab-org/gitlab@bb7a6cdf5c46a6fe94bfe489b6a00c76ba3824ce) ([merge request](gitlab-org/gitlab!137661))
- [Remove index on`jira_connect_subscriptions`](gitlab-org/gitlab@a5dab5baaad1766e43814f69ece8d3cb0d719ab1) ([merge request](gitlab-org/gitlab!137658))
- [Remove `index_web_hooks_on_project_id` index](gitlab-org/gitlab@8675568f7ba310847803d78b29b6617a50adcaca) ([merge request](gitlab-org/gitlab!137572))
- [Disable joins for approval rules group users](gitlab-org/gitlab@5b124c05ab41720bd03abc2e7dfff5c431c3e3d9) ([merge request](gitlab-org/gitlab!137235)) **GitLab Enterprise Edition**
- [Remove Ability based queries and use groups finder](gitlab-org/gitlab@282e27a2b32b36c62bad440abfc5ae8fcbd2eac3) ([merge request](gitlab-org/gitlab!135822)) **GitLab Enterprise Edition**
- [Add a temporary transitionable flag to speed up validations](gitlab-org/gitlab@69fbb9d3f90f5f40746e9ca50d7d6b7177f23a7a) ([merge request](gitlab-org/gitlab!136283))
- [Disable joins for ApprovalRuleLike.group_users](gitlab-org/gitlab@4b06c1dc0afb33c35231631f02c7e39a02bbafba) ([merge request](gitlab-org/gitlab!136588)) **GitLab Enterprise Edition**
- [Rewrite SQL query for ByApproversFinder](gitlab-org/gitlab@72fcd7fe1a18ca39ac20c2ebad39e332061127a3) ([merge request](gitlab-org/gitlab!136614))

### Other (116 changes)

- [No beta label for CS on SM in 16.7](gitlab-org/gitlab@6d36fbe62ff7e39c53a69849d7a82171c5f47aed) ([merge request](gitlab-org/gitlab!140072))
- [Add accessibility test for tags view](gitlab-org/gitlab@dd01bdd3fb22c95519353e4eb7bb92cd51f98280) ([merge request](gitlab-org/gitlab!135138))
- [chore: Fix typo for word response](gitlab-org/gitlab@5778cc379b02c23e21a397129cc7784754d2f183) by @gerardo-navarro ([merge request](gitlab-org/gitlab!139930))
- [Hide unnessary public methods in ProcessCommitWorker](gitlab-org/gitlab@32831cf7d8f4ff96534b05cc8c3a9c1aae1cad11) by @zzaakiirr ([merge request](gitlab-org/gitlab!139432))
- [Dropped cluster_id column from deployments table](gitlab-org/gitlab@d825a592d341a48fbb1a37006ce62d3b69b07ab3) by @TamsilAmani ([merge request](gitlab-org/gitlab!135428))
- [Add synchronous indexes for partitioned key on ci_stages](gitlab-org/gitlab@635bd360db66dc2ab5d87f63aa9339efd13684a4) ([merge request](gitlab-org/gitlab!139076))
- [Backfill default_branch_protection_defaults for namespace settings](gitlab-org/gitlab@a01271738cdec4980386051d585bf296a50a676f) ([merge request](gitlab-org/gitlab!136181))
- [Backfill vs_code_settings uuid with default value](gitlab-org/gitlab@6493e1b08e60ea126dc68b6468cd9eae219b40d9) ([merge request](gitlab-org/gitlab!138355))
- [refactor: Rename column container_path_pattern](gitlab-org/gitlab@8ea392bf2ca6d1bd7ab0d751aa33a6e78615ddc1) by @gerardo-navarro ([merge request](gitlab-org/gitlab!137945))
- [Bump gitlab-shell version to v14.32.0](gitlab-org/gitlab@7017636edf2f4bf734bd77e6ddb0d291f04b3e20) ([merge request](gitlab-org/gitlab!139621))
- [Finalize BackfillUuidConversionColumnInVulnerabilityOccurrences](gitlab-org/gitlab@74bbfd467a7497d0ba17d43591f9ebe38f99c3d7) ([merge request](gitlab-org/gitlab!139177))
- [Make Direct Transfer logging more consistent](gitlab-org/gitlab@9ade4ea34d4a403c800a7e601d4f6f8a95b6114c) ([merge request](gitlab-org/gitlab!138990))
- [Finalize migration BackfillMissingCiCdSettings](gitlab-org/gitlab@9c38a167a5ed2513dbebc6fa2760c64a12c9293f) by @project_52263761_bot_66de0d9c027ad0d6b413f50a3904241f ([merge request](gitlab-org/gitlab!139145))
- [Add avatar to organizations table](gitlab-org/gitlab@a01804907bec8cedec88e174b4f607473afa2d44) ([merge request](gitlab-org/gitlab!138706))
- [Add active colors to super sidebar interactive items](gitlab-org/gitlab@6802210bb0fb8fede406dc9a2f27f4bcca5b6b75) ([merge request](gitlab-org/gitlab!137738))
- [Remove logging for read_namespace ability usages](gitlab-org/gitlab@bd19dd46043190a32cee069a0c15cf2889a0f626) by @Taucher2003 ([merge request](gitlab-org/gitlab!139217))
- [Finalize BackfillProjectStatisticsStorag...PipelineArtifactsSizeJob](gitlab-org/gitlab@d707a06dc4c27da60659995d8e07b23f75a525b9) ([merge request](gitlab-org/gitlab!139147))
- [Add use_web_ide_extension_marketplace to user_pref](gitlab-org/gitlab@ae40c9c9e3e8152169c55f9561776a5d69a5b499) ([merge request](gitlab-org/gitlab!139000))
- [Add a column to store home organization of the user](gitlab-org/gitlab@28df8f03212c31b433b9958c1e82ef9483d8737c) ([merge request](gitlab-org/gitlab!137252))
- [test: Set feature category for test Ldap::OmniauthCallbacksController](gitlab-org/gitlab@a9dfd8e39080a5e288913b78f9d60a5604ab282d) by @gerardo-navarro ([merge request](gitlab-org/gitlab!139274))
- [Add redis-namespace gem for mailroom](gitlab-org/gitlab@237b4e2417d614e7a4e6dfcdc85b7cf3fa046807) ([merge request](gitlab-org/gitlab!139259))
- [Update pages without wildcard DNS docs](gitlab-org/gitlab@0d718abccccc8abd382c679304ca5a8a53f98a7a) ([merge request](gitlab-org/gitlab!139204))
- [Finalize migration RemoveInvalidDeployAccessLevelGroups](gitlab-org/gitlab@c0cb230de3c56369d16a54dcbbf416d778a220f0) ([merge request](gitlab-org/gitlab!139183))
- [Finalize migration PopulateVulnerabilityDismissalFields](gitlab-org/gitlab@f1e17bb29dbc8684c129da0872f15a7c19cf63f8) ([merge request](gitlab-org/gitlab!139182))
- [Finalize migration MarkDuplicateNpmPackagesForDestruction](gitlab-org/gitlab@7c5d8ee83942d82e39ff43b14ed835344a57eee7) ([merge request](gitlab-org/gitlab!139181))
- [Finalize migration FixAllowDescendantsOverrideDisabledSharedRunners](gitlab-org/gitlab@a21104cde8cf8b25a2b336fe5481cad7e0c8dd30) ([merge request](gitlab-org/gitlab!139180))
- [Finalize migration DeleteOrphanedTransferredProjectApprovalRules](gitlab-org/gitlab@209a5aa2676ccc2a67c1fa885005cb260c24b34b) ([merge request](gitlab-org/gitlab!139179))
- [Finalize migration CleanupPersonalAccessTokensWithNilExpiresAt](gitlab-org/gitlab@637cee025f4acad008d72c9fbdf553e9e4e0e5d0) ([merge request](gitlab-org/gitlab!139178))
- [Finalize migration BackfillRootStorageStatisticsForkStorageSizes](gitlab-org/gitlab@084d89bd5c08fe74a3bd1c73b2fe709c0747f29c) ([merge request](gitlab-org/gitlab!139149))
- [Finalize migration BackfillProjectWikiRepositories](gitlab-org/gitlab@74b0f8f6a48b9cb4eff0f0729ab8057e6548060a) ([merge request](gitlab-org/gitlab!139148))
- [Finalize migration BackfillMissingVulnerabilityDismissalDetails](gitlab-org/gitlab@0365003b1ca4bb04712e164e49ad4b39dc96d4d7) ([merge request](gitlab-org/gitlab!139146))
- [Backfill catalog_resources visibility_level column](gitlab-org/gitlab@e804173e942459d371ea8e5657c7a561566557d4) ([merge request](gitlab-org/gitlab!139165))
- [Docs: Support for namespace in path for pages](gitlab-org/gitlab@7a8eaf96e516fda8ca7e18d3d601d3c16453aa49) ([merge request](gitlab-org/gitlab!137289))
- [Adds custom email incorrect_forwarding_target error](gitlab-org/gitlab@8743bc323ef3f97c7a83e01beeb1d422ffdf34bf) ([merge request](gitlab-org/gitlab!138371))
- [Add async indexes with partitioned key on ci_stages](gitlab-org/gitlab@47d1c6b7e9b7281e33c68f22ca8e3c259071233b) ([merge request](gitlab-org/gitlab!138755))
- [Cleanup tech debt from registration features migration](gitlab-org/gitlab@43b3888f38b6b66adcf4f8c29b6e697c81a2619f) ([merge request](gitlab-org/gitlab!138953)) **GitLab Enterprise Edition**
- [Finalize migration BackfillDesignManagementRepositories](gitlab-org/gitlab@5b1730908d7fc05aed9e20245c7cb9af6bf28509) ([merge request](gitlab-org/gitlab!137998))
- [Finalize migration BackfillCodeSuggestionsNamespaceSettings](gitlab-org/gitlab@24a7e18899c431d3c1a7e9c2a186816b0f6d49f6) ([merge request](gitlab-org/gitlab!137997))
- [docs: Improve guideline for integrating omniauth provider auth0](gitlab-org/gitlab@8e86f1754fdc218fde5e3f7babaf32142edc7d05) by @gerardo-navarro ([merge request](gitlab-org/gitlab!138473))
- [Retry exceptions during BulkImports::FileDownloadService](gitlab-org/gitlab@27353c249e3179ecfd5f6ff8c41dcf508a03de4c) ([merge request](gitlab-org/gitlab!138494))
- [Add instrumentation for Redis connection pools](gitlab-org/gitlab@571d9c1bf69f09143aba19da750927fc2c7e2117) ([merge request](gitlab-org/gitlab!138340))
- [Remove skip_instructions_extraction FF](gitlab-org/gitlab@95305841c45a5b5faa6161220b2c18b559f821d3) ([merge request](gitlab-org/gitlab!138618)) **GitLab Enterprise Edition**
- [Migration to include partition_id on ci_pipeline_variables indexes](gitlab-org/gitlab@1097c560ea5494ea4eb02b79273d839413942fef) ([merge request](gitlab-org/gitlab!137777))
- [Format "URL" as uppercase in profile links](gitlab-org/gitlab@827b48e1eddeb0c13f6d5f5f1287d29f57cfe0e5) ([merge request](gitlab-org/gitlab!138762))
- [test: Fix typo in omniauth callback controller spec](gitlab-org/gitlab@cfe9266340d07cd9c03cedf45b4714bb8c97de2d) by @gerardo-navarro ([merge request](gitlab-org/gitlab!138759))
- [Upgrade sidekiq-cron gem to v1.10.1](gitlab-org/gitlab@a476c5f4a60f28bc60018af15d5b48e8a26c9d5e) ([merge request](gitlab-org/gitlab!138605))
- [Fix project icon and add tooltips to groups list](gitlab-org/gitlab@f3104a2af84d29d4e0c2cf12844d97ea846ab704) ([merge request](gitlab-org/gitlab!138679))
- [Map spider timeout to browserker setting](gitlab-org/gitlab@39ea9eddd64724287facfa59cf0fd7fe4825fe33) ([merge request](gitlab-org/gitlab!138510)) **GitLab Enterprise Edition**
- [Remove enterprise_users_automatic_claim feature flag](gitlab-org/gitlab@9684a5986bfea7f56dc8ab049665cbd8614cbb14) ([merge request](gitlab-org/gitlab!138332)) **GitLab Enterprise Edition**
- [Composite index on organization_id and id in projects table](gitlab-org/gitlab@6cf2bb1d691f0b81cb3efbc974c9ee6660299f2e) by @TamsilAmani ([merge request](gitlab-org/gitlab!137346))
- [Remove MultiStore in Gitlab::Redis::DbLoadBalancing](gitlab-org/gitlab@fb8df892d6d7fbc2246bef62739f23f42ca18806) ([merge request](gitlab-org/gitlab!137830))
- [Revert "Resolving cross joins on GroupUsersFinder"](gitlab-org/gitlab@6f104b160aa7e6913a6f99b16413a53be19fb647) ([merge request](gitlab-org/gitlab!138534))
- [Clean up prevent_visibility_restriction ff](gitlab-org/gitlab@d9cbb22c0dbf75e795866e5de792d247e7ef607e) ([merge request](gitlab-org/gitlab!138370))
- [Finalize migration BackfillDismissalReasonInVulnerabilityReads](gitlab-org/gitlab@d3464ef17178ecc16449bdab2bc972a27289bac1) ([merge request](gitlab-org/gitlab!137999))
- [Update github import known issues](gitlab-org/gitlab@9a3f12c7d03642b77ead83ced011e049dde0130d) ([merge request](gitlab-org/gitlab!138373))
- [Refactoring 'approvable?' method to include temporary flag](gitlab-org/gitlab@4e95c676640fc558e682357740db09c94f1de3ed) ([merge request](gitlab-org/gitlab!136377)) **GitLab Enterprise Edition**
- [Remove search_issue_label_aggregation FF](gitlab-org/gitlab@48ad0331d7adb0c93cb921f42254457b9278125a) ([merge request](gitlab-org/gitlab!138115))
- [Exposes finalize command to BBM admin UI](gitlab-org/gitlab@0176a0f10759cfc0defb3aa8250bde82eff880f5) ([merge request](gitlab-org/gitlab!136472))
- [Add ids to enable labels to screen readers](gitlab-org/gitlab@152a66b243c55389024157f7ccb8590a0e5c3a13) ([merge request](gitlab-org/gitlab!137682))
- [Restructure CI/CD Components doc](gitlab-org/gitlab@2621ee1350ff65ebb9a1be23ce9f511abd7f9cfe) ([merge request](gitlab-org/gitlab!137655))
- [Removes service_desk_custom_email feature flag](gitlab-org/gitlab@efe452dbf223feba46abd500bca65df07e5ae903) ([merge request](gitlab-org/gitlab!138080))
- [Change partition_id default value and add safety concern](gitlab-org/gitlab@f3cccfaf3a8b9ede039449e4d1bf80dd438c2ea9) ([merge request](gitlab-org/gitlab!137629)) **GitLab Enterprise Edition**
- [Add async indexes for partitioned PK on ci_pipeline_variables](gitlab-org/gitlab@ecfc3b7e3cfab3df149f1bf9336b50cc70ec346b) ([merge request](gitlab-org/gitlab!138040))
- [Remove code_*_split_by_language feature flags](gitlab-org/gitlab@50a3e65b0e36b142f11e97003f7e7a9194908394) ([merge request](gitlab-org/gitlab!138145)) **GitLab Enterprise Edition**
- [Bump Gitlab Shell version to v14.31.0](gitlab-org/gitlab@ff3b701c9e2659514b7c30409a4b8582c96d2f8a) ([merge request](gitlab-org/gitlab!138155))
- [Autocomplete Group Users to use distinct_each_batch](gitlab-org/gitlab@44b079990dbd362a862a0c8a18877c960be1cb8e) ([merge request](gitlab-org/gitlab!138077))
- [Drops unused projects indexes from Gitlab.com instance](gitlab-org/gitlab@fe25387a5600a14a560b94153cdb70060a4ba876) ([merge request](gitlab-org/gitlab!137884))
- [Finalize migration BackfillAdminModeScopeForPersonalAccessTokens](gitlab-org/gitlab@01b970bc1448819306d78344a30d57fc240fbb47) ([merge request](gitlab-org/gitlab!137989))
- [Fix external_redirect to not redirect to self](gitlab-org/gitlab@8c3a3ffc350634db3b61d15734fecc98a713455c) ([merge request](gitlab-org/gitlab!137934))
- [Db migrations for IDE OAuth](gitlab-org/gitlab@4a7d2b21b118ca038ef76b7a7ed85de5569a8267) ([merge request](gitlab-org/gitlab!137212))
- [Update tooltip content to show full path](gitlab-org/gitlab@965d7f2c178d389fa5024fb52340f6fa0589bbb2) ([merge request](gitlab-org/gitlab!137918))
- [Remove the feature_flag search_project_wikis_hide_archived_projects](gitlab-org/gitlab@adea0ce3fa96e8886c5df5c31f750d1a749e1461) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/137834))
- [Display the whole path to a new file](gitlab-org/gitlab@50005395eb9b630e1ad189bb15c0e4d48b0f755d) ([merge request](gitlab-org/gitlab!134001))
- [Mark RelationBatchExportWorker as memory bound](gitlab-org/gitlab@b8e11d267cdd4a00807984f98a9d8d8cfa51602e) ([merge request](gitlab-org/gitlab!137797))
- [Rename to Namespaces::AddOnPurchaseResolver](gitlab-org/gitlab@da51a68f22fd6b733ddbd92002127d11ec9002a0) ([merge request](gitlab-org/gitlab!137786)) **GitLab Enterprise Edition**
- [Remove FF kubernetes_agent_internal_api](gitlab-org/gitlab@9d4720641351fcb64b8f574c24996e8a8d496b71) ([merge request](gitlab-org/gitlab!137757))
- [Migrate Read more to Pajamas](gitlab-org/gitlab@b6adc620c8446c497ee38dbf37263d9db8d4ed53) ([merge request](gitlab-org/gitlab!137539))
- [Add a setting to allow/disallow creation of organizations](gitlab-org/gitlab@26ad8f4086c03283814bda50ff6e7043902cdbff) ([merge request](gitlab-org/gitlab!136944))
- [Bump Direct Transfer workers retries count from 3 to 7](gitlab-org/gitlab@7711ac75c80bf2b9a433a4298e57081db3ad60b5) ([merge request](gitlab-org/gitlab!137260))
- [Reduce TTL for duplicate job keys](gitlab-org/gitlab@0634986004d701eec8f902d68bfacf061cabf534) ([merge request](gitlab-org/gitlab!137607))
- [Drop unused index on users table](gitlab-org/gitlab@c8bf396a97a1ba067adc1f676041258c1320f00e) ([merge request](gitlab-org/gitlab!137601))
- [Refactor the AddOnPurchasePolicy](gitlab-org/gitlab@26ab824832423240f248a41e95eb1a0e18e56ffc) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/137532)) **GitLab Enterprise Edition**
- [Remove feature flag adherence_report_ui and compliance_adherence_report](gitlab-org/gitlab@c73683cff56c36c75c89ad8fa8f14d5da220f6b0) ([merge request](gitlab-org/gitlab!137398)) **GitLab Enterprise Edition**
- [Add foreign key for merge_request_diffs.project_id](gitlab-org/gitlab@63fb87c9a7afe2734d23cd3fd6eaeeb2ac9bbe2e) ([merge request](gitlab-org/gitlab!137495))
- [Add synchronous index_merge_request_diffs_on_project_id](gitlab-org/gitlab@a67f3103fcdb251a2930f4fe51a22c291fabc190) ([merge request](gitlab-org/gitlab!137495))
- [Improve compliance SyncService spec to include non existing record](gitlab-org/gitlab@942766118d21128a1b97b6afef110bf76cbe9049) ([merge request](gitlab-org/gitlab!137458)) **GitLab Enterprise Edition**
- [Prepare index for orgId and id on projects](gitlab-org/gitlab@1943be92f939b4052bce7c788bcf9acbe5f51bf3) by @TamsilAmani ([merge request](gitlab-org/gitlab!137437))
- [Define id trigger on p_ci_builds routing table - self-managed](gitlab-org/gitlab@46eefb55d26c129f40cb49d4c9af4abf9d98dfb2) ([merge request](gitlab-org/gitlab!136452))
- [Remove unused methods from helpers](gitlab-org/gitlab@accb1b89cd0c92885a8fb23efe1104f9966fb4f6) ([merge request](gitlab-org/gitlab!137412))
- [Remove custom_roles_ui-[xxx] feature flags](gitlab-org/gitlab@5abf3b392d176226c3cf37a9fc4b4a3263ec6e33) ([merge request](gitlab-org/gitlab!137404))
- [Drops unused index_projects_on_mirror_last_successful_update_at](gitlab-org/gitlab@0f8c4d51e4bb92dd773509f2c4b7f5f22e8cd3e3) ([merge request](gitlab-org/gitlab!137390))
- [Remove feature flag allow_streaming_audit_events_to_amazon_s3](gitlab-org/gitlab@b852a7cc18277599293b78b813a9b6de5f6095e3) ([merge request](gitlab-org/gitlab!137391)) **GitLab Enterprise Edition**
- [Remove not null constraint from the namespace](gitlab-org/gitlab@3004a73fce8f940e2fb45ef7c484d4a682ebbc47) ([merge request](gitlab-org/gitlab!137376))
- [Upgrade the Sidekiq gem to v7.0.9](gitlab-org/gitlab@bcec4cf61eee8b145d074a6147a681ad827b4cfe) ([merge request](gitlab-org/gitlab!135185)) **GitLab Enterprise Edition**
- [Remove namespace validation for member role](gitlab-org/gitlab@45db3f2180fbc687ba335bc1d65a2edd8136ab74) ([merge request](gitlab-org/gitlab!135633))
- [Add released_at to catalog_resource_versions](gitlab-org/gitlab@cb3ff79616943521ccd78937d2be39fd444abecf) ([merge request](gitlab-org/gitlab!136139))
- [Remove dual-namespace polling support in Sidekiq](gitlab-org/gitlab@825203aae87a5e794d65c8ddcdcf6ffcba20061a) ([merge request](gitlab-org/gitlab!136397))
- [Schedule backfill of merge_request_diffs.project_id](gitlab-org/gitlab@dd8c4a00acf223cb62eb21b5f06be1f31892f00f) ([merge request](gitlab-org/gitlab!136800))
- [Update Ci::Catalog::Resource search to use Postgres Full Text Search](gitlab-org/gitlab@a0da5ef2bf4f15399a76f0205157672503eb2ce9) ([merge request](gitlab-org/gitlab!136263))
- [Add GQL request tests for CI runner filter by version prefix](gitlab-org/gitlab@e2f79775b97c0cddf4c0fa902f2530e812b68183) by @zzaakiirr ([merge request](gitlab-org/gitlab!136636))
- [Add project_id column to merge_request_diffs and populate it on save](gitlab-org/gitlab@4912a8ada14d95ea840594cf9c72607f9c498042) ([merge request](gitlab-org/gitlab!136800))
- [Document `regex` and `type` input attributes](gitlab-org/gitlab@d7d6312e73b84b17c07dc4a467e1748d2da9f243) ([merge request](gitlab-org/gitlab!136201))
- [Cleanup `replicate_object_pool_on_move`](gitlab-org/gitlab@1f748c5b6eab5f709e15893c7ce4254217a7973b) ([merge request](gitlab-org/gitlab!136875))
- [Highlight only the discussion diffs that are in the response](gitlab-org/gitlab@039fa38e62bc5493de85810e4d53d839070437e7) ([merge request](gitlab.com/gitlab-org/gitlab/-/merge_requests/136993))
- [Remove `resolvable_issue_threads` feature flag](gitlab-org/gitlab@b16ebd563a0a3ce915e939b3898ac50664680766) ([merge request](gitlab-org/gitlab!136973))
- [Fix wrong name for feature flag `packages_protected_packages`](gitlab-org/gitlab@dc8044a8ccaeecd16b95f32d24daa3f05b870ee2) by @gerardo-navarro ([merge request](gitlab-org/gitlab!136877))
- [Remove configure_sentry_in_application_settings feature flag](gitlab-org/gitlab@1e84b6f0775486821f381886d5b5fc5eb23dd532) ([merge request](gitlab-org/gitlab!136188))
- [Prevent gitlab-http async to use DB and Gitaly](gitlab-org/gitlab@a47986f8c4e576a9af186604cb4a5e69fc805021) ([merge request](gitlab-org/gitlab!136294))
- [Adding diff_match_patch gem to vendor/gems to fix upgrade issues](gitlab-org/gitlab@26fdcbce7c57b6b147bd6387a681195e6e2d1e6a) ([merge request](gitlab-org/gitlab!135772))
- [Removes feature flag ipynbdiff_notes_tracker](gitlab-org/gitlab@3dad1b39c765d4557dbc7e594b98472110bf8be2) ([merge request](gitlab-org/gitlab!136836))
- [Enable  `k8s_watch_api` feature flag by default](gitlab-org/gitlab@8fe5baf0316a4f0ea3ffe9fbf2ebbb29eda3ee67) ([merge request](gitlab-org/gitlab!136831))
- [Finalize backfill of packages_tags.project_id](gitlab-org/gitlab@9ec21b147183192b2d432941ce0c491b74010e39) ([merge request](gitlab-org/gitlab!136792))
- [Drop unused index on namespaces table](gitlab-org/gitlab@7d465fa182352a1e9d4d0aadd54f7f1f0858c25d) ([merge request](gitlab-org/gitlab!136784))
- [Define id trigger on p_ci_builds routing table](gitlab-org/gitlab@d12ba91e057f384c3c42bbbcd1f82b34f0527cd1) ([merge request](gitlab-org/gitlab!136445))
- [Remove already enabled enforce_memory_watchdog feature flag](gitlab-org/gitlab@ca01074ab2cad72f59fcb4ee520626d213dd7017) ([merge request](gitlab-org/gitlab!136308))
- [Drop unused indexes on the users table](gitlab-org/gitlab@81c347bdb2c6889f8b008a73603aa9dbc7fb4816) ([merge request](gitlab-org/gitlab!136651))

### fixed EE: true (1 change)

- [Move export buttons next to each other](gitlab-org/gitlab@106bea7a6246cd153cf66d133936a09d46369ae3) ([merge request](gitlab-org/gitlab!137461))

## 16.6.10 (2024-09-20)

No changes.

## 16.6.9 (2024-07-23)

### Added (1 change)

- [Add Rake task to show token expiration info](https://gitlab.com/gitlab-org/gitlab/-/commit/3dc90cff5b65c02d77ad188d9e03cb6beebd7ea5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159089))

### Changed (1 change)

- [Do not enqueue PAT expiry enforcement migration](https://gitlab.com/gitlab-org/gitlab/-/commit/0bfdb5a3473850bad2db375f2e46e317829e9535) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153466))

### Other (1 change)

- [Clear instance value](https://gitlab.com/gitlab-org/gitlab/-/commit/c80c110f8e413fd6d076a8320acb0e838306da59) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160246))

## 16.6.8 (2024-06-25)

### Fixed (1 change)

- [Update an expired test certificate](gitlab-org/gitlab@5df73aee0ffd7904fce472b2dc65ffbf8b0c6794) ([merge request](gitlab-org/gitlab!156398))

### Changed (1 change)

- [Add a banner informing about token expiration](gitlab-org/gitlab@882e550f0353f8a4c46a9ef21829c91d474d50a6) ([merge request](gitlab-org/gitlab!155270))

## 16.6.7 (2024-02-07)

### Security (3 changes)

- [Fix CI component input Regexp](gitlab-org/security/gitlab@4aea3a2d7f371d57a00eef647f84dce2b6963dc6) ([merge request](gitlab-org/security/gitlab!3856))
- [Make scan result policies block renaming branches](gitlab-org/security/gitlab@6ea7b750df3a5c2505717555db0875be6b0b3cd0) ([merge request](gitlab-org/security/gitlab!3840))
- [Limit vulnerabilitiesCountByDay date range to 1 year](gitlab-org/security/gitlab@4896b80a35e3a31b2cf0df28a3545ba5caf9cc6f) ([merge request](gitlab-org/security/gitlab!3831))

## 16.6.6 (2024-01-24)

### Fixed (1 change)

- [Bring legacy verification behavior back for repositories](gitlab-org/security/gitlab@36bcdbdd83f726f9e4b89352d5c2c5d3d6a0aed8) **GitLab Enterprise Edition**

### Security (5 changes)

- [Devfile parser arbitrary file write](gitlab-org/security/gitlab@d99a6dd3b4db37b4de1e3064059d769233c71ebd) ([merge request](gitlab-org/security/gitlab!3801))
- [Use public email in tags atom feed](gitlab-org/security/gitlab@0c6e04dd2ad28ea1630e11903b74d74c177fc128) ([merge request](gitlab-org/security/gitlab!3804))
- [Fix improper username sanitization](gitlab-org/security/gitlab@13d91b4e6248be0f326d0e476e2291360be7a1eb) ([merge request](gitlab-org/security/gitlab!3786))
- [Escape user input before building regex for linker](gitlab-org/security/gitlab@fa1f908f65d7e2de0f5a5d99d4641e13bad92b10) ([merge request](gitlab-org/security/gitlab!3789))
- [Do not allow non-team member to set MR assignees/reviewers](gitlab-org/security/gitlab@632f6852c312f29984fb1eebb5fc7e9d1a6de1ae) ([merge request](gitlab-org/security/gitlab!3793))

## 16.6.5 (2024-01-13)

No changes.

## 16.6.4 (2024-01-10)

### Fixed (1 change)

- [Add missing ci_sources_pipelines indexes for self-host](gitlab-org/security/gitlab@3c1411f3e5843e0d52315237b8fcc7d33c7dff2e) ([merge request](gitlab-org/security/gitlab!3810))

### Security (5 changes)

- [Consider older commits when resetting codeowner approvals](gitlab-org/security/gitlab@950b435ea484bcff31bd549d11738ff54fe21ccf) ([merge request](gitlab-org/security/gitlab!3765))
- [Password reset followups](gitlab-org/security/gitlab@db6b903bac7435dc2484bb4b97715d05a81d45c6) ([merge request](gitlab-org/security/gitlab!3778))
- [Add verification layer for BaseSlash commands](gitlab-org/security/gitlab@0db0cb8673d406e0f464fd9f6b95e46c3b4f9695) ([merge request](gitlab-org/security/gitlab!3757))
- [Ensure workspaces are created under same root namespace as agent](gitlab-org/security/gitlab@9d9a33b8201ccd5734ec56b149841193f4611741) ([merge request](gitlab-org/security/gitlab!3760))
- [Sync security with canonical for 16.6 stable branch](gitlab-org/security/gitlab@e1ec9524344f469375e40145e78d3068462bed05) ([merge request](gitlab-org/security/gitlab!3782))

## 16.6.2 (2023-12-13)

### Fixed (1 change)

- [Fix adding confidential child tasks](gitlab-org/security/gitlab@1e67ddffca37e733aee2c3b118c2f9510fc094c0)

### Security (8 changes)

- [Prevent tag names starting with SHA-1 and SHA-256 values](gitlab-org/security/gitlab@d942166b879e8986d9deb45ab1732fa563e715c2) ([merge request](gitlab-org/security/gitlab!3746))
- [Pass encoded file paths to router](gitlab-org/security/gitlab@1e414bb90ec85c818955bb241934bd43137adb4d) ([merge request](gitlab-org/security/gitlab!3735))
- [Validate access level of user while rotating token](gitlab-org/security/gitlab@a8267a4facee6ba922897fa2a1f358636d24fb09) ([merge request](gitlab-org/security/gitlab!3750))
- [Fix large time_spent value causing GraphQL error `Integer out of bounds`](gitlab-org/security/gitlab@6a48b4b8d58daf75a1d1da192b69c790435427bc) ([merge request](gitlab-org/security/gitlab!3745))
- [Restrict Protected branch access via group to direct members](gitlab-org/security/gitlab@dde50268150c2ef4653c7024eb8357321042ec94) ([merge request](gitlab-org/security/gitlab!3726))
- [Remove the ability to fork and create MR for auditors](gitlab-org/security/gitlab@c1a532527ee764c32f9c0779fa787a31b6d481f4) ([merge request](gitlab-org/security/gitlab!3738))
- [Restrict passing variables on the pipeline schedule API](gitlab-org/security/gitlab@0f12c83c9be495e37a04594c678a500643deb410) ([merge request](gitlab-org/security/gitlab!3723))
- [Smartcard auth: encrypt client cert in params](gitlab-org/security/gitlab@180374e354da080d90c70500aef9e574cc371e9e) ([merge request](gitlab-org/security/gitlab!3729))

## 16.6.1 (2023-11-30)

### Fixed (3 changes)

- [Revert "Merge branch 'sc1-release-goredis' into 'master'"](gitlab-org/security/gitlab@9589d80224cae8723bea3180418061363deeddd9)
- [Truncate verification failure message to 255](gitlab-org/security/gitlab@d3c363a1e644525c386e670abca295181a9ae450) **GitLab Enterprise Edition**
- [Prefer custom sort order with search in users API](gitlab-org/security/gitlab@3c9b46eb086ebfa595083452f82ddd19db586e5b)

### Security (11 changes)

- [Validate adding members with higher role](gitlab-org/security/gitlab@e55b3d8e5f3cf86fa5b124b0c85d3c70e94056b0) ([merge request](gitlab-org/security/gitlab!3713))
- [Enforce ref protection on pipeline schedule updates](gitlab-org/security/gitlab@a4565e7ddc064035a622c0f645bdcf583f8d9945) ([merge request](gitlab-org/security/gitlab!3703))
- [Update mermaid version for DOS security fixes](gitlab-org/security/gitlab@baec50f7af8077e77cf3124ac695ecb12d2d0028) ([merge request](gitlab-org/security/gitlab!3707))
- [Prevent guest users from being able to add emojis in confidential issues](gitlab-org/security/gitlab@7700354a9e5bd11b8db8e6b116d6708c9ef15e72) ([merge request](gitlab-org/security/gitlab!3699))
- [Do not run ssl cert validation if key has errors](gitlab-org/security/gitlab@a585a7ad29319b9cdaa6086287251ac34b0cd2be) ([merge request](gitlab-org/security/gitlab!3702))
- [Ensure access is checked when loading releases associated with tags](gitlab-org/security/gitlab@68cb75d412db5e1fe97823f21cd848299cb1c969) ([merge request](gitlab-org/security/gitlab!3701))
- [XSS and ReDoS in Markdown via Banzai pipeline of Jira](gitlab-org/security/gitlab@4ab2701284c928a392b5390977e4daed30b1b39f) ([merge request](gitlab-org/security/gitlab!3697))
- [Prevent branch names starting with SHA-1 and SHA-256 values](gitlab-org/security/gitlab@cc65b6c8c94b1b647995fe5f2d6afd23cc621f12) ([merge request](gitlab-org/security/gitlab!3698))
- [Filter out projects with disabled package registry in Composer finder](gitlab-org/security/gitlab@576f1ee9a3b612a579f987471e59dcd4820f5bd4) ([merge request](gitlab-org/security/gitlab!3684))
- [Check max role for user for group access to protected ref](gitlab-org/security/gitlab@1e39ee42f24588675336da5b95a9863ee46b33c4) ([merge request](gitlab-org/security/gitlab!3700))
- [Treat security policy bots as external](gitlab-org/security/gitlab@487e39c72883c71f5a4149191c9580017b0babd2) ([merge request](gitlab-org/security/gitlab!3678))

## 16.6.0 (2023-11-15)

### Added (117 changes)

- [Add SAML Auth for Approvals](gitlab-org/gitlab@3fc89ba6d391b7264bc7d63d526c6fe5a397e4a7) ([merge request](gitlab-org/gitlab!130204)) **GitLab Enterprise Edition**
- [Add Archive Project custom permission](gitlab-org/gitlab@7e8e8b15ad899bf51ae83743aeaadece67bf7e9c) ([merge request](gitlab-org/gitlab!134998)) **GitLab Enterprise Edition**
- [Added MLFLow API to get latest model version](gitlab-org/gitlab@65756294681052f131d9910cd0fd2632125cc0c8) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/136117))
- [This MR adds compliance framework dropdown](gitlab-org/gitlab@97e2eea040a560d8e9ef2c4a3e31f5c6407d7f2b) ([merge request](gitlab-org/gitlab!135792)) **GitLab Enterprise Edition**
- [Add Cloud Connector ADR 001 to design doc](gitlab-org/gitlab@cc8ccf84959e84ba34bda91d0e23852c8fc37a02) ([merge request](gitlab-org/gitlab!135818))
- [Removed nil constraint from personal access token table](gitlab-org/gitlab@1e38e00acae1fbefba8a436f210d10299f53faf6) ([merge request](gitlab-org/gitlab!135472)) **GitLab Enterprise Edition**
- [Add a fullpath argument to the ciCatalogResource endpoint](gitlab-org/gitlab@313c94abb839189c2fc7c1c1098f60e8a9536b5d) ([merge request](gitlab-org/gitlab!135493))
- [Removes the saved_replies feature flag](gitlab-org/gitlab@04d3023c16ddcfd4c2a87d8454a95518a0b8fa11) ([merge request](gitlab-org/gitlab!123363))
- [Add column to namespace settings](gitlab-org/gitlab@b420b80b7da25fa654501d56481d77fc7fc1362d) ([merge request](gitlab-org/gitlab!136063))
- [Enable bulk_import_details_page by default](gitlab-org/gitlab@33018de66e3415161b97455344c7f4704597a4a1) ([merge request](gitlab-org/gitlab!136408))
- [Add CVSS Vector to CSV](gitlab-org/gitlab@ed6113a895258c16e7f2fc34f33758eea937b53d) ([merge request](gitlab-org/gitlab!135930)) **GitLab Enterprise Edition**
- [Added create api for namespace filters](gitlab-org/gitlab@0b3cd5909122945bffdfdb5ce3b0a4529d458b7a) ([merge request](gitlab-org/gitlab!136047)) **GitLab Enterprise Edition**
- [Save additional PyPi metadata info](gitlab-org/gitlab@c9443415d29358d07b8ddd94cf0615a8edb4ea9d) ([merge request](gitlab-org/gitlab!131327))
- [Save the timestamp of the last project authorization recalculation](gitlab-org/gitlab@12b3e949d38c7551ec8862376fd26f7e3b59b431) ([merge request](gitlab-org/gitlab!136157))
- [Audit auditor role changes](gitlab-org/gitlab@1cde5e88613d24758b6826699140e6e9b88dbea0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/136456)) **GitLab Enterprise Edition**
- [Implement Resolve This Vulnerability service classes](gitlab-org/gitlab@7f06b149173008fd6d7461e0205bcee33b8db426) ([merge request](gitlab-org/gitlab!135826)) **GitLab Enterprise Edition**
- [Add triggered badge to pipeline views](gitlab-org/gitlab@4584f6927206711e78e0bc6e8ec23b5328838d26) by @Taucher2003 ([merge request](gitlab-org/gitlab!135407))
- [Set default true for search_project_wikis_hide_archived_projects](gitlab-org/gitlab@8112d5a4be2b3c1972d3be90dc803a8cedcb6b46) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/136427)) **GitLab Enterprise Edition**
- [Add a user preference to show times in 12h or 24h format](gitlab-org/gitlab@4ca99a5a3297d31ec0f7ccd8e9d41de4c30ec9a8) by @n0rdlicht ([merge request](gitlab-org/gitlab!130789))
- [Helper to create bigint indexes for each integer column index](gitlab-org/gitlab@6e713e3dcce06381c4573526394a58f2569f8bce) ([merge request](gitlab-org/gitlab!135781))
- [Accept current_file for chat requests](gitlab-org/gitlab@ac6885494aa99093da524fef6c9c0ba095644956) ([merge request](gitlab-org/gitlab!135717)) **GitLab Enterprise Edition**
- [Added archived filter for wiki_blobs scope](gitlab-org/gitlab@313bd4ad5aafe44fb7e6d8f78901e77374e36467) ([merge request](gitlab-org/gitlab!129224)) **GitLab Enterprise Edition**
- [Allow expires_at param in token rotation API](gitlab-org/gitlab@825c98c505d9357998141d969f9cf0b3b7e696c6) ([merge request](gitlab-org/gitlab!136332))
- [Adds SMTP authentication method to custom email settings page](gitlab-org/gitlab@8e1434fa132dc28b61f538f1526f3a3060fd1f2d) ([merge request](gitlab-org/gitlab!135865))
- [Add support for wolfi purl type](gitlab-org/gitlab@fb4e3c6397a4e92b519ff254a142afa19e2561b4) ([merge request](gitlab-org/gitlab!133902)) **GitLab Enterprise Edition**
- [Adds notes to abuse reports backend](gitlab-org/gitlab@a0dac12297a1159c3153e477724676171014a8ef) ([merge request](gitlab-org/gitlab!134730))
- [Use SQL functions for primary key lookups](gitlab-org/gitlab@c1ed14dc86d4aa586895f230af7eb07963f85b47) ([merge request](gitlab-org/gitlab!135196))
- [Support source branch param on MR list page](gitlab-org/gitlab@71136869d61b7aa11476eda7c180cc6853d07b85) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/134555)) **GitLab Enterprise Edition**
- [Support artifacts upload from Maven/Gradle using basic-http auth](gitlab-org/gitlab@9eb04473113af8a6c1e9f341e2437a7390bddfab) ([merge request](gitlab-org/gitlab!135761))
- [Add pending members GraphQl endpoint](gitlab-org/gitlab@fa5050c6307d25141f648ece9774ee1d0151372d) by @missy-davies ([merge request](gitlab-org/gitlab!126069)) **GitLab Enterprise Edition**
- [Add ability to filter runners by version prefix](gitlab-org/gitlab@3aaf4fea35da93e05d4487a73996bd5ecbe56e9c) by @joe-snyder ([merge request](gitlab-org/gitlab!135025))
- [Introduce Packages::Npm::CleanupStaleMetadataCacheWorker](gitlab-org/gitlab@e34d8e4fd41e52ec6f799c94b66b0cf2bc6f0b3d) ([merge request](gitlab-org/gitlab!132012))
- [Support member role in invite endpoints without FF](gitlab-org/gitlab@d039c2a3c05d92f4687e11e0655a18be76e699cc) ([merge request](gitlab-org/gitlab!136245)) **GitLab Enterprise Edition**
- [Add source_package_name to sbom_components](gitlab-org/gitlab@1ac5245d55f5db91304cc0cf627f9f609360cb86) ([merge request](gitlab-org/gitlab!135108))
- [WIP implement Resolve This Vulnerability infrastructure](gitlab-org/gitlab@65644eda77b9e952cc2e44891a83d3d19a00cab4) ([merge request](gitlab-org/gitlab!133123)) **GitLab Enterprise Edition**
- [Add egress ip options in remote development agent configs](gitlab-org/gitlab@9f0a38d6c0727d29da2718eefa130aee4b94f01c) ([merge request](gitlab-org/gitlab!135497)) **GitLab Enterprise Edition**
- [Added namespace filter in external destination query api](gitlab-org/gitlab@01e4812f3668d3f2f989cb8b70a6eb967585fb3b) ([merge request](gitlab-org/gitlab!135562)) **GitLab Enterprise Edition**
- [Added MLFLow API to update registered models](gitlab-org/gitlab@d1efbed201c004832ddc1e304e351891ea4697ae) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/135738))
- [Allow to update value streams in GraphQL](gitlab-org/gitlab@7154b6797c03b8002fb13dcf7f940e3ef550d4fc) ([merge request](gitlab-org/gitlab!135154)) **GitLab Enterprise Edition**
- [Enable feature flag default true](gitlab-org/gitlab@c2ca371b28ab5608982326c24a5073951b9f0ed6) ([merge request](gitlab-org/gitlab!133852))
- [Show loading icon in vulnerability status badge](gitlab-org/gitlab@7160bb0ca6ed6a8e10e759d063c6ac915dafe7b3) ([merge request](gitlab-org/gitlab!135804)) **GitLab Enterprise Edition**
- [Default branch protection settings for application setting](gitlab-org/gitlab@d7d22d4ab753651422558b9e84fcd17d1ca5ac7f) ([merge request](gitlab-org/gitlab!136006))
- [This MR adds policy scope section](gitlab-org/gitlab@2a093233e423bb94f96f0a1cadf576ddec0e911d) ([merge request](gitlab-org/gitlab!135398)) **GitLab Enterprise Edition**
- [Audit pipeline delete action](gitlab-org/gitlab@556f836e08e66cc2281552ce642a7bcbaf82aca3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/135255)) **GitLab Enterprise Edition**
- [Remove FF zoekt_index_private_repositories](gitlab-org/gitlab@699403268e5425880184c5785637cc7260d9ea89) ([merge request](gitlab-org/gitlab!135975))
- [Add documentation of Parent widget for tasks and OKRs](gitlab-org/gitlab@bc123a7fa6764b5ee15e049c6e5d144b27f1ac7f) ([merge request](gitlab-org/gitlab!135697))
- [Handle arkose outage on sign-up](gitlab-org/gitlab@8d194e508601fd9ed1c98bfac055284abd06a665) ([merge request](gitlab-org/gitlab!133405)) **GitLab Enterprise Edition**
- [Filter by package version in REST and Graphql APIs](gitlab-org/gitlab@fc36bd6502efc2e59ba3154ca2cf0fbe2877470e) by @renehernandez ([merge request](gitlab-org/gitlab!135606))
- [Adds smtp_authentication to Service Desk Custom Email credentials](gitlab-org/gitlab@910e4e7f0d82d9530608bdd4b4a3939d69d8016b) ([merge request](gitlab-org/gitlab!135612))
- [Add table to link Security Policies to Compliance Frameworks](gitlab-org/gitlab@1da934efbf329d0caae512ce202f1b1dfa675d34) ([merge request](gitlab-org/gitlab!135291)) **GitLab Enterprise Edition**
- [Update backend for namespaces for emails_enabled](gitlab-org/gitlab@9754c864df327492fee4cffce29a447612a564f7) by @joe-snyder ([merge request](gitlab-org/gitlab!127899))
- [Add Watch API for Flux sync status](gitlab-org/gitlab@cc50f357ebb45782e5f5b3fc82a3a48b368c7f53) ([merge request](gitlab-org/gitlab!135864))
- [Create Group component for list selector](gitlab-org/gitlab@80e6585bf42ea5387cff8cdd5a15e9d493829a3f) ([merge request](gitlab-org/gitlab!135704))
- [Add `include_hidden`, `include_pending_delete` option to Project API](gitlab-org/gitlab@9a46f27d291d2556a65e9dfa001338876f0cabc3) ([merge request](gitlab-org/gitlab!135727)) **GitLab Enterprise Edition**
- [Create spam abuse events worker](gitlab-org/gitlab@1e633a75f1ea4f56754710062c78bdeef5fab0f1) ([merge request](gitlab-org/gitlab!134987))
- [Add cost factored storage sizes to graphql project statistics type](gitlab-org/gitlab@0143374254ac212cfea7ddc6faa316175653680f) ([merge request](gitlab-org/gitlab!135664)) **GitLab Enterprise Edition**
- [Expose single member role in GraphQL](gitlab-org/gitlab@9151cba5571aa1d55cf88abc6e15c8dba67b9492) ([merge request](gitlab-org/gitlab!135166))
- [Added settings for access token expiration service accounts](gitlab-org/gitlab@a9d0134ef0beee3306cb73f55b75c03beff945a9) ([merge request](gitlab-org/gitlab!135225)) **GitLab Enterprise Edition**
- [Adds `path` to catalog_resource_components](gitlab-org/gitlab@8e8bd894b9377361953bc064d3532ddc9400c2e8) ([merge request](gitlab-org/gitlab!135018))
- [Adding MLFlow API for creating registered models](gitlab-org/gitlab@f8778f66748f45892c41f63cc426c9135b4e5d22) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/134443))
- [Adding group and project filters for audit streaming](gitlab-org/gitlab@e357646ceb63348c7a83ca9c78d7e11555470ced) ([merge request](gitlab-org/gitlab!135080)) **GitLab Enterprise Edition**
- [Add Direct Transfer entity failures API](gitlab-org/gitlab@657cad97d1cebd08cd22d9242159eb788247ffe9) ([merge request](gitlab-org/gitlab!135030))
- [Set `default_enabled` to `true` for enterprise_users_automatic_claim FF](gitlab-org/gitlab@7a3d650461b4f90084de40fd0849fee0ee60f4ef) ([merge request](gitlab-org/gitlab!135570)) **GitLab Enterprise Edition**
- [Add user_permissions fields to PackageType and PackageDetailsType](gitlab-org/gitlab@4f8b49bf5b966d11f13e5fd70ba33b14526c1dad) ([merge request](gitlab-org/gitlab!135384))
- [Add built-in template for Astro Tailwind](gitlab-org/gitlab@7c2473ae729c41005f84670f63097e1d3ccb65fe) ([merge request](gitlab-org/gitlab!135582))
- [Add api to rename a pipeline](gitlab-org/gitlab@3727bb26344f92f625d9a1b7098af6e2fdbde3d7) by @Taucher2003 ([merge request](gitlab-org/gitlab!134574))
- [Create GraphQL mutation to create an Organization](gitlab-org/gitlab@3234056c1c0884af8f81659287a4ee0015b9772e) ([merge request](gitlab-org/gitlab!135176))
- [feat: Graphql mutation to create container registry protection rules](gitlab-org/gitlab@325dead6702699ff669ec92097631059189e5ded) by @gerardo-navarro ([merge request](gitlab-org/gitlab!133527))
- [Add audit events for releases created, updated or deleted via the UI](gitlab-org/gitlab@2ae620a790059fea88966fcdb0ca8aec9b38d1c2) ([merge request](gitlab-org/gitlab!135381)) **GitLab Enterprise Edition**
- [Display custom roles on the group members page](gitlab-org/gitlab@284035d343034e43784e44cf058b368a69b3e764) ([merge request](gitlab-org/gitlab!133417)) **GitLab Enterprise Edition**
- [Support parent widget on tasks](gitlab-org/gitlab@a731b5e10b79c3d2a1cc742c2c669f60699b0e7a) ([merge request](gitlab-org/gitlab!134654))
- [Adds notes to abuse reports backend](gitlab-org/gitlab@cb62a51302b6c50648217f9a9e3ae19e3ab10b33) ([merge request](gitlab-org/gitlab!134343))
- [Push work item FFs to groups](gitlab-org/gitlab@6d99b0711bc7112c5ac27ad5f7633ed9ea129150) ([merge request](gitlab-org/gitlab!135338))
- [Adding ability to view Trusted user in User admin panel](gitlab-org/gitlab@ee380a23d612d762aacd2273ccf0d5359c9c259b) ([merge request](gitlab-org/gitlab!132402))
- [Initialize bigint conversion for p_ci_builds](gitlab-org/gitlab@ef1c1d2d490b407c421af1030b21217cadcfa740) ([merge request](gitlab-org/gitlab!129332))
- [Cleanup use_embeddings_with_vertex FF](gitlab-org/gitlab@6d0323c9fbe6a35cdff134cd2f0979c8f667f0c1) ([merge request](gitlab-org/gitlab!135092)) **GitLab Enterprise Edition**
- [feat: Add graphql mutation to delete package protection rules](gitlab-org/gitlab@02696a1c615189a68d42937dbd93b0510e2c4847) by @gerardo-navarro ([merge request](gitlab-org/gitlab!127659))
- [Add enforce_ci_builds_pagination_limit feature flag](gitlab-org/gitlab@be86c3270d838da628b87cd0c2555be5a2f1c022) ([merge request](gitlab-org/gitlab!135162))
- [Add sha256 hash to NuGet symbols](gitlab-org/gitlab@848af658fd8a8d1ca7bc38e9d488f1a2c79d6360) ([merge request](gitlab-org/gitlab!134689))
- [Add ssh audit events](gitlab-org/gitlab@5928f694975aba386b85ed95976ad925427e794f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/134556)) **GitLab Enterprise Edition**
- [Added option to filter projects by full paths in GraphQL](gitlab-org/gitlab@65f5d0e6cdc8c6b4085eb7f802d9641b6323ca28) by @zillemarco ([merge request](gitlab-org/gitlab!133596))
- [Add name and description denormalized columns in catalog_resources table](gitlab-org/gitlab@0f1ffaa4e812300d7d0ee87465cac95349e993c0) ([merge request](gitlab-org/gitlab!134708))
- [Default the issue label aggregation FF to true](gitlab-org/gitlab@c0400a98fe3ce29cafc2937715c3d811227c0c44) ([merge request](gitlab-org/gitlab!134802))
- [Add graphQL create custom role mutation](gitlab-org/gitlab@0341dd9e86d92810f59aa74b4f1133757b1d2048) ([merge request](gitlab-org/gitlab!131362))
- [Allow to save Security Policy YAML with policy scope](gitlab-org/gitlab@5c324a026fe1058ae6f64a19a9ba8eaecd3a9aa1) ([merge request](gitlab-org/gitlab!134504)) **GitLab Enterprise Edition**
- [Add detailed_import_status to Project in GraphQL](gitlab-org/gitlab@a8a31aa4907f7d92d86169c8f2459175680c124e) by @Taucher2003 ([merge request](gitlab-org/gitlab!134830))
- [Add nuget allow_duplicates toggle to the group packages settings](gitlab-org/gitlab@888ddda749ff8ed5beeac185d87c34b13f3bbd54) ([merge request](gitlab-org/gitlab!134974))
- [Release feature and remove `suggested_reviewers_control` feature flag](gitlab-org/gitlab@abe62b839832ee803e3d66b0489f21dd09ebfa4a) ([merge request](gitlab-org/gitlab!134728)) **GitLab Enterprise Edition**
- [Cleanup nuget_duplicates_option feature flag](gitlab-org/gitlab@306a11b1acae0ec370dfa6f8143326916887f141) ([merge request](gitlab-org/gitlab!134366))
- [Add container scanning properties](gitlab-org/gitlab@f8ff22e48af1e2968f1b18fded6b56d7a84437ee) ([merge request](gitlab-org/gitlab!134427))
- [Add wiki front matter title](gitlab-org/gitlab@216d17a3f35714a61ccd90613ef468e62c3c9ca2) by @zhanglinjie ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/133521))
- [Adds support for `options` in inputs](gitlab-org/gitlab@de34343e436c18b9009130305ea8b1d054c56037) ([merge request](gitlab-org/gitlab!133122))
- [Implement support for inactive mergeability check](gitlab-org/gitlab@c1aff850a1eb658671c6ab2c4b3270f7668a80bf) ([merge request](gitlab-org/gitlab!134365))
- [Add metrices for CSV](gitlab-org/gitlab@1c0c7c0b780325eb69d0e727e5f64f7936aa2ca1) ([merge request](gitlab-org/gitlab!133589)) **GitLab Enterprise Edition**
- [GraphQL: Allow to destroy value streams](gitlab-org/gitlab@6ac4317469660827cbe92f0adc85ab2f630dfcfc) ([merge request](gitlab-org/gitlab!134451)) **GitLab Enterprise Edition**
- [Support member role assigment via invitation API](gitlab-org/gitlab@c7dc8bc67c8f5b1452ade916b30a8686d9ce330a) ([merge request](gitlab-org/gitlab!134100)) **GitLab Enterprise Edition**
- [Add push option to select target project for MR](gitlab-org/gitlab@93693ce77741640f4d842154a64196fb09e36d36) ([merge request](gitlab-org/gitlab!132475))
- [Cleanup the `create_embeddings_with_vertex_ai` FF](gitlab-org/gitlab@7c06b259e1e38f438170b45f5cab4bb386974d95) ([merge request](gitlab-org/gitlab!134540)) **GitLab Enterprise Edition**
- [Remove frontend code for issues archived ff](gitlab-org/gitlab@e73932b6df10f2ba1e95ca6dfb0699deb6df4573) ([merge request](gitlab-org/gitlab!134784))
- [Remove frontend code for code archived ff](gitlab-org/gitlab@9c62759843f09905cc1d8f0d03fa6341dfa02119) ([merge request](gitlab-org/gitlab!134776))
- [Adds ModelsController#destroy action](gitlab-org/gitlab@eaac428b91757c2744b7f8077b0641cfc96d95c4) ([merge request](gitlab-org/gitlab!134395))
- [GraphQL API for deleting audit event streaming amazon_s3_configurations](gitlab-org/gitlab@74152c2ffa3b39d7343fdaf9421e067046d3e7b6) ([merge request](gitlab-org/gitlab!133695)) **GitLab Enterprise Edition**
- [AuditEvent model for ClickHouse database](gitlab-org/gitlab@e0d9c293326408d005ca20465a91d3dac85f612f) ([merge request](gitlab-org/gitlab!132108))
- [Adds boilerplate for ModelVersionsController#show](gitlab-org/gitlab@b45d49cdb82b9f30ebb555c570c15f99af30ec46) ([merge request](gitlab-org/gitlab!134260))
- [Use Danger to notify about outdated rubocop todos](gitlab-org/gitlab@34e703d26dd2adfa4f5d6c5561fe6f5b47592a32) ([merge request](gitlab-org/gitlab!134297))
- [Allow to trust/untrust users in spam log UI](gitlab-org/gitlab@63898e32cdf056baa0ca84df4bce8dba1d3b2a0e) ([merge request](gitlab-org/gitlab!131812))
- [Add support for Mastodon as user social](gitlab-org/gitlab@af670b658b81f4061b2e8c439ac9bceef95bbbe1) ([merge request](gitlab-org/gitlab!132892))
- [Add search to Model registry](gitlab-org/gitlab@ad5f6c5b89f424c2f9f665326fb3488266da6d85) ([merge request](gitlab-org/gitlab!133844))
- [Add prefix for certain quick actions in RTE](gitlab-org/gitlab@ef5a59a536ad07f1cdee60b58793e3450749afb4) ([merge request](gitlab-org/gitlab!133699))
- [Notify admin when email signup is not enabled](gitlab-org/gitlab@8649da74469f5e9fa9165d3f45e09249865886be) ([merge request](gitlab-org/gitlab!133609)) **GitLab Enterprise Edition**
- [feat: Integrate package protection rules for npm packages](gitlab-org/gitlab@5a6d26aa808bf0e654edac9294fc11d11393f84e) by @gerardo-navarro ([merge request](gitlab-org/gitlab!124979))
- [Allow to create value streams in GraphQL](gitlab-org/gitlab@252b5c52178a458b450bbae1157a738e8b281110) ([merge request](gitlab-org/gitlab!133632)) **GitLab Enterprise Edition**
- [Enable runner dashboard](gitlab-org/gitlab@5794fc2c791eb02bfd3d0a467febcaa4ab6e0706) ([merge request](gitlab-org/gitlab!134553)) **GitLab Enterprise Edition**
- [Add an auto merge indicator when merge checks failed](gitlab-org/gitlab@826dfbede4b7434e0f8fe99ad98bb36041c30862) ([merge request](gitlab-org/gitlab!134374))
- [Clean up ci_variable_drawer feature flag](gitlab-org/gitlab@bbfd78264435cb04d40eaad65589b500f125d874) ([merge request](gitlab-org/gitlab!134350))
- [Expose group member roles through graphQL](gitlab-org/gitlab@c1fabbd9f14da64e53685266f6298ca578326b59) ([merge request](gitlab-org/gitlab!134174)) **GitLab Enterprise Edition**
- [Allow admin to create identity verification exemption](gitlab-org/gitlab@ece13f4f5e80e22bd0a73376eed8ecc19eeb29ac) ([merge request](gitlab-org/gitlab!133971)) **GitLab Enterprise Edition**

### Fixed (117 changes)

- [Do not use find_by inside a scope](gitlab-org/gitlab@0d08fc6181a984aff49c966bcdd7ac669955f539) ([merge request](gitlab-org/gitlab!136416)) **GitLab Enterprise Edition**
- [Set the height of the iframe containing credit card form to 480px](gitlab-org/gitlab@63b3142fb2b01d39384e6fe80f54ac2eaf32ee6c) ([merge request](gitlab-org/gitlab!136295)) **GitLab Enterprise Edition**
- [Restrict access level for PrAT with custom roles](gitlab-org/gitlab@8752a97929fe727f9927f531ddd735f2a0e426a0) ([merge request](gitlab-org/gitlab!136468))
- [Ensure after_run ops execute once only](gitlab-org/gitlab@7b5c8b0d5066e539a1a09cc21ac473a0c8be5cc3) ([merge request](gitlab-org/gitlab!135955))
- [Use cbl-mariner instead of cbl_mariner purl_type](gitlab-org/gitlab@cdb20026494e8caf40f8f389bc337e69ef461145) ([merge request](gitlab-org/gitlab!133903)) **GitLab Enterprise Edition**
- [Update button for Public Groups (Free Tier) in Usage Quotas page](gitlab-org/gitlab@63330a21f0aa5c3bfeafac26688919fe7c727c1d) ([merge request](gitlab-org/gitlab!135924)) **GitLab Enterprise Edition**
- [Fixed UX issue for selected unapplied labels](gitlab-org/gitlab@cf6cc9a4bf32002347481c8f04da8b3d9ad8de44) ([merge request](gitlab-org/gitlab!132359))
- [Add closedAt to issue graphql fragment](gitlab-org/gitlab@2155956b979a78b0cd6de01bbd70fe798091a49f) ([merge request](gitlab-org/gitlab!136122))
- [Reduce batch size of verification state backfill](gitlab-org/gitlab@a99c53155fd055d4e6bfcebc8be5985d59668299) ([merge request](gitlab-org/gitlab!136356)) **GitLab Enterprise Edition**
- [Fix duration for builds failed via Ci::Build#doom!](gitlab-org/gitlab@4148791567d01ae2674f2d032092dd31bb0a00ec) ([merge request](gitlab-org/gitlab!136458))
- [Fix create issue for new pipeline finding](gitlab-org/gitlab@c238eae7a099fd9ffd230a7739ffc17d7ab650c9) ([merge request](gitlab-org/gitlab!136107)) **GitLab Enterprise Edition**
- [Make snippet creation resilient to replication lag](gitlab-org/gitlab@51c0904a4d6f4de0a26dcec66332d727ccbe26d4) ([merge request](gitlab-org/gitlab!136422))
- [Fix SLO violation on llm_completion](gitlab-org/gitlab@bd3356d1311fab8397efd43f0f9f36076cd8a445) ([merge request](gitlab-org/gitlab!136404)) **GitLab Enterprise Edition**
- [Fix http status when failing to release catalog resource](gitlab-org/gitlab@a4371b3361c614cf10b138a1ecb6cbc48f3f93cb) ([merge request](gitlab-org/gitlab!136417))
- [Fix race condition in deleting scan result policy violation](gitlab-org/gitlab@f974e501946cf2c4f9b6c979bc718aaf4c54609f) ([merge request](gitlab-org/gitlab!135787)) **GitLab Enterprise Edition**
- [Increase Jira Net timeout when fetching issues](gitlab-org/gitlab@bf4122180a59a921c4edbcaead59d6cc1d40aec7) ([merge request](gitlab-org/gitlab!136361))
- [Fix user sometimes not being set for manual jobs](gitlab-org/gitlab@a86fd1ef9492cadd57591f141f31b2593f86156c) ([merge request](gitlab-org/gitlab!136177))
- [Use small dot style for Work Item activity](gitlab-org/gitlab@c03015b0fdd54e643803b693ed79d102f739c8df) ([merge request](gitlab-org/gitlab!135516))
- [Add scope checks when using Dependency Proxy with group access tokens](gitlab-org/gitlab@bf707e3d5f5938cba53563555382b173967601e7) ([merge request](gitlab-org/gitlab!129697))
- [Fix errors caused by expired sessions](gitlab-org/gitlab@5eab2a63761439a16b953dd5a9ed99dbbc672364) ([merge request](gitlab-org/gitlab!135591))
- [Refactor can_move_repository_storage concern to resolve race condition](gitlab-org/gitlab@45b07507f4c13e30f32a36ed17ea28cc60caeddb) ([merge request](gitlab-org/gitlab!136049))
- [Fix for tall right-aligned images in description](gitlab-org/gitlab@6b2bebe7abe7db535470e8a58a276f029a8e13b2) ([merge request](gitlab-org/gitlab!136148))
- [User profile: Fix achievements and actions](gitlab-org/gitlab@ff5ecb23282a3f17b21146038c5f371ad9433315) ([merge request](gitlab-org/gitlab!136296))
- [Recover long stopping environments in worker](gitlab-org/gitlab@6c9b10becd32043814e473e130a32678b6dbeedc) ([merge request](gitlab-org/gitlab!133601))
- [Fix wiki sidebar hierarchy indentation](gitlab-org/gitlab@37ecd2e163fba67b22faac9532bf5933b41de895) by @glauciellesa ([merge request](gitlab-org/gitlab!135642))
- [Fix ingestion logic for remediations](gitlab-org/gitlab@9ff26b4663335374e8307d738532226954490f26) ([merge request](gitlab-org/gitlab!135302)) **GitLab Enterprise Edition**
- [Fixed numpad enter not working on the global search](gitlab-org/gitlab@f283acae8d76b6b8f845fa7bbf116b9ecc3f8d93) ([merge request](gitlab-org/gitlab!136236))
- [Update oncall shift persistence to fix timezone edge cases](gitlab-org/gitlab@6e9857e10d33b205c375b1cf874e8f71fb1b96c3) ([merge request](gitlab-org/gitlab!136228)) **GitLab Enterprise Edition**
- [Hide repository size limit field on project settings without admin mode](gitlab-org/gitlab@c8ed65e3d2898dde1dfbec6766d725a4a1099772) ([merge request](gitlab-org/gitlab!135976)) **GitLab Enterprise Edition**
- [Fix overflow of project name in activity feed](gitlab-org/gitlab@342adfe868a752a0e482bcd18999613e2cc7cf6f) ([merge request](gitlab-org/gitlab!136184))
- [Hide review app button when review apps exist](gitlab-org/gitlab@945eb9a87da6ccc1e6718b18fb4f8424808d55ae) ([merge request](gitlab-org/gitlab!135960))
- [Fix group application settings access in admin mode](gitlab-org/gitlab@85232c006e1bb29340c3636d357691037a6f04ed) ([merge request](gitlab-org/gitlab!135429))
- [Add test for mediawiki markup](gitlab-org/gitlab@cb89f05ea8c1a0d2e25398a58986252d63727782) ([merge request](gitlab-org/gitlab!135933))
- [Create group wiki repo if absent when verifying on primary](gitlab-org/gitlab@55e6143cdaf7b823da72014b37b6ec719bf65661) ([merge request](gitlab-org/gitlab!135766)) **GitLab Enterprise Edition**
- [Fix assign security check permission checks](gitlab-org/gitlab@080914bd656e154d079b7c7aa1463942c7f4e81a) ([merge request](gitlab-org/gitlab!135977)) **GitLab Enterprise Edition**
- [Prioritize exact matching on username and e-mail for users search](gitlab-org/gitlab@9fa745db7851d3ade589790b6d1d8b8bc1ca59bd) ([merge request](gitlab-org/gitlab!136115))
- [Add note that branch names are case-sensitive](gitlab-org/gitlab@e7a5621d32988fc8593c2a634d6a738851c59bf1) ([merge request](gitlab-org/gitlab!135504)) **GitLab Enterprise Edition**
- [Fix alignment of related merge request widget](gitlab-org/gitlab@b6dc347cba98317ff709edc90c6f6ec9964dce78) ([merge request](gitlab-org/gitlab!135947))
- [Fix regexp for CI components paths](gitlab-org/gitlab@98b17e129c66d267de8f592b16a5d9e9614bb5ef) ([merge request](gitlab-org/gitlab!135953))
- [Fix save password form dialog on CI/CD Registration token](gitlab-org/gitlab@d2fb02848f113161cd60fa0c80346496424d8fbb) ([merge request](gitlab-org/gitlab!135583))
- [Fix broken issue rendering when initial ID is null](gitlab-org/gitlab@60ae2fae63df02b390280451e9869c2257302860) ([merge request](gitlab-org/gitlab!136022))
- [Prevent loading state from showing after undo](gitlab-org/gitlab@c6903b069b86feaec18ea190bb8c1d3ad853ed6a) ([merge request](gitlab-org/gitlab!127036))
- [Backport thread-safety fix for Sprockets v3.7.2](gitlab-org/gitlab@ec00d54730d6932ce94e3a058a8ac006d599040f) ([merge request](gitlab-org/gitlab!135784))
- [Fix alignment of CI icon on pipeline detail page](gitlab-org/gitlab@79accfe061a9eb69187eb787c0e5c9f2660737f7) ([merge request](gitlab-org/gitlab!135974))
- [Fix alignment of MR popover](gitlab-org/gitlab@72b664d2d1f15848dbb1b4bc90c086bc77d0b7c5) ([merge request](gitlab-org/gitlab!135940))
- [Unlock non-successful pipelines](gitlab-org/gitlab@2be102b0b15125537c9ed884bc8b83f3809d8434) ([merge request](gitlab-org/gitlab!134967))
- [Update error messaging when SCIM identity is false](gitlab-org/gitlab@b924b9ccc46d0bcc34abe42ca1f49f4143b39b90) ([merge request](gitlab-org/gitlab!131423)) **GitLab Enterprise Edition**
- [Prioritize exact user matches when searching in users API](gitlab-org/gitlab@1dd6cbad204d2a6a4b2d51c847bb640fd5d547f7) ([merge request](gitlab-org/gitlab!135917))
- [Fix epic date range selector not changing date ranges](gitlab-org/gitlab@901ede441be1147a6a78e129733ebe06298b7ec5) ([merge request](gitlab-org/gitlab!135889))
- [Switch to UrlValidator for Identifer URL validation](gitlab-org/gitlab@42cb8ba160dca8104213f298f88b7b75846e59d6) ([merge request](gitlab-org/gitlab!135876)) **GitLab Enterprise Edition**
- [Adds check for temporarily_unapproved approval state](gitlab-org/gitlab@671a93516a349688fa73e8213a8688f197310427) ([merge request](gitlab-org/gitlab!135749)) **GitLab Enterprise Edition**
- [REST: Fix deprecation milestones in documentation](gitlab-org/gitlab@624076e54d4dc36fc90472788db7991a884b7d32) ([merge request](gitlab-org/gitlab!135854))
- [Ignore builds already added to Ci::FinishedBuildChSyncEvent](gitlab-org/gitlab@aa78b5438d7760c30430a302733764a1a03a19fa) ([merge request](gitlab-org/gitlab!135843)) **GitLab Enterprise Edition**
- [Fix intermittent CI/CD analytics request error for 180 day windows](gitlab-org/gitlab@a3e057207ea5aa2312d056d8084a4097f5529100) ([merge request](gitlab-org/gitlab!135282))
- [Fix merge request file browser height clipped at the top of the page](gitlab-org/gitlab@1824a3edcbb576aa9e19042ea9f8dee0a58254de) ([merge request](gitlab-org/gitlab!135545))
- [Geo: Report number of sites on /admin](gitlab-org/gitlab@068e11630ea3fe91722f7f2db23b2bab1975245f) ([merge request](gitlab-org/gitlab!135417)) **GitLab Enterprise Edition**
- [Remove extra pipeline mini graph margin](gitlab-org/gitlab@e498fdad7ac39262eb4325e1f7c8be9b706ba116) ([merge request](gitlab-org/gitlab!135776))
- [Set default branch after importing repo from Bitbucket](gitlab-org/gitlab@5a58f837adc431463f14d2af55d5f9df05632fef) ([merge request](gitlab-org/gitlab!135221))
- [Fixes stale link to docs](gitlab-org/gitlab@b1f4bc315e7cd999d672122960c554ec9595b386) ([merge request](gitlab-org/gitlab!135404))
- [Restricting job token for public and internal projects](gitlab-org/gitlab@293ce3eed8423b9d4742bbe37d1c6e06037aa503) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/135263))
- [Fix extra divider in header_actions when no permissions](gitlab-org/gitlab@fbca882b626f50c9387b170b729119f95c5e3219) ([merge request](gitlab-org/gitlab!135798))
- [Super sidebar: Update avatar after upload](gitlab-org/gitlab@2ea031436b6891b8beaad891ae8f08069c66c97b) ([merge request](gitlab-org/gitlab!135721))
- [Activity: Increase contrast of sign in message](gitlab-org/gitlab@9c1cf023ba0b80e19e4a9a740ae77f5cbef659b6) ([merge request](gitlab-org/gitlab!135611))
- [Change Issue activity to match MRs](gitlab-org/gitlab@e2e93f0cc3f888adcb022dad28904642369d86f7) ([merge request](gitlab-org/gitlab!135306))
- [Set deploy key as actor for Git proxied requests (Geo)](gitlab-org/gitlab@4b402dd6a316920f2e7acbcdb3571c3ee9bdd190) ([merge request](gitlab-org/gitlab!134546)) **GitLab Enterprise Edition**
- [Return error message when locked issue state filter is used](gitlab-org/gitlab@f0d3fc4cda461c6190741fe76b715eab1c4452a5) ([merge request](gitlab-org/gitlab!135663))
- [Add scan_result_policies to Approval Rule graphql](gitlab-org/gitlab@74a8ae8da2e43014a3c04c73e00bdf6f0102926f) ([merge request](gitlab-org/gitlab!133087)) **GitLab Enterprise Edition**
- [Branches list: fix border in darkmode](gitlab-org/gitlab@a94db7c505b9e8f67b83045d924f26c97d14ad3e) ([merge request](gitlab-org/gitlab!135571))
- [Show all implemented custom permissions](gitlab-org/gitlab@7513999bb3f3db5646811fffb03f72178c9f1c1f) ([merge request](gitlab-org/gitlab!135512)) **GitLab Enterprise Edition**
- [Raise circular dependencies error when job has a self-dependency](gitlab-org/gitlab@132151c48ee6026f54240c1e8148686346043a1e) ([merge request](gitlab-org/gitlab!134673))
- [Security dashboard: fix latest vulnerability count](gitlab-org/gitlab@cf649f999fd268bcd8c2eeb0a9807dc5218de7f2) ([merge request](gitlab-org/gitlab!135569)) **GitLab Enterprise Edition**
- [Fix tests for GeoNodeStatus replicator stats](gitlab-org/gitlab@c531addaf50283833e1b7dfaecf4e958ad11da0f) ([merge request](gitlab-org/gitlab!135183)) **GitLab Enterprise Edition**
- [Fix Migration[2.2] initialization](gitlab-org/gitlab@52cd58e01218c982abfa57844c98bf0c2450b6a4) ([merge request](gitlab-org/gitlab!135436))
- [Fix `undefined` tooltip for `Toggle commit description` button](gitlab-org/gitlab@1564119554b2e5e628269daebdf6ea189c0f5f50) ([merge request](gitlab-org/gitlab!135463))
- [Fixed alignment of the assign yourself button on MR reviewers](gitlab-org/gitlab@a368b49a50b0c778a117aefa2cf6dac1f0df8097) by @zillemarco ([merge request](gitlab-org/gitlab!135123))
- [Adjust job log line padding and margin widths](gitlab-org/gitlab@b3c5a6707bfa70eec292ce6950b0b9097ecef5c3) ([merge request](gitlab-org/gitlab!135419))
- [Geo: Bring back legacy project Prometheus metrics](gitlab-org/gitlab@00aa6289635c1a717858524bbe9373143cd0f369) ([merge request](gitlab-org/gitlab!135315)) **GitLab Enterprise Edition**
- [Add api badge label](gitlab-org/gitlab@a3f242d7f434d93df6f449b2ae6697d1e244b415) ([merge request](gitlab-org/gitlab!135250))
- [Make emoji localstorage cache optional](gitlab-org/gitlab@272d053a1c4d3eff7fe841a26e41c5829492f11e) ([merge request](gitlab-org/gitlab!135380))
- [Ignore jobs without runners when tracking failed jobs](gitlab-org/gitlab@b2d70835b224de256a000578bd524638899d9703) ([merge request](gitlab-org/gitlab!135362)) **GitLab Enterprise Edition**
- [Fix bug with suggestions dropdown in rich text](gitlab-org/gitlab@65d5b3cf3e1f9d68d8207601eeda969984fd4ad0) ([merge request](gitlab-org/gitlab!135262))
- [Stop validating `default` CI input type in Entry](gitlab-org/gitlab@413478addf24b564893c6c7279030019b08b8eee) ([merge request](gitlab-org/gitlab!135337))
- [MR widget: Fix title alignment on mobile](gitlab-org/gitlab@a279e0870e64c1f3e36961806a2b3e39ae24f781) ([merge request](gitlab-org/gitlab!135087))
- [Add safe-guard for projects not in the group with AI enabled](gitlab-org/gitlab@5531f5d974a9461d91bc73a17b0bfecf1e0800ed) ([merge request](gitlab-org/gitlab!135155)) **GitLab Enterprise Edition**
- [PyPi group endpoint: exclude projects with disabled package registry](gitlab-org/gitlab@b7903c0dce9c5d6d6b3f58107cc1d33048b60dbc) ([merge request](gitlab-org/gitlab!135111))
- [Uses non-metadata severity](gitlab-org/gitlab@25e9e00e6eaeba650226b8eced949b99efd70343) ([merge request](gitlab-org/gitlab!134782)) **GitLab Enterprise Edition**
- [Improve skeleton for loading status description](gitlab-org/gitlab@9ae0108e63e39bd986e6dc08efa4992a815f2dca) ([merge request](gitlab-org/gitlab!135240)) **GitLab Enterprise Edition**
- [Fix issue with content editor under relative URL](gitlab-org/gitlab@1cf75ca14d07322512c29bfc64f59724a446c5ce) ([merge request](gitlab-org/gitlab!135203))
- [Reset environments list when opening CI variable drawer](gitlab-org/gitlab@cfaf5698d907c907756750aa980627b462539fc6) ([merge request](gitlab-org/gitlab!134358))
- [Add missing package manager `poetry`](gitlab-org/gitlab@93653b90b08f4839cec3993c956415966a9ca061) ([merge request](gitlab-org/gitlab!134799)) **GitLab Enterprise Edition**
- [Removing FF bulk_import_idempotent_worker](gitlab-org/gitlab@70d79570a9304109312c79c1b624f201ac30c968) ([merge request](gitlab-org/gitlab!135156))
- [Downgrade vue-apollo to prevent auto-restarting subscriptions on error](gitlab-org/gitlab@7de2ee182ea2c228f98e0d777802da45efc1ff75) ([merge request](gitlab-org/gitlab!135098))
- [fix: Query declaration error for graphql createPackageProtectionRule](gitlab-org/gitlab@a16ad708ceb743d4866d5990b5cedf28c56dea27) by @gerardo-navarro ([merge request](gitlab-org/gitlab!134244))
- [Include projects.scss on artifacts page](gitlab-org/gitlab@ecd145b92a0871a9de6fe8602a9ada50caa9cda0) ([merge request](gitlab-org/gitlab!134637))
- [Fix scrolling to a note hash in single file mode](gitlab-org/gitlab@efaf94befdb77b7e19817f02b3bb1b2b817a04d7) ([merge request](gitlab-org/gitlab!133229))
- [Fix issue with issue templates in rich text editor](gitlab-org/gitlab@59222fe39be22c770d22590058354821fef08299) ([merge request](gitlab-org/gitlab!134989))
- [Always set source_partition_id from app](gitlab-org/gitlab@c78bed3c91157615cb2aa1f4c2216fc9b41f8d3d) ([merge request](gitlab-org/gitlab!133806))
- [Hide Security & Compliance nav links if disabled](gitlab-org/gitlab@ea33470b6c4b8b321c38568c5131ff927c9e4c5b) ([merge request](gitlab-org/gitlab!134344)) **GitLab Enterprise Edition**
- [Fixing cross joins in lib-banzai](gitlab-org/gitlab@43422d04e9ad04a68d0100bf05f0b7dc7d2582b0) ([merge request](gitlab-org/gitlab!133471))
- [Reindex epics to fix possible wrong values of label_ids](gitlab-org/gitlab@c692e53ce4b708c70b29dce95197133db3207673) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/133612)) **GitLab Enterprise Edition**
- [GithubImport::ObjectCounter use same TTL when read](gitlab-org/gitlab@8f185c7f2f3fd0d76fcc9e731073f7998bba79d5) ([merge request](gitlab-org/gitlab!134943))
- [Fix alignment of issuable sidebar header](gitlab-org/gitlab@bfa3b1e474c3c61c16fd0c9dcc528a0b63dc9087) ([merge request](gitlab-org/gitlab!134931))
- [Show new feature popover after a second](gitlab-org/gitlab@f48cfe0d792621148d85376d8a65f97baef22aa0) ([merge request](gitlab-org/gitlab!134863)) **GitLab Enterprise Edition**
- [Change order of unknown and info severity](gitlab-org/gitlab@54b8f9c181e9dc01a43de558a5d72ad5ca238c80) ([merge request](gitlab-org/gitlab!134119)) **GitLab Enterprise Edition**
- [Fix zoekt/client issues](gitlab-org/gitlab@5f7efb8fc2a2466a30375c4635600908c6c4f30e) ([merge request](gitlab-org/gitlab!134779)) **GitLab Enterprise Edition**
- [Fix "Leave admin mode" link](gitlab-org/gitlab@4ab8f9906abbcae22f0d07657a39feffe4b24d82) ([merge request](gitlab-org/gitlab!134866))
- [Fix Branch Rules showing 'All protected branches' under 'All branches'](gitlab-org/gitlab@b239e677bd774d491b904d2f77d93171597e7a5f) ([merge request](gitlab-org/gitlab!134800)) **GitLab Enterprise Edition**
- [Decouple product analytics custom dashboards](gitlab-org/gitlab@1c43cb68348acee065e26db40009e8fb82f93b2b) ([merge request](gitlab-org/gitlab!132773)) **GitLab Enterprise Edition**
- [Reindex wikis to fix routing and backfill archived](gitlab-org/gitlab@b9b47371f451f57e5ead27f980591bcf285bdc91) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/134581)) **GitLab Enterprise Edition**
- [Add group_ids in base_scope for GroupSearchResults](gitlab-org/gitlab@8e693dead011404414698b8e29229144674ac1e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/134107)) **GitLab Enterprise Edition**
- [Fix vulnerability count mismatch](gitlab-org/gitlab@c2fcd53b61a823b50dc7f395c6297e058f27b34d) ([merge request](gitlab-org/gitlab!133701)) **GitLab Enterprise Edition**
- [Fixes flaky specs in email participants feature specs](gitlab-org/gitlab@d10527b42316a80ce38ccc9a85e40ed608aa6eef) ([merge request](gitlab-org/gitlab!134620))
- [Apply Issue Analytics page filters to table](gitlab-org/gitlab@777d8e4ddb97b7d0853691e6b3ba1ad2eb3a5f81) ([merge request](gitlab-org/gitlab!133255)) **GitLab Enterprise Edition**
- [Fix epic board children count and weight on card](gitlab-org/gitlab@c85abf4d14bd31ce136337c4b1bbe83554cbd1bb) ([merge request](gitlab-org/gitlab!134591)) **GitLab Enterprise Edition**
- [Improve `script` with `trigger` error message](gitlab-org/gitlab@37f49ed92efd6995cf103885c6604949446e60ca) ([merge request](gitlab-org/gitlab!134409))
- [Fix work items sidebar glitch incase of parent widget](gitlab-org/gitlab@1d201516184397c1879285024e9bea66957d0c6c) ([merge request](gitlab-org/gitlab!134377))
- [Fix position validation on issues board list movement](gitlab-org/gitlab@087bf10efac0a202298d3c6eaa0b1dc8f1f5735d) by @zzaakiirr ([merge request](gitlab-org/gitlab!134203)) **GitLab Enterprise Edition**

### Changed (175 changes)

- [Serve pages deployments without going through PagesMetadatum](gitlab-org/gitlab@0c48f6f36ef3b806433155947591270f7dd564e9) ([merge request](gitlab-org/gitlab!135993))
- [Support Microsoft SAML attribute names by default](gitlab-org/gitlab@6afcc821bc9a25c7ca13b3c9751e338f1b001033) ([merge request](gitlab-org/gitlab!135770))
- [Avoid calling Git in gitlab-backup-cli.gemspec](gitlab-org/gitlab@e458f525ff0e3c03fc48cd53eb686d0b2af27d66) ([merge request](gitlab-org/gitlab!136623))
- [Update gitlab-elasticsearch-indexer to 4.5.0](gitlab-org/gitlab@590c7716d28801db9b90b4ddf5daed526e09d138) ([merge request](gitlab-org/gitlab!136386))
- [Fix not efficient alert when you exceeding free storage](gitlab-org/gitlab@d03a974ad25c971a795eae63092f305e4209685f) by @marc-andre.vezeau.exfo ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/133338)) **GitLab Enterprise Edition**
- [Using a constant for the file amount](gitlab-org/gitlab@c9d56d782c206bcb811ceb2eb0d90950ad94349a) by @manav014 ([merge request](gitlab-org/gitlab!136195))
- [Remove duplicated index from merge_request_assignees](gitlab-org/gitlab@026e57d24874cda7294122f765f124ef21916dd6) ([merge request](gitlab-org/gitlab!136499))
- [Removes feature flag service_desk_new_note_email_native_attachments](gitlab-org/gitlab@5abcc37d83d8d1d1a5246fd69d1bb7ee5542dc94) ([merge request](gitlab-org/gitlab!114562))
- [Added ApplicationRateLimit for Namespace update API](gitlab-org/gitlab@a1c2283ba8af8776fddf036a95e439211d3ac374) ([merge request](gitlab-org/gitlab!132053))
- [Fix: Rich Text Editor - Copy/Paste Text from Table Not Behaving Properly](gitlab-org/gitlab@dba6e6dff81af477cc8ef29fa2de8c376deac1af) by @Himani_Mehra ([merge request](gitlab-org/gitlab!135891))
- [Update feature flags default_enabled to true](gitlab-org/gitlab@455de5c94ddb96122c78c0a69b952fce2f592b03) ([merge request](gitlab-org/gitlab!136515)) **GitLab Enterprise Edition**
- [Update adherence table based on ux discussions](gitlab-org/gitlab@16029b541de2e19fd31d5ac996bb3a0c4ea88bc2) ([merge request](gitlab-org/gitlab!135994)) **GitLab Enterprise Edition**
- [Change triggered badge to trigger token](gitlab-org/gitlab@f208eda14ddb60a4bcaebd2c2b10f20b2798bb46) ([merge request](gitlab-org/gitlab!136502))
- [Removes extra line from actions menu](gitlab-org/gitlab@fdb5f80353dc627a4f4609b105329b9feb0efabb) ([merge request](gitlab-org/gitlab!136514))
- [Migrate "Enable for this project" runner button](gitlab-org/gitlab@0256cdd77a3f032d986628e274346dfe83328a20) ([merge request](gitlab-org/gitlab!136088))
- [Prevent update of default branch if block_unprotecting_branches is set](gitlab-org/gitlab@9df76275a4f1743813584e52c29e72ac6de49715) ([merge request](gitlab-org/gitlab!136225)) **GitLab Enterprise Edition**
- [Fix pending status check workers](gitlab-org/gitlab@e60e75b18f1afdd5993d279324df308fa555a7c9) ([merge request](gitlab-org/gitlab!135396)) **GitLab Enterprise Edition**
- [Show stopping environments as well](gitlab-org/gitlab@9e6d506588b6f4bf5d5aacbdf204c29e8023bf91) ([merge request](gitlab-org/gitlab!135758))
- [Display project full path and remove namespace column from token table](gitlab-org/gitlab@dd3b1792eacb4422c68dc49695c8f1a5824528c5) ([merge request](gitlab-org/gitlab!136423))
- [Allow Jira organization admins to setup group links](gitlab-org/gitlab@6dace6480ff6342a5952bc794815550dd924def7) ([merge request](gitlab-org/gitlab!135771))
- [Added new setting allow_project_creation_for_guest_and_below](gitlab-org/gitlab@a2ef829850a324fed7749bfca6fb6a90cb82c2aa) ([merge request](gitlab-org/gitlab!134625))
- [Allow you to pass docker options to the Sitespeed docker](gitlab-org/gitlab@3d0b00aa513f224adb155ea8ef84b54e06fa27cd) by @nvalenzuela_paciolan ([merge request](gitlab-org/gitlab!134024))
- [Update filtering in compliance center docs](gitlab-org/gitlab@457c6cdff0db164551b326c13034b7cdace368d6) ([merge request](gitlab-org/gitlab!136360))
- [Update pagination on the standards adherence table](gitlab-org/gitlab@ca13a529820d33daa05de0b7fe665bfc23b6bd94) ([merge request](gitlab-org/gitlab!135525)) **GitLab Enterprise Edition**
- [Updates Ci::Catalog::Resources::CreateService](gitlab-org/gitlab@901ca41a470b14a02c3bfd00af5d6133ce9e9500) ([merge request](gitlab-org/gitlab!136168))
- [Add field to query organizations for a given user](gitlab-org/gitlab@6e82cab268ca928a7d961fbf591dd7e46433199a) ([merge request](gitlab-org/gitlab!136024))
- [This MR adds ability to select projects](gitlab-org/gitlab@150495bcb2f3322903bf36c0f041d78ff530b4f8) ([merge request](gitlab-org/gitlab!135653)) **GitLab Enterprise Edition**
- [Update terraform init default state name (default)](gitlab-org/gitlab@f082878d4036ac7b93453fe6996316f1987abf53) ([merge request](gitlab-org/gitlab!136269))
- [This MR disables unprotect button](gitlab-org/gitlab@4ffa4b723a71c98abd46ef9234d751678e1edcd1) ([merge request](gitlab-org/gitlab!133268)) **GitLab Enterprise Edition**
- [Update Learn Gitlab progress bar](gitlab-org/gitlab@f41035500299b4e55cd3c30e84d84b513dda15e8) ([merge request](gitlab-org/gitlab!135608)) **GitLab Enterprise Edition**
- [Migrate vulnerability state dropdown to Listbox](gitlab-org/gitlab@dcd2ff72dee4fa36d9bd52d5e1c52174c4ef117c) ([merge request](gitlab-org/gitlab!135254)) **GitLab Enterprise Edition**
- [Don't delete project if the repository is moving to a different shard](gitlab-org/gitlab@0d6bf465fcc67305a141690f76b30402820f1dd9) ([merge request](gitlab-org/gitlab!135819))
- [Add devops adoption to registration features](gitlab-org/gitlab@2aff8faa447aff2579c79225c1bdbb85dc4ba31f) ([merge request](gitlab-org/gitlab!136224)) **GitLab Enterprise Edition**
- [Backfill p_ci_builds bigint conversion columns](gitlab-org/gitlab@08dc03ff2942e1bc18de6d351c342d1d29973ab8) ([merge request](gitlab-org/gitlab!135935))
- [Adds Ci::Catalog::Resources::ReleaseService](gitlab-org/gitlab@1dffc58722e6a1d24c9bdbd6a5bea48621a6cb67) ([merge request](gitlab-org/gitlab!133739))
- [Separates type and status icons in headers](gitlab-org/gitlab@24071ecd331dc11a4bef0918e4edfa36f6f5e7dc) ([merge request](gitlab-org/gitlab!135272))
- [Change color for Kotlin language ](gitlab-org/gitlab@25160a87f5afbb2baad7056943e300d38ee857b2) by @gustavoandresimon ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/135991))
- [Contribution analytics: Remove request batching when using Clickhouse](gitlab-org/gitlab@81a2c85f4cc2adaff1f3bfa8d5d37661f4652b04) ([merge request](gitlab-org/gitlab!135765)) **GitLab Enterprise Edition**
- [UserCore - Add lastActivityOn](gitlab-org/gitlab@041e80646c82cee3eb9fecaa644ebba0d6d81da6) ([merge request](gitlab-org/gitlab!135852))
- [Restructure work item header](gitlab-org/gitlab@3198f82077a0e69a0732fc41872ae9100a909250) ([merge request](gitlab-org/gitlab!134609))
- [Initialize bigint conversion for p_ci_builds for self-host](gitlab-org/gitlab@e6102462f46ba700cb71d92f72fd1c85a32184ca) ([merge request](gitlab-org/gitlab!135590))
- [Add delete user vscode_settings endpoint](gitlab-org/gitlab@2a2a53c4ab175e1f64a7155bdae682bed66dcf06) ([merge request](gitlab-org/gitlab!135692))
- [Add Confidentiality Badge to Test Case Sticky Header](gitlab-org/gitlab@202500f4c7647c4fbc23c3a26608cf5795039788) ([merge request](gitlab-org/gitlab!135483))
- [Migrate zoekt_shards to zoekt_nodes](gitlab-org/gitlab@cacfddb2f4976b42828510c8f49403a82ff5f7ff) ([merge request](gitlab-org/gitlab!134901))
- [Add setting for external redirect page for job artifacts](gitlab-org/gitlab@2418106fa6c7c9bc58f5e5210d555c6dfbf100c3) by @ftab ([merge request](gitlab-org/gitlab!133125))
- [Use new import status in bulk_import_history_app](gitlab-org/gitlab@38272a9bf4849ed9f0c21aed2a3239be5755775d) ([merge request](gitlab-org/gitlab!135216))
- [Update Kaniko CI template](gitlab-org/gitlab@79527f73f9f4798711963de8777bc06a3ffa7f48) by @mh4ckt3mh4ckt1c4s ([merge request](gitlab-org/gitlab!133222))
- [Add keyboard shortcut for compare button](gitlab-org/gitlab@f6a763319547042aa4778e9721d7b7b13a74c760) ([merge request](gitlab-org/gitlab!135465))
- [Log project repository storage](gitlab-org/gitlab@7e466b0701d74d6db2c56cef0f8d01165d004e80) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/136043))
- [Default enable allow_streaming_audit_events_to_amazon_s3 feature flag](gitlab-org/gitlab@9b4b8866b7b1df4699f609e47fc76b38afb19e50) ([merge request](gitlab-org/gitlab!136050))
- [Add scope argument with `all` option](gitlab-org/gitlab@0fb77a4d4bd3dbe9c16fa59dd38c17ab380b6e3c) ([merge request](gitlab-org/gitlab!135017))
- [Add fixed width and truncate framework badge](gitlab-org/gitlab@e58d98b10909394a79a892ed27901342bfe12afc) ([merge request](gitlab-org/gitlab!135059))
- [Migrate buttons in notes_helper.rb](gitlab-org/gitlab@365ea2c6e97bc9d8a71ab85457d1c8b76d635cb8) ([merge request](gitlab-org/gitlab!134173))
- [Enable super sidebar for logged-out users](gitlab-org/gitlab@4c8bd3583376590e7680cc295cd61c07fdedab83) ([merge request](gitlab-org/gitlab!134890))
- [Update error message for DAG circular dependency](gitlab-org/gitlab@97bc053575e2a003e1f3657e92faca44bb127be4) ([merge request](gitlab-org/gitlab!135722))
- [Add a usage quotas card for SaaS project limits = 0 state](gitlab-org/gitlab@89ed2278350bb8afea2d876f2b1e5791d68c6b3b) ([merge request](gitlab-org/gitlab!134916)) **GitLab Enterprise Edition**
- [Add advanced search to registration features](gitlab-org/gitlab@e9ea91013f6729f82d6c671834cdb80c1560e9f4) ([merge request](gitlab-org/gitlab!135580)) **GitLab Enterprise Edition**
- [New CiIcons](gitlab-org/gitlab@84f6a9d2b1c89bf7146cdb50dfd060b2c6c42f5b) ([merge request](gitlab-org/gitlab!133501))
- [refactor: Validate package_name_pattern format in protection rule](gitlab-org/gitlab@5b44bb8697285469c11781197deceb9d95901acb) by @gerardo-navarro ([merge request](gitlab-org/gitlab!132279))
- [Use the list tags repository API to fetch tags](gitlab-org/gitlab@5f1595df10ad42b3afef8de790e88ec2224396b5) ([merge request](gitlab-org/gitlab!132716))
- [Ignore plain-text columns from Users::CreditCardValidation model](gitlab-org/gitlab@40021c090e784eaf0779c8a1a123c2754aa91a98) ([merge request](gitlab-org/gitlab!135194))
- [Fix license category in license compliance widget](gitlab-org/gitlab@b87faea17b5d2348e80b66fc286cd97b75cbcabc) ([merge request](gitlab-org/gitlab!130244))
- [Update code suggestion input limits](gitlab-org/gitlab@51ed3460d03c49ddbbc7536c2ef40fa831c9702d) ([merge request](gitlab-org/gitlab!134886)) **GitLab Enterprise Edition**
- [Activity feed: Update private contribution to use new style](gitlab-org/gitlab@bab78c959cc9ce80038038faa5440a51517b9273) ([merge request](gitlab-org/gitlab!135831))
- [Update enterprise badge, filtering, and disabling 2FA to new definition](gitlab-org/gitlab@75e9c25c2910eaef9c7e123216a90ca97d2bcb90) ([merge request](gitlab-org/gitlab!135335)) **GitLab Enterprise Edition**
- [Swapped AIGenieChat with DuoChat component](gitlab-org/gitlab@759a9554744e42e98f8d3717dc702cdbcc54c331) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/134669)) **GitLab Enterprise Edition**
- [Tweaks plan limit validations to support unlimited](gitlab-org/gitlab@089833cf6e4cefaa9a27443b42a82353a48eb49a) ([merge request](gitlab-org/gitlab!135371)) **GitLab Enterprise Edition**
- [Changes label link to subscribed tab](gitlab-org/gitlab@2cfbf42591f3eac926d867c097c0dae24a315d6c) ([merge request](gitlab-org/gitlab!135624))
- [Add toast when pin item added and removed](gitlab-org/gitlab@19d3964752e56489e74cf57fd74abe0595a34f0e) ([merge request](gitlab-org/gitlab!134726))
- [Increase spacing of CI Catalog badge](gitlab-org/gitlab@a292b985029b9f42276f52aa2f2b1fa8153b9006) ([merge request](gitlab-org/gitlab!135667))
- [feat: Added field `id` for the graphql Packages::Protection::RuleType](gitlab-org/gitlab@c5b26d76b8a2c37a2c8f23bb872cf34797bfcadc) by @gerardo-navarro ([merge request](gitlab-org/gitlab!134250))
- [Add bold styling to user activity](gitlab-org/gitlab@329bffff5531ec563ce62da26e119be9afe193bd) ([merge request](gitlab-org/gitlab!135756))
- [Allow to move project repositories in hidden/pending_delete state](gitlab-org/gitlab@ccd79e9bee61851a6b7a1c4f3ef47868c3e1e326) ([merge request](gitlab-org/gitlab!135748))
- [Allow self-signed certs when adding certs to a pages domain](gitlab-org/gitlab@c7e64ec93531b1157797ca2ebe9330c6f4e224d6) ([merge request](gitlab-org/gitlab!134419))
- [Increase container spacing](gitlab-org/gitlab@ff6350f92372a1b5420f5140639bf06b255060b2) ([merge request](gitlab-org/gitlab!124325))
- [Cleanup for converted ci_pipeline_messages.pipeline_id](gitlab-org/gitlab@12d3703a9ed0b8f931e90400002686f580c7a703) ([merge request](gitlab-org/gitlab!134226))
- [Reorders form in admin namespace limits view](gitlab-org/gitlab@08fe61867cc20bc6677268514e8a1eede0f1cdac) ([merge request](gitlab-org/gitlab!135707)) **GitLab Enterprise Edition**
- [Document known issue regarding runner token rotation](gitlab-org/gitlab@0699a0b58110f8221b8c008811f357b19180c00e) ([merge request](gitlab-org/gitlab!135619))
- [Remove avatars from user profile activity](gitlab-org/gitlab@50a8d948c60973d17de5fef8ca845b7ce06adb9a) ([merge request](gitlab-org/gitlab!135038))
- [Update dependency auto-build-image to v1.49.0](gitlab-org/gitlab@a9b080ad1fcd4e779cae6d0050a45caa32055e64) ([merge request](gitlab-org/gitlab!135674))
- [Guidance to disable git SSH limit](gitlab-org/gitlab@68ef1675db7c238d49811b136acefb63b5f505d1) ([merge request](gitlab-org/gitlab!135460))
- [Add possibility for minimal forks](gitlab-org/gitlab@5c9d43273d3a870ad3383358b00cdbefb776343e) ([merge request](gitlab-org/gitlab!134751))
- [Add AWS S3 streaming destinations](gitlab-org/gitlab@09617c5fe17f8c2c2d0d0a0d95f323cfcfedade8) ([merge request](gitlab-org/gitlab!132603)) **GitLab Enterprise Edition**
- [Migrate header_actions to GlDisclosureDropdown](gitlab-org/gitlab@fca5e974fd9fb8bf0c7098046ad9ffbf5c597298) ([merge request](gitlab-org/gitlab!130709))
- [Link to ruby/gems in Ruby upgrade docs](gitlab-org/gitlab@9db35c9e848db70f8dc610f210234fdbdbabd03a) ([merge request](gitlab-org/gitlab!135551))
- [Format tooltip wait time values in seconds](gitlab-org/gitlab@3904f7111e6ad232879f1903f42547c22360f424) ([merge request](gitlab-org/gitlab!135589))
- [Cleanup for converted ci_sources_pipelines.pipeline_id](gitlab-org/gitlab@420cf4e04ea05d4342464699ed244b9d760561a5) ([merge request](gitlab-org/gitlab!134965))
- [Migrate issue_move_dropdown to GlCollapsibleListbox](gitlab-org/gitlab@bd7778af74ca0b34d0447d0f31f7ec21d2fbe615) ([merge request](gitlab-org/gitlab!135484))
- [Migrates dropdown to Pajamas disclosure](gitlab-org/gitlab@00aa63f7386bccd48045be446996ef7bc4c4ddeb) ([merge request](gitlab-org/gitlab!135341)) **GitLab Enterprise Edition**
- [Add DB tables to allow group approval rules](gitlab-org/gitlab@7864e4b2692162a67bf3093f91ed0c1b20e57be2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/132651)) **GitLab Enterprise Edition**
- [Replace the legacy openai_experimentation FF with ai_global_switch](gitlab-org/gitlab@aab2235af535664dd18456a3b115c0c1018c19a3) ([merge request](gitlab-org/gitlab!135248)) **GitLab Enterprise Edition**
- [Pipeline graph: Change group alignments](gitlab-org/gitlab@f61262f06a91961b1548f7b2334b7cc315d0d3ed) ([merge request](gitlab-org/gitlab!135476))
- [Update test_file_finder to 0.2.1](gitlab-org/gitlab@8a542ae2826f4efe40551e510c1227fc42081ea8) ([merge request](gitlab-org/gitlab!135550))
- [This MR fixes Injections clashing with Computed](gitlab-org/gitlab@b46dcc1604508a26b54dbadea32e5281b94460cd) ([merge request](gitlab-org/gitlab!135278)) **GitLab Enterprise Edition**
- [Mask `shared_with_group and `source` if the group is private](gitlab-org/gitlab@ac6b7c01c1b0a862a216e6a9663c072b67f01079) ([merge request](gitlab-org/gitlab!134623))
- [Removes new registration flow feedback banner](gitlab-org/gitlab@fdf29ed5f2a7cf1e789ddb26f4c9f402e4f84d48) ([merge request](gitlab-org/gitlab!135470))
- [Removed the composer_use_ssh_source_urls feature flag](gitlab-org/gitlab@fab1cf3a61119634d05217123f09928eaa522468) ([merge request](gitlab-org/gitlab!135467))
- [Improve runner registration instructions](gitlab-org/gitlab@02e8b7a3b5e78894ad65fd5f577c8f4d0b9d7819) ([merge request](gitlab-org/gitlab!135464))
- [Adds button to return to runners list from dashboard](gitlab-org/gitlab@b4bb6c72b964a930bae9f3127e33b0d03ab3f87b) ([merge request](gitlab-org/gitlab!135468)) **GitLab Enterprise Edition**
- [Update GraphQL default ability field description](gitlab-org/gitlab@4bf1f2e3f975b869eda7d7e678772b1d1ec0d6ce) ([merge request](gitlab-org/gitlab!135455))
- [Move compare to beginning of common tree view buttons](gitlab-org/gitlab@b8d40456823c1cabd0324ee9b99f5ef461a24257) ([merge request](gitlab-org/gitlab!135390))
- [Fix trial page footer](gitlab-org/gitlab@1436ee57964eb5d3910605b0f7c058844f1cdb5c) ([merge request](gitlab-org/gitlab!134787)) **GitLab Enterprise Edition**
- [Replace all delete tag calls with compliant endpoint](gitlab-org/gitlab@987a7a39763c09b23c7703f05ff49e546c422de4) ([merge request](gitlab-org/gitlab!134455)) **GitLab Enterprise Edition**
- [Remove math node limit for wikis and blobs](gitlab-org/gitlab@4fc50b647cb4a95bd74f35db6348e8c37865e2e3) ([merge request](gitlab-org/gitlab!135063))
- [Migrate dropdown to disclosure dropdown](gitlab-org/gitlab@b61bc9d156c9a7121e60aaa7f7b4ab7ec0e8dea2) ([merge request](gitlab-org/gitlab!134912))
- [Add users and permissions report to registration features](gitlab-org/gitlab@d78a22804bbf4df6f38ddd5c124832e64466bb4b) ([merge request](gitlab-org/gitlab!135147)) **GitLab Enterprise Edition**
- [Splits namespace usage quotas storage cards by limit type](gitlab-org/gitlab@7002a9d8a4b93c4c1a443d73ab5b79abc9863fee) ([merge request](gitlab-org/gitlab!135057)) **GitLab Enterprise Edition**
- [Update `add_catalog_resource` helper](gitlab-org/gitlab@38508a38f1652d86ad7ddfb8b3c0b8225c20949d) ([merge request](gitlab-org/gitlab!134907))
- [Sort emojis based on Unicode ordering](gitlab-org/gitlab@63f9ea1ee4ee001458c2907a66b04f9afa372016) ([merge request](gitlab-org/gitlab!134458))
- [Swapping columns for ci_pipelines for self-host](gitlab-org/gitlab@9402e537fe328dd93fd3f637909a5b088b622f7a) ([merge request](gitlab-org/gitlab!135070))
- [Redesign of freetrial](gitlab-org/gitlab@db2481839162f5cd12147f941b6ac3c6a35d3c7a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121269)) **GitLab Enterprise Edition**
- [Replace cross-joins on approval rules](gitlab-org/gitlab@3f87a2c77ab78da9e121b677ae9df0f0ffefe569) ([merge request](gitlab-org/gitlab!134108))
- [Added link to commit in commited changes banner](gitlab-org/gitlab@f34821e24ec52b7b2a59af0d3c663fd6c34d613d) ([merge request](gitlab-org/gitlab!134934))
- [Add aria-hidden attr](gitlab-org/gitlab@f3ba8f252abb6e52750426fdd297989847006eb9) ([merge request](gitlab-org/gitlab!134911)) **GitLab Enterprise Edition**
- [Add model validations](gitlab-org/gitlab@df38bde8a9454dd523ddd59dce3abef6b49c1231) ([merge request](gitlab-org/gitlab!135231)) **GitLab Enterprise Edition**
- [Tidy up Activity feed](gitlab-org/gitlab@6b7e14493783933373b091b9b616f93508915bea) ([merge request](gitlab-org/gitlab!135011))
- [Swapping columns for ci_stages for self-host](gitlab-org/gitlab@bba70f9c3e6c09505e4713744be71afbf9d4aa60) ([merge request](gitlab-org/gitlab!135071))
- [Sync scan_result_policy_violations for license_scanning rules](gitlab-org/gitlab@17c62bd65a3e54e25a3f33b9d30116ae3d63a697) ([merge request](gitlab-org/gitlab!135121)) **GitLab Enterprise Edition**
- [Update mermaid version to 10.6.0](gitlab-org/gitlab@f4aacf723487222fde95958a5da052e13ebe1a92) ([merge request](gitlab-org/gitlab!135193))
- [Restore repositories from backup manifest files](gitlab-org/gitlab@898c215585350cf4fc0fabacf8b965979b76c985) ([merge request](gitlab-org/gitlab!135175))
- [Remove Chat Self Discover Feature flag](gitlab-org/gitlab@289822390ee13abd1370244a5ce11f554d690bdf) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/134795))
- [Improve issues metric names in Value Streams Dashboard](gitlab-org/gitlab@e399883b6797eb401fd560e5dd4f8eec3688fbad) ([merge request](gitlab-org/gitlab!135163)) **GitLab Enterprise Edition**
- [This MR fixes undefined in v-on handler](gitlab-org/gitlab@b87671a15cbc4515ad4d626d04c74e53f8301498) ([merge request](gitlab-org/gitlab!134764)) **GitLab Enterprise Edition**
- [Add worker to timeout status check responses](gitlab-org/gitlab@2677660b5ab5545f87e63161dcc66c7eb0c6e59c) ([merge request](gitlab-org/gitlab!133383)) **GitLab Enterprise Edition**
- [Improve Jira issue creation dropdown](gitlab-org/gitlab@8ee0b54b721c2b809231fde1c4a340389d4f9811) ([merge request](gitlab-org/gitlab!134168))
- [Block call to CustomersDot when too many namespace name updates](gitlab-org/gitlab@0b067e8979607945caf8a5a90be641df0e497085) ([merge request](gitlab-org/gitlab!135019)) **GitLab Enterprise Edition**
- [Cleanup for converted ci_pipeline_chat_data.pipeline_id](gitlab-org/gitlab@382d3e434601f448de84d147fcf3f79065b2243c) ([merge request](gitlab-org/gitlab!134225))
- [Moves authorization to runs/experiments resources](gitlab-org/gitlab@bda17cfef84347c6796ee3ed5851884ee5eeff74) ([merge request](gitlab-org/gitlab!135116))
- [Refactor import logos](gitlab-org/gitlab@c678060beef3de1420e27d7f0f32ae18848d53c6) ([merge request](gitlab-org/gitlab!135117))
- [Replicate object pools during the migration](gitlab-org/gitlab@106648b900e0772eff308c1bf5eac440ceda5ae2) ([merge request](gitlab-org/gitlab!135103))
- [Add creator information to header of the runner](gitlab-org/gitlab@f18ee09d36c9c06c0564bec02b90d8c34cbff558) ([merge request](gitlab-org/gitlab!134516))
- [Add DB tables to allow group approval rules](gitlab-org/gitlab@9d5ad46d58489d9e84e01454838235afec9ddc89) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/132651)) **GitLab Enterprise Edition**
- [Add Lock project membership to group to registration features](gitlab-org/gitlab@7a1c83c0d8575ddb20885fb5f64bcb3305dcb44f) ([merge request](gitlab-org/gitlab!134963)) **GitLab Enterprise Edition**
- [Expose list of custom roles](gitlab-org/gitlab@afc613ddfc329a57ce50658d49afd4ff0f664c53) ([merge request](gitlab-org/gitlab!133696))
- [Remove drop_job_on_secrets_provider_not_found feature flag](gitlab-org/gitlab@3d33a277e6849b8110be299169c50c315805bf17) ([merge request](gitlab-org/gitlab!134453)) **GitLab Enterprise Edition**
- [Re-do swapping columns for ci_stages](gitlab-org/gitlab@ea1477761cafb07717e46753f9804fdc8530becf) ([merge request](gitlab-org/gitlab!134618))
- [Add tooltip to status check mr widget](gitlab-org/gitlab@e3de2a2593cb2e01e6a5b245731c902fe56bc6db) ([merge request](gitlab-org/gitlab!133472)) **GitLab Enterprise Edition**
- [Pipeline: Redesign Pipeline Graph](gitlab-org/gitlab@19f90546e91657b37ffaf1d585612a04c1e5ee2f) ([merge request](gitlab-org/gitlab!132462))
- [Small fixups for Bitbucket parallel importer](gitlab-org/gitlab@6ee6d66ec3089df4a197662047baf5466b6d9a86) ([merge request](gitlab-org/gitlab!134741))
- [Improve Jira app config instructions](gitlab-org/gitlab@fae651a2edb8e433ff3d6454e5db6a24e03d46af) ([merge request](gitlab-org/gitlab!134535))
- [Format CI/CD analytics metrics using the browser settings](gitlab-org/gitlab@bd06e0c6aee7ae5d9e8315e5ab867fa58bd3c0da) ([merge request](gitlab-org/gitlab!134671))
- [Refactor CiIcon](gitlab-org/gitlab@9986e0758237597683cf630b5a9cf3e7ceffd418) ([merge request](gitlab-org/gitlab!133437))
- [Move the content of service_usage_data page to metrics_and_profiling](gitlab-org/gitlab@58f4c95792a7c0c82c088033bc6f35e139054137) ([merge request](gitlab-org/gitlab!133161))
- [Remove `check_multiple_pipelines_for_security_reports` feature flag](gitlab-org/gitlab@8c519b42488bca089a02db17034f85917ff89efb) ([merge request](gitlab-org/gitlab!134975)) **GitLab Enterprise Edition**
- [Remove isSingleRequest true from apollo query context](gitlab-org/gitlab@15039fc7d00588c8eb073b55c16478e0b69bf01e) ([merge request](gitlab-org/gitlab!130911)) **GitLab Enterprise Edition**
- [Use password input field for PAT](gitlab-org/gitlab@74deb6dd37b1010494d36c7a2f7817fcdcd532d9) ([merge request](gitlab-org/gitlab!134788))
- [Add Service Level Agreement countdown timer to registration features](gitlab-org/gitlab@313eff6bc50fa129157cc998389ee9167c1ddf75) ([merge request](gitlab-org/gitlab!134793)) **GitLab Enterprise Edition**
- [Cleanup bigint conversion for shared_runners_duration](gitlab-org/gitlab@9d98eee8ecba80ce447b8b2a339f54bb9c187cdf) ([merge request](gitlab-org/gitlab!134037))
- [Remove jwt_auth_space_delimited_scopes feature flag](gitlab-org/gitlab@2f69abc85c2189509701917c102500db9c7be734) ([merge request](gitlab-org/gitlab!134772))
- [Rename zoekt shards to nodes](gitlab-org/gitlab@3cdddc5349cb2c5e6f888d82585ebe881a0879b7) ([merge request](gitlab-org/gitlab!134717)) **GitLab Enterprise Edition**
- [Fix EscapeUtils deprecation warning](gitlab-org/gitlab@eb714ac4dd9131ede836aa2e9a3c3259b12c6c76) ([merge request](gitlab-org/gitlab!134889)) **GitLab Enterprise Edition**
- [Move comment logic to parallel importer](gitlab-org/gitlab@002c80678b0d612ed6a22efcad91c0b02466146e) ([merge request](gitlab-org/gitlab!133208))
- [Slack slash commands page: Migrate clipboard buttons](gitlab-org/gitlab@a8b403126522ba1758b305bea11da5e7a1e2f0af) ([merge request](gitlab-org/gitlab!134086))
- [Update acts-as-taggable-on to 10.0](gitlab-org/gitlab@a4d867b4bf675366ea2c004b07aa1a050d391c0b) ([merge request](gitlab-org/gitlab!134554))
- [Unify labelName and authorUsername GraphQL arguments](gitlab-org/gitlab@37134f4df364a7749eef01a252d888899f553ddf) ([merge request](gitlab-org/gitlab!134312)) **GitLab Enterprise Edition**
- [Add group webhooks to registration features](gitlab-org/gitlab@63d0bbdd8ff11580776df504be8a2052af81a311) ([merge request](gitlab-org/gitlab!134549)) **GitLab Enterprise Edition**
- [Underline links in package row component](gitlab-org/gitlab@7f5176660b256cec1c503b4968de72c6fb19afbb) ([merge request](gitlab-org/gitlab!133869))
- [Remove search_notes_hide_archived_projects](gitlab-org/gitlab@8d9928a3f7e2607e048006fb99e2ebfd82d1a783) ([merge request](gitlab-org/gitlab!134509))
- [Clean up and remove ios_specific_templates experiment](gitlab-org/gitlab@225ca3a58986c657792f961ec5da49f1aaa573af) ([merge request](gitlab-org/gitlab!133608))
- [Migrate actions buttons](gitlab-org/gitlab@c67491f0c1bea105dfce16ebaff5e0a026f09069) ([merge request](gitlab-org/gitlab!134181))
- [Adds a new Danger check for changing column default](gitlab-org/gitlab@6e55aad71e99f7dacaa1a9a10c54b9f0e8f7104e) ([merge request](gitlab-org/gitlab!134594))
- [Update dependency auto-deploy-image to v2.60.0](gitlab-org/gitlab@d77fd1a22e157b9835448185c96c2857d527477a) ([merge request](gitlab-org/gitlab!134683))
- [Remove search_merge_requests_hide_archived_projects](gitlab-org/gitlab@2735a18fe5af481a6f021e70d8fa5ee053cc2f77) ([merge request](gitlab-org/gitlab!134512))
- [Geo Sites Form - Migrate Shards Dropdown](gitlab-org/gitlab@ca9ef36f07cb5307c61a496c659f61b7ba0a1d2f) ([merge request](gitlab-org/gitlab!134416)) **GitLab Enterprise Edition**
- [Change notifications/todos feature flag to current_user](gitlab-org/gitlab@336e545d27a2babb96b1abe35b38cbedb52f3827) ([merge request](gitlab-org/gitlab!134661))
- [Remove search_issues_hide_archived_projects flag](gitlab-org/gitlab@4f2a01c4ff7844bf19e9aadecb09ec68188343ff) ([merge request](gitlab-org/gitlab!134506))
- [Move user profile actions into overflow menu](gitlab-org/gitlab@a61d1dda0a1374f4524073b6dfb197cb82dcc7ba) ([merge request](gitlab-org/gitlab!132673))
- [Search: Track autocomplete action](gitlab-org/gitlab@9e25a5d4fdc06e077b4574d12f9892c170c138a4) ([merge request](gitlab-org/gitlab!134424))
- [Allow permitted invalid approval settings for policy rule builder](gitlab-org/gitlab@c28171c44776020783f429831d18e9f186fa53cb) ([merge request](gitlab-org/gitlab!134622)) **GitLab Enterprise Edition**
- [Fix and migrate missing clipboard buttons](gitlab-org/gitlab@4f4676de926ef9bd81a361d6095999614d0292cf) ([merge request](gitlab-org/gitlab!134170))
- [Add group file templates to registration features](gitlab-org/gitlab@a155caea54379385059664aa1347052b91cfdb75) ([merge request](gitlab-org/gitlab!134288)) **GitLab Enterprise Edition**
- [Re-do swapping columns for ci_pipelines](gitlab-org/gitlab@78169da996b364a4abd9e88d4e0bbb237a486a25) ([merge request](gitlab-org/gitlab!134597))
- [Geo Replicable - Migrate Filter Dropdown](gitlab-org/gitlab@40d2b51f80043bd3b7483af7d8730047c5c3e105) ([merge request](gitlab-org/gitlab!134433)) **GitLab Enterprise Edition**
- [Allow environment override of NODE_OPTIONS for webpack](gitlab-org/gitlab@42b7fa207865d20bcd360292185be4539cbb92c4) by @twk3 ([merge request](gitlab-org/gitlab!131578))
- [Update dependency auto-build-image to v1.46.0](gitlab-org/gitlab@e593cf334a32d8a4f2a6835ce9258b9e248137bc) ([merge request](gitlab-org/gitlab!134305))

### Deprecated (1 change)

- [Add bigint fields for epic descendant weights](gitlab-org/gitlab@033a7575820cc639735771fa20971f6b029e840c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/125501)) **GitLab Enterprise Edition**

### Removed (32 changes)

- [Remove Rugged patches (step 2)](gitlab-org/gitlab@17d3f4cdafb182ca3b4e68f34ba1b49eb0cb852a) ([merge request](gitlab-org/gitlab!135949))
- [Remove ignored column from in_product_marketing_emails](gitlab-org/gitlab@0559e152de2cc3b922a6f7bc8ec74af49f9b100b) ([merge request](gitlab-org/gitlab!135731))
- [Remove flux custom logic](gitlab-org/gitlab@1a5f2786ad5421fe0359df01e6dec057df347e4f) ([merge request](gitlab-org/gitlab!136005))
- [Remove audit event related to third party AI setting](gitlab-org/gitlab@e08ebcc27b6eed0e3a5cfbb53dd109eaa4911db8) ([merge request](gitlab-org/gitlab!136310)) **GitLab Enterprise Edition**
- [Remove all references to Third-Party AI features setting](gitlab-org/gitlab@29c7574d4e36255d8cd079cebcaba7056f363879) ([merge request](gitlab-org/gitlab!136144)) **GitLab Enterprise Edition**
- [Remove design_* and wiki_* ignore columns rule](gitlab-org/gitlab@d15ef053c42f907e252bbf5672e572e5ddb946cf) ([merge request](gitlab-org/gitlab!136226)) **GitLab Enterprise Edition**
- [Remove toggle to turn off new navigation](gitlab-org/gitlab@04675bc702c6f3ed5f33f90fff0e2d517c0e3e56) ([merge request](gitlab-org/gitlab!134531))
- [Cleanup generate description feature](gitlab-org/gitlab@c502e05c1b4c506aeeed4bb9f202344cbc1067f4) ([merge request](gitlab-org/gitlab!136176)) **GitLab Enterprise Edition**
- [Remove reversibility of Jira endpoints](gitlab-org/gitlab@c35e919910f8ace7f72f94251df85c1424095992) ([merge request](gitlab-org/gitlab!134791))
- [Drop project_settings.jitsu_key](gitlab-org/gitlab@4d4400f893c706eb015dd0c14f006f02faaea495) ([merge request](gitlab-org/gitlab!135230))
- [Remove Rugged patches](gitlab-org/gitlab@b1c64be76bc4950775e8b45e78d11698fd9b06aa) ([merge request](gitlab-org/gitlab!132111))
- [Remove unused redis-namespace gem](gitlab-org/gitlab@561e7c4de3ca6bf328e3764e67b340e0554f1397) ([merge request](gitlab-org/gitlab!135344))
- [Remove projects.scss from FF](gitlab-org/gitlab@c9e8c58c4ddbb18163db7ffdb4e4eea609e74541) ([merge request](gitlab-org/gitlab!135081))
- [Remove redundant indexes within Optimize](gitlab-org/gitlab@1c948e67d6b0fbf4b3e32d596917a817a289418f) ([merge request](gitlab-org/gitlab!134993))
- [Remove COOP header](gitlab-org/gitlab@44d5d6f0e903e98e1b6a1aea83b3686f349ac30c) ([merge request](gitlab-org/gitlab!134542))
- [Remove unused Geo::FileRegistryFinder class](gitlab-org/gitlab@6e8eb97e9eb7d7a34f8eb6bf7f552b6510c39883) ([merge request](gitlab-org/gitlab!135033)) **GitLab Enterprise Edition**
- [Remove deprecated status data from Geo Site Status API](gitlab-org/gitlab@f29f49b06f9b9cdc3f210ebfbbbbdf45ac67cef8) ([merge request](gitlab-org/gitlab!135026)) **GitLab Enterprise Edition**
- [Remove unused #user_table_headers](gitlab-org/gitlab@a2488e0c41ce904486d84dce8ab4f1aa523ed862) ([merge request](gitlab-org/gitlab!135027))
- [Delete dupliacted index_scan_result_policies_on_policy_configuration_id](gitlab-org/gitlab@ffca08301bc392f39143d51580dc8800df0d52cf) ([merge request](gitlab-org/gitlab!134786))
- [Remove merge_request_refs_cleanup feature flag](gitlab-org/gitlab@a8465ddda82a49b51f0279081f3867e140dea715) ([merge request](gitlab-org/gitlab!130004))
- [Drop unused project_registry table](gitlab-org/gitlab@1beb0df8e6a01c57183df80efced629407af56c9) ([merge request](gitlab-org/gitlab!134939)) **GitLab Enterprise Edition**
- [Remove unused #visibility_level_helper method](gitlab-org/gitlab@04e3b18c1093bfe9af223d37afb16e81ea5d3eac) ([merge request](gitlab-org/gitlab!134927))
- [Remove the disable merge trains flag](gitlab-org/gitlab@fc638526c66f0018ac3233a483c3382dbc668946) ([merge request](gitlab-org/gitlab!132394)) **GitLab Enterprise Edition**
- [Remove unused wiki_sort_title helper](gitlab-org/gitlab@691968a8f1f2a2dd7025b1597281d3c3d4dfaa1c) ([merge request](gitlab-org/gitlab!134794))
- [Drop column force_full_reconciliation from workspaces](gitlab-org/gitlab@a54004d8001e88ba44492be516ee3cf69b1bd996) ([merge request](gitlab-org/gitlab!134735))
- [Remove Snowplow event generator as obsolete](gitlab-org/gitlab@db9b38735645b77c6ebb54922a33af54f44d6dee) ([merge request](gitlab-org/gitlab!134701))
- [Remove unused feature flag sync_mr_approval_rules_security_policies](gitlab-org/gitlab@8284c78c654f59eb56e52b9141405a549af21b94) ([merge request](gitlab-org/gitlab!134624)) **GitLab Enterprise Edition**
- [Remove unbatch_graphql_queries FF](gitlab-org/gitlab@286266a1bf205de0d726536b93133c36a88d07f7) ([merge request](gitlab-org/gitlab!132433))
- [Remove value_stream_dashboard_on_off_setting FF](gitlab-org/gitlab@7b77f2f701883976f358bcc1d60c74658816feb2) ([merge request](gitlab-org/gitlab!134619)) **GitLab Enterprise Edition**
- [Silent Mode - Remove experiement badge](gitlab-org/gitlab@9ea56545101b0096b6e4429378206b71648c709b) ([merge request](gitlab-org/gitlab!134310))
- [Remove columns from users and application settings](gitlab-org/gitlab@715c7fafbf030d3d8c3f47c2fda26754908b431e) ([merge request](gitlab-org/gitlab!134525))
- [Remove the tasks to be done worker](gitlab-org/gitlab@49a5263ac695d702b6f158fef08bef3c6f0f764d) ([merge request](gitlab-org/gitlab!134182))

### Security (10 changes)

- [Update RedCloth gem to include CVE fix](gitlab-org/gitlab@92bdc9027bd69b88d05f0650653c6a4a809761e1) ([merge request](gitlab-org/gitlab!132834))
- [Proxy asset URLs with protocol but no slashes](gitlab-org/gitlab@a6aeed7442b82330d8321af21624a1bdb3c64847) ([merge request](gitlab-org/gitlab!135146))
- [Fix infinite loop when finding component project](gitlab-org/gitlab@1d815423cda7c757d37a6c7eb827b3363dd55b91)
- [Add abuse detection for pipes](gitlab-org/gitlab@b25b9d215c347ceb6691245018d8c967cf5c8ac6)
- [Remove FIFO files from tarball extract](gitlab-org/gitlab@a932d4fc24a0a143466391422cc101a3c49ac503)
- [Guard gitlab_version_check helper](gitlab-org/gitlab@c64544230e9c6b40c7a94a73e903edfecb874573)
- [Add the environment action to the CI JWT token fields](gitlab-org/gitlab@b3b9fa2a0d565071ba8942682e443d38a1de0b48)
- [Prevent unprivileged user assignment in templated projects](gitlab-org/gitlab@945cf506eb9d861361f2db6a68a31ffb63b8bed0)
- [Fixes Service Desk email template issue description privileges](gitlab-org/gitlab@480f7bc4bc43251154c342318aee82d3d82cb2f9)
- [Update sidekiq to 6.5.12](gitlab-org/gitlab@674319bcc8c4aacbccf40abcf2161c813a3fd51e) ([merge request](gitlab-org/gitlab!133042))

### Performance (10 changes)

- [Fix cross-join test failure for ApprovalProjectRule method](gitlab-org/gitlab@723c0bd50cdf6304be0454ab1b7390df915756a8) ([merge request](gitlab-org/gitlab!136619))
- [Enable and remove the FF ci_fix_performance_pipelines_json_endpoint](gitlab-org/gitlab@35dd6274a35df0c5d31416a48da0fb64d8df039a) ([merge request](gitlab-org/gitlab!136044))
- [Remove notes count from network graph](gitlab-org/gitlab@40e6cc27e42684071f50fdb305b471ec1276f14e) ([merge request](gitlab-org/gitlab!135716))
- [Use InOperatorOptimization module on standards adherence dashboard](gitlab-org/gitlab@7844ce1b1c7ff0e52737378ba4ddac85adf3b76a) ([merge request](gitlab-org/gitlab!134871)) **GitLab Enterprise Edition**
- [Increase GraphQL client timeout](gitlab-org/gitlab@9cd03f642c06593572030fdfe1bca993c50bd872) ([merge request](gitlab-org/gitlab!135477))
- [Add index to catalog_resources on state](gitlab-org/gitlab@d42bf0fd9eaffb846cf9cd92b882d5ce74006f06) ([merge request](gitlab-org/gitlab!135002))
- [Drop an index in deployments table](gitlab-org/gitlab@29a5f924cdad0f570bc2b16964b12e324ac90dd1) ([merge request](gitlab-org/gitlab!135310))
- [perf: Improve performance of create_package_service_spec](gitlab-org/gitlab@df49f2d6a8273c0a74c3fc035b02a3c6efd1c35d) by @gerardo-navarro ([merge request](gitlab-org/gitlab!134367))
- [Removing offending line to see what pipeline issues arise](gitlab-org/gitlab@cabf3d47ef6da9357faaed3963e7e3677966daeb) ([merge request](gitlab-org/gitlab!134346))
- [Security findings performance improvements](gitlab-org/gitlab@b085e3f2e3e8094e7e5bbb9404d953a2dfe8bea5) ([merge request](gitlab-org/gitlab!134470)) **GitLab Enterprise Edition**

### Other (58 changes)

- [Cleanup package metadata feature flags](gitlab-org/gitlab@826878a7f52430e05d5fd894e5209b9c5a92c5e3) ([merge request](gitlab-org/gitlab!135980))
- [Drops unused index from namespaces](gitlab-org/gitlab@b649aa6f416c9cf672df45dcf3e0a537eda1bcaa) ([merge request](gitlab-org/gitlab!135040))
- [Denormalize visibility_level column on catalog_resources](gitlab-org/gitlab@7dc643f44440491879b33bf1fd200e50835e5ab7) ([merge request](gitlab-org/gitlab!136111))
- [Remove FF use_pipeline_wizard_for_pages](gitlab-org/gitlab@e4b24e5cde1467806705dff633f83a3637f25c6b) ([merge request](gitlab-org/gitlab!135952))
- [Remove FF create_deployment_only_for_processable_jobs](gitlab-org/gitlab@750f8fd6df5d65831992b730e9ef6d58620a4b55) ([merge request](gitlab-org/gitlab!135540))
- [Remove admin_group_member FF](gitlab-org/gitlab@a51ca2927a1699780c4a84a554d53eb9a4791830) ([merge request](gitlab-org/gitlab!136247)) **GitLab Enterprise Edition**
- [Remove feature flag `data_transfer_monitoring_mock_data`](gitlab-org/gitlab@054aa902775f5b35adf652a65c0d1c7ee4d88dec) ([merge request](gitlab-org/gitlab!135594))
- [Update the mr doc](gitlab-org/gitlab@181b1156fd2404542b9522b09200acf85ecf2ed3) ([merge request](gitlab-org/gitlab!136281))
- [Remove all scope from GitClassProxy](gitlab-org/gitlab@b5ca9d40d7c6d8b4106dd8648886098e4c72a821) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/135988)) **GitLab Enterprise Edition**
- [Clarify component paths and directory structure](gitlab-org/gitlab@cf7bdb793fb443a619de85f77564c0756bbb230b) ([merge request](gitlab-org/gitlab!136052))
- [Initialize bigint conversion for system_note_metadata](gitlab-org/gitlab@c3c7e7ef1f2780ac515233d0f1118d0868b1622b) ([merge request](gitlab-org/gitlab!135322))
- [Reduce duplicate job key TTL from 6 hrs to 10 mins](gitlab-org/gitlab@6d94dc2dbab9268b8343f0395a292a9e5897dcf2) ([merge request](gitlab-org/gitlab!135910))
- [Dropping repositories columns from geo_node_statuses table](gitlab-org/gitlab@5335aeadcb13f52b7dafe10f86a4aff0a6941bab) by @TamsilAmani ([merge request](gitlab-org/gitlab!136048))
- [Make BulkImports workers retriable](gitlab-org/gitlab@82d7b88d521422a88722ea12a3f754f5542b7de6) ([merge request](gitlab-org/gitlab!135946))
- [Doc: non-public email is used for commit match](gitlab-org/gitlab@08fe198ea3d9e543532b81623150831d74ebd686) ([merge request](gitlab-org/gitlab!135967))
- [Make Direct Transfer export workers retriable](gitlab-org/gitlab@8854e7ab0f26f5e264396c58f61c7b3b09513931) ([merge request](gitlab-org/gitlab!135841))
- [Bump devise version to 4.9.3](gitlab-org/gitlab@80ed670d0538089f5c2207dd294251a32a1f8f1a) ([merge request](gitlab-org/gitlab!135997))
- [Update sentry gems to 5.12.0](gitlab-org/gitlab@7384ec11c36ded984d36d10d165305c8964da9dc) ([merge request](gitlab-org/gitlab!135998))
- [Replace redigo with go-redis](gitlab-org/gitlab@7aeddaa3b0a3d2df94bf7ba413fc28c6a07f790a) ([merge request](gitlab-org/gitlab!134596))
- [Remove feature flag definition file](gitlab-org/gitlab@727ab32ee566d5316656897db474c57e40e62082) ([merge request](gitlab-org/gitlab!135024))
- [Replace database_cleaner with database_cleaner-active_record](gitlab-org/gitlab@e7ddefb2218b75d463c08523876fcdcbc996c506) ([merge request](gitlab-org/gitlab!135866))
- [Include author username in avatar on Repository](gitlab-org/gitlab@643b56c597e5b6bf76bc8fdb3cd38fc02800f8fc) ([merge request](gitlab-org/gitlab!135595))
- [Update wiki search query to filter archived project results](gitlab-org/gitlab@7e09769c41c8b898f7d134aed8a787e51ba8ddc2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/126145)) **GitLab Enterprise Edition**
- [Enable GitLab HTTP_V2](gitlab-org/gitlab@ee05188136dea697aa1dbd42e302c9d4a250c65c) ([merge request](gitlab-org/gitlab!135812))
- [Use Tooling::FindChanges for scripts/lint-doc.sh](gitlab-org/gitlab@8b21118a54eda9316f6ddb1bb2beacd119637e0e) by @Taucher2003 ([merge request](gitlab-org/gitlab!135434))
- [Remove alignment rule for header actions](gitlab-org/gitlab@5e6fb5f687b6bcd8cbac4b63fadf327f54a796a0) ([merge request](gitlab-org/gitlab!134568))
- [Improve color contrast ratio to pass WCAG recomendation](gitlab-org/gitlab@c42992588600dc00f923286cc0e41707da8df20b) ([merge request](gitlab-org/gitlab!135131))
- [refactor: Rename helper file to be consistent with its module name](gitlab-org/gitlab@d1098385d76b13111afe9bb3a9310da5d4ea8a8a) by @gerardo-navarro ([merge request](gitlab-org/gitlab!135488))
- [Remove temp index](gitlab-org/gitlab@dead4b3f87efd1c4f129f6fb279e367d42c1f109) by @TamsilAmani ([merge request](gitlab-org/gitlab!135473))
- [Drop an unused index for GitLab.com](gitlab-org/gitlab@2f279f8247795e597bc3fe8db17235b2f3a020f9) ([merge request](gitlab-org/gitlab!134948))
- [Re-add unique index on design_user_mentions](gitlab-org/gitlab@56e201dd865750d26e2e4f1f5e351e1ca654d844) ([merge request](gitlab-org/gitlab!135435))
- [Remove :vulnerability_report_grouping feature flag](gitlab-org/gitlab@c51ceef7cbd6f1cdf9b2600b788017da01104d8f) ([merge request](gitlab-org/gitlab!135113)) **GitLab Enterprise Edition**
- [Remove log_verification_user_not_found method from identity verification](gitlab-org/gitlab@24298f70288605273a460402669fd44d2d43b0ce) ([merge request](gitlab-org/gitlab!135201)) **GitLab Enterprise Edition**
- [Adds cop to ensure mandatory keys in bbm dictionary](gitlab-org/gitlab@29232983a5a3f57d50a94dcbc3bbcd843a9dcbd5) ([merge request](gitlab-org/gitlab!132639))
- [Cleanup feature flag `verify_push_rules_for_first_commit`](gitlab-org/gitlab@6aee40900ae48c66da18fdc61149253378eccfea) ([merge request](gitlab-org/gitlab!135266))
- [test: Adjust feature category to package registry](gitlab-org/gitlab@31851d639140b1ec9ce242a4a8e7e9a5b59d456b) by @gerardo-navarro ([merge request](gitlab-org/gitlab!135223))
- [Remove super_sidebar_nav_enrolled feature flag](gitlab-org/gitlab@149ecef3f0c1e73e242b50a253efd3d1d474d085) ([merge request](gitlab-org/gitlab!135214))
- [Unite Clickhouse CI data ingestion FF](gitlab-org/gitlab@007a0720e26c43e399801feb76441bf119a59d72) ([merge request](gitlab-org/gitlab!135145))
- [Display username on smaller screens](gitlab-org/gitlab@9b0f370a789b675f50c62815a48660c8c4d4dc7d) ([merge request](gitlab-org/gitlab!133984))
- [Remove cached_security_policies feature flag](gitlab-org/gitlab@c63386db2d0c6548f3824ec8ab46f4bb5dbb58ae) ([merge request](gitlab-org/gitlab!135053)) **GitLab Enterprise Edition**
- [Drop the old unique index on approval merge request rule table](gitlab-org/gitlab@e8a520732b4e29cf06526dbd77ff6f5128796c4e) ([merge request](gitlab-org/gitlab!134155))
- [Replace kebab menu with x for work item child](gitlab-org/gitlab@fff847ce09e2031d89c71fb07f8456106cf33828) ([merge request](gitlab-org/gitlab!134721))
- [Cascade auto_canceled_by_partition_id to canceled jobs](gitlab-org/gitlab@62e08dbfe1769f54bef9043c4edc1e9b6a42fa21) ([merge request](gitlab-org/gitlab!134966))
- [Add auto_canceled_by_partition_id to p_ci_builds for self-managed](gitlab-org/gitlab@ea4b8b2ce5311d5dc480cbebc1a11b49212d339d) ([merge request](gitlab-org/gitlab!134732))
- [Drop the use of namespace in Sidekiq and Mailroom delivery](gitlab-org/gitlab@619d0648448154c4f53e00dae4d15e5ec67d0187) ([merge request](gitlab-org/gitlab!133070))
- [Add tracking to the pipeline IID dropdown](gitlab-org/gitlab@40d732aa63937fb7ba91a1f171aad834e9ff3031) ([merge request](gitlab-org/gitlab!134685))
- [Add an endpoint for internal/zoekt/callback](gitlab-org/gitlab@c5fcfe0328ffd5e12a05068a7f9dafbf2af0f156) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/134763)) **GitLab Enterprise Edition**
- [Use less attributes for builds initialization](gitlab-org/gitlab@866f6d22c34a7f51dfd724af194de492d78e4bf0) ([merge request](gitlab-org/gitlab!134378))
- [Cleanup geo_registries_update_mutation FF](gitlab-org/gitlab@47c3822a514f34e8368ab20820add73e16b80502) ([merge request](gitlab-org/gitlab!134548))
- [Fixed shortcut test](gitlab-org/gitlab@da0a329a48734caac8d82b2bb60c22cef2640ca3) ([merge request](gitlab-org/gitlab!134245))
- [Migrate SubmitDropdown to GlDisclosureDropdown](gitlab-org/gitlab@39f4f9ea23365848a00f0eb1e3291a3461e8c270) ([merge request](gitlab-org/gitlab!133067))
- [Added generated column to diff files](gitlab-org/gitlab@b15140ea159f4abe9fa60a90cd20570c69d3d979) ([merge request](gitlab-org/gitlab!127119))
- [Check if work item hierarchy widget link redirects properly](gitlab-org/gitlab@fc81ee927cf39ed3e897c70692841604f700b7ed) ([merge request](gitlab-org/gitlab!134486)) **GitLab Enterprise Edition**
- [Remove unnecessary EntityWorker calls](gitlab-org/gitlab@a46b23c2faaed9ac491d986c95afb436fed540b3) ([merge request](gitlab-org/gitlab!134434))
- [Drops unused idx namespaces_on_shared_and_extra_runners_minutes_limit](gitlab-org/gitlab@19ee2784b010ec4e2cc1e1683e041ef165f8e5be) ([merge request](gitlab-org/gitlab!134505))
- [Raise rate limit error with type](gitlab-org/gitlab@68e071cdea7a7874f4975d1555c384ef920c0dee) ([merge request](gitlab-org/gitlab!134511))
- [Remove pubsub migration helper for actioncable](gitlab-org/gitlab@763ca1305db6f1c9cf6700b8497494a81926d742) ([merge request](gitlab-org/gitlab!133066))
- [Use partitioned table for CommitStatus](gitlab-org/gitlab@063826e042778995fae13928a2fb5de2c8855b45) ([merge request](gitlab-org/gitlab!134489))

## 16.5.10 (2024-09-20)

No changes.

## 16.5.9 (2024-07-23)

### Added (1 change)

- [Add Rake task to show token expiration info](https://gitlab.com/gitlab-org/gitlab/-/commit/38e92182768a2727bd93e71988af72841e66f606) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159093))

### Fixed (1 change)

- [Update an expired test certificate](https://gitlab.com/gitlab-org/gitlab/-/commit/e4940da36a2ce954bec919de96b0cbaa15f2e8f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156399))

### Changed (2 changes)

- [Add a banner informing about token expiration](https://gitlab.com/gitlab-org/gitlab/-/commit/d41286dccd5eccef58cf04a76e7b743fced6e2ea) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158110))
- [Do not enqueue PAT expiry enforcement migration](https://gitlab.com/gitlab-org/gitlab/-/commit/43329df2117133bb8841acdfd67b3c912ebf4e97) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153459))

### Other (1 change)

- [Clear instance value](https://gitlab.com/gitlab-org/gitlab/-/commit/cb2000d3a93c8e3b98213d0e23291a2d4331c2c6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160245))

## 16.5.8 (2024-01-24)

### Security (1 change)

- [Devfile parser arbitrary file write](gitlab-org/security/gitlab@0a831ae0ed0eb32b42ab69652010815e9dffec51) ([merge request](gitlab-org/security/gitlab!3802))

## 16.5.7 (2024-01-13)

### Fixed (1 change)

- [Make chat_names table migration idempotent](gitlab-org/gitlab@1a2ac58037d06717b9a27f5b2a6a9e5ec887d374) ([merge request](gitlab-org/gitlab!141706))

## 16.5.6 (2024-01-11)

### Fixed (1 change)

- [Add missing ci_sources_pipelines indexes for self-host](gitlab-org/security/gitlab@bcc8c8f2b4c3fec3288cba0d3e69d22ebc519dfb) ([merge request](gitlab-org/security/gitlab!3811))

### Security (4 changes)

- [Consider older commits when resetting codeowner approvals](gitlab-org/security/gitlab@6a7a49ba29793e1a3454f56dee47b584938c6c46) ([merge request](gitlab-org/security/gitlab!3766))
- [Password reset followups](gitlab-org/security/gitlab@0043a2acd829accf42e8bb61dbf5aaa2a2bb3e22) ([merge request](gitlab-org/security/gitlab!3779))
- [Add verification layer for BaseSlash commands](gitlab-org/security/gitlab@d8293ba365c85465f5fe02ac2edc6d22714a9946) ([merge request](gitlab-org/security/gitlab!3758))
- [Ensure workspaces are created under same root namespace as agent](gitlab-org/security/gitlab@59391fdf8a15807c28e68136279e348bd29d572a) ([merge request](gitlab-org/security/gitlab!3761))

## 16.5.4 (2023-12-13)

### Fixed (1 change)

- [Truncate verification failure message to 255](gitlab-org/security/gitlab@640f8fa1b9ac91767b25992be646b8369fe41e09) **GitLab Enterprise Edition**

### Security (8 changes)

- [Prevent tag names starting with SHA-1 and SHA-256 values](gitlab-org/security/gitlab@2a67d2efe432eeb1264ffe3dd5e0625c364d3d4b) ([merge request](gitlab-org/security/gitlab!3747))
- [Pass encoded file paths to router](gitlab-org/security/gitlab@7299f46a651db01f451694bf7b801ae8af672592) ([merge request](gitlab-org/security/gitlab!3736))
- [Validate access level of user while rotating token](gitlab-org/security/gitlab@4a1ca1e3f95d858966ef1f985925c57f70923e17) ([merge request](gitlab-org/security/gitlab!3751))
- [Fix large time_spent value causing GraphQL error `Integer out of bounds`](gitlab-org/security/gitlab@a87f5d04de526fbed7ecbf6ed8d44db356076826) ([merge request](gitlab-org/security/gitlab!3744))
- [Restrict Protected branch access via group to direct members](gitlab-org/security/gitlab@22fd1a0d19f49c761fb20f80c326fa8658c962f7) ([merge request](gitlab-org/security/gitlab!3727))
- [Remove the ability to fork and create MR for auditors](gitlab-org/security/gitlab@1a9d9490b3cf0e91321a90333d3f79ed275df4c0) ([merge request](gitlab-org/security/gitlab!3739))
- [Restrict passing variables on the pipeline schedule API](gitlab-org/security/gitlab@eeb86c57a3b09b04659cb3d1300e396bdd51db58) ([merge request](gitlab-org/security/gitlab!3724))
- [Smartcard auth: encrypt client cert in params](gitlab-org/security/gitlab@4ca907081651de95bcb392ee2ca2626dd7679f36) ([merge request](gitlab-org/security/gitlab!3730))

## 16.5.3 (2023-11-30)

### Security (11 changes)

- [Validate adding members with higher role](gitlab-org/security/gitlab@4159a01ca7dfca9856a0ce404fcba8459382b104) ([merge request](gitlab-org/security/gitlab!3714))
- [Enforce ref protection on pipeline schedule updates](gitlab-org/security/gitlab@4bafe829109bedb1d31f1c28eccafa425083c297) ([merge request](gitlab-org/security/gitlab!3656))
- [Update mermaid version for DOS security fixes](gitlab-org/security/gitlab@641557519046d680bf8916a60b66c3d6020b1b88) ([merge request](gitlab-org/security/gitlab!3673))
- [Prevent guest users from being able to add emojis in confidential issues](gitlab-org/security/gitlab@f6fe0644a285e323b0469510a69c8d01d7fbe2a7) ([merge request](gitlab-org/security/gitlab!3690))
- [Do not run ssl cert validation if key has errors](gitlab-org/security/gitlab@dcd5a3dcafc8ec943b78b43b8898201b5a9c4de5) ([merge request](gitlab-org/security/gitlab!3661))
- [Ensure access is checked when loading releases associated with tags](gitlab-org/security/gitlab@1d1a454147e80ea27cee382743cfff9e9041d0fe) ([merge request](gitlab-org/security/gitlab!3695))
- [XSS and ReDoS in Markdown via Banzai pipeline of Jira](gitlab-org/security/gitlab@13cae16669e25b1f7a889ca3fdc5d08c5a6d28a2) ([merge request](gitlab-org/security/gitlab!3691))
- [Prevent branch names starting with SHA-1 and SHA-256 values](gitlab-org/security/gitlab@bd18a249dbae6dc362dc5ecad26c61eb69407d78) ([merge request](gitlab-org/security/gitlab!3687))
- [Filter out projects with disabled package registry in Composer finder](gitlab-org/security/gitlab@1d7e1de18c0ce2bf380f44aa777566dd61919a25) ([merge request](gitlab-org/security/gitlab!3682))
- [Check max role for user for group access to protected ref](gitlab-org/security/gitlab@d3eef816a353bb0a4fb611a91c1cf0af6d9006bf) ([merge request](gitlab-org/security/gitlab!3646))
- [Treat security policy bots as external](gitlab-org/security/gitlab@f16c6f2b80bd70d04a304b0441da2642dd32abe5) ([merge request](gitlab-org/security/gitlab!3676))

## 16.5.2 (2023-11-14)

### Fixed (4 changes)

- [Fix assign security check permission checks](gitlab-org/gitlab@41d0d45a2abd8621ef55042eb0bc54343a48f2da) ([merge request](gitlab-org/gitlab!136434)) **GitLab Enterprise Edition**
- [Create group wiki repo if absent when verifying on primary](gitlab-org/gitlab@0b490bdbda06febdda47b2e0e0cea1d9e52dd381) ([merge request](gitlab-org/gitlab!136243)) **GitLab Enterprise Edition**
- [Fix broken issue rendering when initial ID is null](gitlab-org/gitlab@9f9fafbe202c5f5f591f689e295f62b01b8d40fc) ([merge request](gitlab-org/gitlab!136065))
- [Backport artifacts page breadcrumb fixes](gitlab-org/gitlab@4f15baf84a8de9068fa5c2c6af47fc74d2a46df8) ([merge request](gitlab-org/gitlab!135195))

## 16.5.1 (2023-10-30)

### Fixed (1 change)

- [Revert "Merge branch '419642-better-error-messages-for-pull-mirroring' into 'master'"](gitlab-org/security/gitlab@08ae4b9d3814a05631d9b486fea1d4353a702a7d) by @Taucher2003

### Security (7 changes)

- [Fix infinite loop when finding component project](gitlab-org/security/gitlab@9f9f87376e23c3f7aab74348c47f7401ac2d78ee) ([merge request](gitlab-org/security/gitlab!3665))
- [Guard gitlab_version_check helper](gitlab-org/security/gitlab@35c8592afc0225653677a00c545043eb7212a6d4) ([merge request](gitlab-org/security/gitlab!3652))
- [Add the environment action to the CI JWT token fields](gitlab-org/security/gitlab@cdfcea2200b0a18b9972ffd2acd9630089022f8e) ([merge request](gitlab-org/security/gitlab!3648))
- [Remove FIFO files from tarball extract](gitlab-org/security/gitlab@c284870b8f1ffcc9697ea34c8bd3b7314040e39c) ([merge request](gitlab-org/security/gitlab!3644))
- [Backport add abuse detection for pipes](gitlab-org/security/gitlab@1720c5ba557946e5805719deaaf0b9834f1a91d6) ([merge request](gitlab-org/security/gitlab!3647))
- [Prevent unprivileged user assignment in templated projects](gitlab-org/security/gitlab@b74af1395876a4ffb32f692f090b268815e75afd) ([merge request](gitlab-org/security/gitlab!3645))
- [Fixes Service Desk email template issue description privileges](gitlab-org/security/gitlab@097a300ac6144f0b80dfa3bc4aea73410ef74cb1) ([merge request](gitlab-org/security/gitlab!3641))

### Other (1 change)

- [Update migration to drop column only if it exists](gitlab-org/security/gitlab@36bcb0e41d37aa92457f60ee1016bd32003da2f6)

## 16.5.0 (2023-10-20)

### Added (140 changes)

- [Add branch field to Telegram integration](gitlab-org/gitlab@dd8eb28a06c7f518128a417183d5a0ebd82f14cf) ([merge request](gitlab-org/gitlab!134361))
- [Add validation for restrictions on work item links](gitlab-org/gitlab@6bc0197872b732b341ec424dca33b852373dd5d8) ([merge request](gitlab-org/gitlab!133618))
- [Optimize index for adjourned project deletion](gitlab-org/gitlab@e8f7386b48cc9ec58e713633628f3385ba26175e) ([merge request](gitlab-org/gitlab!134438))
- [Add parent widget to work items](gitlab-org/gitlab@097b46575a40c0678e3dc2602a751ef5299dcb69) ([merge request](gitlab-org/gitlab!133426)) **GitLab Enterprise Edition**
- [VSD drill-down links inherit labels from panel filter](gitlab-org/gitlab@4ff4f4707656a6a317d33feb33a2fce8d06feed3) ([merge request](gitlab-org/gitlab!133899)) **GitLab Enterprise Edition**
- [Increased the limit of linked items that can be added at the time](gitlab-org/gitlab@50610ceb942d8cce85fd40e44d9c6f9a3ed781ff) ([merge request](gitlab-org/gitlab!134295))
- [feat: Add graphql query for package protection rules](gitlab-org/gitlab@19eee23b8152e9963b0457653f98b2e0e19aa194) by @gerardo-navarro ([merge request](gitlab-org/gitlab!127022))
- [Hide snippets of banned users](gitlab-org/gitlab@817389ee1f67495a55ce773be2d0b3f585ecf7c8) ([merge request](gitlab-org/gitlab!134048))
- [Add counts with no DORA data within scope](gitlab-org/gitlab@8f2aae7efda5a5e24329c759119714344d235bcc) ([merge request](gitlab-org/gitlab!132516)) **GitLab Enterprise Edition**
- [Adds notes to abuse reports backend](gitlab-org/gitlab@1fac5166c60eb8ba756c4475bbdd10a889cb538b) ([merge request](gitlab-org/gitlab!132505))
- [Enable the print_wiki feature flag by default](gitlab-org/gitlab@36a7604df43d31dc32d9a0923bf45d4bddcb16df) ([merge request](gitlab-org/gitlab!134251))
- [Convert user columns in projects to LFKs](gitlab-org/gitlab@474c09f1551f68b7bc50470c3568fb5c40046a60) ([merge request](gitlab-org/gitlab!134246))
- [Add Cloud Connector service design doc](gitlab-org/gitlab@b27c39cc92aaaf34e0070a603dabff054610d7dd) ([merge request](gitlab-org/gitlab!132977))
- [Add ancestors field to hierarchy widget](gitlab-org/gitlab@3228bc7cea360051b7b481ad6d68c24f98f44086) ([merge request](gitlab-org/gitlab!134134))
- [Adding GraphQL endpoint for blocking merge requests](gitlab-org/gitlab@c6efc1902b72dc186698493938f9b6b03b85f538) ([merge request](gitlab-org/gitlab!132595)) **GitLab Enterprise Edition**
- [Enable Global Search For Epics](gitlab-org/gitlab@177df761e74e193a299ace78e65437bceb772aae) by @sd5869 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/130146)) **GitLab Enterprise Edition**
- [Allow container registry with disabled repository](gitlab-org/gitlab@93b7760e92dcb796acf0ada23091e9c17d655fbd) by @Taucher2003 ([merge request](gitlab-org/gitlab!133117))
- [Boilerplate for /-/ml/models/{model_id}](gitlab-org/gitlab@1995f12860bcba5f2c2758fe71a46f4fec9aeee3) ([merge request](gitlab-org/gitlab!133991))
- [Remove the server_side_frecent_namespaces feature flag](gitlab-org/gitlab@19e89ed7483da931be3227ab00d16a041628bcfa) ([merge request](gitlab-org/gitlab!133830))
- [Add container scanning properties](gitlab-org/gitlab@8c780a41b47515bc89f4341153ab2ee9ff8ed276) ([merge request](gitlab-org/gitlab!134004))
- [Add "Manage Project Access Tokens" custom permission](gitlab-org/gitlab@ff70f0d2da50b10e0da6ca6cb900309ded42fd47) ([merge request](gitlab-org/gitlab!132342)) **GitLab Enterprise Edition**
- [Create notes for new issuable links in async job](gitlab-org/gitlab@593c625f040c8880e3db2ed6910a8d72007e3c21) ([merge request](gitlab-org/gitlab!133107))
- [Prevent delete protected branches via security policies](gitlab-org/gitlab@d3a48362d978666d8f94f89fd8cba94a3401712a) ([merge request](gitlab-org/gitlab!132365)) **GitLab Enterprise Edition**
- [Support HTML in merge request review AI summary](gitlab-org/gitlab@ea9952f5c7c853adff1b8175279f5c314a62f18f) ([merge request](gitlab-org/gitlab!131048))
- [Remove the verification_reminder feature flag](gitlab-org/gitlab@9b25cc7dfe55c58d8a512bca56828fca609adc02) ([merge request](gitlab-org/gitlab!134116)) **GitLab Enterprise Edition**
- [Add default related link restrictions](gitlab-org/gitlab@2e305bfc9c05b6bdc6a2cc195377a3ec9cb0d6b7) ([merge request](gitlab-org/gitlab!133452))
- [Enable Vulnerability Report Grouping feature flag by default](gitlab-org/gitlab@0bc05fd0dd6ea5af5c41bfc1afa851ce68ea0259) ([merge request](gitlab-org/gitlab!134073)) **GitLab Enterprise Edition**
- [Trigger webhook on delete release event](gitlab-org/gitlab@6f5d8853f6991c738088e6be5abe5bc6438f12be) ([merge request](gitlab-org/gitlab!133769))
- [Establishes dependency between migrations and BBMs](gitlab-org/gitlab@9960c097b8a0f471c89fe4e84edaf5e46b3cae8a) ([merge request](gitlab-org/gitlab!133436))
- [Add status_message to package graphql payload](gitlab-org/gitlab@efb56e85bcc3c8b1a86e2cc834e7b16599ad978e) ([merge request](gitlab-org/gitlab!134183))
- [Add manage group members as custom permissions](gitlab-org/gitlab@2a66fd0fe29c35a6704682a3319f7412fca5f61a) ([merge request](gitlab-org/gitlab!131914)) **GitLab Enterprise Edition**
- [Add option to turn off math rendering limits](gitlab-org/gitlab@d791fc39a138be158d9d94a259e9352ab43aa20f) ([merge request](gitlab-org/gitlab!132939))
- [Add support for group mention events to Discord integration](gitlab-org/gitlab@90faff675a6f8634b6cb5db597ee5cff62da452a) by @Taucher2003 ([merge request](gitlab-org/gitlab!133241))
- [Remove api_keyset_pagination_multi_order FF](gitlab-org/gitlab@e2b4e1afc0f7c861e5ed827fce96e0f9a0763257) ([merge request](gitlab-org/gitlab!134112))
- [Adding new scope for_package_name for package protection rule](gitlab-org/gitlab@e36e21a7d186818f814f32b65abc64077b15c38c) by @gerardo-navarro ([merge request](gitlab-org/gitlab!131298))
- [Add database indexes for hashed in user_credit_card_validations](gitlab-org/gitlab@1d1fce2f99a92008ad1a563e983d18c13237d003) ([merge request](gitlab-org/gitlab!133586))
- [Remove batch_delay_jira_branch_sync_worker feature flag](gitlab-org/gitlab@77ddbf13934a84d683e5a56b054a5f874ca807cf) ([merge request](gitlab-org/gitlab!134062))
- [feat: Introducing basics for protecting containers](gitlab-org/gitlab@72a5d5ab4a2412d699811f79cdb0433135e9c6c6) by @gerardo-navarro ([merge request](gitlab-org/gitlab!133297))
- [GraphQL API for updating audit event streaming amazon_s3_configurations](gitlab-org/gitlab@df5e82018f62fdd50a0e991787ffc65c56f25060) ([merge request](gitlab-org/gitlab!133691)) **GitLab Enterprise Edition**
- [Enable new Service Desk list by default](gitlab-org/gitlab@3d6ee64b9fee9961516e81ef36d848aebaef59ca) ([merge request](gitlab-org/gitlab!133938))
- [Add ambiguous ref modal](gitlab-org/gitlab@2fe5995123ecc0fdd1ac481fa93eb0975bb1df91) ([merge request](gitlab-org/gitlab!132749))
- [Add push/pull token for rename API](gitlab-org/gitlab@768ec2198bd2b09b175e262b01b599a644b62277) ([merge request](gitlab-org/gitlab!132083))
- [Adding update api for instance GCP](gitlab-org/gitlab@dd2f044da25478d0381412bb35881e40380e6827) ([merge request](gitlab-org/gitlab!131790)) **GitLab Enterprise Edition**
- [Implement mergeabilityChecks GraphQL field](gitlab-org/gitlab@c16194692d10f2e75ecbe8f2fa63020c75c5beaa) ([merge request](gitlab-org/gitlab!132349))
- [Add a tooltip to include archived filter](gitlab-org/gitlab@86348d73567f903107a135bceea8ae5af2c8c268) ([merge request](gitlab-org/gitlab!132357))
- [Add migration for locking on login attempts settings](gitlab-org/gitlab@21c24e113ae778ff0284c40f12f7f4984bd5b75b) ([merge request](gitlab-org/gitlab!132023))
- [Remove declarative policy gem cached attributes patch](gitlab-org/gitlab@c7315a0216e6fd70e62f30a16f2f0180d4b891a0) ([merge request](gitlab-org/gitlab!133966))
- [Reads mail-key from CC in general email receiver](gitlab-org/gitlab@3c783d153aeb030e32b6def01930512c1b9d9224) ([merge request](gitlab-org/gitlab!129700))
- [Add configurable API requests setting](gitlab-org/gitlab@803370b5402a71dee60e27bc39c0fcc0a37fc93e) ([merge request](gitlab-org/gitlab!129319))
- [Add rails support for GetFileAttributes RPC](gitlab-org/gitlab@952df82ca0c0da0f8f0ab777a60ad6517d8e5971) ([merge request](gitlab-org/gitlab!133935))
- [Hide snippets of banned users](gitlab-org/gitlab@558e692072a740918f75ff00ffbc223314e85b86) ([merge request](gitlab-org/gitlab!131725))
- [Add add_child quick action for work items](gitlab-org/gitlab@e86161d60d42af5013901e5c60a6b3876167d392) ([merge request](gitlab-org/gitlab!132761))
- [Cleanup index_nuget_symbol_files feature flag](gitlab-org/gitlab@1d1f2cda29795801a691872461d7e8ea4a662338) ([merge request](gitlab-org/gitlab!133884))
- [Adds pagination to model index](gitlab-org/gitlab@f1218171dc66bed2cda8fcdccc3f94b71b074848) ([merge request](gitlab-org/gitlab!133331))
- [Add remediations filter to finder](gitlab-org/gitlab@ce44a611ba0b3d48913fce9dcf0f12534c0b5bd9) ([merge request](gitlab-org/gitlab!133491)) **GitLab Enterprise Edition**
- [Expose `has_failures` attribute in Direct Transfer API](gitlab-org/gitlab@6276fdd741330ea53db27ea943e8d11b6fcbbae9) ([merge request](gitlab-org/gitlab!133838))
- [Add deployment events as supported by discord integration](gitlab-org/gitlab@ec3c150ec7224b52204d5d1bd6b14837016354c3) by @Taucher2003 ([merge request](gitlab-org/gitlab!133142))
- [Added missing states to GraphQL UserState](gitlab-org/gitlab@cfe1c497d301bbbe935132f785f76682671cf251) by @jboeijenga ([merge request](gitlab-org/gitlab!133398))
- [Enable fast-forward and semi-linear merge trains](gitlab-org/gitlab@d353265111691fcabf2abe39403a94b01b6f1ecc) ([merge request](gitlab-org/gitlab!133738))
- [feat: Add graphql mutation to create package protection rules](gitlab-org/gitlab@0d95435b652208652496d564cc55b7a9a7d83edf) by @gerardo-navarro ([merge request](gitlab-org/gitlab!125915))
- [Update vulnerability_reads after remediation creation](gitlab-org/gitlab@7fba7bb71888f8914828e10e63f76227a88223e6) ([merge request](gitlab-org/gitlab!129125))
- [Added possibility to filter notes on the GraphQL resolver](gitlab-org/gitlab@4cb8d02dc6ae15e6e85cb45c26b6c9532c0aadd0) by @zillemarco ([merge request](gitlab-org/gitlab!133538))
- [Disallow reserved domains from being verified](gitlab-org/gitlab@216a54ff68bb91012ade72d06d6bd37e1ace8340) ([merge request](gitlab-org/gitlab!129363)) **GitLab Enterprise Edition**
- [Updates model experiments visibility through API](gitlab-org/gitlab@f80247cc6aac9043ad713ceff00621e3adaebea2) ([merge request](gitlab-org/gitlab!132972))
- [Add support for pull request reviewers](gitlab-org/gitlab@908f3c34f1e3c8e4fc186451e860ec4379389235) ([merge request](gitlab-org/gitlab!132771))
- [Add clickhouse logs to production](gitlab-org/gitlab@f52dde4c50a77f7b58c2484962dc06ee8bf5f3b4) ([merge request](gitlab-org/gitlab!133371))
- [Add vulnerabilities column to sbom_occurrences](gitlab-org/gitlab@a55caeffc9dae6ea564ec03761b0e908ee04bc82) ([merge request](gitlab-org/gitlab!132981)) **GitLab Enterprise Edition**
- [Add export route and worker for CSV](gitlab-org/gitlab@9767c5b494d12bcb4d669ec1b55150f299b72772) ([merge request](gitlab-org/gitlab!133209)) **GitLab Enterprise Edition**
- [Change value streams project ids filter contraint](gitlab-org/gitlab@1600581239b15e93ee9efd8926ae58a91c6e6ed0) ([merge request](gitlab-org/gitlab!133515))
- [Added active param while header creation](gitlab-org/gitlab@a3370e03a30340bb633388e9fe7af65b92633b9d) ([merge request](gitlab-org/gitlab!129702)) **GitLab Enterprise Edition**
- [Add Enterprise group attributes to admin UI](gitlab-org/gitlab@327a0e3e8467e6cd67edaea67a8f5b99b5a9be94) ([merge request](gitlab-org/gitlab!132938)) **GitLab Enterprise Edition**
- [Index nuget symbol files](gitlab-org/gitlab@7117bfa2640c20d0b3da056d581d15f40dc80880) ([merge request](gitlab-org/gitlab!131567))
- [Adding feature for activating or deactivating headers](gitlab-org/gitlab@99b9661657eb305d2ea49fbc4a9de2648ca0e124) ([merge request](gitlab-org/gitlab!129704)) **GitLab Enterprise Edition**
- [Add scope and service for statistics usage export](gitlab-org/gitlab@eaaaed14da7dd26c034191e1470747d9d8c2d896) ([merge request](gitlab-org/gitlab!130857)) **GitLab Enterprise Edition**
- [Update epic hierarchy restrictions records](gitlab-org/gitlab@2c878c3720cfe515d9979535fac11db4de317de9) ([merge request](gitlab-org/gitlab!132352))
- [Add work items related link restrictions table](gitlab-org/gitlab@177339a7f54d6714214015c62d482b2302298b29) ([merge request](gitlab-org/gitlab!133044))
- [Add API for listing audit events amazon_s3_configurations for a group](gitlab-org/gitlab@23298c6caec6a57019fd9147e8172bd58c586a67) ([merge request](gitlab-org/gitlab!133464)) **GitLab Enterprise Edition**
- [Add integrations placeholder](gitlab-org/gitlab@2cb9b76129230ab47f36bfc9d4b6ac96ac7ef1c4) ([merge request](gitlab-org/gitlab!133456))
- [Add API for creating amazon_s3_configurations for audit event streaming](gitlab-org/gitlab@baeaaf490cf4745ea2d653fe0c30aedaf8321fb8) ([merge request](gitlab-org/gitlab!132443)) **GitLab Enterprise Edition**
- [Added syntax options drawer document](gitlab-org/gitlab@391b78a4bf56a1a624567a35caad01ae023543c1) ([merge request](gitlab-org/gitlab!132358)) **GitLab Enterprise Edition**
- [Expose access_locked? as locked](gitlab-org/gitlab@7b6a273ac3c0a8d8dd8f8d79ebfef9e0888ad758) ([merge request](gitlab-org/gitlab!132518))
- [Add new filters to issues completed count](gitlab-org/gitlab@109aeb545f0060654b5d37fc3b53d4ca8b9ed29c) ([merge request](gitlab-org/gitlab!133071)) **GitLab Enterprise Edition**
- [Add missing has_merge_request argument](gitlab-org/gitlab@f782aacbc1d19e1055c1f604bf0ac710d2e6f62c) ([merge request](gitlab-org/gitlab!133163)) **GitLab Enterprise Edition**
- [Remove linked item from the work item](gitlab-org/gitlab@57f0689bfa144b08e7d6ab15ad9b13e397af81ca) ([merge request](gitlab-org/gitlab!131555)) **GitLab Enterprise Edition**
- [Add set_parent quick action for work items](gitlab-org/gitlab@e7b3f38777d0e0287afb91abb0ad820ab569c5e8) ([merge request](gitlab-org/gitlab!132522))
- [Displays ai_features token only when available](gitlab-org/gitlab@91c88a935a4c85127353c38810f08f80db8dbc36) ([merge request](gitlab-org/gitlab!131873)) **GitLab Enterprise Edition**
- [Implement REST API to create (limited) PAT with PAT](gitlab-org/gitlab@ec9f199edd6d97813b08d71797ec8a648b0cb0df) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131923))
- [Schedule CronJob to refresh assigned users](gitlab-org/gitlab@6d6a22212f5fa3794e5141a00fd25637c1d000fb) ([merge request](gitlab-org/gitlab!132419)) **GitLab Enterprise Edition**
- [Allow to persist value stream settings](gitlab-org/gitlab@93d8e6d658932e97bbcb13f17f8314e5a6dbfc49) ([merge request](gitlab-org/gitlab!132996)) **GitLab Enterprise Edition**
- [Ingest CVSS vectors if given](gitlab-org/gitlab@406c6b6d676993e9ecd98d1e7444caaba5203338) ([merge request](gitlab-org/gitlab!132548)) **GitLab Enterprise Edition**
- [Update config_version & force_full_reconciliation for stale workspaces](gitlab-org/gitlab@63869e8bd05fcbf76b78059f4f6f0dfd0bc3d174) ([merge request](gitlab-org/gitlab!131402)) **GitLab Enterprise Edition**
- [Reschedule finding_id backfilling](gitlab-org/gitlab@22ea809ea0f5f8f49b87be278a2678e3dea1168f) ([merge request](gitlab-org/gitlab!133097))
- [Add feature to stream audit events to Amazon S3 destinations](gitlab-org/gitlab@76af11e0e6c6b589bedfed77805921828955c292) ([merge request](gitlab-org/gitlab!131372)) **GitLab Enterprise Edition**
- [Introduce new column on approval merge request rules](gitlab-org/gitlab@35bfac7addddb97ec6e206d5964d75a1769b7d80) ([merge request](gitlab-org/gitlab!132853))
- [Force include all resources logic for workspaces](gitlab-org/gitlab@bfde2566e0e84a67aacf77cdb5bbef901acffea5) ([merge request](gitlab-org/gitlab!132507)) **GitLab Enterprise Edition**
- [Support NuGet Delete Service](gitlab-org/gitlab@1fd66674cac6985aca7f91ecdf0eaa2785ddf774) ([merge request](gitlab-org/gitlab!132215))
- [Add regex validation to string CI inputs](gitlab-org/gitlab@3e4fcf052bb058b572a99b9c7160c8b9e1ed5cf0) ([merge request](gitlab-org/gitlab!132574))
- [Create table and model for value stream settings](gitlab-org/gitlab@794d6bc1a9c7e8603c6b517801133222c678a7c5) ([merge request](gitlab-org/gitlab!132650)) **GitLab Enterprise Edition**
- [Add foreign key for ci_stages.pipeline_id_convert_to_bigint](gitlab-org/gitlab@20db2eef58829d9252cd53e47a07e05b71e22c99) ([merge request](gitlab-org/gitlab!130901))
- [Add foreign key for ci_sources_pipelines bigint conversion](gitlab-org/gitlab@2ec38d34485e73563f38b655d704491e52bd8e96) ([merge request](gitlab-org/gitlab!132615))
- [Allow actor override when Direct Transfer disabled](gitlab-org/gitlab@f4e16b355c03368a758ea00f0ce42e656a22abde) ([merge request](gitlab-org/gitlab!132431))
- [Set patch_id_sha on record creation](gitlab-org/gitlab@c58a7ffed593287b1b4dd332247dd62bf56145be) ([merge request](gitlab-org/gitlab!131407))
- [Add foreign key for ci_pipelines.auto_canceled_by_id_convert_to_bigint](gitlab-org/gitlab@029517a1d80e58e5d31a3e0dfb5e6ec4b3c9f270) ([merge request](gitlab-org/gitlab!132609))
- [Enable group_level_licenses by default](gitlab-org/gitlab@f10310574f3bfb2c953e058ed42adfa9886aa8f3) ([merge request](gitlab-org/gitlab!132685)) **GitLab Enterprise Edition**
- [Adding OKR checkin reminder email notifications](gitlab-org/gitlab@8ab3adf4d0b84abf2275596f33d4dcc729a733f4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131426)) **GitLab Enterprise Edition**
- [Add documentation for locked labels](gitlab-org/gitlab@61d724f29573839820329fbff8d4e0589f1cdc20) ([merge request](gitlab-org/gitlab!132062))
- [Broadcast chat messages to all clients](gitlab-org/gitlab@a3f038dc0ed63797e86e5db8b00805dbc8101cdd) ([merge request](gitlab-org/gitlab!132029)) **GitLab Enterprise Edition**
- [Add container registry DB enabled flag to usage ping](gitlab-org/gitlab@76b80df88a9f52c57d419615f7b77935a6621a35) ([merge request](gitlab-org/gitlab!132550))
- [Cleanup after vulnerability_occurrences.uuid type migration](gitlab-org/gitlab@54bc43aaaea29344ae0eda350bde55b72a14ebe4) ([merge request](gitlab-org/gitlab!127754))
- [Ability to search and link work item](gitlab-org/gitlab@a65ae3f03e7d70f9d9b4e692480d5f3749c5e872) ([merge request](gitlab-org/gitlab!131194))
- [Release `admin_merge_request` granular permission](gitlab-org/gitlab@b1aca3e2ae71dd04951c0f2e87b876f3ef1405d1) ([merge request](gitlab-org/gitlab!132578)) **GitLab Enterprise Edition**
- [Populate finding_id in manual Vulnerability creation service objects](gitlab-org/gitlab@2a2500bc3c120deee10f95dd416a404fe8d3226c) ([merge request](gitlab-org/gitlab!132539)) **GitLab Enterprise Edition**
- [Display a ref type icon in the ref selector](gitlab-org/gitlab@07c1d6ea1489113b4d654ae1f0395bcf3f0b6936) ([merge request](gitlab-org/gitlab!132508))
- [Make GraphQL note and user types countable](gitlab-org/gitlab@196f8469814c07a2d939b26eedf4d82f2a48cfd2) ([merge request](gitlab-org/gitlab!132446))
- [Add 'latest_released_at' column to catalog_resources table](gitlab-org/gitlab@51cab8f35f8b2a61b436feaec5002b96e417c925) ([merge request](gitlab-org/gitlab!132429))
- [Limit number of issues that can be linked to an issue](gitlab-org/gitlab@7723c44bb5d3d13d6090fbdfe82b04f7ecfe1814) ([merge request](gitlab-org/gitlab!132116))
- [Create p_ci_finished_build_ch_sync_events table](gitlab-org/gitlab@f70597abd4376b3be7cd57d30baab9648e51a59b) ([merge request](gitlab-org/gitlab!131902)) **GitLab Enterprise Edition**
- [Add cvss column to vulnerabilities table](gitlab-org/gitlab@4dd33820f853506398cf0701ee6c5f5483b35718) ([merge request](gitlab-org/gitlab!131039))
- [Sync create indexes for ci_sources_pipelines pipeline_id conversion](gitlab-org/gitlab@e3a6eddca503d054c2f534b7d861737c3e74b6aa) ([merge request](gitlab-org/gitlab!131230))
- [Save draft new releases to local storage](gitlab-org/gitlab@5c2402f18d09eba5dd64b7512d39160d7908d73a) ([merge request](gitlab-org/gitlab!131677))
- [Add security policy schema to block unprotecting branches](gitlab-org/gitlab@fc8cfcbb0955c5faacc0be9d6959c471bd904dd8) ([merge request](gitlab-org/gitlab!132059)) **GitLab Enterprise Edition**
- [Add an option to use `unidiff` format for diff API responses](gitlab-org/gitlab@a328242e07cf825301af2bd428f757462c41b3c4) ([merge request](gitlab-org/gitlab!130610))
- [Manage achievements order on profile](gitlab-org/gitlab@6450de0d8f6bc1bac29aa2b9b6fcf7ae59ce5465) by @Taucher2003 ([merge request](gitlab-org/gitlab!123558))
- [Typecast both query sides to UUID for safe type migration](gitlab-org/gitlab@c76a6740e01ae2b437c4bed6c7f6cf49ff6e8cd7) ([merge request](gitlab-org/gitlab!131395))
- [Create temporary index on uuid column to support typecasting](gitlab-org/gitlab@93031c33032eda57ec451feff3fd3d87955b309e) ([merge request](gitlab-org/gitlab!131748))
- [Add compare button to tree view page](gitlab-org/gitlab@dd78b11ca8036b040ba64b7bdf7a4be84c21b0a7) ([merge request](gitlab-org/gitlab!132273))
- [Add last_assigned_users_refreshed_at column](gitlab-org/gitlab@3ce732e322fd4240870bce837f7cb511e039fb91) ([merge request](gitlab-org/gitlab!132295))
- [Add new column to hierarchy restrictions table](gitlab-org/gitlab@2fd1d41181150ed2a1839d50008d9ae64df9ff66) ([merge request](gitlab-org/gitlab!132018))
- [Move repository storage to BasicProjectDetails](gitlab-org/gitlab@a206c2cc193a734f5703da475ee21d7e08a06aeb) ([merge request](gitlab-org/gitlab!132036))
- [Add force_include_all_resources field to workspaces](gitlab-org/gitlab@0d54e73d3215751187bee18eeb667e13962f6afa) ([merge request](gitlab-org/gitlab!132239))
- [Add support for nuget v2 feed download endpoint](gitlab-org/gitlab@0cffa52702309ea64f1b6c58f23ffc3bb88cd10d) ([merge request](gitlab-org/gitlab!129126))
- [Track weight and sprint_id for VSA issues](gitlab-org/gitlab@43a8a5b8b2a533253040287e740342afe4864da4) ([merge request](gitlab-org/gitlab!132022))
- [Record and display fetched GitHub PR reviewers](gitlab-org/gitlab@024235ec021660a85ea49950a03ee90530e99756) ([merge request](gitlab-org/gitlab!132196))
- [Apply filtering of projects by topic for DORA score counts](gitlab-org/gitlab@43f32f63747063b09d87d58b0bee3e448eac1601) ([merge request](gitlab-org/gitlab!131498)) **GitLab Enterprise Edition**
- [Geo Replicables - SSF Bulk Actions UI](gitlab-org/gitlab@428662bec2f714c1b2a4ad4c8b0b8228b0b258ea) ([merge request](gitlab-org/gitlab!131674)) **GitLab Enterprise Edition**
- [Add hasParent to issue type](gitlab-org/gitlab@27466ae8259c36a471bbeab53cc50c755d8463c5) ([merge request](gitlab-org/gitlab!132033)) **GitLab Enterprise Edition**
- [Backfill vulnerabilities.finding_id column](gitlab-org/gitlab@ebc42da43ac87996c67b6bdd7f90dfaa61971ba7) ([merge request](gitlab-org/gitlab!130058))
- [Ensure backfill of default branch protection setting](gitlab-org/gitlab@499d32856cfb1c4e84f62d79e88c998dfc82abde) ([merge request](gitlab-org/gitlab!131255))
- [Sync create indexes for ci_pipelines pipeline_id conversion](gitlab-org/gitlab@c917a15ad2b892fe981a16d99a554a5714dc390d) ([merge request](gitlab-org/gitlab!131108))
- [Sync creation of i_compliance_violations_for_export](gitlab-org/gitlab@55d44652a0f7f57c72add3cdecf90bda8bab7d18) ([merge request](gitlab-org/gitlab!131088))

### Fixed (152 changes)

- [Fix combined negated filters for issues](gitlab-org/gitlab@31cfe34a23f4d6a42792601a674dd2714defa50e) ([merge request](gitlab-org/gitlab!133815))
- [Toggle Auto DevOps extra settings](gitlab-org/gitlab@037774fab0f7bbf553afa8085fb6bcb6ff2ea543) ([merge request](gitlab-org/gitlab!134441))
- [Fix param names in RelatedLinksCreateWorker](gitlab-org/gitlab@21c775e655db66e7f7d1b290c36c15e331c0a2ff) ([merge request](gitlab-org/gitlab!134384))
- [Add work_item_related_link_restrictions to deletion exceptions](gitlab-org/gitlab@6e9d5bcd05391a9245c74da24c734ee475e138c3) ([merge request](gitlab-org/gitlab!134528))
- [Clear AI availability check when members get added](gitlab-org/gitlab@a81ee0be66f62731f60e03e91221c8eadfed9940) ([merge request](gitlab-org/gitlab!133993)) **GitLab Enterprise Edition**
- [Fix bleeding of page size selector in vulnerability report grouping](gitlab-org/gitlab@89571f2646cf33a6023a82e3e64a5adc47e64d3a) ([merge request](gitlab-org/gitlab!134355)) **GitLab Enterprise Edition**
- [Update last_assigned_users_refreshed_at column](gitlab-org/gitlab@081deef7e84cfe54d6d6e2340417892d23fa668b) ([merge request](gitlab-org/gitlab!134241)) **GitLab Enterprise Edition**
- [Improve create VSA error messaging](gitlab-org/gitlab@10f7740681c8e525cd488836fb85d8b956b90f67) ([merge request](gitlab-org/gitlab!134002)) **GitLab Enterprise Edition**
- [Fix missing UI text](gitlab-org/gitlab@5b606de3df2e5c160086048544b783b047abc669) ([merge request](gitlab-org/gitlab!134249))
- [Gracefully handle space-delimited scopes in registry /jwt/auth requests](gitlab-org/gitlab@00e01dc8d53ad8c84e6eb9fbc0e3a5db29e7b540) ([merge request](gitlab-org/gitlab!133841))
- [Fix k8s namespaced services list](gitlab-org/gitlab@3aa8840f52320151f1b314c9c8db4533436b752e) ([merge request](gitlab-org/gitlab!134368))
- [Do not send empty strings as a chunk](gitlab-org/gitlab@e2b3de1ba6a679ea617fa20705f1be98b5da8125) ([merge request](gitlab-org/gitlab!134362)) **GitLab Enterprise Edition**
- [Allow expand/collapse with chevron on vulnerability report grouping](gitlab-org/gitlab@2c5ccc0430cf0e2459097614ad9e7c5ed76464f8) ([merge request](gitlab-org/gitlab!134352)) **GitLab Enterprise Edition**
- [Update mime-types to v3.5.1 and mime-types data to 3.2023.1003](gitlab-org/gitlab@d5bf6127e3f5abfea63903726732fa5a1a2ca12d) ([merge request](gitlab-org/gitlab!134307))
- [Catch semver_dialects parse errors](gitlab-org/gitlab@49a86ae8c23beb61b1ac9c3ad209c05050554ef1) ([merge request](gitlab-org/gitlab!134294)) **GitLab Enterprise Edition**
- [Remove the routing when container exists in wiki cleanup from elastic](gitlab-org/gitlab@6f782a1508468341d98b3ac78429ec9090b4d582) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/134273)) **GitLab Enterprise Edition**
- [Use UntrustedRegexp with inputs regex](gitlab-org/gitlab@ebc331186f2f0c813f3efd36f7d147f729fb8c66) ([merge request](gitlab-org/gitlab!133977))
- [Fixed users API docs using a PAT that triggered secret detection](gitlab-org/gitlab@f63e767b0751022cbe20387b65379a437a7b3056) by @zillemarco ([merge request](gitlab-org/gitlab!134179))
- [Fix gitlab_username_claim support for OmniAuth providers](gitlab-org/gitlab@bfc548e7fbb2d5beb1fc96f0b749f3931c44081d) ([merge request](gitlab-org/gitlab!134015))
- [Fix pipeline schedules view when owner is nil](gitlab-org/gitlab@daaf2554d0aa02a14181b83e004db8a1da443582) ([merge request](gitlab-org/gitlab!134041))
- [Update migration worker preflight check](gitlab-org/gitlab@0335854a635c7066b7cebb7e57f1206b0b956212) ([merge request](gitlab-org/gitlab!134070)) **GitLab Enterprise Edition**
- [Check supported versions when querying compressed package metadata](gitlab-org/gitlab@ba3da1fcec222dd6a5eae9513a30036df047ac33) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/133083)) **GitLab Enterprise Edition**
- [Switch success to primary variant in split_button](gitlab-org/gitlab@43b4062d109401a16248e34c82c5153128e428c3) ([merge request](gitlab-org/gitlab!134106)) **GitLab Enterprise Edition**
- [Allow empty email field on LDAP entry](gitlab-org/gitlab@4fd5401e06c1b86d68a16c2cf5ad5eed8a7ef517) ([merge request](gitlab-org/gitlab!133320))
- [Do not save linked resources if the incident is not persisted](gitlab-org/gitlab@54fc8bd1f46caf65d3fd2f4147679fbdfb061286) ([merge request](gitlab-org/gitlab!133685))
- [Import missing projects specific CSS on more list pages](gitlab-org/gitlab@7b6a53e7d37d4f1e40d9184139758e8b4f5225b1) ([merge request](gitlab-org/gitlab!131405))
- [Fix regression for breadcrumbs styling after moving projects.scss](gitlab-org/gitlab@c2ca5465545047f78145205afc89259f5e81c6ed) ([merge request](gitlab-org/gitlab!131405))
- [Render user menu dropdown list items in `<ul>`](gitlab-org/gitlab@f1028365fa89a9af4e215baf1e5b21216d6199ae) ([merge request](gitlab-org/gitlab!133552))
- [Block un-UTF-8-able tag names](gitlab-org/gitlab@23fe84143c7a235d3feca0d4da8bffa313f1f569) ([merge request](gitlab-org/gitlab!132135))
- [Fix work item child items widget overflow](gitlab-org/gitlab@2f34eb6a9c46e9867ab96d407f8e36007ab863f4) ([merge request](gitlab-org/gitlab!133726))
- [Prevent Meta+K default behaviour in rich text editors](gitlab-org/gitlab@83157587728413dab6641a0e0f59763e6c102553) by @a.shreya202 ([merge request](gitlab-org/gitlab!133372))
- [Reindex wikis to fix routing and backfill archived](gitlab-org/gitlab@1a972006dc710b8972bd6cf5f571bee58407e961) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/129983)) **GitLab Enterprise Edition**
- [Remove "Skip to main content" link from navigation when logged out](gitlab-org/gitlab@2feff309e9a4d95485b4cbf1a35d27d8408297eb) ([merge request](gitlab-org/gitlab!133650))
- [Fix super sidebar update for learn gitlab when updating percent](gitlab-org/gitlab@d785a594742b8c9033879a75d772995b599c8aac) ([merge request](gitlab-org/gitlab!133495)) **GitLab Enterprise Edition**
- [Fix text overflow in performance bar in text only zoom mode in FF](gitlab-org/gitlab@ed8da58b7911b566c3374cea1075f5041def9fd5) ([merge request](gitlab-org/gitlab!133827))
- [Fix Direct Transfer stage incorrect execution order due to failures](gitlab-org/gitlab@a4b41037dd6d5164ca5f76486c4dc8c44202295e) ([merge request](gitlab-org/gitlab!133638))
- [Fetch missing commits during Bitbucket server import](gitlab-org/gitlab@6eb4e8e0420274fcc8b4f8504ace9789d67de2b1) ([merge request](gitlab-org/gitlab!133606))
- [Geo: Avoid getting resources stuck in Queued](gitlab-org/gitlab@31442fb720915e6e1ae6172a231fc4d64bcaee37) ([merge request](gitlab-org/gitlab!133782)) **GitLab Enterprise Edition**
- [Fix GraphQL ConnectionFilterExtension for list types](gitlab-org/gitlab@4329a50c31b5a2f589748cf597f87a8d73379238) by @zzaakiirr ([merge request](gitlab-org/gitlab!133046))
- [Show task icon instead of status in linked item widget](gitlab-org/gitlab@20855dcd34b87d66c401d6be1d8e6f025550e7df) ([merge request](gitlab-org/gitlab!133602))
- [Do not show runner manager as online when registering](gitlab-org/gitlab@20f3c4c370c3549721f87f822cd84452165afbbd) ([merge request](gitlab-org/gitlab!133858))
- [Filter k8s services by namespace](gitlab-org/gitlab@1870b6af5a8358fe28d8b93e1628b6560faff143) ([merge request](gitlab-org/gitlab!133824))
- [Remove active scope in add-on purchase lookup for SM](gitlab-org/gitlab@2504d2fc3e1cd0b5b2fa7af69064b01551110db1) ([merge request](gitlab-org/gitlab!132983)) **GitLab Enterprise Edition**
- [Fix dummy email for omniauth integrations](gitlab-org/gitlab@869e2bb9eac513c705fbde8e1ba88e1acbd409b9) ([merge request](gitlab-org/gitlab!133529))
- [Fix spelling corrections not working in RTE](gitlab-org/gitlab@92f2f109a0b876c255fc49548b0b52ad0cfe59b0) ([merge request](gitlab-org/gitlab!133771))
- [Return 400 Bad Request if request parameters cannot be decoded](gitlab-org/gitlab@a77665456601bb51b25606884f9d6c513594aa2b) ([merge request](gitlab-org/gitlab!133791))
- [Fix Jira issues with 'Done' status do not appear on vulnerability page](gitlab-org/gitlab@18b509e9fbf6fd500dfed1ff6f53940448424eee) by @egor-kh ([merge request](gitlab-org/gitlab!133767)) **GitLab Enterprise Edition**
- [Fix vulnerability statistics gathering query for A grade projects](gitlab-org/gitlab@01e5a0e8c19ff4fbb9b4736f144b919e55180d91) ([merge request](gitlab-org/gitlab!133722)) **GitLab Enterprise Edition**
- [Fix jest console error on unit tests](gitlab-org/gitlab@19ef9896b4218a2be03cdb7bf3d324b33ac7fb38) ([merge request](gitlab-org/gitlab!133574))
- [Updates schema validation index query](gitlab-org/gitlab@d6a371bbd79cebd1e6343ffdce41e0d287ec982d) ([merge request](gitlab-org/gitlab!132172))
- [Hide logo images from accessibility tree](gitlab-org/gitlab@9f46dd7d88452b92b00a08a7f9e84e9098a4f503) ([merge request](gitlab-org/gitlab!133560))
- [Prevent serialization from failing in RTE](gitlab-org/gitlab@85b7e2e8c1cd2a145c7901f0f1ff31338311cf30) ([merge request](gitlab-org/gitlab!133711))
- [Fixes MLflow run search compatibility](gitlab-org/gitlab@4f4345c094827537ea9bedc3d59c50f299ad5f49) ([merge request](gitlab-org/gitlab!133702))
- [Fix failing migration when commit_message_negative_regex is missing](gitlab-org/gitlab@722d32ebe4165b3ba430c80c1b1dc2fd8e5c7471) ([merge request](gitlab-org/gitlab!132908))
- [Fixes error when mail without to header in ServiceDeskHandler](gitlab-org/gitlab@a1dde9d6cb0ff60e943ca6240ffbf8cddc629098) ([merge request](gitlab-org/gitlab!132913))
- [Fix vulnerability statistics calculation query](gitlab-org/gitlab@295a16d1160ec8e4a47a208fb3a579846c0c7e41) ([merge request](gitlab-org/gitlab!133354)) **GitLab Enterprise Edition**
- [Fix validation error not shown on first click](gitlab-org/gitlab@3b5b692bcd63e47b4a8be2b26b3e0c301f8b41d2) ([merge request](gitlab-org/gitlab!133572))
- [Protected environment settings modal overflow fix](gitlab-org/gitlab@4d8c7936c60d6a21c3bc38572d39ff81f1d8bc58) ([merge request](gitlab-org/gitlab!133682)) **GitLab Enterprise Edition**
- [New navigation display tooltip on keyboard focus](gitlab-org/gitlab@3c8001a03b11a3d88aed49645e3bcaa6ddecfd29) ([merge request](gitlab-org/gitlab!133651))
- [Gracefully handle exceptions](gitlab-org/gitlab@29b94903f68d73f2e49fb25b1b532c562cbfe5e5) ([merge request](gitlab-org/gitlab!133630))
- [Maintain elasticsearch for epics on label deletion](gitlab-org/gitlab@e5072795385a03ad49469ddd823413e3f186a95b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/133577)) **GitLab Enterprise Edition**
- [Temporarily allow listing cross join](gitlab-org/gitlab@137d004c88a24e606b044e914c8ee3876434871a) ([merge request](gitlab-org/gitlab!133617))
- [Prevent existing undeleted user access to return true](gitlab-org/gitlab@7b3ab9cb6d3e43ff308e496c461cb6685474c9ac) ([merge request](gitlab-org/gitlab!132380))
- [Remove new repository on failed replication](gitlab-org/gitlab@178f36d9c0daf5afa4d22586ded7bb6e3f23b43b) ([merge request](gitlab-org/gitlab!133240))
- [Add nav element to logged out header](gitlab-org/gitlab@72a0a8999e0c9c9f689cd3e72fff052ba8f1d479) ([merge request](gitlab-org/gitlab!133559))
- [Disable group readme mountpoint when gitlab-profile project is private](gitlab-org/gitlab@fbbd7416ce321f79ad2d7a6a1ab3026b3c59ad66) by @Taucher2003 ([merge request](gitlab-org/gitlab!133540))
- [MR sidebar toggle button position fix](gitlab-org/gitlab@9b28304ddf7219ede5f1740c0a46ad9a65c43596) ([merge request](gitlab-org/gitlab!133505))
- [Code generation: skip trailing white spaces suffix](gitlab-org/gitlab@d8090bb403b297504b248cd13001ce439840ab94) ([merge request](gitlab-org/gitlab!132626)) **GitLab Enterprise Edition**
- [Fix GitHub Import workers from aborting when rate limit is reached](gitlab-org/gitlab@e21267b8ce659be6f38a614bdf59313391f5d773) ([merge request](gitlab-org/gitlab!132813))
- [Keep locking_version when updating partitioned records](gitlab-org/gitlab@78558a8c46e7fa03865ef2c19dc90c6628ceca9d) ([merge request](gitlab-org/gitlab!133447))
- [Fix Security Policy Bot not created when SAML is enabled](gitlab-org/gitlab@6c8d5a2ff3d44600ae4b98cfcde90bb0e7bd9dad) ([merge request](gitlab-org/gitlab!133333)) **GitLab Enterprise Edition**
- [Fix issue creation from pipeline security modal](gitlab-org/gitlab@b718d9b5ae54db12a03fbdfeb3b811d04389d79d) ([merge request](gitlab-org/gitlab!133363))
- [Front-end support for bigint board weight fields](gitlab-org/gitlab@273f456224f05753f068fdbcf887cf0524fe55e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/125249)) **GitLab Enterprise Edition**
- [ChatOps calls should record user activity](gitlab-org/gitlab@7455b62eb774a180ee81f34f2b3b30f5d6acf184) ([merge request](gitlab-org/gitlab!132521))
- [Enable k8s cluster when CI/CI is disabled](gitlab-org/gitlab@bad0ecb3b298bba919c991be618843013e1cbbe0) by @abhiandthetruth ([merge request](gitlab-org/gitlab!133124))
- [Fix update of optional_approvals in bot comment](gitlab-org/gitlab@4565999326e4a432223363e0940b7bef54368ebd) ([merge request](gitlab-org/gitlab!133407)) **GitLab Enterprise Edition**
- [Prevents note column swap migration to fail](gitlab-org/gitlab@db6fdd1e9aa4938fac88984d47731f4b0b02cb34) ([merge request](gitlab-org/gitlab!132686))
- [Do no re-enqueue timed-out bulk imports](gitlab-org/gitlab@010fd14728d15f08a9a1c82f493f1986d78acb63) ([merge request](gitlab-org/gitlab!133384))
- [Disable routing in delete for force wiki reindexing](gitlab-org/gitlab@05ae6ceba35e51626d3ecd2c40a5a8d8bb173fce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/129810)) **GitLab Enterprise Edition**
- [Fix draft comment files not loading](gitlab-org/gitlab@bc51aaae1a947df887b7c86fd0428d96a24fdf06) ([merge request](gitlab-org/gitlab!133339))
- [Fix pages custom domain requests being redirected to unique domain](gitlab-org/gitlab@0dab36d55146b93dbb544d12b0eeed094c986615) ([merge request](gitlab-org/gitlab!133330))
- [ToDo: Fix count when not filtered](gitlab-org/gitlab@d2cb70cb091b703979c8b93678144200e4e4fc9f) ([merge request](gitlab-org/gitlab!133204))
- [Set pipeline schedule owner_id to importer user when importing](gitlab-org/gitlab@3fa496f0144cc798afd24bd974c05bab96b34ced) ([merge request](gitlab-org/gitlab!133235))
- [Attempt to parse Redis cert_file and key_file only if defined](gitlab-org/gitlab@7ff5e81f4144d5fe2727e52f0cffb594ba023876) ([merge request](gitlab-org/gitlab!133292))
- [Fix GraphQL API for clearing issue contacts](gitlab-org/gitlab@5d3955ce35c13f3ed1e52c59b0d2d7e4cc086fd4) ([merge request](gitlab-org/gitlab!133174))
- [Update vulnerability_read when vulnerability dismissed](gitlab-org/gitlab@290396fc8a59c329b494993487823989737e02a8) ([merge request](gitlab-org/gitlab!133300)) **GitLab Enterprise Edition**
- [Fix GraphQL userNotesCount when not logged in](gitlab-org/gitlab@4e8f8c531ae5b805319cf0ec3c0ec26f295046e0) ([merge request](gitlab-org/gitlab!133302))
- [Cache database_id before doing other work](gitlab-org/gitlab@6f94b1ad3817db99c4362cdeca24ba5076b6b2e7) ([merge request](gitlab-org/gitlab!133149))
- [Fix dropdown alignment in new navigation](gitlab-org/gitlab@0a406cda64b9114655499c59e869a2287679489a) ([merge request](gitlab-org/gitlab!132841))
- [Performance Bar: Fix darkmode link color](gitlab-org/gitlab@82e6e113e14bb579582cb8c448cf42d9be9698f1) ([merge request](gitlab-org/gitlab!133172))
- [Fix ci pipeline reference when pushing duplicate NuGet package](gitlab-org/gitlab@cce7c221c472f8cb64fe9995b9cd9d81f5aa5890) ([merge request](gitlab-org/gitlab!132360))
- [Recover environments that are stuck stopping](gitlab-org/gitlab@ca8c4a9ad540bc5fcd5a4c9c92b7c628f57d686d) ([merge request](gitlab-org/gitlab!132300))
- [Invite project mmembers overlay dropdown overflow fix](gitlab-org/gitlab@dd90bd5b64dd893c70e6a4c87027446b3715e9ff) ([merge request](gitlab-org/gitlab!133077)) **GitLab Enterprise Edition**
- [Fix security policy bot not created when group does not allow new users](gitlab-org/gitlab@0c0314395f2afd47011c48b6d3436622921c850d) ([merge request](gitlab-org/gitlab!133031)) **GitLab Enterprise Edition**
- [Show work item comments locked only after loading](gitlab-org/gitlab@1811fd770d34b10a4f3f5df247263d15f576ff59) ([merge request](gitlab-org/gitlab!132801))
- [Fix experiment rollout logic](gitlab-org/gitlab@0bebbca12b6c0dbdc07e33c64b31bc4bad610136) ([merge request](gitlab-org/gitlab!133038))
- [Fixed VSA multi-select project dropdown](gitlab-org/gitlab@5773c4bfd18bcbb209065950b4b56a27652899e4) ([merge request](gitlab-org/gitlab!132426))
- [Return 401 token invalid form graphql](gitlab-org/gitlab@2c7812b18275ec8dae2442926ba8f9b3b3f4c8c2) ([merge request](gitlab-org/gitlab!132149))
- [ToDo badge: Fix count when list is filtered](gitlab-org/gitlab@a2297e6dd595f01ea6d75bac60c5984450f367d4) ([merge request](gitlab-org/gitlab!132510))
- [Stops log from resetting line in every section](gitlab-org/gitlab@88ed8d986645842d26733bb58d9526436b784ec7) ([merge request](gitlab-org/gitlab!132964))
- [Avoid account lockout when account password automatically set](gitlab-org/gitlab@90906e2ef545e8a149189a96526b1be188f686aa) ([merge request](gitlab-org/gitlab!133027))
- [Fix permissions on :read_pipeline_schedule](gitlab-org/gitlab@a82f5077dcda709ab28bf9d92bc2cd8f2d9228de) ([merge request](gitlab-org/gitlab!132952))
- [Keep branch name in a search input](gitlab-org/gitlab@7f77d322a437332eae271f3b117b6cd4372ce559) ([merge request](gitlab-org/gitlab!132043))
- [Fix avatar wrapping in work items child objectives widget](gitlab-org/gitlab@531a510d0737c60cec1405201c2f86f87981d97b) ([merge request](gitlab-org/gitlab!132890))
- [Remove orphaned approval rules for imported project/merge request](gitlab-org/gitlab@2fc9ee07e23d711e27e0c8e111b3e994ca6b73d6) ([merge request](gitlab-org/gitlab!127212))
- [Revert auth changes on the Composer registry package endpoint](gitlab-org/gitlab@a3e4f6ddc77b67b3d7935b6666f981bc7d45976e) ([merge request](gitlab-org/gitlab!132931))
- [Update ChatName activity timestamp throttle](gitlab-org/gitlab@6747dc0119b7041b9696cd8097e9b268d755f61b) ([merge request](gitlab-org/gitlab!132385))
- [Remove extra spacing around epic header actions](gitlab-org/gitlab@f17e6e8801d1b8052ac2a99b95e6608cfbb129b6) ([merge request](gitlab-org/gitlab!132923))
- [Child issues and epics widget: Fix alignment and overflow issue](gitlab-org/gitlab@584260579b11d780b137593a00c30303636e1b7b) ([merge request](gitlab-org/gitlab!132750)) **GitLab Enterprise Edition**
- [Fix position of job sidebar with performance bar enabled](gitlab-org/gitlab@8c74a2daaa6010b83f5735d4d0213074b93f4728) ([merge request](gitlab-org/gitlab!132906))
- [Fix "Continue editing" button being retained](gitlab-org/gitlab@1aa794d332b1619938faf970ce0045dc754f60c3) ([merge request](gitlab-org/gitlab!132868))
- [Add preload hint for GitLab Sans italic font](gitlab-org/gitlab@84ae173a161b9a307f50d3c68534a3d89addbb8d) ([merge request](gitlab-org/gitlab!132870))
- [Prevent modification of security_policy_bot members](gitlab-org/gitlab@613df337020f2f07963fbf28efca50312d59c140) ([merge request](gitlab-org/gitlab!132864)) **GitLab Enterprise Edition**
- [Fixes confidentiality handling of NoteForm component](gitlab-org/gitlab@b65a692bf41abe14f0f26ee3ee8ee75345b4aba8) ([merge request](gitlab-org/gitlab!132782))
- [Fix enum fields data propagation](gitlab-org/gitlab@e9d9bf1c38934a9ebfaa35d8023a5e9887205f63) ([merge request](gitlab-org/gitlab!132848))
- [Fix auto-scrolling to Markdown anchors](gitlab-org/gitlab@79c4a586f040d563be64671e1ad98b8132291622) ([merge request](gitlab-org/gitlab!132846))
- [Limit GraphQL job trace HTML summary to 16KiB](gitlab-org/gitlab@fce3941a7fdeebb252a8ec7d9d644402955ef272) ([merge request](gitlab-org/gitlab!132804))
- [Remove list marker and href attribute](gitlab-org/gitlab@95b59d26b064b0a808a35e4a1db241c4ce04477f) ([merge request](gitlab-org/gitlab!132830))
- [Ensure TLS is disabled with `dind` service in Code Quality template](gitlab-org/gitlab@d0995c1852f016bbef8759b7b4cedd34701b432f) ([merge request](gitlab-org/gitlab!132814))
- [Ensure consistent behavior when LDAP encryption config missing](gitlab-org/gitlab@c2cae9457dc6b34652aad04f171a2dd8ce30b961) ([merge request](gitlab-org/gitlab!132689))
- [Add merged_commit_sha to queries for merge requests](gitlab-org/gitlab@aeadf63e97662f3349526291b05c80c061a3ca07) ([merge request](gitlab-org/gitlab!131922))
- [Fix Direct Transfer stages execution order](gitlab-org/gitlab@ad1435f57a38ddf3c28bbbdd4b58e0916001a38f) ([merge request](gitlab-org/gitlab!132320))
- [Fix composer API to work with CI job token](gitlab-org/gitlab@73e8b561199991e64a8263b95c0a298c919f718d) by @ar-mali ([merge request](gitlab-org/gitlab!127300))
- [Ensure empty relation file exists on disk even if nothing was exported](gitlab-org/gitlab@2e978acaff6776fc018d7afdc7f3222447568bb6) ([merge request](gitlab-org/gitlab!132631))
- [Add redirecting to identity verification success page back](gitlab-org/gitlab@d7f571bb2d195e8883dbbe7494af0ca0568363ea) ([merge request](gitlab-org/gitlab!132611)) **GitLab Enterprise Edition**
- [Fix NoMethodError on CreateBotService when authorization is enabled](gitlab-org/gitlab@414ca139b7d48b66a96500876b58045dfa3a6dca) ([merge request](gitlab-org/gitlab!132683)) **GitLab Enterprise Edition**
- [Fixes overflow of username in note header in the timeline](gitlab-org/gitlab@a2f0e2d04ab51181bbce8e4e442859f62b96a6fe) ([merge request](gitlab-org/gitlab!132506))
- [Use a more robust extraction function to get the file hash](gitlab-org/gitlab@be640437b28ed0032bf9a3c28bccb936a3acc72f) ([merge request](gitlab-org/gitlab!132301))
- [Send notification emails using background worker](gitlab-org/gitlab@0b95725db1d2bc7bca06662a0ba6451ce3f54925) ([merge request](gitlab-org/gitlab!132633))
- [Fix WorkItemUpdate mutation permissions](gitlab-org/gitlab@80bb764c366d41236bb2493703b3a624171103d4) ([merge request](gitlab-org/gitlab!132224))
- [Add missing provider ID field](gitlab-org/gitlab@18d27b6edc8338671714780a3e67630f47ac876c) ([merge request](gitlab-org/gitlab!131316)) **GitLab Enterprise Edition**
- [Resolve tooltip on navigation toggle button staying visible on mobile](gitlab-org/gitlab@d0cf8ce477af2657500bc43230fc0d88964eff96) ([merge request](gitlab-org/gitlab!131118))
- [Add report abuse button to epic actions](gitlab-org/gitlab@c434e5d866a26bf8208aa5717949f6e3003e68eb) ([merge request](gitlab-org/gitlab!131476))
- [Remove extra margin on members tabs](gitlab-org/gitlab@412b953e82f4ac511e4253113e5c79c65e431bc6) ([merge request](gitlab-org/gitlab!132592))
- [Fix missing sha default in merge trains API](gitlab-org/gitlab@9c678701a05fc95a7536d7981b50a5a8384a3906) ([merge request](gitlab-org/gitlab!132590)) **GitLab Enterprise Edition**
- [Support Microsoft Graph pagination](gitlab-org/gitlab@ddf5d603ac9ee63bb7fda8dcb79f17b4ed842a16) ([merge request](gitlab-org/gitlab!132464)) **GitLab Enterprise Edition**
- [Fix N+1 for indexing epics and milestones](gitlab-org/gitlab@910717a48365021a62ebefa08dc3f1f5c99f47a0) ([merge request](gitlab-org/gitlab!132545)) **GitLab Enterprise Edition**
- [InternalEvents.track_event should be called with objects and not ids](gitlab-org/gitlab@e8426602a033d12ae88ac1fbfd8328f5a088fed7) ([merge request](gitlab-org/gitlab!132235))
- [Fix merge request header icons](gitlab-org/gitlab@b2ea95b8b1f15228a2fd5fa3fbd316857d5676b8) ([merge request](gitlab-org/gitlab!131557))
- [Super sidebar contextual header restore font-weight](gitlab-org/gitlab@fac511e4538c011229655087b10f69ef3e1bde03) ([merge request](gitlab-org/gitlab!132503))
- [Verify VSD point target_project_id](gitlab-org/gitlab@2a0cf22fcd8783782a756b74dbc930d4fa1d5bd9) ([merge request](gitlab-org/gitlab!132130)) **GitLab Enterprise Edition**
- [Improve ci schema to support several forms of scripts](gitlab-org/gitlab@54b9bbacee763e678fa8eeebb8f05646b9182396) by @pm9551 ([merge request](gitlab-org/gitlab!128603))
- [Fix invalid HTML markup in super sidebar](gitlab-org/gitlab@3244b67524a1073c192dbc72271e035d1089a2c6) ([merge request](gitlab-org/gitlab!131977))
- [This MR adds check for namespace](gitlab-org/gitlab@01197081bd2012deae9a073250366ac99f3ded61) ([merge request](gitlab-org/gitlab!132068)) **GitLab Enterprise Edition**
- [Only add confirmed accounts directly as member](gitlab-org/gitlab@e8b9ab869a6347b8a813a213721898c649515559) ([merge request](gitlab-org/gitlab!131389))
- [Fix Markdown rendering references inside inline diff](gitlab-org/gitlab@9f39d19027fa185322a2ca67019e9fdec729d460) ([merge request](gitlab-org/gitlab!132312))
- [Fix CLI messages for project limits in SM](gitlab-org/gitlab@1c171564f3ec61d3d6484342be305ff2aadd1a67) ([merge request](gitlab-org/gitlab!131122)) **GitLab Enterprise Edition**
- [Fix mobile alignment of MR AI summary](gitlab-org/gitlab@887adc15d6ebb7bd430ebdd28e35b8bd55e68db9) ([merge request](gitlab-org/gitlab!132282))
- [Fixing import list pagination bug](gitlab-org/gitlab@03082e666c887a5ca90021fd82de4b5e6d417034) ([merge request](gitlab-org/gitlab!132169))
- [Fix incorrect SystemHook GitLab header](gitlab-org/gitlab@698851ce8ec2882642abc383cd06e9c622f6b085) ([merge request](gitlab-org/gitlab!132167))
- [Fixes the .merge-request-tabs-holder background color in darkmode](gitlab-org/gitlab@da9b2f22341a9795e0ea4e9efaf872632dbcca5d) ([merge request](gitlab-org/gitlab!132274))
- [Don't signal MR rebase if on current fast-forward train](gitlab-org/gitlab@51777afd62c42e142fdccddcdb808d6de126260a) ([merge request](gitlab-org/gitlab!131942)) **GitLab Enterprise Edition**

### Changed (221 changes)

- [Remove user dropdown from terms layout](gitlab-org/gitlab@b5a81e1dcf0a870c447eca325c378a545cfc20c3) ([merge request](gitlab-org/gitlab!134151))
- [Display name of user that triggered CI on candidate table](gitlab-org/gitlab@09a67abb76ba4210e865d5bf941075a011ddf905) by @zzaakiirr ([merge request](gitlab-org/gitlab!134209))
- [Swap the columns for ci_pipeline_variables](gitlab-org/gitlab@bcc4bcd36980f5d278e92decbfe1f40a3ae18855) ([merge request](gitlab-org/gitlab!130912))
- [Update devise-two-factor to 4.1.1](gitlab-org/gitlab@3ef1833478d27315c1549fcda61e9ebe78d02b80) ([merge request](gitlab-org/gitlab!134255))
- [Add logo to PivotalTracker integration](gitlab-org/gitlab@fcd723780005e942b99750face34022f89857dad) ([merge request](gitlab-org/gitlab!134493))
- [Update tanuki image for new user onboarding](gitlab-org/gitlab@51b0173827de7cdcfd2d3f840afcae93576b82c9) ([merge request](gitlab-org/gitlab!134418)) **GitLab Enterprise Edition**
- [Remove loading spinner in feature flagged todo button](gitlab-org/gitlab@fa441632fe89b9ae67be889b8c04a2342fa996c6) ([merge request](gitlab-org/gitlab!134309))
- [Update similar_by_holder_name & similar_records in CreditCardValidation](gitlab-org/gitlab@0cf3b6ff1da6c269f1a687cc16650327f2b242ee) ([merge request](gitlab-org/gitlab!131365))
- [Migrate cancel button iin shared/notes/form](gitlab-org/gitlab@9a5a3e017309c3bb50ec22e87713ab1fb3b1eec3) ([merge request](gitlab-org/gitlab!134163))
- [Migrate group_dropdown to import_target_dropdown](gitlab-org/gitlab@3f5abdb6366aa2688bd8e3c311ee6c588ed3d6a5) ([merge request](gitlab-org/gitlab!133986))
- [Move epic notifications and todos](gitlab-org/gitlab@7929dee41038cc020903c5127a1900650f8f6378) ([merge request](gitlab-org/gitlab!134287))
- [Remove unused blob header files](gitlab-org/gitlab@c9b84b1d1fffbc6492f9b626bcca991f990aa0e5) ([merge request](gitlab-org/gitlab!134157))
- [Remove unncessary typecasting in SQL queries](gitlab-org/gitlab@6ecf8085867e67a8636d56479414751853dbca98) ([merge request](gitlab-org/gitlab!134380)) **GitLab Enterprise Edition**
- [Improve test case action dropdown](gitlab-org/gitlab@7c464dd7892cb9e8b91e0a9c1843761c0e444ae4) ([merge request](gitlab-org/gitlab!134123)) **GitLab Enterprise Edition**
- [Migrate GlDropdown component to use GlCollapsibleListbox](gitlab-org/gitlab@0fe2cbbb2fecc7f69d9de85508155ecd337b3da2) ([merge request](gitlab-org/gitlab!133497))
- [Remove feature flag database_analyze_on_partitioned_tables](gitlab-org/gitlab@6519a6f2925019ef21f77b322f851f97c74e7926) ([merge request](gitlab-org/gitlab!132219))
- [Add pipeline name to GraphQL API](gitlab-org/gitlab@d63068ef7560cbccfcda54c8b371d30658284ab0) ([merge request](gitlab-org/gitlab!134333))
- [Add Confidentiality Checkbox to New Test Case Form](gitlab-org/gitlab@a02c620894752feecd032b8b3c994791b2340b89) ([merge request](gitlab-org/gitlab!133900)) **GitLab Enterprise Edition**
- [Add system-out and system-err to test parsing](gitlab-org/gitlab@8ed29675579cb416e5a369bc92f853b03f27dd32) by @evigeant ([merge request](gitlab-org/gitlab!134219))
- [Remove summarize_diff_abstraction_layer feature flag](gitlab-org/gitlab@798f69d1b6b4737e33c7a6c81f0e1b4030817747) ([merge request](gitlab-org/gitlab!134339)) **GitLab Enterprise Edition**
- [Added logging to TokensController](gitlab-org/gitlab@6fce841384e034a2d1338605bfe87576fd5c42da) ([merge request](gitlab-org/gitlab!133396))
- [Upgrade GitLab Pages to latest version](gitlab-org/gitlab@7e38705c4dc656456113a03d832ca0a30d084a92) ([merge request](gitlab-org/gitlab!134335))
- [Update adherence_report_ui ff to default enabled](gitlab-org/gitlab@ae963d79becf0cc652ccd150b1a9a6acfc0aefdc) ([merge request](gitlab-org/gitlab!133757))
- [Dark mode label fix](gitlab-org/gitlab@1b956c8d341af6af0f9ee57e29565957b9276676) ([merge request](gitlab-org/gitlab!134021))
- [Update notifications documentation](gitlab-org/gitlab@9029eae3e544383cd4cfc2226c218ee7cf42316e) ([merge request](gitlab-org/gitlab!133891))
- [Geo Sites Form - Migrate Namespace Dropdown](gitlab-org/gitlab@4086f40e0c0eac2b6c750e168e85d3bf4a1151ba) ([merge request](gitlab-org/gitlab!133766)) **GitLab Enterprise Edition**
- [Remove domain verification SSO redirect feature flag](gitlab-org/gitlab@a2fd4144abdc1641ce2d20f19209ddff4885e54a) ([merge request](gitlab-org/gitlab!134298)) **GitLab Enterprise Edition**
- [Add contribution analytics to registration features](gitlab-org/gitlab@fdb18277e1f2f8e5d8814069cd7091e5ae12b80d) ([merge request](gitlab-org/gitlab!134066)) **GitLab Enterprise Edition**
- [Add geo_handle_after_create to all replicators](gitlab-org/gitlab@f76814c4b9354b3cd0aa73b3bebaf72980b0c5b6) ([merge request](gitlab-org/gitlab!133239)) **GitLab Enterprise Edition**
- [Import LFS objects](gitlab-org/gitlab@fb349dd5fed7cfccbced71a5de4d0ae5d6aa24d8) ([merge request](gitlab-org/gitlab!133182))
- [Add internal API to receive zoekt heartbeats](gitlab-org/gitlab@4424ea0e8a817df7f9670ba2f59d186d32efc121) ([merge request](gitlab-org/gitlab!131671))
- [Add logo to Jira integration](gitlab-org/gitlab@530c36d24785b3e1db67f48a6208ee4186516d5a) ([merge request](gitlab-org/gitlab!134275))
- [Add logo to Pushover integration](gitlab-org/gitlab@2a8939b9fb6505d9b6f7279345bd8b6a7c3caaf5) ([merge request](gitlab-org/gitlab!134272))
- [Update empty state component](gitlab-org/gitlab@a825c285be49a38a5fb658687beff8f64826b5c1) ([merge request](gitlab-org/gitlab!134071))
- [Update dependency auto-deploy-image to v2.59.1](gitlab-org/gitlab@76776dc235609d41130648743e8fed2952df2eb3) ([merge request](gitlab-org/gitlab!134230))
- [Migrate the epic actions dropdown to GlDisclosureDropdown](gitlab-org/gitlab@00d5d28135b1795cf31dc7e3e204232484af51ec) ([merge request](gitlab-org/gitlab!134114)) **GitLab Enterprise Edition**
- [Synch index addition for index_vulnerabilities_on_project_id_and_id](gitlab-org/gitlab@931f52440ff23000ee210024b9a0a33e49b484d9) ([merge request](gitlab-org/gitlab!134201)) **GitLab Enterprise Edition**
- [Remove dead code in pipeline presenter](gitlab-org/gitlab@e43c64ed28907c6c766fa41386522873b67b8c8b) ([merge request](gitlab-org/gitlab!134154))
- [Add schedules pagination](gitlab-org/gitlab@af0738783a22eae0297ca03d61ffcb75a676b40d) ([merge request](gitlab-org/gitlab!133758))
- [Remove search_commits_hide_archived_projects flag](gitlab-org/gitlab@78840fa4dc69db9df74ff079c66f5eccc2dde429) ([merge request](gitlab-org/gitlab!132122))
- [Fixing rubocop testid exceptions No. 3](gitlab-org/gitlab@40a9007063103cd7ccecb326f2b7e470a4a62c93) ([merge request](gitlab-org/gitlab!134156)) **GitLab Enterprise Edition**
- [Improve order of mention autocomplete results](gitlab-org/gitlab@a41885ffc09f98efcd74c1f630c1e668b07bc638) ([merge request](gitlab-org/gitlab!134153))
- [Remove search_blobs_hide_archived_projects flag](gitlab-org/gitlab@368fd61f6ffbb3b536a01a77b54236a5c906128b) ([merge request](gitlab-org/gitlab!132123))
- [Move notifications and todos on issues](gitlab-org/gitlab@5d7584ecb5895b04d5555ccc1beb15cd5e39ff17) ([merge request](gitlab-org/gitlab!133474))
- [Ci::BuildNeed name limit increase](gitlab-org/gitlab@717a6f148ec2869ea67a3ca6915caddde78f5a20) ([merge request](gitlab-org/gitlab!133689))
- [Activate and deactivate streaming headers](gitlab-org/gitlab@ed37b6a7ce1d92055c80c70ca35c36fcdb6fe9bf) ([merge request](gitlab-org/gitlab!130584)) **GitLab Enterprise Edition**
- [Migrate kerberos copy url button](gitlab-org/gitlab@91d2cd671f18053f9c3c55f69dac0deb45b413c2) ([merge request](gitlab-org/gitlab!134138))
- [Record a custom attribute when auto banning users](gitlab-org/gitlab@595e50dc957aa65b1a18ee6ed9b8fa9631d914fd) ([merge request](gitlab-org/gitlab!132641))
- [MR widget: Align environment button with widget expand button](gitlab-org/gitlab@5935acd04fac27b9234e18005d6eee6cb8a24824) ([merge request](gitlab-org/gitlab!134101))
- [Domain edit page: Migrate clipboard button](gitlab-org/gitlab@5db3372e6f1dab67bf1bba1b77bbe868d8b61ef8) ([merge request](gitlab-org/gitlab!134095))
- [MR sidebar: Migrate clipboard buttons](gitlab-org/gitlab@1227e7a64a19aa049856a94c9e1990fa0858798e) ([merge request](gitlab-org/gitlab!134092))
- [Add project count for namespace API when admin](gitlab-org/gitlab@96e4f8cbec0cf91777bba4f8e1a2d264752ce8ea) ([merge request](gitlab-org/gitlab!133905)) **GitLab Enterprise Edition**
- [Clone repo clipboard button migration](gitlab-org/gitlab@1a492e920d59dc2a43ffb5c408344dede5bf6ba8) ([merge request](gitlab-org/gitlab!134082))
- [Remove deprecated_clipboard_button from user homepage](gitlab-org/gitlab@d0a0be5c664b74cc2d20b85cce011756e6299c72) ([merge request](gitlab-org/gitlab!134079))
- [SSH Key detail page: Migrate clipboard button](gitlab-org/gitlab@a26bbd9e1b9e363996db66e54c2c84835f31e0de) ([merge request](gitlab-org/gitlab!134080))
- [Commit SHA align appearance across pipeline, job, mr](gitlab-org/gitlab@866150d90324f39293f24c961d7b5bdf31876626) ([merge request](gitlab-org/gitlab!133509))
- [Swap the columns for ci_sources_pipelines](gitlab-org/gitlab@2bc337e2ecf8b8d21a9e038c596a270181f6437e) ([merge request](gitlab-org/gitlab!133312))
- [Move projects.scss to page_bundles](gitlab-org/gitlab@a324a0e749a89ac4cee3b170beab0f109b6bcebd) ([merge request](gitlab-org/gitlab!131405))
- [Remove deprecated_clipboard_button in Slack](gitlab-org/gitlab@537682e976c770c80feb80c6da16b324f8e67733) ([merge request](gitlab-org/gitlab!134039))
- [Swap the columns for ci_stages](gitlab-org/gitlab@99d0fb0cff2cbb4b806252b1e4ae4d445ad5c9ab) ([merge request](gitlab-org/gitlab!133307))
- [Swap the columns for ci_pipelines](gitlab-org/gitlab@76ff74fb0cbc75780965f74ba78ccd3cbdf1adb1) ([merge request](gitlab-org/gitlab!134038))
- [Make sure scoped label remove icon is visible](gitlab-org/gitlab@840f83a0997aeb177e22faf4d4c00667c59ccde4) ([merge request](gitlab-org/gitlab!134027))
- [Change add-on availability to use UserAssignment](gitlab-org/gitlab@8360d83e767143f08e1736ccf36e5628aa11da59) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/133277)) **GitLab Enterprise Edition**
- [Add instance GCP logging streaming destinations](gitlab-org/gitlab@24bafbb23bd6d899d964948500f80c8c20fe6ce7) ([merge request](gitlab-org/gitlab!131851)) **GitLab Enterprise Edition**
- [Migrate split_button to button group with Listbox](gitlab-org/gitlab@8fcf1bec83225a06bf411c2444ed6e9b08f339ce) ([merge request](gitlab-org/gitlab!133402)) **GitLab Enterprise Edition**
- [Remove move_close_into_dropdown feature flag](gitlab-org/gitlab@56b36bc4b5a80ac18ee38f0998d878edc1425a03) ([merge request](gitlab-org/gitlab!133475))
- [Add (gpg_key_id, id) index to gpg_signatures](gitlab-org/gitlab@a340f81fd2b315d5678b33f07ff217bb7bc93aab) ([merge request](gitlab-org/gitlab!133705))
- [Update dependency auto-deploy-image to v2.59.0](gitlab-org/gitlab@ddbea7ed6800a4869de0def56e3766470026e3d3) ([merge request](gitlab-org/gitlab!133997))
- [Pass CVSS to common security report parser](gitlab-org/gitlab@fa38715e0f43cbad0f5282382d89e3ece8647f1b) ([merge request](gitlab-org/gitlab!133743)) **GitLab Enterprise Edition**
- [Make impossible to turn on Rugged feature flags](gitlab-org/gitlab@ecc8ab566bcb7ac4da447e7ddf369433f76a45ee) ([merge request](gitlab-org/gitlab!132091))
- [Enable streaming for gitlab duo](gitlab-org/gitlab@adfda1dba076af4d345cd6c3ba4630be3c17f170) ([merge request](gitlab-org/gitlab!133754)) **GitLab Enterprise Edition**
- [Add email custom text to registration features](gitlab-org/gitlab@496e0e3836f11d32d483537911ed10c1cfe64a89) ([merge request](gitlab-org/gitlab!133713)) **GitLab Enterprise Edition**
- [Update related epic links permissions](gitlab-org/gitlab@51f1c60b0d6370b041940f5ff30e4f03e67afb0b) ([merge request](gitlab-org/gitlab!133837)) **GitLab Enterprise Edition**
- [Geo: Proxy Git fetch/clone over SSH via Gitlab Shell](gitlab-org/gitlab@cc7079e9cb75606e8ed2cc55320213b30f80d33c) ([merge request](gitlab-org/gitlab!133920)) **GitLab Enterprise Edition**
- [Removed MAX_PANELS_LIMIT for Value Streams Dashboard](gitlab-org/gitlab@0afd6a17933b70b63afb1aac25a56a7ed27aad3c) by @tedtran2019 ([merge request](gitlab-org/gitlab!133555)) **GitLab Enterprise Edition**
- [Change epic daterange dropdown to use listbox](gitlab-org/gitlab@e06f0218e40e4c73e00397eedfd704919c5a4c1a) ([merge request](gitlab-org/gitlab!133873)) **GitLab Enterprise Edition**
- [Create deployments for ready-to-run jobs only](gitlab-org/gitlab@1741fa002b940086f63de0977bfddb1a86371315) ([merge request](gitlab-org/gitlab!132835))
- [Modify ETV Anthropic implementation to remove precanned response text](gitlab-org/gitlab@7ec9e295680eda959a46abc316d6741818849e72) ([merge request](gitlab-org/gitlab!130338)) **GitLab Enterprise Edition**
- [Swap the columns for ci_pipeline_chat_data](gitlab-org/gitlab@b5128839e8eab909c161c18e97b8e397b65c0142) ([merge request](gitlab-org/gitlab!131243))
- [Add issue analytics to registration features](gitlab-org/gitlab@bd4d3c9115b285241ce87638abbc1b8720ba58c7) ([merge request](gitlab-org/gitlab!133848)) **GitLab Enterprise Edition**
- [Use font-display: swap for custom fonts](gitlab-org/gitlab@36420614d6e99131ccf23ce961eb0a704eabc2d0) ([merge request](gitlab-org/gitlab!133828))
- [This MR migrates legacy dropdown](gitlab-org/gitlab@5d7cc83578d048d3db496c065951ba84b23d4e23) ([merge request](gitlab-org/gitlab!132883)) **GitLab Enterprise Edition**
- [Clean up the feature flag search_milestones_hide_archived_projects](gitlab-org/gitlab@af53561c1353acf11ff19b20ed791964c1e9a55f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/133820)) **GitLab Enterprise Edition**
- [Remove redundant version in runner details](gitlab-org/gitlab@1d2d4f15e1bf6e1f97dd4f8a4c7e502a1761cb75) ([merge request](gitlab-org/gitlab!133443))
- [Extract runner package host to constants.js](gitlab-org/gitlab@f40bf14d3b67605b86860a7da09a8ee76707033a) by @orozot ([merge request](gitlab-org/gitlab!133656))
- [Update dependency auto-deploy-image to v2.58.1](gitlab-org/gitlab@28013fb5736c1c755c523325560213542b22803e) ([merge request](gitlab-org/gitlab!133794))
- [Stop showing the explore plans link on the billing page](gitlab-org/gitlab@e0e1ec15490e0f9c3eec4abe4d9c5c3eeb03f3ac) ([merge request](gitlab-org/gitlab!133765)) **GitLab Enterprise Edition**
- [Use `InOperatorOptimization` for group vulnerabilities](gitlab-org/gitlab@eb588e271b513e374188b70b1e3de7cd2e1915df) ([merge request](gitlab-org/gitlab!127180)) **GitLab Enterprise Edition**
- [Changes props on GlFormInut, GlFormSelect & GlDatepicker](gitlab-org/gitlab@9edaf64baf61f4d79461a20b9540486f046aa45f) ([merge request](gitlab-org/gitlab!133693))
- [Update tag size in warning alert](gitlab-org/gitlab@e55c3ef3875054a0e5e53821ea09223843b0c13a) ([merge request](gitlab-org/gitlab!133718))
- [Add group wiki to registration features](gitlab-org/gitlab@4dbe0745978ec9a75437f1fc4252fd902001f1c6) ([merge request](gitlab-org/gitlab!133670)) **GitLab Enterprise Edition**
- [Database backup script supports overriding individual database settings](gitlab-org/gitlab@959af10c0176368b84e7f2880af9813ef5dd691b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/133177))
- [Set force_include_all_resources to default true in database](gitlab-org/gitlab@16547234947ebb357b9d4baac50d8e2455b50a68) ([merge request](gitlab-org/gitlab!133324))
- [Override project approval settings](gitlab-org/gitlab@99f4be745b7c4cd5a970b1d075465f442c91c90c) ([merge request](gitlab-org/gitlab!132254)) **GitLab Enterprise Edition**
- [Fix complaince in admin mode](gitlab-org/gitlab@c52529f76bc99147b333836842609e93dd8f5b78) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/132954)) **GitLab Enterprise Edition**
- [Remove redundant details in runner page](gitlab-org/gitlab@e24af9e24a8d338cb8b3fa0f9a19ebb443bc8d7b) ([merge request](gitlab-org/gitlab!133433))
- [Project overview Edit button fix](gitlab-org/gitlab@0403f4ac6e8ed21a8193f979a07118b4ca2012af) ([merge request](gitlab-org/gitlab!133508))
- [Remove `group_level_licenses` feature flag](gitlab-org/gitlab@bad1779d75b4952f40f7b69e0acfe84f25ad94a7) ([merge request](gitlab-org/gitlab!132698)) **GitLab Enterprise Edition**
- [Add licenses to group level dependency list export](gitlab-org/gitlab@0028ee148c95b4e281bb360590fd7fc936a743ae) ([merge request](gitlab-org/gitlab!133379)) **GitLab Enterprise Edition**
- [Update illustrations](gitlab-org/gitlab@c562ff38f43e94a9168d7bbe31cb27ccf7515e1a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/132979))
- [Move notifications and todos to buttons at top of page](gitlab-org/gitlab@acded872266e08a697d455aa4f49a786d2a38146) ([merge request](gitlab-org/gitlab!132678))
- [Clean up automatic_trial_registration experiemnt](gitlab-org/gitlab@8d571d6d738e410642506a682914a5dc0da4870c) ([merge request](gitlab-org/gitlab!129007)) **GitLab Enterprise Edition**
- [Enable semi-linear merge trains (behind feature flag)](gitlab-org/gitlab@3a720bee044d0e401f54d2de6534477a2be6b42d) ([merge request](gitlab-org/gitlab!132898)) **GitLab Enterprise Edition**
- [Add the readme tab to the CI catalog details](gitlab-org/gitlab@18678860f356e519cacbddc53b9a6a85e0081537) ([merge request](gitlab-org/gitlab!132408)) **GitLab Enterprise Edition**
- [Update dependency auto-deploy-image to v2.58.0](gitlab-org/gitlab@16637da774b9a52c0f5c1e711c5bfda9a23044b2) ([merge request](gitlab-org/gitlab!132985))
- [Fix broken master](gitlab-org/gitlab@a21d79ee059fb852e0dc02c3c02c96777d1ea7cc) ([merge request](gitlab-org/gitlab!133441))
- [Update loading of streaming destinations](gitlab-org/gitlab@e7a2baaf9cbd6d383230276694d07435d50a5591) ([merge request](gitlab-org/gitlab!133151)) **GitLab Enterprise Edition**
- [Restructure Catalog details page](gitlab-org/gitlab@85103b50750c037d89b12dadf8282dcaf70ec349) ([merge request](gitlab-org/gitlab!132293)) **GitLab Enterprise Edition**
- [Improve spacing vulnerability details buttons](gitlab-org/gitlab@462a98d1fb14d0fcd2483c2cbaf76c1046277e17) ([merge request](gitlab-org/gitlab!133414)) **GitLab Enterprise Edition**
- [Allow restoring a specific backup with server-side backups](gitlab-org/gitlab@8e15b27e57661af6439708169a5f1efc3cabf101) ([merge request](gitlab-org/gitlab!132188))
- [Update copy on welcome page during free registration](gitlab-org/gitlab@f3a266b6ae4137a6a4a9c6ca2cb38bd0f7e6abd3) ([merge request](gitlab-org/gitlab!133357)) **GitLab Enterprise Edition**
- [Remove group_level_dependencies ff](gitlab-org/gitlab@00be09056f1d5b69b01142dcd9bf087b3f07af39) ([merge request](gitlab-org/gitlab!132015)) **GitLab Enterprise Edition**
- [Allow group owner access to ssh certs api](gitlab-org/gitlab@0909595e8f247506fb95568b9e8930bd96cd53b1) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/132867)) **GitLab Enterprise Edition**
- [Migrate build_timeout to respect the max](gitlab-org/gitlab@518b677278efc07d1091593816d7a7fcd4ab6ff7) ([merge request](gitlab-org/gitlab!132677))
- [Add logo to Telegram integration](gitlab-org/gitlab@9d23abb093cab4f33283de40c8c0c82b91d337eb) ([merge request](gitlab-org/gitlab!133072))
- [Use attachment_color for embed colors in Discord integration](gitlab-org/gitlab@373d85ad1943db8bd6cae6c59783628e3d73ccef) by @Taucher2003 ([merge request](gitlab-org/gitlab!133120))
- [Pipeline detail: Update CiIcon to CiBadgeLink](gitlab-org/gitlab@0e6369b36eb44af7c9029cc46273324b3fbdb65f) ([merge request](gitlab-org/gitlab!133074))
- [Show additional access levels for custom roles](gitlab-org/gitlab@c0f69dc849c60a175386b5d02d72cfff9a667468) ([merge request](gitlab-org/gitlab!132922)) **GitLab Enterprise Edition**
- [Update Jira links](gitlab-org/gitlab@36cfba8686ca98dc655b727fcbdb5a778a032127) ([merge request](gitlab-org/gitlab!133282))
- [This MR prevents page refresh](gitlab-org/gitlab@e505c7ccfc8492f9399787b2370749a7dc4937b9) ([merge request](gitlab-org/gitlab!133007)) **GitLab Enterprise Edition**
- [Shows all recorded metrics for a candidate](gitlab-org/gitlab@c0e768c6c436a7f1d03a9d76cd591925174b49f2) ([merge request](gitlab-org/gitlab!131527))
- [Save Vertex AI Access Token in database](gitlab-org/gitlab@63163de51c13add85f6d6e17d0df2287b406a299) ([merge request](gitlab-org/gitlab!130814)) **GitLab Enterprise Edition**
- [Add logo to Bamboo integration](gitlab-org/gitlab@1fd94e8f839a59cff08a1d0ccda3f8686152d86f) ([merge request](gitlab-org/gitlab!133188))
- [Rack::Attack - consider /oauth endpoints as API endpoints](gitlab-org/gitlab@ebff890291125ad1fcf5cb77eb06a3d42935e4cc) ([merge request](gitlab-org/gitlab!133109))
- [Swap the columns for ci_pipeline_messages](gitlab-org/gitlab@0d819b4c13b3d2fd71a6946917df1b68b9e085d9) ([merge request](gitlab-org/gitlab!133191))
- [Aligns upgrade badge to the surrounding text](gitlab-org/gitlab@a07a08d8f22e408fd81a46b0d128fd546b85fd5a) ([merge request](gitlab-org/gitlab!133183))
- [Update mermaid version to 10.5.0](gitlab-org/gitlab@7625fa4b631cb1256d3ecd5433fd9c47788c4ff4) ([merge request](gitlab-org/gitlab!133185))
- [Child issues and epics widget: Add empty message](gitlab-org/gitlab@3c6e2a72871995bdde8a501900b4f369ed05dcba) ([merge request](gitlab-org/gitlab!132866)) **GitLab Enterprise Edition**
- [Sync validate foreign key for ci_sources_pipelines](gitlab-org/gitlab@e27e3a2811bc4bf2e9e7fc1064828b4c91824706) ([merge request](gitlab-org/gitlab!132957))
- [Sync validate foreign key for ci_pipelines](gitlab-org/gitlab@91a1788d18eb059acd8d251062b27a24e12b32b9) ([merge request](gitlab-org/gitlab!133162))
- [Add dev documentation for bitbucket importer](gitlab-org/gitlab@465eb660f2f6434052ed0f6c083955108c86c967) ([merge request](gitlab-org/gitlab!132258))
- [Add Sidebar Confidentiality Widget to Test Cases](gitlab-org/gitlab@acd34d4137a3371b3b20a3fdea8a500a4ff0d97d) ([merge request](gitlab-org/gitlab!132897)) **GitLab Enterprise Edition**
- [Allow terraform reports to be seen with a blocked/incomplete state](gitlab-org/gitlab@1afd11aea867f16fb731f479a50b0970618695be) by @vermainfinite ([merge request](gitlab-org/gitlab!132497))
- [Remove geo_batch_count feature flag](gitlab-org/gitlab@184bbf20035d7d87a17d4c236b0c9188eaa2a0b0) ([merge request](gitlab-org/gitlab!133013)) **GitLab Enterprise Edition**
- [Use cronjob to delete old pages deployments](gitlab-org/gitlab@eb3af4d0e1cd3212c5bc242dc21bf04a6b42ca0a) ([merge request](gitlab-org/gitlab!132252))
- [Remove references to lfs_batch_direct_downloads](gitlab-org/gitlab@48b1ec008cd2324e8f51e6cf42e520a9650420e4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/133078))
- [Geo Sites - Migrate GlDropdown](gitlab-org/gitlab@56a2bf1603f4ae6783d6f75ef35636d8d6665652) ([merge request](gitlab-org/gitlab!132807)) **GitLab Enterprise Edition**
- [Use CiBadgeLink instead of CiIcon for Pipeline Mini Graph](gitlab-org/gitlab@b2c5fd5ae1a6f8fc7dc73da6b53d7f72c4079192) ([merge request](gitlab-org/gitlab!132623))
- [Add refresh_interval to gitlab:elastic:info](gitlab-org/gitlab@cd54f9f513fb9aa757297173f0a0620e4bceb86b) ([merge request](gitlab-org/gitlab!132989)) **GitLab Enterprise Edition**
- [Performance Bar improvements](gitlab-org/gitlab@514dfbbdbfc85a196ef79ad1b96cf637351addcb) ([merge request](gitlab-org/gitlab!132763))
- [Remove redundant runner version upgrade alert](gitlab-org/gitlab@558106592e872a77684a1e095e3ddf0c81a255b4) ([merge request](gitlab-org/gitlab!132728)) **GitLab Enterprise Edition**
- [Adding OKR checkin reminder todo item](gitlab-org/gitlab@440c07cd7e8734b85470cfa1cdb42ae525c4e529) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/132175)) **GitLab Enterprise Edition**
- [Fix grammar in approval rules docs](gitlab-org/gitlab@da336c92216bb6047f41084c41f2a9e7a7ff8378) ([merge request](gitlab-org/gitlab!133003))
- [This MR migrates legacy dropdown](gitlab-org/gitlab@c2c7a904b95c7518f728380f2633eee8e9c78131) ([merge request](gitlab-org/gitlab!132649)) **GitLab Enterprise Edition**
- [Enable cached_security_policies by default](gitlab-org/gitlab@80e45adab521d108d306463a42c5b65140f42fce) ([merge request](gitlab-org/gitlab!132969)) **GitLab Enterprise Edition**
- [Create pending status check responses per MR](gitlab-org/gitlab@cdcd3c154170e24f8be315152c0c1a7d58043848) ([merge request](gitlab-org/gitlab!124811)) **GitLab Enterprise Edition**
- [Update the upgrade badge to contain more details](gitlab-org/gitlab@330b465a22c5af1c4388b209bb9ec4dfe7dd26d6) ([merge request](gitlab-org/gitlab!132636)) **GitLab Enterprise Edition**
- [Sync validate foreign key for ci_stages](gitlab-org/gitlab@206ee6b8d5d53d775aaef2448cb53aea3037f7b4) ([merge request](gitlab-org/gitlab!132956))
- [Export last activity details](gitlab-org/gitlab@2d63fc105e27ec076b993cfde368ee95df725715) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/132612)) **GitLab Enterprise Edition**
- [Expand import error message](gitlab-org/gitlab@16a1cf2bd8d7465097ff6cf8637890cf166fbedb) ([merge request](gitlab-org/gitlab!132806))
- [Update adherence table thWidths](gitlab-org/gitlab@54828a4c288b67e3a56a505d89c09bded2996d52) ([merge request](gitlab-org/gitlab!132800)) **GitLab Enterprise Edition**
- [This MR migrates legacy dropdown](gitlab-org/gitlab@7c6b4196da13c1204c6168736efd543a75bbe30d) ([merge request](gitlab-org/gitlab!132657)) **GitLab Enterprise Edition**
- [Allow long group description (backend)](gitlab-org/gitlab@fd7ea5fea610f5ff3ec9ff3618edd8cf6a2458da) by @freznicek ([merge request](gitlab-org/gitlab!132920))
- [Remove "Add seats" btn from usage quotas for community plans](gitlab-org/gitlab@1517c9a5ad4743f429d058c5290388c9d6a5694a) ([merge request](gitlab-org/gitlab!131443)) **GitLab Enterprise Edition**
- [Update dependency auto-deploy-image to v2.57.0](gitlab-org/gitlab@dfb22f3f8969902ac9c03a3c49c61934d48d6194) ([merge request](gitlab-org/gitlab!132905))
- [Consolidate Puma low-level error handler code](gitlab-org/gitlab@80b76a16e06bebba149d4acdbe63cbbe0990a853) ([merge request](gitlab-org/gitlab!132581))
- [This MR migrates legacy dropdown](gitlab-org/gitlab@6328a4df2ae0a990ef8ff7d9ce20f829258b6c8d) ([merge request](gitlab-org/gitlab!132041)) **GitLab Enterprise Edition**
- [This MR migrates legacy dropdown](gitlab-org/gitlab@c6c9f6172e9786ebd28154e449cc4cc06e480b2c) ([merge request](gitlab-org/gitlab!132706)) **GitLab Enterprise Edition**
- [Swap columns for shared_runners_duration conversion](gitlab-org/gitlab@b44fbab5601d7be96c2e3d1696843d96a49e59e4) ([merge request](gitlab-org/gitlab!132225))
- [Truncate time in environments page](gitlab-org/gitlab@262e95e426aff4f31576c723db84b9d3e7794913) by @vermainfinite ([merge request](gitlab-org/gitlab!131962))
- [Update dependency auto-build-image to v1.42.0](gitlab-org/gitlab@05d9861fd844e19bfd5a5d3c9ed75e13d1b319f5) ([merge request](gitlab-org/gitlab!132769))
- [Allow merges in the absence of a pipeline](gitlab-org/gitlab@e9899633db92b8a0b36e79559da70d19540d9f50) ([merge request](gitlab-org/gitlab!132681))
- [Improve standards adherence report](gitlab-org/gitlab@bdbf13ea58f4d1bdebd5d70bd04afd15cc8af12c) ([merge request](gitlab-org/gitlab!132564)) **GitLab Enterprise Edition**
- [When user has 2FA enabled, do not attempt OAuth password auth](gitlab-org/gitlab@68f14a2951bedbff3847963d1977d8da52845f7e) ([merge request](gitlab-org/gitlab!132758))
- [Enable `ingest_sbom_licenses` by default](gitlab-org/gitlab@4157888256af82a025e1b476d14fa0d95dd495a3) ([merge request](gitlab-org/gitlab!132292)) **GitLab Enterprise Edition**
- [feat: Add runner type badge to jobs table in admin job page](gitlab-org/gitlab@67c3ae02e7a05c1e9e8bf2474deecbf979ce629c) by @gerardo-navarro ([merge request](gitlab-org/gitlab!123932))
- [Remove visible_label_selection_on_metadata feature flag](gitlab-org/gitlab@3ea64011ad4556780f7163344121092b28b0e750) ([merge request](gitlab-org/gitlab!132361))
- [Replace loading icon with destination path as text](gitlab-org/gitlab@4f1f5538996bfa6d429fb9f02f4fcff0bc7ed926) ([merge request](gitlab-org/gitlab!132514))
- [Import bitbucket notes](gitlab-org/gitlab@13f482afee20af0f1161ca38be40d8bc922de67c) ([merge request](gitlab-org/gitlab!131149))
- [MIgrate chat names to GlTable](gitlab-org/gitlab@fc0a2075286a57950abbe559b4d20d4ed79a9b49) ([merge request](gitlab-org/gitlab!132638))
- [Replace feature flag for Code Suggestions tab on Usage Quotas page](gitlab-org/gitlab@2d1771a028be2eb600d24126675df3d96d608162) ([merge request](gitlab-org/gitlab!132709)) **GitLab Enterprise Edition**
- [Update text in CI status badges](gitlab-org/gitlab@c0bb9a42a94a41ae45e007df7c3f9b8ca17d6b67) ([merge request](gitlab-org/gitlab!130269))
- [Update docs for status check removal](gitlab-org/gitlab@b1debaca114a1bc6e79dee4c74225361f08f1d6c) ([merge request](gitlab-org/gitlab!132625))
- [Cleaning up build_ios_app_guide_email experiment](gitlab-org/gitlab@010e900c21d63c0aab6e134b3d3601592719b25c) ([merge request](gitlab-org/gitlab!131787))
- [Update AI architecture documentation](gitlab-org/gitlab@19defe0f9c33b3109f5b08d05231fb9ced046c3f) ([merge request](gitlab-org/gitlab!131772))
- [Fix cross database join in fetch_policy_approvers_service](gitlab-org/gitlab@5c96832a586868acd47852f1a2f47938fd73cc7b) ([merge request](gitlab-org/gitlab!132621)) **GitLab Enterprise Edition**
- [Tidy up jobs list](gitlab-org/gitlab@72d8551afc5ed23af4917f07fcf927ad26c69615) ([merge request](gitlab-org/gitlab!131126))
- [Remove `maxlength` limit from the group description textarea](gitlab-org/gitlab@851b8dc8f0ac5b320a59b945bc1c133cb4b162ed) ([merge request](gitlab-org/gitlab!132451))
- [Handle optional approvals in policy bot comment](gitlab-org/gitlab@00507c2177431573d78dd3f16cee848c1817f467) ([merge request](gitlab-org/gitlab!132417)) **GitLab Enterprise Edition**
- [Fix RetryJob mutation ID type](gitlab-org/gitlab@4edb25e8521199e1c3ecb072de4be167ac8b837e) ([merge request](gitlab-org/gitlab!130222))
- [Adding index on work_item_progresses.reminder_frequency](gitlab-org/gitlab@ed65d104572754fc4df0219ad199b13daf7ae18d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/132577))
- [Make epic creation dropdown Pajamas compliant](gitlab-org/gitlab@e17a0072b60c7f45814c9399ca7e53ca1fa4792f) ([merge request](gitlab-org/gitlab!131885)) **GitLab Enterprise Edition**
- [Hide Application Analytics when experiments are disabled](gitlab-org/gitlab@660419575c0565b93edd9efd2e6335d2769b1e70) ([merge request](gitlab-org/gitlab!131915))
- [Job page: restructre page](gitlab-org/gitlab@fd0ec1657ffed80f1e130b4f88714f1c59fb3d1b) ([merge request](gitlab-org/gitlab!130317))
- [Make pipeline header mobile](gitlab-org/gitlab@9d35c6860409e428d578dac29faec01a85cb89cb) ([merge request](gitlab-org/gitlab!132415))
- [Raise MissingAttributeError with explicit message](gitlab-org/gitlab@eb0aba2d3cbf5e2ae6b9d4c638eff2b25d87acfc) ([merge request](gitlab-org/gitlab!132549))
- [Find squashed commit if normal commit is not found on import](gitlab-org/gitlab@41daf940dc8a8696b99e34d177638bbd3d92a5dd) ([merge request](gitlab-org/gitlab!131894))
- [Respond with 401 instead of 404 on npm unauthenticated requests](gitlab-org/gitlab@a201195bbae9e58f42c1b0aa816506f8b356e513) ([merge request](gitlab-org/gitlab!131074))
- [Updates CiIcon to CiBadge](gitlab-org/gitlab@fcc4b03ccbb4cbab226c4f4c0af139fdaae5ce6b) ([merge request](gitlab-org/gitlab!131036))
- [Enforce not null constraints for workspace personal_access_token_id](gitlab-org/gitlab@7aaebd3cb0c66b86a48c95d46efce3e2d98e5d30) ([merge request](gitlab-org/gitlab!132026))
- [Rename framework folder to projects](gitlab-org/gitlab@5709617770789239c4c3b4b203869ac7febad355) ([merge request](gitlab-org/gitlab!132482)) **GitLab Enterprise Edition**
- [Remove deprecated unlock LDAP membership feature](gitlab-org/gitlab@24b5a4d59269aabf4847f1441804ee2aefb79592) ([merge request](gitlab-org/gitlab!132459)) **GitLab Enterprise Edition**
- [Add pagination to standards adherence table](gitlab-org/gitlab@dd20647bcc4c30f9691fe19a917c4c4cab2359a1) ([merge request](gitlab-org/gitlab!131585)) **GitLab Enterprise Edition**
- [Add optional SHA parameter to CI lint API](gitlab-org/gitlab@e0d0bfeea568d067e642b7f6fe77fbd8272ec1cd) by @oula.kuuva ([merge request](gitlab-org/gitlab!131890))
- [Make boards selector dropdown Pajamas compliant](gitlab-org/gitlab@707f61d96e404666271a3adb9c0433afb8f1c29b) ([merge request](gitlab-org/gitlab!129722))
- [Move labels.scss to page_bundles from page_specific_bundles](gitlab-org/gitlab@7c6e3f9ddacd2ac135644535d0f177713c6fd89b) ([merge request](gitlab-org/gitlab!131606))
- [Update artifacts page layout](gitlab-org/gitlab@eb6fa651f597524a8eeecad5b57f34cc55663466) ([merge request](gitlab-org/gitlab!131928))
- [Removes the mobile_devops_projects_promo feature flag](gitlab-org/gitlab@d3ec61e66a23b23fc82efd6c4d10462107a50f28) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/132405))
- [Redirect product planning hierachy page](gitlab-org/gitlab@2ed7821bf47846fb6c325cb35c736e65259adfbe) ([merge request](gitlab-org/gitlab!132113))
- [Update spacing and classes of user profile controls](gitlab-org/gitlab@18f623ac94d8adb37a5927f0023e0373750aa408) ([merge request](gitlab-org/gitlab!132280))
- [feat(web_ide): Added new API for VS Code Settings](gitlab-org/gitlab@e06349eb70c1760a26a5b7d04b32cd5eb179ef02) ([merge request](gitlab-org/gitlab!131900))
- [This MR migrates legacy dropdown](gitlab-org/gitlab@df7b86157871d8cf4cec65dcd33fcafbdbcc7a70) ([merge request](gitlab-org/gitlab!131951)) **GitLab Enterprise Edition**
- [Fix for z-index bug for label filter](gitlab-org/gitlab@0dc619de1581445b0a67ac7eed32810880b5f27f) ([merge request](gitlab-org/gitlab!132143))
- [Upgrade to grpc v1.58.0](gitlab-org/gitlab@5b8939a9508fd5de2e21ed1c8ca51e48241a6213) ([merge request](gitlab-org/gitlab!132287))
- [Rename copy of GitHub PR attachments stat](gitlab-org/gitlab@d8cc2eea4491ab728dc7d44c859d5dff1f5f0ad3) ([merge request](gitlab-org/gitlab!132308))
- [Update Rails to 7.0.8](gitlab-org/gitlab@ff67a2a57afce7c9c26e2c41f43d50446d670d7f) ([merge request](gitlab-org/gitlab!132044))
- [Use handRaiseLeadButton in code_suggestions_intro](gitlab-org/gitlab@c4826abc3437809bdcd9e72ebf017f8c7dcbdf2f) ([merge request](gitlab-org/gitlab!131811)) **GitLab Enterprise Edition**
- [Updates CSP for Google Analytics 4](gitlab-org/gitlab@ad95bb1102c154a8ba279b4ce28b1f885abaecaf) ([merge request](gitlab-org/gitlab!131861))
- [Update URL for work items with type issue](gitlab-org/gitlab@e1603a71ea1d753e5a02b8dcddc4f9f72bde67d1) ([merge request](gitlab-org/gitlab!132250))
- [Update job page layout](gitlab-org/gitlab@1fe2d4978398441cbf112afc970cb8a032b84759) ([merge request](gitlab-org/gitlab!131806))
- [Remove use of the welcome controller and route in CE](gitlab-org/gitlab@4c12c59ebbede1e117328c47fb984b5870b0eb7a) ([merge request](gitlab-org/gitlab!130335))
- [Fix epic header actions when feature flag is off](gitlab-org/gitlab@51879cbc8f3f79aad114681c018acf270d2d409a) ([merge request](gitlab-org/gitlab!132227)) **GitLab Enterprise Edition**
- [Import bitbucket issues](gitlab-org/gitlab@732209bc34be9e58bcdd5924a987fbc9e9b78ae0) ([merge request](gitlab-org/gitlab!131138))
- [Feature flag cleanup: standalone finding modal FE](gitlab-org/gitlab@5b1dad93bc7788eac1517d44bf86f4e294b8beec) ([merge request](gitlab-org/gitlab!131481)) **GitLab Enterprise Edition**
- [Add project push rules changes auditor](gitlab-org/gitlab@0ed7fd2b1e22516a6a74b6e0b4887f191f82157e) ([merge request](gitlab-org/gitlab!132157)) **GitLab Enterprise Edition**
- [Enable the ssh access by default in the Composer package registry](gitlab-org/gitlab@21fc803a98aac30b3f79ad81fb4181e7de7eaafc) ([merge request](gitlab-org/gitlab!132147))
- [Update schedule pipeline layout](gitlab-org/gitlab@aeb8d46cb7cdb2d69cc7feb6d999ee36d4f45735) ([merge request](gitlab-org/gitlab!131673))
- [Do not save contributors and exports fields in npm metadata](gitlab-org/gitlab@320fedd830a49a81e40cd1a42e69de85420f7677) ([merge request](gitlab-org/gitlab!132139))
- [Prevent namespace level banned users from accessing inviting projects](gitlab-org/gitlab@da5de935c123c74999dcc6f8c91c2f9de481030e) ([merge request](gitlab-org/gitlab!130654)) **GitLab Enterprise Edition**
- [This MR migrates legacy dropdown](gitlab-org/gitlab@dd77e3e654f9cfd05375962d96643e975a2c84d8) ([merge request](gitlab-org/gitlab!131952)) **GitLab Enterprise Edition**
- [Sync validate foreign key for ci_pipeline_messages](gitlab-org/gitlab@b7005c39c3a12a3ec8c254bd28d9cf28d4a2ac0e) ([merge request](gitlab-org/gitlab!131251))

### Deprecated (2 changes)

- [Deprecate groupApprovers field in ScanResultPolicyType](gitlab-org/gitlab@4c0d1bb57a23f73a695b97f77e83e8b77ff23afd) ([merge request](gitlab-org/gitlab!132786)) **GitLab Enterprise Edition**
- [Add deprecation for openSUSE Leap 15.4](gitlab-org/gitlab@4a7b5e7a905cf1d3803b3cabaec284674f7cd143) ([merge request](gitlab-org/gitlab!132050))

### Removed (26 changes)

- [Re-remove the member_tasks table](gitlab-org/gitlab@160a0e203c61262e4baa86fcd86fec23a994ad6b) ([merge request](gitlab-org/gitlab!134452))
- [Clean up bigint conversion for notes (self-managed)](gitlab-org/gitlab@eb14837fe0ce7124eaf05c2c9b63ea49d9313f96) ([merge request](gitlab-org/gitlab!134217))
- [Remove gitlab_gtm_datalayer feature flag](gitlab-org/gitlab@99675af98a32a4afd2cb93a4ab8b204564cc27ca) ([merge request](gitlab-org/gitlab!134284)) **GitLab Enterprise Edition**
- [Remove remove_legacy_github_client flag](gitlab-org/gitlab@070c1052592b4d9425501ac8a72a9ed6e6c02649) ([merge request](gitlab-org/gitlab!132544))
- [Remove member_tasks table](gitlab-org/gitlab@05dee5a1aaa587909d2802a77363dce775884735) ([merge request](gitlab-org/gitlab!134169))
- [Remove issuable features moved popover](gitlab-org/gitlab@d39538b3657c2cb3ecbcbc225728707dfc9955c9) ([merge request](gitlab-org/gitlab!133476))
- [Remove Gitlab::Shell#mv_repository calls](gitlab-org/gitlab@ec603a0df4dea70ebee6e659c58596d24970d4e0) ([merge request](gitlab-org/gitlab!133972))
- [Remove `user_pat_rest_api` FF](gitlab-org/gitlab@7ba0aae89f6ee1f7da8d423b1d5b3f7a6c94412d) ([merge request](gitlab-org/gitlab!133428))
- [Remove feature flag content_editor_on_issues](gitlab-org/gitlab@31ab840a3b2b08461bb7b113c83ce4d8a981cdc2) ([merge request](gitlab-org/gitlab!133246))
- [Remove feature flag enforce_vulnerability_attributes_rules enabled](gitlab-org/gitlab@328652c424f06dff192ffab240566a17f8f99f28) ([merge request](gitlab-org/gitlab!133063)) **GitLab Enterprise Edition**
- [Remove Pages migration from legacy outdated code](gitlab-org/gitlab@84d701ebf02ade9d92e6600e2ed430fedbdd5de1) ([merge request](gitlab-org/gitlab!133103))
- [Remove feature flag scan_execution_policy_pipelines enabled by default](gitlab-org/gitlab@d1a951f1287a73375862aa30502a4379b57664fa) ([merge request](gitlab-org/gitlab!133064)) **GitLab Enterprise Edition**
- [Remove legacy replication for project repositories](gitlab-org/gitlab@9eb4e88ac5f05952488bb9457d51f9b1d95c3e30) ([merge request](gitlab-org/gitlab!130565)) **GitLab Enterprise Edition**
- [Remove tasks to be done for members from service and api layer](gitlab-org/gitlab@3605d5ef5cb979cf29d07b45714167555229de0f) ([merge request](gitlab-org/gitlab!133032))
- [Drop unused PA cluster settings](gitlab-org/gitlab@271656376c65b9c8b3e26007adc3e1a736e918a5) ([merge request](gitlab-org/gitlab!132748))
- [Remove k8s_proxy_pat FF](gitlab-org/gitlab@2dbca85bf96fd1ff57996d9e5da37ce98cef2ae6) ([merge request](gitlab-org/gitlab!131518))
- [Removed feature flag deactivation_email_additional_text](gitlab-org/gitlab@2913a93670b9c625e65644f3f555c6d30380397d) ([merge request](gitlab-org/gitlab!132968))
- [Remove callout for rich text editor](gitlab-org/gitlab@0a4fd06c4d93f927cf292c285d95234e1a9e45f0) ([merge request](gitlab-org/gitlab!132751))
- [Remove the deprecated DeleteContainerRepositoryWorker](gitlab-org/gitlab@96fdced8cd69b88ca0087779c7b31058efc6b7e1) ([merge request](gitlab-org/gitlab!106676))
- [Remove the arkose_labs_login_challenge feature](gitlab-org/gitlab@8ce22948db4fed9efa1c88ea5ca9a312af323ecd) ([merge request](gitlab-org/gitlab!132382)) **GitLab Enterprise Edition**
- [Remove unused diff_merge_request_whitespace_link helper](gitlab-org/gitlab@0a399d6802b56cadcf211e65a9e05ee7237e6081) ([merge request](gitlab-org/gitlab!132579))
- [Geo Replicables - Remove RESTful support Vuex](gitlab-org/gitlab@ca40106846ebee7c5a1b2232c7a87b5a19625462) ([merge request](gitlab-org/gitlab!132156)) **GitLab Enterprise Edition**
- [Drop ignored columns from geo_node_statuses](gitlab-org/gitlab@98b0dea62e6826edaeaafede93b002e3b983c5c5) ([merge request](gitlab-org/gitlab!131991))
- [Remove restrict_special_characters_in_namespace_path feature flag](gitlab-org/gitlab@1ea052cfbfc8185fd8f25ba15bfdc7dc4667c342) ([merge request](gitlab-org/gitlab!129800))
- [Remove `asana` gem dependency](gitlab-org/gitlab@4f27188f55af02d6d67a1d639b9b5e6ab1cb4199) ([merge request](gitlab-org/gitlab!132165))
- [Geo Replicables - Remove RESTful support from UI](gitlab-org/gitlab@ee00e8d83ee00b91ce06cd98ede482fb990fc3f9) ([merge request](gitlab-org/gitlab!132263)) **GitLab Enterprise Edition**

### Security (20 changes)

- [Enforce that the policy is executed by the bot user](gitlab-org/gitlab@d5063338843881164bb48d7dea596178be6c2b19) ([merge request](gitlab-org/gitlab!131102)) **GitLab Enterprise Edition**
- [Fix Maven request forward vulnerability to response splitting](gitlab-org/gitlab@b6cd744f72eb3a854fec532b5ff2f20410856227) ([merge request](gitlab-org/gitlab!133317)) **GitLab Enterprise Edition**
- [Update URI gem to v0.12.2](gitlab-org/gitlab@9e74d720e4aa77f3b1588a6f56e0bace2e4b8fb9) ([merge request](gitlab-org/gitlab!132743))
- [Fix leaking source code of restricted project through a fork](gitlab-org/gitlab@7e456746761b52db188602585197e81ae31fbece)
- [Allow only one membership for security policy bots](gitlab-org/gitlab@99c7582d2c46ed634a63384e9926ee78b06f3e70)
- [Delete of member branch protection rules cascadingly](gitlab-org/gitlab@9901a9ed463a3c62dc6d4446cd513d8f82583df7)
- [Revert "Merge branch 'security-415371-block-fifo-file' into 'master'"](gitlab-org/gitlab@b50d51ba5c2ea408829d0a771fce0ed311319a60)
- [Prevents Ci::Build data from being rendered](gitlab-org/gitlab@4eae4351694bbe8424fe2d69cd3050ae2c7e8c40)
- [Restrict Project Fork Linking to Owners and Admins](gitlab-org/gitlab@b68e24aee1953538561a299e33bcbd3283e7bfab)
- [Prevent collaboration across forks when author cannot push](gitlab-org/gitlab@5a31becf8dac9afb3dddb7ca19de21da60138db6)
- [Reset all approvals when target branch changes](gitlab-org/gitlab@03f382219a4a89f2a19d9c1bb9f7dd9ada5c6541)
- [Default to using the asset proxy](gitlab-org/gitlab@e0401e85f7751200f02cbb538f49e0ae66b03cae)
- [Pipelines will have no access to protected vars and may fail with tags](gitlab-org/gitlab@3a2dd0e0a3944b22d3659e2aa1afeb2529507dc0)
- [Destroy group service accounts when removing group](gitlab-org/gitlab@3b6e55bb85bb53c45e19cf4480723f9457429552)
- [Fix SSO Enforcement for shared groups and projects](gitlab-org/gitlab@2752476a008502815da5c75f6313666d9314e74f)
- [Prevent math hijacking page elements](gitlab-org/gitlab@5f180f979ba614cc088957b431223f65a1344d81)
- [Allow Maintainer+ to list Sentry projects](gitlab-org/gitlab@caff25a44006274256f0cb58ce5b9bb2b5aea962)
- [Validate typeflag of import archive file](gitlab-org/gitlab@8f4eb5bbf9350c3f6a0c7208f6177546800d6866)
- [Prevent leaking CI variables via fork MRs](gitlab-org/gitlab@cd811a5a19ab32e8d25f83c2bb20edd9db31431d)
- [Mark any CI builds that are not complete as canceled when imported](gitlab-org/gitlab@ac0f8d8e27836741bb9c26437e2fcf4ed082182c)

### Performance (6 changes)

- [GitHub attachment importers resume their work](gitlab-org/gitlab@487521cc26c1e2bdba4fc67c14478d2b2a5f2bfa) ([merge request](gitlab-org/gitlab!134229))
- [Sync removal of index_events_on_author_id_and_created_at_merge_requests](gitlab-org/gitlab@5d66059024ec4bd6642d57205e44fd5259c9fc18) ([merge request](gitlab-org/gitlab!127657))
- [Drop index_deployments_on_project_id_and_ref concurrently](gitlab-org/gitlab@401bacabcc3e3a88aa12a11da4ff94ecdef257b4) ([merge request](gitlab-org/gitlab!133649))
- [Remove index_deployments_on_project_id_and_ref async-ly](gitlab-org/gitlab@5b3b34cc41cbdd76fcba2c58acb982c39e7847b8) ([merge request](gitlab-org/gitlab!133057))
- [Async remove `index_events_on_author_id_and_created_at_merge_requests`](gitlab-org/gitlab@7e14e229073dba4cc3f456d08bc2f3dc9c753719) ([merge request](gitlab-org/gitlab!127656))
- [Query the sum of approvals required instead of calculating it in Rails](gitlab-org/gitlab@819375772702e36522cfb09ae7061c75a5d9a39e) ([merge request](gitlab-org/gitlab!132131)) **GitLab Enterprise Edition**

### Other (73 changes)

- [Complete rollout of new pipeline unlock mechanism](gitlab-org/gitlab@3a20ca08c26f6eac55718df796bc86c12b3e00f1) ([merge request](gitlab-org/gitlab!134477))
- [Async create index for env state updated at](gitlab-org/gitlab@2a07349a22cabe043ea345607d72dfacfa87b120) ([merge request](gitlab-org/gitlab!134008))
- [Add auto_canceled_by_partition_id to p_ci_builds](gitlab-org/gitlab@4b4573f655c768c4665c375a7d428b8768414895) ([merge request](gitlab-org/gitlab!134386))
- [Drops unused index_namespaces_on_ldap_sync_last_update_at](gitlab-org/gitlab@3da9c3648ff78a7f2527b148acbbf00ee380ebb3) ([merge request](gitlab-org/gitlab!134513))
- [Change the validation to take into account for the new column](gitlab-org/gitlab@acc598243cfa252ebeaa085495b99c8aa05b8cb7) ([merge request](gitlab.com/gitlab-org/gitlab/-/merge_requests/133622))
- [refactor: Improve consistency in create_package_service_spec](gitlab-org/gitlab@6d8986c62103d2b981014dd57b5896795bde201e) by @gerardo-navarro ([merge request](gitlab-org/gitlab!134383))
- [Adds initial developer docs for Model Registry](gitlab-org/gitlab@d946a11d6d90248f10be819c3a3f1b90abd47265) ([merge request](gitlab-org/gitlab!134315))
- [Migrate webhook resend request button](gitlab-org/gitlab@6aafac76eb5736b30a7add28a03ef8956df19a7a) ([merge request](gitlab-org/gitlab!134129))
- [Backfill has_remediations on existing vulnerability_reads records](gitlab-org/gitlab@9b3837f018d92c575752921a28103b05c6c314e2) ([merge request](gitlab-org/gitlab!133714))
- [Removing temporary index used to backfill project stats](gitlab-org/gitlab@e98d152791944d72ad73784d6044a6d182d9aa6f) by @TamsilAmani ([merge request](gitlab-org/gitlab!134204))
- [refactor: Use BaseProjectService for CreateRuleService](gitlab-org/gitlab@0bddcbd8a9454ca7abbe154aa94fcc9631b8ab65) by @gerardo-navarro ([merge request](gitlab-org/gitlab!134131))
- [Default enable inherit_higher_access_levels_no_cross_join flag](gitlab-org/gitlab@8447a1758836139c2e25af774c951e84060fe025) ([merge request](gitlab-org/gitlab!134053))
- [This MR removes on_demand_scans_runner_tags FF](gitlab-org/gitlab@a516e4d1b51b59354256e084f4a69154423d62e3) ([merge request](gitlab-org/gitlab!119480)) **GitLab Enterprise Edition**
- [refactor: Add enum for push_protected_up_to_access_level](gitlab-org/gitlab@b4596b8334bede44b5587b55aa7e8078ec4afa27) by @gerardo-navarro ([merge request](gitlab-org/gitlab!133416))
- [Dropping unused idx index_namespaces_on_updated_at](gitlab-org/gitlab@7f2ca426a5e82aae4abcf5ff1bd46a2dd8d4d169) ([merge request](gitlab-org/gitlab!133892))
- [Bump Gitlab Shell to 14.29.0](gitlab-org/gitlab@4548b8d41736ea8bcc0f77e13c3437b64ea7c186) ([merge request](gitlab-org/gitlab!133936))
- [Remove issues AI related feature flags](gitlab-org/gitlab@0c96d603cf8b91aab6b4712597d28bdb4f5ecaad) ([merge request](gitlab-org/gitlab!132350)) **GitLab Enterprise Edition**
- [Remove the feature_flag use_new_zoekt_indexer](gitlab-org/gitlab@1e4b4a8d3fb500a1486a880ef832175c09654914) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/133708)) **GitLab Enterprise Edition**
- [Remove the hardcoding for getting shard](gitlab-org/gitlab@e425e83a0062b46fb7ff76fef033f522bcb2ca88) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131614)) **GitLab Enterprise Edition**
- [Removing ff advanceStageTimeout](gitlab-org/gitlab@0f6b701532bad9e604573f3a2b79b6b578dba617) ([merge request](gitlab-org/gitlab!133874))
- [Renamed groupFilters to reportGroupFilters](gitlab-org/gitlab@2bce793b9ea794a9c22f25d3ee457b23d57e380f) by @tedtran2019 ([merge request](gitlab-org/gitlab!133821))
- [Update validation message when verifying sha](gitlab-org/gitlab@69ea5386fd4baf29015658f7647ca806268f1b5e) ([merge request](gitlab-org/gitlab!133470))
- [Remove use_traversal_ids feature flag](gitlab-org/gitlab@f10c150989054b693f411fe873f0eca0d6f26eca) ([merge request](gitlab-org/gitlab!133089))
- [Guidelines regarding rolling out percentages Feature Flags](gitlab-org/gitlab@cd95b50d5458e6dea28958c22840f1bef0b1d333) ([merge request](gitlab-org/gitlab!133362))
- [Reindex and remove merge_requests from main index](gitlab-org/gitlab@269af2885122c3484c72a762142d0b9a1763d4e3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/133404)) **GitLab Enterprise Edition**
- [Update sass npm from 1.49.9 to 1.69.0](gitlab-org/gitlab@1f66cde79c767b55f7131d0e84afb550d76d2b34) by @tnir ([merge request](gitlab-org/gitlab!133523))
- [Resolve ambiguous references for archive metadata](gitlab-org/gitlab@6898405a1c92bb3909ccaea4fb65607b2a1c5280) ([merge request](gitlab-org/gitlab!132873))
- [Cleanup/promote to production gtm_nonce feature flag](gitlab-org/gitlab@610ac6332f6c105e1ab77f4f4041c0b1d82b7b23) ([merge request](gitlab-org/gitlab!133463))
- [Migrate widget action buttons to GlDisclosureDropdown](gitlab-org/gitlab@844ca3429815eddd7b6e0b63789d916ef01a35b2) ([merge request](gitlab-org/gitlab!133408))
- [refactor: Align file location of package protection rule factory](gitlab-org/gitlab@6ed3bd3c27c71623cb9c151c9413736ec0590749) by @gerardo-navarro ([merge request](gitlab-org/gitlab!133418))
- [Add `email_with_layout` in access_token_revoked_email method](gitlab-org/gitlab@05838d7d595c03a9f73e5c3c2bde8122dab04d82) by @KiranSatyaRaj ([merge request](gitlab-org/gitlab!126196))
- [Send schema_version value flags for blob, commit and wiki](gitlab-org/gitlab@4a3897c5ddb81a7398003ec785f8a9308a500a44) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/132106)) **GitLab Enterprise Edition**
- [Add documentation related to link work items](gitlab-org/gitlab@ea19a8e81f0325796dbbc72305d08ac2845a8f1e) ([merge request](gitlab-org/gitlab!132965))
- [Reindex notes from main index](gitlab-org/gitlab@e06d169cca05eb41d2c73cd4ccc78e7a2e21ced3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/132970)) **GitLab Enterprise Edition**
- [Removing the feature flag loose_foreign_keys_batch_load_using_union](gitlab-org/gitlab@699dd3ba54ac52fc8c0bc147d90dabcfc8f8cefb) ([merge request](gitlab-org/gitlab!132884))
- [Cleanup FFs for migrating exclusive lease](gitlab-org/gitlab@a69d80716f02e92394e75bb4f79822f982221244) ([merge request](gitlab-org/gitlab!133291))
- [Remove elastic_file_name_reverse_optimization feature flag](gitlab-org/gitlab@a5dda37adb260d8ea65a9ca3437b2e11cd11599e) ([merge request](gitlab-org/gitlab!132937)) **GitLab Enterprise Edition**
- [Refactors boolean validation specs using 'validate_inclusion_of'](gitlab-org/gitlab@d312e9a9334250a8346c0dfb8f2502c26e6b0240) by @harshitprasad ([merge request](gitlab-org/gitlab!133073))
- [Remove optimize_find_routable feature flag](gitlab-org/gitlab@d44487b915d1f760f809e3cfac087218b5ea5ef2) ([merge request](gitlab-org/gitlab!132559))
- [Drop an unused index on the namespaces table](gitlab-org/gitlab@d11e6a404d10366fd5cb25e85d8ebe53bbc14d77) ([merge request](gitlab-org/gitlab!133146))
- [Remove FF bulk_imports_batched_import_export](gitlab-org/gitlab@199902dcbe2323e9ba4665f28404e00733d13cb4) ([merge request](gitlab-org/gitlab!132537))
- [Add a migration to remove hashed_root_namespace_id from users index](gitlab-org/gitlab@c8704c5d1c7cb1979ac8086e5bf48dc77d7f5e04) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/132856)) **GitLab Enterprise Edition**
- [Use QueuesMetadata for duplicate jobs](gitlab-org/gitlab@248574bd7a868b6d0f4cb6a8a305d4c501a15588) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131736))
- [Add automated accessibility tests](gitlab-org/gitlab@1af85daa8e83aa9525c9015f9f795dcb0bd5fea7) ([merge request](gitlab-org/gitlab!132670))
- [Externalize strings from viewer_swicher.html.haml](gitlab-org/gitlab@334b10337f39c47612d0d96908ef69b34a106039) by @wwwxx4869 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/49122))
- [Write licenses to `sbom_occurrences` table](gitlab-org/gitlab@08119f98d260f6efa76c7e74ea6d7cb4641f2d28) ([merge request](gitlab-org/gitlab!132294)) **GitLab Enterprise Edition**
- [Removing a leftover from previous removal](gitlab-org/gitlab@c971d4cc5d7a1776ed95c4486962ff8e6d28d57f) ([merge request](gitlab-org/gitlab!132911))
- [Cleanup deploy_key_for_protected_tags feature flag](gitlab-org/gitlab@7b74e26295c3734257d6b4e6ddb31513c1640690) ([merge request](gitlab-org/gitlab!132875))
- [Use a dedicated client for workhorse-redis](gitlab-org/gitlab@b825224d431d19ee8128777b9ca0183471cb8a2e) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/127577))
- [Drop an unused index on the namespaces table](gitlab-org/gitlab@5717167e0eef647d45a382665cb7760185df7c4a) ([merge request](gitlab-org/gitlab!132836))
- [Remove ff standard_merge_train_ref_merge_commit](gitlab-org/gitlab@9ca80485863b4953234285fa1ad3b80e0a9a8bee) ([merge request](gitlab-org/gitlab!132805)) **GitLab Enterprise Edition**
- [Remove 'gitlab_duo' feature flag](gitlab-org/gitlab@05be838f799a59ff2096ca8f11db0a3688d7b670) ([merge request](gitlab-org/gitlab!132347)) **GitLab Enterprise Edition**
- [Remove 'ai_related_settings' feature flag](gitlab-org/gitlab@afeecef1f112733e886d5c4fa089dedf706f7500) ([merge request](gitlab-org/gitlab!132347)) **GitLab Enterprise Edition**
- [Remove mention of ai_redis_chat](gitlab-org/gitlab@dcee3d3fd2c776ea81d38b344c3fde8b7c59d867) ([merge request](gitlab-org/gitlab!132347)) **GitLab Enterprise Edition**
- [Remove 'tanuki_bot' feature flag](gitlab-org/gitlab@fbccb8a6d4559f29e2987b6f629d0ddd7fa1967f) ([merge request](gitlab-org/gitlab!132347)) **GitLab Enterprise Edition**
- [Remove 'explain_code_snippet' feature flag](gitlab-org/gitlab@8bc2b67c2368e1b1131f4b2701cc0e53577dbe59) ([merge request](gitlab-org/gitlab!132347)) **GitLab Enterprise Edition**
- [Remove 'chat_epic_identifier' FF](gitlab-org/gitlab@970942295a272923dae9e1c1987cb6d621189791) ([merge request](gitlab-org/gitlab!132347)) **GitLab Enterprise Edition**
- [Remove 'ai_tool_info' feature flag](gitlab-org/gitlab@0ac208dcbd1dda31b9164bbf41aa910bfa62e3cd) ([merge request](gitlab-org/gitlab!132347)) **GitLab Enterprise Edition**
- [Drop an unused index on the namespaces table](gitlab-org/gitlab@6b8c11667dab9cb8450bbd3b2094cfff71b62b05) ([merge request](gitlab-org/gitlab!132688))
- [Feature flags rollout instructions update](gitlab-org/gitlab@02d5fdbfcb0d1f1f582e0beceae96faefe2abe8e) ([merge request](gitlab-org/gitlab!132566))
- [Add SaaS guard on onboarding controller](gitlab-org/gitlab@89b9249400b06c8cd82ed6d0eebf4b2d691bdddb) ([merge request](gitlab-org/gitlab!132453)) **GitLab Enterprise Edition**
- [Cleanup `errors_utf_8_encoding` feature flag](gitlab-org/gitlab@26ba5f6ab97c36f64b7e64a171dec977348aa006) ([merge request](gitlab-org/gitlab!132523))
- [Cleanup "optimize_group_template_query" feature flag](gitlab-org/gitlab@0c0c3eb491f98acb8e505422f04be7de2f1888f8) ([merge request](gitlab-org/gitlab!132525))
- [Remove the `chatops` feature flag since it's enabled by default](gitlab-org/gitlab@806da3a3b80f9c86288cd5541edac298e0a1422c) ([merge request](gitlab-org/gitlab!132311))
- [Added styles to to email](gitlab-org/gitlab@01ff2e7057055f72a519ae772b4d2fe208029b2b) by @NIKU-SINGH ([merge request](gitlab-org/gitlab!132478))
- [Add index on ci_job_artifacts file_final_path](gitlab-org/gitlab@f9cd0979e200bef79ab57abe2e676d2c94cbaf77) ([merge request](gitlab-org/gitlab!132243))
- [Update documentation regarding deprecated random feature flags](gitlab-org/gitlab@16d272a0c8618fe127daa43a89a8a52a689ab180) ([merge request](gitlab-org/gitlab!132283))
- [Adds "name" field to provide machine readable status](gitlab-org/gitlab@df6e7b6bc8dedadda5c725595f1e47bfc55be72a) ([merge request](gitlab-org/gitlab!130308))
- [Remove self_and_hierarchy scope feature flag](gitlab-org/gitlab@1e517029e7f531b6066bfb4710f66f1dbc8d2b28) ([merge request](gitlab-org/gitlab!129359))
- [Add endpoint_id label to web transaction metrics](gitlab-org/gitlab@39f3de4164f4d3190ca9d898da60e477ba1d84dd) ([merge request](gitlab-org/gitlab!132095))
- [Remove FF when canceling redundant pipelines](gitlab-org/gitlab@16bb8c5ff1ef7c6b1d854c71f4fec555439de210) ([merge request](gitlab-org/gitlab!131978))
- [Alias read_namespace to access_namespace and move usages to new ability](gitlab-org/gitlab@61cdb4127143162a9bf9182f9c3c2d8421ee447f) by @Taucher2003 ([merge request](gitlab-org/gitlab!126625))
- [Remove `custom_roles_on_groups` feature flag](gitlab-org/gitlab@ddb4b4399b8bb82793410005c5778a002ae409b9) ([merge request](gitlab-org/gitlab!132187)) **GitLab Enterprise Edition**

## 16.4.7 (2024-09-20)

No changes.

## 16.4.6 (2024-07-23)

### Added (2 changes)

- [Removed nil constraint from personal access token table](https://gitlab.com/gitlab-org/gitlab/-/commit/f20aab9203d7b085d5963a7e75a537efb02896b7) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159125)) **GitLab Enterprise Edition**
- [Add Rake task to show token expiration info](https://gitlab.com/gitlab-org/gitlab/-/commit/385110959faf9d65fa3a33f1d2dff49659eb835a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159125))

### Fixed (1 change)

- [Update an expired test certificate](https://gitlab.com/gitlab-org/gitlab/-/commit/fda6b0a5e5be798e3537e817e3ba03cb969e2594) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156400))

### Changed (2 changes)

- [Add a banner informing about token expiration](https://gitlab.com/gitlab-org/gitlab/-/commit/a23e1d214732b53465904ea271864f99c8e52151) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158474))
- [Do not enqueue PAT expiry enforcement migration](https://gitlab.com/gitlab-org/gitlab/-/commit/8dda03380e73f82e72c77f965c2be50ba74a22d5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153458))

### Other (1 change)

- [Clear instance value](https://gitlab.com/gitlab-org/gitlab/-/commit/22395fb7fd39e0074ad0c86efae39fe5698a5487) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160242))

## 16.4.5 (2024-01-11)

### Security (2 changes)

- [Fix clickouse-server version in CI](gitlab-org/security/gitlab@71878185c35a1025d00eebc6dea54688fb93b585) ([merge request](gitlab-org/security/gitlab!3808))
- [User password reset accepts multiple email addresses](gitlab-org/security/gitlab@394e91005d4a7b3df36be077aecf8a36acdee0f3) ([merge request](gitlab-org/security/gitlab!3795))

## 16.4.4 (2023-12-13)

### Security (8 changes)

- [Prevent tag names starting with SHA-1 and SHA-256 values](gitlab-org/security/gitlab@dea535057d372f313db2f3afb7928a65a3acfcf7) ([merge request](gitlab-org/security/gitlab!3748))
- [Pass encoded file paths to router](gitlab-org/security/gitlab@435d14da6592134edc1b051be9e53a5756f37eff) ([merge request](gitlab-org/security/gitlab!3737))
- [Validate access level of user while rotating token](gitlab-org/security/gitlab@d4e74025a0910966e4c92a117a5d1721c1d69854) ([merge request](gitlab-org/security/gitlab!3752))
- [Fix large time_spent value causing GraphQL error `Integer out of bounds`](gitlab-org/security/gitlab@532192423ae25061c7454a47956b0d9f9ff07ffa) ([merge request](gitlab-org/security/gitlab!3753))
- [Restrict Protected branch access via group to direct members](gitlab-org/security/gitlab@267933e624d8988ace9948804476f1c5d14fc228) ([merge request](gitlab-org/security/gitlab!3728))
- [Remove the ability to fork and create MR for auditors](gitlab-org/security/gitlab@720c977c36a1ec349b38897b61b7fcb62e6bd1eb) ([merge request](gitlab-org/security/gitlab!3740))
- [Restrict passing variables on the pipeline schedule API](gitlab-org/security/gitlab@ed1141076ffef659886753830b201e68c9bacf32) ([merge request](gitlab-org/security/gitlab!3725))
- [Smartcard auth: encrypt client cert in params](gitlab-org/security/gitlab@3c1d11225878573e9de0803f0484e17764bce8ee) ([merge request](gitlab-org/security/gitlab!3731))

## 16.4.3 (2023-11-30)

### Fixed (1 change)

- [Fix assign security check permission checks](gitlab-org/security/gitlab@68b0fe3e41199a47e5851f3f00412ba18cc61a27) **GitLab Enterprise Edition**

### Security (10 changes)

- [Enforce ref protection on pipeline schedule updates](gitlab-org/security/gitlab@222b8d02d95e6c33ef26bfbb69718fa73daf31bc) ([merge request](gitlab-org/security/gitlab!3657))
- [Update mermaid version for DOS security fixes](gitlab-org/security/gitlab@91f6263eb4697e9aebe059aee46ccfe1974d481c) ([merge request](gitlab-org/security/gitlab!3672))
- [Prevent guest users from being able to add emojis in confidential issues](gitlab-org/security/gitlab@cc233c603bc595ef60f1b7ea2fcd69ab6113a374) ([merge request](gitlab-org/security/gitlab!3689))
- [Do not run ssl cert validation if key has errors](gitlab-org/security/gitlab@ce234f97638d9182c22636301eccae87e7af854a) ([merge request](gitlab-org/security/gitlab!3662))
- [Ensure access is checked when loading releases associated with tags](gitlab-org/security/gitlab@fead41322a5cf79513b5e3375fb2372ca936ef10) ([merge request](gitlab-org/security/gitlab!3696))
- [XSS and ReDoS in Markdown via Banzai pipeline of Jira](gitlab-org/security/gitlab@7d9d64aa7123287c495b6be291a9b00dc60f179e) ([merge request](gitlab-org/security/gitlab!3692))
- [Prevent branch names starting with SHA-1 and SHA-256 values](gitlab-org/security/gitlab@f51d428a6961bf77661cffffd50face4d02c6f43) ([merge request](gitlab-org/security/gitlab!3688))
- [Filter out projects with disabled package registry in Composer finder](gitlab-org/security/gitlab@844ddc2028fd7389beee440034a1e83a42693ba2) ([merge request](gitlab-org/security/gitlab!3683))
- [Check max role for user for group access to protected ref](gitlab-org/security/gitlab@1f6036ab1e227d013c0d42210a9c08ac7ff231c6) ([merge request](gitlab-org/security/gitlab!3643))
- [Treat security policy bots as external](gitlab-org/security/gitlab@b0cf61131f21381978509ab2698b9da57522e726) ([merge request](gitlab-org/security/gitlab!3677))

## 16.4.2 (2023-10-30)

### Fixed (4 changes)

- [Fix pipeline schedules view when owner is nil](gitlab-org/security/gitlab@663b1328b6e05e472f60ebdcec9866220b88d066)
- [Update dependency prometheus-client-mmap to '>= 0.28.1'](gitlab-org/security/gitlab@a478482f3616bfe205e10fcca997b0e6f133d692)
- [Fix failing migration when commit_message_negative_regex is missing](gitlab-org/security/gitlab@1488c3ed6568d44aa7c8b7d0551fa8160b59c1dc)
- [Backport fix flaky epic tests](gitlab-org/security/gitlab@155cb51939d5b3c1f4b847219a5cb62c9f2ae1b0) **GitLab Enterprise Edition**

### Security (9 changes)

- [Fix infinite loop when finding component project](gitlab-org/security/gitlab@b38efc987c1081fcd092c96e69c7ebb539324679) ([merge request](gitlab-org/security/gitlab!3666))
- [Update gitlab-chronic-duration to 0.12](gitlab-org/security/gitlab@1c8dd2e890c1121b1c1ad947f701a39ec6ac5310) ([merge request](gitlab-org/security/gitlab!3628))
- [Guard gitlab_version_check helper](gitlab-org/security/gitlab@e6c833ee0da8a801f08d5d7411b4ff683d0cde31) ([merge request](gitlab-org/security/gitlab!3653))
- [Add the environment action to the CI JWT token fields](gitlab-org/security/gitlab@10fe34349f2e1d8230b805316f559b2dde8e6240) ([merge request](gitlab-org/security/gitlab!3616))
- [Remove FIFO files from tarball extract](gitlab-org/security/gitlab@5d5acf918d68ffcf193a7c477c637788aadd882e) ([merge request](gitlab-org/security/gitlab!3633))
- [Backport add abuse detection for pipes](gitlab-org/security/gitlab@2ccde2dbbcc647c8fc34ebb71c5472e2b70560ab) ([merge request](gitlab-org/security/gitlab!3618))
- [Prevent unprivileged user assignment in templated projects](gitlab-org/security/gitlab@977371d7af40caa2a9b8fb18fe093be12d2e8443) ([merge request](gitlab-org/security/gitlab!3636))
- [Fixes Service Desk email template issue description privileges](gitlab-org/security/gitlab@6e8e58e222937232397502828fa0985dee1bf786) ([merge request](gitlab-org/security/gitlab!3640))
- [Update mermaid version for DOS fixes](gitlab-org/security/gitlab@5047299db60c7ab27fb521812d04dee7e70e319b) ([merge request](gitlab-org/security/gitlab!3626))

### Other (1 change)

- [Create Geo event when project is created](gitlab-org/security/gitlab@1f743fba3af02ab30e65c03da7f088610880a90a) **GitLab Enterprise Edition**

## 16.4.1 (2023-09-28)

### Security (15 changes)

- [Mark any CI builds that are not complete as canceled when imported](gitlab-org/security/gitlab@2b3246c076dd7b6505945b6e19d3787fc8698b6f) ([merge request](gitlab-org/security/gitlab!3597))
- [Destroy group service accounts when removing group](gitlab-org/security/gitlab@5135447afe579babb040e7f40192ac330d663aee) ([merge request](gitlab-org/security/gitlab!3602))
- [Fix SSO Enforcement for shared groups and projects](gitlab-org/security/gitlab@bdcbc1561c60b8039763bf85f0b00e34e6771cc0) ([merge request](gitlab-org/security/gitlab!3603))
- [Prevents Ci::Build data from being rendered](gitlab-org/security/gitlab@d53320b0ad9b5c6f517971072a073f985d35facb) ([merge request](gitlab-org/security/gitlab!3604))
- [Allow only one membership for security policy bots](gitlab-org/security/gitlab@0427e9ce8496fd587f4c971d8df710ab37d4a104) ([merge request](gitlab-org/security/gitlab!3611))
- [Reset all approvals when target branch changes](gitlab-org/security/gitlab@d3cd8f60d73ce2feecd034383bf2e17789f6fe43) ([merge request](gitlab-org/security/gitlab!3607))
- [Default to using the asset proxy](gitlab-org/security/gitlab@524aebbbaa746b3745506ce642eba67b668f9872) ([merge request](gitlab-org/security/gitlab!3587))
- [Restrict Project Fork Linking to Owners and Admins](gitlab-org/security/gitlab@3132e578fcd0fc093d732a9891dd72a37341cfab) ([merge request](gitlab-org/security/gitlab!3605))
- [Prevent math hijacking page elements](gitlab-org/security/gitlab@c8c813dc3fc8b26e3975392758328c97568e6eb4) ([merge request](gitlab-org/security/gitlab!3591))
- [Delete of member branch protection rules cascadingly](gitlab-org/security/gitlab@4635a97c527fbe81bb4d93502460d7147262c2a6) ([merge request](gitlab-org/security/gitlab!3594))
- [Prevent collaboration across forks when author cannot push](gitlab-org/security/gitlab@d9b21a60fe0ff6f7e5cbecbcaf2a70ac33aa4acd) ([merge request](gitlab-org/security/gitlab!3586))
- [Allow Maintainer+ to list Sentry projects](gitlab-org/security/gitlab@a8ad5be6dea95c30d498770d8eb58182b51c7f44) ([merge request](gitlab-org/security/gitlab!3553))
- [Fix leaking source code of restricted project through a fork](gitlab-org/security/gitlab@a44af43b779df34712bd04dc01bf0da4fa7fc994) ([merge request](gitlab-org/security/gitlab!3593))
- [Prevent leaking CI variables via fork MRs](gitlab-org/security/gitlab@1ba8ef7d453bc3b9299b98e066d4d2756c7edb2e) ([merge request](gitlab-org/security/gitlab!3588))
- [Pipelines will have no access to protected vars and may fail with tags](gitlab-org/security/gitlab@5db5e98acb966bd80105ee74127fef228e6edab5) ([merge request](gitlab-org/security/gitlab!3583))

## 16.4.0 (2023-09-21)

### Added (179 changes)

- [Create list for standards adherence report](gitlab-org/gitlab@e8aabe8fac4cf2d99de68ab325c788468abe64ee) ([merge request](gitlab-org/gitlab!129538)) **GitLab Enterprise Edition**
- [Add keyset pagination support for /users endpoint](gitlab-org/gitlab@bb7df12f5e7cb60c654d6b518a1e96a847a2f01b) ([merge request](gitlab-org/gitlab!130019))
- [Add documentation for Self-Managed Code Suggestions](gitlab-org/gitlab@cf61e023da5737d9fa7528283d66a3e9caed7167) ([merge request](gitlab-org/gitlab!131628))
- [Added create api for instance level gcp destinations](gitlab-org/gitlab@d40dde514fa1d456bc5fb09762f04e03fdc6eb1b) ([merge request](gitlab-org/gitlab!130663)) **GitLab Enterprise Edition**
- [Support multiline comment for code generation](gitlab-org/gitlab@6ad031e89bf3d9fb4530af0e0fe5de525ace17d8) ([merge request](gitlab-org/gitlab!131793)) **GitLab Enterprise Edition**
- [Expose `vulnerability_events` integrations field](gitlab-org/gitlab@501ffaceeb709179ebd9fe655d4cce67c7c051fa) ([merge request](gitlab-org/gitlab!131831)) **GitLab Enterprise Edition**
- [Added delete api for instance gcp config](gitlab-org/gitlab@87e31d608c0459979b46fbe398ff52621b55728b) ([merge request](gitlab-org/gitlab!131752)) **GitLab Enterprise Edition**
- [Enable package_metadata_advisory_sync and...](gitlab-org/gitlab@ae6fb2eb94d03bd3f979379ddad5b284b7f6ef46) ([merge request](gitlab-org/gitlab!131705)) **GitLab Enterprise Edition**
- [Add /award quick action for work items](gitlab-org/gitlab@e8c3705fde44496aa9ecac2be51ee1fceb9683d6) ([merge request](gitlab-org/gitlab!127953))
- [Added instance level gcp destination streaming](gitlab-org/gitlab@34f43f68e1c518e4b0e1111ba0a7ceec326fef71) ([merge request](gitlab-org/gitlab!131608)) **GitLab Enterprise Edition**
- [Graphql endpoint for listing all custom roles](gitlab-org/gitlab@e0fe47d2bffbbf503d21c1e4b884bc5f2e07921e) ([merge request](gitlab-org/gitlab!131324)) **GitLab Enterprise Edition**
- [Added archived filter for commits scope](gitlab-org/gitlab@4cee5884597d948305fab1a8acc49bd28d36eb95) ([merge request](gitlab-org/gitlab!129222)) **GitLab Enterprise Edition**
- [Added archived filter for blobs scope](gitlab-org/gitlab@83c910dd92ccf28694413e5bbaf6c5b8ac276766) ([merge request](gitlab-org/gitlab!129221)) **GitLab Enterprise Edition**
- [Add OpenSUSE 15.5 to the support OS page](gitlab-org/gitlab@96fce779f5d0846ad7e1f191eb6dec0a00af19e9) ([merge request](gitlab-org/gitlab!131805))
- [Update severity count based on dismissal reason](gitlab-org/gitlab@db8b5e670696588cae8a19832ee5214e2ef8f899) ([merge request](gitlab-org/gitlab!131998)) **GitLab Enterprise Edition**
- [Include the merge commits when checking if appoval is allowed](gitlab-org/gitlab@6bd143de9e54f22b8860a5a486bc3d38dfda60d9) ([merge request](gitlab-org/gitlab!131778))
- [Support specifying TLS settings in resque.yml](gitlab-org/gitlab@ea5d36e7e9963e71be4a767e6d68bcd0465a28be) ([merge request](gitlab-org/gitlab!131867))
- [Allow filtering by dismissal reason in vulnerabilitySeveritiesCount](gitlab-org/gitlab@a598f362e09b871bcd890701ea8d84c4b91c030b) ([merge request](gitlab-org/gitlab!128390)) **GitLab Enterprise Edition**
- [Add snowplow_database_collector_hostname app setting](gitlab-org/gitlab@239a7c806e296d7e81a15262ddf1604b267deea5) ([merge request](gitlab-org/gitlab!127650))
- [Create personal access token for workspaces without one](gitlab-org/gitlab@8f1ab5f75d3fce98a63958c10c0ce7cd1b7b364a) ([merge request](gitlab-org/gitlab!131516)) **GitLab Enterprise Edition**
- [Add experimental info as warning](gitlab-org/gitlab@519e19d6e04d892e6b84af20590746e02bc71f15) ([merge request](gitlab-org/gitlab!131859))
- [Added archived filter for notes scope](gitlab-org/gitlab@2fa13c2552ba3fcda0826b157b0ce74b22b4578d) ([merge request](gitlab-org/gitlab!129223)) **GitLab Enterprise Edition**
- [Add rest endpoints for group CA](gitlab-org/gitlab@2b290e4cab322737f4704dcd3c6b94f2bddca38b) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/130866)) **GitLab Enterprise Edition**
- [Add basic input params restrictions](gitlab-org/gitlab@aca8f805ce5350d14602f0003b5285d642321c89) ([merge request](gitlab-org/gitlab!131519)) **GitLab Enterprise Edition**
- [Enable merge_sbom_api FF](gitlab-org/gitlab@bd929e8934b6ed5fa624d5d15495181a937b8177) ([merge request](gitlab-org/gitlab!131782)) **GitLab Enterprise Edition**
- [Create list for standards adherence report](gitlab-org/gitlab@45ec3362dee9d979bc3861fc7675d61ab31e2c3f) ([merge request](gitlab-org/gitlab!128813)) **GitLab Enterprise Edition**
- [Silent Mode - Add experiment badge](gitlab-org/gitlab@4515b08cbe062571f7a87b038357ec2acaba29e6) ([merge request](gitlab-org/gitlab!131686))
- [Enable UI portion for violation export](gitlab-org/gitlab@e38ffd6682067f0a5bab1a3201aec960ab4d9684) ([merge request](gitlab-org/gitlab!131206)) **GitLab Enterprise Edition**
- [Adds duo_api scope for GitLab Duo endpoints](gitlab-org/gitlab@3adf4935e0d3c8ed03a739df2d7894101e79f9cb) ([merge request](gitlab-org/gitlab!131034)) **GitLab Enterprise Edition**
- [Add graphql mutation for continuous vuln scans](gitlab-org/gitlab@437256c4eaf531a39bcd22ad6f59aa5000754d21) ([merge request](gitlab-org/gitlab!131450)) **GitLab Enterprise Edition**
- [Update milestones search query to filter archived project results](gitlab-org/gitlab@da2abec1fe9d814bd7101e76c01d6ba064bde22d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/130937))
- [Adds timestamp to sbom report](gitlab-org/gitlab@cac0669fa624cd86f8bc44fc51c9318fc746babe) ([merge request](gitlab-org/gitlab!131399)) **GitLab Enterprise Edition**
- [Updated issuable update mutations allowing null to reset time estimate](gitlab-org/gitlab@f3bc69a875fc59e79f7695f0334284a6fe6cfe9d) by @zillemarco ([merge request](gitlab-org/gitlab!129868))
- [Include has_merge_request field to vulnerabilities graphql](gitlab-org/gitlab@05ca59592225bfae4745b1cbb44cdb7d40b0c132) ([merge request](gitlab-org/gitlab!131649)) **GitLab Enterprise Edition**
- [Include has_merge_request filter to vulnerabilities read finder](gitlab-org/gitlab@4c39a4a34b170fda6c3a1912d48eeae96bf989e0) ([merge request](gitlab-org/gitlab!131542)) **GitLab Enterprise Edition**
- [Allow to list group dashboard visualizations with GraphQL](gitlab-org/gitlab@6b35b7c79a9039c17330a46d9ffca0f8d87419c6) ([merge request](gitlab-org/gitlab!131301)) **GitLab Enterprise Edition**
- [Add cvs toggle to project security settings](gitlab-org/gitlab@f7657f5e03b197db8df8da96de120dc8c09f2de4) ([merge request](gitlab-org/gitlab!131315))
- [Add refresh assignment worker](gitlab-org/gitlab@9ad419c3578c587866499973b37c5138a79f6311) ([merge request](gitlab-org/gitlab!130947)) **GitLab Enterprise Edition**
- [Adds Service Desk custom email](gitlab-org/gitlab@aaa9a4220903dc9b009f37a2d27e4e7070591457) ([merge request](gitlab-org/gitlab!131249))
- [Show warning for single database connection](gitlab-org/gitlab@49f093761fd9177c73045758bb62c79021919944) ([merge request](gitlab-org/gitlab!131521))
- [Implement /authorized_certs internal endpoint](gitlab-org/gitlab@629c7e25fcac4b152a77ebd0acc3165bde746382) ([merge request](gitlab-org/gitlab!131435))
- [Add help popover for dismissal reasons](gitlab-org/gitlab@64e05a3bfe681ae9f36b6f4d65d3d1b62cb7cdaf) ([merge request](gitlab-org/gitlab!131049)) **GitLab Enterprise Edition**
- [Add the UserType in create/remove addon response](gitlab-org/gitlab@3b5b3c05c94b23769f986c7fbb5346ca2421f792) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/129887)) **GitLab Enterprise Edition**
- [Create audit_events_amazon_s3_configurations table](gitlab-org/gitlab@d86154d3facf497b32df96eebd98f4aa7350fcd8) ([merge request](gitlab-org/gitlab!131371)) **GitLab Enterprise Edition**
- [Add setting for enabling Continuous Vulnerability Scans](gitlab-org/gitlab@f79b44006572dbb9386531ecda937530dcdc723a) ([merge request](gitlab-org/gitlab!131305)) **GitLab Enterprise Edition**
- [Create index to support uuid typecasting asynchronously](gitlab-org/gitlab@c9fcfcc31f07e786104c5edd88b07c0c823fc739) ([merge request](gitlab-org/gitlab!131620))
- [Enable resolvable issue threads by default](gitlab-org/gitlab@25595663a04a4aa7c0929950f9f1c4fa29594e04) ([merge request](gitlab-org/gitlab!131622))
- [GraphQL: Add analytics dashboards listing for groups](gitlab-org/gitlab@ff21345c560759b839a41711ec0c1ac088f62699) ([merge request](gitlab-org/gitlab!130274)) **GitLab Enterprise Edition**
- [Include has_merge_request to vulnerabilities read model](gitlab-org/gitlab@d4d592ef71ea18921171d1f5675b360b889d32e0) ([merge request](gitlab-org/gitlab!131174)) **GitLab Enterprise Edition**
- [Migration to add root_namespace_id to project_statistics](gitlab-org/gitlab@fe44c653354744f8fc569b7acc693245c4720ce5) ([merge request](gitlab-org/gitlab!131387))
- [Silent Mode - Add UI Support](gitlab-org/gitlab@7324284b448bb7d37f53c7b6cf911b12ce5a800a) ([merge request](gitlab-org/gitlab!131090))
- [Create background migration to create compliance standards adherence](gitlab-org/gitlab@ea70dbc8621c71747ceecdc10b114108f8519499) ([merge request](gitlab-org/gitlab!129941))
- [Call cleanup worker](gitlab-org/gitlab@cc94716f0b421118cb24407ad6f0554863aead79) ([merge request](gitlab-org/gitlab!130751)) **GitLab Enterprise Edition**
- [Peek sidebar when mouse is over the toggle](gitlab-org/gitlab@fa4190f3d218b04f4c22e77725eada19d6e83965) ([merge request](gitlab-org/gitlab!131028))
- [Add group transfer hook for zoekt](gitlab-org/gitlab@6ed9a4901c17787d1ffc627a4aff38bb24eed7d2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/130178)) **GitLab Enterprise Edition**
- [List api for instance level gcl config](gitlab-org/gitlab@0db1321338555fb12c90cf6056d770aa8d0f43ac) ([merge request](gitlab-org/gitlab!130666)) **GitLab Enterprise Edition**
- [Add previousStageJobs field to JobType](gitlab-org/gitlab@ae52054735af434e07f8a35b6b866cfdc1ddf793) ([merge request](gitlab-org/gitlab!131040))
- [Added archived filter to merge_request](gitlab-org/gitlab@5b3f8ab6ce62da2ff2cc2bbb498cf91f63ccbade) ([merge request](gitlab-org/gitlab!129220)) **GitLab Enterprise Edition**
- [Added filters button to search results](gitlab-org/gitlab@31a1e51162ac56a80ef90e57ad0167a1254c7867) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/124992))
- [Display job external links in sidebar](gitlab-org/gitlab@53f54a3ab1e378fc62bd868d4ceac3419abf5845) by @KyleFromKitware ([merge request](gitlab-org/gitlab!129105))
- [Add API endpoint to get license usage data](gitlab-org/gitlab@db906a7d6d8f279cfc3695166b092bbb4cc64e31) ([merge request](gitlab-org/gitlab!130815)) **GitLab Enterprise Edition**
- [Basic logic for tracking projects/groups visits in the backend](gitlab-org/gitlab@3e9c850149fd024845926ddd5df06643bd2f0269) ([merge request](gitlab-org/gitlab!123554))
- [Release Security Policy branch exceptions](gitlab-org/gitlab@bb627a526b4c9dfca0b22e48832a10f435404a8c) ([merge request](gitlab-org/gitlab!131444)) **GitLab Enterprise Edition**
- [Introducing basics for protecting packages](gitlab-org/gitlab@09117ff518d1d8f48bfcd52c46a9ad95ab27d26b) by @gerardo-navarro ([merge request](gitlab-org/gitlab!124776))
- [Enahnce GraphQL to add fields for lockable labels](gitlab-org/gitlab@f99753c3bf410fa5558180087e90c4a986c83a7b) ([merge request](gitlab-org/gitlab!130989))
- [Remove hide_deprecated_billing_plans FF](gitlab-org/gitlab@68644d4543e0e8bf8fa1fcadb5c7ca67b3338496) ([merge request](gitlab-org/gitlab!130865)) **GitLab Enterprise Edition**
- [Added archived filter for issues scope](gitlab-org/gitlab@5bf077ec220df1ee19511dace0d8247ffceb26e6) ([merge request](gitlab-org/gitlab!129219)) **GitLab Enterprise Edition**
- [Expose adminWorkItemLink permission in work items](gitlab-org/gitlab@77f4c8d24918ac034aa6208fc58ad43b9576d8e4) ([merge request](gitlab-org/gitlab!131390))
- [Close similar abuse reports when primary abuse report is closed](gitlab-org/gitlab@ab941abb7112e0c7653421c8695fcbd6b3be2734) ([merge request](gitlab-org/gitlab!130028))
- [Persist approval_settings and any_merge_request rules in policies](gitlab-org/gitlab@6abe2948274ab94154fcc5298652aa983f3509de) ([merge request](gitlab-org/gitlab!130630)) **GitLab Enterprise Edition**
- [Release branch_exceptions feature flag for SaaS](gitlab-org/gitlab@9425837c696fe95d52b5fb3adc57290e32eb512a) ([merge request](gitlab-org/gitlab!131326)) **GitLab Enterprise Edition**
- [Add Packages::Nuget::Symbol model and corresponding db table](gitlab-org/gitlab@d99f937fa864300e26aaf0724818b20c504ed0fc) ([merge request](gitlab-org/gitlab!129916))
- [Geo: Add Object Storage verification (filesize check)](gitlab-org/gitlab@30be991d3e55904b81ba6babe741d1c50852778c) ([merge request](gitlab-org/gitlab!131000)) **GitLab Enterprise Edition**
- [Adds Service Desk custom email reply address](gitlab-org/gitlab@84bf176fc809085531ca7378021fe3be18e96880) ([merge request](gitlab-org/gitlab!131270))
- [Enable on-hover flyout menus in sidebar of new navigation](gitlab-org/gitlab@c28322cae744b480fe17bf0e0dbbcdea63935186) ([merge request](gitlab-org/gitlab!131264))
- [Chore: add instance and docker-autoscaler executor types](gitlab-org/gitlab@c906bec4a444b5e07be2ae5956456396071979df) by @ar-mali ([merge request](gitlab-org/gitlab!130249))
- [Adds support for runs/search MLflow API](gitlab-org/gitlab@a25d9a04ee6d1157795ca2af7e192bbae83401d7) ([merge request](gitlab-org/gitlab!130521))
- [Support registries to resync all and reverify all via GraphQL](gitlab-org/gitlab@30c98b8e5d10a280a27f1a7ac925ca18c77e5664) ([merge request](gitlab-org/gitlab!123758)) **GitLab Enterprise Edition**
- [Provide and edit dismissal reason when dismissing finding](gitlab-org/gitlab@1d8ba127d0d107f1fe9f4d9e54d5bca49527df42) ([merge request](gitlab-org/gitlab!130193)) **GitLab Enterprise Edition**
- [Update MATLAB.gitlab-ci.yml to add a new `build` job](gitlab-org/gitlab@5796ef4182e5083d85a72fb89f033da8f033fe4f) by @sameagen-MW ([merge request](gitlab-org/gitlab!130569))
- [Add notify_only_broken_pipelines field to Telegram](gitlab-org/gitlab@838d734d4639330fc4d4cd178aff7756bc7b82ca) ([merge request](gitlab-org/gitlab!131140))
- [Added model validation and list active attribute for header](gitlab-org/gitlab@b322a2c6bd4e13604b8a2fb4b1947db48e88bdbe) ([merge request](gitlab-org/gitlab!129829)) **GitLab Enterprise Edition**
- [Add license type to dependency type](gitlab-org/gitlab@cc348736950af6befc97601c8cf9639c3cb9e6b9) ([merge request](gitlab-org/gitlab!130526)) **GitLab Enterprise Edition**
- [Add force_full_reconciliation field to workspaces](gitlab-org/gitlab@402be46595a059791c328ebb67a805d7218ebccd) ([merge request](gitlab-org/gitlab!131188))
- [Add ComponentsFinder](gitlab-org/gitlab@c41c0120a10e47124f7330dae6a0b83613d5a44c) ([merge request](gitlab-org/gitlab!128941)) **GitLab Enterprise Edition**
- [Sessions cookie key to be configurable in development environment](gitlab-org/gitlab@0a5c3c69d0e5d87bfb5d346a1989db8f7f8d4fa4) ([merge request](gitlab-org/gitlab!130858))
- [Prepare async index for pipeline_id_convert_to_bigint](gitlab-org/gitlab@d2a98d18e4338c51e06df4d173e868545ca10ba8) ([merge request](gitlab-org/gitlab!129201))
- [Sync create indexes for ci_stages pipeline_id conversion](gitlab-org/gitlab@38574ffa52e98f2bbcb6474a2a1f61086c85c8db) ([merge request](gitlab-org/gitlab!130917))
- [Add extra attributes to Internal events tracking on frontend](gitlab-org/gitlab@362e62d2d8e24a4aa392ddbe0f62fe9dcd5c247f) ([merge request](gitlab-org/gitlab!130810))
- [Add validation for legacy epic issue relation](gitlab-org/gitlab@8e306d82c40d38d435dae80fe0ef9697c4ad3d86) ([merge request](gitlab-org/gitlab!130726)) **GitLab Enterprise Edition**
- [Add actual time that the MR was merged to merged MR list](gitlab-org/gitlab@6542b062a0506c52d808b48762f2eef65cb59b82) ([merge request](gitlab-org/gitlab!130245))
- [Audit user password reset failure events](gitlab-org/gitlab@93186dc31fb038b03a92d54e93210814f3db6171) ([merge request](gitlab-org/gitlab!129079)) **GitLab Enterprise Edition**
- [Adds Export Sbom APIs](gitlab-org/gitlab@6f8f175ba84a3b099872cf021db13a9481611d7f) ([merge request](gitlab-org/gitlab!128974)) **GitLab Enterprise Edition**
- [Adding cached markdown fields to Review LLM Summaries](gitlab-org/gitlab@05e1858aa90194cc003f16fd18756371dc4be49a) ([merge request](gitlab-org/gitlab!131087))
- [Support for include:rules:changes](gitlab-org/gitlab@b71cf74c1ce712e88846348392e3c1175090c226) ([merge request](gitlab-org/gitlab!130966))
- [Add state header to notification emails](gitlab-org/gitlab@75a99ec9047636df4c4ba8033a8bf8dc69b078a3) ([merge request](gitlab-org/gitlab!130967))
- [Add vsd banner](gitlab-org/gitlab@b88a10de6920a400b06fae7e185722de87310bdb) ([merge request](gitlab-org/gitlab!130513)) **GitLab Enterprise Edition**
- [Add foreign key for ci_pipeline_chat_data.pipeline_id_convert_to_bigint](gitlab-org/gitlab@17229ead957644c449396ef0bc9da526da7057d1) ([merge request](gitlab-org/gitlab!130893))
- [Add foreign key for ci_pipeline_messages.pipeline_id_convert_to_bigint](gitlab-org/gitlab@457bfd5ba0f37912a4841a7b3112b75de91c5311) ([merge request](gitlab-org/gitlab!130899))
- [Add cosign template](gitlab-org/gitlab@7d8133d7395e399cdd778daf98e95d1a01d41755) ([merge request](gitlab-org/gitlab!130339))
- [Add merged_commit_sha to merge_requests](gitlab-org/gitlab@7843dd76e179acaf164186b87173d0d8cf87b54a) ([merge request](gitlab-org/gitlab!129311))
- [Update advisory scanning to only scan recent](gitlab-org/gitlab@bc4b85bc771a0062379d47364db5acf767031971) ([merge request](gitlab-org/gitlab!130469)) **GitLab Enterprise Edition**
- [Release expose_dismissal_reason feature](gitlab-org/gitlab@dcc828e8b29e2cb997d0e082ed84ddf437f7fd63) ([merge request](gitlab-org/gitlab!130748))
- [Add a GraphQL query to get organization users](gitlab-org/gitlab@38178d871a3165b2c6fff036ff4bf1be9ed46fba) ([merge request](gitlab-org/gitlab!130017))
- [Create cron job to ensure merge requests are prepared](gitlab-org/gitlab@dde61a7c05561b07ae0f5b4ae35fdbac85b3a2ef) ([merge request](gitlab-org/gitlab!121999))
- [Table and model for instance level gcp config added](gitlab-org/gitlab@12befa626b1126bd4853a40d9016db340fadf8d7) ([merge request](gitlab-org/gitlab!130079)) **GitLab Enterprise Edition**
- [Add cleanup worker](gitlab-org/gitlab@f5080b3fbc9a05bd098565e4fdc6a66ae2706456) ([merge request](gitlab-org/gitlab!130622)) **GitLab Enterprise Edition**
- [Associate projects with organization](gitlab-org/gitlab@5b9fba59bad5b59df24b57632e98ffce076cabf4) ([merge request](gitlab-org/gitlab!120829))
- [Add support for nuget v2 OData package entity endpoints](gitlab-org/gitlab@cc9643994fe0216934845427aa3207dffad9d3ac) ([merge request](gitlab-org/gitlab!127667))
- [Display activity for similar open abuse reports when aggregated](gitlab-org/gitlab@a016ebc4f7dfe4651d59bc39e7a8a77cf2dad30c) ([merge request](gitlab-org/gitlab!130278))
- [Add `pages_path_prefix` job option](gitlab-org/gitlab@ce70ec571b0fc82fd7185022643d4d64cffa5b0a) ([merge request](gitlab-org/gitlab!129534))
- [Send email when resource access token about to expire](gitlab-org/gitlab@76e7f92bef2d92fae99194e49e4e7dc2492a639d) ([merge request](gitlab-org/gitlab!128662))
- [Adds page URL params for packages list pagination](gitlab-org/gitlab@8ce0ef342aa88dddc5c88dc9c49826cd55d855ad) ([merge request](gitlab-org/gitlab!130437))
- [Prepare async index for pipeline_id_convert_to_bigint](gitlab-org/gitlab@deaa03b708980c0dc7b83f60a6781865a77e7ef4) ([merge request](gitlab-org/gitlab!128710))
- [Remove scan_execution_group_bot_users feature flag](gitlab-org/gitlab@5591b5a611edc7984d3583534ba9c6ee89c2d18f) ([merge request](gitlab-org/gitlab!130711)) **GitLab Enterprise Edition**
- [Migration for service account users be declared as external](gitlab-org/gitlab@ada024e189da53fbd12ec7344a5acee305e7125e) ([merge request](gitlab-org/gitlab!130597)) **GitLab Enterprise Edition**
- [Prepare async index for pipeline_id_convert_to_bigint](gitlab-org/gitlab@76f3fc58f75c68bfdd22c09010da8cbf00fbb931) ([merge request](gitlab-org/gitlab!129196))
- [Enable VSD count aggregation setting](gitlab-org/gitlab@2bb9d1e46294bbd13d5ebfb569b4e54930ff09e8) ([merge request](gitlab-org/gitlab!130704))
- [Add BrowserSDK for page view tracking to Gitlab.com](gitlab-org/gitlab@28467e7014a781d7ce8a94588be2b420e705c5f1) ([merge request](gitlab-org/gitlab!130168))
- [Exclude archived projects from blob search](gitlab-org/gitlab@128f4b00a70eb7488d3ce3a2a8b0d384c96193fb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/128613)) **GitLab Enterprise Edition**
- [Add logo to integrations page](gitlab-org/gitlab@aeb6e51f255da7fa389d2d5c12778af03aba7fc8) ([merge request](gitlab-org/gitlab!130331))
- [Allow verification of files in Object Storage](gitlab-org/gitlab@72d54886cd608830c75296ba8ca40583122f3bdc) ([merge request](gitlab-org/gitlab!127408)) **GitLab Enterprise Edition**
- [Remove elevated_guests FF](gitlab-org/gitlab@a4f7a8e032b693929b48c65ca53a61219c4999a1) ([merge request](gitlab-org/gitlab!130048)) **GitLab Enterprise Edition**
- [Add Geo bulk mark verification pending in batches](gitlab-org/gitlab@566eaa4718ed6e830cfc24078ae0d06d7365c303) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/125784)) **GitLab Enterprise Edition**
- [Add external issue author to graphql for service desk](gitlab-org/gitlab@a106eab003ceef148656f65f819d1bc1ccc386fb) ([merge request](gitlab-org/gitlab!129665))
- [Implement VSD GraphQL query](gitlab-org/gitlab@71e6a511082700e556f4b444fa5c3f4f6a50f53e) ([merge request](gitlab-org/gitlab!129450)) **GitLab Enterprise Edition**
- [Add user_list to feature_flag api](gitlab-org/gitlab@32780082abf3111d57287c5c81e97aae4a64402e) by @zhanglinjie ([merge request](gitlab-org/gitlab!129899))
- [Backfill ProjectStatistics to use recent size](gitlab-org/gitlab@031e79cb018546656696d8486e8b06bab9e8ddfe) ([merge request](gitlab-org/gitlab!128730))
- [Add patch_id_sha column to approvals](gitlab-org/gitlab@c9726c40167e52e9b3fd0a1748b8281877883584) ([merge request](gitlab-org/gitlab!130108))
- [Add filter argument to linkedItems field](gitlab-org/gitlab@c1aa00ce90370b092502d2ba717c32e2006e4875) ([merge request](gitlab-org/gitlab!127984))
- [Add group merge request approval setting for SAML](gitlab-org/gitlab@2c88a9a9ea416513e0508d27bca1ac63a19dc951) ([merge request](gitlab-org/gitlab!129780))
- [Remove the scan_execution_bot_users feature flag](gitlab-org/gitlab@217c5a842fb6a7f11ab34ac6194555788d614a9c) ([merge request](gitlab-org/gitlab!130397)) **GitLab Enterprise Edition**
- [Add scan policies count to security_orchestration_helper](gitlab-org/gitlab@5520577a10b9f0dc3d80cb66b6a282b3b0811304) ([merge request](gitlab-org/gitlab!129863)) **GitLab Enterprise Edition**
- [Prepare async index for pipeline_id_convert_to_bigint](gitlab-org/gitlab@00095579f9b6948cab5e4fbf25169477f50338a1) ([merge request](gitlab-org/gitlab!127471))
- [Add support for approval_settings and any_merge_request in policy schema](gitlab-org/gitlab@6f14e8ec8ab1b4345f7d332d8d4867a4f0fb13f1) ([merge request](gitlab-org/gitlab!130189)) **GitLab Enterprise Edition**
- [Remove ai_chat_history_context feature flag](gitlab-org/gitlab@00b79c09a4c02a7dcfc49026dd2e16edbc7edfb7) ([merge request](gitlab-org/gitlab!130396)) **GitLab Enterprise Edition**
- [Create index for pipeline_id_convert_to_bigint](gitlab-org/gitlab@81238f7eed1443becc190f76b61d5e2da461081f) ([merge request](gitlab-org/gitlab!128716))
- [Adds merge service](gitlab-org/gitlab@eca3367f5fc56150e0a31ee212a121786f224766) ([merge request](gitlab-org/gitlab!128872)) **GitLab Enterprise Edition**
- [Add vulnerability's full path to CSV export](gitlab-org/gitlab@9c6710df8f1a014c3ae7e2c180996ab3cd150585) ([merge request](gitlab-org/gitlab!129818)) **GitLab Enterprise Edition**
- [Synchronously create indexes for uuid colum type migration cleanup](gitlab-org/gitlab@4908da82473bde5bf043cf434b3f6205baa53451) ([merge request](gitlab-org/gitlab!128496))
- [Add frontend metrics tracking for Threat Insights](gitlab-org/gitlab@bfe49e5d213a05abeb8198192854ee9042b28528) ([merge request](gitlab-org/gitlab!129620)) **GitLab Enterprise Edition**
- [Adds page URL params for dependency proxy pagination](gitlab-org/gitlab@1179f66a0c3cc902bcb30e450c93774920bd3628) ([merge request](gitlab-org/gitlab!130088))
- [Schedule VSD CountWorker via Cron](gitlab-org/gitlab@5cd4e0e2633a9c5394317f055541035ebc47f801) ([merge request](gitlab-org/gitlab!130273))
- [Return response from streamed request to Anthropic](gitlab-org/gitlab@d8aacf83c3fef8443d88585a756f7eecebc14735) ([merge request](gitlab-org/gitlab!130093)) **GitLab Enterprise Edition**
- [Remove namespace_storage_forks_cost_factor feature flag](gitlab-org/gitlab@5214438b024432de0630fe7e14acc5caa7cf94a6) ([merge request](gitlab-org/gitlab!130247))
- [Add `admin_merge_request` to `member_roles` table](gitlab-org/gitlab@c0ae2f9c2f51b274e3bb2ea231d787cf68bfceef) ([merge request](gitlab-org/gitlab!128302))
- [Show custom emoji in issuable title in header & list](gitlab-org/gitlab@b2a84270d1fe947e2c977cc1f85f6358cacfcd2c) ([merge request](gitlab-org/gitlab!129453)) **GitLab Enterprise Edition**
- [Add connected agents usage metric](gitlab-org/gitlab@fcc4b218f29111aa30f44698006bdc9f8915977f) ([merge request](gitlab-org/gitlab!128580))
- [Add usage data on new product analytics features](gitlab-org/gitlab@1f306dc8951a4df475bd5e539abc3e131983fafb) ([merge request](gitlab-org/gitlab!128029))
- [Add workspace variables table and add PAT to workspaces table](gitlab-org/gitlab@e5e5daf543d02b60bb4b5d53efab728e74c9d07a) ([merge request](gitlab-org/gitlab!129688)) **GitLab Enterprise Edition**
- [Globally Enable holt winters forecast for deployment frequency](gitlab-org/gitlab@b54cb33c51df377f1f04bc46e1909abdfbf4c226) ([merge request](gitlab-org/gitlab!130026)) **GitLab Enterprise Edition**
- [Add lock_on_merge support for scoped labels](gitlab-org/gitlab@90d0d74a482557272603a10d4080f27a81ed41e4) ([merge request](gitlab-org/gitlab!129867))
- [Expose uuid on VulnerabilityType](gitlab-org/gitlab@3ec1562f63f7dfa4d2cb66b6bcb63ea02d0db3a0) ([merge request](gitlab-org/gitlab!129977)) **GitLab Enterprise Edition**
- [Expose solution on VulnerabilityType](gitlab-org/gitlab@65475a1ff6cbdd35fe86cb9cde0a51f8d33b2b0f) ([merge request](gitlab-org/gitlab!129852)) **GitLab Enterprise Edition**
- [Add a setting for allowing/disallowing duplicate NuGet package uploads](gitlab-org/gitlab@acc368b66b502c3d3da36cc9b502a7e78462bea6) ([merge request](gitlab-org/gitlab!128269))
- [Add pages multiple version toggle](gitlab-org/gitlab@6ee611e290914021a2a46eabe6a4ca8192b85314) ([merge request](gitlab-org/gitlab!127142))
- [Audit delivery of confirmation emails](gitlab-org/gitlab@742d8812c64540aa948f78eaca04f70c3f5cf6a1) ([merge request](gitlab-org/gitlab!129261)) **GitLab Enterprise Edition**
- [Adding decompress_archive_file_timeout to application settings](gitlab-org/gitlab@43c793f13dbb3ba4e9d264c902d7c867baa826b9) ([merge request](gitlab-org/gitlab!129161))
- [Add `licenses` column to `sbom_occurrences` table](gitlab-org/gitlab@f04c12c3092c3d6e5abc598b6867fdbeeea5dcc4) ([merge request](gitlab-org/gitlab!129542))
- [Check Arkose's status, bypass captcha on sign-in if there is an outage](gitlab-org/gitlab@915fb204e979e08c76a1a55988c23f9bead7e931) ([merge request](gitlab-org/gitlab!126933)) **GitLab Enterprise Edition**
- [Add a background migration to fix the `namespace_id`s read records](gitlab-org/gitlab@e016049f27c6578eb690b27389bdfd928e0ce3e3) ([merge request](gitlab-org/gitlab!129244))
- [Add popover to experiment badge](gitlab-org/gitlab@9ddd516dd9d0156838a7f92a6584ca1e455180cf) ([merge request](gitlab-org/gitlab!128499)) **GitLab Enterprise Edition**
- [Include the type of work item in related system notes](gitlab-org/gitlab@472c4d4bc5c7666f98f0969718d166ab96544814) ([merge request](gitlab-org/gitlab!129613))
- [Show confidential information when in work item notes](gitlab-org/gitlab@0ccb10de80e5a61b3d1a38461c1871ebebc5d980) ([merge request](gitlab-org/gitlab!125258))
- [Add a GraphQL query to get organization groups](gitlab-org/gitlab@0c8ee3b8f343930cbf6a63ec233464142c5039d6) ([merge request](gitlab-org/gitlab!128733))
- [Toggle on/off rollup progress](gitlab-org/gitlab@14cefcbe4fb10df2a3263179f910a44131b8e41f) ([merge request](gitlab-org/gitlab!128446)) **GitLab Enterprise Edition**
- [Display similar abuse reports in detail view of an abuse report](gitlab-org/gitlab@3a5ba00ae3a1ff79c2e5f9f8e5d403b9c4425990) ([merge request](gitlab-org/gitlab!120958))
- [Adding name field to google cloud logging audit destinations](gitlab-org/gitlab@a5d7fac9d02645a9d13242f8c0ba4f66db50800e) ([merge request](gitlab-org/gitlab!128205)) **GitLab Enterprise Edition**
- [Add GraphQL mutation to unlink items from a work item](gitlab-org/gitlab@9194075b49431b40252f1ae8b15fb00291028bb8) ([merge request](gitlab-org/gitlab!127639))
- [Handle code suggestions add-on purchase in licenses](gitlab-org/gitlab@7da2c03881297b51b9cc3dea56e2ea017f43c0ba) ([merge request](gitlab-org/gitlab!129484)) **GitLab Enterprise Edition**
- [Dismiss card and copy text for AI discussion summary](gitlab-org/gitlab@b91fe0eb3c78b382551a88a830241613dfb4e40f) ([merge request](gitlab-org/gitlab!129339)) **GitLab Enterprise Edition**
- [Update label views to allow setting lock_on_merge](gitlab-org/gitlab@961249baab405b828aa45b4077be003a11d6078a) ([merge request](gitlab-org/gitlab!129151))
- [Populate denormalized columns for the sbom_occurrences table](gitlab-org/gitlab@813f3e9ff28b74bd608fafb54edad042631dd219) ([merge request](gitlab-org/gitlab!129486))
- [Add Authorizations Changed Event consumer](gitlab-org/gitlab@90c5359fec4cc15a2261bbce7a6fb8a47a142d56) ([merge request](gitlab-org/gitlab!119792))
- [Add metrics for Vulnerability Management actions](gitlab-org/gitlab@d203dc9707622436c01367f35615768a99d1c139) ([merge request](gitlab-org/gitlab!129482)) **GitLab Enterprise Edition**
- [Add patch_id_sha field to REST API](gitlab-org/gitlab@ddce24ffc5ca51f4cc33056b1a885307b533c6cd) ([merge request](gitlab-org/gitlab!129546))
- [Remove post_import_repository_size_check ff](gitlab-org/gitlab@4baed0516bc750065b066398765d1c0271d82a6f) ([merge request](gitlab-org/gitlab!129341)) **GitLab Enterprise Edition**
- [Expose source branch protected and squash CI vars](gitlab-org/gitlab@6a0219cf0a5fafa1318c9270ca884281d86ee0ad) ([merge request](gitlab-org/gitlab!127848))
- [Add DeclarativePolicy patch to memoize some attributes](gitlab-org/gitlab@86a2f5b633067ae81a1275fa74d60fc398057400) ([merge request](gitlab-org/gitlab!128970))

### Fixed (167 changes)

- [Fix GitHub repositories mirror](gitlab-org/gitlab@5f8ccb6c2d60b81130466f0cea08db747b657cb4) ([merge request](gitlab-org/gitlab!131720))
- [Fix import of subrelations on items with 1 emoji](gitlab-org/gitlab@b3367287c36f9d54db63b2a3165665cfd283167f) ([merge request](gitlab-org/gitlab!131958))
- [Add period for consistency](gitlab-org/gitlab@24689ec50eff1ce2ff1a586dede5239e1c0e111b) ([merge request](gitlab-org/gitlab!131946))
- [Change vulnerability state to detected](gitlab-org/gitlab@e53e5da170d483de580129112f4eac54f753c7db) ([merge request](gitlab-org/gitlab!131732)) **GitLab Enterprise Edition**
- [Fix vulnerability report pagination alignment](gitlab-org/gitlab@e3b63dcc5e08707b029b280c62ecd91d24d81a22) ([merge request](gitlab-org/gitlab!131769)) **GitLab Enterprise Edition**
- [Change last event id columns in geo_node_statuses table to bigint](gitlab-org/gitlab@6588c416ce95e08a6290aa64334e9bcb396c8efe) ([merge request](gitlab-org/gitlab!131079))
- [Removing shared_into_ancestors from members query](gitlab-org/gitlab@39cae3e7c50bd508c9be35444b1f20159c051cbd) ([merge request](gitlab-org/gitlab!131587))
- [Fix opt in email option during registration](gitlab-org/gitlab@2d3b68beb1d37857f8961464fb14d6a7310ff01c) ([merge request](gitlab-org/gitlab!131926)) **GitLab Enterprise Edition**
- [Add infinite scroll to source branch dropdown](gitlab-org/gitlab@204ebe883983ba05dc94415d5b6ced83849a363a) ([merge request](gitlab-org/gitlab!130145))
- [Update merged_commit_sha in MergeRequests::RefreshService](gitlab-org/gitlab@882f958db0fe19ccd745f4e5535c3a2b99f0283a) ([merge request](gitlab-org/gitlab!131924))
- [Add repository_size_limit permission checks](gitlab-org/gitlab@8df2d6846c34ec1f72adeb8d9b40b44cb77effd2) ([merge request](gitlab-org/gitlab!131147)) **GitLab Enterprise Edition**
- [Fixed sligthly off text element on CI job sidebar](gitlab-org/gitlab@f0ee8757f5fce31ed2f1857aa0df48cb5a1484d8) by @zillemarco ([merge request](gitlab-org/gitlab!131751))
- [Allow auditors/admins to view VSA](gitlab-org/gitlab@c2ec4112305b7ddf4ae424be2dd76e7d94de4bab) ([merge request](gitlab-org/gitlab!131469)) **GitLab Enterprise Edition**
- [Let people make text bigger if they want to](gitlab-org/gitlab@0cad1572c7eaf4288880ef964b60f59775790d8f) ([merge request](gitlab-org/gitlab!131852))
- [Fix Geo secondary proxying Git pulls unnecessarily](gitlab-org/gitlab@7853b97b5935cd8085c3aa2fa76d4fdf841bdd3d) ([merge request](gitlab-org/gitlab!131832)) **GitLab Enterprise Edition**
- [Hide dropdown divider if user is issuable author](gitlab-org/gitlab@4bbd10b6f0e64a8f3d43ca8078e736f0f6e1a1a5) ([merge request](gitlab-org/gitlab!131814))
- [Capture gitaly errors in Security Policies to mitigate 500 errors](gitlab-org/gitlab@47dc360e88f62cc3795d704b28df62baf3468e8f) ([merge request](gitlab-org/gitlab!131353)) **GitLab Enterprise Edition**
- [Fix feature flag check in Routable](gitlab-org/gitlab@3ae2ce3b23582fe3c3017ce3f26adc967e6fa83d) ([merge request](gitlab-org/gitlab!131786))
- [Allow Service Account to be added to SSO-enforced group](gitlab-org/gitlab@b3e301dbb577e2e0bdcd2e6a642f64550106e10b) ([merge request](gitlab-org/gitlab!126059)) **GitLab Enterprise Edition**
- [Change dropdown label for when 'No one' role is selected](gitlab-org/gitlab@5f5c1dd0b420ad1684008c6ea025455b14c53d56) ([merge request](gitlab-org/gitlab!131822))
- [Move pin button to be sibling of nav item link in new navigation](gitlab-org/gitlab@4aaa224f9883010c851653cf194cf03c3af0361f) ([merge request](gitlab-org/gitlab!130603))
- [Fix bug with MRs now showing diffs after bitbucket importer](gitlab-org/gitlab@fd2493e3559e4de9619615ae09ed97cc22747eef) ([merge request](gitlab-org/gitlab!131382))
- [Fix icon for submodules in the commit view](gitlab-org/gitlab@b83f25109f46532c2a6c0ccd8c9b8b2a69f0245c) ([merge request](gitlab-org/gitlab!131260))
- [Fix checking of parent presence in namespace method](gitlab-org/gitlab@7b4d766e423e6b61107eac92900f0d4e6ad57d0d) ([merge request](gitlab-org/gitlab!131723))
- [This MR fixes the bug scan execution policy](gitlab-org/gitlab@b6f3521a93d11c5900bf69bc2a3ddbe1fbb5e2e9) ([merge request](gitlab-org/gitlab!131556)) **GitLab Enterprise Edition**
- [This MR fixes the bug](gitlab-org/gitlab@01fd51dbdb10f6e13d1786ad4b05fab1462388c6) ([merge request](gitlab-org/gitlab!131552)) **GitLab Enterprise Edition**
- [Removes empty alert from Insights page](gitlab-org/gitlab@e654651788d08069571aca95f18b7a2992515bd4) ([merge request](gitlab-org/gitlab!131700)) **GitLab Enterprise Edition**
- [Clear SafeRequestStore often when exporting](gitlab-org/gitlab@0d98d55c95014625d150ca58f41d861a1ee9e0e6) ([merge request](gitlab-org/gitlab!131621))
- [Fix PipelineBatchWorker retries](gitlab-org/gitlab@6deb2eb9fb7972a593373b5242202efcf20a2c21) ([merge request](gitlab-org/gitlab!131714))
- [Update horizontal spacing on runner platform options](gitlab-org/gitlab@77a8425493d37efc2c1893e312601adfea625a5e) ([merge request](gitlab-org/gitlab!131678))
- [Fix pipeline editor file tree spacing](gitlab-org/gitlab@9e2b06af934abd02f78e08c0fb442d221f3ebddc) ([merge request](gitlab-org/gitlab!131676))
- [Fix Sidekiq NameError for BackfillNotificationJobsWorker](gitlab-org/gitlab@01de58b1d17fd72c979fd4a976cdac22514d65b8) ([merge request](gitlab-org/gitlab!131663))
- [Fix push event description for batches](gitlab-org/gitlab@c8036c07173a794c5f96b4c84b55a6cbd92c1a43) ([merge request](gitlab-org/gitlab!131157))
- [Fix redirects for 2fa and finish onboarding appropriately](gitlab-org/gitlab@1492587aa0644d64b370800aed512f547c687f93) ([merge request](gitlab-org/gitlab!131059)) **GitLab Enterprise Edition**
- [Handle an exception when Git blame is out of range](gitlab-org/gitlab@c434d5de799ca562c73219f6629b84b0a6a3e09e) ([merge request](gitlab-org/gitlab!131638))
- [Fix sidebar toggle tooltip](gitlab-org/gitlab@f5e1de903b550ae1be36b10454a9c72bbc505ad0) ([merge request](gitlab-org/gitlab!131515))
- [Support max_byte_size settings for instance SAML](gitlab-org/gitlab@9a9bcee340848ce65f5d0bbd2d06b1fb3fbe54e6) ([merge request](gitlab-org/gitlab!130515))
- [Fix tooltip rendering in user bar](gitlab-org/gitlab@50badcf80da93339df91e2e67978c450046e9563) ([merge request](gitlab-org/gitlab!131394))
- [Inline SyncProjectWorker call in RefreshProjectPoliciesWorker](gitlab-org/gitlab@5ab682cee1f6dc16a5669a8469e5cf427bd4bf5c) ([merge request](gitlab-org/gitlab!131539)) **GitLab Enterprise Edition**
- [Fix OAuth bug related to openid_connect](gitlab-org/gitlab@48f531deda453b972c4a32c083e3fb918b344977) ([merge request](gitlab-org/gitlab!131449))
- [Fix mermaid rendering](gitlab-org/gitlab@848d582c9e0a49b3d6802940c4266ab3ea7dbaf1) ([merge request](gitlab-org/gitlab!131377))
- [Fix `admin_merge_request` custom role when the feature is private](gitlab-org/gitlab@e72ed66bb20d98ddd751c1aebfc1ad9c2035bf05) ([merge request](gitlab-org/gitlab!131529)) **GitLab Enterprise Edition**
- [Remove `update_chronic_duration` feature flag](gitlab-org/gitlab@c876a2616cea53ac0349019e6439310d7a857524) ([merge request](gitlab-org/gitlab!131514))
- [Allow CWE(uppercase) for security training](gitlab-org/gitlab@6f348ff827318c549c3a57173cbf4942eb10be04) ([merge request](gitlab-org/gitlab!131153)) **GitLab Enterprise Edition**
- [Update regex and mapped usernames to handle bug](gitlab-org/gitlab@357b640dbd37c7ef1071790d2756f9c730b9fb1b) ([merge request](gitlab-org/gitlab!131493))
- [Fix group member invite limit rendering](gitlab-org/gitlab@f7373523dc2a636e7535384b700713fde9f3d851) ([merge request](gitlab-org/gitlab!131318))
- [Combine devise 2FA strategies](gitlab-org/gitlab@f0669b1e9c169f427d25620d63654e1b193a6276) ([merge request](gitlab-org/gitlab!130756))
- [Reset required approvals for violated rules](gitlab-org/gitlab@7807ea2789992a0a2b3db226230f1e3cc260fe56) ([merge request](gitlab-org/gitlab!130517)) **GitLab Enterprise Edition**
- [Adding contentHtml to review summary types](gitlab-org/gitlab@2b2a0d2f74f51469d10b9f38794b2111287c66d0) ([merge request](gitlab-org/gitlab!130221)) **GitLab Enterprise Edition**
- [Fix notification dropdown hover in work_item_actions](gitlab-org/gitlab@18732c70a2cc864b30e6a75d56f2d999f9e473dc) ([merge request](gitlab-org/gitlab!130928))
- [Update calendar icon spacing on environments view](gitlab-org/gitlab@d89ea86963243e720bce0535b5106105b5c8568d) ([merge request](gitlab-org/gitlab!131451))
- [Reindex issues to fix possible wrong values of label_ids](gitlab-org/gitlab@2f00a91c3b20817f7c30cff943f111f8dec18127) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131261)) **GitLab Enterprise Edition**
- [Allow dismissal_reason updates on already dismissed findings](gitlab-org/gitlab@c326f486b6792d4e4ba44582311c71a62c449a7b) ([merge request](gitlab-org/gitlab!130509)) **GitLab Enterprise Edition**
- [Reindex work_item to fix possible wrong values of label_ids](gitlab-org/gitlab@4794a48a3ca552bb40af4e495548e278573fbbf9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131284)) **GitLab Enterprise Edition**
- [Handle old usernames that are substrings of new usernames](gitlab-org/gitlab@f08049b470e4379a105714f66bb568984046be1a) ([merge request](gitlab-org/gitlab!131187))
- [Make sure active nav item in sidebar is visible](gitlab-org/gitlab@fd1bb11cd4cd60debf1742bc901f1b893159db36) ([merge request](gitlab-org/gitlab!131136))
- [Stop sending user to pages they don't have access to on invites](gitlab-org/gitlab@f330845f236255eed989bec00dbb389d91027e23) ([merge request](gitlab-org/gitlab!130771))
- [Update namespace_id in standards adherence when a project is moved](gitlab-org/gitlab@edcca42267cec0acb62590da27f53ed02103f5cf) ([merge request](gitlab-org/gitlab!130701)) **GitLab Enterprise Edition**
- [Fix active nav item for Service Desk page](gitlab-org/gitlab@cb200f1d6a690101476f646292e85571eac43f92) ([merge request](gitlab-org/gitlab!130849))
- [Put exact matches first when searching for groups to transfer](gitlab-org/gitlab@db2259e4f4567566aad819fcb0e1582629ac9646) ([merge request](gitlab-org/gitlab!130773))
- [Hide the issue from archived project for basic search](gitlab-org/gitlab@d9131db625d943dce3937780c140dde62ee7e5bb) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131185))
- [Fix positioning of retry job dropdown](gitlab-org/gitlab@3eac967aeec224383b720b421eabc53e8fa6eb64) ([merge request](gitlab-org/gitlab!131189))
- [Remove checksum guard on modifying service class](gitlab-org/gitlab@637e1640c65999066c3980569b451df548b286bb) ([merge request](gitlab-org/gitlab!130806)) **GitLab Enterprise Edition**
- [Fix broken `learn more` link](gitlab-org/gitlab@a8a82888a28af7a9652c15c0cd2c69a998363804) ([merge request](gitlab-org/gitlab!131154))
- [Reindex Issue when attached label gets deleted](gitlab-org/gitlab@5b412bb2a75dcd1f9f5c51889812c6c9a8426dd3) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/130843)) **GitLab Enterprise Edition**
- [Pipelines list: Fix focus state](gitlab-org/gitlab@0e4d19a90555d434a2764cd207347000831e8a6d) ([merge request](gitlab-org/gitlab!130916))
- [Prevent pipeline creation while import is running](gitlab-org/gitlab@461539f1dc4cfde2e04124e277dab7eccdb8d4c0) ([merge request](gitlab-org/gitlab!131141))
- [Pipelines list: Actions are pushed out of table](gitlab-org/gitlab@bc29bf931925c00e7e8e27f7ff17332495741fa6) ([merge request](gitlab-org/gitlab!131133))
- [Properly handle `lang` attribute on `code` tags](gitlab-org/gitlab@f3317b94c182bbabf010f06571609a94b299b316) ([merge request](gitlab-org/gitlab!131100))
- [Ensure `include_source_code` is appropriately passed to the template](gitlab-org/gitlab@be00b33c62ca600b7f1d0f9fb80328c3385ac4f6) ([merge request](gitlab-org/gitlab!130875)) **GitLab Enterprise Edition**
- [Fix NoMethodError for ActivityPub](gitlab-org/gitlab@d91226dd745a0a425d4421cf68c7672fbb479920) ([merge request](gitlab-org/gitlab!131066))
- [Enable sync with package metadata db by default](gitlab-org/gitlab@f21da98ec90c8d505395e4c801c01a3e2c6e57d5) ([merge request](gitlab-org/gitlab!130176))
- [Jobs list: Fix focus states](gitlab-org/gitlab@f871c57bf18ea84b91631f77cb0cdd348b416ee1) ([merge request](gitlab-org/gitlab!130915))
- [Fix handling of locked scoped labels](gitlab-org/gitlab@ca5e455568597f89bf4a5760e373602616c59d2c) ([merge request](gitlab-org/gitlab!130252))
- [Email confirmation setting to be considered](gitlab-org/gitlab@7b278a7e99bf82f6c299f43faae423b05d6e83e4) ([merge request](gitlab-org/gitlab!130447)) **GitLab Enterprise Edition**
- [Limit the width of alerts on the MR page in fixed-width mode](gitlab-org/gitlab@037d06779353ed40babd490b5f72b458d28c582b) ([merge request](gitlab-org/gitlab!130248))
- [Fix bug in references pipeline](gitlab-org/gitlab@4b11a17c8ec3415c6843fa8fba1cd09f6f85c3ad) ([merge request](gitlab-org/gitlab!130942))
- [Gitpod settings description margin bottom fix (Admin area)](gitlab-org/gitlab@441d9c28d6d605a1fb5a52d8bdc0b306407260cc) ([merge request](gitlab-org/gitlab!130946))
- [Search query hash add filter, fix/refactor](gitlab-org/gitlab@1e2d09d1cec1c36b5edbb5ffbeaa4b74e3cd266d) ([merge request](gitlab-org/gitlab!130043)) **GitLab Enterprise Edition**
- [GraphQL: Return error from runners query if permissions missing](gitlab-org/gitlab@0e78a6552be919624121a6f68d552187a4bf968f) ([merge request](gitlab-org/gitlab!130450))
- [Fix bridge policy raises an error when downstream_project is nil](gitlab-org/gitlab@2e51ffa8d0e5a6faed21e34c112150d0e1bcbc8d) ([merge request](gitlab-org/gitlab!130889))
- [Add background color to new MR tabs](gitlab-org/gitlab@ad39b10885abc9a998da340e1f34baaec9a1344b) ([merge request](gitlab-org/gitlab!130873))
- [Remove sideborder in incident timeline event](gitlab-org/gitlab@c450ed266fb6e1d250f8d94552ee0f2caa15f77c) by @zarthus ([merge request](gitlab-org/gitlab!130867))
- [Note form: Normalize button spacing](gitlab-org/gitlab@18abe75af6a2ef8da595aeed3053e24bf90bc163) ([merge request](gitlab-org/gitlab!130838))
- [Fix undefined method `labels' for Jira integration](gitlab-org/gitlab@5f261c9c11481a55a9b059e6dbc16c52fc275933) ([merge request](gitlab-org/gitlab!130820))
- [Indicate user needs to login with primary email](gitlab-org/gitlab@c411b7353e2254d94723d087a89d26b6e1c71a5f) ([merge request](gitlab-org/gitlab!130779))
- [Create iid sequence for ci_pipelines with new projects](gitlab-org/gitlab@f0c13f146863a2a065aaab61381d91ae1d63a194) ([merge request](gitlab-org/gitlab!130532))
- [Fix undefined method `labels' for Jira integration](gitlab-org/gitlab@8de34d080f914c007b7d04acdf075969f9679d95) ([merge request](gitlab-org/gitlab!130717))
- [Check if SBOM pipeline has ID set](gitlab-org/gitlab@54d397647494c62731e4d5b74d51fd6fc98b472b) ([merge request](gitlab-org/gitlab!130312)) **GitLab Enterprise Edition**
- [Give dark-mode override higher specifity to fix bg color](gitlab-org/gitlab@2af9bb73904d08480e0a355e5022c302f07b53d9) ([merge request](gitlab-org/gitlab!130708))
- [Enable offset pagination FF for canceling pipelines](gitlab-org/gitlab@6d7f663d8189d706ca7d7afe68cdfb86760ba430) ([merge request](gitlab-org/gitlab!130607))
- [Add user allowlist to bypass Global Search rate limit](gitlab-org/gitlab@c5f0b4b1b30acc790a4a250a7e52bc3597bae206) ([merge request](gitlab-org/gitlab!130389))
- [Include descendant members in user autocompletes](gitlab-org/gitlab@dbafcbaa93218e2d6e7d35c8c642e47d3a934963) ([merge request](gitlab-org/gitlab!130652))
- [Fix placement of "Create new..." tooltip in navigation](gitlab-org/gitlab@336b94eb6b7d707c8e79cd09754f8ed36979a6c6) ([merge request](gitlab-org/gitlab!130588))
- [Fix the date filter on the global time tracking report](gitlab-org/gitlab@0944fc49debe12b737f376941627857c100673e7) ([merge request](gitlab-org/gitlab!130013))
- [Re-raise exceptions that happens during migration sampling](gitlab-org/gitlab@a0a1db18c36b712160c3f2b9af1c40e903ecad5e) ([merge request](gitlab-org/gitlab!130671))
- [Fix source code range highlighting](gitlab-org/gitlab@ff862da871fab685d92e202c552d28f2aec89e29) ([merge request](gitlab-org/gitlab!130401))
- [Do not render "Create new..." menu when it's empty](gitlab-org/gitlab@2f07971cfe46c1f73eede3e65b1ca45444b32796) ([merge request](gitlab-org/gitlab!130655))
- [Fix nil job JWTs when there are Gitaly connection issues](gitlab-org/gitlab@c02f822f9b5c3fdefc501ee603198b3bed4e3414) ([merge request](gitlab-org/gitlab!130651))
- [Fix secret detection ruleset variable suggestion](gitlab-org/gitlab@b7d66fa658a8a8b5d71f3cfd9613f2a2483547cf) ([merge request](gitlab-org/gitlab!130507)) **GitLab Enterprise Edition**
- [Refactor checking :enforce_locked_labels_on_merge](gitlab-org/gitlab@50f39876b78c863cea87659382e8effac950765a) ([merge request](gitlab-org/gitlab!130472))
- [Remove redundant 'plan' from order summary details](gitlab-org/gitlab@a1ac3a86b3a0b6767cc501422fb88c2c4dbda07e) ([merge request](gitlab-org/gitlab!130208)) **GitLab Enterprise Edition**
- [Fix disappearing filtered search in Issues Analytics](gitlab-org/gitlab@6999cb49f86146876e14f7bd82bf2b8fc831ac46) ([merge request](gitlab-org/gitlab!130577)) **GitLab Enterprise Edition**
- [Fix cluster service reindexing params](gitlab-org/gitlab@e71917d2e003c722fa4259df2d903f82e17fc6ed) ([merge request](gitlab-org/gitlab!130107)) **GitLab Enterprise Edition**
- [Add ability to search log header](gitlab-org/gitlab@59d2175744dc202001352a7d23f65a52f60e9609) ([merge request](gitlab-org/gitlab!129860))
- [Add username to users mapper](gitlab-org/gitlab@78c39f0d86140b99d891df89e04f94a83cefb783) ([merge request](gitlab-org/gitlab!128999))
- [Change `Vulnerability*Finder` interaction with archived projects](gitlab-org/gitlab@9fafff194b34691524cde2bbdf6b94d8d5202204) ([merge request](gitlab-org/gitlab!126921)) **GitLab Enterprise Edition**
- [Prevents Mail::SMTP monkey patch from overriding defaults](gitlab-org/gitlab@9a20000a8feeeae2e1a2bff4397071ecf31ba08a) ([merge request](gitlab-org/gitlab!130185))
- [Fix vertical alignment of user status sidebar](gitlab-org/gitlab@cebe3990eef9b6a98e28fb06cbfaea0a3da8bad0) ([merge request](gitlab-org/gitlab!130482))
- [GraphQL: Mask CiJob.shortSha when non-authorized](gitlab-org/gitlab@ff27c151a0f283a0c6b4fee41482c265ba14fdea) ([merge request](gitlab-org/gitlab!130110))
- [gitaly-test-spawn: Ensure that the gitlab-shell secret exists](gitlab-org/gitlab@469bcfd74c47ed25ce64535b71f8b94a4185608a) ([merge request](gitlab-org/gitlab!130485))
- [Update header-height SCSS variable to CSS custom property](gitlab-org/gitlab@aeb325bab0c52b35e275ec0eed7ea58f51c68e63) ([merge request](gitlab-org/gitlab!129769))
- [Modify ETV to use anthropic body streaming to fix timeout problems](gitlab-org/gitlab@d6d042ed203b70172d426217618c46042738bc7a) ([merge request](gitlab-org/gitlab!130337)) **GitLab Enterprise Edition**
- [Fix vertical alignment of emoji in cover status](gitlab-org/gitlab@76a89fea4b1489083e1a3ac048b8cfdd79760411) ([merge request](gitlab-org/gitlab!130443))
- [Fix reference to groupApprovers in security approvals](gitlab-org/gitlab@1ee4a7dae8b7844984d6514eadcd1f9cb76a71cc) ([merge request](gitlab-org/gitlab!129744)) **GitLab Enterprise Edition**
- [Remove unused jitsu-related settings](gitlab-org/gitlab@f2339004df795d7b0e15b0c149627e0b4ab76499) ([merge request](gitlab-org/gitlab!129981)) **GitLab Enterprise Edition**
- [Drop bridge jobs on unknown failures](gitlab-org/gitlab@e6be178223272aa73d0da45c3debe377ba9924f2) ([merge request](gitlab-org/gitlab!130311))
- [Fix focus mode behaviour for boards](gitlab-org/gitlab@99a1cceafa2a16f686dc8af66d234e7e5b7adaf4) ([merge request](gitlab-org/gitlab!130306))
- [Fix incorrect feature check for group level of push rules](gitlab-org/gitlab@99345a79f296c4957fc8cbbaa8b32c78fc5b5858) ([merge request](gitlab-org/gitlab!130293)) **GitLab Enterprise Edition**
- [Fix Job URL shows 404 when it's bridge](gitlab-org/gitlab@412172660d364458fb55e1aa071b3db8e3f60a00) ([merge request](gitlab-org/gitlab!130285))
- [Fix discrepancy in documentation](gitlab-org/gitlab@180a9e2b2b248285e3da2ef8536e17f593e24026) ([merge request](gitlab-org/gitlab!130086))
- [Fix false audit event for non persisted members](gitlab-org/gitlab@775e03199a2375cb3793e4a69e0454381401b71f) ([merge request](gitlab-org/gitlab!130050)) **GitLab Enterprise Edition**
- [Increase DROPDOWN_X_OFFSET_BASE in create menu](gitlab-org/gitlab@c5f5fa58b3b60bc0e252d680c65688de4cfe7910) ([merge request](gitlab-org/gitlab!130135))
- [Fixes missing "locked" checkbox from project runners form](gitlab-org/gitlab@0dc03c1c0681af63bd432aa91c6a0775e3fcaa35) ([merge request](gitlab-org/gitlab!129944))
- [Read latest ingested sbom pipeline id from redis](gitlab-org/gitlab@0f84dce985b02c6ee73bfc8fd2043ceda171e5ed) ([merge request](gitlab-org/gitlab!130196)) **GitLab Enterprise Edition**
- [This MR fixes error for branch exceptions](gitlab-org/gitlab@13edb8b0c302848fae75db1cd8d949f0e6335c8a) ([merge request](gitlab-org/gitlab!130133)) **GitLab Enterprise Edition**
- [Assignees & Participants: Fix show more buttons](gitlab-org/gitlab@6de7c9c6812394a24d83dfd7ca492a1a03f0725f) ([merge request](gitlab-org/gitlab!130149))
- [Modify query for group.first_owner](gitlab-org/gitlab@7fff19a9f3fe157d8849ea32695443e3aef9c948) ([merge request](gitlab-org/gitlab!130180))
- [Markdown editor: FIx alignment of notification warning](gitlab-org/gitlab@03acd724fdbf6bb49a9747409c1eeb55192060e3) ([merge request](gitlab-org/gitlab!130170))
- [Fixing LooseForeignKeys tests for single-db](gitlab-org/gitlab@a2067c10ab532f99888381af0b5a1dfcbb197993) ([merge request](gitlab-org/gitlab!130156))
- [Pipeline widget: Fix alignment of elements](gitlab-org/gitlab@f21b92b3b7fca34bb5248c19989f276cd398c247) ([merge request](gitlab-org/gitlab!129945))
- [Remove `gl-pt-2` class from sidebar search button wrapper](gitlab-org/gitlab@4a4cece050b61bf11788fb1f335c3e6ea840dfc1) ([merge request](gitlab-org/gitlab!130136))
- [Introducing LFK CleanupWorker turbo mode](gitlab-org/gitlab@0e1c9cfdd17b88a7e2eeabfaeb60ccf71e9d8bf6) ([merge request](gitlab-org/gitlab!128538))
- [Backfill nuget normalized version](gitlab-org/gitlab@df551b8b42f5d47df231ef65b2d52069137b293c) ([merge request](gitlab-org/gitlab!128675))
- [GraphQL: Mask job fields when requested for a non-owned runner](gitlab-org/gitlab@60ae8a17036ca59502d85fdaf5d0e7068eafec78) ([merge request](gitlab-org/gitlab!129831))
- [Prevent analyzers from being excluded in scan execution pipelines](gitlab-org/gitlab@6fb2472c7388bcc144d1cf1e798a1a1ad3bc2ced) ([merge request](gitlab-org/gitlab!130082)) **GitLab Enterprise Edition**
- [Enable "optimize_group_template_query" FF](gitlab-org/gitlab@c2ee14f18445e3d3f811acb423b6df9ddd9932b8) ([merge request](gitlab-org/gitlab!130074))
- [Fix timeout on group and instance security dashboards](gitlab-org/gitlab@0ea09b274d6bda69da9921a76e368db7c7b38533) ([merge request](gitlab-org/gitlab!130059)) **GitLab Enterprise Edition**
- [Fix broken link formatting in Gitlab for Slack App](gitlab-org/gitlab@7f845e6e3d63ac4735f908d36f3247c906a4145e) ([merge request](gitlab-org/gitlab!130052))
- [Fix duplicate license_scanning approval rule in MR approvals](gitlab-org/gitlab@325d35b92b3ff3cf0e063b9673b7ed19ed27c980) ([merge request](gitlab-org/gitlab!129965)) **GitLab Enterprise Edition**
- [Enable feature flag "errors_utf_8_encoding" by default](gitlab-org/gitlab@9ab804e17db3f66f2418e2903c042ee6ad2dc03e) ([merge request](gitlab-org/gitlab!129826))
- [Perform scheduled scan execution policy in a separate worker](gitlab-org/gitlab@9ed4f0e88b4d91b6d7bd5a72a92b0a597d9fcbc9) ([merge request](gitlab-org/gitlab!128137)) **GitLab Enterprise Edition**
- [Label selection dropdown: Fix first item stays selected](gitlab-org/gitlab@c40acd7377c56ec1252f60dea1ac99062b2c2554) ([merge request](gitlab-org/gitlab!128338))
- [Update group path updates with NPM packages](gitlab-org/gitlab@923cb3c7f18168dfbb964c6a4574eac8468290eb) ([merge request](gitlab-org/gitlab!129913))
- [Adjust VulnerabilitiesFinderResolver to accept only dismissal reason](gitlab-org/gitlab@ef5ebde7e714daff31b88c3bd15caa4d17c60a9c) ([merge request](gitlab-org/gitlab!129623)) **GitLab Enterprise Edition**
- [Direct import fails early when 2FA requirements not met](gitlab-org/gitlab@e484cb932c0b092f4c0b2ca53bb65c315652bcc7) ([merge request](gitlab-org/gitlab!129586))
- [Fix issue url generation for group level issues](gitlab-org/gitlab@d68ab6a8c4a4d3751e37aa6aa202de5bb20fe2b3) ([merge request](gitlab-org/gitlab!129872))
- [Don't send Service Desk emails when it's disabled](gitlab-org/gitlab@d91682f43f6ba04c7236afbb78958b3011c11682) ([merge request](gitlab-org/gitlab!129701))
- [Projects list: truncate project name](gitlab-org/gitlab@c5dba0cc8835f18816d50a419499e138ed560ec1) ([merge request](gitlab-org/gitlab!129783))
- [Fix "Convert to task" item showing in epics](gitlab-org/gitlab@4a13687459fe1de028a8a041860978a3146f5626) ([merge request](gitlab-org/gitlab!129792))
- [Reduce interference between Duo and discussion summary](gitlab-org/gitlab@397f9fec687649cbda77afe790f55baf2074fcae) ([merge request](gitlab-org/gitlab!129775)) **GitLab Enterprise Edition**
- [gitaly_client: Fix indeterministic cherry-picks and reverts](gitlab-org/gitlab@6ec50be52307190106b7a0e9fa471cee9e8fbddc) ([merge request](gitlab-org/gitlab!129776))
- [Fixes comma placement for codeowners](gitlab-org/gitlab@ad62a5b3060396a0c0d03c11482fedee74751873) ([merge request](gitlab-org/gitlab!129510)) **GitLab Enterprise Edition**
- [Fix exposing artifacts with dot slash paths](gitlab-org/gitlab@c5719429b6b3db2b145a5759d9b6eafd9e630fed) ([merge request](gitlab-org/gitlab!129740))
- [Fixes failed render when job stage data is missing](gitlab-org/gitlab@68fb18b7d13f9d76d541633b99390889710d2899) ([merge request](gitlab-org/gitlab!129716))
- [Only include branch name pipeline editor link](gitlab-org/gitlab@cfe3658a2fa2838af097b490fc9cc1b8ebdc1cbc) by @AaronDewes ([merge request](gitlab-org/gitlab!128565))
- [Fix deployment webhook for bridge job](gitlab-org/gitlab@51d3836aecca155d732bb760f8b0c35c92593d89) ([merge request](gitlab-org/gitlab!128717))
- [Support BigInt in front-end for dependency proxy size](gitlab-org/gitlab@7e97ba2e9906a991e58d6eedf0e74fbb43616aed) ([merge request](gitlab-org/gitlab!123121)) **GitLab Enterprise Edition**
- [Fix project listbox text not wrapping](gitlab-org/gitlab@3cbf604fca596b730d291585bb9c12555f4bce86) ([merge request](gitlab-org/gitlab!129672))
- [Update brand logo accessible name for screen readers](gitlab-org/gitlab@9dbd2720946ddc877a4f52a28176194d985c6932) ([merge request](gitlab-org/gitlab!129558))
- [Resync direct upload object stored artifacts](gitlab-org/gitlab@4b3d20362de3bb69db0b6a978c192b0adac85566) ([merge request](gitlab-org/gitlab!128939)) **GitLab Enterprise Edition**
- [Disable deleting approval rules from scan result policies](gitlab-org/gitlab@4d9cfdfae97e02d09d59de451481cc9d72958e65) ([merge request](gitlab-org/gitlab!129402)) **GitLab Enterprise Edition**
- [Fix page title on Compare revisions](gitlab-org/gitlab@3627e59d2627cc579ad974683bf7f0dc76a51856) ([merge request](gitlab-org/gitlab!129639))
- [Fix Microsoft Application enablement for SaaS](gitlab-org/gitlab@d58ad4802c7cc1a24f5b517afedb6e404cea385d) ([merge request](gitlab-org/gitlab!129496)) **GitLab Enterprise Edition**
- [Show iteration period in collapsed sidebar](gitlab-org/gitlab@ec68e22896f9cbc298cd671163eb3901843773bd) ([merge request](gitlab-org/gitlab!129232)) **GitLab Enterprise Edition**
- [Surface error when need name exceeds length](gitlab-org/gitlab@8f6db89f13213151a4f5b594613acaca591967c7) ([merge request](gitlab-org/gitlab!129326))
- [Add support for nuget normalized version](gitlab-org/gitlab@0b0d23a8d18edb8dc96a1ed67e240f038473a731) ([merge request](gitlab-org/gitlab!129113))

### Changed (224 changes)

- [Imports Bitbucket pull requests](gitlab-org/gitlab@5c61d1a158d1a14abe2e2a2a46e66f87b4d24977) ([merge request](gitlab-org/gitlab!131134))
- [GitLab Pages unique domain feature default enabled](gitlab-org/gitlab@ac199a03cfb46fae0ee7435bda99ebdcbb26a628) ([merge request](gitlab-org/gitlab!131055))
- [This MR migrates legacy dropdown](gitlab-org/gitlab@aa88d336d61dadddcb6874c2a3c9d6bd382697ff) ([merge request](gitlab-org/gitlab!131961)) **GitLab Enterprise Edition**
- [Prevent deletion of security policy bot members](gitlab-org/gitlab@6ecaa618a51d7e6a122b28fb6ca4908264976d22) ([merge request](gitlab-org/gitlab!132097)) **GitLab Enterprise Edition**
- [Work Item Quick Action: Set confidentiality](gitlab-org/gitlab@6b550ec37d1183e884f0689cfafca3ee44875070) ([merge request](gitlab-org/gitlab!129175))
- [Create service accounts as external in one query](gitlab-org/gitlab@92b94e2bfe60f21020fe41bd7fdf6a36bd0ef132) ([merge request](gitlab-org/gitlab!131675)) **GitLab Enterprise Edition**
- [Rely on disk_path for PoolRepository identification](gitlab-org/gitlab@84a1a3d1f9d434cf96e9d77ac3422077fea2eb76) ([merge request](gitlab-org/gitlab!131378))
- [Remove warning from security_and_compliance page](gitlab-org/gitlab@693be07af081685a3964fae86f73b4c15e4eadfa) ([merge request](gitlab-org/gitlab!132047)) **GitLab Enterprise Edition**
- [Update code creation template](gitlab-org/gitlab@eca9be99c0efb55b556b913217639d4e65b3a672) ([merge request](gitlab-org/gitlab!132028)) **GitLab Enterprise Edition**
- [Update Confidentiality Sidebar to Support Test Cases](gitlab-org/gitlab@d6d363c8589667b6dfc31067503add201b4203cf) ([merge request](gitlab-org/gitlab!131654))
- [Lower redundant pipelines lookup to 3 days](gitlab-org/gitlab@32af6154775615f0fe6d2a8465c57197df4d200e) ([merge request](gitlab-org/gitlab!131758))
- [Tweak active nav item with avatar styling](gitlab-org/gitlab@af2972484dbf401516128d73f7ee4c21261658fd) ([merge request](gitlab-org/gitlab!131798))
- [Add username in Web IDE new branch suggestion](gitlab-org/gitlab@7eb464a5a021a03eba3ad727436624d68749ac49) ([merge request](gitlab-org/gitlab!131972))
- [Salesforce login button text change](gitlab-org/gitlab@45f6956ab3b54e536aed40c42302a1b5c6b08bb9) ([merge request](gitlab-org/gitlab!131839))
- [Make actions optional for scan result policies](gitlab-org/gitlab@df8618a3804f21572f351c2b8b3b28dd7f96b77b) ([merge request](gitlab-org/gitlab!131692)) **GitLab Enterprise Edition**
- [Only include sbom_occurrences with CVS enabled](gitlab-org/gitlab@414ca683ddd7991fdbbbedac34b09ced26378bea) ([merge request](gitlab-org/gitlab!131454)) **GitLab Enterprise Edition**
- [Default prevent_visibility_restriction on and update docs](gitlab-org/gitlab@3a00cc7d73093c70673360be3af16cad365ccbf9) ([merge request](gitlab-org/gitlab!131203))
- [Default enable custom_roles_ui_[xxx] feature flags](gitlab-org/gitlab@a891380831741d16381202b4299c57e6e45d5ca0) ([merge request](gitlab-org/gitlab!131930)) **GitLab Enterprise Edition**
- [Default enable expiring member notifications](gitlab-org/gitlab@f7c4f1a67325c2e6bb5555c9dcba512d181c9f0e) ([merge request](gitlab-org/gitlab!131836))
- [Adds a new Danger check for renamed/dropped columns](gitlab-org/gitlab@1919b40bc7ec8df94f1007893396c57cc81c04e2) ([merge request](gitlab-org/gitlab!131078))
- [Add (un)subscribe quick actions to work items](gitlab-org/gitlab@eef1bb5d60ee91fb2f6d7ef2f2204087982479aa) ([merge request](gitlab-org/gitlab!131702))
- [Add PagesDeployment#deleted_at field](gitlab-org/gitlab@94b0969c02d78492104e05c029432582baf65017) ([merge request](gitlab-org/gitlab!130848))
- [Add username to push and pull mirroring form](gitlab-org/gitlab@48ecec39647364b36ad28ec63f67f40b6e816429) ([merge request](gitlab-org/gitlab!130334)) **GitLab Enterprise Edition**
- [This MR migrates legacy dropdown](gitlab-org/gitlab@314f469af3210b53f20abfc207d99f149f9858e9) ([merge request](gitlab-org/gitlab!131584)) **GitLab Enterprise Edition**
- [Synchronous index for `finding_id` to the `vulnerabilities` table](gitlab-org/gitlab@bdb1ed841e044149f32b1fd8030892c5c9d39962) ([merge request](gitlab-org/gitlab!131739)) **GitLab Enterprise Edition**
- [Clean up `write_project_authorizations_is_unique` feature flag](gitlab-org/gitlab@26efe595e9e25d7b7d4d901aa0b368ab2eb079d1) ([merge request](gitlab-org/gitlab!131866))
- [Add user preference to disable keyboard shortcuts](gitlab-org/gitlab@b0c982d181ab21c25217edfd2e26a2a60d578633) by @FromTheStackAndBack ([merge request](gitlab-org/gitlab!123581))
- [Add authorization on GET `project_import` endpoint](gitlab-org/gitlab@09ae7b0c73881c8659e10b7d87cf27ad52af424c) ([merge request](gitlab-org/gitlab!131573))
- [Enable admin_merge_request by default](gitlab-org/gitlab@3fb032214dbcbd42d1d622e9542bce4f857fadda) ([merge request](gitlab-org/gitlab!131833)) **GitLab Enterprise Edition**
- [Add language picker to trial registration page](gitlab-org/gitlab@cb2f2c369b9f9fff03b3d4c2a411a31ffb115434) ([merge request](gitlab-org/gitlab!127646)) **GitLab Enterprise Edition**
- [Update group and admin runners layout](gitlab-org/gitlab@b07a169d5afa9f6657ee8eb64b46862d84aea499) ([merge request](gitlab-org/gitlab!131687))
- [Update dependency auto-deploy-image to v2.56.0](gitlab-org/gitlab@9c2af2cdeb55840a9268d435d2cbcf455d9841b6) ([merge request](gitlab-org/gitlab!131781))
- [Move approval rules sync after security findings injestion](gitlab-org/gitlab@41f2a30c9881ad8aaf2352e5ad9792263fdb3d36) ([merge request](gitlab-org/gitlab!130685)) **GitLab Enterprise Edition**
- [Include grace period for SM add-on expiration](gitlab-org/gitlab@aa6b484921e78e283b8e7d5900457333e1de4e8d) ([merge request](gitlab-org/gitlab!131632)) **GitLab Enterprise Edition**
- [Disable license scanning job](gitlab-org/gitlab@16fb6fbb5f8367dc3fe9941a4abd4bd8dd8b2fd7) ([merge request](gitlab-org/gitlab!130962))
- [Stop creating summary when MR author submits a review](gitlab-org/gitlab@5553f31f8f09228ac12592540755d1dd74930239) ([merge request](gitlab-org/gitlab!131364)) **GitLab Enterprise Edition**
- [Move import and export settings to new section](gitlab-org/gitlab@972d3ede0fd5d8077ced752d605a1a3a7bdd16a4) ([merge request](gitlab-org/gitlab!129584))
- [This MR adds grouping to settings](gitlab-org/gitlab@028513bc0458f876d476ebfd0b4381332a15aaef) ([merge request](gitlab-org/gitlab!131409)) **GitLab Enterprise Edition**
- [Remove exact_matches_first_group_transfer feature flag](gitlab-org/gitlab@c5ef0d001ccdd03cc259a9fbf497dc33107b9afd) ([merge request](gitlab-org/gitlab!131703))
- [Update gpgme to v2.0.23](gitlab-org/gitlab@0647333c9a806f1110353449176af4ebd28218a9) ([merge request](gitlab-org/gitlab!131691))
- [Update job sidebar and layout](gitlab-org/gitlab@79521484e576926709deac38eca8ce30f1fda2aa) ([merge request](gitlab-org/gitlab!131303))
- [Finalize index on merge_requests.merged_commit_sha](gitlab-org/gitlab@b56125add69cf6e03011620e8e207c5bf3dce825) ([merge request](gitlab-org/gitlab!131682))
- [Prevent re-testing webhook logs with outdated URLs](gitlab-org/gitlab@ea5741cd3022031d25d169dddcdc50bdce8dfeca) ([merge request](gitlab-org/gitlab!131537))
- [Refactor experimental features toggle for non-AI features](gitlab-org/gitlab@d510cdb669b41f51165e3b8381e0c3eb8f6928e1) ([merge request](gitlab-org/gitlab!131666)) **GitLab Enterprise Edition**
- [Remove the FF npm_optimize_metadata_generation](gitlab-org/gitlab@6942e94babb9564bfaff16e4ba70544cd60086a7) ([merge request](gitlab-org/gitlab!131662))
- [Add purchased storage available breakdown card](gitlab-org/gitlab@2a6673fa0d7d8a045193d905fccbde60bf4e1965) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/129757)) **GitLab Enterprise Edition**
- [Add export for violation report](gitlab-org/gitlab@9fe2e57087865eb2fbead847b30f764832aa44e0) ([merge request](gitlab-org/gitlab!120636)) **GitLab Enterprise Edition**
- [Update dependencies action bar design](gitlab-org/gitlab@6c335e99f5d65ae1181aee2a4d7b4744e2a4a64a) ([merge request](gitlab-org/gitlab!131231)) **GitLab Enterprise Edition**
- [Add if active for SCIM](gitlab-org/gitlab@d7d01c612ebe69f2938773360a20848524aa429a) ([merge request](gitlab-org/gitlab!130988))
- [Update integrations development guidelines](gitlab-org/gitlab@46522f0825b28c7cc1bb13d6370dfffc66db5332) ([merge request](gitlab-org/gitlab!131544))
- [Update integrations' status types](gitlab-org/gitlab@664501cc9940c9d1be2bf571edf2341e9aaac52c) ([merge request](gitlab-org/gitlab!131373))
- [Release 1.week TTL for importer JobWaiter keys](gitlab-org/gitlab@642d681f1d09cf423fccb6d6ca9b2efb89b501cf) ([merge request](gitlab-org/gitlab!131582))
- [This MR adds new approval settings](gitlab-org/gitlab@5bf0b853b52fba8a23c6dc020be6bf7042ec1649) ([merge request](gitlab-org/gitlab!130880)) **GitLab Enterprise Edition**
- [Update spacing on CI variables table](gitlab-org/gitlab@3f32a89ef8d9142c41cf6f9bae422062c49a9f1e) ([merge request](gitlab-org/gitlab!131442))
- [Update trial column](gitlab-org/gitlab@5a567846fd3651837dd47bbb9dd211fd61bccf00) ([merge request](gitlab-org/gitlab!129369))
- [Introduce admin jobs refactor](gitlab-org/gitlab@0dabc794a420aa237381c22b598e35f17a9a3196) ([merge request](gitlab-org/gitlab!131190))
- [Ban users when spamcheck returns a BLOCK verdict](gitlab-org/gitlab@4c8a075cbf86adb94223f929a751320d5655435b) ([merge request](gitlab-org/gitlab!130676))
- [Update illustrations](gitlab-org/gitlab@3f66447730a67aec4f38c1badb1c03e028891e84) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131512))
- [Lock user for 15 mins after 3 failed login attempts](gitlab-org/gitlab@4c19ccd11d91dc29a4bc09790e04803202b47f38) ([merge request](gitlab-org/gitlab!131375))
- [Enable scan result policies to block changes to protected branches](gitlab-org/gitlab@33fffcbd6f12e784c32602c9e9bcef162aa3c2fc) ([merge request](gitlab-org/gitlab!130653)) **GitLab Enterprise Edition**
- [Update Illustrations](gitlab-org/gitlab@da614a7e2d0e0d5c04cae477b13129ce6e574c42) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131388))
- [Remove available on-demand badge from ODS when FIPS mode is enabled](gitlab-org/gitlab@9a28f33f9606fafb041dfb3a459b7c7893e6a85f) ([merge request](gitlab-org/gitlab!131137)) **GitLab Enterprise Edition**
- [Add toggle action to award emoji update mutation](gitlab-org/gitlab@b583346c13acdbd8760f45c74519bca97f03c55a) ([merge request](gitlab-org/gitlab!131434))
- [Return an unknown license from the JSON serializer](gitlab-org/gitlab@7a4b96943556f3333b3e1774a5e14ebaae0d6550) ([merge request](gitlab-org/gitlab!131081))
- [Use standard merge commit for merge trains](gitlab-org/gitlab@80620c376cc5e454b8d190a3a058113b9d61f0f8) ([merge request](gitlab-org/gitlab!131308))
- [Respect rebase and squash settings when creating merge train ref](gitlab-org/gitlab@a89d35df9bc3a65f7e6030d4cb90b5c536084590) ([merge request](gitlab-org/gitlab!131218))
- [Add Configurate button to integrations list view](gitlab-org/gitlab@e35f35bee718417e0e62cd7b37829aea9577a724) ([merge request](gitlab-org/gitlab!131262))
- [Update ProductAnalyticsDashboard type to CustomizableDashboard](gitlab-org/gitlab@a6aaeee73739a5919ea06c0bf1e53fe6d12b0014) ([merge request](gitlab-org/gitlab!130672))
- [Remove feature flag ci_commit_statuses_api_exclusive_lock](gitlab-org/gitlab@b4dadbdf6aa354ddbc2cc7a74085cec2e6684498) ([merge request](gitlab-org/gitlab!131385))
- [Enable streaming of audit events for protected environments](gitlab-org/gitlab@cf740fbc4a15d1a7727a64db7d4a0dbb04e2ee94) ([merge request](gitlab-org/gitlab!131245)) **GitLab Enterprise Edition**
- [Adding checkin reminder setting quick action](gitlab-org/gitlab@00593972431511f90b74ef13a10bb7c0fc668c04) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/130371)) **GitLab Enterprise Edition**
- [Update re2 gem to v2.0.0.beta2](gitlab-org/gitlab@8361dc2fe66fcd107aaae537c5e460eaf2d84f89) ([merge request](gitlab-org/gitlab!131273))
- [Pipelines: Migrate Artifacts dropdown](gitlab-org/gitlab@b87b73857a2ad9023ba2dcac2c90ac5aa504a12a) ([merge request](gitlab-org/gitlab!130458))
- [This MR adds option to provide custom values](gitlab-org/gitlab@b76c5c84f445c387abd72a3adb33d7076fdbcadf) ([merge request](gitlab-org/gitlab!131103)) **GitLab Enterprise Edition**
- [Hide work item meta data text in small screens](gitlab-org/gitlab@7f5f071de5bbe8157be156d17900b88bff8b1af6) ([merge request](gitlab-org/gitlab!130897))
- [Extend width of jobs tabs to 100%](gitlab-org/gitlab@dfd4112c99858af85049808e13782512919e7d40) ([merge request](gitlab-org/gitlab!131319))
- [Super sidebar: Lighten theme background color](gitlab-org/gitlab@2835817d398db7d97d686967b00e0cd79a1a56f7) ([merge request](gitlab-org/gitlab!129958))
- [Migrate protected branch edit dropdowns to vue](gitlab-org/gitlab@ee13bdc20776acc4599a37ae0836f91153587bce) by @ShaneMaglangit ([merge request](gitlab-org/gitlab!131275))
- [Migrate protected branch create dropdowns to vue](gitlab-org/gitlab@8fa31c96f9f349c1320d1c67bb81a302d7771879) by @ShaneMaglangit ([merge request](gitlab-org/gitlab!128575))
- [Removing feature flag ff_external_audit_events](gitlab-org/gitlab@76d54252df7f28480d4ee2f23326d997156acbdf) ([merge request](gitlab-org/gitlab!125512)) **GitLab Enterprise Edition**
- [Support for marking Gitsign certs as Unverified](gitlab-org/gitlab@19c14ef248327e65886c7d933aec79cdfe611b4a) by @ChevronTango ([merge request](gitlab-org/gitlab!121228))
- [Update job sidebar UI](gitlab-org/gitlab@c6c4c0291ef2ffe5bcb5e1057d11faf3be47c51d) ([merge request](gitlab-org/gitlab!130296))
- [Move labels.scss to page_bundles from page_specific_bundles](gitlab-org/gitlab@6f6c7aa407e7d606f0ed7e540e7cfab057c1d9cc) ([merge request](gitlab-org/gitlab!131024))
- [Remove tooltip from "Apply" button for suggestions](gitlab-org/gitlab@7731dbf9d1e881c9a334b35958016d7a138406af) ([merge request](gitlab-org/gitlab!130695))
- [This MR adds human readable strings](gitlab-org/gitlab@d523326fff2a6e9b637d6b0af78f45e44a921090) ([merge request](gitlab-org/gitlab!130190)) **GitLab Enterprise Edition**
- [Fix highlighted tab on compliance center page](gitlab-org/gitlab@4256e5fd6e05f64d0ce71f060149ce8f55f35144) ([merge request](gitlab-org/gitlab!130994)) **GitLab Enterprise Edition**
- [Update SAST auto-resolution comment to include link with more context](gitlab-org/gitlab@c22d981204491778f61b4827cafacdb2e839b634) ([merge request](gitlab-org/gitlab!130715)) **GitLab Enterprise Edition**
- [Add protected paths for get request](gitlab-org/gitlab@0dbb5bceadada8e0907423431fc487fb8d8e2004) by @zhanglinjie ([merge request](gitlab-org/gitlab!129774))
- [Add `user.id` to `explain_vulnerability` cache key](gitlab-org/gitlab@1e2f0538802284e715e85d4e0021e755aa6fca1b) ([merge request](gitlab-org/gitlab!130931)) **GitLab Enterprise Edition**
- [Pipeline Editor cleanup](gitlab-org/gitlab@f2ec3c6b758f7c7b990cf89b2d02e124249794bc) ([merge request](gitlab-org/gitlab!131010))
- [Make the BitBucket Cloud importer parallel](gitlab-org/gitlab@4f983b00d1d16343e537e0ec694dfc9ac2cc00ab) ([merge request](gitlab-org/gitlab!130731))
- [Add audit event for changed user profile visiblity](gitlab-org/gitlab@cd5bbd15387b5f5763699489488e03fb734e6107) ([merge request](gitlab-org/gitlab!129149)) **GitLab Enterprise Edition**
- [Use <nav> for root element in super sidebar](gitlab-org/gitlab@37da204f711365fa4c50372c567ad6c70e48e55c) ([merge request](gitlab-org/gitlab!130592))
- [Update dependency auto-build-image to v1.41.0](gitlab-org/gitlab@00e62169b1c843bf86a6d81c2904e66621903f87) ([merge request](gitlab-org/gitlab!131105))
- [Update vulnerability_states filter to match default value](gitlab-org/gitlab@cc6631008d8d3d0f43896b95812963723537651f) ([merge request](gitlab-org/gitlab!130552)) **GitLab Enterprise Edition**
- [Fix scan execution policy CI variables for pipelines](gitlab-org/gitlab@779f49fb35eb1288a94127d7c235fbd8847fbacf) ([merge request](gitlab-org/gitlab!130459)) **GitLab Enterprise Edition**
- [Update pipeline checking pipeline status tooltip](gitlab-org/gitlab@3795aa3b31a91e5154c965e15e86f2394da4093a) ([merge request](gitlab-org/gitlab!131089))
- [Update adherence_report_ui ff scope](gitlab-org/gitlab@5e6cbf632c81d67b30fc2673757d9b853e3225be) ([merge request](gitlab-org/gitlab!129532)) **GitLab Enterprise Edition**
- [Geo Sites Form - Use namespace full_name](gitlab-org/gitlab@a18306217fa80b85f95888028334b554395c0435) ([merge request](gitlab-org/gitlab!131060)) **GitLab Enterprise Edition**
- [Re-implement language switcher for registrations](gitlab-org/gitlab@93d30bee46c22d4c31267f8548eafa2a50717707) ([merge request](gitlab-org/gitlab!130349))
- [This MR adds new rule builder](gitlab-org/gitlab@4aa72d0fe7c39f4e410536aa79acf97d5f19c6e3) ([merge request](gitlab-org/gitlab!130131)) **GitLab Enterprise Edition**
- [Update vulnerability_reads trigger to set has_merge_request](gitlab-org/gitlab@464b1f3f744efe1cc2de4bfc10343f8adbe60ea6) ([merge request](gitlab-org/gitlab!130422))
- [Make License.feature_available? check for Registration Features](gitlab-org/gitlab@336c07de8efac0f16d644f09d524d684128985c3) ([merge request](gitlab-org/gitlab!130702))
- [Initialize the conversion for shared_runners_duration](gitlab-org/gitlab@697bdbdd2cf59232736f130dab34df0afd7bb29b) ([merge request](gitlab-org/gitlab!129573))
- [Remove min_access_level check](gitlab-org/gitlab@e1c6642cfa0c51654bb74ba2b298cb808d9f8e72) ([merge request](gitlab-org/gitlab!130933)) **GitLab Enterprise Edition**
- [Increase the string limits for regex fields in push_rules](gitlab-org/gitlab@119079813b25715b3a89a849d0315ca2567148a5) ([merge request](gitlab-org/gitlab!130394)) **GitLab Enterprise Edition**
- [Convert members.user_id to LFK](gitlab-org/gitlab@1ba854d59d29dd764da9bb1a890fe1ed5b60b2ab) ([merge request](gitlab-org/gitlab!130083))
- [Update show raw log icon button](gitlab-org/gitlab@ea5fddad65285ba75479cccd6bc2fd29d87575d9) ([merge request](gitlab-org/gitlab!130975))
- [Migrate to clipboard_button helper in commit box](gitlab-org/gitlab@5fe9f620b70589ef96fd8cb29cc2c40b078baed2) ([merge request](gitlab-org/gitlab!126591))
- [Standardize language and terminologies across pipelines](gitlab-org/gitlab@018d5a92f2241aebf7adaf4b4c17642b08fd6658) ([merge request](gitlab-org/gitlab!130570))
- [Enable group_level_dependencies by default](gitlab-org/gitlab@f7115e752aede80719819d33d7cbf804b02a6b65) ([merge request](gitlab-org/gitlab!129041)) **GitLab Enterprise Edition**
- [Disable on demand scans when in FIPS mode](gitlab-org/gitlab@fd97fcfe7e2fe39d5afb8811babde1e6fa2709a3) ([merge request](gitlab-org/gitlab!130744)) **GitLab Enterprise Edition**
- [Display Confidential Icon in Project Test Cases List](gitlab-org/gitlab@093f9771b331ce2d607800c8e646b83b64cec4bd) ([merge request](gitlab-org/gitlab!130770)) **GitLab Enterprise Edition**
- [Add exclusive lock to ensure only one pipeline is created](gitlab-org/gitlab@fbef757988e6dca678eb76a10d8663b893959d67) ([merge request](gitlab-org/gitlab!129164))
- [Ensure note id column swapping has finished for self managed](gitlab-org/gitlab@5e81ab34899faf8054d9cfa5cd443428e51d0bb4) ([merge request](gitlab-org/gitlab!127566))
- [Updating UI text](gitlab-org/gitlab@060ac5943d76f7ed6a3fe3e354c0bc1245807366) ([merge request](gitlab-org/gitlab!130872))
- [Add slot for externalAuthor](gitlab-org/gitlab@9d295bc39912a8221b6cf32f6dab03e0d50f24a6) ([merge request](gitlab-org/gitlab!130658))
- [Allow group maintainers to see group runner list](gitlab-org/gitlab@70defd1c5549af559e687823f47c4d9da99018da) ([merge request](gitlab-org/gitlab!130500))
- [Replacing AuditEventService with Gitlab::Audit::Auditor](gitlab-org/gitlab@85ed4daff8345b1a56af767ede4cc0c0e9cb4d65) by @TamsilAmani ([merge request](gitlab-org/gitlab!130699)) **GitLab Enterprise Edition**
- [Fixed user registration bug when no import sources selected](gitlab-org/gitlab@c738de6aeb901676ed54e899b25130eed6df821a) ([merge request](gitlab-org/gitlab!130861)) **GitLab Enterprise Edition**
- [Rename ambiguosly named settings in pinned section](gitlab-org/gitlab@d851d07db63ab4cdf6602493d17143ce80769db8) ([merge request](gitlab-org/gitlab!130840))
- [This MR migrates legacy dropdown](gitlab-org/gitlab@3a20ada3b01cc7d74998cefddb4c295277f1ec84) ([merge request](gitlab-org/gitlab!130543)) **GitLab Enterprise Edition**
- [UI polish on the webhook log page](gitlab-org/gitlab@648f04990582414337a20adaea80ea25780832b1) ([merge request](gitlab-org/gitlab!130427))
- [Remove the feature flag harbor_registry_integration](gitlab-org/gitlab@2638494e9042fbd5d263dd6d98d9cfae0213d02b) ([merge request](gitlab-org/gitlab!130536))
- [Enable fill_in_mr_template by default](gitlab-org/gitlab@0b3985b58b6e2c7860bf2cdee8cffd2820459e27) ([merge request](gitlab-org/gitlab!130808))
- [Enable automatically_summarize_mr_review by default](gitlab-org/gitlab@c9e7847169bb08200fa49d1b06bd55822eeb4f9a) ([merge request](gitlab-org/gitlab!130807)) **GitLab Enterprise Edition**
- [Clean up support_ci_environment_variables_in_job_rules feature flag](gitlab-org/gitlab@f315c3eb4aae88594e07657450cd4ce5ce310d0e) ([merge request](gitlab-org/gitlab!130804))
- [Adds a single ops feature flag to disable all database feature flags](gitlab-org/gitlab@2a1ba91a02ae4ed0d095b7eb9945fac332356b61) ([merge request](gitlab-org/gitlab!130554))
- [Add `finding_id` to the `vulnerabilities` table](gitlab-org/gitlab@56f9e0008335dbc86ec562066f6abba393b65428) ([merge request](gitlab-org/gitlab!130007)) **GitLab Enterprise Edition**
- [Allow personal access token authentication in Kubernetes proxy](gitlab-org/gitlab@6d489cad4551f9c88292204fc197601a0de06f42) ([merge request](gitlab-org/gitlab!130141))
- [Add diagonal tolerance when moving the mouse towards flyout menu](gitlab-org/gitlab@254c692f8a0b66344c58bac162bc4da4539da432) ([merge request](gitlab-org/gitlab!129107))
- [Use Pajamas compliant clipboard btn in doorkeeper](gitlab-org/gitlab@616b7827a5d4ae88a3d66cec7663ace1c2c50eea) ([merge request](gitlab-org/gitlab!130703))
- [Keep SAML Identity when deprovisioning via SCIM](gitlab-org/gitlab@4dd7a2b8150daeca09bbc515104727956dc76e0f) ([merge request](gitlab-org/gitlab!121226)) **GitLab Enterprise Edition**
- [Update gitlab-elasticsearch-indexer to 4.3.9](gitlab-org/gitlab@1db8268d57c874caedd2c3661bda2c468ee3e896) ([merge request](gitlab-org/gitlab!130670))
- [URL parsing and sanitizing logic added for Relay State](gitlab-org/gitlab@c92193f41c50f788d5ffb859adf82b8f2bb517a0) ([merge request](gitlab-org/gitlab!129710)) **GitLab Enterprise Edition**
- [Update job log page UI](gitlab-org/gitlab@80548d20248142a071cd1e4d974e9235b74cbbf6) ([merge request](gitlab-org/gitlab!130370))
- [Update validates_hostname gem](gitlab-org/gitlab@89dfe565a681eba301a72db8539c3810c84ed7fd) ([merge request](gitlab-org/gitlab!130448))
- [Migrate work_item_actions to GlDisclosureDropdown](gitlab-org/gitlab@a73abed8ed804f0d0c31379d99223fbfbc501acc) ([merge request](gitlab-org/gitlab!130016))
- [Delay display of pinning buttons in sidebar](gitlab-org/gitlab@4cf7a1435321bb269f0f2048576f84eceb9279fe) ([merge request](gitlab-org/gitlab!129834))
- [Migrate to PJ compliant button in merge_requests_helper](gitlab-org/gitlab@1f492518f36ebb41bf395caf12901bf232fbe831) ([merge request](gitlab-org/gitlab!130409))
- [Update gitlab-pages](gitlab-org/gitlab@b372d546c43f73fd93b90b1b6a3caabb3917c923) ([merge request](gitlab-org/gitlab!130581))
- [This MR migrates legacy dropdown](gitlab-org/gitlab@a3ccfac2ceba78b2a28d974081443c5669992618) ([merge request](gitlab-org/gitlab!130534)) **GitLab Enterprise Edition**
- [This MR migrates legacy dropdown](gitlab-org/gitlab@17183a8db7e122e0e42884be393175644cd80b50) ([merge request](gitlab-org/gitlab!130325)) **GitLab Enterprise Edition**
- [Backfill prometheus integrations into http_integrations table](gitlab-org/gitlab@bb166e7f1d27db7dc6f730089e3a8edbf660ae41) ([merge request](gitlab-org/gitlab!119847))
- [Add streaming capabilities for chat](gitlab-org/gitlab@19e000f59deb0313e29dff03387022012d9368ed) ([merge request](gitlab-org/gitlab!129966)) **GitLab Enterprise Edition**
- [Update job sidebar UI](gitlab-org/gitlab@43fe11e9f172c6a22e90c6f15b37abea8135476a) ([merge request](gitlab-org/gitlab!130220))
- [Add re-deploy button](gitlab-org/gitlab@de7b9f9b503ab9bf879b16d09770ec549e1729a8) ([merge request](gitlab-org/gitlab!130463))
- [Migrates dependency proxy header dropdown to disclosure](gitlab-org/gitlab@5fc7a077125e26fa8c0c4434e6f613372ecd3d4d) ([merge request](gitlab-org/gitlab!130491))
- [Update user list component error message](gitlab-org/gitlab@efedf36af2ac203dff97a4d348989116904aa0a7) ([merge request](gitlab-org/gitlab!130486))
- [Fix scan policies count to security_orchestration_helper](gitlab-org/gitlab@19c39d3dacc8ca709b161b89fa40c2fe842e5a5e) ([merge request](gitlab-org/gitlab!130464)) **GitLab Enterprise Edition**
- [Migrate test report widget to V2](gitlab-org/gitlab@917bb32c46d4da29dd2104b3328103cf8684128a) ([merge request](gitlab-org/gitlab!127252))
- [Allow guest user seat assignment](gitlab-org/gitlab@819ca2fca66eb2f1dfeffbcbaae6ae72678f7865) ([merge request](gitlab-org/gitlab!130446)) **GitLab Enterprise Edition**
- [Updates component fetching](gitlab-org/gitlab@e0f0304218eaadfd567a2c5ef325db71a1e4205d) ([merge request](gitlab-org/gitlab!130214))
- [Migrate work_item_links_menu to GlDisclosureDropdown](gitlab-org/gitlab@87559a8d7776d3a2dd520eabae234488cbefd8a8) ([merge request](gitlab-org/gitlab!130307))
- [Improve Docker-in-Docker troubleshooting documentation](gitlab-org/gitlab@801a5df75c4d9d508c708108cb3182d61c4dcee2) ([merge request](gitlab-org/gitlab!129649))
- [Migrates packages shared cli-commands dropdown to disclosure](gitlab-org/gitlab@c0067830da0df38d32d2a26ea051c9ddf05faeb4) ([merge request](gitlab-org/gitlab!128917))
- [Use Pajamas button component for Mattermost](gitlab-org/gitlab@351fe4609b23869fcbec701debfac11dc1df8ead) ([merge request](gitlab-org/gitlab!130393))
- [Convert notification_settings.user_id to LFK](gitlab-org/gitlab@12c1e68d813c44e33f3b45b9d593b37aaed188d6) ([merge request](gitlab-org/gitlab!130080))
- [Remove seats_in_use_for_free_or_trial flag](gitlab-org/gitlab@0a0be1460abbbddea6ae61cf1fcc89ccdf7daa2d) ([merge request](gitlab-org/gitlab!130383)) **GitLab Enterprise Edition**
- [This MR migrates legacy dropdown](gitlab-org/gitlab@42c70f2fb16d2d4d3d87ac1d2169eabcdde4da12) ([merge request](gitlab-org/gitlab!129968)) **GitLab Enterprise Edition**
- [Add name to GCP logging streaming destinations](gitlab-org/gitlab@cd1ae39a36363789a51f18e0a394c4758df5f8a2) ([merge request](gitlab-org/gitlab!128313)) **GitLab Enterprise Edition**
- [This MR migrates legacy dropdown](gitlab-org/gitlab@85f4af9dd21410e0b661fb42b442a3abb2d00979) ([merge request](gitlab-org/gitlab!130066))
- [Cached project-based ETAG lookup for GitHub email for a user](gitlab-org/gitlab@5e782f10d213ebf821b49330bbdc1485ed701e77) ([merge request](gitlab-org/gitlab!129836))
- [Use new ci badge link on last commit section](gitlab-org/gitlab@28239629e4438bfbeaad0b0cdb10a4aeb2022671) ([merge request](gitlab-org/gitlab!130227))
- [Add Confidential Attribute to CreateTestCase Mutation](gitlab-org/gitlab@e16bf79e1f1c9c474a59099cc13e12cac308851c) ([merge request](gitlab-org/gitlab!129871)) **GitLab Enterprise Edition**
- [Update button variant to newer options](gitlab-org/gitlab@3224961ea43d248020e2a202fcf4aca4cb17d00b) ([merge request](gitlab-org/gitlab!130341))
- [Use browser language setting for registration flows](gitlab-org/gitlab@7ea3ad7098d9f3a73f574c0ad636e296b355369d) ([merge request](gitlab-org/gitlab!129651))
- [Pipeline: Change label for triggerer](gitlab-org/gitlab@a41198b71a714b784e4cd2ad8821bcc1670eb7f3) ([merge request](gitlab-org/gitlab!130290))
- [Update dependency auto-deploy-image to v2.55.0](gitlab-org/gitlab@8dfe9179474f72f93a8be9898bd86f6b494c9221) ([merge request](gitlab-org/gitlab!130279))
- [Expose config option to show swagger operationId](gitlab-org/gitlab@cee8a617a3b6e5657c5bc75316a498a65316fa8c) ([merge request](gitlab-org/gitlab!129788))
- [Use Pajamas compliant clipboard button](gitlab-org/gitlab@d59c774154f3f8a2796f8ac49a01fa9feaf2fef3) ([merge request](gitlab-org/gitlab!130266))
- [Enable Sidekiq JSON logging by default](gitlab-org/gitlab@b36ee8c9f1f768330c0aab8a35d879ac722c5e05) ([merge request](gitlab-org/gitlab!120668))
- [feat: Add new filter option `runner_type` to jobs page in admin area](gitlab-org/gitlab@5d49e976fbf72c71c3d6e5d8faf9a917fbe97a64) by @gerardo-navarro ([merge request](gitlab-org/gitlab!123131))
- [Move job sidebar buttons to header](gitlab-org/gitlab@b80e2f63df75e75785de09ddd77a79c8387ef718) ([merge request](gitlab-org/gitlab!130100))
- [Use lighter gray for failed jobs toggle](gitlab-org/gitlab@0e89e444e31c96f0b2cf403164d65b4cd1f655b2) ([merge request](gitlab-org/gitlab!130223))
- [Jobs list: Change created by](gitlab-org/gitlab@ec51217883bc50d5735f28e85a8f9b7b3d2aaf44) ([merge request](gitlab-org/gitlab!130201))
- [Use Action Cable to update notes in real-time](gitlab-org/gitlab@f2efd620ef582497fc58583ffaa612f2156bc891) ([merge request](gitlab-org/gitlab!129095))
- [Pipelines Pagination spacing](gitlab-org/gitlab@394bebc2767ad2b854f2efaa3eed037183b6f7f6) ([merge request](gitlab-org/gitlab!130198))
- [Convert routes.namespace_id to LFK](gitlab-org/gitlab@af9fd0163475708c40c82b76a1eb6bec6462615d) ([merge request](gitlab-org/gitlab!130096))
- [Quarantined flaky invite feature spec becuase of broken master](gitlab-org/gitlab@72cf761b5162d302d337b9699a6eaba1bd84e678) ([merge request](gitlab-org/gitlab!130167))
- [Make search button in navigation more prominent](gitlab-org/gitlab@ae2e3d144ad95db16ec4d4783ca1f179e52c4692) by @deep-swaraj ([merge request](gitlab-org/gitlab!127935))
- [Enable geo_proxy_lfs_batch_requests by default](gitlab-org/gitlab@b3f97997cc741c9d1a111d3acb2e00c3c9d0b8e7) ([merge request](gitlab-org/gitlab!130115)) **GitLab Enterprise Edition**
- [Update top-bar on new project/group pages to be fixed to top of viewport](gitlab-org/gitlab@82904c4295cb2ff379a8eb703ac51b551b5df5b3) ([merge request](gitlab-org/gitlab!129574))
- [Remove unneeded template options, handle nil prompt situation](gitlab-org/gitlab@1033f17884b40b0c838ad53a79ef43a28767f469) ([merge request](gitlab-org/gitlab!129372)) **GitLab Enterprise Edition**
- [Set merge_request_refs_cleanup default_enabled: true](gitlab-org/gitlab@9439cea7e839e7d81ea2205c20cec13bbb985169) ([merge request](gitlab-org/gitlab!130098))
- [Updates error message and documentation for interpolator](gitlab-org/gitlab@b118e364782667d01c3d3677ce4f48529510b493) ([merge request](gitlab-org/gitlab!129239))
- [Migrate security_report_download_dropdown to GlDisclosureDropdown](gitlab-org/gitlab@92d929318e4772b3f2af172ce1de334385272390) ([merge request](gitlab-org/gitlab!130034)) **GitLab Enterprise Edition**
- [Remove summarize_diff_vertex feature flag](gitlab-org/gitlab@0da25696e22a830941598c117a63105fffd15ab3) ([merge request](gitlab-org/gitlab!130029)) **GitLab Enterprise Edition**
- [Refactor inline-findings Drawer](gitlab-org/gitlab@0df54d8e830dd6839d37cec148fcbe934a74a158) ([merge request](gitlab-org/gitlab!128798)) **GitLab Enterprise Edition**
- [This MR migrates legacy dropdown](gitlab-org/gitlab@fd3fec4830b2127d4d0e0060583bede5bc64caf3) ([merge request](gitlab-org/gitlab!129955)) **GitLab Enterprise Edition**
- [Enable `unbatch_graphql_queries` feature flag globally](gitlab-org/gitlab@3e4a771178ef53870abc8b7d708bb380480d902c) ([merge request](gitlab-org/gitlab!129926))
- [Update ruby_parser to v3.20.3](gitlab-org/gitlab@2be0d3c49e4ded5d4ffaaf7417923bd0e2e4aa07) ([merge request](gitlab-org/gitlab!129947))
- [This MR migrates legacy dropdown](gitlab-org/gitlab@4e53933d53cfa152aae0116f7b7376b3a8c97069) ([merge request](gitlab-org/gitlab!129940)) **GitLab Enterprise Edition**
- [Add limit for group count within namespaces](gitlab-org/gitlab@4f81cf8915069d10fbcd9dc254004eee03ff29e9) ([merge request](gitlab-org/gitlab!129260)) **GitLab Enterprise Edition**
- [Use SSH URL in composer metadata source entry for non-public projects](gitlab-org/gitlab@224dca09c98a1174c2fa50d630645eb55f582431) by @nickygerritsen ([merge request](gitlab-org/gitlab!119739))
- [Add optional client_subscription_id](gitlab-org/gitlab@37252ebee63bd827bec75a4b370ad070e8d021b9) ([merge request](gitlab-org/gitlab!129521)) **GitLab Enterprise Edition**
- [Enable emoji_webhooks feature flag by default](gitlab-org/gitlab@b241017131a40ad01a286987b3c5c6cbced8ec38) ([merge request](gitlab-org/gitlab!128861))
- [Respect merge method and squash preferences for merge train ref](gitlab-org/gitlab@8c93feeb66d43e167e9470fa580899633b97d8fe) ([merge request](gitlab-org/gitlab!129660))
- [Update premium and ultimate titles in plans table](gitlab-org/gitlab@2188775b25cf162fa199d28e7d6de5005746fc61) ([merge request](gitlab-org/gitlab!129419))
- [Add protected branch warning](gitlab-org/gitlab@b6e212cf03dcab40265080fb39c7f4181b13f10e) ([merge request](gitlab-org/gitlab!129508))
- [Migrate protected tag dropdowns to vue](gitlab-org/gitlab@c5fe064004838afed0a8093403a16bcf4ebbd431) by @ShaneMaglangit ([merge request](gitlab-org/gitlab!126649))
- [Migrate pagination bar dropdown to disclosure](gitlab-org/gitlab@43f85f0ed0eb8cf6447e6aa2dcc66a0cec05b57e) by @ShaneMaglangit ([merge request](gitlab-org/gitlab!129490))
- [Update dependency auto-build-image to v1.40.0](gitlab-org/gitlab@5abfd0ba677bc9f8ddc05fe756a342f0670db4c3) ([merge request](gitlab-org/gitlab!129805))
- [Prevent name collision between migrations](gitlab-org/gitlab@57e0c1911fe9de0edd1047ce8b7532429248de50) ([merge request](gitlab-org/gitlab!129012))
- [Change default theme to light gray](gitlab-org/gitlab@1a7decc4796ca30a586fd11265205c8156e25dac) ([merge request](gitlab-org/gitlab!129479))
- [Migrate to GlCollapsibleListbox in work_item_activity_sort_filter](gitlab-org/gitlab@7724db432be0f0d14f33a3db1f400e1b995d805c) ([merge request](gitlab-org/gitlab!128968))
- [Sidebar navigation: Change badge background](gitlab-org/gitlab@fc4bfb1bbf5d9fcc7a1324bfd29b57132bee8155) ([merge request](gitlab-org/gitlab!129782))
- [Introduce schedules refactor](gitlab-org/gitlab@2571a51dd4f21997e8bd8bb5f8576e1e3b795b9d) ([merge request](gitlab-org/gitlab!128913))
- [Implement explain vuln anthropic, use vertex by default](gitlab-org/gitlab@38cd4dfdbae91f62906a65ad5fbb4f96a0c2759a) ([merge request](gitlab-org/gitlab!128118)) **GitLab Enterprise Edition**
- [Update dependency auto-build-image to v1.39.0](gitlab-org/gitlab@4e290c07b9db51a2af8c614c6f0b38fc5689bda0) ([merge request](gitlab-org/gitlab!129732))
- [Add PagesDomain#certificate_key length validation](gitlab-org/gitlab@fb0fa0171735138df50dce5c86ab99ea733a9cc0) ([merge request](gitlab-org/gitlab!129294))
- [Include double colon inside the translation](gitlab-org/gitlab@7581ecd164c05a74758f70a994f5123efcae750c) ([merge request](gitlab-org/gitlab!129581)) **GitLab Enterprise Edition**
- [Remove FF search_projects_hide_archived](gitlab-org/gitlab@39484e841d609dda4575d9e52188b824b259df28) ([merge request](gitlab-org/gitlab!129386))
- [Access tokens - show token name in delete copy](gitlab-org/gitlab@b4e801f6af7f2936a8f2d611cd2e269b75227df7) by @zarthus ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/129529))
- [Updated feedback URL](gitlab-org/gitlab@085a74e14ecb5a3ba9954418d920d6415d0a384b) ([merge request](gitlab-org/gitlab!129645)) **GitLab Enterprise Edition**
- [Update placeholder in GitLab Duo text input](gitlab-org/gitlab@9536cec275e7364f9965252a6d0a3b5f8e8c1966) ([merge request](gitlab-org/gitlab!129577)) **GitLab Enterprise Edition**
- [Set max widths on project repository settings inputs](gitlab-org/gitlab@d85a65cd2d294d9227ba6c2a66dea2cd420a4195) ([merge request](gitlab-org/gitlab!129535))
- [Disable feature flag using v1 package metadata sync](gitlab-org/gitlab@560e5c27abdcc3dd3deb8af930eaa1e68b089d1c) ([merge request](gitlab-org/gitlab!129405)) **GitLab Enterprise Edition**
- [Add job status badges to runners list](gitlab-org/gitlab@0be41cc8f72fa44fa19f658565627164014a8a2a) ([merge request](gitlab-org/gitlab!129374))
- [Remove legacy plan reference from plan presenter](gitlab-org/gitlab@3efb275f03316b1b5ac629b69cc483995ed4e280) ([merge request](gitlab-org/gitlab!129309)) **GitLab Enterprise Edition**
- [Sync validate foreign key for pipeline_id_convert_to_bigint](gitlab-org/gitlab@2c8616aec41ac2173bb555ae20941b30d63f66b7) ([merge request](gitlab-org/gitlab!129199))
- [Update hex values](gitlab-org/gitlab@0c3d59381f6a486b5f731bf1a14f05da64d3e9cb) ([merge request](gitlab-org/gitlab!129128))
- [Update dependency auto-deploy-image to v2.54.0](gitlab-org/gitlab@2323fdecdd1e7e8937f93b820df7b036793c61a2) ([merge request](gitlab-org/gitlab!129051))
- [Rollout advanced_search_decrease_indexing_timeout](gitlab-org/gitlab@3ea173d0369c5de411b2ffb40b4f757e5cdf86e5) ([merge request](gitlab-org/gitlab!126685)) **GitLab Enterprise Edition**

### Deprecated (4 changes)

- [Make BuildSuccessWorker no-op](gitlab-org/gitlab@892a6c4af8a201938402ab5f5b18276fbbcc9275) ([merge request](gitlab-org/gitlab!131717))
- [Redirect legacy /admin/geo/replication/projects route](gitlab-org/gitlab@ce4a9f4b947b807a4a08d7b68cb44b707bb15f1b) ([merge request](gitlab-org/gitlab!130737)) **GitLab Enterprise Edition**
- [Mark unused jitsu-related columns as ignored](gitlab-org/gitlab@0b94f3753120f0c27f091ef12018ceba7f092f55) ([merge request](gitlab-org/gitlab!130669))
- [Deprecate rake gitlab:list_repos](gitlab-org/gitlab@c90d7997059004fdebd46a6d8f81185a0ae0d95f) ([merge request](gitlab-org/gitlab!129435))

### Removed (23 changes)

- [Remove cache_pages_domain_api feature flag](gitlab-org/gitlab@c91ee59e327b3e9dc5e34922f84f37ab43f65263) ([merge request](gitlab-org/gitlab!131767))
- [Drop unused design_registry table](gitlab-org/gitlab@1c22a309469b0db3bbadf7408f3d2a6acb711b3b) ([merge request](gitlab-org/gitlab!126132)) **GitLab Enterprise Edition**
- [Remove tasks to be done from onboarding and invite emails](gitlab-org/gitlab@1572f7b26710020fd0dedebc8f745b31b8293ca8) ([merge request](gitlab-org/gitlab!131640))
- [Remove module github.com/grpc-ecosystem/go-grpc-middleware](gitlab-org/gitlab@95eb473fd5fea9994a28ff98691a0c0061513def) ([merge request](gitlab-org/gitlab!130646))
- [Remove artifacts page feedback banner](gitlab-org/gitlab@c78a6e211109623a3c31551d722003c75da48e9a) ([merge request](gitlab-org/gitlab!131314))
- [Remove feature flag explain_current_blob](gitlab-org/gitlab@74a8f045dcdc8aa6cef5169ec36b837f9922d2ff) ([merge request](gitlab-org/gitlab!131119))
- [Remove legacy BitBucket Server importer](gitlab-org/gitlab@a8c4a5b875179bfea1c8253bb0096be4e73ab4a2) ([merge request](gitlab-org/gitlab!121614))
- [Cleanup feature flag security_policy_approval_notification](gitlab-org/gitlab@2b7049ce9b5b50e26c318789d7736ed78d9cee32) ([merge request](gitlab-org/gitlab!130827)) **GitLab Enterprise Edition**
- [Remove :group_mentions feature flag](gitlab-org/gitlab@00eb8bfff2b5cbd8f9da9e31d4320adfb449d0e0) ([merge request](gitlab-org/gitlab!130761))
- [Remove deprecated wiki status data from Geo Sites Status API](gitlab-org/gitlab@6f8ba9a110f923fa4b15bcabc396d37892c7112b) ([merge request](gitlab-org/gitlab!130376)) **GitLab Enterprise Edition**
- [Clean up project callout three](gitlab-org/gitlab@6ad7fdae352392d0c30d88065df58111f2bb497f) ([merge request](gitlab-org/gitlab!129924))
- [Remove CTE backward compatibility code](gitlab-org/gitlab@3d4141b9ef9376d368e26eefc642b6785f5e3cea) ([merge request](gitlab-org/gitlab!130142))
- [Remove unused namespace details columns for free user cap](gitlab-org/gitlab@297858d768eff9cb8e6394440524211df9995dd5) ([merge request](gitlab-org/gitlab!130575))
- [Remove free user cap email notification workers](gitlab-org/gitlab@07c69c056c6ce1bc0c14737ad9002e06513228da) ([merge request](gitlab-org/gitlab!129957)) **GitLab Enterprise Edition**
- [Remove dashboard_notification_limit column](gitlab-org/gitlab@ad0e7b939b660cbf5045137818c906006175e759) ([merge request](gitlab-org/gitlab!129247))
- [Remove tmp_idx_vuln_reads_where_dismissal_reason_null index](gitlab-org/gitlab@6398411c6869588f285f3c492b1cb3a85f7f6646) ([merge request](gitlab-org/gitlab!129943))
- [Remove summarize_review_vertex feature flag](gitlab-org/gitlab@6e42692f25b411151ff0e95ce67411a920bb057f) ([merge request](gitlab-org/gitlab!129994))
- [Remove Ultimate feature removal banner](gitlab-org/gitlab@73d1163074964aaea380f63c7c237d85ada25433) ([merge request](gitlab-org/gitlab!129703))
- [Remove batched_api_mergeability_checks FF](gitlab-org/gitlab@91218f9db020894dbe5c549234e21c74b00d5456) ([merge request](gitlab-org/gitlab!129817))
- [Remove role required before action](gitlab-org/gitlab@7cfac1cd5f8ef5e3b7d786ba53651416330a0463) ([merge request](gitlab-org/gitlab!129519))
- [Clean-up registration_verification feature flag](gitlab-org/gitlab@737849d0c646f49314490d99e94558bf9beda2b0) ([merge request](gitlab-org/gitlab!129270))
- [Perform step 2 in removal of unused dashboard columns](gitlab-org/gitlab@d54fa9f6655eb1fd9a3f06c01ac0f5406cc98a2f) ([merge request](gitlab-org/gitlab!128808))
- [Remove code_suggestions_third_party_alert](gitlab-org/gitlab@9438be66ce345f4f470bbfa9825019a1de791000) ([merge request](gitlab-org/gitlab!129022)) **GitLab Enterprise Edition**

### Security (17 changes)

- [Enforce that the policy is executed by the bot user](gitlab-org/gitlab@8c147032d09ed81f3f6edffea95a7e9ca0c7abaf)
- [Bump query number on spec](gitlab-org/gitlab@a4e7fcf5d6d86085255b1853f6a0f526213e1d1d)
- [Update commonmarker to 0.23.10](gitlab-org/gitlab@66f183effce3845f6577cd88fab1d8c4b7f77253)
- [Service account users should be external by default](gitlab-org/gitlab@b0823a015e18848e83ac3c07e2a5cd412d57f6f7)
- [Prevent namespace level banned users from accessing API](gitlab-org/gitlab@34bfa7149434065bc24bff5817b0d382409f90a3)
- [Additional permission check when editing label](gitlab-org/gitlab@36861497d37346620ba895f228bc4fed48119ca6)
- [Remove DAST secret variables when URL is updated](gitlab-org/gitlab@f3a25970427ca0bf747b9262650744b895bb9e5b)
- [Fix ReDOS in bulk_imports endpoint params](gitlab-org/gitlab@52d3a6748d3229e509a01ee03191e687bf0ad485)
- [Add authorization checks to import status endpoint](gitlab-org/gitlab@9309617c889769234ae18becaf92270fab483b57)
- [Maintainer can leak sentry token by changing the configured URL](gitlab-org/gitlab@f3ad4451e8806c42dfa48ff94ac53f7dc9345f4e)
- [Check prohibit_outer_forks in fork relationship api](gitlab-org/gitlab@aefa8cdfe500cadf478d11b3f429b88b11d2fbbc)
- [Remove channel properties from API when channels are masked](gitlab-org/gitlab@902aaf4b412dc61a165b588611885cd60afb7a69) by @Taucher2003 ([merge request](gitlab-org/gitlab!129497))
- [Prevent traversal for `path` parameter in refs/switch endpoint](gitlab-org/gitlab@11646795118a010c9a58d9e44bcad9e1beb33286)
- [Requires write_model_experiments on mlflow api](gitlab-org/gitlab@b393f167bce7a2ec19a493105786eb55cd3b01b9)
- [Remove GCP private key from streaming audit events UI](gitlab-org/gitlab@33caa14b879e04b48eee59467f29e730da2a797c)
- [Gitaly keyset pager when pagination none only with tree view](gitlab-org/gitlab@63716e9d4e2d352e7b35ac0a5a01f96e242840b8)
- [Prefix agent tokens with `glagent-`](gitlab-org/gitlab@341ff3297859db0354a0fc581ec8fcb607f64084) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/129778))

### Performance (10 changes)

- [Cache security policy YAML](gitlab-org/gitlab@bd5355fa5d3e983cf1b30fe57bf4facbdf4dee6d) ([merge request](gitlab-org/gitlab!131384)) **GitLab Enterprise Edition**
- [Fix performance problem with Projects#new page](gitlab-org/gitlab@0951c67209d65c8e211b0a8bcaaa1bfca0f834f6) ([merge request](gitlab-org/gitlab!131869)) **GitLab Enterprise Edition**
- [Optimize regexp matching](gitlab-org/gitlab@39baff89e1daf2cb518f00c1690299f113d1c63a) ([merge request](gitlab-org/gitlab!131633)) **GitLab Enterprise Edition**
- [Drop index_deployments_on_id_where_cluster_id_present](gitlab-org/gitlab@34cf440a44ec01c0bc6b410dc96b66aefb3484b2) ([merge request](gitlab-org/gitlab!130831))
- [Fix long sleeps removing load balancing hosts](gitlab-org/gitlab@084868ff5d6cc9276ad9078f0014cdae57b9ae13) ([merge request](gitlab-org/gitlab!130432))
- [Drop an index from the deployments table](gitlab-org/gitlab@1474d5f8e892d1a9832ceec83b62d9124be2e093) ([merge request](gitlab-org/gitlab!130853))
- [Improve rich viewer frontend rendering](gitlab-org/gitlab@0b79d3c21e9e88537317d93429fe7e581c352d24) ([merge request](gitlab-org/gitlab!127467))
- [Remove an index on deployments table async-ly](gitlab-org/gitlab@7abdff9fbaa636ea2759319abf775552b581e770) ([merge request](gitlab-org/gitlab!129673))
- [Drop index_deployments_on_id_where_cluster_id_present async-ly](gitlab-org/gitlab@c0f6018dde4275babc90686351f6797d5dbaac93) ([merge request](gitlab-org/gitlab!129676))
- [Remove duplicate empty state check](gitlab-org/gitlab@aa049b823157c5601670182d0d16c555b675006a) ([merge request](gitlab-org/gitlab!129136))

### Other (76 changes)

- [Restart sent_notifications column swap for self-installed](gitlab-org/gitlab@7a5badc0c9f521f872cf22d11beeeb9fba584a76) ([merge request](gitlab-org/gitlab!126763))
- [Skips disconnecting old hosts when there is no need](gitlab-org/gitlab@f690af289467bd72273d5c4fd8b7f8478d20af21) ([merge request](gitlab-org/gitlab!132002))
- [Use partitioned table on CommitStatus](gitlab-org/gitlab@61de26b68de4209b8bd208ad7bf387e528476db8) ([merge request](gitlab-org/gitlab!129812))
- [Set minimum pipeline batch size in RedisCacheStore](gitlab-org/gitlab@893eff3530fc3144e11aab58aab597da2605e093) ([merge request](gitlab-org/gitlab!131470))
- [Remove .and_call_original as redundant](gitlab-org/gitlab@615d1fd4cd1b2be4d88d184d4651f423e0aa4397) ([merge request](gitlab-org/gitlab!131901)) **GitLab Enterprise Edition**
- [Create the sync migration of the prepared_at created_at index removal](gitlab-org/gitlab@f4acef480da3d387880613ae3c63a6259320cce7) ([merge request](gitlab-org/gitlab!131631))
- [Create the sync migration of the prepared_at created_at index addition](gitlab-org/gitlab@3f3062e1744e581e249ab5ae35491187275e291d) ([merge request](gitlab-org/gitlab!131629))
- [List related work items in the work item relationship widget](gitlab-org/gitlab@50142052804c7f54a5473e7988adc1766d4cce17) ([merge request](gitlab-org/gitlab!130194)) **GitLab Enterprise Edition**
- [Add sync index on `projects.organization_id`](gitlab-org/gitlab@2fbe793eebafcf073dc55fede860dd44d05ac53e) ([merge request](gitlab-org/gitlab!131635))
- [Remove feature flag introduce_ci_max_total_yaml_size_bytes](gitlab-org/gitlab@4f9daaaca13b7138fdd3a6af942ebf04008713b5) ([merge request](gitlab-org/gitlab!131397))
- [Backfill has_merge_request on existing vulnerability_reads records](gitlab-org/gitlab@fe25bbdd71b96ff1d59821d05e4c43f14274d50f) ([merge request](gitlab-org/gitlab!130952))
- [Include the issues in advanced project search on archived project](gitlab-org/gitlab@bec041a60c948681fbc776cc1ce7e777facc708f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131500)) **GitLab Enterprise Edition**
- [Include merge requests in advanced project search on archived project](gitlab-org/gitlab@cd8de07eb0a2810fd3e7cddd720af0e07033071a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131505)) **GitLab Enterprise Edition**
- [Manually analyze partitioned tables](gitlab-org/gitlab@aa052046d8fc35bbbe5683ac7802431788b35d96) ([merge request](gitlab-org/gitlab!131056))
- [Remove compressed_package_metadata_query flag](gitlab-org/gitlab@81017f878fc98f4207e0e4bb0dafd0ea5027a18f) ([merge request](gitlab-org/gitlab!130976)) **GitLab Enterprise Edition**
- [Added --location note to job artifacts api docs](gitlab-org/gitlab@613e0f4a04d302b55702240943cef2bba673e3d9) by @zillemarco ([merge request](gitlab-org/gitlab!131379))
- [Prepare async index on file_final_path](gitlab-org/gitlab@70b2b76ecb4a878096cf204b04f14d5d984c2012) ([merge request](gitlab-org/gitlab!130723))
- [Poll dual namespace for sidekiq by default](gitlab-org/gitlab@4a7fd195fe507f54294b1d152803b7feb9d6e3fa) ([merge request](gitlab-org/gitlab!131478))
- [Remove commits documents from the main index](gitlab-org/gitlab@c67afdcf062e3b65712296e45dadc87334618bc9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/130197)) **GitLab Enterprise Edition**
- [Simplify gitlab container repository delete tags services](gitlab-org/gitlab@17ce367cfb4eae6656477cea46ec5334461105c6) by @edith007 ([merge request](gitlab-org/gitlab!81183))
- [Move Full stop period out of "Learn More" link](gitlab-org/gitlab@c03036f8f68dd309b000cfd197bdc36ecb773ac2) by @jrachelr1 ([merge request](gitlab-org/gitlab!130968)) **GitLab Enterprise Edition**
- [Remove search_index_integrity feature flag](gitlab-org/gitlab@b4e850b5f282efb257a5b14969aeedf7c341976a) ([merge request](gitlab-org/gitlab!131192)) **GitLab Enterprise Edition**
- [Remove command_palette feature flag](gitlab-org/gitlab@4d1010aa02963255a496e9960bd664f316cd10f3) ([merge request](gitlab-org/gitlab!130910))
- [Add histogram for Redis pipeline size](gitlab-org/gitlab@3b93a01d96440abc634e20e7ddb5729a7e64221c) ([merge request](gitlab-org/gitlab!131018))
- [Create a Work items relationship widget shell](gitlab-org/gitlab@6174c21c587c6273041572d734e4108da3c7027f) ([merge request](gitlab-org/gitlab!130456))
- [Add a migration to force commit reindex some projects](gitlab-org/gitlab@bcfb466745429b5e8ad19985f21069077fdb91b0) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/130718)) **GitLab Enterprise Edition**
- [Write a migration to backfill archived on milestones](gitlab-org/gitlab@ba6387af32a059f663acc82f93bc21249ceceabe) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/130639)) **GitLab Enterprise Edition**
- [Convert credit card validation data to hashes in database](gitlab-org/gitlab@80fb29301dd64dae055bc1a12629b5981bc40ea0) ([merge request](gitlab-org/gitlab!129350))
- [Use a single flags for AI experimentation endpoint](gitlab-org/gitlab@39ec08851ba675f5ba32db56a9b5029c6a90d3ec) ([merge request](gitlab-org/gitlab!130798)) **GitLab Enterprise Edition**
- [Clean up `flux_resource_for_environment` feature flag](gitlab-org/gitlab@f4aa7ddf0ded3e70dee967230f8b02476422b726) ([merge request](gitlab-org/gitlab!130648))
- [Remove multi_pipeline_scan_result_policies feature flag](gitlab-org/gitlab@4e037aba42fa54f65741d9baa0b97581a653ed87) ([merge request](gitlab-org/gitlab!130812)) **GitLab Enterprise Edition**
- [Update Gitlab Shell version to 14.27.0](gitlab-org/gitlab@713db784641a22bacf2ff77e0455755940d23b65) ([merge request](gitlab-org/gitlab!130797))
- [Add migration to sync ScanResultPolicyRead](gitlab-org/gitlab@ce51f0d5c6065b4724b0539d5c538d3761bd51f5) ([merge request](gitlab-org/gitlab!128378))
- [Rename Tofa experimentation endpoint to Vertex](gitlab-org/gitlab@c99f39c8807e033b63afa76ae1e211c58b238334) ([merge request](gitlab-org/gitlab!130598)) **GitLab Enterprise Edition**
- [Add pipeline trigger tokens finder](gitlab-org/gitlab@cb6e8cab27488ff1ce4e53c6bd3b51f52757e4a2) by @missy-davies ([merge request](gitlab-org/gitlab!129064))
- [Add archived in MilestoneInstanceProxy](gitlab-org/gitlab@2a3d909003404a97b6a600dea97f1434ff698584) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/130624)) **GitLab Enterprise Edition**
- [Remove AiProxyHelper and SelfManagedi::ProxyRequest](gitlab-org/gitlab@e6dcb13721454435758ecbbe6338ac2e9f1f4613) ([merge request](gitlab-org/gitlab!129823)) **GitLab Enterprise Edition**
- [Remove non-hashtag key fallback in manifest-import metadata](gitlab-org/gitlab@19c235576ee4dac752cf0aaa2aa296425a89ac91) ([merge request](gitlab-org/gitlab!130600))
- [Remove PAT field for Code Suggestions](gitlab-org/gitlab@3c0255537119cdac09dfcb0adcfc36ddfc1949df) ([merge request](gitlab-org/gitlab!129493)) **GitLab Enterprise Edition**
- [Add linked items widget to Ticket work item type](gitlab-org/gitlab@d627ba1cff27d1ece551906c4b30a6d9d2f04c67) ([merge request](gitlab-org/gitlab!130101))
- [MonitorLockedTablesWorker to automatically lock tables](gitlab-org/gitlab@bfb6cd9d95159d1e5244aaa538aa57a2b64bf5ae) ([merge request](gitlab-org/gitlab!129748))
- [Add schema_version to notes](gitlab-org/gitlab@e659426087ac755e1e2fa261b6d1667b48529a83) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/130163)) **GitLab Enterprise Edition**
- [Add schema_version to snippets](gitlab-org/gitlab@79e87c94147e4b68e598328054cedcd6e2ce8cc6) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/130161)) **GitLab Enterprise Edition**
- [Remove the product_analytics_snowplow_support feature flag](gitlab-org/gitlab@8bc1dc7765219f817a750410d96a702db116b5a6) ([merge request](gitlab-org/gitlab!130228))
- [Move `Project#pages_lookup_path` to `Pages::VirtualDomain`](gitlab-org/gitlab@d7dcad8f13171977615127e2860bedd814d1d49e) ([merge request](gitlab-org/gitlab!130406))
- [Add migration to backfill archived field for blobs](gitlab-org/gitlab@9122038b2d632a116a728d7c225d915c08c83f6a) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/127365)) **GitLab Enterprise Edition**
- [Request proofreader permission](gitlab-org/gitlab@49f81fc2ccea312060ac0b6761d2c9e99ebcc512) by @zhaoqi01 ([merge request](gitlab-org/gitlab!130257))
- [Extract token selector input and create a shared component](gitlab-org/gitlab@65eed78ac76fe2690da6887420ab6c565dcea33c) ([merge request](gitlab-org/gitlab!128973))
- [Add schema_verison to milestones](gitlab-org/gitlab@b6730d8624c236a60a99911ec1ec9aa363ab3b05) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/130158)) **GitLab Enterprise Edition**
- [Cleanup unused code related to old abuse reports list implementation](gitlab-org/gitlab@9ba47955ec5fe0cf6e019ba91bb72d2a1433cf59) ([merge request](gitlab-org/gitlab!129343))
- [Sync Prometheus updates from integrations table to http integrations](gitlab-org/gitlab@c1c0471286761865ff91bd51aa0a9a60927a7b4b) ([merge request](gitlab-org/gitlab!123217))
- [Add current user todos widget to Epic work item type](gitlab-org/gitlab@7a14f87e32f95c5fa3859595f52de9bae439b200) ([merge request](gitlab-org/gitlab!128307))
- [Remove refactor_merge_service feature flag](gitlab-org/gitlab@36cf8db06e9bf814d751f19b0a3a7a91d51b2f80) ([merge request](gitlab-org/gitlab!129539))
- [Remove `descendant_security_scans` feature flag](gitlab-org/gitlab@c5bed922b869702cfbf8f7750bd9c67e6c8860c0) ([merge request](gitlab-org/gitlab!130217)) **GitLab Enterprise Edition**
- [Add schema_version to merge_requests](gitlab-org/gitlab@dd72759b5e712da6bc80ab6be1e57e6918120f4c) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/130068)) **GitLab Enterprise Edition**
- [Rescue RecordNotUnique exception silently](gitlab-org/gitlab@119f7719f1452ab60e4875341a0f7a8cfc555f5e) ([merge request](gitlab-org/gitlab!129296)) **GitLab Enterprise Edition**
- [Adds class for MlModel packages](gitlab-org/gitlab@e4fae06060d615de63282089d20e6ee7edb72180) ([merge request](gitlab-org/gitlab!127264))
- [Detecting duplicate btree indexes](gitlab-org/gitlab@f2e2ead8e4988288d617f9f7399e80db3e7c21d7) ([merge request](gitlab-org/gitlab!106721))
- [Switch go go-redis client](gitlab-org/gitlab@e57ed00d263d3c2e3576e7e52c23762c68acac8f) ([merge request](gitlab-org/gitlab!128204))
- [Fill null values of user_preferences table with their default values](gitlab-org/gitlab@3ebe41c33f0beaa0430675f2690ac4e9097165ba) ([merge request](gitlab-org/gitlab!125774))
- [Fill null values of users table with their default values](gitlab-org/gitlab@6184c735fe1175a2bf577e65d3ee48c2dfbff136) ([merge request](gitlab-org/gitlab!125881))
- [Convert merge_request_user_mentions.note_id to bigint for self-managed](gitlab-org/gitlab@5de4e4ec8bf3a72b5bb9dfafe2f8bc549afd6793) ([merge request](gitlab-org/gitlab!129134))
- [Test(Subscription): activating second license](gitlab-org/gitlab@125dbbef33d2507a1689a39c5a09c4da18c23f15) ([merge request](gitlab-org/gitlab!107259)) **GitLab Enterprise Edition**
- [Correcting typos of "existence"](gitlab-org/gitlab@706e62290854927df32b38aa9288cf1a7062cee6) ([merge request](gitlab-org/gitlab!129851))
- [Revert "Add project_runners_vue_ui feature flag"](gitlab-org/gitlab@e3f76488032e39436c1d7003c16e8fec6890f586) ([merge request](gitlab-org/gitlab!129626))
- [Tweaked run e2e test message to avoid confusion for non team members](gitlab-org/gitlab@54ccf256f1f65fb95c4b4c6639d90ddad0de1355) by @zillemarco ([merge request](gitlab-org/gitlab!129678))
- [Convert issue_user_mentions.note_id to bigint for self-managed](gitlab-org/gitlab@bf101a787056331731bd7b76df8ef9e5c43ce980) ([merge request](gitlab-org/gitlab!128934))
- [Ensure id uniquness across p_ci_builds partitions](gitlab-org/gitlab@a22db7fdcebde1588ea49ba82d20fa16943e16ff) ([merge request](gitlab-org/gitlab!129464))
- [Refactor CI External::Rules class to use Entry class](gitlab-org/gitlab@90f121580e33a30c427b903f479d7c3fe1d47d6d) ([merge request](gitlab-org/gitlab!129650))
- [Clean up environment_details_vue feature flag](gitlab-org/gitlab@05ffca7f55f56c5be394f1055c49360036f4d03c) ([merge request](gitlab-org/gitlab!129400))
- [Convert system_note_metadata.note_id to bigint for self-managed](gitlab-org/gitlab@4b4892b4b2f96599b1f855c5bd79c81f5fa35976) ([merge request](gitlab-org/gitlab!128803))
- [Remove self_managed_code_suggestions_completion_api FF](gitlab-org/gitlab@ac130e166184786ed238988741e0e6630352cf38) ([merge request](gitlab-org/gitlab!129384))
- [Remove code_suggestions_tokens_from_customers_dot FF](gitlab-org/gitlab@b129f3578f57540d5b5ca3c14c5f6d1791f893d8) ([merge request](gitlab-org/gitlab!129385))
- [Remove completed partition_id migrations](gitlab-org/gitlab@119f7a7fd961c93be6b1bbd606fbbe2b798f10aa) ([merge request](gitlab-org/gitlab!129118))
- [Convert design_user_mentions.note_id to bigint for self-managed](gitlab-org/gitlab@08219da99fc356fecc4e9965fe1891baca4d10ff) ([merge request](gitlab-org/gitlab!129111))
- [Migrate etag cache store from SharedState to Cache](gitlab-org/gitlab@6476298fcdcf77206fa768bcca6bd1e3c7994936) ([merge request](gitlab-org/gitlab!129050))

## 16.3.9 (2024-09-20)

No changes.

## 16.3.8 (2024-07-23)

### Added (1 change)

- [Add Rake task to show token expiration info](https://gitlab.com/gitlab-org/gitlab/-/commit/5cff20e0f81c46192f7da21a99fcb2ccb3f1a759) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159383))

### Fixed (1 change)

- [Update an expired test certificate](https://gitlab.com/gitlab-org/gitlab/-/commit/f43da768fb134d230c927f725cf6f303f33259f9) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156401))

### Changed (2 changes)

- [Add a banner informing about token expiration](https://gitlab.com/gitlab-org/gitlab/-/commit/c188632b066fefce719fbe3233d79d24474e8567) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/158475))
- [Do not enqueue PAT expiry enforcement migration](https://gitlab.com/gitlab-org/gitlab/-/commit/64da75077c8218d683c131476a6b1d24fab7a92d) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153457))

### Other (1 change)

- [Clear instance value](https://gitlab.com/gitlab-org/gitlab/-/commit/db817ea6889be2eb82815b22b7fa9d0e67c02d83) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/160265))

## 16.3.7 (2024-01-11)

### Security (2 changes)

- [Fix clickouse-server version in CI](gitlab-org/security/gitlab@114a80eae87becf50ff7df80ae632409c08ea79e) ([merge request](gitlab-org/security/gitlab!3807))
- [User password reset accepts multiple email addresses](gitlab-org/security/gitlab@d65f79dcccc4df9bea87a8a172719961b010cf4f) ([merge request](gitlab-org/security/gitlab!3796))

## 16.3.6 (2023-10-30)

### Security (9 changes)

- [Fix infinite loop when finding component project](gitlab-org/security/gitlab@a1c1255f8f767f1b9a26aee1008ef6a286988a1d) ([merge request](gitlab-org/security/gitlab!3667))
- [Update gitlab-chronic-duration to 0.12](gitlab-org/security/gitlab@89ed5a67a26c362d197eae4f3228755a5e3a1c03) ([merge request](gitlab-org/security/gitlab!3630))
- [Guard gitlab_version_check helper](gitlab-org/security/gitlab@b8f490fc3cfe465d46666380b17c065669c216e1) ([merge request](gitlab-org/security/gitlab!3654))
- [Add the environment action to the CI JWT token fields](gitlab-org/security/gitlab@0563e1a02c2b6886cc21c4dfbedd975c102f0fbb) ([merge request](gitlab-org/security/gitlab!3615))
- [Remove FIFO files from tarball extract](gitlab-org/security/gitlab@d794f0c972e2e081c0ed78ed5001bdd111688641) ([merge request](gitlab-org/security/gitlab!3634))
- [Backport add abuse detection for pipes](gitlab-org/security/gitlab@84a3debec3ce0473598d4681850ccca74a892b30) ([merge request](gitlab-org/security/gitlab!3619))
- [Prevent unprivileged user assignment in templated projects](gitlab-org/security/gitlab@b4ba31c793317dee41382f7a41af4637f38cddaa) ([merge request](gitlab-org/security/gitlab!3637))
- [Fixes Service Desk email template issue description privileges](gitlab-org/security/gitlab@223765ae04031afda38f10e8487a3785ab53032b) ([merge request](gitlab-org/security/gitlab!3639))
- [Update mermaid version for DOS fixes](gitlab-org/security/gitlab@602b89ced4ccad048819fc1603d6e978fd58c882) ([merge request](gitlab-org/security/gitlab!3627))

## 16.3.5 (2023-09-28)

### Security (16 changes)

- [Mark any CI builds that are not complete as canceled when imported](gitlab-org/security/gitlab@749c7d910266e963aeb60380f5a87217cfc6c01f) ([merge request](gitlab-org/security/gitlab!3598))
- [Destroy group service accounts when removing group](gitlab-org/security/gitlab@ba0c8cda5204261419761ed6492f2162587a823e) ([merge request](gitlab-org/security/gitlab!3552))
- [Fix SSO Enforcement for shared groups and projects](gitlab-org/security/gitlab@63a8149fc8ad173d8981181a4a57b12d06a30949) ([merge request](gitlab-org/security/gitlab!3548))
- [Prevents Ci::Build data from being rendered](gitlab-org/security/gitlab@0c9e61c64ce2ec138c2d1f3a23fde86f254dd5f1) ([merge request](gitlab-org/security/gitlab!3542))
- [Update dependency auto-deploy-image to v2.55.0](gitlab-org/security/gitlab@019561fba6919e30ad47af4099074f012440750c) ([merge request](gitlab-org/security/gitlab!3520))
- [Allow only one membership for security policy bots](gitlab-org/security/gitlab@4733816e5258cf1519a2e7b83e1bd558ab707e35) ([merge request](gitlab-org/security/gitlab!3612))
- [Reset all approvals when target branch changes](gitlab-org/security/gitlab@3dd636d81071a058bbde617ed81517acde204adb) ([merge request](gitlab-org/security/gitlab!3608))
- [Default to using the asset proxy](gitlab-org/security/gitlab@eb8d9bc1603b633a7d48380f28db720c36ce614f) ([merge request](gitlab-org/security/gitlab!3580))
- [Restrict Project Fork Linking to Owners and Admins](gitlab-org/security/gitlab@1d557089f4858cf6e224ef8670d491d7f1b48658) ([merge request](gitlab-org/security/gitlab!3565))
- [Prevent math hijacking page elements](gitlab-org/security/gitlab@3a8673a98ebff3d50ff531b329d81a5fe793621c) ([merge request](gitlab-org/security/gitlab!3590))
- [Delete of member branch protection rules cascadingly](gitlab-org/security/gitlab@7dda5b380ee4d354644e0b02888f17ea7cd956b1) ([merge request](gitlab-org/security/gitlab!3596))
- [Prevent collaboration across forks when author cannot push](gitlab-org/security/gitlab@d7195ed4db4cdd121ea5124deb18e82c20792432) ([merge request](gitlab-org/security/gitlab!3530))
- [Allow Maintainer+ to list Sentry projects](gitlab-org/security/gitlab@49c67aa2bbd79829dc33f8f3898015c06e6971a2) ([merge request](gitlab-org/security/gitlab!3554))
- [Fix leaking source code of restricted project through a fork](gitlab-org/security/gitlab@aa1677c558add202d66e981b22eda38bb139e9ab) ([merge request](gitlab-org/security/gitlab!3494))
- [Prevent leaking CI variables via fork MRs](gitlab-org/security/gitlab@72da00d93ca33e4719b3905f7445cde31e54bfae) ([merge request](gitlab-org/security/gitlab!3561))
- [Pipelines will have no access to protected vars and may fail with tags](gitlab-org/security/gitlab@9e3cdd3f4c6609471a925e26355dad6b820c392f) ([merge request](gitlab-org/security/gitlab!3544))

## 16.3.4 (2023-09-18)

### Fixed (2 changes)

- [Fix Geo secondary proxying Git pulls unnecessarily](gitlab-org/security/gitlab@d4ac7db42e80dec97fee07c50471f1e7b60d3bcc) **GitLab Enterprise Edition**
- [Use new indexer, fix removing blobs from index](gitlab-org/security/gitlab@5d48e6871bc6f1c36b93c10f2a54cf28d6adbc65) **GitLab Enterprise Edition**

### Security (1 change)

- [Enforce that the policy is executed by the bot user](gitlab-org/security/gitlab@3f278f761f18ee0b14aca68e2e5f764e1e274176) ([merge request](gitlab-org/security/gitlab!3568))

## 16.3.3 (2023-09-12)

### Fixed (2 changes)

- [Prevent pipeline creation while import is running](gitlab-org/gitlab@b4e374ed7f5b264f04a2589a99004e568ef92319) ([merge request](gitlab-org/gitlab!131156))
- [Create iid sequence for ci_pipelines with new projects](gitlab-org/gitlab@a74b9ac352e0d9783ec39adaadbe2b65028f8e0c) ([merge request](gitlab-org/gitlab!130835))

## 16.3.2 (2023-09-05)

### Fixed (2 changes)

- [Drop bridge jobs on unknown failures](gitlab-org/gitlab@d6fa408c6ecd9283430d6e9d6f46132d6726a8d3) ([merge request](gitlab-org/gitlab!130833))
- [Fix Code Suggestions in Web IDE on GitLab 16.3](gitlab-org/gitlab@6e4cb467dd8c73e9034ba1b3c51a51c2eb02dd38) ([merge request](gitlab-org/gitlab!130755))

## 16.3.1 (2023-08-31)

### Fixed (1 change)

- [Geo: Resync direct upload object stored artifacts](gitlab-org/security/gitlab@5db060ebf8829d027d61403fe9e30f5dc04e17ae) **GitLab Enterprise Edition**

### Security (11 changes)

- [Add authorization checks to import status endpoint](gitlab-org/security/gitlab@4ab4a1e5a3388f222154a3c4d71487303bc15387) ([merge request](gitlab-org/security/gitlab!3513))
- [Update commonmarker to 0.23.10](gitlab-org/security/gitlab@58c3c6e164f7c4f20a711f996b9816d767cafc8c) ([merge request](gitlab-org/security/gitlab!3507))
- [Remove DAST secret variables when URL is updated](gitlab-org/security/gitlab@038471d42bfe5a15df95645b487c9c6872528a33) ([merge request](gitlab-org/security/gitlab!3498))
- [Maintainer can leak sentry token by changing the configured URL](gitlab-org/security/gitlab@62ac5e0cb77f61c107c4b91a442927ab666056e8) ([merge request](gitlab-org/security/gitlab!3516))
- [Service account users are external by default](gitlab-org/security/gitlab@8c6892ba0144d202a346d9cc83488fa5d9ae044b) ([merge request](gitlab-org/security/gitlab!3501))
- [Additional permission check when editing label](gitlab-org/security/gitlab@ec01380d19929259a95bf2d198cdffde3351806f) ([merge request](gitlab-org/security/gitlab!3504))
- [Fix ReDOS in bulk_imports endpoint params](gitlab-org/security/gitlab@6e043d181b1c4968777efd0ab06bc9879a5a2076) ([merge request](gitlab-org/security/gitlab!3510))
- [Prevent namespace level banned users from accessing API](gitlab-org/security/gitlab@ca3180b89ee5601b3a535058ae0a51def2b78a0f) ([merge request](gitlab-org/security/gitlab!3519))
- [Check prohibit_outer_forks in fork relationship api](gitlab-org/security/gitlab@95f74317906732a0f8c6db830dcd9ac1113f69d3) ([merge request](gitlab-org/security/gitlab!3479))
- [Prevent traversal for `path` parameter in refs/switch endpoint](gitlab-org/security/gitlab@12b3b42cf27750b6b7c2c4b62352b444b4b4ae34) ([merge request](gitlab-org/security/gitlab!3491))
- [Gitaly keyset pager when pagination none only with tree view](gitlab-org/security/gitlab@39cbdd7aae475cee11bc720ef25e02518dd54b99) ([merge request](gitlab-org/security/gitlab!3495))

## 16.3.0 (2023-08-21)

### Added (169 changes)

- [Add metrics for Dependency Management actions](gitlab-org/gitlab@305f5bfc638fd693c447bdaed844df90184ea37f) ([merge request](gitlab-org/gitlab!129481)) **GitLab Enterprise Edition**
- [Adding new application setting called ci_max_total_yaml_size_bytes](gitlab-org/gitlab@accf6c4c29c8e306a836e870c087e183fb6fba64) ([merge request](gitlab-org/gitlab!123129))
- [Add default_branch_protection_defaults in groups apis](gitlab-org/gitlab@dd442e7a643070257fd9cf4f44801e597cf7963c) ([merge request](gitlab-org/gitlab!128760))
- [Add documentation for multi pipeline scan result policy feature](gitlab-org/gitlab@7d0147bbe197e39f7f377184124620344ff58bd4) ([merge request](gitlab-org/gitlab!128126)) **GitLab Enterprise Edition**
- [Adds CatalogResourceComponents table](gitlab-org/gitlab@c5ffadd08f57532e30c9651585b2017e05f46b78) ([merge request](gitlab-org/gitlab!127775))
- [Add popover for Flux sync status badge](gitlab-org/gitlab@32fe79fe61b43adbf1634948022381e36cb0d4cc) ([merge request](gitlab-org/gitlab!129098))
- [Adds `to_redacted_sql` support for ClickHouse QueryBuilder](gitlab-org/gitlab@2208b24e261ce25ffd2cf734bb1ed4422a509e7e) ([merge request](gitlab-org/gitlab!128933))
- [Remove ci_namespace_catalog_experimental](gitlab-org/gitlab@d30d57d8eba8d86021063b9741e5086d646b62d4) ([merge request](gitlab-org/gitlab!129299))
- [New default branch protection json field](gitlab-org/gitlab@b20292728aed75e734e5b021e3697d5ba50f4974) ([merge request](gitlab-org/gitlab!128577))
- [Allow to select flux resource for environment](gitlab-org/gitlab@9a8ec346b5e8b9ed42e8cc4aba383a47151b5cd6) ([merge request](gitlab-org/gitlab!128857))
- [Adding WAL rate db health indicator](gitlab-org/gitlab@f7d35e30da51edf0dd24dafef9aa491d71d52241) ([merge request](gitlab-org/gitlab!128365))
- [Support themes in "super sidebar" navigation redesign](gitlab-org/gitlab@d51d6d7adb2137c3eebb54d661041dd02229d800) ([merge request](gitlab-org/gitlab!127990))
- [Introduce rake task for bumping sequences of cells](gitlab-org/gitlab@b0a13e294d842be2908fd2bde8ff5bf9b2e66e04) ([merge request](gitlab-org/gitlab!129243))
- [Add vulnerability attributes to policy drawer](gitlab-org/gitlab@67fd1e83edfb1fd5d82b78e4a657c14dc63cdd67) ([merge request](gitlab-org/gitlab!123404)) **GitLab Enterprise Edition**
- [Add pipelineTriggersDelete GraphQL mutation](gitlab-org/gitlab@cd6500c74881efe42d99fbdf630eaacb145cab48) by @missy-davies ([merge request](gitlab-org/gitlab!126540))
- [Add GraphQL mutation to link work items](gitlab-org/gitlab@498149443c1f152119b7f30c7030b6c1ec78dcc9) ([merge request](gitlab-org/gitlab!127380))
- [Implement CVS UI in Vulnerability dashboard page](gitlab-org/gitlab@f8bbcb085ae4b93736f2ba6a6eb7cca94d02496f) ([merge request](gitlab-org/gitlab!128256))
- [Update pm affected_package ingestion with new attribute](gitlab-org/gitlab@1c36e324b827aa4965c1c17544e6237884cff8ec) ([merge request](gitlab-org/gitlab!127915)) **GitLab Enterprise Edition**
- [Add frequently visited items to search modal](gitlab-org/gitlab@7ff9d8ddb0e92c15a6d5c8a24945bd2dc8e1c660) ([merge request](gitlab-org/gitlab!129020))
- [Error handling to label deletion controllers](gitlab-org/gitlab@8bc6ef1c0b3a3b4b2552f2b41046a64f0e3ddaf1) ([merge request](gitlab-org/gitlab!129027))
- [Show alert for more than 10 agents](gitlab-org/gitlab@9b2b92b791abbd79511884f911b6d65592371e86) ([merge request](gitlab-org/gitlab!129122))
- [Publish Authorizations Changed Event](gitlab-org/gitlab@4e8eafe2cf0ee53ef01050fd4e9ffae152f058f8) ([merge request](gitlab-org/gitlab!128539))
- [Add spam checking for issue CSV uploads](gitlab-org/gitlab@ede500db5c79808f16fac50c3770d22e592ab930) ([merge request](gitlab-org/gitlab!127538))
- [NuGet v2 $metadata endpoint](gitlab-org/gitlab@ece3d3d2af7871c1115cceaccdeddd41f1815f6e) ([merge request](gitlab-org/gitlab!128786))
- [Add support for GetObjectPool RPC](gitlab-org/gitlab@1aa17e72ab0ab41c9a84b2f44ea0ead5afe5bcb3) ([merge request](gitlab-org/gitlab!127644))
- [Add pipelineTriggersUpdate GraphQL mutation](gitlab-org/gitlab@e966c784e4f0e230003926c20ab77b3c91dd8792) by @missy-davies ([merge request](gitlab-org/gitlab!126537))
- [Add advisory ingestion event](gitlab-org/gitlab@5c94d88cabf30ca18152ec5dd02dba2022974e03) ([merge request](gitlab-org/gitlab!127800))
- [Add Groups::SshCertificate model to store group's CAs](gitlab-org/gitlab@ab9801ef68e6e5355760cb88388561d165b0ea17) ([merge request](gitlab-org/gitlab!127856))
- [Removes ci_needs_parallel_matrix feature flag](gitlab-org/gitlab@670cb17970ed3d62f11b52189048a39d60cbce92) ([merge request](gitlab-org/gitlab!128791))
- [Add has_remediations column to vulnerability_reads](gitlab-org/gitlab@eac1bcfdf4c3c94c43d3ad094d8af46c6afb95e4) ([merge request](gitlab-org/gitlab!128915))
- [Added [data-event-tracking-load=true] tracking attribute](gitlab-org/gitlab@3e99704a9866fed47db4e90ede9842d90d3d7551) ([merge request](gitlab-org/gitlab!128587))
- [Save pages_deployments path_prefix and build.ref](gitlab-org/gitlab@9411433fa4d0d4470f365a9804ca8fdfac344d48) ([merge request](gitlab-org/gitlab!128930))
- [Default enable custom_roles_on_groups FF](gitlab-org/gitlab@73fe72cf1cb1f97657cfe769a5c8458992fd0ee7) ([merge request](gitlab-org/gitlab!129211)) **GitLab Enterprise Edition**
- [ClickHouse data collector for contribution analytics](gitlab-org/gitlab@1987b06de274d8c14fd37787908d91e3a3cb4812) ([merge request](gitlab-org/gitlab!127435)) **GitLab Enterprise Edition**
- [Add flux_resource_path to the environments table](gitlab-org/gitlab@ad08bce149765b81855b1d4f5e6731d1e05e7d91) ([merge request](gitlab-org/gitlab!128819))
- [Add attributes filter to scan result policies](gitlab-org/gitlab@17cfb1eb2f8ba24c76e1b96bf629a75e708e2948) ([merge request](gitlab-org/gitlab!123052)) **GitLab Enterprise Edition**
- [Show message acknowledging deployment approval](gitlab-org/gitlab@f98cf6e81436e08d553d56f7d68512608373419a) ([merge request](gitlab-org/gitlab!129127)) **GitLab Enterprise Edition**
- [Add block counts to linked work items widget](gitlab-org/gitlab@faf319c254740d6277fef4adf5db51cb99c391a5) ([merge request](gitlab-org/gitlab!128152))
- [Adding migrations for gcp config name backfilling and setting not null](gitlab-org/gitlab@d3df48e55b75f1bbc17ebe2e94f5f3aa65b25483) ([merge request](gitlab-org/gitlab!128449))
- [Adding active column to custom http audit event destination headers](gitlab-org/gitlab@e8eb1d68f7072d499b6eaec91591d2ec9a7098ec) ([merge request](gitlab-org/gitlab!128727))
- [Trigger for has_merge_request on vulnerability_issue_links](gitlab-org/gitlab@4f28da5459f7634aa835337b98061d394d532923) ([merge request](gitlab-org/gitlab!128372))
- [Remove pat_reuse_detection feature flag](gitlab-org/gitlab@5461dcc88fdb61772577abcc17bb8940a6b9095b) ([merge request](gitlab-org/gitlab!129116))
- [Add REPOSITORIES_SERVER_SIDE env to enable gitaly server-side backups](gitlab-org/gitlab@d984b45d608c949db9833a1c6d55ebf48d4723a3) ([merge request](gitlab-org/gitlab!126637))
- [Add foreign key constraint to ci_pipeline_variables](gitlab-org/gitlab@2e20e0ec6aca6be97a45e1a73a312355eed34d1c) ([merge request](gitlab-org/gitlab!127445))
- [Create indexes necessary for uuid column type change](gitlab-org/gitlab@3f2da3e8f238fe839e7a4cbc1ccca79a10eb6842) ([merge request](gitlab-org/gitlab!128485))
- [Send X-Gitlab-Realm header to AI gateway](gitlab-org/gitlab@f148592559ed54d0f3b335444829e943dca1a79c) ([merge request](gitlab-org/gitlab!128998)) **GitLab Enterprise Edition**
- [Add CRM contacts to the issue webhook](gitlab-org/gitlab@932aabdd9985504c2563e4989955e486bf0bbff3) by @TickettEnterprises ([merge request](gitlab-org/gitlab!126530))
- [Add source_project_id to commit template](gitlab-org/gitlab@d4698775ad4841a17d360c459d7392533e2aaa58) by @bovi ([merge request](gitlab-org/gitlab!128553))
- [Release sec policy bot users for groups](gitlab-org/gitlab@c083fbb2b9bc83ad29f47fb7fd06903d0f8c8de3) ([merge request](gitlab-org/gitlab!128988)) **GitLab Enterprise Edition**
- [Add status poller to import groups history page](gitlab-org/gitlab@296be2276f81d69f0c157a2290f8554afcd25aa5) ([merge request](gitlab-org/gitlab!128860))
- [Release sec policy vulnerability attributes filter](gitlab-org/gitlab@a557984931e29f5485cdc0ea380ed58fe953b16f) ([merge request](gitlab-org/gitlab!128713)) **GitLab Enterprise Edition**
- [Add usage tracking of security policies actions](gitlab-org/gitlab@19b29b6ca6c74951933617647b4abaef9cb46638) ([merge request](gitlab-org/gitlab!128629)) **GitLab Enterprise Edition**
- [Add pipelineTriggersCreate GraphQL mutation](gitlab-org/gitlab@ac8b01cb22046f027d62f964a7c84a9f10e54dca) by @missy-davies ([merge request](gitlab-org/gitlab!125887))
- [Feat: Add print to PDF for wiki](gitlab-org/gitlab@34d4690ed65b4214fa9b70d95522fdded04753ba) by @fenyuluoshang ([merge request](gitlab-org/gitlab!125260))
- [Add GraphQL endpoints to fetch abuse report and abuse report labels](gitlab-org/gitlab@345e933eb091087d872aec125ac4c48f18c29228) ([merge request](gitlab-org/gitlab!128219))
- [Enhance ci-cd pipeline settings](gitlab-org/gitlab@a27b7d14c212aa894816a8ccc890e90add66497e) by @dbvech ([merge request](gitlab-org/gitlab!128563))
- [Add sentry_clientside_traces_sample_rate app setting](gitlab-org/gitlab@e66e8e10a28d95cf821d217ed15f87bda7e35524) ([merge request](gitlab-org/gitlab!128336))
- [Run compliance standards checks when new projects are created](gitlab-org/gitlab@09bea05388fb4749b22f3d94463d788f5ac26eda) ([merge request](gitlab-org/gitlab!128749)) **GitLab Enterprise Edition**
- [Add at least two approvals check to Gitlab standard](gitlab-org/gitlab@1d328530277d447c340cd75575ed0f6ee4a7dcd7) ([merge request](gitlab-org/gitlab!128340)) **GitLab Enterprise Edition**
- [Release sec policy bot users for projects](gitlab-org/gitlab@29e29aed2d47729811d37a15026259c828697b5c) ([merge request](gitlab-org/gitlab!128963)) **GitLab Enterprise Edition**
- [Add annotations job artifact type](gitlab-org/gitlab@db9babfe502f9a49e4afba87f4112b0c7158e8fd) by @KyleFromKitware ([merge request](gitlab-org/gitlab!126575))
- [Add confidentiality to work item bulk edit](gitlab-org/gitlab@48a98e828793bbb7846ece684212d74052dc68be) ([merge request](gitlab-org/gitlab!128412))
- [Add ability to query linked work items](gitlab-org/gitlab@2635683120e86dcfd8b4b1576777dc1aed9b8e70) ([merge request](gitlab-org/gitlab!126980))
- [Adds a health checker for elastic cluster](gitlab-org/gitlab@3aae7dfd443511b97e2e412cdf6ddb68c93b9477) ([merge request](gitlab-org/gitlab!127731)) **GitLab Enterprise Edition**
- [Update progress update mutation](gitlab-org/gitlab@df99048b55b4b485614aa6d2a49acd7fe368e327) ([merge request](gitlab-org/gitlab!128142)) **GitLab Enterprise Edition**
- [Remove feat flags: delete unconfirmed user feature](gitlab-org/gitlab@ff447da7cde290763894617656590674c5ff1097) ([merge request](gitlab-org/gitlab!128699)) **GitLab Enterprise Edition**
- [Add support for feature flags on DSL field](gitlab-org/gitlab@cb2ffb66a491ce62dd830e2b7752950507e20032) ([merge request](gitlab-org/gitlab!128123))
- [Query builder for clickhouse](gitlab-org/gitlab@2c7636e683b98b31ac53e1bddcffd6fe8c477347) ([merge request](gitlab-org/gitlab!128096))
- [Added UI to set time estimate on issues and merge requests](gitlab-org/gitlab@9996b94901aa716cd60f359510bae9a395318f58) by @zillemarco ([merge request](gitlab-org/gitlab!113037))
- [Add lock_on_merge column to labels table (fixed)](gitlab-org/gitlab@b81b30dd49a3ec8cbd8272648c3f59c3c8a0c33a) ([merge request](gitlab-org/gitlab!128667))
- [Add "auditors" parameter to users API](gitlab-org/gitlab@b1a686c55047afc57be0baa2fa41fd9a0923c7de) by @joe-snyder ([merge request](gitlab-org/gitlab!126064)) **GitLab Enterprise Edition**
- [Session variable to store provider two factor bypass](gitlab-org/gitlab@7ab7d25348071da2960ff03cf1da2467dc02abf4) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/122109))
- [Removed ai_chat_emit_user_messages flag](gitlab-org/gitlab@ba272f64dcd60cf4af3e1cdc209e2853b2ad6b7c) ([merge request](gitlab-org/gitlab!128765)) **GitLab Enterprise Edition**
- [Allow filtering by dismissal reason on vulnerability report](gitlab-org/gitlab@b89bc670dfbddecb729a6561daa6e8d55609affc) ([merge request](gitlab-org/gitlab!121532)) **GitLab Enterprise Edition**
- [Exclude archived projects from commit search](gitlab-org/gitlab@bf15236eb0962ce934ad1387335ae05c255d6ea7) by @sd5869 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/128080)) **GitLab Enterprise Edition**
- [Removes ci_include_components ff](gitlab-org/gitlab@b18932b9656fd9582c0f72391874700528e8a7a5) ([merge request](gitlab-org/gitlab!128617))
- [Add get all pipelineTriggers GraphQl endpoint](gitlab-org/gitlab@d045d24c6e8867211ac6edd77895219aef2fb86c) by @missy-davies ([merge request](gitlab-org/gitlab!125129))
- [Add copy reference keyboard shortcut](gitlab-org/gitlab@4ef462c99fa9c9ee89606e769ec1816da4dc60e2) ([merge request](gitlab-org/gitlab!128542))
- [Add sync status badge to the environment](gitlab-org/gitlab@f26fc52333a5b26debc6ceb787688876cb40a1f4) ([merge request](gitlab-org/gitlab!128028))
- [Send hashed instance and user IDs to AI gateway](gitlab-org/gitlab@eacf23e241cdcf5a54c287808eaedaefd8349780) ([merge request](gitlab-org/gitlab!127882)) **GitLab Enterprise Edition**
- [Add lock_on_merge column to labels table](gitlab-org/gitlab@dd2799a342f8cb825372d3984b0228cb728a705b) ([merge request](gitlab-org/gitlab!127683))
- [Add `component_name` and `input_file_path` columns to sbom_occurrences](gitlab-org/gitlab@2bd1ce9c76bb27a4dd42ff585833ec9448070793) ([merge request](gitlab-org/gitlab!128243))
- [Default enable linear self and hierarchy scopes](gitlab-org/gitlab@26509ba94ed496aca192ccacd3434c877f60d84b) ([merge request](gitlab-org/gitlab!127837))
- [Add Places group to default search view](gitlab-org/gitlab@421895f929a559341326e13d097d7318741a6d5a) ([merge request](gitlab-org/gitlab!128376))
- [Add max decompression archive size to AS](gitlab-org/gitlab@a44eb879afbd83f23770a419465f85b867f0172c) ([merge request](gitlab-org/gitlab!128218))
- [Offer email reset when verifying email](gitlab-org/gitlab@097a3adb6fb0d41e7b02d22b8efb87dc2753ea7d) ([merge request](gitlab-org/gitlab!126345))
- [Add temporary index for pipeline_artifacts_size](gitlab-org/gitlab@ed4cede825a5b576ade8d6b4c78969c5004fce8e) ([merge request](gitlab-org/gitlab!126053))
- [Added name field to gcp conf for external audit event destinations](gitlab-org/gitlab@3e9dad860cbc49e4e335221db209c408b5e81ce5) ([merge request](gitlab-org/gitlab!127620))
- [Add group users autocomplete to GrahQL API](gitlab-org/gitlab@c7d5c63898e9843b4e0db48e2a3d8cf73c9657b0) ([merge request](gitlab-org/gitlab!128306))
- [Create list for standards adherence report](gitlab-org/gitlab@0a3e329eb5634e3fa0e170a4163cd5aa65696ce0) ([merge request](gitlab-org/gitlab!125444)) **GitLab Enterprise Edition**
- [Add prevent approval by committer check to Gitlab standard](gitlab-org/gitlab@d3e25e69c85a25fdc79d046eff20bf82680ac674) ([merge request](gitlab-org/gitlab!127716)) **GitLab Enterprise Edition**
- [Add has_merge_request column to vulnerability_reads](gitlab-org/gitlab@35953ef4a8e6424515dad7e9856593539e944d72) ([merge request](gitlab-org/gitlab!127329))
- [Add new DirectTransfer/Import max file size app settings](gitlab-org/gitlab@a8f2a01a727eb605c6965b96487d7d71421b91e7) ([merge request](gitlab-org/gitlab!127772))
- [Added audit events for update destroy headers](gitlab-org/gitlab@f1ea1cc4ea0cd9d6b0f74c26f248374ad9714594) ([merge request](gitlab-org/gitlab!127228)) **GitLab Enterprise Edition**
- [Refactored audit event for group creation](gitlab-org/gitlab@648e404c63a5922f48fedd17848900fac3cda850) ([merge request](gitlab-org/gitlab!121005)) **GitLab Enterprise Edition**
- [Hide the notes from the archived project in the search results](gitlab-org/gitlab@8dab0ac0cc7fd6e5f7b1fe8caa1a6483b7ee0bce) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/127333))
- [Add a setting for allowing/disallowing duplicate NuGet package upload](gitlab-org/gitlab@c0d5d8400bc6806d7af6c46a5ec2919c418a07e7) ([merge request](gitlab-org/gitlab!123783))
- [Add basic support for issue filter by date](gitlab-org/gitlab@1de78d0be160710ae7ae3d9551c72c94f7ef1757) ([merge request](gitlab-org/gitlab!120160))
- [Add work item state to header](gitlab-org/gitlab@5b5ba10d7d6022c8d9e3e141e52aaef0ed549f84) ([merge request](gitlab-org/gitlab!127196))
- [Add ability to store linked work items](gitlab-org/gitlab@4afa5ad19c7543564451a5b05ab2e4b47305b8a0) ([merge request](gitlab-org/gitlab!126854))
- [Show an alert if there are pending obsolete elastic migrations](gitlab-org/gitlab@76b1e33fd10cf5e68cf435fd738cfb10ce5c1549) ([merge request](gitlab-org/gitlab!127458)) **GitLab Enterprise Edition**
- [Allow filtering Vulnerabilties by dismissal reason](gitlab-org/gitlab@1bd215bd111c6422e7c8f1d6886b836a49292265) ([merge request](gitlab-org/gitlab!127652))
- [Add versions attribute to affected packages](gitlab-org/gitlab@769a2e7fa954e7120435e977b919f4a9451bff05) ([merge request](gitlab-org/gitlab!127681))
- [Add firewall rules to workspaces](gitlab-org/gitlab@0b22c51463810758ce497298400a0251df6e8c3a) ([merge request](gitlab-org/gitlab!126283))
- [Add name and description fields to member_roles](gitlab-org/gitlab@806a2725378ef023f194d52dece8bd72f8c4d11d) ([merge request](gitlab-org/gitlab!126423))
- [Add namespace to sbom components](gitlab-org/gitlab@fe8a3d2850f2e73fcaaa768083abf08e76bebe0f) ([merge request](gitlab-org/gitlab!127528))
- [Enable standalone_finding_modal by default](gitlab-org/gitlab@6292fb1faf7eb51c8be19a09a6aaa238a76ab5fd) ([merge request](gitlab-org/gitlab!127546)) **GitLab Enterprise Edition**
- [Add mutation for subscribing to a work item](gitlab-org/gitlab@1c1d6bf8c5333a353ed8bba95ca17c75a7af4a79) ([merge request](gitlab-org/gitlab!127220))
- [Add updated_at timestamp to PlanLimits](gitlab-org/gitlab@0d3f82613fc9e504c5462eac477be9538a4d4810) ([merge request](gitlab-org/gitlab!127459))
- [Add vulnerability age to policy drawer](gitlab-org/gitlab@d0ffa7f1f4cf67ae9bde5a2de1730f67662ef9e2) ([merge request](gitlab-org/gitlab!122665)) **GitLab Enterprise Edition**
- [Add an application setting to enable public package registries](gitlab-org/gitlab@0e041adf1ec13728c4005ff369e030617b772fd5) ([merge request](gitlab-org/gitlab!124825))
- [Enforce approval rules based on attributes](gitlab-org/gitlab@e3e3a5afc02f186bc568a1f40b0d0262e38769d4) ([merge request](gitlab-org/gitlab!127250)) **GitLab Enterprise Edition**
- [Support functions in Ci config interpolation](gitlab-org/gitlab@dcc21c864a7603eb7f92072c379d1946b63de7b4) ([merge request](gitlab-org/gitlab!125802))
- [Backfill all epics into Elasticsearch](gitlab-org/gitlab@db5dc1d2fa9a7fd407d3d6fee17c19fde9a4f956) ([merge request](gitlab-org/gitlab!125663)) **GitLab Enterprise Edition**
- [Add boolean and number CI inputs](gitlab-org/gitlab@cc083351c94b64fa86c9c34e396e437fa44b4c14) ([merge request](gitlab-org/gitlab!127762))
- [Add mutation userAddOnAssignmentRemove](gitlab-org/gitlab@6ff18e2bca54878b0a676652755f302bd83cdb03) ([merge request](gitlab-org/gitlab!127419)) **GitLab Enterprise Edition**
- [Filter groups by repository storage](gitlab-org/gitlab@14f3ff67aeebd8fe96ae5a4179816066c602b314) ([merge request](gitlab-org/gitlab!127526))
- [Index `vulnerability_reads` on `project_id` and `vulnerability_id`](gitlab-org/gitlab@666bf942fc00bad754232fa1bae973ffafc7e37f) ([merge request](gitlab-org/gitlab!127747))
- [This MR adds branches dropdown](gitlab-org/gitlab@23b25779e47f9e2de4f5e902faf026cf30fbd513) ([merge request](gitlab-org/gitlab!127394)) **GitLab Enterprise Edition**
- [Support search field option for iterations REST API](gitlab-org/gitlab@37b5c7fbadb60a4cd369a57b031bb424805b6d0c) ([merge request](gitlab-org/gitlab!125497)) **GitLab Enterprise Edition**
- [Validate URL on Vulnerabilities::Identifier model](gitlab-org/gitlab@a2bdaefe1640b671d6dc97def4fb0fda8b445496) ([merge request](gitlab-org/gitlab!127352)) **GitLab Enterprise Edition**
- [Add basic auth to Zoekt client](gitlab-org/gitlab@cff62b3d7005acbe06f15d738ae71fd5a46e68fa) ([merge request](gitlab-org/gitlab!127203)) **GitLab Enterprise Edition**
- [Enable elevated_guests by default](gitlab-org/gitlab@057d856eeba7f07b75988b54deb2a7e21719a3d3) ([merge request](gitlab-org/gitlab!127378)) **GitLab Enterprise Edition**
- [Add new metric for advanced search limited indexing setting](gitlab-org/gitlab@0bbb69e89ef0fbbdc9dcc95e78b1f544af281f0e) ([merge request](gitlab-org/gitlab!122351)) **GitLab Enterprise Edition**
- [Forward User-Agent header to model gateway](gitlab-org/gitlab@e5cd565a9ee6eca3dbae40662bb410feb155c235) ([merge request](gitlab-org/gitlab!127630)) **GitLab Enterprise Edition**
- [Allow to set different webhooks on events in Discord Integration](gitlab-org/gitlab@54f2db504e74cbec2ebe699820125b090c0a1f54) by @Taucher2003 ([merge request](gitlab-org/gitlab!125621))
- [Add member expiring email notification](gitlab-org/gitlab@65166ae79deaa6f37a672133ce3810699b8284b6) by @zhanglinjie ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/124577))
- [Add form error messages to vulnerability report bulk updates](gitlab-org/gitlab@99703d13de9014382b5cb2f8dd8ad1e96e4ac6d8) ([merge request](gitlab-org/gitlab!127464)) **GitLab Enterprise Edition**
- [Add MR reviewers to BitBucketServer import](gitlab-org/gitlab@6d2b622a33bd580d7f70c3108bd1d675eab52ca9) ([merge request](gitlab-org/gitlab!126729))
- [Add tracking for neovim plugin](gitlab-org/gitlab@b9171d1a53db32a073bed38306a7197e1b026a33) ([merge request](gitlab-org/gitlab!127561))
- [Remove notify_kas_on_git_push feature flag](gitlab-org/gitlab@3eb09abc3546248d6a7c41723c9334cdae785566) ([merge request](gitlab-org/gitlab!126405))
- [Add age filter for scan result policies](gitlab-org/gitlab@f7229a070cb30dfb4f476f2d4d0a2729d87bd21e) ([merge request](gitlab-org/gitlab!122638)) **GitLab Enterprise Edition**
- [Adds patch_id to merge_request_diffs](gitlab-org/gitlab@81a0e6f648f899fd9f97af694ffb8064a8d1b69f) ([merge request](gitlab-org/gitlab!126920))
- [Add mutation userAddOnAssignmentCreate](gitlab-org/gitlab@4c64099b31ad6e44e47d905734d88f6d0878e343) ([merge request](gitlab-org/gitlab!126964)) **GitLab Enterprise Edition**
- [Add tmp index for orphaned approval rules](gitlab-org/gitlab@3fbc64499cebbc1d0dd00f787f521cb24a908cfb) ([merge request](gitlab-org/gitlab!127426))
- [Add project_visibility JWT claim](gitlab-org/gitlab@6045121766a033af691f24fd7eac3c648c7f0fca) ([merge request](gitlab-org/gitlab!125787))
- [Add link to forecast feedback issue at top of Deployment Frequency page](gitlab-org/gitlab@c02bfc346cdadb79ccb8ec0218cb747ca5af8334) ([merge request](gitlab-org/gitlab!127274))
- [GQL code owners Validation for every file named CODEOWNERS](gitlab-org/gitlab@dada2a35532f0cc42d0407d314b12c103fc42f89) ([merge request](gitlab-org/gitlab!126318)) **GitLab Enterprise Edition**
- [Aggregate open abuse reports by reported-user and abuse category](gitlab-org/gitlab@ef0bee5c1755d46c78f15240a94ed4476df80cab) ([merge request](gitlab-org/gitlab!119282))
- [Creates Ml::ModelVersion on package creation](gitlab-org/gitlab@a9bd4c5bc84f78972f2df4a8455f554ee1b64ce9) ([merge request](gitlab-org/gitlab!126686))
- [Add and endpoint to receive Telesign transaction callbacks](gitlab-org/gitlab@d1f6b72a6a5b9d7654c83e9c269418bdee836b92) ([merge request](gitlab-org/gitlab!125983)) **GitLab Enterprise Edition**
- [Finalize conversion for FKs targeting p_ci_builds - 3 self-managed](gitlab-org/gitlab@fb5353c2afd0e46ecb6bf981b5df73f8fc34c51f) ([merge request](gitlab-org/gitlab!124311))
- [Adds services to create Ml::* entities](gitlab-org/gitlab@f079f01829f4f7b887d35375a5ce2a90afb98a15) ([merge request](gitlab-org/gitlab!126490))
- [Add option to disable rollback on outdated deployments](gitlab-org/gitlab@79715e22b17ba7f47111a2dfa735438506abac0e) ([merge request](gitlab-org/gitlab!126788))
- [Add FileTree toggle hotkey](gitlab-org/gitlab@6a5e7d596f35ad16639d538a9aa1273c2debc170) ([merge request](gitlab-org/gitlab!127098))
- [Adding position parameter to Draft Notes API](gitlab-org/gitlab@f17012fd0d7e5695245eb44ed13814be4d714b11) ([merge request](gitlab-org/gitlab!123107))
- [Update resolved status of notes in real time](gitlab-org/gitlab@192d7f112c46e014507bbd396482145473c29929) ([merge request](gitlab-org/gitlab!127000))
- [Update projects to not use emails_disabled](gitlab-org/gitlab@f1c430eca81bc50cd84cde23d4bdaf5a5caaf073) by @joe-snyder ([merge request](gitlab-org/gitlab!121585)) **GitLab Enterprise Edition**
- [Remove pipeline_name_in_api feature flag](gitlab-org/gitlab@5b2cb99e54f073246b26b0949925883d816d8366) ([merge request](gitlab-org/gitlab!123134))
- [Feat: edit user profile vue avatar](gitlab-org/gitlab@bba46444c3efe4099bfcd403f586d4de6523150e) ([merge request](gitlab-org/gitlab!123627))
- [Backfill `dismissal_reason` column for `vulnerability_reads` table](gitlab-org/gitlab@bbd4bc41af224be94d33f832f3a738f3b232a294) ([merge request](gitlab-org/gitlab!123518))
- [Add status_message to packages table](gitlab-org/gitlab@30e22997c60cc233c3d09903862a809d84f4907c) ([merge request](gitlab-org/gitlab!122299))
- [Create catalog_resource_versions table](gitlab-org/gitlab@36d1ded2d2a4f61fb74ad4fb174d1711d3e72890) ([merge request](gitlab-org/gitlab!124668))
- [Add Azure Key Vault support for CI/CD](gitlab-org/gitlab@6369742ac57a213e4c8c008dce94cf5fc97ccc5f) ([merge request](gitlab-org/gitlab!106321))
- [Add archived col in commits index](gitlab-org/gitlab@70e1970ecd310b76332fa028a349bdeb510dc54e) by @sd5869 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/127004)) **GitLab Enterprise Edition**
- [Add service index and publish endpoints for NuGet v2](gitlab-org/gitlab@1318f1e4c7922787b1c53bc2398904f7520a460f) ([merge request](gitlab-org/gitlab!125558))
- [Add archived col in main index for blobs](gitlab-org/gitlab@d562adbbbf7ee3900db3af07f4946f65baee2c38) by @sd5869 ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/127008)) **GitLab Enterprise Edition**
- [Added "DORA performers score" panel to Value Streams Dashboard](gitlab-org/gitlab@e056f59ac7744a15a9fe4c3e2789ea9b27953a09) ([merge request](gitlab-org/gitlab!126206)) **GitLab Enterprise Edition**
- [Add tracking for visual studio extension](gitlab-org/gitlab@cbb6f10f3546dfdebe0cb864e7b6a3d37104aa5c) ([merge request](gitlab-org/gitlab!124913))
- [Add achievement and user achievement GraphQL count](gitlab-org/gitlab@cce43385a5d400ffaf071645754b95e60d3f18f9) ([merge request](gitlab-org/gitlab!126912))
- [Add syntax highlighting for Svelte files in Blob view](gitlab-org/gitlab@0680b3a27b3973287ae6a973703faf9472535c47) by @rudedog9d ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/125030))
- [Add `package_manager` column to `sbom_occurrences` table](gitlab-org/gitlab@036d89132ee370de746fbca336caf0b7a3148d5d) ([merge request](gitlab-org/gitlab!126850))
- [Removes namespace_limits_admin_dashboard FF](gitlab-org/gitlab@fffbf6f3391a4c28c842ce025443f3432027eb5a) ([merge request](gitlab-org/gitlab!126547)) **GitLab Enterprise Edition**
- [Adds a script to generate elastic migration files](gitlab-org/gitlab@4d8223d2ea2c7102c4e2ee853d21cf5afe9048a4) ([merge request](gitlab-org/gitlab!126824))
- [Adds a script to generate elastic migration files](gitlab-org/gitlab@4c4db7f9302e28ce5b567a2d246c2dab92e1cb03) ([merge request](gitlab-org/gitlab!125265))
- [Expose deploy key in push access level graphql type](gitlab-org/gitlab@aaeb41c24ccb5bcb54e3dd902a1c807e6653a067) ([merge request](gitlab-org/gitlab!126746))
- [Cleanup ci_group_env_scope_graphql feature flag](gitlab-org/gitlab@2cd6c501021952345ee69c882953947f1691519b) ([merge request](gitlab-org/gitlab!126718))
- [Add the sync index creation](gitlab-org/gitlab@152027bb35478e1a95538e10517601610eefef81) ([merge request](gitlab-org/gitlab!126689))
- [Remove track_work_items_activity feature flag](gitlab-org/gitlab@5fe3a2d7ed657e00ee1e600d5ebe15667ea8e005) ([merge request](gitlab-org/gitlab!126399))

### Fixed (180 changes)

- [Update visibility level when levels are restricted](gitlab-org/gitlab@bc9e5ffb51ea0f0ad3fcc2d03321fec2fc27beef) ([merge request](gitlab-org/gitlab!128967))
- [gitaly: Update server version to include memory leak fix](gitlab-org/gitlab@ad470b039176a057a8fc72d54670f8fb61eba9ea) ([merge request](gitlab-org/gitlab!129585))
- [Fix focus on vulnerability details comment](gitlab-org/gitlab@4beaaf93b285023eaa6f5ec18261638a656be4e4) ([merge request](gitlab-org/gitlab!129267)) **GitLab Enterprise Edition**
- [Fix CI catalog loading state](gitlab-org/gitlab@81b53d17fb7d8d796098c14d8535b385ff596af8) ([merge request](gitlab-org/gitlab!129509)) **GitLab Enterprise Edition**
- [Redirect API requests to moved projects](gitlab-org/gitlab@fa19b60b7f337ec7ce8290c3cd842fe975a8498e) ([merge request](gitlab-org/gitlab!128642))
- [Only check valid changes during diff checks](gitlab-org/gitlab@c2cf8824700857ed2ef8558c77286d8c253799b6) ([merge request](gitlab-org/gitlab!129465))
- [Compare page same branch fix](gitlab-org/gitlab@383018a514489eca90097b42a4a50f0fd4abda38) ([merge request](gitlab-org/gitlab!129227))
- [Remove autosaved drafts when the note entry form is cancelled](gitlab-org/gitlab@e36cd9295a831713a77abc1de5f42137da0caf49) ([merge request](gitlab-org/gitlab!129437))
- [Disable max allowed looks check for Geo counters](gitlab-org/gitlab@fd59f3a259b556794423829de93e63ed10915128) ([merge request](gitlab-org/gitlab!129316)) **GitLab Enterprise Edition**
- [Fix deploy freeze table alignment](gitlab-org/gitlab@263febade580dad37f07f957ba05accff2e7cb4f) ([merge request](gitlab-org/gitlab!129421))
- [Fix missing SBOM component link](gitlab-org/gitlab@8706cc1e60600fa99d21112be528b59ccba542a2) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/128111)) **GitLab Enterprise Edition**
- [Escape special characters while searching for an SBOM occurrence](gitlab-org/gitlab@0f9a02c87edcdde779691f6e056b9b54225527a1) ([merge request](gitlab-org/gitlab!129361)) **GitLab Enterprise Edition**
- [Fix blockedByCount GraphQL field](gitlab-org/gitlab@ae128928c1b10d034ca82da5bf663e354c8c4ee9) ([merge request](gitlab-org/gitlab!129358))
- [Fix error reporting when user is not authorized](gitlab-org/gitlab@a4bc9c327e7f015b423cbbd15369e56f0686c396) ([merge request](gitlab-org/gitlab!129346))
- [Improving membersQuery for indirect and group relationships](gitlab-org/gitlab@c950c220a357d8133f7a024a73e419cc5afc9424) ([merge request](gitlab-org/gitlab!129017))
- [Add support for bot users in Dependency Proxy authentication](gitlab-org/gitlab@f4437be4b31205288adba0d73c102d9653e6995a) ([merge request](gitlab-org/gitlab!128583))
- [Use the denormalized attributes to query SBOM occurrences](gitlab-org/gitlab@c2b070356b2fc07bc97a0d48c4f81a0fdd04320b) ([merge request](gitlab-org/gitlab!128898))
- [Show inherited group members when flag is number](gitlab-org/gitlab@01d592f89d82336cbe85a12e415634a8b9f67573) ([merge request](gitlab-org/gitlab!129276)) **GitLab Enterprise Edition**
- [Namepace email address label](gitlab-org/gitlab@60c01ede9ed8b59b437a1394a3226e4aa0b4e132) ([merge request](gitlab-org/gitlab!129291))
- [Link license report to the correct pipeline](gitlab-org/gitlab@5bf026b4357126061df322c874b9521b35d75af8) by @AaronDewes ([merge request](gitlab-org/gitlab!126621)) **GitLab Enterprise Edition**
- [What's New entries show 21st rather than 22nd](gitlab-org/gitlab@7f81f42c78a2791e9b7efb5f0d9fa34b60e30317) ([merge request](gitlab-org/gitlab!129233))
- [Fix tab background color on MR tabs when Sourcegraph enabled](gitlab-org/gitlab@e12645610f57fb84689bf1a7896bea50e3b5d9d2) ([merge request](gitlab-org/gitlab!129226))
- [SAML Group Sync with multiple providers](gitlab-org/gitlab@5007d586700a932eaa2beda7231a0099dffd9e3f) ([merge request](gitlab-org/gitlab!123884)) **GitLab Enterprise Edition**
- [Fix MR analytics label search for large groups](gitlab-org/gitlab@2c7c89db84110e2b09a5d3193c10a389d3a69e41) ([merge request](gitlab-org/gitlab!128948)) **GitLab Enterprise Edition**
- [Fix missing vue injection with group issue list](gitlab-org/gitlab@eb2fcfcc33de5bf9c6ed4c4187a92f9e150418e7) ([merge request](gitlab-org/gitlab!129180))
- [Add updated hook to packages shared title area component](gitlab-org/gitlab@949d23304279fa956b3789aee7fdd6b7cc66d7b8) ([merge request](gitlab-org/gitlab!128957))
- [Cancel old requests in group select to avoid old data](gitlab-org/gitlab@12a5991aa8898ef674c6500b752298b7b2e794b4) by @fenyuluoshang ([merge request](gitlab-org/gitlab!126836))
- [Revert "Return LFS URL in blob.external_storage_url if lfs_blob?"](gitlab-org/gitlab@d262c41b2a7be6028c23cdd5001caca6eb60a9e2) ([merge request](gitlab-org/gitlab!129096))
- [Update requirements drawer](gitlab-org/gitlab@b8ada822784e0e07bf86146524d17c148741585c) ([merge request](gitlab-org/gitlab!128940))
- [Only expose valid custom notification settings](gitlab-org/gitlab@921b0a5da11124dc8a7d8902b31a925bfbd3850b) ([merge request](gitlab-org/gitlab!129078)) **GitLab Enterprise Edition**
- [Fix hash highlighting for .json files](gitlab-org/gitlab@241d6a78bf4e4c3b2031d848d1b7ef5f828bad69) ([merge request](gitlab-org/gitlab!128647))
- [Repair admin tag runner sorting with relative url mounts](gitlab-org/gitlab@45d1892ec20969d167db749682d50d3f4bb26964) by @markus.ferrell ([merge request](gitlab-org/gitlab!125567))
- [Ignore tag pipeline for scan result policy comparison](gitlab-org/gitlab@afdba703454852aa8526f3aff0e8f724bc3de4d6) ([merge request](gitlab-org/gitlab!128534)) **GitLab Enterprise Edition**
- [Making the LFK DeletedRecords fetching query faster](gitlab-org/gitlab@38511c092a70b136edaa7d755971bf174b61b5fc) ([merge request](gitlab-org/gitlab!128759))
- [Render GFM content in vulnerability description](gitlab-org/gitlab@e120153952fe2b462706882383a70c2f6771839e) ([merge request](gitlab-org/gitlab!128604)) **GitLab Enterprise Edition**
- [Do not emit user messages by default](gitlab-org/gitlab@2fccac7ec044d17a746d859e903e30c8d154e65c) ([merge request](gitlab-org/gitlab!128994)) **GitLab Enterprise Edition**
- [Include descendant shares in user autocomplete](gitlab-org/gitlab@308370a787f25d8f30e2d1c565b59677e87acb01) ([merge request](gitlab-org/gitlab!129005))
- [Fix Emoji button svg alignment](gitlab-org/gitlab@37b06c99f8f4d4969e8a48a09e4afc9af59b7643) ([merge request](gitlab-org/gitlab!129000))
- [Fix the epics endpoint used by the filtered search bar](gitlab-org/gitlab@224d2922a88f953f2554e9e98a459d0a12286a1c) ([merge request](gitlab-org/gitlab!128278)) **GitLab Enterprise Edition**
- [Enable Google Syndication CSP on registration flow](gitlab-org/gitlab@6acda1ae6b3e5d57081a62da6af1021e14571494) ([merge request](gitlab-org/gitlab!128478))
- [Fix limit view of Direct transfer max file size](gitlab-org/gitlab@d38a53c898023582ed25f8678579d6d3140aca4a) ([merge request](gitlab-org/gitlab!128952))
- [Fix queue Elasticsearch indexing when branch changes for repo](gitlab-org/gitlab@814b91be037d9f95c5a3b119be4cb673550a3b73) ([merge request](gitlab-org/gitlab!127405)) **GitLab Enterprise Edition**
- [Remove trial button from free biling page if trialed before](gitlab-org/gitlab@614a23680f8a5d6a520b561caadd0bd17d8a091b) ([merge request](gitlab-org/gitlab!128925)) **GitLab Enterprise Edition**
- [Fix deleting job artifact objects](gitlab-org/gitlab@e190d39ce871210ceafe3a7a6a4ead4e23228737) ([merge request](gitlab-org/gitlab!128279))
- [Fix(Subscription): fix activation form](gitlab-org/gitlab@1fccc9ffe48654ed3d47691c58beb6912e9e607a) ([merge request](gitlab-org/gitlab!128893)) **GitLab Enterprise Edition**
- [Allow using Service Accounts for HTTP Basic Authentication for Git](gitlab-org/gitlab@cb64970cc1e81ffbe1430f5409da66ed2e4ab45d) ([merge request](gitlab-org/gitlab!127615)) **GitLab Enterprise Edition**
- [Include subgroup and project users in autocomplete](gitlab-org/gitlab@e6178cd1e764752cea8b48a7fc0eb7a1d181b577) ([merge request](gitlab-org/gitlab!128255))
- [Respect relative root for MLflow package URLs](gitlab-org/gitlab@a0d4f6e02c97bfd94de9e33f439ea99203d5a557) ([merge request](gitlab-org/gitlab!128644))
- [Group/Project name overflow fix](gitlab-org/gitlab@04385742ea786a0e2ac733c02d77d60957e1cf72) ([merge request](gitlab-org/gitlab!128877))
- [Fix searches for Upgrade Status to act on runner manager versions](gitlab-org/gitlab@2406f6c2e580ae203899e0912d2f47a8f968ed9d) ([merge request](gitlab-org/gitlab!128625))
- [Fix target projects path](gitlab-org/gitlab@6ea5432d748981f87dd4da432e1ff2ace005526e) ([merge request](gitlab-org/gitlab!128745))
- [Markdown Editor: Fix height change](gitlab-org/gitlab@7f6daadb4350667bb6602644bcdc64d43b40cf70) ([merge request](gitlab-org/gitlab!128467))
- [Fix issues finder when filtering by project](gitlab-org/gitlab@6a6869432a67bc308a88492b4bcdd87aef780148) ([merge request](gitlab-org/gitlab!128859))
- [Fix lock_on_merge migration](gitlab-org/gitlab@0d272e324b88eed53ff207f2c27fa97b144bb201) ([merge request](gitlab-org/gitlab!128830))
- [Change in_reply_to_discussion_id parameter to string](gitlab-org/gitlab@4eca214c05de0268a122bd6ef8b4ec44119d2aab) ([merge request](gitlab-org/gitlab!128794))
- [Remove orphaned approval project rules after transfer](gitlab-org/gitlab@68a9a2c7cf17d58b9cd7bbc2d0a0b0c17674a238) ([merge request](gitlab-org/gitlab!127767))
- [Revert "Remove log_response_length feature flag"](gitlab-org/gitlab@db5daba111a01f1c53088cdb166e14f0381bc0bf) ([merge request](gitlab-org/gitlab!128762))
- [Fix deleting job artifact objects](gitlab-org/gitlab@ebe20bdbcf122ab1882c542912262ceabd70023c) ([merge request](gitlab-org/gitlab!129214))
- [Fix flaky test on CI](gitlab-org/gitlab@236e0d02e2f31f29782af9e5ae20c304ed2c3c24) ([merge request](gitlab-org/gitlab!128663))
- [GraphQL: Fix N+1 query for CiRunner.managers field](gitlab-org/gitlab@f507b9ca5c8750ae6411d11367ba289ea57928f5) ([merge request](gitlab-org/gitlab!128283))
- [Fix `branch_exceptions` for `branch_type: protected`](gitlab-org/gitlab@6647d0ddec3df65420f440153ce84796355bfe45) ([merge request](gitlab-org/gitlab!128235)) **GitLab Enterprise Edition**
- [Fix group templates tab load](gitlab-org/gitlab@2789e3a880d4e80bf0d26ad189a9b7212c567df2) ([merge request](gitlab-org/gitlab!128270)) **GitLab Enterprise Edition**
- [Fix max number of slices](gitlab-org/gitlab@cfcbaae3ee5bb24c1fd82a47aa594d637b5f23b0) ([merge request](gitlab-org/gitlab!128488)) **GitLab Enterprise Edition**
- [User preferences: Fix AI settings sections](gitlab-org/gitlab@4b811cae0c6157e52622a04329b632b64d0c3556) ([merge request](gitlab-org/gitlab!128346))
- [Fix allow_descendants_override_disabled_shared_runners in database](gitlab-org/gitlab@c798eabe01838c0fb3328a45dbb33dd1f5b6d6bd) ([merge request](gitlab-org/gitlab!128112))
- [Put back broadcast messages to sign-in page for self-hosted](gitlab-org/gitlab@88594f6a01fd30889df52508c80f56780e4a06a6) ([merge request](gitlab-org/gitlab!128234))
- [Fix N+1 query in MR pipelines. Also fix N+1 testing documentation](gitlab-org/gitlab@81dad0ee2f83cd1408b95d22763de686f09c43ad) ([merge request](gitlab-org/gitlab!128097))
- [Change labels for token access settings](gitlab-org/gitlab@fc278effb652ebe881324ecca30828f94acf9f79) ([merge request](gitlab-org/gitlab!126894))
- [Add a migration to reindex on the basis of schema_version](gitlab-org/gitlab@c78d7cbdcfd95bbbfdbd58982c73c98d9b631b86) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/128043)) **GitLab Enterprise Edition**
- [Update the `namespace_id` of `vulnerability_reads` when project moves](gitlab-org/gitlab@2a06c4eacacbed87bce31a78b2197e4e81884060) ([merge request](gitlab-org/gitlab!127649)) **GitLab Enterprise Edition**
- [MR Pipeline widget: Fix view app dropdown behind other elements](gitlab-org/gitlab@74a4741b4325e1f1303fc47b02a396c12952263e) ([merge request](gitlab-org/gitlab!128470))
- [Require term param for search/autocomplete](gitlab-org/gitlab@617e1fef90a5347364e4edfd068962b52a940015) ([merge request](gitlab-org/gitlab!128537))
- [Allow Starter customers to use ApprovalRules API](gitlab-org/gitlab@a91708a1200d1cb1ffb22b0fa3f6a483825d3aad) ([merge request](gitlab-org/gitlab!128516)) **GitLab Enterprise Edition**
- [Always allow re-dismissing a vulnerability](gitlab-org/gitlab@d71d9c82534a63601e88820769e22ea544ab0686) ([merge request](gitlab-org/gitlab!128159)) **GitLab Enterprise Edition**
- [Make artifacts dropdown refetch list on show at 'Pipelines'](gitlab-org/gitlab@8155d95bfcb3acf71143d9aa05bc2004f92de7b3) by @av3f ([merge request](gitlab-org/gitlab!122962))
- [Support nuget version normalization](gitlab-org/gitlab@027bf0231cea7ddd6d86183241ac4fb9f11d89db) ([merge request](gitlab-org/gitlab!121260))
- [Change email validation regex to use Devise email regex](gitlab-org/gitlab@9d503d783ef4291a536932fdeef790d5ef68a39d) ([merge request](gitlab-org/gitlab!128471))
- [Downcase email before using it to generate confirmation token](gitlab-org/gitlab@b7ca8f08db99e9bb0d84c83ceaace01ad8e6caec) ([merge request](gitlab-org/gitlab!128457)) **GitLab Enterprise Edition**
- [stylesheets: Re-increase font-size of gl-emoji](gitlab-org/gitlab@c4167290e236223bbc4f46c678fcc026bb077049) ([merge request](gitlab-org/gitlab!128441))
- [Fix Container Scanning invalid pkg manager types](gitlab-org/gitlab@d5986ecfc6ccf0a60d2f161ce308666469683c4f) ([merge request](gitlab-org/gitlab!128385)) **GitLab Enterprise Edition**
- [Promote ffaker gem to production](gitlab-org/gitlab@38a9c9d208f3d2367ef1713caa16eb0135d3effb) ([merge request](gitlab-org/gitlab!128404))
- [Fix scheduled scan execution policies is applied to incorrect branches](gitlab-org/gitlab@408c48a34a342157740b831da6030cc69fac7bcc) ([merge request](gitlab-org/gitlab!128166)) **GitLab Enterprise Edition**
- [Remove hierarchy validation for promote_to quick action](gitlab-org/gitlab@f414a6b292ba49149d331c7aa6829cf4ab1a9cba) ([merge request](gitlab-org/gitlab!128393))
- [Include CodeQuality MR Widget in CE](gitlab-org/gitlab@80c4a7b9d8e0c4f7c0e964b0f36bffe04159d913) ([merge request](gitlab-org/gitlab!128349))
- [Fix checkbox to url mapping](gitlab-org/gitlab@ec7ef2b4850678547febd46534aa4d598e97db63) ([merge request](gitlab-org/gitlab!128107))
- [Fix CI_PAGES_URL when pages unique domain enabled](gitlab-org/gitlab@6c0434da45dd9b7d4ad0abb22ebd22621c13ee5a) ([merge request](gitlab-org/gitlab!128248))
- [Add LFS warning popup for deleting files](gitlab-org/gitlab@7ea0430201d155a77db1827b829d16a79c9eddb1) ([merge request](gitlab-org/gitlab!127859))
- [Fix variable name for secret detection options](gitlab-org/gitlab@cdbcbdbbd5bb6b1dd022c4eef9750966153ddf91) ([merge request](gitlab-org/gitlab!128350)) **GitLab Enterprise Edition**
- [Fix truncate_legacy_tables for detached partitions](gitlab-org/gitlab@2d626f323d21b31ba6108a407e7278cbdd5041c1) ([merge request](gitlab-org/gitlab!128093))
- [Align test coverage tooltip on center of indicator](gitlab-org/gitlab@1e9a29f232db5e9b8f5135341a35166dd3f0b658) by @glauciellesa ([merge request](gitlab-org/gitlab!126143))
- [Don't proxy batch request for LFS](gitlab-org/gitlab@6f69d1148eb44cb4904875e142ec72e06f5a751e) ([merge request](gitlab-org/gitlab!122258)) **GitLab Enterprise Edition**
- [Remove the feature gate on the VSD config setting](gitlab-org/gitlab@6d7529194afc42e108fc5e57d61d2abe3023b5b7) ([merge request](gitlab-org/gitlab!128280)) **GitLab Enterprise Edition**
- [Fix global search modal input Home/End behaviour](gitlab-org/gitlab@83bf5db49348eaead6f485b82da139f3aba6907b) ([merge request](gitlab-org/gitlab!127976))
- [Fix bug in #git_diff_prefix regex](gitlab-org/gitlab@73ca44520eb1822cb94697dc655277304ade0c95) ([merge request](gitlab-org/gitlab!128265))
- [Fix settings for newly created incides](gitlab-org/gitlab@2a248c02fe7b3fdad8ab43529940ea58964e9e1a) ([merge request](gitlab-org/gitlab!128098)) **GitLab Enterprise Edition**
- [Fix tooltips in workspaces actions](gitlab-org/gitlab@1fa57eb91583d688d90e31371e81d72d8091204f) ([merge request](gitlab-org/gitlab!128239)) **GitLab Enterprise Edition**
- [Maintain work_items when projects gets archived/unarchived](gitlab-org/gitlab@e7fa5b4ac8725eb24c4e2b1b01b13ca86b95ac9f) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/127995)) **GitLab Enterprise Edition**
- [Fixes the OpenAPI blob viewer](gitlab-org/gitlab@e9a06c2f89a555dde159f04b59c3a828c0484d92) ([merge request](gitlab-org/gitlab!128224))
- [Fix merge train merge failed when check_mergeability obtain lock error](gitlab-org/gitlab@4b5a28dc32273457e4e45e17577aee08d1551068) by @zhanglinjie ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/128202)) **GitLab Enterprise Edition**
- [Fixes flex property of package tags in smaller screen sizes](gitlab-org/gitlab@2e05cafd13210e9c6bab1077e5d7d921f1c3ab86) ([merge request](gitlab-org/gitlab!128201))
- [Fix artifacts object storage geo replication](gitlab-org/gitlab@cf7d938328fc7d3ed75c520c8f58682f971e4983) ([merge request](gitlab-org/gitlab!127733))
- [Allow capturing uniqueness error](gitlab-org/gitlab@3195b90c5781f07bc3f3ebccd8de8bd3916972d8) ([merge request](gitlab-org/gitlab!124025)) **GitLab Enterprise Edition**
- [Align trial illustration when on fluid layout ](gitlab-org/gitlab@50413ad47c425714547be222fa6dc83bada98402) ([merge request](gitlab-org/gitlab!127416))
- [Fix Query.vulnerabilitiesCountByDay always returning nil data](gitlab-org/gitlab@e3241e54ed2fe85936f3dc7b347bdd28ad5910a5) ([merge request](gitlab-org/gitlab!127913)) **GitLab Enterprise Edition**
- [Return description field in nuget package catalog entry](gitlab-org/gitlab@70ab9fedb309f85b9c6eb6b7d478f6bf5f26ba63) ([merge request](gitlab-org/gitlab!128125))
- [Use _path helpers instead of _url helpers](gitlab-org/gitlab@e37757e5e324345087ddb3eb7169d0f137a67bc6) ([merge request](gitlab-org/gitlab!127890))
- [Reduce the number of components created in each transaction](gitlab-org/gitlab@1cecb3207b7fef7e30e681b4690fbff3af8d1bf0) ([merge request](gitlab-org/gitlab!128026)) **GitLab Enterprise Edition**
- [Fix UX issues with the label](gitlab-org/gitlab@2fb695dcea1c117cba2f2fa027a5b3f3b22389e9) ([merge request](gitlab-org/gitlab!127327))
- [Check :code_suggestions licensed feature for SM](gitlab-org/gitlab@3d25ca638bfcafe31aad4c61040299fc099447fd) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/127992)) **GitLab Enterprise Edition**
- [Update Ruby system version check for 3.0](gitlab-org/gitlab@14c4a3b7a3f6a4ad3f7972ca68c24e4d60d7e0a3) ([merge request](gitlab-org/gitlab!128000))
- [Add includeSourceCode to `ExplainVulnerability` cache key](gitlab-org/gitlab@4a3408829105a9ac72de8f29df64dee6de5e02cc) ([merge request](gitlab-org/gitlab!127261)) **GitLab Enterprise Edition**
- [Show Code Suggestions settings only on licensed EE](gitlab-org/gitlab@74a15aa18e47d7b4f38428243d992eb02a631e01) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/127507)) **GitLab Enterprise Edition**
- [Remove duplicate relative url in package registry](gitlab-org/gitlab@3dc1f569ea71e5c65b3908f0da0ade2d527279e5) by @bymayanksingh ([merge request](gitlab-org/gitlab!127931))
- [Fix restrict_user_defined_variables restriction on pipeline schedules](gitlab-org/gitlab@bbfd2650f9942e5dde3ec5086997f8c137dd0509) ([merge request](gitlab-org/gitlab!127456))
- [Fix group path update validations](gitlab-org/gitlab@60725e58716a332994c5e6ca7f8422413ac66df8) ([merge request](gitlab-org/gitlab!127164))
- [Allow frontend to access LFS file storage URL](gitlab-org/gitlab@7906e722ce6d47e365d7b641143d1b5d0c991f1b) ([merge request](gitlab-org/gitlab!127059))
- [Allow cube proxy to handle 'continue wait' requrests](gitlab-org/gitlab@4b96a18989583916a1bde96f778500f022937956) ([merge request](gitlab-org/gitlab!127885))
- [Fix push rules validation on initial push](gitlab-org/gitlab@ef60479a463284ed48f24df9e7a96fe99ff8d0f2) ([merge request](gitlab-org/gitlab!127877))
- [Surfaces error in interpolation inputs when header does not exist](gitlab-org/gitlab@b9c17fea35ceb8a40fd36873abe3b6c481ee0576) ([merge request](gitlab-org/gitlab!127490))
- [Emoji Picker: Add hover state to tabs](gitlab-org/gitlab@6dbb8ea75686023293df9a0b212d50981d27913d) ([merge request](gitlab-org/gitlab!127844))
- [Correctly delete todos when group is made private](gitlab-org/gitlab@3af0b159deae962aed1ee7a670eb7f5d313bf367) ([merge request](gitlab-org/gitlab!127818))
- [fix: Drop unnecessary unique index on vulnerability_signatures](gitlab-org/gitlab@12ded410b7dac2fa2a08e25ec215f41c1579afd8) ([merge request](gitlab-org/gitlab!127796))
- [Avoid 6 hours of stale Geo status](gitlab-org/gitlab@98bb3e9ab7fe1cc02b7c9cd7297be20dfce6119a) ([merge request](gitlab-org/gitlab!127810)) **GitLab Enterprise Edition**
- [Remove feature flag](gitlab-org/gitlab@288374f0faf440a2ec5f359de91c1693c263b9a2) ([merge request](gitlab-org/gitlab!127519))
- [Fix UX issues with the label](gitlab-org/gitlab@6d69f249bbb0ab9747b466709c389bb7264bf99b) ([merge request](gitlab-org/gitlab!127495))
- [Allowing external guest account to pull docker images from the registry](gitlab-org/gitlab@e83a0812c3d4e2f6c35b2302cca9433f11df459f) ([merge request](gitlab-org/gitlab!126136))
- [Remove slicing and reduce batch size in migration](gitlab-org/gitlab@aeaab3c3bf1a9a0c087d2dcd0eddec9dfc9d2bd5) ([merge request](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/127623)) **GitLab Enterprise Edition**
- [Hide protected pipeline job retry/cancel btns](gitlab-org/gitlab@21249c1ace9a568b13dcb586f121aa46efff2d28) ([merge request](gitlab-org/gitlab!127267))
- [Remove include:rules from the Security/BAS template](gitlab-org/gitlab@b57f740c7e8b75fd5737a5f2c04ba029d942eb5d) ([merge request](gitlab-org/gitlab!127729))
- [Add non negative validation to time estimate quick action](gitlab-org/gitlab@f7d2af8c39d5444b101973ef1da522caa8ead056) by @missy-davies ([merge request](gitlab-org/gitlab!126609))
- [Exclude projects pending deletion from group visibility level validation](gitlab-org/gitlab@6d3867c7719f4edd1742321cf71c7155546df6be) ([merge request](gitlab-org/gitlab!126823))
- [Allow guest users to subscribe work items](gitlab-org/gitlab@10a2bb8479984c71c34ae65956b5959595a6017b) ([merge request](gitlab-org/gitlab!127137)) **GitLab Enterprise Edition**
- [Fix impersonation button availability in admin area](gitlab-org/gitlab@4df76e62c0e0629149213ffd4806fa3df02a9e0b) by @Taucher2003 ([merge request](gitlab-org/gitlab!126616))
- [Fix wrapping buttons on commits page](gitlab-org/gitlab@c43b0955ab0a36c79ca330969c6ccb00bca4b0e0) by @glauciellesa ([merge request](gitlab-org/gitlab!125882))
- [Do not store chat messages by default](gitlab-org/gitlab@3822cfb10a4f3f4c037fa348e732f8445586f058) ([merge request](gitlab-org/gitlab!127511)) **GitLab Enterprise Edition**
- [Render textual LFS files in UI](gitlab-org/gitlab@4dcc6478fa15382da2d153d4eea05db9e9a5275d) ([merge request](gitlab-org/gitlab!127135))
- [Add non negative validation to time estimate rest api endpoint](gitlab-org/gitlab@90616bc42238ea552c94343f593ad6700c976dfd) by @missy-davies ([merge request](gitlab-org/gitlab!126620))
- [Show correct push instructions for a forked MR](gitlab-org/gitlab@cd8902d3e5cdc8939ae91e6ac9e080e42aa8e4d4) ([merge request](gitlab-org/gitlab!127173))
- [Add space between project housekeeping buttons](gitlab-org/gitlab@a17d7722c93571533be6daf59e9fa046be3a4ce2) ([merge request](gitlab-org/gitlab!127413))
- [Allow `report_source` to be nil when delegating packager](gitlab-org/gitlab@02d940f568d2e8b2d95d562b076705e88ddc98af) ([merge request](gitlab-org/gitlab!127489)) **GitLab Enterprise Edition**
- [Prevent triggering explain code on file names](gitlab-org/gitlab@d1a1779e180bc1f4b1e70f0430a2514baddd65d8) ([merge request](gitlab-org/gitlab!127367))
- [Add negative validation to estimate mutations](gitlab-org/gitlab@29c6918f3adc5995c0d1fb26bfb54bbeab1a8065) by @missy-davies ([merge request](gitlab-org/gitlab!126619))
- [Disable IAT verification by default](gitlab-org/gitlab@f326916f14aed93ff4f0a50d7d87beb7947e35ff) ([merge request](gitlab-org/gitlab!127395))
- [Fix issues caused by ambiguous refs](gitlab-org/gitlab@4b5260a849382701449c53e7dfa25579f3bb7b94) ([merge request](gitlab-org/gitlab!122145))
- [Only allow group owners to query environment scopes](gitlab-org/gitlab@98e59130692ae22ac3257d31ef8800df3d4aa3d8) ([merge request](gitlab-org/gitlab!127384))
- [Fix set/edit status button on old navigation](gitlab-org/gitlab@bd144f8474229f3dfb031bc4f8d98ac7949eed31) ([merge request](gitlab-org/gitlab!127239))
- [Fix the N+1 query issue for Vulnerability#hasRemediations field](gitlab-org/gitlab@6c567a5e335837f595fcb915d3e3759c71045343) ([merge request](gitlab-org/gitlab!127347)) **GitLab Enterprise Edition**
- [Fix auto-scrolling to hash on Markdown files](gitlab-org/gitlab@1b7b6db5fbd1c7acfb5e2cfe39e82c9049a701af) ([merge request](gitlab-org/gitlab!127328))
- [Ignore approval rules from policies when importing/exporting project](gitlab-org/gitlab@7ca61eaf5d1ba0adf6113a02c7e4c85b89a06bcd) ([merge request](gitlab-org/gitlab!127176)) **GitLab Enterprise Edition**
- [Fix crash when LDAP CA file set outside tls_options](gitlab-org/gitlab@e864c33029a4bdc9be7dc9858028b93c2860cc96) ([merge request](gitlab-org/gitlab!127290))
- [Fixes container registry image list sorting UI inconsistency](gitlab-org/gitlab@9d94facbc3ae8ccf7f892e8a571a36f01b754b33) ([merge request](gitlab-org/gitlab!126651))
- [Use root_ref to get last commit for index integrity](gitlab-org/gitlab@55fd57694b785553096113da33d03ef5e51349a0) ([merge request](gitlab-org/gitlab!127246)) **GitLab Enterprise Edition**
- [Fix "pending deletion" badge](gitlab-org/gitlab@552d8c191d73f9be3891292c02941d4a89b3f583) ([merge request](gitlab-org/gitlab!127251))
- [Apply user timezone to date headers in commits list](gitlab-org/gitlab@0b61e4b1e2cb6c08e6f980d6303b9bd2b453469f) ([merge request](gitlab-org/gitlab!126472))
- [Add spacing between approval checkbox and textarea](gitlab-org/gitlab@3bec7ed94e24b87bb81e0ce0291fbd702488d52d) ([merge request](gitlab-org/gitlab!127233))
- [Update GitHub Importer Client Pool to include main token](gitlab-org/gitlab@b3dfd3873a455f43487aebedbdd0c42aa8590b26) ([merge request](gitlab-org/gitlab!127213))
- [Display labels description and scoped labels for epics on roadmap](gitlab-org/gitlab@0a575aeb757012314b7b5bba50e75f04c2f90aed) ([merge request](gitlab-org/gitlab!126709)) **GitLab Enterprise Edition**
- [Fix deployments waiting for user actions are marked as "created"](gitlab-org/gitlab@f35e854e48f3551026a532c3e5b29d18dbefc907) ([merge request](gitlab-org/gitlab!125659))
- [Fix converting issue to incident](gitlab-org/gitlab@534da7532787f4a886d3dea6afaa4fbc0e1c2f33) ([merge request](gitlab-org/gitlab!126913))
- [Tooltip for long labels on Labels list](gitlab-org/gitlab@05ba1c97503ee44a143de5cea06f1dbbb15a65b8) by @endera_ ([merge request](gitlab-org/gitlab!126258))
- [Backfill missing vulnerability dismissal information](gitlab-org/gitlab@19274fac01c60b4d3b31308e2cc41d43b677fde0) ([merge request](gitlab-org/gitlab!126253))
- [Fix wrong default licenses saved in package_metadata ingestion](gitlab-org/gitlab@a1692e2f227d9dffdf3f2ce727a2370e126d73fe) ([merge request](gitlab-org/gitlab!126887))
- [Fix repository push error message](gitlab-org/gitlab@af2a9da12e96e9f455238131212e53c80fe7bfa6) ([merge request](gitlab-org/gitlab!125408)) **GitLab Enterprise Edition**
- [Show archived projects from subgroups](gitlab-org/gitlab@3c2a5431e8dc39ed5431b2670a11a70f15c2b9e7) ([merge request](gitlab-org/gitlab!127148))
- [Sync approval rules for group policies when transferring a project](gitlab-org/gitlab@028b294cfde9d3a1b88cea2a60016995e250046b) ([merge request](gitlab-org/gitlab!127123)) **GitLab Enterprise Edition**
- [Remove work item input backgrounds in dark mode](gitlab-org/gitlab@9141acbb7557bcb601b245d929e075cdd90bc7af) ([merge request](gitlab-org/gitlab!126425))
- [Fix system note permissions check](gitlab-org/gitlab@b093e7410bcf89c0134fe8ac19e13507d5b89ec3) ([merge request](gitlab-org/gitlab!127097))
- [Fix index creation to detect if index exists](gitlab-org/gitlab@41694bf6c3e187d3b0e9f11a2d41611e33493999) ([merge request](gitlab-org/gitlab!127067))
- [Fix canApprove GraphQL field returning null](gitlab-org/gitlab@412e4c6ffada3bd72b9b7e1aa15eb973e14324a3) ([merge request](gitlab-org/gitlab!127068))
- [Fix list style types in rich text and preview](gitlab-org/gitlab@038ffaa42936093d550894cc69ef209dc27e8bd9) ([merge request](gitlab-org/gitlab!127039))
- [Autofocus the editors when switching between them](gitlab-org/gitlab@3f5dce6f0243cf528a990587a007da49b8821f30) ([merge request](gitlab-org/gitlab!126974))
- [Improve query in Projects::ParticipantsService](gitlab-org/gitlab@e698b3c8d02013710113607f8cd46001eea03817) ([merge request](gitlab-org/gitlab!126815))
- [Fix completion of pending direct upload](gitlab-org/gitlab@a3e85ceeaf897759a5123a6740b8e4efb118c4cd) ([merge request](gitlab-org/gitlab!127017))
- [Clear GroupIndexStatus in clear_index_status rake task](gitlab-org/gitlab@f36234263fd8647ef2019a525c546cf09448456b) ([merge request](gitlab-org/gitlab!127007)) **GitLab Enterprise Edition**
- [Allow pasting a markdown block](gitlab-org/gitlab@a2119edeeb223bb25e11d3db1f352f96ab55b297) ([merge request](gitlab-org/gitlab!126993))
- [Autofocus the editor when commenting on a diff](gitlab-org/gitlab@55ce3a48958508257245a99f5f0dcf4ce33e4001) ([merge request](gitlab-org/gitlab!126978))
- [Fixes container registry tags list sorting UI inconsistency](gitlab-org/gitlab@877cfd9fbbe68f2dc069b86e9b4704b592051b3f) ([merge request](gitlab-org/gitlab!125982))
- [Ensure components are ingested in a consistent order](gitlab-org/gitlab@4e35f90c95940f68d143568db3b0784de432fb6f) ([merge request](gitlab-org/gitlab!126898)) **GitLab Enterprise Edition**
- [Fix label on token name field](gitlab-org/gitlab@05a3f1332cf6e6fd01d8e6b5fa1a89d3b686e804) by @Taucher2003 ([merge request](gitlab-org/gitlab!126614))
- [Fix shadows and scrims in dark mode](gitlab-org/gitlab@b62b7551efb2aa7b04b0ca28210edd4dc6561e61) ([merge request](gitlab-org/gitlab!125507))

### Changed (265 changes)

- [Sort admin runners by runner machine upgrade status](gitlab-org/gitlab@7553611c42622285b02c886a7922cb36cdb7ef54) by @markus.ferrell ([merge request](gitlab-org/gitlab!128809))
- [Add search attribute to zoekt indexed namespaces](gitlab-org/gitlab@4d4b3f9a997c882144f1fac6c2f8c58ab46cf82b) ([merge request](gitlab-org/gitlab!128835))
- [Do not include min_access_level for admins](gitlab-org/gitlab@f339e2b4a8bf8396d0d943e9a5d5a7d952825dee) ([merge request](gitlab-org/gitlab!129229))
- [Use skeleton loader while waiting for discussion summary](gitlab-org/gitlab@7563990e5c756615f75d6b9778832a9ab2d0679a) ([merge request](gitlab-org/gitlab!128875)) **GitLab Enterprise Edition**
- [Send review request email to new reviewers](gitlab-org/gitlab@8916f91426f657f282e37b0f8f83519ee3e9fc0c) ([merge request](gitlab-org/gitlab!127872))
- [Renamed explain vuln experiment to beta](gitlab-org/gitlab@9729126a5bb4cb26c85937ea3f26c95522fa5534) ([merge request](gitlab-org/gitlab!128660)) **GitLab Enterprise Edition**
- [Remove protected ref check from integrations google play v2 ](gitlab-org/gitlab@f9d999fca8cfce267346b452245ab8bd4b209955) by @StevenMetz ([merge request](gitlab-org/gitlab!126392))
- [Use secondary text color for project settings subheaders](gitlab-org/gitlab@edbd52941c14f8d316ab43fff61349af1ed0d6f4) ([merge request](gitlab-org/gitlab!129030))
- [Add error field when visualization file missing](gitlab-org/gitlab@a588d4baa7e3d9b25c74aeffce4b67a4c77451d8) ([merge request](gitlab-org/gitlab!128883)) **GitLab Enterprise Edition**
- [This MR migrates legacy dropdown](gitlab-org/gitlab@d9f6f5175b702603e0c454d396937de3c70b7b73) ([merge request](gitlab-org/gitlab!129172)) **GitLab Enterprise Edition**
- [Trigger Microsoft Azure Group Sync for self-managed SAML sign-in](gitlab-org/gitlab@af3bb124c0bdb6ffdd1de2c63b20646d8fc56cf8) ([merge request](gitlab-org/gitlab!129023)) **GitLab Enterprise Edition**
- [Add max width to user settings inputs](gitlab-org/gitlab@3219c9fb35b64ccb7b35d471dba41569abdface7) ([merge request](gitlab-org/gitlab!129308))
- [Updated the Cargo.toml linker to support inline tables](gitlab-org/gitlab@9bffd82a94538a0e90d0898ae71ef6e2d1ff476d) by @Ian678 ([merge request](gitlab-org/gitlab!129029))
- [Prepare add-on purchase services to work without a namespace](gitlab-org/gitlab@8bb901a9b4759b72e58ffcb238dcd908f9819737) ([merge request](gitlab-org/gitlab!128899)) **GitLab Enterprise Edition**
- [Remove FF add_docker_distribution_manifest_list_v2_type_to_accept_header](gitlab-org/gitlab@6e2edfd3d60eee67f7ca7e331e1185ee8723a0ed) ([merge request](gitlab-org/gitlab!129447))
- [Use gitaly exception message](gitlab-org/gitlab@a5ef1d431f87497db3daeb5ca7ea724e204b4c30) ([merge request](gitlab-org/gitlab!128366))
- [Offer phone verification exemption for medium risk users](gitlab-org/gitlab@a4fb0565baccd2e43b7ad073535778552ee29f2a) ([merge request](gitlab-org/gitlab!128770)) **GitLab Enterprise Edition**
- [Add streaming to Anthropic client](gitlab-org/gitlab@9b6a105861e206bb40377448a8e3be3f6f64ee1a) ([merge request](gitlab-org/gitlab!129245)) **GitLab Enterprise Edition**
- [Update incident header layout](gitlab-org/gitlab@2d00863e18c275f16f800a148efd58bac9a7fc09) ([merge request](gitlab-org/gitlab!128922))
- [Remove recent_objects_for_project_statistics FF](gitlab-org/gitlab@837bf3290eb99abdb152f2a180df5e6170f216f2) ([merge request](gitlab-org/gitlab!128800))
- [Admin settings: Update description style](gitlab-org/gitlab@db8982fa6207053a238b0d5c6b68b09c57f5182a) ([merge request](gitlab-org/gitlab!129008))
- [Display all potential approval groups in policy drawer](gitlab-org/gitlab@81dba551653840483cc4f481ff8ca3ef119c1462) ([merge request](gitlab-org/gitlab!128129)) **GitLab Enterprise Edition**
- [Deploy keys settings: Use GlCard](gitlab-org/gitlab@16c7fb74ba04e5e1530b6668a28a7987beef7598) ([merge request](gitlab-org/gitlab!128888))
- [Group Advanced settings: Use GlCard](gitlab-org/gitlab@07afe518f6934a255e55e9a0aec0554b7d66f210) ([merge request](gitlab-org/gitlab!129085))
- [Move deploy tokens into card](gitlab-org/gitlab@bd3004822ecc92321253b78759d01fbfb17f617f) ([merge request](gitlab-org/gitlab!128678))
- [Add user info to jwt in container registry auth](gitlab-org/gitlab@ab25668fd7eadd14d0cf0b0c3019bde6d4725947) ([merge request](gitlab-org/gitlab!127622))
- [Disable rule mode for invalid vulnerability_attributes](gitlab-org/gitlab@3143c0fb95fcc166ef30e2c4c2a6d663370ff3a6) ([merge request](gitlab-org/gitlab!123398)) **GitLab Enterprise Edition**
- [Enable the compressed_package_metadata_query feature flag by default](gitlab-org/gitlab@143deb6a0865e8a9efa6b3bebf72a20f25655810) ([merge request](gitlab-org/gitlab!129262)) **GitLab Enterprise Edition**
- [Splits monthly and per-project data loading](gitlab-org/gitlab@a8605afb30cefe7c1e40f166b99b0b08a7aea337) ([merge request](gitlab-org/gitlab!121878)) **GitLab Enterprise Edition**
- [Use text secondary style for group settings subheaders](gitlab-org/gitlab@9516716aec9b53d3194e685eb1318bf5efa86213) ([merge request](gitlab-org/gitlab!129033))
- [Alerts settings: Use GlCard](gitlab-org/gitlab@57533f9e608533399465a40d64e898ef0676099a) ([merge request](gitlab-org/gitlab!128984))
- [Improve shared runners toggle for projects](gitlab-org/gitlab@dc1f4c8ffba56835325988528275036b44a023f5) ([merge request](gitlab-org/gitlab!128721))
- [Migrate metrics widget to V2](gitlab-org/gitlab@acd2719cadd1faf41bec07702187ba3c9a6c4491) ([merge request](gitlab-org/gitlab!127160)) **GitLab Enterprise Edition**
- [Compare results for scan_finding approval rules from multiple pipelines](gitlab-org/gitlab@a2e89e8878455f413aee43f92f3c4658b7a21c16) ([merge request](gitlab-org/gitlab!129146)) **GitLab Enterprise Edition**
- [Update deploy keys and tokens docs](gitlab-org/gitlab@83b2ef2c2d7743cddd6f5f8b302ebe5368f56471) ([merge request](gitlab-org/gitlab!129142))
- [Add border between milestone and iteration](gitlab-org/gitlab@7e8b14a14e7ea00ef5e4d2693cf82853b83021c5) ([merge request](gitlab-org/gitlab!129140))
- [Cleanup new GlCard implementations](gitlab-org/gitlab@aff388afbaa12176590467f948fa778e9ba8aaca) ([merge request](gitlab-org/gitlab!129076))
- [Admin Area: Appearance settings change to use one column](gitlab-org/gitlab@b3fc0fee6fab364b5f307407d41fe76e7991aabc) ([merge request](gitlab-org/gitlab!129068))
- [Group compliance framework settings: Use GlCard](gitlab-org/gitlab@7cc1554459d584232869efb5a8164c2fc7beac34) ([merge request](gitlab-org/gitlab!128911))
- [Move group container registry from operations to deploy](gitlab-org/gitlab@ad443a5873dbc0c91d3e16a49ba62cfa68465a2c) ([merge request](gitlab-org/gitlab!129091))
- [Refactor sastReportsInInlineDiff handling](gitlab-org/gitlab@1fae65b2b192a7af2bdbc336064eecfab8b58395) ([merge request](gitlab-org/gitlab!128602)) **GitLab Enterprise Edition**
- [Enable v2 package metadata license sync](gitlab-org/gitlab@c15dd2922b95c84563628430177b568af4ab5d3d) ([merge request](gitlab-org/gitlab!128638)) **GitLab Enterprise Edition**
- [Advanced project settings: Use GlCard](gitlab-org/gitlab@2c802bb67acd636ad0a653d24922587b630ebba7) ([merge request](gitlab-org/gitlab!129083))
- [Update broadcast message target roles UI](gitlab-org/gitlab@0678369213200facba8f90b88f9a8717c1c0b57a) ([merge request](gitlab-org/gitlab!127905))
- [Ensure_onboarding experiment: Successful cleanup](gitlab-org/gitlab@37a764e79be92d91dac59dc6db6e0a1225b2d0a1) ([merge request](gitlab-org/gitlab!129074)) **GitLab Enterprise Edition**
- [Billing settings: use GlCard](gitlab-org/gitlab@bbaaaa4cf8dff240b84881883581b4292120597a) ([merge request](gitlab-org/gitlab!129072)) **GitLab Enterprise Edition**
- [Group CI/CD settings: remove container limited class](gitlab-org/gitlab@ad314613a5c8a44d2ac530cdc54db04e820a4aa7) ([merge request](gitlab-org/gitlab!129067))
- [Sort referenced issues numerically](gitlab-org/gitlab@f62fabe73a34e04de2a7f4716636488065c42693) ([merge request](gitlab-org/gitlab!128661))
- [Set max width on user preference inputs](gitlab-org/gitlab@49fee93307155e86f7d98c0b510b9c028d9b8056) ([merge request](gitlab-org/gitlab!127909))
- [Enable the content block retry to be enabled contextually](gitlab-org/gitlab@bb5f0ac776158bc1f5524957b4b27ebe79b1f2e5) ([merge request](gitlab-org/gitlab!124348)) **GitLab Enterprise Edition**
- [Add copy reference shortcut docs](gitlab-org/gitlab@b844a4472d0e9ca154436fd410053e9dab9f316d) ([merge request](gitlab-org/gitlab!129013))
- [Migrate health status dropdown to listbox](gitlab-org/gitlab@e91f27070b30c5b4596dfc13b86d2a45a70e17ef) by @ShaneMaglangit ([merge request](gitlab-org/gitlab!128241)) **GitLab Enterprise Edition**
- [Add audit event for changed product description](gitlab-org/gitlab@151201d6ff1204d15dad4b61cbdcd980e376a0c5) ([merge request](gitlab-org/gitlab!128978)) **GitLab Enterprise Edition**
- [Add spec for parsing inputs as boolean](gitlab-org/gitlab@47999ae5fcfd28e5f879def1f32808a308e1af69) ([merge request](gitlab-org/gitlab!128677)) **GitLab Enterprise Edition**
- [Finish moving BroadcastMessage under System module](gitlab-org/gitlab@dacc34f4aa1f6be2ad2d9aff4a669e9a56158033) ([merge request](gitlab-org/gitlab!127147))
- [Fix the typo in migration by no-oping migration & adding new one](gitlab-org/gitlab@8901739c0f16631e6b0d84c844244e3