/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.antlr.semantic.types.special;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.opensearch.sql.legacy.antlr.semantic.types.Type;
import org.opensearch.sql.legacy.utils.StringUtils;

public class Generic
implements Type {
    public static final Function<Type[], Type> T = types -> Generic.findSameGenericType(Name.T, types);
    private final Name name;
    private final Type binding;

    public Generic(Name name, Type type) {
        this.name = name;
        this.binding = type;
    }

    public static Type T(Type type) {
        return new Generic(Name.T, type);
    }

    public static Function<Type[], Type> specialize(Function<Type[], Type> func, Type[] actualArgTypes) {
        if (func != T) {
            return func;
        }
        Type genericType = func.apply(actualArgTypes);
        int genericTypeIndex = Arrays.asList(actualArgTypes).indexOf(genericType);
        return actualTypes -> actualTypes[genericTypeIndex];
    }

    private static Type findSameGenericType(Name name, Type[] types) {
        return Arrays.stream(types).filter(type -> type instanceof Generic).filter(type -> ((Generic)type).name == name).findFirst().orElseThrow(() -> new IllegalStateException(StringUtils.format("Type definition is wrong. Could not unbind generic type [%s] in type list %s.", new Object[]{name, types})));
    }

    @Override
    public String getName() {
        return this.name.name();
    }

    @Override
    public boolean isCompatible(Type other) {
        return this.binding.isCompatible(other);
    }

    @Override
    public Type construct(List<Type> others) {
        return this.binding.construct(others);
    }

    @Override
    public String usage() {
        return this.binding.usage() + " " + String.valueOf((Object)this.name);
    }

    private static enum Name {
        T;

    }
}

