/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugins;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockFactory;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.env.ShardLock;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.shard.ShardPath;
import org.opensearch.index.store.IndexStoreListener;
import org.opensearch.index.store.Store;
import org.opensearch.index.store.remote.filecache.FileCache;
import org.opensearch.indices.recovery.RecoveryState;
import org.opensearch.threadpool.ThreadPool;

@PublicApi(since="1.0.0")
public interface IndexStorePlugin {
    default public Map<String, DirectoryFactory> getDirectoryFactories() {
        return Collections.emptyMap();
    }

    default public Map<String, CompositeDirectoryFactory> getCompositeDirectoryFactories() {
        return Collections.emptyMap();
    }

    default public Map<String, RecoveryStateFactory> getRecoveryStateFactories() {
        return Collections.emptyMap();
    }

    default public Optional<IndexStoreListener> getIndexStoreListener() {
        return Optional.empty();
    }

    @ExperimentalApi
    default public Map<String, StoreFactory> getStoreFactories() {
        return Collections.emptyMap();
    }

    @ExperimentalApi
    public static interface StoreFactory {
        public Store newStore(ShardId var1, IndexSettings var2, Directory var3, ShardLock var4, Store.OnClose var5, ShardPath var6) throws IOException;

        public Store newStore(ShardId var1, IndexSettings var2, Directory var3, ShardLock var4, Store.OnClose var5, ShardPath var6, DirectoryFactory var7) throws IOException;
    }

    @FunctionalInterface
    @PublicApi(since="1.0.0")
    public static interface RecoveryStateFactory {
        public RecoveryState newRecoveryState(ShardRouting var1, DiscoveryNode var2, @Nullable DiscoveryNode var3);
    }

    @FunctionalInterface
    @ExperimentalApi
    public static interface CompositeDirectoryFactory {
        public Directory newDirectory(IndexSettings var1, ShardPath var2, DirectoryFactory var3, Directory var4, FileCache var5, ThreadPool var6) throws IOException;
    }

    @PublicApi(since="1.0.0")
    public static interface DirectoryFactory {
        public Directory newDirectory(IndexSettings var1, ShardPath var2) throws IOException;

        public Directory newFSDirectory(Path var1, LockFactory var2, IndexSettings var3) throws IOException;
    }
}

