/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.internals;

import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalLong;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.BatchReader;
import org.apache.kafka.raft.internals.CloseListener;
import org.apache.kafka.raft.internals.RecordsIterator;
import org.apache.kafka.server.common.serialization.RecordSerde;

public final class RecordsBatchReader<T>
implements BatchReader<T> {
    private final long baseOffset;
    private final RecordsIterator<T> iterator;
    private final CloseListener<BatchReader<T>> closeListener;
    private long lastReturnedOffset;
    private Optional<Batch<T>> nextBatch = Optional.empty();
    private boolean isClosed = false;

    private RecordsBatchReader(long baseOffset, RecordsIterator<T> iterator, CloseListener<BatchReader<T>> closeListener) {
        this.baseOffset = baseOffset;
        this.iterator = iterator;
        this.closeListener = closeListener;
        this.lastReturnedOffset = baseOffset;
    }

    @Override
    public boolean hasNext() {
        this.ensureOpen();
        if (this.nextBatch.isEmpty()) {
            this.nextBatch = this.nextBatch();
        }
        return this.nextBatch.isPresent();
    }

    @Override
    public Batch<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Records batch reader doesn't have any more elements");
        }
        Batch<T> batch = this.nextBatch.get();
        this.nextBatch = Optional.empty();
        this.lastReturnedOffset = batch.lastOffset();
        return batch;
    }

    @Override
    public long baseOffset() {
        return this.baseOffset;
    }

    @Override
    public OptionalLong lastOffset() {
        if (this.isClosed) {
            return OptionalLong.of(this.lastReturnedOffset);
        }
        return OptionalLong.empty();
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            this.iterator.close();
            this.closeListener.onClose(this);
        }
    }

    public static <T> RecordsBatchReader<T> of(long baseOffset, Records records, RecordSerde<T> serde, BufferSupplier bufferSupplier, int maxBatchSize, CloseListener<BatchReader<T>> closeListener, boolean doCrcValidation, LogContext logContext) {
        return new RecordsBatchReader<T>(baseOffset, new RecordsIterator<T>(records, serde, bufferSupplier, maxBatchSize, doCrcValidation, logContext), closeListener);
    }

    private void ensureOpen() {
        if (this.isClosed) {
            throw new IllegalStateException("Records batch reader was closed");
        }
    }

    private Optional<Batch<T>> nextBatch() {
        if (this.iterator.hasNext()) {
            return Optional.of(this.iterator.next());
        }
        return Optional.empty();
    }
}

