/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern.consumer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.FencedMemberEpochException;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.coordinator.common.runtime.CoordinatorMetadataImage;
import org.apache.kafka.coordinator.group.modern.Assignment;
import org.apache.kafka.coordinator.group.modern.MemberState;
import org.apache.kafka.coordinator.group.modern.TopicIds;
import org.apache.kafka.coordinator.group.modern.UnionSet;
import org.apache.kafka.coordinator.group.modern.consumer.ConsumerGroupMember;
import org.apache.kafka.coordinator.group.modern.consumer.ResolvedRegularExpression;

public class CurrentAssignmentBuilder {
    private final ConsumerGroupMember member;
    private CoordinatorMetadataImage metadataImage = CoordinatorMetadataImage.EMPTY;
    private int targetAssignmentEpoch;
    private Assignment targetAssignment;
    private boolean hasSubscriptionChanged;
    private Map<String, ResolvedRegularExpression> resolvedRegularExpressions = Map.of();
    private BiFunction<Uuid, Integer, Integer> currentPartitionEpoch;
    private List<ConsumerGroupHeartbeatRequestData.TopicPartitions> ownedTopicPartitions;

    public CurrentAssignmentBuilder(ConsumerGroupMember member) {
        this.member = Objects.requireNonNull(member);
    }

    public CurrentAssignmentBuilder withMetadataImage(CoordinatorMetadataImage metadataImage) {
        this.metadataImage = metadataImage;
        return this;
    }

    public CurrentAssignmentBuilder withTargetAssignment(int targetAssignmentEpoch, Assignment targetAssignment) {
        this.targetAssignmentEpoch = targetAssignmentEpoch;
        this.targetAssignment = Objects.requireNonNull(targetAssignment);
        return this;
    }

    public CurrentAssignmentBuilder withHasSubscriptionChanged(boolean hasSubscriptionChanged) {
        this.hasSubscriptionChanged = hasSubscriptionChanged;
        return this;
    }

    public CurrentAssignmentBuilder withResolvedRegularExpressions(Map<String, ResolvedRegularExpression> resolvedRegularExpressions) {
        this.resolvedRegularExpressions = resolvedRegularExpressions;
        return this;
    }

    public CurrentAssignmentBuilder withCurrentPartitionEpoch(BiFunction<Uuid, Integer, Integer> currentPartitionEpoch) {
        this.currentPartitionEpoch = Objects.requireNonNull(currentPartitionEpoch);
        return this;
    }

    public CurrentAssignmentBuilder withOwnedTopicPartitions(List<ConsumerGroupHeartbeatRequestData.TopicPartitions> ownedTopicPartitions) {
        this.ownedTopicPartitions = ownedTopicPartitions;
        return this;
    }

    public ConsumerGroupMember build() {
        switch (this.member.state()) {
            case STABLE: {
                if (this.member.memberEpoch() != this.targetAssignmentEpoch) {
                    return this.computeNextAssignment(this.member.memberEpoch(), this.member.assignedPartitions());
                }
                if (this.hasSubscriptionChanged) {
                    return this.updateCurrentAssignment(this.member.assignedPartitions());
                }
                return this.member;
            }
            case UNREVOKED_PARTITIONS: {
                if (this.ownsRevokedPartitions(this.member.partitionsPendingRevocation())) {
                    if (this.hasSubscriptionChanged) {
                        return this.updateCurrentAssignment(this.member.assignedPartitions());
                    }
                    return this.member;
                }
                return this.computeNextAssignment(this.member.memberEpoch(), this.member.assignedPartitions());
            }
            case UNRELEASED_PARTITIONS: {
                return this.computeNextAssignment(this.member.memberEpoch(), this.member.assignedPartitions());
            }
            case UNKNOWN: {
                if (this.ownedTopicPartitions == null || !this.ownedTopicPartitions.isEmpty()) {
                    throw new FencedMemberEpochException("The consumer group member is in a unknown state. The member must abandon all its partitions and rejoin.");
                }
                return this.computeNextAssignment(this.targetAssignmentEpoch, this.member.assignedPartitions());
            }
        }
        return this.member;
    }

    private boolean ownsRevokedPartitions(Map<Uuid, Set<Integer>> assignment) {
        if (this.ownedTopicPartitions == null) {
            return true;
        }
        for (ConsumerGroupHeartbeatRequestData.TopicPartitions topicPartitions : this.ownedTopicPartitions) {
            Set partitionsPendingRevocation = assignment.getOrDefault(topicPartitions.topicId(), Set.of());
            for (Integer partitionId : topicPartitions.partitions()) {
                if (!partitionsPendingRevocation.contains(partitionId)) continue;
                return true;
            }
        }
        return false;
    }

    private ConsumerGroupMember updateCurrentAssignment(Map<Uuid, Set<Integer>> memberAssignedPartitions) {
        Map<Uuid, Set<Integer>> newPartitionsPendingRevocation;
        Map<Object, Set<Integer>> newAssignedPartitions;
        Set<Uuid> subscribedTopicIds = this.subscribedTopicIds();
        if (subscribedTopicIds.isEmpty() && this.member.partitionsPendingRevocation().isEmpty()) {
            newAssignedPartitions = Map.of();
            newPartitionsPendingRevocation = memberAssignedPartitions;
        } else {
            newAssignedPartitions = memberAssignedPartitions;
            newPartitionsPendingRevocation = new HashMap<Uuid, Set<Integer>>(this.member.partitionsPendingRevocation());
            for (Map.Entry<Uuid, Set<Integer>> entry : memberAssignedPartitions.entrySet()) {
                if (subscribedTopicIds.contains(entry.getKey())) continue;
                if (newAssignedPartitions == memberAssignedPartitions) {
                    newAssignedPartitions = new HashMap<Uuid, Set<Integer>>(memberAssignedPartitions);
                    newPartitionsPendingRevocation = new HashMap<Uuid, Set<Integer>>(this.member.partitionsPendingRevocation());
                }
                newAssignedPartitions.remove(entry.getKey());
                newPartitionsPendingRevocation.merge(entry.getKey(), entry.getValue(), (existing, additional) -> {
                    existing = new HashSet(existing);
                    existing.addAll(additional);
                    return existing;
                });
            }
        }
        if (newAssignedPartitions == memberAssignedPartitions) {
            return this.member;
        }
        if (!newPartitionsPendingRevocation.isEmpty() && this.ownsRevokedPartitions(newPartitionsPendingRevocation)) {
            return new ConsumerGroupMember.Builder(this.member).setState(MemberState.UNREVOKED_PARTITIONS).setAssignedPartitions(newAssignedPartitions).setPartitionsPendingRevocation(newPartitionsPendingRevocation).build();
        }
        return new ConsumerGroupMember.Builder(this.member).setAssignedPartitions(newAssignedPartitions).build();
    }

    private ConsumerGroupMember computeNextAssignment(int memberEpoch, Map<Uuid, Set<Integer>> memberAssignedPartitions) {
        Set<Uuid> subscribedTopicIds = this.subscribedTopicIds();
        boolean hasUnreleasedPartitions = false;
        HashMap<Uuid, Set<Integer>> newAssignedPartitions = new HashMap<Uuid, Set<Integer>>();
        HashMap<Uuid, Set<Integer>> newPartitionsPendingRevocation = new HashMap<Uuid, Set<Integer>>();
        HashMap<Uuid, Set> newPartitionsPendingAssignment = new HashMap<Uuid, Set>();
        HashSet<Uuid> allTopicIds = new HashSet<Uuid>(this.targetAssignment.partitions().keySet());
        allTopicIds.addAll(memberAssignedPartitions.keySet());
        for (Uuid topicId2 : allTopicIds) {
            Set target = this.targetAssignment.partitions().getOrDefault(topicId2, Set.of());
            Set currentAssignedPartitions = memberAssignedPartitions.getOrDefault(topicId2, Set.of());
            if (!subscribedTopicIds.contains(topicId2)) {
                target = Set.of();
            }
            HashSet assignedPartitions = new HashSet(currentAssignedPartitions);
            assignedPartitions.retainAll(target);
            HashSet partitionsPendingRevocation = new HashSet(currentAssignedPartitions);
            partitionsPendingRevocation.removeAll(assignedPartitions);
            HashSet<Integer> partitionsPendingAssignment = new HashSet<Integer>(target);
            partitionsPendingAssignment.removeAll(assignedPartitions);
            boolean bl = hasUnreleasedPartitions = partitionsPendingAssignment.removeIf(partitionId -> this.currentPartitionEpoch.apply(topicId2, (Integer)partitionId) != -1 && !this.member.partitionsPendingRevocation().getOrDefault(topicId2, Set.of()).contains(partitionId)) || hasUnreleasedPartitions;
            if (!assignedPartitions.isEmpty()) {
                newAssignedPartitions.put(topicId2, assignedPartitions);
            }
            if (!partitionsPendingRevocation.isEmpty()) {
                newPartitionsPendingRevocation.put(topicId2, partitionsPendingRevocation);
            }
            if (partitionsPendingAssignment.isEmpty()) continue;
            newPartitionsPendingAssignment.put(topicId2, partitionsPendingAssignment);
        }
        if (!newPartitionsPendingRevocation.isEmpty() && this.ownsRevokedPartitions(newPartitionsPendingRevocation)) {
            return new ConsumerGroupMember.Builder(this.member).setState(MemberState.UNREVOKED_PARTITIONS).updateMemberEpoch(memberEpoch).setAssignedPartitions(newAssignedPartitions).setPartitionsPendingRevocation(newPartitionsPendingRevocation).build();
        }
        if (!newPartitionsPendingAssignment.isEmpty()) {
            newPartitionsPendingAssignment.forEach((topicId, partitions) -> newAssignedPartitions.computeIfAbsent((Uuid)topicId, __ -> new HashSet()).addAll(partitions));
            MemberState newState = hasUnreleasedPartitions ? MemberState.UNRELEASED_PARTITIONS : MemberState.STABLE;
            return new ConsumerGroupMember.Builder(this.member).setState(newState).updateMemberEpoch(this.targetAssignmentEpoch).setAssignedPartitions(newAssignedPartitions).setPartitionsPendingRevocation(Map.of()).build();
        }
        if (hasUnreleasedPartitions) {
            return new ConsumerGroupMember.Builder(this.member).setState(MemberState.UNRELEASED_PARTITIONS).updateMemberEpoch(this.targetAssignmentEpoch).setAssignedPartitions(newAssignedPartitions).setPartitionsPendingRevocation(Map.of()).build();
        }
        return new ConsumerGroupMember.Builder(this.member).setState(MemberState.STABLE).updateMemberEpoch(this.targetAssignmentEpoch).setAssignedPartitions(newAssignedPartitions).setPartitionsPendingRevocation(Map.of()).build();
    }

    private Set<Uuid> subscribedTopicIds() {
        ResolvedRegularExpression resolvedRegularExpression;
        Set<String> subscriptions = this.member.subscribedTopicNames();
        String subscribedTopicRegex = this.member.subscribedTopicRegex();
        if (subscribedTopicRegex != null && !subscribedTopicRegex.isEmpty() && (resolvedRegularExpression = this.resolvedRegularExpressions.get(subscribedTopicRegex)) != null) {
            if (subscriptions.isEmpty()) {
                subscriptions = resolvedRegularExpression.topics();
            } else if (!resolvedRegularExpression.topics().isEmpty()) {
                subscriptions = new UnionSet<String>(subscriptions, resolvedRegularExpression.topics());
            }
        }
        return new TopicIds(subscriptions, this.metadataImage);
    }
}

