﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sagemaker/SageMaker_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace SageMaker {
namespace Model {
class CreateNotebookInstanceResult {
 public:
  AWS_SAGEMAKER_API CreateNotebookInstanceResult() = default;
  AWS_SAGEMAKER_API CreateNotebookInstanceResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SAGEMAKER_API CreateNotebookInstanceResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the notebook instance. </p>
   */
  inline const Aws::String& GetNotebookInstanceArn() const { return m_notebookInstanceArn; }
  template <typename NotebookInstanceArnT = Aws::String>
  void SetNotebookInstanceArn(NotebookInstanceArnT&& value) {
    m_notebookInstanceArnHasBeenSet = true;
    m_notebookInstanceArn = std::forward<NotebookInstanceArnT>(value);
  }
  template <typename NotebookInstanceArnT = Aws::String>
  CreateNotebookInstanceResult& WithNotebookInstanceArn(NotebookInstanceArnT&& value) {
    SetNotebookInstanceArn(std::forward<NotebookInstanceArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateNotebookInstanceResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_notebookInstanceArn;
  bool m_notebookInstanceArnHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SageMaker
}  // namespace Aws
