# Common maintenance tasks

## Manually release a new RubyGem version

* an upstream [security-report-schemas](https://gitlab.com/gitlab-org/security-products/security-report-schemas) pipeline failed to trigger the release pipeline
* you want to add, remove or deprecate support for report schema versions
* you need to release a new version of the gem without altering version ranges,
  because for example:
  * an existing gem release has a bug, and the bugfix release needs to cover the
  same version range.
  * there were breaking changes to the gem's public API that must be released
  for the currently supported version range.

### Solution

1. Open and merge an MR targeting the default branch which may:
    * change the [`supported_versions`](../supported_versions) file to set the
      report schema version range that the release should include.
    * change the `Gitlab::SecurityReportSchemas::Version::GEM_VERSION` constant
      to set the MAJOR.MINOR.PATCH version components of the resulting release.
2. Run a new pipeline for the default branch and set the `MANUAL_RELEASE` CI
   variable.
3. Trigger the manual `manual-release` job in the resulting pipeline.

## Jobs fail to self-push due to an expired service account access token

To self-push commits, we use an access token of a service account which
belongs to the top-level `gitlab-org` group. This token is kept in this project's
`GITLAB_PUSH_ACCESS_TOKEN` CI variable and the token expires yearly.

The service account access token [should get automatically rotated](https://gitlab.com/gitlab-com/team-member-epics/access-requests/-/issues/29595#note_2433504597)
and the CI variable should get updated with the updated token.

Should auto-rotation fail or the access token become invalid for another
reason, the `add-schema-version` and `manual-release` jobs fail:

```
$ git push origin $CI_COMMIT_REF_NAME
remote: HTTP Basic: Access denied. If a password was provided for Git authentication, the password was incorrect or you're required to use a token instead of a password. If a token was provided, it was either incorrect, expired, or improperly scoped.
```

### Solution: Manually rotate the service account access token

Owners of the top-level `gitlab-org` group can manually
[rotate the service account access token](https://docs.gitlab.com/user/profile/service_accounts/#rotate-the-personal-access-token)
and update this project's `GITLAB_PUSH_ACCESS_TOKEN` CI variable with the
renewed token.

### Workaround: Use a temporary personal access token

To release urgently without Owner access to `gitlab-org`:

1. update the default branch protection so that you can push
2. create a short-lived personal access token and rerun the failed `manual-release`
   job, setting the CI variable `GITLAB_PUSH_ACCESS_TOKEN` to your short-lived token
3. after the job succeeded, revoke your short-lived token and restore the default
   branch protection so that you can no longer push

## Find the commit SHA for a RubyGem version

Before a rubygems.org release is created, a git tag referencing the full
v-prefixed release version is pushed, for example `v0.1.0.min15.0.0.max15.0.1`.
